; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV64

define void @bitreverse_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v8i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX2-RV32-NEXT:    vsll.vi v25, v25, 8
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    lui a1, 15
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    lui a1, 13
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 11
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v8i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX2-RV64-NEXT:    vsll.vi v25, v25, 8
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    lui a1, 15
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    lui a1, 13
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 11
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v25, v25, 8
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 1
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    lui a1, 15
; LMULMAX1-RV32-NEXT:    addi a1, a1, 240
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 3
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    lui a1, 13
; LMULMAX1-RV32-NEXT:    addi a1, a1, -820
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    lui a1, 11
; LMULMAX1-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v25, v25, 8
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 1
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    lui a1, 15
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 240
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 3
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    lui a1, 13
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -820
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    lui a1, 11
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)

define void @bitreverse_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v4i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX2-RV32-NEXT:    vsll.vi v27, v25, 8
; LMULMAX2-RV32-NEXT:    lui a1, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v27, v27, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v25, v25, 24
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    lui a1, 986895
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    lui a1, 838861
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 699051
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v4i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX2-RV64-NEXT:    vsll.vi v27, v25, 8
; LMULMAX2-RV64-NEXT:    lui a1, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v27, v27, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v25, v25, 24
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    lui a1, 241
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    lui a1, 205
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 171
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX1-RV32-NEXT:    lui a1, 16
; LMULMAX1-RV32-NEXT:    addi a1, a1, -256
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v25, 8
; LMULMAX1-RV32-NEXT:    lui a1, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v25, v25, 24
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    lui a1, 986895
; LMULMAX1-RV32-NEXT:    addi a1, a1, 240
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    lui a1, 838861
; LMULMAX1-RV32-NEXT:    addi a1, a1, -820
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    lui a1, 699051
; LMULMAX1-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v25, 8
; LMULMAX1-RV64-NEXT:    lui a1, 16
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v25, 8
; LMULMAX1-RV64-NEXT:    lui a1, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v25, v25, 24
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 61681
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    lui a1, 241
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 240
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 209715
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    lui a1, 205
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -820
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 349525
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    lui a1, 171
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)

define void @bitreverse_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v2i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi a6, zero, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v25, a6
; LMULMAX2-RV32-NEXT:    addi a2, zero, 40
; LMULMAX2-RV32-NEXT:    vsrl.vx v27, v25, a2
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    vand.vx v27, v27, a3
; LMULMAX2-RV32-NEXT:    vor.vv v26, v27, v26
; LMULMAX2-RV32-NEXT:    addi a4, zero, 5
; LMULMAX2-RV32-NEXT:    vsetivli a5, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a4
; LMULMAX2-RV32-NEXT:    vsetivli a4, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v27, 0
; LMULMAX2-RV32-NEXT:    lui a4, 1044480
; LMULMAX2-RV32-NEXT:    vmerge.vxm v27, v27, a4, v0
; LMULMAX2-RV32-NEXT:    vsetivli a4, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v25, 8
; LMULMAX2-RV32-NEXT:    vand.vv v27, v28, v27
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v25, 24
; LMULMAX2-RV32-NEXT:    lui a4, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v28, v28, a4
; LMULMAX2-RV32-NEXT:    vor.vv v27, v27, v28
; LMULMAX2-RV32-NEXT:    vor.vv v26, v27, v26
; LMULMAX2-RV32-NEXT:    addi a5, zero, 255
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v27, a5
; LMULMAX2-RV32-NEXT:    vmerge.vim v27, v27, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v25, 8
; LMULMAX2-RV32-NEXT:    vand.vv v27, v28, v27
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a3
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vi v29, v25, 24
; LMULMAX2-RV32-NEXT:    vand.vv v28, v29, v28
; LMULMAX2-RV32-NEXT:    vor.vv v27, v28, v27
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a4
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vx v29, v25, a2
; LMULMAX2-RV32-NEXT:    vand.vv v28, v29, v28
; LMULMAX2-RV32-NEXT:    vsll.vx v25, v25, a6
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    lui a1, 986895
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    lui a1, 838861
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    lui a1, 699051
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX2-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v2i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi a1, zero, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    addi a2, zero, 40
; LMULMAX2-RV64-NEXT:    vsrl.vx v27, v25, a2
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    vand.vx v27, v27, a3
; LMULMAX2-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX2-RV64-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX2-RV64-NEXT:    lui a3, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v27, v27, a3
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v25, 8
; LMULMAX2-RV64-NEXT:    addi a3, zero, 255
; LMULMAX2-RV64-NEXT:    slli a4, a3, 24
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a4
; LMULMAX2-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX2-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX2-RV64-NEXT:    vsll.vi v27, v25, 8
; LMULMAX2-RV64-NEXT:    slli a4, a3, 32
; LMULMAX2-RV64-NEXT:    vand.vx v27, v27, a4
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v25, 24
; LMULMAX2-RV64-NEXT:    slli a4, a3, 40
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a4
; LMULMAX2-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX2-RV64-NEXT:    vsll.vx v28, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vx v25, v25, a2
; LMULMAX2-RV64-NEXT:    slli a1, a3, 48
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vor.vv v25, v28, v25
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 3855
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    lui a1, 1044721
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 13107
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    lui a1, 1035469
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    lui a1, 1026731
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX2-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a6, zero, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v25, a6
; LMULMAX1-RV32-NEXT:    addi a2, zero, 40
; LMULMAX1-RV32-NEXT:    vsrl.vx v27, v25, a2
; LMULMAX1-RV32-NEXT:    lui a3, 16
; LMULMAX1-RV32-NEXT:    addi a3, a3, -256
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a3
; LMULMAX1-RV32-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    addi a4, zero, 5
; LMULMAX1-RV32-NEXT:    vsetivli a5, 1, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a4
; LMULMAX1-RV32-NEXT:    vsetivli a4, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.i v27, 0
; LMULMAX1-RV32-NEXT:    lui a4, 1044480
; LMULMAX1-RV32-NEXT:    vmerge.vxm v27, v27, a4, v0
; LMULMAX1-RV32-NEXT:    vsetivli a4, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v25, 8
; LMULMAX1-RV32-NEXT:    vand.vv v27, v28, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v25, 24
; LMULMAX1-RV32-NEXT:    lui a4, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v28, v28, a4
; LMULMAX1-RV32-NEXT:    vor.vv v27, v27, v28
; LMULMAX1-RV32-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV32-NEXT:    addi a5, zero, 255
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a5
; LMULMAX1-RV32-NEXT:    vmerge.vim v27, v27, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vi v28, v25, 8
; LMULMAX1-RV32-NEXT:    vand.vv v27, v28, v27
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v28, a3
; LMULMAX1-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vi v29, v25, 24
; LMULMAX1-RV32-NEXT:    vand.vv v28, v29, v28
; LMULMAX1-RV32-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v28, a4
; LMULMAX1-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vx v29, v25, a2
; LMULMAX1-RV32-NEXT:    vand.vv v28, v29, v28
; LMULMAX1-RV32-NEXT:    vsll.vx v25, v25, a6
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    lui a1, 986895
; LMULMAX1-RV32-NEXT:    addi a1, a1, 240
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    lui a1, 838861
; LMULMAX1-RV32-NEXT:    addi a1, a1, -820
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v26
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    lui a1, 699051
; LMULMAX1-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a1
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a1, zero, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    addi a2, zero, 40
; LMULMAX1-RV64-NEXT:    vsrl.vx v27, v25, a2
; LMULMAX1-RV64-NEXT:    lui a3, 16
; LMULMAX1-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a3
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 24
; LMULMAX1-RV64-NEXT:    lui a3, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v28, v25, 8
; LMULMAX1-RV64-NEXT:    addi a3, zero, 255
; LMULMAX1-RV64-NEXT:    slli a4, a3, 24
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a4
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v25, 8
; LMULMAX1-RV64-NEXT:    slli a4, a3, 32
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v28, v25, 24
; LMULMAX1-RV64-NEXT:    slli a4, a3, 40
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a4
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vsll.vx v28, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vx v25, v25, a2
; LMULMAX1-RV64-NEXT:    slli a1, a3, 48
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v28, v25
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 3855
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    lui a1, 1044721
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -241
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 240
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 13107
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    lui a1, 1035469
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -820
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    lui a1, 21845
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v26, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    lui a1, 1026731
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)

define void @bitreverse_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 8
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 8
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV32-NEXT:    lui a1, 15
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV32-NEXT:    lui a1, 13
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV32-NEXT:    lui a1, 11
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 8
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 8
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV64-NEXT:    lui a1, 15
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV64-NEXT:    lui a1, 13
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV64-NEXT:    lui a1, 11
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a6)
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v25, v25, 8
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a2, 1
; LMULMAX1-RV32-NEXT:    addi a7, a2, -241
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a7
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV32-NEXT:    lui a3, 15
; LMULMAX1-RV32-NEXT:    addi a3, a3, 240
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a4, 3
; LMULMAX1-RV32-NEXT:    addi a4, a4, 819
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV32-NEXT:    lui a5, 13
; LMULMAX1-RV32-NEXT:    addi a5, a5, -820
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV32-NEXT:    lui a2, 11
; LMULMAX1-RV32-NEXT:    addi a2, a2, -1366
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 8
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a7
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a6)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a6)
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v25, v25, 8
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a2, 1
; LMULMAX1-RV64-NEXT:    addiw a7, a2, -241
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a7
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    lui a3, 15
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 240
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a4, 3
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    lui a5, 13
; LMULMAX1-RV64-NEXT:    addiw a5, a5, -820
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    lui a2, 11
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 8
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a7
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a6)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %a)
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)

define void @bitreverse_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v30, v26, 24
; LMULMAX2-RV32-NEXT:    vor.vv v28, v28, v30
; LMULMAX2-RV32-NEXT:    vsll.vi v30, v26, 8
; LMULMAX2-RV32-NEXT:    lui a1, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v30, v30, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v26, v26, 24
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV32-NEXT:    lui a1, 986895
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV32-NEXT:    lui a1, 838861
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV32-NEXT:    lui a1, 699051
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    vand.vx v28, v28, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v30, v26, 24
; LMULMAX2-RV64-NEXT:    vor.vv v28, v28, v30
; LMULMAX2-RV64-NEXT:    vsll.vi v30, v26, 8
; LMULMAX2-RV64-NEXT:    lui a1, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v30, v30, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v26, v26, 24
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV64-NEXT:    lui a1, 241
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV64-NEXT:    lui a1, 205
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV64-NEXT:    lui a1, 171
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a7, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a7)
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 8
; LMULMAX1-RV32-NEXT:    lui a2, 16
; LMULMAX1-RV32-NEXT:    addi t0, a2, -256
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, t0
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v25, 24
; LMULMAX1-RV32-NEXT:    vor.vv v27, v27, v28
; LMULMAX1-RV32-NEXT:    vsll.vi v28, v25, 8
; LMULMAX1-RV32-NEXT:    lui a6, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV32-NEXT:    vsll.vi v25, v25, 24
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi t1, a4, -241
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, t1
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV32-NEXT:    lui a5, 986895
; LMULMAX1-RV32-NEXT:    addi a5, a5, 240
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a3, 209715
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV32-NEXT:    lui a1, 838861
; LMULMAX1-RV32-NEXT:    addi a1, a1, -820
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v27, v25, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV32-NEXT:    lui a4, 699051
; LMULMAX1-RV32-NEXT:    addi a4, a4, -1366
; LMULMAX1-RV32-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v26, 8
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, t0
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v26, 24
; LMULMAX1-RV32-NEXT:    vor.vv v27, v27, v28
; LMULMAX1-RV32-NEXT:    vsll.vi v28, v26, 8
; LMULMAX1-RV32-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 24
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, t1
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vx v27, v26, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV32-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV32-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a7)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a7, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a7)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v25, 8
; LMULMAX1-RV64-NEXT:    lui a2, 16
; LMULMAX1-RV64-NEXT:    addiw t0, a2, -256
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, t0
; LMULMAX1-RV64-NEXT:    vsrl.vi v28, v25, 24
; LMULMAX1-RV64-NEXT:    vor.vv v27, v27, v28
; LMULMAX1-RV64-NEXT:    vsll.vi v28, v25, 8
; LMULMAX1-RV64-NEXT:    lui a6, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV64-NEXT:    vsll.vi v25, v25, 24
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a4, 61681
; LMULMAX1-RV64-NEXT:    addiw t1, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, t1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    lui a5, 241
; LMULMAX1-RV64-NEXT:    addiw a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 240
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a3, 209715
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    lui a1, 205
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -820
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    lui a2, 349525
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    lui a4, 171
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -1365
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a4
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vsrl.vi v27, v26, 8
; LMULMAX1-RV64-NEXT:    vand.vx v27, v27, t0
; LMULMAX1-RV64-NEXT:    vsrl.vi v28, v26, 24
; LMULMAX1-RV64-NEXT:    vor.vv v27, v27, v28
; LMULMAX1-RV64-NEXT:    vsll.vi v28, v26, 8
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV64-NEXT:    vsll.vi v26, v26, 24
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, t1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a4
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a7)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %a)
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)

define void @bitreverse_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi a6, zero, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v28, v26, a6
; LMULMAX2-RV32-NEXT:    addi a2, zero, 40
; LMULMAX2-RV32-NEXT:    vsrl.vx v30, v26, a2
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    vand.vx v30, v30, a3
; LMULMAX2-RV32-NEXT:    vor.vv v28, v30, v28
; LMULMAX2-RV32-NEXT:    addi a4, zero, 85
; LMULMAX2-RV32-NEXT:    vsetivli a5, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a4
; LMULMAX2-RV32-NEXT:    vsetivli a4, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV32-NEXT:    lui a4, 1044480
; LMULMAX2-RV32-NEXT:    vmerge.vxm v30, v30, a4, v0
; LMULMAX2-RV32-NEXT:    vsetivli a4, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v26, 8
; LMULMAX2-RV32-NEXT:    vand.vv v30, v8, v30
; LMULMAX2-RV32-NEXT:    vsrl.vi v8, v26, 24
; LMULMAX2-RV32-NEXT:    lui a4, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX2-RV32-NEXT:    vor.vv v30, v30, v8
; LMULMAX2-RV32-NEXT:    vor.vv v28, v30, v28
; LMULMAX2-RV32-NEXT:    addi a5, zero, 255
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a5
; LMULMAX2-RV32-NEXT:    vmerge.vim v30, v30, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v26, 8
; LMULMAX2-RV32-NEXT:    vand.vv v30, v8, v30
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v8, a3
; LMULMAX2-RV32-NEXT:    vmerge.vim v8, v8, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vi v10, v26, 24
; LMULMAX2-RV32-NEXT:    vand.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vor.vv v30, v8, v30
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v8, a4
; LMULMAX2-RV32-NEXT:    vmerge.vim v8, v8, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsll.vx v10, v26, a2
; LMULMAX2-RV32-NEXT:    vand.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsll.vx v26, v26, a6
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v8
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v28, v26, v28
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV32-NEXT:    lui a1, 986895
; LMULMAX2-RV32-NEXT:    addi a1, a1, 240
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v28, v26, v28
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV32-NEXT:    lui a1, 838861
; LMULMAX2-RV32-NEXT:    addi a1, a1, -820
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v28, v26, v28
; LMULMAX2-RV32-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV32-NEXT:    lui a1, 699051
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vand.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi a1, zero, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    addi a2, zero, 40
; LMULMAX2-RV64-NEXT:    vsrl.vx v30, v26, a2
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    vand.vx v30, v30, a3
; LMULMAX2-RV64-NEXT:    vor.vv v28, v30, v28
; LMULMAX2-RV64-NEXT:    vsrl.vi v30, v26, 24
; LMULMAX2-RV64-NEXT:    lui a3, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v30, v30, a3
; LMULMAX2-RV64-NEXT:    vsrl.vi v8, v26, 8
; LMULMAX2-RV64-NEXT:    addi a3, zero, 255
; LMULMAX2-RV64-NEXT:    slli a4, a3, 24
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX2-RV64-NEXT:    vor.vv v30, v8, v30
; LMULMAX2-RV64-NEXT:    vor.vv v28, v30, v28
; LMULMAX2-RV64-NEXT:    vsll.vi v30, v26, 8
; LMULMAX2-RV64-NEXT:    slli a4, a3, 32
; LMULMAX2-RV64-NEXT:    vand.vx v30, v30, a4
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v26, 24
; LMULMAX2-RV64-NEXT:    slli a4, a3, 40
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX2-RV64-NEXT:    vor.vv v30, v8, v30
; LMULMAX2-RV64-NEXT:    vsll.vx v8, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vx v26, v26, a2
; LMULMAX2-RV64-NEXT:    slli a1, a3, 48
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vor.vv v26, v8, v26
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 3855
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 4
; LMULMAX2-RV64-NEXT:    lui a1, 1044721
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -241
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 240
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 13107
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 2
; LMULMAX2-RV64-NEXT:    lui a1, 1035469
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -820
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v28, v28, 1
; LMULMAX2-RV64-NEXT:    lui a1, 1026731
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1366
; LMULMAX2-RV64-NEXT:    vand.vx v26, v26, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v30, (a1)
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a6, zero, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v30, a6
; LMULMAX1-RV32-NEXT:    addi a7, zero, 40
; LMULMAX1-RV32-NEXT:    vsrl.vx v27, v30, a7
; LMULMAX1-RV32-NEXT:    lui a4, 16
; LMULMAX1-RV32-NEXT:    addi a4, a4, -256
; LMULMAX1-RV32-NEXT:    vand.vx v27, v27, a4
; LMULMAX1-RV32-NEXT:    vor.vv v27, v27, v26
; LMULMAX1-RV32-NEXT:    addi a5, zero, 5
; LMULMAX1-RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a5
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.i v26, 0
; LMULMAX1-RV32-NEXT:    lui a2, 1044480
; LMULMAX1-RV32-NEXT:    vmerge.vxm v26, v26, a2, v0
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v30, 8
; LMULMAX1-RV32-NEXT:    vand.vv v28, v28, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v29, v30, 24
; LMULMAX1-RV32-NEXT:    lui a5, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v29, v29, a5
; LMULMAX1-RV32-NEXT:    vor.vv v28, v28, v29
; LMULMAX1-RV32-NEXT:    vor.vv v31, v28, v27
; LMULMAX1-RV32-NEXT:    addi a2, zero, 255
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a2
; LMULMAX1-RV32-NEXT:    vmerge.vim v27, v27, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vi v28, v30, 8
; LMULMAX1-RV32-NEXT:    vand.vv v29, v28, v27
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v28, a4
; LMULMAX1-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v30, 24
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v28
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v29
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v29, a5
; LMULMAX1-RV32-NEXT:    vmerge.vim v29, v29, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsll.vx v9, v30, a7
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v29
; LMULMAX1-RV32-NEXT:    vsll.vx v30, v30, a6
; LMULMAX1-RV32-NEXT:    vor.vv v30, v30, v9
; LMULMAX1-RV32-NEXT:    vor.vv v30, v30, v8
; LMULMAX1-RV32-NEXT:    vor.vv v31, v30, v31
; LMULMAX1-RV32-NEXT:    lui a2, 61681
; LMULMAX1-RV32-NEXT:    addi a2, a2, -241
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v30, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v8, v31, v30
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    lui a2, 986895
; LMULMAX1-RV32-NEXT:    addi a2, a2, 240
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v9, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v31, v31, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v31, v31, 4
; LMULMAX1-RV32-NEXT:    vor.vv v31, v31, v8
; LMULMAX1-RV32-NEXT:    lui a2, 209715
; LMULMAX1-RV32-NEXT:    addi a2, a2, 819
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v8, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v10, v31, v8
; LMULMAX1-RV32-NEXT:    vsll.vi v10, v10, 2
; LMULMAX1-RV32-NEXT:    lui a2, 838861
; LMULMAX1-RV32-NEXT:    addi a2, a2, -820
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v11, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v31, v31, v11
; LMULMAX1-RV32-NEXT:    vsrl.vi v31, v31, 2
; LMULMAX1-RV32-NEXT:    vor.vv v31, v31, v10
; LMULMAX1-RV32-NEXT:    lui a2, 349525
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v12, v31, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v12, 1
; LMULMAX1-RV32-NEXT:    lui a2, 699051
; LMULMAX1-RV32-NEXT:    addi a2, a2, -1366
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v13, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vand.vv v31, v31, v13
; LMULMAX1-RV32-NEXT:    vsrl.vi v31, v31, 1
; LMULMAX1-RV32-NEXT:    vor.vv v31, v31, v12
; LMULMAX1-RV32-NEXT:    vsrl.vx v12, v25, a6
; LMULMAX1-RV32-NEXT:    vsrl.vx v14, v25, a7
; LMULMAX1-RV32-NEXT:    vand.vx v14, v14, a4
; LMULMAX1-RV32-NEXT:    vor.vv v12, v14, v12
; LMULMAX1-RV32-NEXT:    vsrl.vi v14, v25, 8
; LMULMAX1-RV32-NEXT:    vand.vv v26, v14, v26
; LMULMAX1-RV32-NEXT:    vsrl.vi v14, v25, 24
; LMULMAX1-RV32-NEXT:    vand.vx v14, v14, a5
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v14
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v12
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v25, 8
; LMULMAX1-RV32-NEXT:    vand.vv v27, v12, v27
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v25, 24
; LMULMAX1-RV32-NEXT:    vand.vv v28, v12, v28
; LMULMAX1-RV32-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV32-NEXT:    vsll.vx v28, v25, a7
; LMULMAX1-RV32-NEXT:    vand.vv v28, v28, v29
; LMULMAX1-RV32-NEXT:    vsll.vx v25, v25, a6
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v30
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 4
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v8
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 2
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v11
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vand.vv v26, v25, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v13
; LMULMAX1-RV32-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v26
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v31, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -16
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV64-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; LMULMAX1-RV64-NEXT:    .cfi_offset s0, -8
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi t1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (t1)
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a7, zero, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v27, v26, a7
; LMULMAX1-RV64-NEXT:    addi t0, zero, 40
; LMULMAX1-RV64-NEXT:    vsrl.vx v28, v26, t0
; LMULMAX1-RV64-NEXT:    lui a1, 16
; LMULMAX1-RV64-NEXT:    addiw t2, a1, -256
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, t2
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vsrl.vi v28, v26, 24
; LMULMAX1-RV64-NEXT:    lui a6, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV64-NEXT:    vsrl.vi v29, v26, 8
; LMULMAX1-RV64-NEXT:    addi a1, zero, 255
; LMULMAX1-RV64-NEXT:    slli t3, a1, 24
; LMULMAX1-RV64-NEXT:    vand.vx v29, v29, t3
; LMULMAX1-RV64-NEXT:    vor.vv v28, v29, v28
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vsll.vi v28, v26, 8
; LMULMAX1-RV64-NEXT:    slli t4, a1, 32
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, t4
; LMULMAX1-RV64-NEXT:    vsll.vi v29, v26, 24
; LMULMAX1-RV64-NEXT:    slli t5, a1, 40
; LMULMAX1-RV64-NEXT:    vand.vx v29, v29, t5
; LMULMAX1-RV64-NEXT:    vor.vv v28, v29, v28
; LMULMAX1-RV64-NEXT:    vsll.vx v29, v26, a7
; LMULMAX1-RV64-NEXT:    vsll.vx v26, v26, t0
; LMULMAX1-RV64-NEXT:    slli t6, a1, 48
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, t6
; LMULMAX1-RV64-NEXT:    vor.vv v26, v29, v26
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v28
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    lui a4, 3855
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, 241
; LMULMAX1-RV64-NEXT:    slli a4, a4, 12
; LMULMAX1-RV64-NEXT:    addi a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    lui a5, 1044721
; LMULMAX1-RV64-NEXT:    addiw a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, -241
; LMULMAX1-RV64-NEXT:    slli a5, a5, 12
; LMULMAX1-RV64-NEXT:    addi a5, a5, 240
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 4
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    lui a2, 13107
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 819
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    lui a3, 1035469
; LMULMAX1-RV64-NEXT:    addiw a3, a3, -819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, -819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, -819
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, -820
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 2
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    lui a1, 21845
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v27, v26, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    lui s0, 1026731
; LMULMAX1-RV64-NEXT:    addiw s0, s0, -1365
; LMULMAX1-RV64-NEXT:    slli s0, s0, 12
; LMULMAX1-RV64-NEXT:    addi s0, s0, -1365
; LMULMAX1-RV64-NEXT:    slli s0, s0, 12
; LMULMAX1-RV64-NEXT:    addi s0, s0, -1365
; LMULMAX1-RV64-NEXT:    slli s0, s0, 12
; LMULMAX1-RV64-NEXT:    addi s0, s0, -1366
; LMULMAX1-RV64-NEXT:    vand.vx v26, v26, s0
; LMULMAX1-RV64-NEXT:    vsrl.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vsrl.vx v27, v25, a7
; LMULMAX1-RV64-NEXT:    vsrl.vx v28, v25, t0
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, t2
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vsrl.vi v28, v25, 24
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, a6
; LMULMAX1-RV64-NEXT:    vsrl.vi v29, v25, 8
; LMULMAX1-RV64-NEXT:    vand.vx v29, v29, t3
; LMULMAX1-RV64-NEXT:    vor.vv v28, v29, v28
; LMULMAX1-RV64-NEXT:    vor.vv v27, v28, v27
; LMULMAX1-RV64-NEXT:    vsll.vi v28, v25, 8
; LMULMAX1-RV64-NEXT:    vand.vx v28, v28, t4
; LMULMAX1-RV64-NEXT:    vsll.vi v29, v25, 24
; LMULMAX1-RV64-NEXT:    vand.vx v29, v29, t5
; LMULMAX1-RV64-NEXT:    vor.vv v28, v29, v28
; LMULMAX1-RV64-NEXT:    vsll.vx v29, v25, a7
; LMULMAX1-RV64-NEXT:    vsll.vx v25, v25, t0
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, t6
; LMULMAX1-RV64-NEXT:    vor.vv v25, v29, v25
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 4
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 4
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 2
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 2
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vand.vx v27, v25, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v27, v27, 1
; LMULMAX1-RV64-NEXT:    vand.vx v25, v25, s0
; LMULMAX1-RV64-NEXT:    vsrl.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (t1)
; LMULMAX1-RV64-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; LMULMAX1-RV64-NEXT:    addi sp, sp, 16
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %a)
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)
