; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV64

define void @bswap_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v8i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -16
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 0(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 14(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 12(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 10(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 8(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 6(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 4(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 2(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v25, (sp)
; LMULMAX2-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 16
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v8i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -16
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 0(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 14(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 12(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 10(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 8(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 6(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 4(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 2(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v25, (sp)
; LMULMAX2-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, sp, 16
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -16
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 0(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 14(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 12(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 10(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 8(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 6(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 4(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    slli a2, a1, 8
; LMULMAX1-RV32-NEXT:    slli a1, a1, 16
; LMULMAX1-RV32-NEXT:    srli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a2, a1
; LMULMAX1-RV32-NEXT:    sh a1, 2(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (sp)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 16
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -16
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 0(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 14(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 12(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 10(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 8(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 6(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 4(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    slli a2, a1, 8
; LMULMAX1-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX1-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    sh a1, 2(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (sp)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 16
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = call <8 x i16> @llvm.bswap.v8i16(<8 x i16> %a)
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}
declare <8 x i16> @llvm.bswap.v8i16(<8 x i16>)

define void @bswap_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v4i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -16
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    slli a4, a1, 8
; LMULMAX2-RV32-NEXT:    lui a5, 4080
; LMULMAX2-RV32-NEXT:    and a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 0(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    slli a4, a1, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    slli a4, a1, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a3, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a3
; LMULMAX2-RV32-NEXT:    slli a3, a1, 8
; LMULMAX2-RV32-NEXT:    and a3, a3, a5
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a3
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX2-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 16
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v4i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -16
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    lui a5, 4080
; LMULMAX2-RV64-NEXT:    and a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sw a1, 0(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sw a1, 12(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sw a1, 8(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    srliw a3, a1, 24
; LMULMAX2-RV64-NEXT:    or a2, a2, a3
; LMULMAX2-RV64-NEXT:    slli a3, a1, 8
; LMULMAX2-RV64-NEXT:    and a3, a3, a5
; LMULMAX2-RV64-NEXT:    slli a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a1, a3
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sw a1, 4(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v25, (sp)
; LMULMAX2-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, sp, 16
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -16
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    lui a3, 16
; LMULMAX1-RV32-NEXT:    addi a3, a3, -256
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    lui a5, 4080
; LMULMAX1-RV32-NEXT:    and a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 0(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a3
; LMULMAX1-RV32-NEXT:    slli a3, a1, 8
; LMULMAX1-RV32-NEXT:    and a3, a3, a5
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a3
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 16
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -16
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX1-RV64-NEXT:    lui a3, 16
; LMULMAX1-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    slli a4, a1, 8
; LMULMAX1-RV64-NEXT:    lui a5, 4080
; LMULMAX1-RV64-NEXT:    and a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    sw a1, 0(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    slli a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    slli a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srliw a2, a1, 8
; LMULMAX1-RV64-NEXT:    and a2, a2, a3
; LMULMAX1-RV64-NEXT:    srliw a3, a1, 24
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    slli a3, a1, 8
; LMULMAX1-RV64-NEXT:    and a3, a3, a5
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 16
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = call <4 x i32> @llvm.bswap.v4i32(<4 x i32> %a)
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}
declare <4 x i32> @llvm.bswap.v4i32(<4 x i32>)

define void @bswap_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v2i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -16
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    slli a4, a1, 8
; LMULMAX2-RV32-NEXT:    lui a6, 4080
; LMULMAX2-RV32-NEXT:    and a4, a4, a6
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a4, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    slli a4, a1, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a6
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX2-RV32-NEXT:    addi a1, zero, 32
; LMULMAX2-RV32-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX2-RV32-NEXT:    srli a4, a2, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a3
; LMULMAX2-RV32-NEXT:    srli a5, a2, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a2, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a2, a2, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a5
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    sw a2, 0(sp)
; LMULMAX2-RV32-NEXT:    vsrl.vx v25, v26, a1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV32-NEXT:    srli a2, a1, 8
; LMULMAX2-RV32-NEXT:    and a2, a2, a3
; LMULMAX2-RV32-NEXT:    srli a3, a1, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a3
; LMULMAX2-RV32-NEXT:    slli a3, a1, 8
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    slli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a3
; LMULMAX2-RV32-NEXT:    or a1, a1, a2
; LMULMAX2-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, sp, 16
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v2i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX2-RV64-NEXT:    srli a2, a1, 40
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a7, a3, -256
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    srli a4, a1, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a1, 24
; LMULMAX2-RV64-NEXT:    lui a6, 4080
; LMULMAX2-RV64-NEXT:    and a4, a4, a6
; LMULMAX2-RV64-NEXT:    srli a5, a1, 8
; LMULMAX2-RV64-NEXT:    addi a3, zero, 255
; LMULMAX2-RV64-NEXT:    slli t0, a3, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or t1, a4, a2
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    slli t2, a3, 32
; LMULMAX2-RV64-NEXT:    and a4, a4, t2
; LMULMAX2-RV64-NEXT:    slli a2, a1, 24
; LMULMAX2-RV64-NEXT:    slli t3, a3, 40
; LMULMAX2-RV64-NEXT:    and a2, a2, t3
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    slli a4, a1, 40
; LMULMAX2-RV64-NEXT:    slli a3, a3, 48
; LMULMAX2-RV64-NEXT:    and a4, a4, a3
; LMULMAX2-RV64-NEXT:    slli a1, a1, 56
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    or t1, a1, t1
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX2-RV64-NEXT:    srli a4, a2, 40
; LMULMAX2-RV64-NEXT:    and a4, a4, a7
; LMULMAX2-RV64-NEXT:    srli a1, a2, 56
; LMULMAX2-RV64-NEXT:    or a1, a4, a1
; LMULMAX2-RV64-NEXT:    srli a4, a2, 24
; LMULMAX2-RV64-NEXT:    and a4, a4, a6
; LMULMAX2-RV64-NEXT:    srli a5, a2, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or a1, a4, a1
; LMULMAX2-RV64-NEXT:    slli a4, a2, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, t2
; LMULMAX2-RV64-NEXT:    slli a5, a2, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t3
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    slli a5, a2, 40
; LMULMAX2-RV64-NEXT:    and a3, a5, a3
; LMULMAX2-RV64-NEXT:    slli a2, a2, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a3
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.x v25, a1
; LMULMAX2-RV64-NEXT:    vmv.s.x v25, t1
; LMULMAX2-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -16
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 16
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    lui a3, 16
; LMULMAX1-RV32-NEXT:    addi a3, a3, -256
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    lui a6, 4080
; LMULMAX1-RV32-NEXT:    and a4, a4, a6
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a6
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV32-NEXT:    addi a1, zero, 32
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    srli a4, a2, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a3
; LMULMAX1-RV32-NEXT:    srli a5, a2, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a2, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a6
; LMULMAX1-RV32-NEXT:    slli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a5
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    sw a2, 0(sp)
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v26, a1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a2, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a2, a3
; LMULMAX1-RV32-NEXT:    srli a3, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a3
; LMULMAX1-RV32-NEXT:    slli a3, a1, 8
; LMULMAX1-RV32-NEXT:    and a3, a3, a6
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a3
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 16
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srli a2, a1, 40
; LMULMAX1-RV64-NEXT:    lui a3, 16
; LMULMAX1-RV64-NEXT:    addiw a7, a3, -256
; LMULMAX1-RV64-NEXT:    and a2, a2, a7
; LMULMAX1-RV64-NEXT:    srli a4, a1, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    srli a4, a1, 24
; LMULMAX1-RV64-NEXT:    lui a6, 4080
; LMULMAX1-RV64-NEXT:    and a4, a4, a6
; LMULMAX1-RV64-NEXT:    srli a5, a1, 8
; LMULMAX1-RV64-NEXT:    addi a3, zero, 255
; LMULMAX1-RV64-NEXT:    slli t0, a3, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t0
; LMULMAX1-RV64-NEXT:    or a4, a5, a4
; LMULMAX1-RV64-NEXT:    or t1, a4, a2
; LMULMAX1-RV64-NEXT:    slli a4, a1, 8
; LMULMAX1-RV64-NEXT:    slli t2, a3, 32
; LMULMAX1-RV64-NEXT:    and a4, a4, t2
; LMULMAX1-RV64-NEXT:    slli a2, a1, 24
; LMULMAX1-RV64-NEXT:    slli t3, a3, 40
; LMULMAX1-RV64-NEXT:    and a2, a2, t3
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    slli a4, a1, 40
; LMULMAX1-RV64-NEXT:    slli a3, a3, 48
; LMULMAX1-RV64-NEXT:    and a4, a4, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 56
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    or t1, a1, t1
; LMULMAX1-RV64-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    srli a4, a2, 40
; LMULMAX1-RV64-NEXT:    and a4, a4, a7
; LMULMAX1-RV64-NEXT:    srli a1, a2, 56
; LMULMAX1-RV64-NEXT:    or a1, a4, a1
; LMULMAX1-RV64-NEXT:    srli a4, a2, 24
; LMULMAX1-RV64-NEXT:    and a4, a4, a6
; LMULMAX1-RV64-NEXT:    srli a5, a2, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, t0
; LMULMAX1-RV64-NEXT:    or a4, a5, a4
; LMULMAX1-RV64-NEXT:    or a1, a4, a1
; LMULMAX1-RV64-NEXT:    slli a4, a2, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, t2
; LMULMAX1-RV64-NEXT:    slli a5, a2, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t3
; LMULMAX1-RV64-NEXT:    or a4, a5, a4
; LMULMAX1-RV64-NEXT:    slli a5, a2, 40
; LMULMAX1-RV64-NEXT:    and a3, a5, a3
; LMULMAX1-RV64-NEXT:    slli a2, a2, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v25, a1
; LMULMAX1-RV64-NEXT:    vmv.s.x v25, t1
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = call <2 x i64> @llvm.bswap.v2i64(<2 x i64> %a)
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}
declare <2 x i64> @llvm.bswap.v2i64(<2 x i64>)

define void @bswap_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 0(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 1, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 30(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 26(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 24(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 22(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 20(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 18(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 16(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 14(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 12(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 10(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 8(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 6(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 4(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV32-NEXT:    slli a2, a1, 8
; LMULMAX2-RV32-NEXT:    slli a1, a1, 16
; LMULMAX2-RV32-NEXT:    srli a1, a1, 24
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sh a1, 2(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (sp)
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -64
; LMULMAX2-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 64
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 0(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 1, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 15
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 30(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 14
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 28(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 13
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 26(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 12
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 11
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 22(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 10
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 20(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 9
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 18(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 8
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 16(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 14(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 12(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 10(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 8(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 6(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 4(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slliw a1, a1, 16
; LMULMAX2-RV64-NEXT:    srliw a1, a1, 24
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sh a1, 2(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (sp)
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -64
; LMULMAX2-RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 64
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 30(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 26(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 22(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 20(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 18(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 0(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 14(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 12(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 10(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 8(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 6(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 4(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV32-NEXT:    slli a3, a2, 8
; LMULMAX1-RV32-NEXT:    slli a2, a2, 16
; LMULMAX1-RV32-NEXT:    srli a2, a2, 24
; LMULMAX1-RV32-NEXT:    or a2, a3, a2
; LMULMAX1-RV32-NEXT:    sh a2, 2(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (sp)
; LMULMAX1-RV32-NEXT:    addi a2, sp, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a1)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -32
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 30(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 26(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 22(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v27
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 20(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 18(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 0(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 7
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 14(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 6
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 12(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 5
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 10(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 4
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 8(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 6(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 4(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    slliw a2, a2, 16
; LMULMAX1-RV64-NEXT:    srliw a2, a2, 24
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    sh a2, 2(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (sp)
; LMULMAX1-RV64-NEXT:    addi a2, sp, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a1)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 32
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = call <16 x i16> @llvm.bswap.v16i16(<16 x i16> %a)
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}
declare <16 x i16> @llvm.bswap.v16i16(<16 x i16>)

define void @bswap_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v26
; LMULMAX2-RV32-NEXT:    srli a2, a3, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    and a2, a2, a1
; LMULMAX2-RV32-NEXT:    srli a4, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a2, a4
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    lui a2, 4080
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 0(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 24(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 20(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 16(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 12(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 8(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v26
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a1, a4, a1
; LMULMAX2-RV32-NEXT:    srli a4, a3, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a4
; LMULMAX2-RV32-NEXT:    slli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a2, a4, a2
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a2, a3, a2
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (sp)
; LMULMAX2-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -64
; LMULMAX2-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 64
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v26
; LMULMAX2-RV64-NEXT:    srliw a2, a3, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    and a2, a2, a1
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a2, a4
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    lui a2, 4080
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 0(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 7
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 28(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 6
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 5
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 20(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 4
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 16(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 12(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a5, a3, 24
; LMULMAX2-RV64-NEXT:    or a4, a4, a5
; LMULMAX2-RV64-NEXT:    slli a5, a3, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a3, a3, a5
; LMULMAX2-RV64-NEXT:    or a3, a3, a4
; LMULMAX2-RV64-NEXT:    sw a3, 8(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a3, v26
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a1, a4, a1
; LMULMAX2-RV64-NEXT:    srliw a4, a3, 24
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    slli a4, a3, 8
; LMULMAX2-RV64-NEXT:    and a2, a4, a2
; LMULMAX2-RV64-NEXT:    slli a3, a3, 24
; LMULMAX2-RV64-NEXT:    or a2, a3, a2
; LMULMAX2-RV64-NEXT:    or a1, a2, a1
; LMULMAX2-RV64-NEXT:    sw a1, 4(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (sp)
; LMULMAX2-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -64
; LMULMAX2-RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 64
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a6)
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV32-NEXT:    srli a3, a4, 8
; LMULMAX1-RV32-NEXT:    lui a2, 16
; LMULMAX1-RV32-NEXT:    addi a2, a2, -256
; LMULMAX1-RV32-NEXT:    and a3, a3, a2
; LMULMAX1-RV32-NEXT:    srli a5, a4, 24
; LMULMAX1-RV32-NEXT:    or a5, a3, a5
; LMULMAX1-RV32-NEXT:    slli a1, a4, 8
; LMULMAX1-RV32-NEXT:    lui a3, 4080
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    slli a4, a4, 24
; LMULMAX1-RV32-NEXT:    or a1, a4, a1
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 28(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 0(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a4, a2
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a3, a4, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a3
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a6)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi sp, sp, -32
; LMULMAX1-RV64-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV64-NEXT:    srliw a3, a4, 8
; LMULMAX1-RV64-NEXT:    lui a2, 16
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -256
; LMULMAX1-RV64-NEXT:    and a3, a3, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a4, 24
; LMULMAX1-RV64-NEXT:    or a5, a3, a5
; LMULMAX1-RV64-NEXT:    slli a1, a4, 8
; LMULMAX1-RV64-NEXT:    lui a3, 4080
; LMULMAX1-RV64-NEXT:    and a1, a1, a3
; LMULMAX1-RV64-NEXT:    slli a4, a4, 24
; LMULMAX1-RV64-NEXT:    or a1, a4, a1
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 28(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v27, v26, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 20(sp)
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 0(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 3
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v25, 2
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a4, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a5, a1, 24
; LMULMAX1-RV64-NEXT:    or a4, a4, a5
; LMULMAX1-RV64-NEXT:    slli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a4
; LMULMAX1-RV64-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a2, a4, a2
; LMULMAX1-RV64-NEXT:    srliw a4, a1, 24
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    slli a4, a1, 8
; LMULMAX1-RV64-NEXT:    and a3, a4, a3
; LMULMAX1-RV64-NEXT:    slli a1, a1, 24
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    or a1, a1, a2
; LMULMAX1-RV64-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV64-NEXT:    addi a1, sp, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a6)
; LMULMAX1-RV64-NEXT:    addi sp, sp, 32
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = call <8 x i32> @llvm.bswap.v8i32(<8 x i32> %a)
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}
declare <8 x i32> @llvm.bswap.v8i32(<8 x i32>)

define void @bswap_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bswap_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi sp, sp, -64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; LMULMAX2-RV32-NEXT:    .cfi_offset ra, -4
; LMULMAX2-RV32-NEXT:    .cfi_offset s0, -8
; LMULMAX2-RV32-NEXT:    addi s0, sp, 64
; LMULMAX2-RV32-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV32-NEXT:    andi sp, sp, -32
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v26
; LMULMAX2-RV32-NEXT:    srli a2, a3, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    and a2, a2, a1
; LMULMAX2-RV32-NEXT:    srli a4, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a2, a4
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    lui a6, 4080
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 4(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v28
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 28(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v30, v26, 2
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v30
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 20(sp)
; LMULMAX2-RV32-NEXT:    vslidedown.vi v8, v26, 1
; LMULMAX2-RV32-NEXT:    vmv.x.s a3, v8
; LMULMAX2-RV32-NEXT:    srli a4, a3, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a3, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a3, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a3, a3, 24
; LMULMAX2-RV32-NEXT:    or a3, a3, a5
; LMULMAX2-RV32-NEXT:    or a3, a3, a4
; LMULMAX2-RV32-NEXT:    sw a3, 12(sp)
; LMULMAX2-RV32-NEXT:    addi a3, zero, 32
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v26, a3
; LMULMAX2-RV32-NEXT:    vmv.x.s a4, v26
; LMULMAX2-RV32-NEXT:    srli a5, a4, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a1
; LMULMAX2-RV32-NEXT:    srli a2, a4, 24
; LMULMAX2-RV32-NEXT:    or a2, a5, a2
; LMULMAX2-RV32-NEXT:    slli a5, a4, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a4, a4, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    or a2, a4, a2
; LMULMAX2-RV32-NEXT:    sw a2, 0(sp)
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v28, a3
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV32-NEXT:    srli a4, a2, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a2, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a2, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a2, a2, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a5
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    sw a2, 24(sp)
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v30, a3
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV32-NEXT:    srli a4, a2, 8
; LMULMAX2-RV32-NEXT:    and a4, a4, a1
; LMULMAX2-RV32-NEXT:    srli a5, a2, 24
; LMULMAX2-RV32-NEXT:    or a4, a4, a5
; LMULMAX2-RV32-NEXT:    slli a5, a2, 8
; LMULMAX2-RV32-NEXT:    and a5, a5, a6
; LMULMAX2-RV32-NEXT:    slli a2, a2, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a5
; LMULMAX2-RV32-NEXT:    or a2, a2, a4
; LMULMAX2-RV32-NEXT:    sw a2, 16(sp)
; LMULMAX2-RV32-NEXT:    vsrl.vx v26, v8, a3
; LMULMAX2-RV32-NEXT:    vmv.x.s a2, v26
; LMULMAX2-RV32-NEXT:    srli a3, a2, 8
; LMULMAX2-RV32-NEXT:    and a1, a3, a1
; LMULMAX2-RV32-NEXT:    srli a3, a2, 24
; LMULMAX2-RV32-NEXT:    or a1, a1, a3
; LMULMAX2-RV32-NEXT:    slli a3, a2, 8
; LMULMAX2-RV32-NEXT:    and a3, a3, a6
; LMULMAX2-RV32-NEXT:    slli a2, a2, 24
; LMULMAX2-RV32-NEXT:    or a2, a2, a3
; LMULMAX2-RV32-NEXT:    or a1, a2, a1
; LMULMAX2-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (sp)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi sp, s0, -64
; LMULMAX2-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; LMULMAX2-RV32-NEXT:    addi sp, sp, 64
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bswap_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi sp, sp, -64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa_offset 64
; LMULMAX2-RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; LMULMAX2-RV64-NEXT:    .cfi_offset ra, -8
; LMULMAX2-RV64-NEXT:    .cfi_offset s0, -16
; LMULMAX2-RV64-NEXT:    addi s0, sp, 64
; LMULMAX2-RV64-NEXT:    .cfi_def_cfa s0, 0
; LMULMAX2-RV64-NEXT:    andi sp, sp, -32
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    srli a2, a1, 40
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a7, a3, -256
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    srli a3, a1, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a3
; LMULMAX2-RV64-NEXT:    srli a3, a1, 24
; LMULMAX2-RV64-NEXT:    lui a6, 4080
; LMULMAX2-RV64-NEXT:    and a4, a3, a6
; LMULMAX2-RV64-NEXT:    srli a5, a1, 8
; LMULMAX2-RV64-NEXT:    addi a3, zero, 255
; LMULMAX2-RV64-NEXT:    slli t0, a3, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or a4, a4, a2
; LMULMAX2-RV64-NEXT:    slli a2, a1, 8
; LMULMAX2-RV64-NEXT:    slli t1, a3, 32
; LMULMAX2-RV64-NEXT:    and a2, a2, t1
; LMULMAX2-RV64-NEXT:    slli a5, a1, 24
; LMULMAX2-RV64-NEXT:    slli t2, a3, 40
; LMULMAX2-RV64-NEXT:    and a5, a5, t2
; LMULMAX2-RV64-NEXT:    or a5, a5, a2
; LMULMAX2-RV64-NEXT:    slli a2, a1, 40
; LMULMAX2-RV64-NEXT:    slli a3, a3, 48
; LMULMAX2-RV64-NEXT:    and a2, a2, a3
; LMULMAX2-RV64-NEXT:    slli a1, a1, 56
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    or a1, a1, a5
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    sd a1, 0(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 1, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 3
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    srli a2, a1, 40
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    srli a4, a1, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a1, 24
; LMULMAX2-RV64-NEXT:    and a4, a4, a6
; LMULMAX2-RV64-NEXT:    srli a5, a1, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or a2, a4, a2
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, t1
; LMULMAX2-RV64-NEXT:    slli a5, a1, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t2
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    slli a5, a1, 40
; LMULMAX2-RV64-NEXT:    and a5, a5, a3
; LMULMAX2-RV64-NEXT:    slli a1, a1, 56
; LMULMAX2-RV64-NEXT:    or a1, a1, a5
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sd a1, 24(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v28, v26, 2
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v28
; LMULMAX2-RV64-NEXT:    srli a2, a1, 40
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    srli a4, a1, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a1, 24
; LMULMAX2-RV64-NEXT:    and a4, a4, a6
; LMULMAX2-RV64-NEXT:    srli a5, a1, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or a2, a4, a2
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, t1
; LMULMAX2-RV64-NEXT:    slli a5, a1, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t2
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    slli a5, a1, 40
; LMULMAX2-RV64-NEXT:    and a5, a5, a3
; LMULMAX2-RV64-NEXT:    slli a1, a1, 56
; LMULMAX2-RV64-NEXT:    or a1, a1, a5
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sd a1, 16(sp)
; LMULMAX2-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vmv.x.s a1, v26
; LMULMAX2-RV64-NEXT:    srli a2, a1, 40
; LMULMAX2-RV64-NEXT:    and a2, a2, a7
; LMULMAX2-RV64-NEXT:    srli a4, a1, 56
; LMULMAX2-RV64-NEXT:    or a2, a2, a4
; LMULMAX2-RV64-NEXT:    srli a4, a1, 24
; LMULMAX2-RV64-NEXT:    and a4, a4, a6
; LMULMAX2-RV64-NEXT:    srli a5, a1, 8
; LMULMAX2-RV64-NEXT:    and a5, a5, t0
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    or a2, a4, a2
; LMULMAX2-RV64-NEXT:    slli a4, a1, 8
; LMULMAX2-RV64-NEXT:    and a4, a4, t1
; LMULMAX2-RV64-NEXT:    slli a5, a1, 24
; LMULMAX2-RV64-NEXT:    and a5, a5, t2
; LMULMAX2-RV64-NEXT:    or a4, a5, a4
; LMULMAX2-RV64-NEXT:    slli a5, a1, 40
; LMULMAX2-RV64-NEXT:    and a3, a5, a3
; LMULMAX2-RV64-NEXT:    slli a1, a1, 56
; LMULMAX2-RV64-NEXT:    or a1, a1, a3
; LMULMAX2-RV64-NEXT:    or a1, a1, a4
; LMULMAX2-RV64-NEXT:    or a1, a1, a2
; LMULMAX2-RV64-NEXT:    sd a1, 8(sp)
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (sp)
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi sp, s0, -64
; LMULMAX2-RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; LMULMAX2-RV64-NEXT:    addi sp, sp, 64
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bswap_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi sp, sp, -32
; LMULMAX1-RV32-NEXT:    .cfi_def_cfa_offset 32
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    addi a6, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a6)
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV32-NEXT:    srli a3, a4, 8
; LMULMAX1-RV32-NEXT:    lui a2, 16
; LMULMAX1-RV32-NEXT:    addi a2, a2, -256
; LMULMAX1-RV32-NEXT:    and a3, a3, a2
; LMULMAX1-RV32-NEXT:    srli a5, a4, 24
; LMULMAX1-RV32-NEXT:    or a5, a3, a5
; LMULMAX1-RV32-NEXT:    slli a1, a4, 8
; LMULMAX1-RV32-NEXT:    lui a3, 4080
; LMULMAX1-RV32-NEXT:    and a1, a1, a3
; LMULMAX1-RV32-NEXT:    slli a4, a4, 24
; LMULMAX1-RV32-NEXT:    or a1, a4, a1
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    sw a1, 20(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vslidedown.vi v27, v26, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v27
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 28(sp)
; LMULMAX1-RV32-NEXT:    addi a7, zero, 32
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v26, a7
; LMULMAX1-RV32-NEXT:    vmv.x.s a4, v26
; LMULMAX1-RV32-NEXT:    srli a5, a4, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a2
; LMULMAX1-RV32-NEXT:    srli a1, a4, 24
; LMULMAX1-RV32-NEXT:    or a1, a5, a1
; LMULMAX1-RV32-NEXT:    slli a5, a4, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a4, a4, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    or a1, a4, a1
; LMULMAX1-RV32-NEXT:    sw a1, 16(sp)
; LMULMAX1-RV32-NEXT:    vsrl.vx v26, v27, a7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 24(sp)
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 4(sp)
; LMULMAX1-RV32-NEXT:    vslidedown.vi v26, v25, 1
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v26
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 12(sp)
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v25, a7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a4, a4, a2
; LMULMAX1-RV32-NEXT:    srli a5, a1, 24
; LMULMAX1-RV32-NEXT:    or a4, a4, a5
; LMULMAX1-RV32-NEXT:    slli a5, a1, 8
; LMULMAX1-RV32-NEXT:    and a5, a5, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a5
; LMULMAX1-RV32-NEXT:    or a1, a1, a4
; LMULMAX1-RV32-NEXT:    sw a1, 0(sp)
; LMULMAX1-RV32-NEXT:    vsrl.vx v25, v26, a7
; LMULMAX1-RV32-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV32-NEXT:    srli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a2, a4, a2
; LMULMAX1-RV32-NEXT:    srli a4, a1, 24
; LMULMAX1-RV32-NEXT:    or a2, a2, a4
; LMULMAX1-RV32-NEXT:    slli a4, a1, 8
; LMULMAX1-RV32-NEXT:    and a3, a4, a3
; LMULMAX1-RV32-NEXT:    slli a1, a1, 24
; LMULMAX1-RV32-NEXT:    or a1, a1, a3
; LMULMAX1-RV32-NEXT:    or a1, a1, a2
; LMULMAX1-RV32-NEXT:    sw a1, 8(sp)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (sp)
; LMULMAX1-RV32-NEXT:    addi a1, sp, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a6)
; LMULMAX1-RV32-NEXT:    addi sp, sp, 32
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bswap_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a6, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a6)
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    srli a1, a2, 40
; LMULMAX1-RV64-NEXT:    lui a3, 16
; LMULMAX1-RV64-NEXT:    addiw t0, a3, -256
; LMULMAX1-RV64-NEXT:    and a1, a1, t0
; LMULMAX1-RV64-NEXT:    srli a3, a2, 56
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    srli a3, a2, 24
; LMULMAX1-RV64-NEXT:    lui a7, 4080
; LMULMAX1-RV64-NEXT:    and a3, a3, a7
; LMULMAX1-RV64-NEXT:    srli a5, a2, 8
; LMULMAX1-RV64-NEXT:    addi a4, zero, 255
; LMULMAX1-RV64-NEXT:    slli t1, a4, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t1
; LMULMAX1-RV64-NEXT:    or a3, a5, a3
; LMULMAX1-RV64-NEXT:    or a5, a3, a1
; LMULMAX1-RV64-NEXT:    slli a1, a2, 8
; LMULMAX1-RV64-NEXT:    slli t2, a4, 32
; LMULMAX1-RV64-NEXT:    and a3, a1, t2
; LMULMAX1-RV64-NEXT:    slli a1, a2, 24
; LMULMAX1-RV64-NEXT:    slli t3, a4, 40
; LMULMAX1-RV64-NEXT:    and a1, a1, t3
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    slli a3, a2, 40
; LMULMAX1-RV64-NEXT:    slli a4, a4, 48
; LMULMAX1-RV64-NEXT:    and a3, a3, a4
; LMULMAX1-RV64-NEXT:    slli a2, a2, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    or t4, a1, a5
; LMULMAX1-RV64-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v26, v26, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v26
; LMULMAX1-RV64-NEXT:    srli a3, a2, 40
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    srli a5, a2, 56
; LMULMAX1-RV64-NEXT:    or a3, a3, a5
; LMULMAX1-RV64-NEXT:    srli a5, a2, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, a7
; LMULMAX1-RV64-NEXT:    srli a1, a2, 8
; LMULMAX1-RV64-NEXT:    and a1, a1, t1
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    and a3, a3, t2
; LMULMAX1-RV64-NEXT:    slli a5, a2, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t3
; LMULMAX1-RV64-NEXT:    or a3, a5, a3
; LMULMAX1-RV64-NEXT:    slli a5, a2, 40
; LMULMAX1-RV64-NEXT:    and a5, a5, a4
; LMULMAX1-RV64-NEXT:    slli a2, a2, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a5
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v26, a1
; LMULMAX1-RV64-NEXT:    vmv.s.x v26, t4
; LMULMAX1-RV64-NEXT:    vmv.x.s a1, v25
; LMULMAX1-RV64-NEXT:    srli a2, a1, 40
; LMULMAX1-RV64-NEXT:    and a2, a2, t0
; LMULMAX1-RV64-NEXT:    srli a3, a1, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    srli a3, a1, 24
; LMULMAX1-RV64-NEXT:    and a3, a3, a7
; LMULMAX1-RV64-NEXT:    srli a5, a1, 8
; LMULMAX1-RV64-NEXT:    and a5, a5, t1
; LMULMAX1-RV64-NEXT:    or a3, a5, a3
; LMULMAX1-RV64-NEXT:    or a2, a3, a2
; LMULMAX1-RV64-NEXT:    slli a3, a1, 8
; LMULMAX1-RV64-NEXT:    and a3, a3, t2
; LMULMAX1-RV64-NEXT:    slli a5, a1, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t3
; LMULMAX1-RV64-NEXT:    or a3, a5, a3
; LMULMAX1-RV64-NEXT:    slli a5, a1, 40
; LMULMAX1-RV64-NEXT:    and a5, a5, a4
; LMULMAX1-RV64-NEXT:    slli a1, a1, 56
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    or t4, a1, a2
; LMULMAX1-RV64-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vslidedown.vi v25, v25, 1
; LMULMAX1-RV64-NEXT:    vmv.x.s a2, v25
; LMULMAX1-RV64-NEXT:    srli a3, a2, 40
; LMULMAX1-RV64-NEXT:    and a3, a3, t0
; LMULMAX1-RV64-NEXT:    srli a5, a2, 56
; LMULMAX1-RV64-NEXT:    or a3, a3, a5
; LMULMAX1-RV64-NEXT:    srli a5, a2, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, a7
; LMULMAX1-RV64-NEXT:    srli a1, a2, 8
; LMULMAX1-RV64-NEXT:    and a1, a1, t1
; LMULMAX1-RV64-NEXT:    or a1, a1, a5
; LMULMAX1-RV64-NEXT:    or a1, a1, a3
; LMULMAX1-RV64-NEXT:    slli a3, a2, 8
; LMULMAX1-RV64-NEXT:    and a3, a3, t2
; LMULMAX1-RV64-NEXT:    slli a5, a2, 24
; LMULMAX1-RV64-NEXT:    and a5, a5, t3
; LMULMAX1-RV64-NEXT:    or a3, a5, a3
; LMULMAX1-RV64-NEXT:    slli a5, a2, 40
; LMULMAX1-RV64-NEXT:    and a4, a5, a4
; LMULMAX1-RV64-NEXT:    slli a2, a2, 56
; LMULMAX1-RV64-NEXT:    or a2, a2, a4
; LMULMAX1-RV64-NEXT:    or a2, a2, a3
; LMULMAX1-RV64-NEXT:    or a1, a2, a1
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v25, a1
; LMULMAX1-RV64-NEXT:    vmv.s.x v25, t4
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a6)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = call <4 x i64> @llvm.bswap.v4i64(<4 x i64> %a)
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}
declare <4 x i64> @llvm.bswap.v4i64(<4 x i64>)
