; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,LMULMAX2,LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,LMULMAX2,LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,LMULMAX1,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,LMULMAX1,LMULMAX1-RV64

define void @add_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: add_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = add <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @add_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: add_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = add <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @add_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: add_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = add <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @add_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: add_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = add <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @sub_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: sub_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = sub <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @sub_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: sub_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = sub <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @sub_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: sub_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = sub <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @sub_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: sub_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = sub <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @mul_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: mul_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = mul <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @mul_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: mul_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = mul <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @mul_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: mul_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = mul <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @mul_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: mul_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmul.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = mul <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @and_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: and_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = and <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @and_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: and_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = and <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @and_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: and_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = and <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @and_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: and_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vand.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = and <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @or_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: or_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = or <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @or_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: or_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = or <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @or_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: or_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = or <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @or_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: or_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vor.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = or <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @xor_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: xor_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = xor <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @xor_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: xor_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = xor <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @xor_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: xor_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = xor <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @xor_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: xor_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vxor.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = xor <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @lshr_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: lshr_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = lshr <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @lshr_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: lshr_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = lshr <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @lshr_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: lshr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = lshr <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @lshr_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: lshr_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = lshr <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @ashr_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: ashr_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = ashr <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @ashr_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: ashr_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = ashr <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @ashr_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: ashr_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = ashr <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @ashr_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: ashr_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsra.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = ashr <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @shl_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: shl_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = shl <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @shl_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: shl_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = shl <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @shl_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: shl_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = shl <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @shl_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: shl_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vsll.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = shl <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @sdiv_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: sdiv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = sdiv <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @sdiv_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: sdiv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = sdiv <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @sdiv_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: sdiv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = sdiv <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @sdiv_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: sdiv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vdiv.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = sdiv <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @srem_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: srem_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = srem <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @srem_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: srem_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = srem <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @srem_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: srem_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = srem <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @srem_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: srem_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vrem.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = srem <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @udiv_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: udiv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = udiv <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @udiv_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: udiv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = udiv <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @udiv_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: udiv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = udiv <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @udiv_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: udiv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vdivu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = udiv <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @urem_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: urem_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %c = urem <16 x i8> %a, %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @urem_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: urem_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = urem <8 x i16> %a, %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @urem_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: urem_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = urem <4 x i32> %a, %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @urem_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: urem_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vremu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = urem <2 x i64> %a, %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @mulhu_v16i8(<16 x i8>* %x) {
; RV32-LABEL: mulhu_v16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV32-NEXT:    vle8.v v25, (a0)
; RV32-NEXT:    addi a1, zero, 513
; RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 4
; RV32-NEXT:    vmerge.vim v26, v26, 1, v0
; RV32-NEXT:    lui a1, 1
; RV32-NEXT:    addi a2, a1, 78
; RV32-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a2
; RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV32-NEXT:    vmerge.vim v26, v26, 3, v0
; RV32-NEXT:    lui a2, 8
; RV32-NEXT:    addi a2, a2, 304
; RV32-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a2
; RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV32-NEXT:    vmerge.vim v26, v26, 2, v0
; RV32-NEXT:    lui a2, 3
; RV32-NEXT:    addi a2, a2, -2044
; RV32-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a2
; RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV32-NEXT:    vmv.v.i v27, 0
; RV32-NEXT:    addi a2, zero, -128
; RV32-NEXT:    vmerge.vxm v28, v27, a2, v0
; RV32-NEXT:    addi a1, a1, 32
; RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV32-NEXT:    lui a1, %hi(.LCPI52_0)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI52_0)
; RV32-NEXT:    vle8.v v29, (a1)
; RV32-NEXT:    vmerge.vim v27, v27, 1, v0
; RV32-NEXT:    vsrl.vv v27, v25, v27
; RV32-NEXT:    vmulhu.vv v27, v27, v29
; RV32-NEXT:    vsub.vv v25, v25, v27
; RV32-NEXT:    vmulhu.vv v25, v25, v28
; RV32-NEXT:    vadd.vv v25, v25, v27
; RV32-NEXT:    vsrl.vv v25, v25, v26
; RV32-NEXT:    vse8.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhu_v16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV64-NEXT:    vle8.v v25, (a0)
; RV64-NEXT:    addi a1, zero, 513
; RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 4
; RV64-NEXT:    vmerge.vim v26, v26, 1, v0
; RV64-NEXT:    lui a1, 1
; RV64-NEXT:    addiw a2, a1, 78
; RV64-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a2
; RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV64-NEXT:    vmerge.vim v26, v26, 3, v0
; RV64-NEXT:    lui a2, 8
; RV64-NEXT:    addiw a2, a2, 304
; RV64-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a2
; RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV64-NEXT:    vmerge.vim v26, v26, 2, v0
; RV64-NEXT:    lui a2, 3
; RV64-NEXT:    addiw a2, a2, -2044
; RV64-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a2
; RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; RV64-NEXT:    vmv.v.i v27, 0
; RV64-NEXT:    addi a2, zero, -128
; RV64-NEXT:    vmerge.vxm v28, v27, a2, v0
; RV64-NEXT:    addiw a1, a1, 32
; RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV64-NEXT:    lui a1, %hi(.LCPI52_0)
; RV64-NEXT:    addi a1, a1, %lo(.LCPI52_0)
; RV64-NEXT:    vle8.v v29, (a1)
; RV64-NEXT:    vmerge.vim v27, v27, 1, v0
; RV64-NEXT:    vsrl.vv v27, v25, v27
; RV64-NEXT:    vmulhu.vv v27, v27, v29
; RV64-NEXT:    vsub.vv v25, v25, v27
; RV64-NEXT:    vmulhu.vv v25, v25, v28
; RV64-NEXT:    vadd.vv v25, v25, v27
; RV64-NEXT:    vsrl.vv v25, v25, v26
; RV64-NEXT:    vse8.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhu_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: mulhu_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, 1
; CHECK-NEXT:    vmv.s.x v26, a1
; CHECK-NEXT:    addi a1, zero, 33
; CHECK-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; CHECK-NEXT:    vmv.s.x v0, a1
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v27, 3
; CHECK-NEXT:    vmerge.vim v27, v27, 2, v0
; CHECK-NEXT:    vsetivli a1, 7, e16,m1,tu,mu
; CHECK-NEXT:    vslideup.vi v27, v26, 6
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v28, 0
; CHECK-NEXT:    lui a1, 1048568
; CHECK-NEXT:    vmv1r.v v29, v28
; CHECK-NEXT:    vmv.s.x v29, a1
; CHECK-NEXT:    vsetivli a1, 7, e16,m1,tu,mu
; CHECK-NEXT:    vslideup.vi v28, v26, 6
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    lui a1, %hi(.LCPI53_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI53_0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vsrl.vv v28, v25, v28
; CHECK-NEXT:    vmulhu.vv v26, v28, v26
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vmulhu.vv v25, v25, v29
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    vsrl.vv v25, v25, v27
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = udiv <8 x i16> %a, <i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhu_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: mulhu_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    lui a1, 524288
; CHECK-NEXT:    vmv.s.x v26, a1
; CHECK-NEXT:    vmv.v.i v27, 0
; CHECK-NEXT:    vsetivli a1, 3, e32,m1,tu,mu
; CHECK-NEXT:    vslideup.vi v27, v26, 2
; CHECK-NEXT:    lui a1, %hi(.LCPI54_0)
; CHECK-NEXT:    addi a1, a1, %lo(.LCPI54_0)
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmulhu.vv v26, v25, v26
; CHECK-NEXT:    vsub.vv v25, v25, v26
; CHECK-NEXT:    vmulhu.vv v25, v25, v27
; CHECK-NEXT:    vadd.vv v25, v25, v26
; CHECK-NEXT:    addi a1, zero, 1
; CHECK-NEXT:    vmv.s.x v26, a1
; CHECK-NEXT:    vmv.v.i v27, 2
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,tu,mu
; CHECK-NEXT:    vslideup.vi v27, v26, 3
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vsrl.vv v25, v25, v27
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = udiv <4 x i32> %a, <i32 5, i32 6, i32 7, i32 9>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhu_v2i64(<2 x i64>* %x) {
; RV32-LABEL: mulhu_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    lui a1, %hi(.LCPI55_0)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI55_0)
; RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v26, (a1)
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vmulhu.vv v25, v25, v26
; RV32-NEXT:    lui a1, %hi(.LCPI55_1)
; RV32-NEXT:    addi a1, a1, %lo(.LCPI55_1)
; RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v26, (a1)
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhu_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.v.i v26, 2
; RV64-NEXT:    addi a1, zero, 1
; RV64-NEXT:    vmv.s.x v26, a1
; RV64-NEXT:    lui a1, 1035469
; RV64-NEXT:    addiw a1, a1, -819
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -819
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -819
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -819
; RV64-NEXT:    vmv.v.x v27, a1
; RV64-NEXT:    lui a1, 1026731
; RV64-NEXT:    addiw a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    vmv.s.x v27, a1
; RV64-NEXT:    vmulhu.vv v25, v25, v27
; RV64-NEXT:    vsrl.vv v25, v25, v26
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = udiv <2 x i64> %a, <i64 3, i64 5>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @mulhs_v16i8(<16 x i8>* %x) {
; RV32-LABEL: mulhs_v16i8:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV32-NEXT:    vle8.v v25, (a0)
; RV32-NEXT:    lui a1, 5
; RV32-NEXT:    addi a1, a1, -1452
; RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 7
; RV32-NEXT:    vmerge.vim v26, v26, 1, v0
; RV32-NEXT:    addi a1, zero, -123
; RV32-NEXT:    vmv.v.x v27, a1
; RV32-NEXT:    addi a1, zero, 57
; RV32-NEXT:    vmerge.vxm v27, v27, a1, v0
; RV32-NEXT:    vmulhu.vv v25, v25, v27
; RV32-NEXT:    vsrl.vv v25, v25, v26
; RV32-NEXT:    vse8.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_v16i8:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV64-NEXT:    vle8.v v25, (a0)
; RV64-NEXT:    lui a1, 5
; RV64-NEXT:    addiw a1, a1, -1452
; RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 7
; RV64-NEXT:    vmerge.vim v26, v26, 1, v0
; RV64-NEXT:    addi a1, zero, -123
; RV64-NEXT:    vmv.v.x v27, a1
; RV64-NEXT:    addi a1, zero, 57
; RV64-NEXT:    vmerge.vxm v27, v27, a1, v0
; RV64-NEXT:    vmulhu.vv v25, v25, v27
; RV64-NEXT:    vsrl.vv v25, v25, v26
; RV64-NEXT:    vse8.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhs_v8i16(<8 x i16>* %x) {
; RV32-LABEL: mulhs_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    addi a1, zero, 105
; RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    lui a1, 5
; RV32-NEXT:    addi a1, a1, -1755
; RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a1
; RV32-NEXT:    lui a1, 1048571
; RV32-NEXT:    addi a1, a1, 1755
; RV32-NEXT:    vmerge.vxm v26, v26, a1, v0
; RV32-NEXT:    vmulh.vv v25, v25, v26
; RV32-NEXT:    vsra.vi v25, v25, 1
; RV32-NEXT:    vsrl.vi v26, v25, 15
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse16.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    addi a1, zero, 105
; RV64-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; RV64-NEXT:    vmv.s.x v0, a1
; RV64-NEXT:    lui a1, 5
; RV64-NEXT:    addiw a1, a1, -1755
; RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a1
; RV64-NEXT:    lui a1, 1048571
; RV64-NEXT:    addiw a1, a1, 1755
; RV64-NEXT:    vmerge.vxm v26, v26, a1, v0
; RV64-NEXT:    vmulh.vv v25, v25, v26
; RV64-NEXT:    vsra.vi v25, v25, 1
; RV64-NEXT:    vsrl.vi v26, v25, 15
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse16.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = sdiv <8 x i16> %a, <i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhs_v4i32(<4 x i32>* %x) {
; RV32-LABEL: mulhs_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v25, (a0)
; RV32-NEXT:    addi a1, zero, 5
; RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    lui a1, 419430
; RV32-NEXT:    addi a1, a1, 1639
; RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a1
; RV32-NEXT:    lui a1, 629146
; RV32-NEXT:    addi a1, a1, -1639
; RV32-NEXT:    vmerge.vxm v26, v26, a1, v0
; RV32-NEXT:    vmulh.vv v25, v25, v26
; RV32-NEXT:    vsrl.vi v26, v25, 31
; RV32-NEXT:    vsra.vi v25, v25, 1
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse32.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV64-NEXT:    vle32.v v25, (a0)
; RV64-NEXT:    lui a1, 13107
; RV64-NEXT:    addiw a1, a1, 819
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 973
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -819
; RV64-NEXT:    slli a1, a1, 13
; RV64-NEXT:    addi a1, a1, -1639
; RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a1
; RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV64-NEXT:    vmulh.vv v25, v25, v26
; RV64-NEXT:    vsra.vi v25, v25, 1
; RV64-NEXT:    vsrl.vi v26, v25, 31
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse32.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = sdiv <4 x i32> %a, <i32 -5, i32 5, i32 -5, i32 5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhs_v2i64(<2 x i64>* %x) {
; RV32-LABEL: mulhs_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a2, a1, 1365
; RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a2
; RV32-NEXT:    addi a1, a1, 1366
; RV32-NEXT:    vmv.s.x v26, a1
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vmulh.vv v26, v25, v26
; RV32-NEXT:    addi a1, zero, 1
; RV32-NEXT:    addi a2, zero, 3
; RV32-NEXT:    vsetivli a3, 1, e8,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a2
; RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.i v27, -1
; RV32-NEXT:    vmerge.vim v27, v27, 0, v0
; RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; RV32-NEXT:    vmul.vv v25, v25, v27
; RV32-NEXT:    vadd.vv v25, v26, v25
; RV32-NEXT:    addi a2, zero, 63
; RV32-NEXT:    vsrl.vx v26, v25, a2
; RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.s.x v27, a1
; RV32-NEXT:    vmv.v.i v28, 0
; RV32-NEXT:    vsetivli a1, 3, e32,m1,tu,mu
; RV32-NEXT:    vslideup.vi v28, v27, 2
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vsra.vv v25, v25, v28
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.v.i v26, -1
; RV64-NEXT:    vmv.s.x v26, zero
; RV64-NEXT:    vmul.vv v26, v25, v26
; RV64-NEXT:    lui a1, 21845
; RV64-NEXT:    addiw a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a2, a1, 1365
; RV64-NEXT:    vmv.v.x v27, a2
; RV64-NEXT:    addi a1, a1, 1366
; RV64-NEXT:    vmv.s.x v27, a1
; RV64-NEXT:    vmulh.vv v25, v25, v27
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    addi a1, zero, 63
; RV64-NEXT:    vsrl.vx v26, v25, a1
; RV64-NEXT:    vid.v v27
; RV64-NEXT:    vsra.vv v25, v25, v27
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = sdiv <2 x i64> %a, <i64 3, i64 -3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @smin_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: smin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp slt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @smin_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: smin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp slt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @smin_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: smin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp slt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @smin_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: smin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmin.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp slt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @smax_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: smax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp sgt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @smax_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: smax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp sgt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @smax_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: smax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp sgt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @smax_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: smax_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmax.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp sgt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @umin_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: umin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp ult <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @umin_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: umin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp ult <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @umin_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: umin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp ult <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @umin_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: umin_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vminu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp ult <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @umax_v16i8(<16 x i8>* %x, <16 x i8>* %y) {
; CHECK-LABEL: umax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vle8.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = load <16 x i8>, <16 x i8>* %y
  %cc = icmp ugt <16 x i8> %a, %b
  %c = select <16 x i1> %cc, <16 x i8> %a, <16 x i8> %b
  store <16 x i8> %c, <16 x i8>* %x
  ret void
}

define void @umax_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; CHECK-LABEL: umax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vle16.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %cc = icmp ugt <8 x i16> %a, %b
  %c = select <8 x i1> %cc, <8 x i16> %a, <8 x i16> %b
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}

define void @umax_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; CHECK-LABEL: umax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vle32.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %cc = icmp ugt <4 x i32> %a, %b
  %c = select <4 x i1> %cc, <4 x i32> %a, <4 x i32> %b
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}

define void @umax_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; CHECK-LABEL: umax_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vle64.v v26, (a1)
; CHECK-NEXT:    vmaxu.vv v25, v25, v26
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %cc = icmp ugt <2 x i64> %a, %b
  %c = select <2 x i1> %cc, <2 x i64> %a, <2 x i64> %b
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}

define void @add_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: add_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = add <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @add_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: add_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = add <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @add_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: add_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = add <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @add_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: add_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: add_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: add_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = add <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @sub_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: sub_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = sub <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @sub_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: sub_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = sub <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @sub_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: sub_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = sub <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @sub_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: sub_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sub_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sub_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsub.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = sub <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @mul_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: mul_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = mul <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @mul_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: mul_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = mul <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @mul_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: mul_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = mul <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @mul_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: mul_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmul.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mul_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmul.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mul_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmul.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmul.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = mul <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @and_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: and_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = and <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @and_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: and_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = and <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @and_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: and_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = and <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @and_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: and_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vand.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: and_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vand.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: and_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vand.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vand.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = and <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @or_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: or_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = or <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @or_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: or_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = or <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @or_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: or_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = or <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @or_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: or_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: or_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: or_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = or <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @xor_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: xor_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = xor <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @xor_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: xor_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = xor <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @xor_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: xor_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = xor <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @xor_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: xor_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vxor.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: xor_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vxor.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: xor_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vxor.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vxor.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = xor <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @lshr_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: lshr_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = lshr <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @lshr_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: lshr_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = lshr <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @lshr_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: lshr_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = lshr <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @lshr_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: lshr_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: lshr_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: lshr_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = lshr <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @ashr_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: ashr_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = ashr <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @ashr_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: ashr_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = ashr <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @ashr_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: ashr_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = ashr <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @ashr_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: ashr_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsra.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: ashr_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsra.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: ashr_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = ashr <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @shl_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: shl_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = shl <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @shl_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: shl_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = shl <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @shl_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: shl_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = shl <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @shl_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: shl_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsll.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: shl_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vsll.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: shl_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vsll.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vsll.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = shl <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @sdiv_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: sdiv_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = sdiv <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @sdiv_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: sdiv_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = sdiv <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @sdiv_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: sdiv_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = sdiv <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @sdiv_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: sdiv_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vdiv.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: sdiv_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: sdiv_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = sdiv <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @srem_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: srem_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = srem <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @srem_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: srem_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = srem <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @srem_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: srem_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = srem <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @srem_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: srem_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vrem.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: srem_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vrem.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: srem_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vrem.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vrem.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = srem <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @udiv_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: udiv_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = udiv <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @udiv_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: udiv_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = udiv <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @udiv_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: udiv_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = udiv <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @udiv_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: udiv_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vdivu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: udiv_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: udiv_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = udiv <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @urem_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: urem_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %c = urem <32 x i8> %a, %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @urem_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: urem_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = urem <16 x i16> %a, %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @urem_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: urem_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = urem <8 x i32> %a, %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @urem_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: urem_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vremu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: urem_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vremu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: urem_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vremu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vremu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = urem <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @extract_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: extract_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-LABEL: extract_v4i64:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-NEXT:    vle64.v v25, (a0)
; LMULMAX1-NEXT:    addi a2, a0, 16
; LMULMAX1-NEXT:    vle64.v v26, (a2)
; LMULMAX1-NEXT:    vle64.v v27, (a1)
; LMULMAX1-NEXT:    addi a1, a1, 16
; LMULMAX1-NEXT:    vle64.v v28, (a1)
; LMULMAX1-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-NEXT:    vadd.vv v26, v26, v28
; LMULMAX1-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-NEXT:    vse64.v v25, (a0)
; LMULMAX1-NEXT:    vse64.v v26, (a2)
; LMULMAX1-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  br label %"compute"
"compute":
  %c = add <4 x i64> %a, %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @mulhu_v32i8(<32 x i8>* %x) {
; LMULMAX2-RV32-LABEL: mulhu_v32i8:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi a1, zero, 32
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    lui a2, 8208
; LMULMAX2-RV32-NEXT:    addi a2, a2, 513
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v28, 4
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV32-NEXT:    lui a2, 66785
; LMULMAX2-RV32-NEXT:    addi a2, a2, 78
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 3, v0
; LMULMAX2-RV32-NEXT:    lui a2, 529160
; LMULMAX2-RV32-NEXT:    addi a2, a2, 304
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 2, v0
; LMULMAX2-RV32-NEXT:    lui a2, 163907
; LMULMAX2-RV32-NEXT:    addi a2, a2, -2044
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV32-NEXT:    addi a2, zero, -128
; LMULMAX2-RV32-NEXT:    vmerge.vxm v8, v30, a2, v0
; LMULMAX2-RV32-NEXT:    lui a2, 66049
; LMULMAX2-RV32-NEXT:    addi a2, a2, 32
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    lui a1, %hi(.LCPI129_0)
; LMULMAX2-RV32-NEXT:    addi a1, a1, %lo(.LCPI129_0)
; LMULMAX2-RV32-NEXT:    vle8.v v10, (a1)
; LMULMAX2-RV32-NEXT:    vmerge.vim v30, v30, 1, v0
; LMULMAX2-RV32-NEXT:    vsrl.vv v30, v26, v30
; LMULMAX2-RV32-NEXT:    vmulhu.vv v30, v30, v10
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vmulhu.vv v26, v26, v8
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhu_v32i8:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi a1, zero, 32
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    lui a2, 8208
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 513
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v28, 4
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV64-NEXT:    lui a2, 66785
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 78
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 3, v0
; LMULMAX2-RV64-NEXT:    lui a2, 529160
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 304
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 2, v0
; LMULMAX2-RV64-NEXT:    lui a2, 163907
; LMULMAX2-RV64-NEXT:    addiw a2, a2, -2044
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV64-NEXT:    addi a2, zero, -128
; LMULMAX2-RV64-NEXT:    vmerge.vxm v8, v30, a2, v0
; LMULMAX2-RV64-NEXT:    lui a2, 66049
; LMULMAX2-RV64-NEXT:    addiw a2, a2, 32
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI129_0)
; LMULMAX2-RV64-NEXT:    addi a1, a1, %lo(.LCPI129_0)
; LMULMAX2-RV64-NEXT:    vle8.v v10, (a1)
; LMULMAX2-RV64-NEXT:    vmerge.vim v30, v30, 1, v0
; LMULMAX2-RV64-NEXT:    vsrl.vv v30, v26, v30
; LMULMAX2-RV64-NEXT:    vmulhu.vv v30, v30, v10
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vmulhu.vv v26, v26, v8
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-LABEL: mulhu_v32i8:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle8.v v25, (a1)
; LMULMAX1-NEXT:    lui a2, %hi(.LCPI129_0)
; LMULMAX1-NEXT:    addi a2, a2, %lo(.LCPI129_0)
; LMULMAX1-NEXT:    vle8.v v26, (a2)
; LMULMAX1-NEXT:    vle8.v v27, (a0)
; LMULMAX1-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-NEXT:    vse8.v v26, (a0)
; LMULMAX1-NEXT:    vse8.v v25, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = udiv <32 x i8> %a, <i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 17, i8 18, i8 19, i8 20, i8 21, i8 22, i8 23, i8 24, i8 25>
  store <32 x i8> %b, <32 x i8>* %x
  ret void
}

define void @mulhu_v16i16(<16 x i16>* %x) {
; LMULMAX2-RV32-LABEL: mulhu_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    lui a1, 2
; LMULMAX2-RV32-NEXT:    addi a1, a1, 289
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v28, 3
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 2, v0
; LMULMAX2-RV32-NEXT:    lui a1, 4
; LMULMAX2-RV32-NEXT:    addi a1, a1, 64
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV32-NEXT:    vmv1r.v v12, v0
; LMULMAX2-RV32-NEXT:    addi a1, zero, 257
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV32-NEXT:    lui a1, 1048568
; LMULMAX2-RV32-NEXT:    lui a2, %hi(.LCPI130_0)
; LMULMAX2-RV32-NEXT:    addi a2, a2, %lo(.LCPI130_0)
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a2)
; LMULMAX2-RV32-NEXT:    vmerge.vxm v10, v30, a1, v0
; LMULMAX2-RV32-NEXT:    vmv1r.v v0, v12
; LMULMAX2-RV32-NEXT:    vmerge.vim v30, v30, 1, v0
; LMULMAX2-RV32-NEXT:    vsrl.vv v30, v26, v30
; LMULMAX2-RV32-NEXT:    vmulhu.vv v30, v30, v8
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vmulhu.vv v26, v26, v10
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhu_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    lui a1, 2
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 289
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v28, 3
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 2, v0
; LMULMAX2-RV64-NEXT:    lui a1, 4
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 64
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV64-NEXT:    vmv1r.v v12, v0
; LMULMAX2-RV64-NEXT:    addi a1, zero, 257
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV64-NEXT:    lui a1, 1048568
; LMULMAX2-RV64-NEXT:    lui a2, %hi(.LCPI130_0)
; LMULMAX2-RV64-NEXT:    addi a2, a2, %lo(.LCPI130_0)
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a2)
; LMULMAX2-RV64-NEXT:    vmerge.vxm v10, v30, a1, v0
; LMULMAX2-RV64-NEXT:    vmv1r.v v0, v12
; LMULMAX2-RV64-NEXT:    vmerge.vim v30, v30, 1, v0
; LMULMAX2-RV64-NEXT:    vsrl.vv v30, v26, v30
; LMULMAX2-RV64-NEXT:    vmulhu.vv v30, v30, v8
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vmulhu.vv v26, v26, v10
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-LABEL: mulhu_v16i16:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle16.v v25, (a1)
; LMULMAX1-NEXT:    lui a2, %hi(.LCPI130_0)
; LMULMAX1-NEXT:    addi a2, a2, %lo(.LCPI130_0)
; LMULMAX1-NEXT:    vle16.v v26, (a2)
; LMULMAX1-NEXT:    vle16.v v27, (a0)
; LMULMAX1-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-NEXT:    vse16.v v26, (a0)
; LMULMAX1-NEXT:    vse16.v v25, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = udiv <16 x i16> %a, <i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15, i16 7, i16 9, i16 10, i16 11, i16 12, i16 13, i16 14, i16 15>
  store <16 x i16> %b, <16 x i16>* %x
  ret void
}

define void @mulhu_v8i32(<8 x i32>* %x) {
; LMULMAX2-LABEL: mulhu_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    addi a1, zero, 68
; LMULMAX2-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-NEXT:    vmv.s.x v0, a1
; LMULMAX2-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    lui a1, %hi(.LCPI131_0)
; LMULMAX2-NEXT:    addi a1, a1, %lo(.LCPI131_0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmv.v.i v30, 0
; LMULMAX2-NEXT:    lui a1, 524288
; LMULMAX2-NEXT:    vmerge.vxm v30, v30, a1, v0
; LMULMAX2-NEXT:    vmulhu.vv v28, v26, v28
; LMULMAX2-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-NEXT:    addi a1, zero, 136
; LMULMAX2-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-NEXT:    vmv.s.x v0, a1
; LMULMAX2-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vmv.v.i v28, 2
; LMULMAX2-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhu_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, 524288
; LMULMAX1-RV32-NEXT:    vmv.s.x v27, a2
; LMULMAX1-RV32-NEXT:    vmv.v.i v28, 0
; LMULMAX1-RV32-NEXT:    vsetivli a2, 3, e32,m1,tu,mu
; LMULMAX1-RV32-NEXT:    vslideup.vi v28, v27, 2
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI131_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI131_0)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vmulhu.vv v29, v26, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v26, v26, v29
; LMULMAX1-RV32-NEXT:    vmulhu.vv v26, v26, v28
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v29
; LMULMAX1-RV32-NEXT:    addi a2, zero, 1
; LMULMAX1-RV32-NEXT:    vmv.s.x v29, a2
; LMULMAX1-RV32-NEXT:    vmv.v.i v30, 2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,tu,mu
; LMULMAX1-RV32-NEXT:    vslideup.vi v30, v29, 3
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vsrl.vv v26, v26, v30
; LMULMAX1-RV32-NEXT:    vmulhu.vv v27, v25, v27
; LMULMAX1-RV32-NEXT:    vsub.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vmulhu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vv v25, v25, v30
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, %hi(.LCPI131_0)
; LMULMAX1-RV64-NEXT:    addi a2, a2, %lo(.LCPI131_0)
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a0)
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v26
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = udiv <8 x i32> %a, <i32 5, i32 6, i32 7, i32 9, i32 5, i32 6, i32 7, i32 9>
  store <8 x i32> %b, <8 x i32>* %x
  ret void
}

define void @mulhu_v4i64(<4 x i64>* %x) {
; LMULMAX2-RV32-LABEL: mulhu_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    lui a1, %hi(.LCPI132_0)
; LMULMAX2-RV32-NEXT:    addi a1, a1, %lo(.LCPI132_0)
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmulhu.vv v28, v26, v28
; LMULMAX2-RV32-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, 524288
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v30, a1
; LMULMAX2-RV32-NEXT:    vmv.v.i v8, 0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 6, e32,m2,tu,mu
; LMULMAX2-RV32-NEXT:    vslideup.vi v8, v30, 5
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmulhu.vv v26, v26, v8
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    lui a1, %hi(.LCPI132_1)
; LMULMAX2-RV32-NEXT:    addi a1, a1, %lo(.LCPI132_1)
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhu_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi a1, zero, -1
; LMULMAX2-RV64-NEXT:    slli a1, a1, 63
; LMULMAX2-RV64-NEXT:    vmv.s.x v28, a1
; LMULMAX2-RV64-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV64-NEXT:    vsetivli a1, 3, e64,m2,tu,mu
; LMULMAX2-RV64-NEXT:    vslideup.vi v30, v28, 2
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI132_0)
; LMULMAX2-RV64-NEXT:    addi a1, a1, %lo(.LCPI132_0)
; LMULMAX2-RV64-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX2-RV64-NEXT:    vmulhu.vv v28, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI132_1)
; LMULMAX2-RV64-NEXT:    addi a1, a1, %lo(.LCPI132_1)
; LMULMAX2-RV64-NEXT:    vle64.v v8, (a1)
; LMULMAX2-RV64-NEXT:    vsub.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vsrl.vv v26, v26, v8
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhu_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI132_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI132_0)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI132_1)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI132_1)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhu_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi a1, zero, 2
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    vmv.v.i v27, 0
; LMULMAX1-RV64-NEXT:    addi a3, zero, -1
; LMULMAX1-RV64-NEXT:    slli a3, a3, 63
; LMULMAX1-RV64-NEXT:    vmv.s.x v27, a3
; LMULMAX1-RV64-NEXT:    lui a3, 1044935
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 455
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 455
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 455
; LMULMAX1-RV64-NEXT:    slli a3, a3, 13
; LMULMAX1-RV64-NEXT:    addi a3, a3, 911
; LMULMAX1-RV64-NEXT:    vmv.v.x v28, a3
; LMULMAX1-RV64-NEXT:    lui a3, 4681
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 585
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 585
; LMULMAX1-RV64-NEXT:    slli a3, a3, 12
; LMULMAX1-RV64-NEXT:    addi a3, a3, 585
; LMULMAX1-RV64-NEXT:    slli a3, a3, 13
; LMULMAX1-RV64-NEXT:    addi a3, a3, 1171
; LMULMAX1-RV64-NEXT:    vmv.s.x v28, a3
; LMULMAX1-RV64-NEXT:    vmulhu.vv v28, v26, v28
; LMULMAX1-RV64-NEXT:    vsub.vv v26, v26, v28
; LMULMAX1-RV64-NEXT:    vmulhu.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX1-RV64-NEXT:    vmv.v.i v27, 3
; LMULMAX1-RV64-NEXT:    vmv.s.x v27, a1
; LMULMAX1-RV64-NEXT:    vsrl.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vmv.v.i v27, 2
; LMULMAX1-RV64-NEXT:    addi a1, zero, 1
; LMULMAX1-RV64-NEXT:    vmv.s.x v27, a1
; LMULMAX1-RV64-NEXT:    lui a1, 1035469
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -819
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -819
; LMULMAX1-RV64-NEXT:    vmv.v.x v28, a1
; LMULMAX1-RV64-NEXT:    lui a1, 1026731
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    slli a1, a1, 12
; LMULMAX1-RV64-NEXT:    addi a1, a1, -1365
; LMULMAX1-RV64-NEXT:    vmv.s.x v28, a1
; LMULMAX1-RV64-NEXT:    vmulhu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vsrl.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = udiv <4 x i64> %a, <i64 3, i64 5, i64 7, i64 9>
  store <4 x i64> %b, <4 x i64>* %x
  ret void
}

define void @mulhs_v32i8(<32 x i8>* %x) {
; LMULMAX2-RV32-LABEL: mulhs_v32i8:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    addi a1, zero, 32
; LMULMAX2-RV32-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    lui a2, 304453
; LMULMAX2-RV32-NEXT:    addi a2, a2, -1452
; LMULMAX2-RV32-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV32-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v28, 7
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV32-NEXT:    addi a1, zero, -123
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV32-NEXT:    addi a1, zero, 57
; LMULMAX2-RV32-NEXT:    vmerge.vxm v30, v30, a1, v0
; LMULMAX2-RV32-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhs_v32i8:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    addi a1, zero, 32
; LMULMAX2-RV64-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    lui a2, 304453
; LMULMAX2-RV64-NEXT:    addiw a2, a2, -1452
; LMULMAX2-RV64-NEXT:    vsetivli a3, 1, e32,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX2-RV64-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v28, 7
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 1, v0
; LMULMAX2-RV64-NEXT:    addi a1, zero, -123
; LMULMAX2-RV64-NEXT:    vmv.v.x v30, a1
; LMULMAX2-RV64-NEXT:    addi a1, zero, 57
; LMULMAX2-RV64-NEXT:    vmerge.vxm v30, v30, a1, v0
; LMULMAX2-RV64-NEXT:    vmulhu.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vsrl.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse8.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhs_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, 5
; LMULMAX1-RV32-NEXT:    addi a2, a2, -1452
; LMULMAX1-RV32-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.i v27, -9
; LMULMAX1-RV32-NEXT:    vmerge.vim v27, v27, 9, v0
; LMULMAX1-RV32-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdivu.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a1)
; LMULMAX1-RV64-NEXT:    lui a2, 5
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -1452
; LMULMAX1-RV64-NEXT:    vsetivli a3, 1, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.s.x v0, a2
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.v.i v27, -9
; LMULMAX1-RV64-NEXT:    vmerge.vim v27, v27, 9, v0
; LMULMAX1-RV64-NEXT:    vdivu.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vdivu.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = udiv <32 x i8> %a, <i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9, i8 9, i8 -9, i8 -9, i8 9, i8 -9>
  store <32 x i8> %b, <32 x i8>* %x
  ret void
}

define void @mulhs_v16i16(<16 x i16>* %x) {
; LMULMAX2-RV32-LABEL: mulhs_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    lui a1, 7
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1687
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1755
; LMULMAX2-RV32-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    lui a1, 1048571
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1755
; LMULMAX2-RV32-NEXT:    vmerge.vxm v28, v28, a1, v0
; LMULMAX2-RV32-NEXT:    vmulh.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vsra.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 15
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhs_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    lui a1, 7
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1687
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e16,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -1755
; LMULMAX2-RV64-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV64-NEXT:    lui a1, 1048571
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1755
; LMULMAX2-RV64-NEXT:    vmerge.vxm v28, v28, a1, v0
; LMULMAX2-RV64-NEXT:    vmulh.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vsra.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 15
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse16.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-LABEL: mulhs_v16i16:
; LMULMAX1:       # %bb.0:
; LMULMAX1-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; LMULMAX1-NEXT:    vle16.v v25, (a0)
; LMULMAX1-NEXT:    addi a1, a0, 16
; LMULMAX1-NEXT:    vle16.v v26, (a1)
; LMULMAX1-NEXT:    addi a2, zero, 105
; LMULMAX1-NEXT:    vsetivli a3, 1, e8,m1,ta,mu
; LMULMAX1-NEXT:    vmv.s.x v0, a2
; LMULMAX1-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-NEXT:    vmv.v.i v27, 7
; LMULMAX1-NEXT:    vmerge.vim v27, v27, -7, v0
; LMULMAX1-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-NEXT:    vdiv.vv v25, v25, v27
; LMULMAX1-NEXT:    vse16.v v25, (a0)
; LMULMAX1-NEXT:    vse16.v v26, (a1)
; LMULMAX1-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = sdiv <16 x i16> %a, <i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7, i16 -7, i16 7, i16 7, i16 -7, i16 7, i16 -7, i16 -7, i16 7>
  store <16 x i16> %b, <16 x i16>* %x
  ret void
}

define void @mulhs_v8i32(<8 x i32>* %x) {
; LMULMAX2-RV32-LABEL: mulhs_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi a1, zero, 85
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    lui a1, 419430
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1639
; LMULMAX2-RV32-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV32-NEXT:    lui a1, 629146
; LMULMAX2-RV32-NEXT:    addi a1, a1, -1639
; LMULMAX2-RV32-NEXT:    vmerge.vxm v28, v28, a1, v0
; LMULMAX2-RV32-NEXT:    vmulh.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vsrl.vi v28, v26, 31
; LMULMAX2-RV32-NEXT:    vsra.vi v26, v26, 1
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhs_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    lui a1, 13107
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 973
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, -819
; LMULMAX2-RV64-NEXT:    slli a1, a1, 13
; LMULMAX2-RV64-NEXT:    addi a1, a1, -1639
; LMULMAX2-RV64-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.x v28, a1
; LMULMAX2-RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmulh.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vsra.vi v26, v26, 1
; LMULMAX2-RV64-NEXT:    vsrl.vi v28, v26, 31
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse32.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhs_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    addi a2, zero, 5
; LMULMAX1-RV32-NEXT:    vsetivli a3, 1, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a2
; LMULMAX1-RV32-NEXT:    lui a2, 419430
; LMULMAX1-RV32-NEXT:    addi a2, a2, 1639
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v27, a2
; LMULMAX1-RV32-NEXT:    lui a2, 629146
; LMULMAX1-RV32-NEXT:    addi a2, a2, -1639
; LMULMAX1-RV32-NEXT:    vmerge.vxm v27, v27, a2, v0
; LMULMAX1-RV32-NEXT:    vmulh.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v28, v26, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v26, v26, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX1-RV32-NEXT:    vmulh.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vsrl.vi v27, v25, 31
; LMULMAX1-RV32-NEXT:    vsra.vi v25, v25, 1
; LMULMAX1-RV32-NEXT:    vadd.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a1)
; LMULMAX1-RV64-NEXT:    addi a2, zero, 3
; LMULMAX1-RV64-NEXT:    slli a2, a2, 33
; LMULMAX1-RV64-NEXT:    addi a2, a2, -5
; LMULMAX1-RV64-NEXT:    vsetivli a3, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmv.v.x v27, a2
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vdiv.vv v25, v25, v27
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = sdiv <8 x i32> %a, <i32 -5, i32 5, i32 -5, i32 5, i32 -5, i32 5, i32 -5, i32 5>
  store <8 x i32> %b, <8 x i32>* %x
  ret void
}

define void @mulhs_v4i64(<4 x i64>* %x) {
; LMULMAX2-RV32-LABEL: mulhs_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    addi a1, zero, 51
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v28, -1
; LMULMAX2-RV32-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmul.vv v28, v26, v28
; LMULMAX2-RV32-NEXT:    addi a1, zero, 17
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a2, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli a3, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v30, a2
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1366
; LMULMAX2-RV32-NEXT:    vmerge.vxm v30, v30, a1, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmulh.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    addi a1, zero, 63
; LMULMAX2-RV32-NEXT:    vsrl.vx v28, v26, a1
; LMULMAX2-RV32-NEXT:    addi a1, zero, 68
; LMULMAX2-RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v30, 0
; LMULMAX2-RV32-NEXT:    vmerge.vim v30, v30, 1, v0
; LMULMAX2-RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV32-NEXT:    vsra.vv v26, v26, v30
; LMULMAX2-RV32-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV32-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: mulhs_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    addi a1, zero, 5
; LMULMAX2-RV64-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.s.x v0, a1
; LMULMAX2-RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; LMULMAX2-RV64-NEXT:    vmv.v.i v28, -1
; LMULMAX2-RV64-NEXT:    vmerge.vim v28, v28, 0, v0
; LMULMAX2-RV64-NEXT:    vmul.vv v28, v26, v28
; LMULMAX2-RV64-NEXT:    lui a1, 21845
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV64-NEXT:    slli a1, a1, 12
; LMULMAX2-RV64-NEXT:    addi a2, a1, 1365
; LMULMAX2-RV64-NEXT:    vmv.v.x v30, a2
; LMULMAX2-RV64-NEXT:    addi a1, a1, 1366
; LMULMAX2-RV64-NEXT:    vmerge.vxm v30, v30, a1, v0
; LMULMAX2-RV64-NEXT:    vmulh.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    addi a1, zero, 63
; LMULMAX2-RV64-NEXT:    vsrl.vx v28, v26, a1
; LMULMAX2-RV64-NEXT:    vmv.v.i v30, 1
; LMULMAX2-RV64-NEXT:    vmerge.vim v30, v30, 0, v0
; LMULMAX2-RV64-NEXT:    vsra.vv v26, v26, v30
; LMULMAX2-RV64-NEXT:    vadd.vv v26, v26, v28
; LMULMAX2-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: mulhs_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    lui a2, %hi(.LCPI136_0)
; LMULMAX1-RV32-NEXT:    addi a2, a2, %lo(.LCPI136_0)
; LMULMAX1-RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vdiv.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vdiv.vv v25, v25, v27
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: mulhs_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vmv.v.i v27, -1
; LMULMAX1-RV64-NEXT:    vmv.s.x v27, zero
; LMULMAX1-RV64-NEXT:    vmul.vv v28, v25, v27
; LMULMAX1-RV64-NEXT:    lui a2, 21845
; LMULMAX1-RV64-NEXT:    addiw a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1365
; LMULMAX1-RV64-NEXT:    slli a2, a2, 12
; LMULMAX1-RV64-NEXT:    addi a3, a2, 1365
; LMULMAX1-RV64-NEXT:    vmv.v.x v29, a3
; LMULMAX1-RV64-NEXT:    addi a2, a2, 1366
; LMULMAX1-RV64-NEXT:    vmv.s.x v29, a2
; LMULMAX1-RV64-NEXT:    vmulh.vv v25, v25, v29
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    addi a2, zero, 63
; LMULMAX1-RV64-NEXT:    vsrl.vx v28, v25, a2
; LMULMAX1-RV64-NEXT:    vid.v v30
; LMULMAX1-RV64-NEXT:    vsra.vv v25, v25, v30
; LMULMAX1-RV64-NEXT:    vadd.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vmul.vv v27, v26, v27
; LMULMAX1-RV64-NEXT:    vmulh.vv v26, v26, v29
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vsrl.vx v27, v26, a2
; LMULMAX1-RV64-NEXT:    vsra.vv v26, v26, v30
; LMULMAX1-RV64-NEXT:    vadd.vv v26, v26, v27
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = sdiv <4 x i64> %a, <i64 3, i64 -3, i64 3, i64 -3>
  store <4 x i64> %b, <4 x i64>* %x
  ret void
}

define void @smin_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: smin_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp slt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @smin_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: smin_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp slt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @smin_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: smin_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp slt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @smin_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: smin_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmin.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smin_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmin.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smin_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmin.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmin.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp slt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @smax_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: smax_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp sgt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @smax_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: smax_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp sgt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @smax_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: smax_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp sgt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @smax_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: smax_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmax.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: smax_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmax.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: smax_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmax.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmax.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp sgt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @umin_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: umin_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp ult <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @umin_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: umin_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp ult <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @umin_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: umin_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp ult <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @umin_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: umin_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vminu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umin_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vminu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umin_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vminu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vminu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp ult <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @umax_v32i8(<32 x i8>* %x, <32 x i8>* %y) {
; LMULMAX2-LABEL: umax_v32i8:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vle8.v v26, (a0)
; LMULMAX2-NEXT:    vle8.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse8.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v32i8:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle8.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v32i8:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle8.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle8.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse8.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse8.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <32 x i8>, <32 x i8>* %x
  %b = load <32 x i8>, <32 x i8>* %y
  %cc = icmp ugt <32 x i8> %a, %b
  %c = select <32 x i1> %cc, <32 x i8> %a, <32 x i8> %b
  store <32 x i8> %c, <32 x i8>* %x
  ret void
}

define void @umax_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-LABEL: umax_v16i16:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 16, e16,m2,ta,mu
; LMULMAX2-NEXT:    vle16.v v26, (a0)
; LMULMAX2-NEXT:    vle16.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse16.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle16.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle16.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse16.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %cc = icmp ugt <16 x i16> %a, %b
  %c = select <16 x i1> %cc, <16 x i16> %a, <16 x i16> %b
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}

define void @umax_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-LABEL: umax_v8i32:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 8, e32,m2,ta,mu
; LMULMAX2-NEXT:    vle32.v v26, (a0)
; LMULMAX2-NEXT:    vle32.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse32.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle32.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle32.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse32.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %cc = icmp ugt <8 x i32> %a, %b
  %c = select <8 x i1> %cc, <8 x i32> %a, <8 x i32> %b
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}

define void @umax_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-LABEL: umax_v4i64:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    vsetivli a2, 4, e64,m2,ta,mu
; LMULMAX2-NEXT:    vle64.v v26, (a0)
; LMULMAX2-NEXT:    vle64.v v28, (a1)
; LMULMAX2-NEXT:    vmaxu.vv v26, v26, v28
; LMULMAX2-NEXT:    vse64.v v26, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: umax_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    addi a2, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    addi a3, a1, 16
; LMULMAX1-RV32-NEXT:    vle64.v v27, (a3)
; LMULMAX1-RV32-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV32-NEXT:    vmaxu.vv v26, v26, v27
; LMULMAX1-RV32-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV32-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: umax_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli a2, 2, e64,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vle64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    addi a2, a1, 16
; LMULMAX1-RV64-NEXT:    vle64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    addi a2, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v27, (a2)
; LMULMAX1-RV64-NEXT:    vle64.v v28, (a1)
; LMULMAX1-RV64-NEXT:    vmaxu.vv v26, v27, v26
; LMULMAX1-RV64-NEXT:    vmaxu.vv v25, v25, v28
; LMULMAX1-RV64-NEXT:    vse64.v v25, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v26, (a2)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %cc = icmp ugt <4 x i64> %a, %b
  %c = select <4 x i1> %cc, <4 x i64> %a, <4 x i64> %b
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}

define void @add_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: add_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: add_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: add_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, -1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_vi_v2i64(<2 x i64>* %x) {
; RV32-LABEL: add_vi_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: add_vi_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vadd.vi v25, v25, -1
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 -1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = add <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @add_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: add_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: add_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: add_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_iv_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: add_iv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vadd.vi v25, v25, 1
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = add <2 x i64> %c, %a
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @add_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: add_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: add_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: add_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @add_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: add_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = add <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @add_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: add_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = add <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @add_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: add_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vadd.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = add <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: sub_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: sub_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: sub_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -1
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_vi_v2i64(<2 x i64>* %x) {
; RV32-LABEL: sub_vi_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vsub.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: sub_vi_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    addi a1, zero, -1
; RV64-NEXT:    vsub.vx v25, v25, a1
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 -1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = sub <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @sub_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: sub_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: sub_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: sub_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_iv_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: sub_iv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vrsub.vi v25, v25, 1
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = sub <2 x i64> %c, %a
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @sub_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sub_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sub_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sub_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sub_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sub_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sub <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sub_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sub_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sub <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sub_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sub_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrsub.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sub <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mul_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: mul_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = mul <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @mul_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: mul_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = mul <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @mul_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: mul_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = mul <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mul_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: mul_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = mul <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @mul_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: mul_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = mul <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @mul_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: mul_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmul.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = mul <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: and_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -2, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: and_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -2, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: and_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -2, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_vi_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: and_vi_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, -2
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 -2, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = and <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @and_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: and_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: and_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: and_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_iv_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: and_iv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vand.vi v25, v25, 1
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = and <2 x i64> %c, %a
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @and_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: and_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: and_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: and_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @and_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: and_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = and <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @and_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: and_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = and <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @and_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: and_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vand.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = and <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: or_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -2, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: or_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -2, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: or_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -2, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_vi_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: or_vi_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, -2
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 -2, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = or <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @or_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: or_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: or_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: or_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_iv_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: or_iv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vor.vi v25, v25, 1
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = or <2 x i64> %c, %a
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @or_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: or_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: or_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: or_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @or_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: or_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = or <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @or_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: or_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = or <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @or_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: or_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = or <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: xor_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 -1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: xor_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 -1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: xor_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, -1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 -1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_vi_v2i64(<2 x i64>* %x) {
; RV32-LABEL: xor_vi_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vxor.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: xor_vi_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vxor.vi v25, v25, -1
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 -1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = xor <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @xor_iv_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: xor_iv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 1, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_iv_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: xor_iv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 1, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_iv_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: xor_iv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 1, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_iv_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: xor_iv_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vxor.vi v25, v25, 1
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 1, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = xor <2 x i64> %c, %a
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @xor_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: xor_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: xor_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: xor_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @xor_xv_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: xor_xv_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = xor <16 x i8> %c, %a
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @xor_xv_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: xor_xv_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = xor <8 x i16> %c, %a
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @xor_xv_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: xor_xv_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vxor.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = xor <4 x i32> %c, %a
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @lshr_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: lshr_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = lshr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @lshr_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: lshr_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = lshr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @lshr_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: lshr_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = lshr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @lshr_vi_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: lshr_vi_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vsrl.vi v25, v25, 31
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 31, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = lshr <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @lshr_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: lshr_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = lshr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @lshr_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: lshr_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = lshr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @lshr_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: lshr_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsrl.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = lshr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @ashr_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: ashr_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = ashr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @ashr_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: ashr_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = ashr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @ashr_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: ashr_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = ashr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @ashr_vi_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: ashr_vi_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vsra.vi v25, v25, 31
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 31, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = ashr <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @ashr_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: ashr_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = ashr <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @ashr_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: ashr_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = ashr <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @ashr_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: ashr_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsra.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = ashr <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @shl_vi_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: shl_vi_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 7, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = shl <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @shl_vi_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: shl_vi_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 15
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 15, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = shl <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @shl_vi_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: shl_vi_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 31
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 31, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = shl <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @shl_vi_v2i64(<2 x i64>* %x) {
; CHECK-LABEL: shl_vi_v2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; CHECK-NEXT:    vle64.v v25, (a0)
; CHECK-NEXT:    vsll.vi v25, v25, 31
; CHECK-NEXT:    vse64.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = insertelement <2 x i64> undef, i64 31, i32 0
  %c = shufflevector <2 x i64> %b, <2 x i64> undef, <2 x i32> zeroinitializer
  %d = shl <2 x i64> %a, %c
  store <2 x i64> %d, <2 x i64>* %x
  ret void
}

define void @shl_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: shl_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = shl <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @shl_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: shl_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = shl <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @shl_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: shl_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsll.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = shl <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @sdiv_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: sdiv_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = sdiv <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @sdiv_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: sdiv_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = sdiv <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @sdiv_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: sdiv_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vdiv.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = sdiv <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @srem_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: srem_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = srem <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @srem_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: srem_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = srem <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @srem_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: srem_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vrem.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = srem <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @udiv_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: udiv_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = udiv <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @udiv_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: udiv_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = udiv <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @udiv_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: udiv_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vdivu.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = udiv <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @urem_vx_v16i8(<16 x i8>* %x, i8 %y) {
; CHECK-LABEL: urem_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = insertelement <16 x i8> undef, i8 %y, i32 0
  %c = shufflevector <16 x i8> %b, <16 x i8> undef, <16 x i32> zeroinitializer
  %d = urem <16 x i8> %a, %c
  store <16 x i8> %d, <16 x i8>* %x
  ret void
}

define void @urem_vx_v8i16(<8 x i16>* %x, i16 %y) {
; CHECK-LABEL: urem_vx_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse16.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = insertelement <8 x i16> undef, i16 %y, i32 0
  %c = shufflevector <8 x i16> %b, <8 x i16> undef, <8 x i32> zeroinitializer
  %d = urem <8 x i16> %a, %c
  store <8 x i16> %d, <8 x i16>* %x
  ret void
}

define void @urem_vx_v4i32(<4 x i32>* %x, i32 %y) {
; CHECK-LABEL: urem_vx_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a2, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vremu.vx v25, v25, a1
; CHECK-NEXT:    vse32.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = insertelement <4 x i32> undef, i32 %y, i32 0
  %c = shufflevector <4 x i32> %b, <4 x i32> undef, <4 x i32> zeroinitializer
  %d = urem <4 x i32> %a, %c
  store <4 x i32> %d, <4 x i32>* %x
  ret void
}

define void @mulhu_vx_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhu_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, 57
; CHECK-NEXT:    vmulhu.vx v25, v25, a1
; CHECK-NEXT:    vsrl.vi v25, v25, 1
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9, i8 9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhu_vx_v8i16(<8 x i16>* %x) {
; RV32-LABEL: mulhu_vx_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    lui a1, 2
; RV32-NEXT:    addi a1, a1, 1171
; RV32-NEXT:    vmulhu.vx v26, v25, a1
; RV32-NEXT:    vsub.vv v25, v25, v26
; RV32-NEXT:    vsrl.vi v25, v25, 1
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vsrl.vi v25, v25, 2
; RV32-NEXT:    vse16.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhu_vx_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    lui a1, 2
; RV64-NEXT:    addiw a1, a1, 1171
; RV64-NEXT:    vmulhu.vx v26, v25, a1
; RV64-NEXT:    vsub.vv v25, v25, v26
; RV64-NEXT:    vsrl.vi v25, v25, 1
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vsrl.vi v25, v25, 2
; RV64-NEXT:    vse16.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = udiv <8 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhu_vx_v4i32(<4 x i32>* %x) {
; RV32-LABEL: mulhu_vx_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v25, (a0)
; RV32-NEXT:    lui a1, 838861
; RV32-NEXT:    addi a1, a1, -819
; RV32-NEXT:    vmulhu.vx v25, v25, a1
; RV32-NEXT:    vsrl.vi v25, v25, 2
; RV32-NEXT:    vse32.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhu_vx_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV64-NEXT:    vle32.v v25, (a0)
; RV64-NEXT:    lui a1, 838861
; RV64-NEXT:    addiw a1, a1, -819
; RV64-NEXT:    vmulhu.vx v25, v25, a1
; RV64-NEXT:    vsrl.vi v25, v25, 2
; RV64-NEXT:    vse32.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = udiv <4 x i32> %a, <i32 5, i32 5, i32 5, i32 5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhu_vx_v2i64(<2 x i64>* %x) {
; RV32-LABEL: mulhu_vx_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    addi a1, zero, 5
; RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    lui a1, 699051
; RV32-NEXT:    addi a2, a1, -1366
; RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a2
; RV32-NEXT:    addi a1, a1, -1365
; RV32-NEXT:    vmerge.vxm v26, v26, a1, v0
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vmulhu.vv v25, v25, v26
; RV32-NEXT:    vsrl.vi v25, v25, 1
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhu_vx_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    lui a1, 1026731
; RV64-NEXT:    addiw a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, -1365
; RV64-NEXT:    vmulhu.vx v25, v25, a1
; RV64-NEXT:    vsrl.vi v25, v25, 1
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = udiv <2 x i64> %a, <i64 3, i64 3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}

define void @mulhs_vx_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: mulhs_vx_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a1, zero, -123
; CHECK-NEXT:    vmulhu.vx v25, v25, a1
; CHECK-NEXT:    vsrl.vi v25, v25, 7
; CHECK-NEXT:    vse8.v v25, (a0)
; CHECK-NEXT:    ret
  %a = load <16 x i8>, <16 x i8>* %x
  %b = udiv <16 x i8> %a, <i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9, i8 -9>
  store <16 x i8> %b, <16 x i8>* %x
  ret void
}

define void @mulhs_vx_v8i16(<8 x i16>* %x) {
; RV32-LABEL: mulhs_vx_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    lui a1, 5
; RV32-NEXT:    addi a1, a1, -1755
; RV32-NEXT:    vmulh.vx v25, v25, a1
; RV32-NEXT:    vsra.vi v25, v25, 1
; RV32-NEXT:    vsrl.vi v26, v25, 15
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse16.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_vx_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    lui a1, 5
; RV64-NEXT:    addiw a1, a1, -1755
; RV64-NEXT:    vmulh.vx v25, v25, a1
; RV64-NEXT:    vsra.vi v25, v25, 1
; RV64-NEXT:    vsrl.vi v26, v25, 15
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse16.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = sdiv <8 x i16> %a, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  store <8 x i16> %b, <8 x i16>* %x
  ret void
}

define void @mulhs_vx_v4i32(<4 x i32>* %x) {
; RV32-LABEL: mulhs_vx_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v25, (a0)
; RV32-NEXT:    lui a1, 629146
; RV32-NEXT:    addi a1, a1, -1639
; RV32-NEXT:    vmulh.vx v25, v25, a1
; RV32-NEXT:    vsrl.vi v26, v25, 31
; RV32-NEXT:    vsra.vi v25, v25, 1
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse32.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_vx_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV64-NEXT:    vle32.v v25, (a0)
; RV64-NEXT:    lui a1, 629146
; RV64-NEXT:    addiw a1, a1, -1639
; RV64-NEXT:    vmulh.vx v25, v25, a1
; RV64-NEXT:    vsra.vi v25, v25, 1
; RV64-NEXT:    vsrl.vi v26, v25, 31
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse32.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = sdiv <4 x i32> %a, <i32 -5, i32 -5, i32 -5, i32 -5>
  store <4 x i32> %b, <4 x i32>* %x
  ret void
}

define void @mulhs_vx_v2i64(<2 x i64>* %x) {
; RV32-LABEL: mulhs_vx_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    addi a1, zero, 5
; RV32-NEXT:    vsetivli a2, 1, e8,m1,ta,mu
; RV32-NEXT:    vmv.s.x v0, a1
; RV32-NEXT:    lui a1, 349525
; RV32-NEXT:    addi a2, a1, 1365
; RV32-NEXT:    vsetivli a3, 4, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a2
; RV32-NEXT:    addi a1, a1, 1366
; RV32-NEXT:    vmerge.vxm v26, v26, a1, v0
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vmulh.vv v25, v25, v26
; RV32-NEXT:    addi a1, zero, 63
; RV32-NEXT:    vsrl.vx v26, v25, a1
; RV32-NEXT:    vadd.vv v25, v25, v26
; RV32-NEXT:    vse64.v v25, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: mulhs_vx_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    lui a1, 21845
; RV64-NEXT:    addiw a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 1365
; RV64-NEXT:    slli a1, a1, 12
; RV64-NEXT:    addi a1, a1, 1366
; RV64-NEXT:    vmulh.vx v25, v25, a1
; RV64-NEXT:    addi a1, zero, 63
; RV64-NEXT:    vsrl.vx v26, v25, a1
; RV64-NEXT:    vadd.vv v25, v25, v26
; RV64-NEXT:    vse64.v v25, (a0)
; RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = sdiv <2 x i64> %a, <i64 3, i64 3>
  store <2 x i64> %b, <2 x i64>* %x
  ret void
}
