; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX2
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,LMULMAX1-RV64

define void @splat_ones_v1i1(<1 x i1>* %x) {
; CHECK-LABEL: splat_ones_v1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vmset.m v25
; CHECK-NEXT:    vse1.v v25, (a0)
; CHECK-NEXT:    ret
  store <1 x i1> <i1 1>, <1 x i1>* %x
  ret void
}

define void @splat_zeros_v2i1(<2 x i1>* %x) {
; CHECK-LABEL: splat_zeros_v2i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vmclr.m v25
; CHECK-NEXT:    vse1.v v25, (a0)
; CHECK-NEXT:    ret
  store <2 x i1> zeroinitializer, <2 x i1>* %x
  ret void
}

define void @splat_ones_v4i1(<4 x i1>* %x) {
; CHECK-LABEL: splat_ones_v4i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vmset.m v25
; CHECK-NEXT:    vse1.v v25, (a0)
; CHECK-NEXT:    ret
  store <4 x i1> <i1 1, i1 1, i1 1, i1 1>, <4 x i1>* %x
  ret void
}

define void @splat_zeros_v8i1(<8 x i1>* %x) {
; CHECK-LABEL: splat_zeros_v8i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vmclr.m v25
; CHECK-NEXT:    vse1.v v25, (a0)
; CHECK-NEXT:    ret
  store <8 x i1> zeroinitializer, <8 x i1>* %x
  ret void
}

define void @splat_ones_v16i1(<16 x i1>* %x) {
; CHECK-LABEL: splat_ones_v16i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vmset.m v25
; CHECK-NEXT:    vse1.v v25, (a0)
; CHECK-NEXT:    ret
  store <16 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, <16 x i1>* %x
  ret void
}

define void @splat_zeros_v32i1(<32 x i1>* %x) {
; LMULMAX2-LABEL: splat_zeros_v32i1:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a1, zero, 32
; LMULMAX2-NEXT:    vsetvli a1, a1, e8,m2,ta,mu
; LMULMAX2-NEXT:    vmclr.m v25
; LMULMAX2-NEXT:    vse1.v v25, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: splat_zeros_v32i1:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi a1, a0, 2
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmclr.m v25
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: splat_zeros_v32i1:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi a1, a0, 2
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmclr.m v25
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  store <32 x i1> zeroinitializer, <32 x i1>* %x
  ret void
}

define void @splat_ones_v64i1(<64 x i1>* %x) {
; LMULMAX2-LABEL: splat_ones_v64i1:
; LMULMAX2:       # %bb.0:
; LMULMAX2-NEXT:    addi a1, a0, 4
; LMULMAX2-NEXT:    addi a2, zero, 32
; LMULMAX2-NEXT:    vsetvli a2, a2, e8,m2,ta,mu
; LMULMAX2-NEXT:    vmset.m v25
; LMULMAX2-NEXT:    vse1.v v25, (a1)
; LMULMAX2-NEXT:    vse1.v v25, (a0)
; LMULMAX2-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: splat_ones_v64i1:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    addi a1, a0, 6
; LMULMAX1-RV32-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV32-NEXT:    vmset.m v25
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 4
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV32-NEXT:    addi a1, a0, 2
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV32-NEXT:    vse1.v v25, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: splat_ones_v64i1:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    addi a1, a0, 6
; LMULMAX1-RV64-NEXT:    vsetivli a2, 16, e8,m1,ta,mu
; LMULMAX1-RV64-NEXT:    vmset.m v25
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, a0, 4
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV64-NEXT:    addi a1, a0, 2
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a1)
; LMULMAX1-RV64-NEXT:    vse1.v v25, (a0)
; LMULMAX1-RV64-NEXT:    ret
  store <64 x i1> <i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1, i1 1>, <64 x i1>* %x
  ret void
}
