; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+m,+experimental-v -verify-machineinstrs -riscv-v-vector-bits-min=128  -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64

declare i8 @llvm.vector.reduce.add.v1i8(<1 x i8>)

define i8 @vreduce_add_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v2i8(<2 x i8>)

define i8 @vreduce_add_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v4i8(<4 x i8>)

define i8 @vreduce_add_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v8i8(<8 x i8>)

define i8 @vreduce_add_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v16i8(<16 x i8>)

define i8 @vreduce_add_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v32i8(<32 x i8>)

define i8 @vreduce_add_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v64i8(<64 x i8>)

define i8 @vreduce_add_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v128i8(<128 x i8>)

define i8 @vreduce_add_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.add.v256i8(<256 x i8>)

define i8 @vreduce_add_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_add_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.add.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.add.v1i16(<1 x i16>)

define i16 @vreduce_add_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v2i16(<2 x i16>)

define i16 @vreduce_add_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v4i16(<4 x i16>)

define i16 @vreduce_add_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v8i16(<8 x i16>)

define i16 @vreduce_add_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v16i16(<16 x i16>)

define i16 @vreduce_add_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v32i16(<32 x i16>)

define i16 @vreduce_add_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v64i16(<64 x i16>)

define i16 @vreduce_add_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.add.v128i16(<128 x i16>)

define i16 @vreduce_add_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_add_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.add.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.add.v1i32(<1 x i32>)

define i32 @vreduce_add_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v2i32(<2 x i32>)

define i32 @vreduce_add_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v4i32(<4 x i32>)

define i32 @vreduce_add_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v8i32(<8 x i32>)

define i32 @vreduce_add_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v16i32(<16 x i32>)

define i32 @vreduce_add_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v32i32(<32 x i32>)

define i32 @vreduce_add_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.add.v64i32(<64 x i32>)

define i32 @vreduce_add_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_add_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vadd.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredsum.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.add.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.add.v1i64(<1 x i64>)

define i64 @vreduce_add_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_add_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v2i64(<2 x i64>)

define i64 @vreduce_add_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_add_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredsum.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredsum.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v4i64(<4 x i64>)

define i64 @vreduce_add_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_add_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredsum.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredsum.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v8i64(<8 x i64>)

define i64 @vreduce_add_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_add_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredsum.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredsum.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v16i64(<16 x i64>)

define i64 @vreduce_add_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_add_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredsum.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredsum.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v32i64(<32 x i64>)

define i64 @vreduce_add_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_add_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredsum.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredsum.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.add.v64i64(<64 x i64>)

define i64 @vreduce_add_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_add_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vadd.vv v16, v24, v16
; RV32-NEXT:    vadd.vv v8, v8, v0
; RV32-NEXT:    vadd.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredsum.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_add_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vadd.vv v16, v24, v16
; RV64-NEXT:    vadd.vv v8, v8, v0
; RV64-NEXT:    vadd.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredsum.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.add.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.and.v1i8(<1 x i8>)

define i8 @vreduce_and_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v2i8(<2 x i8>)

define i8 @vreduce_and_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v4i8(<4 x i8>)

define i8 @vreduce_and_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v8i8(<8 x i8>)

define i8 @vreduce_and_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v16i8(<16 x i8>)

define i8 @vreduce_and_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v32i8(<32 x i8>)

define i8 @vreduce_and_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredand.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v64i8(<64 x i8>)

define i8 @vreduce_and_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredand.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v128i8(<128 x i8>)

define i8 @vreduce_and_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.and.v256i8(<256 x i8>)

define i8 @vreduce_and_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_and_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.and.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.and.v1i16(<1 x i16>)

define i16 @vreduce_and_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v2i16(<2 x i16>)

define i16 @vreduce_and_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v4i16(<4 x i16>)

define i16 @vreduce_and_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v8i16(<8 x i16>)

define i16 @vreduce_and_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v16i16(<16 x i16>)

define i16 @vreduce_and_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredand.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v32i16(<32 x i16>)

define i16 @vreduce_and_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredand.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v64i16(<64 x i16>)

define i16 @vreduce_and_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.and.v128i16(<128 x i16>)

define i16 @vreduce_and_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_and_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.and.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.and.v1i32(<1 x i32>)

define i32 @vreduce_and_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v2i32(<2 x i32>)

define i32 @vreduce_and_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v4i32(<4 x i32>)

define i32 @vreduce_and_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredand.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v8i32(<8 x i32>)

define i32 @vreduce_and_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredand.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v16i32(<16 x i32>)

define i32 @vreduce_and_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredand.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v32i32(<32 x i32>)

define i32 @vreduce_and_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.and.v64i32(<64 x i32>)

define i32 @vreduce_and_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_and_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vand.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredand.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.and.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.and.v1i64(<1 x i64>)

define i64 @vreduce_and_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_and_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v2i64(<2 x i64>)

define i64 @vreduce_and_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_and_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredand.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, -1
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredand.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v4i64(<4 x i64>)

define i64 @vreduce_and_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_and_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredand.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredand.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v8i64(<8 x i64>)

define i64 @vreduce_and_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_and_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredand.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredand.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v16i64(<16 x i64>)

define i64 @vreduce_and_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_and_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredand.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredand.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v32i64(<32 x i64>)

define i64 @vreduce_and_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_and_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredand.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vand.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredand.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.and.v64i64(<64 x i64>)

define i64 @vreduce_and_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_and_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vand.vv v16, v24, v16
; RV32-NEXT:    vand.vv v8, v8, v0
; RV32-NEXT:    vand.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredand.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_and_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vand.vv v16, v24, v16
; RV64-NEXT:    vand.vv v8, v8, v0
; RV64-NEXT:    vand.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredand.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.and.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.or.v1i8(<1 x i8>)

define i8 @vreduce_or_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v2i8(<2 x i8>)

define i8 @vreduce_or_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v4i8(<4 x i8>)

define i8 @vreduce_or_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v8i8(<8 x i8>)

define i8 @vreduce_or_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v16i8(<16 x i8>)

define i8 @vreduce_or_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v32i8(<32 x i8>)

define i8 @vreduce_or_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v64i8(<64 x i8>)

define i8 @vreduce_or_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v128i8(<128 x i8>)

define i8 @vreduce_or_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.or.v256i8(<256 x i8>)

define i8 @vreduce_or_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_or_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.or.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.or.v1i16(<1 x i16>)

define i16 @vreduce_or_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v2i16(<2 x i16>)

define i16 @vreduce_or_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v4i16(<4 x i16>)

define i16 @vreduce_or_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v8i16(<8 x i16>)

define i16 @vreduce_or_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v16i16(<16 x i16>)

define i16 @vreduce_or_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v32i16(<32 x i16>)

define i16 @vreduce_or_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v64i16(<64 x i16>)

define i16 @vreduce_or_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.or.v128i16(<128 x i16>)

define i16 @vreduce_or_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_or_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.or.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.or.v1i32(<1 x i32>)

define i32 @vreduce_or_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v2i32(<2 x i32>)

define i32 @vreduce_or_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v4i32(<4 x i32>)

define i32 @vreduce_or_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v8i32(<8 x i32>)

define i32 @vreduce_or_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v16i32(<16 x i32>)

define i32 @vreduce_or_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v32i32(<32 x i32>)

define i32 @vreduce_or_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.or.v64i32(<64 x i32>)

define i32 @vreduce_or_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_or_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.or.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.or.v1i64(<1 x i64>)

define i64 @vreduce_or_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_or_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v2i64(<2 x i64>)

define i64 @vreduce_or_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_or_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredor.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredor.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v4i64(<4 x i64>)

define i64 @vreduce_or_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_or_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredor.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredor.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v8i64(<8 x i64>)

define i64 @vreduce_or_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_or_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredor.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredor.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v16i64(<16 x i64>)

define i64 @vreduce_or_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_or_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v32i64(<32 x i64>)

define i64 @vreduce_or_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_or_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.or.v64i64(<64 x i64>)

define i64 @vreduce_or_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_or_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vor.vv v16, v24, v16
; RV32-NEXT:    vor.vv v8, v8, v0
; RV32-NEXT:    vor.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_or_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vor.vv v16, v24, v16
; RV64-NEXT:    vor.vv v8, v8, v0
; RV64-NEXT:    vor.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.or.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.xor.v1i8(<1 x i8>)

define i8 @vreduce_xor_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v2i8(<2 x i8>)

define i8 @vreduce_xor_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v4i8(<4 x i8>)

define i8 @vreduce_xor_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v8i8(<8 x i8>)

define i8 @vreduce_xor_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v16i8(<16 x i8>)

define i8 @vreduce_xor_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v32i8(<32 x i8>)

define i8 @vreduce_xor_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v64i8(<64 x i8>)

define i8 @vreduce_xor_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v128i8(<128 x i8>)

define i8 @vreduce_xor_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.xor.v256i8(<256 x i8>)

define i8 @vreduce_xor_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_xor_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vxor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.xor.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.xor.v1i16(<1 x i16>)

define i16 @vreduce_xor_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v2i16(<2 x i16>)

define i16 @vreduce_xor_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v4i16(<4 x i16>)

define i16 @vreduce_xor_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v8i16(<8 x i16>)

define i16 @vreduce_xor_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v16i16(<16 x i16>)

define i16 @vreduce_xor_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v32i16(<32 x i16>)

define i16 @vreduce_xor_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v64i16(<64 x i16>)

define i16 @vreduce_xor_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.xor.v128i16(<128 x i16>)

define i16 @vreduce_xor_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_xor_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vxor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.xor.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.xor.v1i32(<1 x i32>)

define i32 @vreduce_xor_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v2i32(<2 x i32>)

define i32 @vreduce_xor_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v4i32(<4 x i32>)

define i32 @vreduce_xor_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v8i32(<8 x i32>)

define i32 @vreduce_xor_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v16i32(<16 x i32>)

define i32 @vreduce_xor_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v32i32(<32 x i32>)

define i32 @vreduce_xor_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.xor.v64i32(<64 x i32>)

define i32 @vreduce_xor_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_xor_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vxor.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredxor.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.xor.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.xor.v1i64(<1 x i64>)

define i64 @vreduce_xor_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v2i64(<2 x i64>)

define i64 @vreduce_xor_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredxor.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredxor.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v4i64(<4 x i64>)

define i64 @vreduce_xor_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredxor.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredxor.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v8i64(<8 x i64>)

define i64 @vreduce_xor_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredxor.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredxor.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v16i64(<16 x i64>)

define i64 @vreduce_xor_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredxor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredxor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v32i64(<32 x i64>)

define i64 @vreduce_xor_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_xor_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vxor.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredxor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vxor.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredxor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.xor.v64i64(<64 x i64>)

define i64 @vreduce_xor_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_xor_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vxor.vv v16, v24, v16
; RV32-NEXT:    vxor.vv v8, v8, v0
; RV32-NEXT:    vxor.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredxor.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_xor_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vxor.vv v16, v24, v16
; RV64-NEXT:    vxor.vv v8, v8, v0
; RV64-NEXT:    vxor.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredxor.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.xor.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.smin.v1i8(<1 x i8>)

define i8 @vreduce_smin_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v2i8(<2 x i8>)

define i8 @vreduce_smin_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v4i8(<4 x i8>)

define i8 @vreduce_smin_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v8i8(<8 x i8>)

define i8 @vreduce_smin_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v16i8(<16 x i8>)

define i8 @vreduce_smin_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v32i8(<32 x i8>)

define i8 @vreduce_smin_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v64i8(<64 x i8>)

define i8 @vreduce_smin_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v128i8(<128 x i8>)

define i8 @vreduce_smin_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smin.v256i8(<256 x i8>)

define i8 @vreduce_smin_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_smin_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vmin.vv v8, v8, v16
; CHECK-NEXT:    addi a0, zero, 127
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmin.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smin.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.smin.v1i16(<1 x i16>)

define i16 @vreduce_smin_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_smin_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v2i16(<2 x i16>)

define i16 @vreduce_smin_v2i16(<2 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v2i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v2i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v4i16(<4 x i16>)

define i16 @vreduce_smin_v4i16(<4 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v4i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v4i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v8i16(<8 x i16>)

define i16 @vreduce_smin_v8i16(<8 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v8i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV32-NEXT:    vle16.v v25, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v8i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; RV64-NEXT:    vle16.v v25, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v16i16(<16 x i16>)

define i16 @vreduce_smin_v16i16(<16 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; RV32-NEXT:    vle16.v v26, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; RV32-NEXT:    vredmin.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; RV64-NEXT:    vle16.v v26, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; RV64-NEXT:    vredmin.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v32i16(<32 x i16>)

define i16 @vreduce_smin_v32i16(<32 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v32i16:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; RV32-NEXT:    vle16.v v28, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; RV32-NEXT:    vredmin.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v32i16:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, zero, 32
; RV64-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; RV64-NEXT:    vle16.v v28, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; RV64-NEXT:    vredmin.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v64i16(<64 x i16>)

define i16 @vreduce_smin_v64i16(<64 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v64i16:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 64
; RV32-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; RV32-NEXT:    vle16.v v8, (a0)
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v64i16:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, zero, 64
; RV64-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; RV64-NEXT:    vle16.v v8, (a0)
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smin.v128i16(<128 x i16>)

define i16 @vreduce_smin_v128i16(<128 x i16>* %x) {
; RV32-LABEL: vreduce_smin_v128i16:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 64
; RV32-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; RV32-NEXT:    vle16.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle16.v v16, (a0)
; RV32-NEXT:    vmin.vv v8, v8, v16
; RV32-NEXT:    lui a0, 8
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v128i16:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, zero, 64
; RV64-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; RV64-NEXT:    vle16.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle16.v v16, (a0)
; RV64-NEXT:    vmin.vv v8, v8, v16
; RV64-NEXT:    lui a0, 8
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smin.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.smin.v1i32(<1 x i32>)

define i32 @vreduce_smin_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_smin_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v2i32(<2 x i32>)

define i32 @vreduce_smin_v2i32(<2 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v25, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; RV64-NEXT:    vle32.v v25, (a0)
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v4i32(<4 x i32>)

define i32 @vreduce_smin_v4i32(<4 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v4i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV32-NEXT:    vle32.v v25, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v4i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; RV64-NEXT:    vle32.v v25, (a0)
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v8i32(<8 x i32>)

define i32 @vreduce_smin_v8i32(<8 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v8i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; RV32-NEXT:    vle32.v v26, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; RV32-NEXT:    vredmin.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v8i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; RV64-NEXT:    vle32.v v26, (a0)
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; RV64-NEXT:    vredmin.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v16i32(<16 x i32>)

define i32 @vreduce_smin_v16i32(<16 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v16i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; RV32-NEXT:    vle32.v v28, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; RV32-NEXT:    vredmin.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v16i32:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; RV64-NEXT:    vle32.v v28, (a0)
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; RV64-NEXT:    vredmin.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v32i32(<32 x i32>)

define i32 @vreduce_smin_v32i32(<32 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v32i32:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; RV32-NEXT:    vle32.v v8, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v32i32:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, zero, 32
; RV64-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; RV64-NEXT:    vle32.v v8, (a0)
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smin.v64i32(<64 x i32>)

define i32 @vreduce_smin_v64i32(<64 x i32>* %x) {
; RV32-LABEL: vreduce_smin_v64i32:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; RV32-NEXT:    vle32.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle32.v v16, (a0)
; RV32-NEXT:    vmin.vv v8, v8, v16
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v64i32:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a1, zero, 32
; RV64-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; RV64-NEXT:    vle32.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle32.v v16, (a0)
; RV64-NEXT:    vmin.vv v8, v8, v16
; RV64-NEXT:    lui a0, 524288
; RV64-NEXT:    addiw a0, a0, -1
; RV64-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smin.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.smin.v1i64(<1 x i64>)

define i64 @vreduce_smin_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v2i64(<2 x i64>)

define i64 @vreduce_smin_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vsrl.vx v26, v26, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v27, a0
; RV32-NEXT:    vsll.vx v27, v27, a1
; RV32-NEXT:    vor.vv v26, v26, v27
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredmin.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredmin.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v4i64(<4 x i64>)

define i64 @vreduce_smin_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v28, a0
; RV32-NEXT:    vsll.vx v28, v28, a1
; RV32-NEXT:    vor.vv v25, v25, v28
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredmin.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredmin.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v8i64(<8 x i64>)

define i64 @vreduce_smin_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v25, v26
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredmin.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredmin.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v16i64(<16 x i64>)

define i64 @vreduce_smin_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v25, v26
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v32i64(<32 x i64>)

define i64 @vreduce_smin_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_smin_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vmin.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v25, v26
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vmin.vv v8, v8, v16
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smin.v64i64(<64 x i64>)

define i64 @vreduce_smin_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_smin_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vmin.vv v16, v24, v16
; RV32-NEXT:    vmin.vv v8, v8, v0
; RV32-NEXT:    vmin.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    addi a0, a0, -1
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v25, v26
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmin.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smin_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vmin.vv v16, v24, v16
; RV64-NEXT:    vmin.vv v8, v8, v0
; RV64-NEXT:    vmin.vv v8, v8, v16
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    addi a0, a0, -1
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmin.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smin.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.smax.v1i8(<1 x i8>)

define i8 @vreduce_smax_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v2i8(<2 x i8>)

define i8 @vreduce_smax_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v4i8(<4 x i8>)

define i8 @vreduce_smax_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)

define i8 @vreduce_smax_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v16i8(<16 x i8>)

define i8 @vreduce_smax_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a1, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v32i8(<32 x i8>)

define i8 @vreduce_smax_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v64i8(<64 x i8>)

define i8 @vreduce_smax_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v128i8(<128 x i8>)

define i8 @vreduce_smax_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.smax.v256i8(<256 x i8>)

define i8 @vreduce_smax_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_smax_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    addi a0, zero, -128
; CHECK-NEXT:    vsetvli a2, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.smax.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.smax.v1i16(<1 x i16>)

define i16 @vreduce_smax_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v2i16(<2 x i16>)

define i16 @vreduce_smax_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)

define i16 @vreduce_smax_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v8i16(<8 x i16>)

define i16 @vreduce_smax_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v16i16(<16 x i16>)

define i16 @vreduce_smax_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a1, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v32i16(<32 x i16>)

define i16 @vreduce_smax_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v64i16(<64 x i16>)

define i16 @vreduce_smax_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.smax.v128i16(<128 x i16>)

define i16 @vreduce_smax_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_smax_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 1048568
; CHECK-NEXT:    vsetvli a2, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.smax.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.smax.v1i32(<1 x i32>)

define i32 @vreduce_smax_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)

define i32 @vreduce_smax_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v4i32(<4 x i32>)

define i32 @vreduce_smax_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v26, a0
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v8i32(<8 x i32>)

define i32 @vreduce_smax_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v16i32(<16 x i32>)

define i32 @vreduce_smax_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a1, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v32i32(<32 x i32>)

define i32 @vreduce_smax_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.smax.v64i32(<64 x i32>)

define i32 @vreduce_smax_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_smax_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vmax.vv v8, v8, v16
; CHECK-NEXT:    lui a0, 524288
; CHECK-NEXT:    vsetvli a2, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.x v25, a0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredmax.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.smax.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.smax.v1i64(<1 x i64>)

define i64 @vreduce_smax_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v2i64(<2 x i64>)

define i64 @vreduce_smax_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v26, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vmv.v.i v27, 0
; RV32-NEXT:    vsll.vx v27, v27, a1
; RV32-NEXT:    vsrl.vx v27, v27, a1
; RV32-NEXT:    vor.vv v26, v27, v26
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredmax.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v26, a0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredmax.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v4i64(<4 x i64>)

define i64 @vreduce_smax_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vmv.v.i v28, 0
; RV32-NEXT:    vsll.vx v28, v28, a1
; RV32-NEXT:    vsrl.vx v28, v28, a1
; RV32-NEXT:    vor.vv v25, v28, v25
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredmax.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredmax.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v8i64(<8 x i64>)

define i64 @vreduce_smax_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vsrl.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v26, v25
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredmax.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredmax.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v16i64(<16 x i64>)

define i64 @vreduce_smax_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vsrl.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v26, v25
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmax.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmax.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v32i64(<32 x i64>)

define i64 @vreduce_smax_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_smax_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vmax.vv v8, v8, v16
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vsrl.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v26, v25
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmax.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vmax.vv v8, v8, v16
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmax.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.smax.v64i64(<64 x i64>)

define i64 @vreduce_smax_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_smax_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vmax.vv v16, v24, v16
; RV32-NEXT:    vmax.vv v8, v8, v0
; RV32-NEXT:    vmax.vv v8, v8, v16
; RV32-NEXT:    lui a0, 524288
; RV32-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.x v25, a0
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsll.vx v25, v25, a1
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsll.vx v26, v26, a1
; RV32-NEXT:    vsrl.vx v26, v26, a1
; RV32-NEXT:    vor.vv v25, v26, v25
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmax.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_smax_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vmax.vv v16, v24, v16
; RV64-NEXT:    vmax.vv v8, v8, v0
; RV64-NEXT:    vmax.vv v8, v8, v16
; RV64-NEXT:    addi a0, zero, -1
; RV64-NEXT:    slli a0, a0, 63
; RV64-NEXT:    vsetvli a1, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.x v25, a0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmax.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.smax.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.umin.v1i8(<1 x i8>)

define i8 @vreduce_umin_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v2i8(<2 x i8>)

define i8 @vreduce_umin_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v4i8(<4 x i8>)

define i8 @vreduce_umin_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v8i8(<8 x i8>)

define i8 @vreduce_umin_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v16i8(<16 x i8>)

define i8 @vreduce_umin_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v32i8(<32 x i8>)

define i8 @vreduce_umin_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v64i8(<64 x i8>)

define i8 @vreduce_umin_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v128i8(<128 x i8>)

define i8 @vreduce_umin_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umin.v256i8(<256 x i8>)

define i8 @vreduce_umin_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_umin_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vminu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umin.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.umin.v1i16(<1 x i16>)

define i16 @vreduce_umin_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v2i16(<2 x i16>)

define i16 @vreduce_umin_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v4i16(<4 x i16>)

define i16 @vreduce_umin_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v8i16(<8 x i16>)

define i16 @vreduce_umin_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v16i16(<16 x i16>)

define i16 @vreduce_umin_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v32i16(<32 x i16>)

define i16 @vreduce_umin_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v64i16(<64 x i16>)

define i16 @vreduce_umin_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umin.v128i16(<128 x i16>)

define i16 @vreduce_umin_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_umin_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vminu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umin.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.umin.v1i32(<1 x i32>)

define i32 @vreduce_umin_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v2i32(<2 x i32>)

define i32 @vreduce_umin_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v4i32(<4 x i32>)

define i32 @vreduce_umin_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, -1
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v8i32(<8 x i32>)

define i32 @vreduce_umin_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v16i32(<16 x i32>)

define i32 @vreduce_umin_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v32i32(<32 x i32>)

define i32 @vreduce_umin_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umin.v64i32(<64 x i32>)

define i32 @vreduce_umin_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_umin_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vminu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, -1
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredminu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umin.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.umin.v1i64(<1 x i64>)

define i64 @vreduce_umin_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v2i64(<2 x i64>)

define i64 @vreduce_umin_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, -1
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredminu.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, -1
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredminu.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v4i64(<4 x i64>)

define i64 @vreduce_umin_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredminu.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredminu.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v8i64(<8 x i64>)

define i64 @vreduce_umin_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredminu.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredminu.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v16i64(<16 x i64>)

define i64 @vreduce_umin_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredminu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredminu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v32i64(<32 x i64>)

define i64 @vreduce_umin_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_umin_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vminu.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredminu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vminu.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredminu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umin.v64i64(<64 x i64>)

define i64 @vreduce_umin_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_umin_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vminu.vv v16, v24, v16
; RV32-NEXT:    vminu.vv v8, v8, v0
; RV32-NEXT:    vminu.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, -1
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredminu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umin_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vminu.vv v16, v24, v16
; RV64-NEXT:    vminu.vv v8, v8, v0
; RV64-NEXT:    vminu.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, -1
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredminu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umin.v64i64(<64 x i64> %v)
  ret i64 %red
}

declare i8 @llvm.vector.reduce.umax.v1i8(<1 x i8>)

define i8 @vreduce_umax_v1i8(<1 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i8>, <1 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v1i8(<1 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v2i8(<2 x i8>)

define i8 @vreduce_umax_v2i8(<2 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e8,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i8>, <2 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v2i8(<2 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v4i8(<4 x i8>)

define i8 @vreduce_umax_v4i8(<4 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e8,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i8>, <4 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v8i8(<8 x i8>)

define i8 @vreduce_umax_v8i8(<8 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e8,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i8>, <8 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v8i8(<8 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v16i8(<16 x i8>)

define i8 @vreduce_umax_v16i8(<16 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e8,m1,ta,mu
; CHECK-NEXT:    vle8.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 16, e8,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i8>, <16 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v16i8(<16 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v32i8(<32 x i8>)

define i8 @vreduce_umax_v32i8(<32 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e8,m2,ta,mu
; CHECK-NEXT:    vle8.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m2,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i8>, <32 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v32i8(<32 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v64i8(<64 x i8>)

define i8 @vreduce_umax_v64i8(<64 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e8,m4,ta,mu
; CHECK-NEXT:    vle8.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m4,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i8>, <64 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v64i8(<64 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v128i8(<128 x i8>)

define i8 @vreduce_umax_v128i8(<128 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i8>, <128 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v128i8(<128 x i8> %v)
  ret i8 %red
}

declare i8 @llvm.vector.reduce.umax.v256i8(<256 x i8>)

define i8 @vreduce_umax_v256i8(<256 x i8>* %x) {
; CHECK-LABEL: vreduce_umax_v256i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 128
; CHECK-NEXT:    vsetvli a2, a1, e8,m8,ta,mu
; CHECK-NEXT:    vle8.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle8.v v16, (a0)
; CHECK-NEXT:    vmaxu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e8,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e8,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <256 x i8>, <256 x i8>* %x
  %red = call i8 @llvm.vector.reduce.umax.v256i8(<256 x i8> %v)
  ret i8 %red
}

declare i16 @llvm.vector.reduce.umax.v1i16(<1 x i16>)

define i16 @vreduce_umax_v1i16(<1 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i16>, <1 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v1i16(<1 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v2i16(<2 x i16>)

define i16 @vreduce_umax_v2i16(<2 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e16,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i16>, <2 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v2i16(<2 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v4i16(<4 x i16>)

define i16 @vreduce_umax_v4i16(<4 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e16,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i16>, <4 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v4i16(<4 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v8i16(<8 x i16>)

define i16 @vreduce_umax_v8i16(<8 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e16,m1,ta,mu
; CHECK-NEXT:    vle16.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 8, e16,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i16>, <8 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v8i16(<8 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v16i16(<16 x i16>)

define i16 @vreduce_umax_v16i16(<16 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e16,m2,ta,mu
; CHECK-NEXT:    vle16.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e16,m2,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i16>, <16 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v16i16(<16 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v32i16(<32 x i16>)

define i16 @vreduce_umax_v32i16(<32 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e16,m4,ta,mu
; CHECK-NEXT:    vle16.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m4,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i16>, <32 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v32i16(<32 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v64i16(<64 x i16>)

define i16 @vreduce_umax_v64i16(<64 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i16>, <64 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v64i16(<64 x i16> %v)
  ret i16 %red
}

declare i16 @llvm.vector.reduce.umax.v128i16(<128 x i16>)

define i16 @vreduce_umax_v128i16(<128 x i16>* %x) {
; CHECK-LABEL: vreduce_umax_v128i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 64
; CHECK-NEXT:    vsetvli a2, a1, e16,m8,ta,mu
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vmaxu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e16,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e16,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <128 x i16>, <128 x i16>* %x
  %red = call i16 @llvm.vector.reduce.umax.v128i16(<128 x i16> %v)
  ret i16 %red
}

declare i32 @llvm.vector.reduce.umax.v1i32(<1 x i32>)

define i32 @vreduce_umax_v1i32(<1 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 1, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <1 x i32>, <1 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v1i32(<1 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v2i32(<2 x i32>)

define i32 @vreduce_umax_v2i32(<2 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 2, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 2, e32,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <2 x i32>, <2 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v2i32(<2 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v4i32(<4 x i32>)

define i32 @vreduce_umax_v4i32(<4 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 4, e32,m1,ta,mu
; CHECK-NEXT:    vle32.v v25, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v26, 0
; CHECK-NEXT:    vsetivli a0, 4, e32,m1,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v25, v26
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <4 x i32>, <4 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v8i32(<8 x i32>)

define i32 @vreduce_umax_v8i32(<8 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 8, e32,m2,ta,mu
; CHECK-NEXT:    vle32.v v26, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 8, e32,m2,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v26, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <8 x i32>, <8 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v8i32(<8 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v16i32(<16 x i32>)

define i32 @vreduce_umax_v16i32(<16 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli a1, 16, e32,m4,ta,mu
; CHECK-NEXT:    vle32.v v28, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetivli a0, 16, e32,m4,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v28, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <16 x i32>, <16 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v16i32(<16 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v32i32(<32 x i32>)

define i32 @vreduce_umax_v32i32(<32 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <32 x i32>, <32 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v32i32(<32 x i32> %v)
  ret i32 %red
}

declare i32 @llvm.vector.reduce.umax.v64i32(<64 x i32>)

define i32 @vreduce_umax_v64i32(<64 x i32>* %x) {
; CHECK-LABEL: vreduce_umax_v64i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, zero, 32
; CHECK-NEXT:    vsetvli a2, a1, e32,m8,ta,mu
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vmaxu.vv v8, v8, v16
; CHECK-NEXT:    vsetvli a0, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.v.i v25, 0
; CHECK-NEXT:    vsetvli a0, a1, e32,m8,ta,mu
; CHECK-NEXT:    vredmaxu.vs v25, v8, v25
; CHECK-NEXT:    vsetvli zero, zero, e32,m1,ta,mu
; CHECK-NEXT:    vmv.x.s a0, v25
; CHECK-NEXT:    ret
  %v = load <64 x i32>, <64 x i32>* %x
  %red = call i32 @llvm.vector.reduce.umax.v64i32(<64 x i32> %v)
  ret i32 %red
}

declare i64 @llvm.vector.reduce.umax.v1i64(<1 x i64>)

define i64 @vreduce_umax_v1i64(<1 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v1i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v1i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 1, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <1 x i64>, <1 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v1i64(<1 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v2i64(<2 x i64>)

define i64 @vreduce_umax_v2i64(<2 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV32-NEXT:    vle64.v v25, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v26, 0
; RV32-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v25, v26
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 2, e64,m1,ta,mu
; RV64-NEXT:    vle64.v v25, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v26, 0
; RV64-NEXT:    vsetivli a0, 2, e64,m1,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v25, v26
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <2 x i64>, <2 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v4i64(<4 x i64>)

define i64 @vreduce_umax_v4i64(<4 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v4i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV32-NEXT:    vle64.v v26, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v26, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v4i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 4, e64,m2,ta,mu
; RV64-NEXT:    vle64.v v26, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 4, e64,m2,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v26, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <4 x i64>, <4 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v4i64(<4 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v8i64(<8 x i64>)

define i64 @vreduce_umax_v8i64(<8 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v8i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV32-NEXT:    vle64.v v28, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v28, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v8i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 8, e64,m4,ta,mu
; RV64-NEXT:    vle64.v v28, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 8, e64,m4,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v28, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <8 x i64>, <8 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v8i64(<8 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v16i64(<16 x i64>)

define i64 @vreduce_umax_v16i64(<16 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v16i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v16i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <16 x i64>, <16 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v16i64(<16 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v32i64(<32 x i64>)

define i64 @vreduce_umax_v32i64(<32 x i64>* %x) {
; RV32-LABEL: vreduce_umax_v32i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v16, (a0)
; RV32-NEXT:    vmaxu.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v32i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v16, (a0)
; RV64-NEXT:    vmaxu.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <32 x i64>, <32 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v32i64(<32 x i64> %v)
  ret i64 %red
}

declare i64 @llvm.vector.reduce.umax.v64i64(<64 x i64>)

define i64 @vreduce_umax_v64i64(<64 x i64>* %x) nounwind {
; RV32-LABEL: vreduce_umax_v64i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV32-NEXT:    vle64.v v8, (a0)
; RV32-NEXT:    addi a1, a0, 256
; RV32-NEXT:    addi a2, a0, 384
; RV32-NEXT:    vle64.v v16, (a2)
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    vle64.v v24, (a0)
; RV32-NEXT:    vle64.v v0, (a1)
; RV32-NEXT:    vmaxu.vv v16, v24, v16
; RV32-NEXT:    vmaxu.vv v8, v8, v0
; RV32-NEXT:    vmaxu.vv v8, v8, v16
; RV32-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.v.i v25, 0
; RV32-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV32-NEXT:    vredmaxu.vs v25, v8, v25
; RV32-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV32-NEXT:    vmv.x.s a0, v25
; RV32-NEXT:    addi a1, zero, 32
; RV32-NEXT:    vsetivli a2, 1, e64,m1,ta,mu
; RV32-NEXT:    vsrl.vx v25, v25, a1
; RV32-NEXT:    vmv.x.s a1, v25
; RV32-NEXT:    ret
;
; RV64-LABEL: vreduce_umax_v64i64:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli a1, 16, e64,m8,ta,mu
; RV64-NEXT:    vle64.v v8, (a0)
; RV64-NEXT:    addi a1, a0, 384
; RV64-NEXT:    vle64.v v16, (a1)
; RV64-NEXT:    addi a1, a0, 256
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    vle64.v v24, (a0)
; RV64-NEXT:    vle64.v v0, (a1)
; RV64-NEXT:    vmaxu.vv v16, v24, v16
; RV64-NEXT:    vmaxu.vv v8, v8, v0
; RV64-NEXT:    vmaxu.vv v8, v8, v16
; RV64-NEXT:    vsetvli a0, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.v.i v25, 0
; RV64-NEXT:    vsetivli a0, 16, e64,m8,ta,mu
; RV64-NEXT:    vredmaxu.vs v25, v8, v25
; RV64-NEXT:    vsetvli zero, zero, e64,m1,ta,mu
; RV64-NEXT:    vmv.x.s a0, v25
; RV64-NEXT:    ret
  %v = load <64 x i64>, <64 x i64>* %x
  %red = call i64 @llvm.vector.reduce.umax.v64i64(<64 x i64> %v)
  ret i64 %red
}
