/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCredential;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoDriverInformation;
import com.mongodb.connection.Authenticator;
import com.mongodb.connection.ClientMetadataHelper;
import com.mongodb.connection.DefaultAuthenticator;
import com.mongodb.connection.GSSAPIAuthenticator;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.InternalConnectionFactory;
import com.mongodb.connection.InternalStreamConnection;
import com.mongodb.connection.InternalStreamConnectionInitializer;
import com.mongodb.connection.NativeAuthenticator;
import com.mongodb.connection.PlainAuthenticator;
import com.mongodb.connection.ScramSha1Authenticator;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.X509Authenticator;
import com.mongodb.event.ConnectionListener;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final StreamFactory streamFactory;
    private final ConnectionListener connectionListener;
    private final BsonDocument clientMetadataDocument;
    private final List<Authenticator> authenticators;

    public InternalStreamConnectionFactory(StreamFactory streamFactory, List<MongoCredential> credentialList, ConnectionListener connectionListener, String applicationName, MongoDriverInformation mongoDriverInformation) {
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.connectionListener = Assertions.notNull("connectionListener", connectionListener);
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        Assertions.notNull("credentialList", credentialList);
        this.authenticators = new ArrayList<Authenticator>(credentialList.size());
        for (MongoCredential credential : credentialList) {
            this.authenticators.add(this.createAuthenticator(credential));
        }
    }

    @Override
    public InternalConnection create(ServerId serverId) {
        return new InternalStreamConnection(serverId, this.streamFactory, new InternalStreamConnectionInitializer(this.authenticators, this.clientMetadataDocument), this.connectionListener);
    }

    private Authenticator createAuthenticator(MongoCredential credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential);
        }
        switch (credential.getAuthenticationMechanism()) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential);
            }
            case SCRAM_SHA_1: {
                return new ScramSha1Authenticator(credential);
            }
            case MONGODB_CR: {
                return new NativeAuthenticator(credential);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

