/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextMapAdapter;
import org.codehaus.plexus.context.DefaultContext;
import org.codehaus.plexus.logging.LoggerManager;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.eclipse.sisu.plexus.PlexusBeanManager;
import org.eclipse.sisu.plexus.PlexusBindingModule;
import org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.eclipse.sisu.plexus.PseudoPlexusContainer;
import org.eclipse.sisu.space.ClassSpace;

public final class PlexusSpaceModule
implements Module {
    private final ClassSpace space;

    public PlexusSpaceModule(ClassSpace space) {
        this.space = space;
    }

    public void configure(Binder binder) {
        ParameterizedContext context = new ParameterizedContext();
        binder.bind(Context.class).toInstance((Object)context);
        DeferredProvider slf4jLoggerFactoryProvider = this.space.deferLoadClass("org.slf4j.ILoggerFactory").asProvider();
        binder.requestInjection((Object)slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        binder.bind(PlexusBeanLocator.class).to(DefaultPlexusBeanLocator.class);
        binder.bind(PlexusContainer.class).to(PseudoPlexusContainer.class);
        PlexusLifecycleManager manager = new PlexusLifecycleManager((Provider<Context>)binder.getProvider(Context.class), (Provider<LoggerManager>)binder.getProvider(LoggerManager.class), (Provider<?>)slf4jLoggerFactoryProvider);
        binder.bind(PlexusBeanManager.class).toInstance((Object)manager);
        PlexusXmlBeanModule xmlModule = new PlexusXmlBeanModule(this.space, new ContextMapAdapter(context));
        binder.install((Module)new PlexusBindingModule((PlexusBeanManager)manager, xmlModule));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ParameterizedContext
    extends DefaultContext {
        ParameterizedContext() {
        }

        @Inject
        protected void setParameters(@Parameters Map<?, ?> parameters) {
            this.contextData.putAll(parameters);
        }
    }
}

