<?php
/**
 * Handler for bitmap images that will be resized by clients.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 * @ingroup Media
 */

/**
 * Handler for bitmap images that will be resized by clients.
 *
 * This is not used by default but can be assigned to some image types
 * using $wgMediaHandlers.
 *
 * @ingroup Media
 */
class BitmapHandler_ClientOnly extends BitmapHandler {
	/**
	 * @param $image File
	 * @param $params
	 * @return bool
	 */
	function normaliseParams( $image, &$params ) {
		return ImageHandler::normaliseParams( $image, $params );
	}

	/**
	 * @param File $image
	 * @param string $dstPath
	 * @param string $dstUrl
	 * @param array $params
	 * @param int $flags
	 * @return ThumbnailImage|TransformParameterError
	 */
	function doTransform( $image, $dstPath, $dstUrl, $params, $flags = 0 ) {
		if ( !$this->normaliseParams( $image, $params ) ) {
			return new TransformParameterError( $params );
		}

		return new ThumbnailImage( $image, $image->getURL(), $image->getLocalRefPath(), $params );
	}
}
