// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociatePhoneNumberWithUser = "AssociatePhoneNumberWithUser"

// AssociatePhoneNumberWithUserRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumberWithUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumberWithUser for more information on using the AssociatePhoneNumberWithUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociatePhoneNumberWithUserRequest method.
//    req, resp := client.AssociatePhoneNumberWithUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser
func (c *Chime) AssociatePhoneNumberWithUserRequest(input *AssociatePhoneNumberWithUserInput) (req *request.Request, output *AssociatePhoneNumberWithUserOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumberWithUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=associate-phone-number",
	}

	if input == nil {
		input = &AssociatePhoneNumberWithUserInput{}
	}

	output = &AssociatePhoneNumberWithUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociatePhoneNumberWithUser API operation for Amazon Chime.
//
// Associates a phone number with the specified Amazon Chime user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumberWithUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumberWithUser
func (c *Chime) AssociatePhoneNumberWithUser(input *AssociatePhoneNumberWithUserInput) (*AssociatePhoneNumberWithUserOutput, error) {
	req, out := c.AssociatePhoneNumberWithUserRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumberWithUserWithContext is the same as AssociatePhoneNumberWithUser with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumberWithUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociatePhoneNumberWithUserWithContext(ctx aws.Context, input *AssociatePhoneNumberWithUserInput, opts ...request.Option) (*AssociatePhoneNumberWithUserOutput, error) {
	req, out := c.AssociatePhoneNumberWithUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumbersWithVoiceConnector = "AssociatePhoneNumbersWithVoiceConnector"

// AssociatePhoneNumbersWithVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnector for more information on using the AssociatePhoneNumbersWithVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorRequest method.
//    req, resp := client.AssociatePhoneNumbersWithVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorRequest(input *AssociatePhoneNumbersWithVoiceConnectorInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnector API operation for Amazon Chime.
//
// Associates phone numbers with the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumbersWithVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnector
func (c *Chime) AssociatePhoneNumbersWithVoiceConnector(input *AssociatePhoneNumbersWithVoiceConnectorInput) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorWithContext is the same as AssociatePhoneNumbersWithVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumbersWithVoiceConnectorGroup = "AssociatePhoneNumbersWithVoiceConnectorGroup"

// AssociatePhoneNumbersWithVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumbersWithVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for more information on using the AssociatePhoneNumbersWithVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociatePhoneNumbersWithVoiceConnectorGroupRequest method.
//    req, resp := client.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (req *request.Request, output *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumbersWithVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=associate-phone-numbers",
	}

	if input == nil {
		input = &AssociatePhoneNumbersWithVoiceConnectorGroupInput{}
	}

	output = &AssociatePhoneNumbersWithVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociatePhoneNumbersWithVoiceConnectorGroup API operation for Amazon Chime.
//
// Associates phone numbers with the specified Amazon Chime Voice Connector
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociatePhoneNumbersWithVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociatePhoneNumbersWithVoiceConnectorGroup
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroup(input *AssociatePhoneNumbersWithVoiceConnectorGroupInput) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumbersWithVoiceConnectorGroupWithContext is the same as AssociatePhoneNumbersWithVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumbersWithVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociatePhoneNumbersWithVoiceConnectorGroupWithContext(ctx aws.Context, input *AssociatePhoneNumbersWithVoiceConnectorGroupInput, opts ...request.Option) (*AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error) {
	req, out := c.AssociatePhoneNumbersWithVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSigninDelegateGroupsWithAccount = "AssociateSigninDelegateGroupsWithAccount"

// AssociateSigninDelegateGroupsWithAccountRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSigninDelegateGroupsWithAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSigninDelegateGroupsWithAccount for more information on using the AssociateSigninDelegateGroupsWithAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateSigninDelegateGroupsWithAccountRequest method.
//    req, resp := client.AssociateSigninDelegateGroupsWithAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount
func (c *Chime) AssociateSigninDelegateGroupsWithAccountRequest(input *AssociateSigninDelegateGroupsWithAccountInput) (req *request.Request, output *AssociateSigninDelegateGroupsWithAccountOutput) {
	op := &request.Operation{
		Name:       opAssociateSigninDelegateGroupsWithAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}?operation=associate-signin-delegate-groups",
	}

	if input == nil {
		input = &AssociateSigninDelegateGroupsWithAccountInput{}
	}

	output = &AssociateSigninDelegateGroupsWithAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateSigninDelegateGroupsWithAccount API operation for Amazon Chime.
//
// Associates the specified sign-in delegate groups with the specified Amazon
// Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation AssociateSigninDelegateGroupsWithAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/AssociateSigninDelegateGroupsWithAccount
func (c *Chime) AssociateSigninDelegateGroupsWithAccount(input *AssociateSigninDelegateGroupsWithAccountInput) (*AssociateSigninDelegateGroupsWithAccountOutput, error) {
	req, out := c.AssociateSigninDelegateGroupsWithAccountRequest(input)
	return out, req.Send()
}

// AssociateSigninDelegateGroupsWithAccountWithContext is the same as AssociateSigninDelegateGroupsWithAccount with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSigninDelegateGroupsWithAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) AssociateSigninDelegateGroupsWithAccountWithContext(ctx aws.Context, input *AssociateSigninDelegateGroupsWithAccountInput, opts ...request.Option) (*AssociateSigninDelegateGroupsWithAccountOutput, error) {
	req, out := c.AssociateSigninDelegateGroupsWithAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateAttendee = "BatchCreateAttendee"

// BatchCreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateAttendee for more information on using the BatchCreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateAttendeeRequest method.
//    req, resp := client.BatchCreateAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee
func (c *Chime) BatchCreateAttendeeRequest(input *BatchCreateAttendeeInput) (req *request.Request, output *BatchCreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opBatchCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateAttendeeInput{}
	}

	output = &BatchCreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateAttendee API operation for Amazon Chime.
//
// Creates up to 100 new attendees for an active Amazon Chime SDK meeting. For
// more information about the Amazon Chime SDK, see Using the Amazon Chime SDK
// (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the Amazon
// Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchCreateAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateAttendee
func (c *Chime) BatchCreateAttendee(input *BatchCreateAttendeeInput) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	return out, req.Send()
}

// BatchCreateAttendeeWithContext is the same as BatchCreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchCreateAttendeeWithContext(ctx aws.Context, input *BatchCreateAttendeeInput, opts ...request.Option) (*BatchCreateAttendeeOutput, error) {
	req, out := c.BatchCreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchCreateRoomMembership = "BatchCreateRoomMembership"

// BatchCreateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the BatchCreateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchCreateRoomMembership for more information on using the BatchCreateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchCreateRoomMembershipRequest method.
//    req, resp := client.BatchCreateRoomMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership
func (c *Chime) BatchCreateRoomMembershipRequest(input *BatchCreateRoomMembershipInput) (req *request.Request, output *BatchCreateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opBatchCreateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships?operation=batch-create",
	}

	if input == nil {
		input = &BatchCreateRoomMembershipInput{}
	}

	output = &BatchCreateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchCreateRoomMembership API operation for Amazon Chime.
//
// Adds up to 50 members to a chat room in an Amazon Chime Enterprise account.
// Members can be either users or bots. The member role designates whether the
// member is a chat room administrator or a general chat room member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchCreateRoomMembership for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchCreateRoomMembership
func (c *Chime) BatchCreateRoomMembership(input *BatchCreateRoomMembershipInput) (*BatchCreateRoomMembershipOutput, error) {
	req, out := c.BatchCreateRoomMembershipRequest(input)
	return out, req.Send()
}

// BatchCreateRoomMembershipWithContext is the same as BatchCreateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See BatchCreateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchCreateRoomMembershipWithContext(ctx aws.Context, input *BatchCreateRoomMembershipInput, opts ...request.Option) (*BatchCreateRoomMembershipOutput, error) {
	req, out := c.BatchCreateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDeletePhoneNumber = "BatchDeletePhoneNumber"

// BatchDeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeletePhoneNumber for more information on using the BatchDeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeletePhoneNumberRequest method.
//    req, resp := client.BatchDeletePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber
func (c *Chime) BatchDeletePhoneNumberRequest(input *BatchDeletePhoneNumberInput) (req *request.Request, output *BatchDeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchDeletePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-delete",
	}

	if input == nil {
		input = &BatchDeletePhoneNumberInput{}
	}

	output = &BatchDeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeletePhoneNumber API operation for Amazon Chime.
//
// Moves phone numbers into the Deletion queue. Phone numbers must be disassociated
// from any users or Amazon Chime Voice Connectors before they can be deleted.
//
// Phone numbers remain in the Deletion queue for 7 days before they are deleted
// permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchDeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchDeletePhoneNumber
func (c *Chime) BatchDeletePhoneNumber(input *BatchDeletePhoneNumberInput) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchDeletePhoneNumberWithContext is the same as BatchDeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchDeletePhoneNumberWithContext(ctx aws.Context, input *BatchDeletePhoneNumberInput, opts ...request.Option) (*BatchDeletePhoneNumberOutput, error) {
	req, out := c.BatchDeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchSuspendUser = "BatchSuspendUser"

// BatchSuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchSuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchSuspendUser for more information on using the BatchSuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchSuspendUserRequest method.
//    req, resp := client.BatchSuspendUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUserRequest(input *BatchSuspendUserInput) (req *request.Request, output *BatchSuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchSuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=suspend",
	}

	if input == nil {
		input = &BatchSuspendUserInput{}
	}

	output = &BatchSuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchSuspendUser API operation for Amazon Chime.
//
// Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime account.
// For more information about different account types, see Managing Your Amazon
// Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Users suspended from a Team account are disassociated from the account, but
// they can continue to use Amazon Chime as free users. To remove the suspension
// from suspended Team account users, invite them to the Team account again.
// You can use the InviteUsers action to do so.
//
// Users suspended from an EnterpriseLWA account are immediately signed out
// of Amazon Chime and can no longer sign in. To remove the suspension from
// suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.
//
// To sign out users without suspending them, use the LogoutUser action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchSuspendUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchSuspendUser
func (c *Chime) BatchSuspendUser(input *BatchSuspendUserInput) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	return out, req.Send()
}

// BatchSuspendUserWithContext is the same as BatchSuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchSuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchSuspendUserWithContext(ctx aws.Context, input *BatchSuspendUserInput, opts ...request.Option) (*BatchSuspendUserOutput, error) {
	req, out := c.BatchSuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUnsuspendUser = "BatchUnsuspendUser"

// BatchUnsuspendUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUnsuspendUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUnsuspendUser for more information on using the BatchUnsuspendUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUnsuspendUserRequest method.
//    req, resp := client.BatchUnsuspendUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUserRequest(input *BatchUnsuspendUserInput) (req *request.Request, output *BatchUnsuspendUserOutput) {
	op := &request.Operation{
		Name:       opBatchUnsuspendUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=unsuspend",
	}

	if input == nil {
		input = &BatchUnsuspendUserInput{}
	}

	output = &BatchUnsuspendUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUnsuspendUser API operation for Amazon Chime.
//
// Removes the suspension from up to 50 previously suspended users for the specified
// Amazon Chime EnterpriseLWA account. Only users on EnterpriseLWA accounts
// can be unsuspended using this action. For more information about different
// account types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Previously suspended users who are unsuspended using this action are returned
// to Registered status. Users who are not previously suspended are ignored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUnsuspendUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUnsuspendUser
func (c *Chime) BatchUnsuspendUser(input *BatchUnsuspendUserInput) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	return out, req.Send()
}

// BatchUnsuspendUserWithContext is the same as BatchUnsuspendUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUnsuspendUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUnsuspendUserWithContext(ctx aws.Context, input *BatchUnsuspendUserInput, opts ...request.Option) (*BatchUnsuspendUserOutput, error) {
	req, out := c.BatchUnsuspendUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdatePhoneNumber = "BatchUpdatePhoneNumber"

// BatchUpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdatePhoneNumber for more information on using the BatchUpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdatePhoneNumberRequest method.
//    req, resp := client.BatchUpdatePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber
func (c *Chime) BatchUpdatePhoneNumberRequest(input *BatchUpdatePhoneNumberInput) (req *request.Request, output *BatchUpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opBatchUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers?operation=batch-update",
	}

	if input == nil {
		input = &BatchUpdatePhoneNumberInput{}
	}

	output = &BatchUpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdatePhoneNumber API operation for Amazon Chime.
//
// Updates phone number product types or calling names. You can update one attribute
// at a time for each UpdatePhoneNumberRequestItem. For example, you can update
// either the product type or the calling name.
//
// For product types, choose from Amazon Chime Business Calling and Amazon Chime
// Voice Connector. For toll-free numbers, you must use the Amazon Chime Voice
// Connector product type.
//
// Updates to outbound calling names can take up to 72 hours to complete. Pending
// updates to outbound calling names must be complete before you can request
// another update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdatePhoneNumber
func (c *Chime) BatchUpdatePhoneNumber(input *BatchUpdatePhoneNumberInput) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// BatchUpdatePhoneNumberWithContext is the same as BatchUpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUpdatePhoneNumberWithContext(ctx aws.Context, input *BatchUpdatePhoneNumberInput, opts ...request.Option) (*BatchUpdatePhoneNumberOutput, error) {
	req, out := c.BatchUpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchUpdateUser = "BatchUpdateUser"

// BatchUpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the BatchUpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchUpdateUser for more information on using the BatchUpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchUpdateUserRequest method.
//    req, resp := client.BatchUpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUserRequest(input *BatchUpdateUserInput) (req *request.Request, output *BatchUpdateUserOutput) {
	op := &request.Operation{
		Name:       opBatchUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users",
	}

	if input == nil {
		input = &BatchUpdateUserInput{}
	}

	output = &BatchUpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchUpdateUser API operation for Amazon Chime.
//
// Updates user details within the UpdateUserRequestItem object for up to 20
// users for the specified Amazon Chime account. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation BatchUpdateUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/BatchUpdateUser
func (c *Chime) BatchUpdateUser(input *BatchUpdateUserInput) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	return out, req.Send()
}

// BatchUpdateUserWithContext is the same as BatchUpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See BatchUpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) BatchUpdateUserWithContext(ctx aws.Context, input *BatchUpdateUserInput, opts ...request.Option) (*BatchUpdateUserOutput, error) {
	req, out := c.BatchUpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccount = "CreateAccount"

// CreateAccountRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccount for more information on using the CreateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAccountRequest method.
//    req, resp := client.CreateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccountRequest(input *CreateAccountInput) (req *request.Request, output *CreateAccountOutput) {
	op := &request.Operation{
		Name:       opCreateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts",
	}

	if input == nil {
		input = &CreateAccountInput{}
	}

	output = &CreateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccount API operation for Amazon Chime.
//
// Creates an Amazon Chime account under the administrator's AWS account. Only
// Team account types are currently supported for this action. For more information
// about different account types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAccount
func (c *Chime) CreateAccount(input *CreateAccountInput) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	return out, req.Send()
}

// CreateAccountWithContext is the same as CreateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateAccountWithContext(ctx aws.Context, input *CreateAccountInput, opts ...request.Option) (*CreateAccountOutput, error) {
	req, out := c.CreateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAttendee = "CreateAttendee"

// CreateAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the CreateAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAttendee for more information on using the CreateAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAttendeeRequest method.
//    req, resp := client.CreateAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee
func (c *Chime) CreateAttendeeRequest(input *CreateAttendeeInput) (req *request.Request, output *CreateAttendeeOutput) {
	op := &request.Operation{
		Name:       opCreateAttendee,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings/{meetingId}/attendees",
	}

	if input == nil {
		input = &CreateAttendeeInput{}
	}

	output = &CreateAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAttendee API operation for Amazon Chime.
//
// Creates a new attendee for an active Amazon Chime SDK meeting. For more information
// about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateAttendee
func (c *Chime) CreateAttendee(input *CreateAttendeeInput) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	return out, req.Send()
}

// CreateAttendeeWithContext is the same as CreateAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateAttendeeWithContext(ctx aws.Context, input *CreateAttendeeInput, opts ...request.Option) (*CreateAttendeeOutput, error) {
	req, out := c.CreateAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBot = "CreateBot"

// CreateBotRequest generates a "aws/request.Request" representing the
// client's request for the CreateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBot for more information on using the CreateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBotRequest method.
//    req, resp := client.CreateBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot
func (c *Chime) CreateBotRequest(input *CreateBotInput) (req *request.Request, output *CreateBotOutput) {
	op := &request.Operation{
		Name:       opCreateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots",
	}

	if input == nil {
		input = &CreateBotInput{}
	}

	output = &CreateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBot API operation for Amazon Chime.
//
// Creates a bot for an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateBot for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateBot
func (c *Chime) CreateBot(input *CreateBotInput) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	return out, req.Send()
}

// CreateBotWithContext is the same as CreateBot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateBotWithContext(ctx aws.Context, input *CreateBotInput, opts ...request.Option) (*CreateBotOutput, error) {
	req, out := c.CreateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMeeting = "CreateMeeting"

// CreateMeetingRequest generates a "aws/request.Request" representing the
// client's request for the CreateMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMeeting for more information on using the CreateMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMeetingRequest method.
//    req, resp := client.CreateMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting
func (c *Chime) CreateMeetingRequest(input *CreateMeetingInput) (req *request.Request, output *CreateMeetingOutput) {
	op := &request.Operation{
		Name:       opCreateMeeting,
		HTTPMethod: "POST",
		HTTPPath:   "/meetings",
	}

	if input == nil {
		input = &CreateMeetingInput{}
	}

	output = &CreateMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMeeting API operation for Amazon Chime.
//
// Creates a new Amazon Chime SDK meeting in the specified media Region with
// no initial attendees. For more information about the Amazon Chime SDK, see
// Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateMeeting for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateMeeting
func (c *Chime) CreateMeeting(input *CreateMeetingInput) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	return out, req.Send()
}

// CreateMeetingWithContext is the same as CreateMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateMeetingWithContext(ctx aws.Context, input *CreateMeetingInput, opts ...request.Option) (*CreateMeetingOutput, error) {
	req, out := c.CreateMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePhoneNumberOrder = "CreatePhoneNumberOrder"

// CreatePhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the CreatePhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePhoneNumberOrder for more information on using the CreatePhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePhoneNumberOrderRequest method.
//    req, resp := client.CreatePhoneNumberOrderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder
func (c *Chime) CreatePhoneNumberOrderRequest(input *CreatePhoneNumberOrderInput) (req *request.Request, output *CreatePhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opCreatePhoneNumberOrder,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number-orders",
	}

	if input == nil {
		input = &CreatePhoneNumberOrderInput{}
	}

	output = &CreatePhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePhoneNumberOrder API operation for Amazon Chime.
//
// Creates an order for phone numbers to be provisioned. Choose from Amazon
// Chime Business Calling and Amazon Chime Voice Connector product types. For
// toll-free numbers, you must use the Amazon Chime Voice Connector product
// type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreatePhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreatePhoneNumberOrder
func (c *Chime) CreatePhoneNumberOrder(input *CreatePhoneNumberOrderInput) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	return out, req.Send()
}

// CreatePhoneNumberOrderWithContext is the same as CreatePhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreatePhoneNumberOrderWithContext(ctx aws.Context, input *CreatePhoneNumberOrderInput, opts ...request.Option) (*CreatePhoneNumberOrderOutput, error) {
	req, out := c.CreatePhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoom = "CreateRoom"

// CreateRoomRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoom for more information on using the CreateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoomRequest method.
//    req, resp := client.CreateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom
func (c *Chime) CreateRoomRequest(input *CreateRoomInput) (req *request.Request, output *CreateRoomOutput) {
	op := &request.Operation{
		Name:       opCreateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms",
	}

	if input == nil {
		input = &CreateRoomInput{}
	}

	output = &CreateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoom API operation for Amazon Chime.
//
// Creates a chat room for the specified Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateRoom for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoom
func (c *Chime) CreateRoom(input *CreateRoomInput) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	return out, req.Send()
}

// CreateRoomWithContext is the same as CreateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateRoomWithContext(ctx aws.Context, input *CreateRoomInput, opts ...request.Option) (*CreateRoomOutput, error) {
	req, out := c.CreateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoomMembership = "CreateRoomMembership"

// CreateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoomMembership for more information on using the CreateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRoomMembershipRequest method.
//    req, resp := client.CreateRoomMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership
func (c *Chime) CreateRoomMembershipRequest(input *CreateRoomMembershipInput) (req *request.Request, output *CreateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships",
	}

	if input == nil {
		input = &CreateRoomMembershipInput{}
	}

	output = &CreateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoomMembership API operation for Amazon Chime.
//
// Adds a member to a chat room in an Amazon Chime Enterprise account. A member
// can be either a user or a bot. The member role designates whether the member
// is a chat room administrator or a general chat room member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateRoomMembership for usage and error information.
//
// Returned Error Types:
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateRoomMembership
func (c *Chime) CreateRoomMembership(input *CreateRoomMembershipInput) (*CreateRoomMembershipOutput, error) {
	req, out := c.CreateRoomMembershipRequest(input)
	return out, req.Send()
}

// CreateRoomMembershipWithContext is the same as CreateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateRoomMembershipWithContext(ctx aws.Context, input *CreateRoomMembershipInput, opts ...request.Option) (*CreateRoomMembershipOutput, error) {
	req, out := c.CreateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser
func (c *Chime) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=create",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon Chime.
//
// Creates a user under the specified Amazon Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateUser
func (c *Chime) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnector = "CreateVoiceConnector"

// CreateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnector for more information on using the CreateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVoiceConnectorRequest method.
//    req, resp := client.CreateVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector
func (c *Chime) CreateVoiceConnectorRequest(input *CreateVoiceConnectorInput) (req *request.Request, output *CreateVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opCreateVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors",
	}

	if input == nil {
		input = &CreateVoiceConnectorInput{}
	}

	output = &CreateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnector API operation for Amazon Chime.
//
// Creates an Amazon Chime Voice Connector under the administrator's AWS account.
// You can choose to create an Amazon Chime Voice Connector in a specific AWS
// Region.
//
// Enabling CreateVoiceConnectorRequest$RequireEncryption configures your Amazon
// Chime Voice Connector to use TLS transport for SIP signaling and Secure RTP
// (SRTP) for media. Inbound calls use TLS transport, and unencrypted outbound
// calls are blocked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnector
func (c *Chime) CreateVoiceConnector(input *CreateVoiceConnectorInput) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorWithContext is the same as CreateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateVoiceConnectorWithContext(ctx aws.Context, input *CreateVoiceConnectorInput, opts ...request.Option) (*CreateVoiceConnectorOutput, error) {
	req, out := c.CreateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVoiceConnectorGroup = "CreateVoiceConnectorGroup"

// CreateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVoiceConnectorGroup for more information on using the CreateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVoiceConnectorGroupRequest method.
//    req, resp := client.CreateVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup
func (c *Chime) CreateVoiceConnectorGroupRequest(input *CreateVoiceConnectorGroupInput) (req *request.Request, output *CreateVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opCreateVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups",
	}

	if input == nil {
		input = &CreateVoiceConnectorGroupInput{}
	}

	output = &CreateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVoiceConnectorGroup API operation for Amazon Chime.
//
// Creates an Amazon Chime Voice Connector group under the administrator's AWS
// account. You can associate Amazon Chime Voice Connectors with the Amazon
// Chime Voice Connector group by including VoiceConnectorItems in the request.
//
// You can include Amazon Chime Voice Connectors from different AWS Regions
// in your group. This creates a fault tolerant mechanism for fallback in case
// of availability events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation CreateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/CreateVoiceConnectorGroup
func (c *Chime) CreateVoiceConnectorGroup(input *CreateVoiceConnectorGroupInput) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// CreateVoiceConnectorGroupWithContext is the same as CreateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) CreateVoiceConnectorGroupWithContext(ctx aws.Context, input *CreateVoiceConnectorGroupInput, opts ...request.Option) (*CreateVoiceConnectorGroupOutput, error) {
	req, out := c.CreateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccount = "DeleteAccount"

// DeleteAccountRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccount for more information on using the DeleteAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAccountRequest method.
//    req, resp := client.DeleteAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccountRequest(input *DeleteAccountInput) (req *request.Request, output *DeleteAccountOutput) {
	op := &request.Operation{
		Name:       opDeleteAccount,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &DeleteAccountInput{}
	}

	output = &DeleteAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccount API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime account. You must suspend all users before
// deleting a Team account. You can use the BatchSuspendUser action to do so.
//
// For EnterpriseLWA and EnterpriseAD accounts, you must release the claimed
// domains for your Amazon Chime account before deletion. As soon as you release
// the domain, all users under that account are suspended.
//
// Deleted accounts appear in your Disabled accounts list for 90 days. To restore
// a deleted account from your Disabled accounts list, you must contact AWS
// Support.
//
// After 90 days, deleted accounts are permanently removed from your Disabled
// accounts list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnprocessableEntityException
//   The request was well-formed but was unable to be followed due to semantic
//   errors.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAccount
func (c *Chime) DeleteAccount(input *DeleteAccountInput) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	return out, req.Send()
}

// DeleteAccountWithContext is the same as DeleteAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteAccountWithContext(ctx aws.Context, input *DeleteAccountInput, opts ...request.Option) (*DeleteAccountOutput, error) {
	req, out := c.DeleteAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttendee = "DeleteAttendee"

// DeleteAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttendee for more information on using the DeleteAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAttendeeRequest method.
//    req, resp := client.DeleteAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee
func (c *Chime) DeleteAttendeeRequest(input *DeleteAttendeeInput) (req *request.Request, output *DeleteAttendeeOutput) {
	op := &request.Operation{
		Name:       opDeleteAttendee,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}",
	}

	if input == nil {
		input = &DeleteAttendeeInput{}
	}

	output = &DeleteAttendeeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAttendee API operation for Amazon Chime.
//
// Deletes an attendee from the specified Amazon Chime SDK meeting and deletes
// their JoinToken. Attendees are automatically deleted when a Amazon Chime
// SDK meeting is deleted. For more information about the Amazon Chime SDK,
// see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteAttendee
func (c *Chime) DeleteAttendee(input *DeleteAttendeeInput) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	return out, req.Send()
}

// DeleteAttendeeWithContext is the same as DeleteAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteAttendeeWithContext(ctx aws.Context, input *DeleteAttendeeInput, opts ...request.Option) (*DeleteAttendeeOutput, error) {
	req, out := c.DeleteAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventsConfiguration = "DeleteEventsConfiguration"

// DeleteEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventsConfiguration for more information on using the DeleteEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventsConfigurationRequest method.
//    req, resp := client.DeleteEventsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration
func (c *Chime) DeleteEventsConfigurationRequest(input *DeleteEventsConfigurationInput) (req *request.Request, output *DeleteEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEventsConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &DeleteEventsConfigurationInput{}
	}

	output = &DeleteEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventsConfiguration API operation for Amazon Chime.
//
// Deletes the events configuration that allows a bot to receive outgoing events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteEventsConfiguration for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteEventsConfiguration
func (c *Chime) DeleteEventsConfiguration(input *DeleteEventsConfigurationInput) (*DeleteEventsConfigurationOutput, error) {
	req, out := c.DeleteEventsConfigurationRequest(input)
	return out, req.Send()
}

// DeleteEventsConfigurationWithContext is the same as DeleteEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteEventsConfigurationWithContext(ctx aws.Context, input *DeleteEventsConfigurationInput, opts ...request.Option) (*DeleteEventsConfigurationOutput, error) {
	req, out := c.DeleteEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMeeting = "DeleteMeeting"

// DeleteMeetingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMeeting for more information on using the DeleteMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMeetingRequest method.
//    req, resp := client.DeleteMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting
func (c *Chime) DeleteMeetingRequest(input *DeleteMeetingInput) (req *request.Request, output *DeleteMeetingOutput) {
	op := &request.Operation{
		Name:       opDeleteMeeting,
		HTTPMethod: "DELETE",
		HTTPPath:   "/meetings/{meetingId}",
	}

	if input == nil {
		input = &DeleteMeetingInput{}
	}

	output = &DeleteMeetingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMeeting API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime SDK meeting. When a meeting is deleted,
// its attendees are also deleted and clients can no longer join it. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteMeeting for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteMeeting
func (c *Chime) DeleteMeeting(input *DeleteMeetingInput) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	return out, req.Send()
}

// DeleteMeetingWithContext is the same as DeleteMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteMeetingWithContext(ctx aws.Context, input *DeleteMeetingInput, opts ...request.Option) (*DeleteMeetingOutput, error) {
	req, out := c.DeleteMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePhoneNumber = "DeletePhoneNumber"

// DeletePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the DeletePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePhoneNumber for more information on using the DeletePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePhoneNumberRequest method.
//    req, resp := client.DeletePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber
func (c *Chime) DeletePhoneNumberRequest(input *DeletePhoneNumberInput) (req *request.Request, output *DeletePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opDeletePhoneNumber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &DeletePhoneNumberInput{}
	}

	output = &DeletePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePhoneNumber API operation for Amazon Chime.
//
// Moves the specified phone number into the Deletion queue. A phone number
// must be disassociated from any users or Amazon Chime Voice Connectors before
// it can be deleted.
//
// Deleted phone numbers remain in the Deletion queue for 7 days before they
// are deleted permanently.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeletePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeletePhoneNumber
func (c *Chime) DeletePhoneNumber(input *DeletePhoneNumberInput) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	return out, req.Send()
}

// DeletePhoneNumberWithContext is the same as DeletePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeletePhoneNumberWithContext(ctx aws.Context, input *DeletePhoneNumberInput, opts ...request.Option) (*DeletePhoneNumberOutput, error) {
	req, out := c.DeletePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoom = "DeleteRoom"

// DeleteRoomRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoom for more information on using the DeleteRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomRequest method.
//    req, resp := client.DeleteRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom
func (c *Chime) DeleteRoomRequest(input *DeleteRoomInput) (req *request.Request, output *DeleteRoomOutput) {
	op := &request.Operation{
		Name:       opDeleteRoom,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &DeleteRoomInput{}
	}

	output = &DeleteRoomOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoom API operation for Amazon Chime.
//
// Deletes a chat room in an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteRoom for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoom
func (c *Chime) DeleteRoom(input *DeleteRoomInput) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	return out, req.Send()
}

// DeleteRoomWithContext is the same as DeleteRoom with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteRoomWithContext(ctx aws.Context, input *DeleteRoomInput, opts ...request.Option) (*DeleteRoomOutput, error) {
	req, out := c.DeleteRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRoomMembership = "DeleteRoomMembership"

// DeleteRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRoomMembership for more information on using the DeleteRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRoomMembershipRequest method.
//    req, resp := client.DeleteRoomMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership
func (c *Chime) DeleteRoomMembershipRequest(input *DeleteRoomMembershipInput) (req *request.Request, output *DeleteRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteRoomMembership,
		HTTPMethod: "DELETE",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &DeleteRoomMembershipInput{}
	}

	output = &DeleteRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRoomMembership API operation for Amazon Chime.
//
// Removes a member from a chat room in an Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteRoomMembership for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteRoomMembership
func (c *Chime) DeleteRoomMembership(input *DeleteRoomMembershipInput) (*DeleteRoomMembershipOutput, error) {
	req, out := c.DeleteRoomMembershipRequest(input)
	return out, req.Send()
}

// DeleteRoomMembershipWithContext is the same as DeleteRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteRoomMembershipWithContext(ctx aws.Context, input *DeleteRoomMembershipInput, opts ...request.Option) (*DeleteRoomMembershipOutput, error) {
	req, out := c.DeleteRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnector = "DeleteVoiceConnector"

// DeleteVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnector for more information on using the DeleteVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorRequest method.
//    req, resp := client.DeleteVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector
func (c *Chime) DeleteVoiceConnectorRequest(input *DeleteVoiceConnectorInput) (req *request.Request, output *DeleteVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnector,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorInput{}
	}

	output = &DeleteVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnector API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated
// with the Amazon Chime Voice Connector must be disassociated from it before
// it can be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnector
func (c *Chime) DeleteVoiceConnector(input *DeleteVoiceConnectorInput) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorWithContext is the same as DeleteVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorWithContext(ctx aws.Context, input *DeleteVoiceConnectorInput, opts ...request.Option) (*DeleteVoiceConnectorOutput, error) {
	req, out := c.DeleteVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorGroup = "DeleteVoiceConnectorGroup"

// DeleteVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorGroup for more information on using the DeleteVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorGroupRequest method.
//    req, resp := client.DeleteVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup
func (c *Chime) DeleteVoiceConnectorGroupRequest(input *DeleteVoiceConnectorGroupInput) (req *request.Request, output *DeleteVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &DeleteVoiceConnectorGroupInput{}
	}

	output = &DeleteVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorGroup API operation for Amazon Chime.
//
// Deletes the specified Amazon Chime Voice Connector group. Any VoiceConnectorItems
// and phone numbers associated with the group must be removed before it can
// be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorGroup
func (c *Chime) DeleteVoiceConnectorGroup(input *DeleteVoiceConnectorGroupInput) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorGroupWithContext is the same as DeleteVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorGroupWithContext(ctx aws.Context, input *DeleteVoiceConnectorGroupInput, opts ...request.Option) (*DeleteVoiceConnectorGroupOutput, error) {
	req, out := c.DeleteVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorOrigination = "DeleteVoiceConnectorOrigination"

// DeleteVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorOrigination for more information on using the DeleteVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorOriginationRequest method.
//    req, resp := client.DeleteVoiceConnectorOriginationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination
func (c *Chime) DeleteVoiceConnectorOriginationRequest(input *DeleteVoiceConnectorOriginationInput) (req *request.Request, output *DeleteVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorOrigination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorOriginationInput{}
	}

	output = &DeleteVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorOrigination API operation for Amazon Chime.
//
// Deletes the origination settings for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorOrigination
func (c *Chime) DeleteVoiceConnectorOrigination(input *DeleteVoiceConnectorOriginationInput) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorOriginationWithContext is the same as DeleteVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorOriginationWithContext(ctx aws.Context, input *DeleteVoiceConnectorOriginationInput, opts ...request.Option) (*DeleteVoiceConnectorOriginationOutput, error) {
	req, out := c.DeleteVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorStreamingConfiguration = "DeleteVoiceConnectorStreamingConfiguration"

// DeleteVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorStreamingConfiguration for more information on using the DeleteVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorStreamingConfigurationRequest method.
//    req, resp := client.DeleteVoiceConnectorStreamingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration
func (c *Chime) DeleteVoiceConnectorStreamingConfigurationRequest(input *DeleteVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *DeleteVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorStreamingConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &DeleteVoiceConnectorStreamingConfigurationInput{}
	}

	output = &DeleteVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Deletes the streaming configuration for the specified Amazon Chime Voice
// Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorStreamingConfiguration
func (c *Chime) DeleteVoiceConnectorStreamingConfiguration(input *DeleteVoiceConnectorStreamingConfigurationInput) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorStreamingConfigurationWithContext is the same as DeleteVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *DeleteVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*DeleteVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.DeleteVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTermination = "DeleteVoiceConnectorTermination"

// DeleteVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTermination for more information on using the DeleteVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorTerminationRequest method.
//    req, resp := client.DeleteVoiceConnectorTerminationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination
func (c *Chime) DeleteVoiceConnectorTerminationRequest(input *DeleteVoiceConnectorTerminationInput) (req *request.Request, output *DeleteVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTermination,
		HTTPMethod: "DELETE",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationInput{}
	}

	output = &DeleteVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTermination API operation for Amazon Chime.
//
// Deletes the termination settings for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTermination
func (c *Chime) DeleteVoiceConnectorTermination(input *DeleteVoiceConnectorTerminationInput) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationWithContext is the same as DeleteVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorTerminationWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVoiceConnectorTerminationCredentials = "DeleteVoiceConnectorTerminationCredentials"

// DeleteVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVoiceConnectorTerminationCredentials for more information on using the DeleteVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVoiceConnectorTerminationCredentialsRequest method.
//    req, resp := client.DeleteVoiceConnectorTerminationCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials
func (c *Chime) DeleteVoiceConnectorTerminationCredentialsRequest(input *DeleteVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *DeleteVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opDeleteVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=delete",
	}

	if input == nil {
		input = &DeleteVoiceConnectorTerminationCredentialsInput{}
	}

	output = &DeleteVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Deletes the specified SIP credentials used by your equipment to authenticate
// during call termination.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DeleteVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DeleteVoiceConnectorTerminationCredentials
func (c *Chime) DeleteVoiceConnectorTerminationCredentials(input *DeleteVoiceConnectorTerminationCredentialsInput) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// DeleteVoiceConnectorTerminationCredentialsWithContext is the same as DeleteVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DeleteVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *DeleteVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*DeleteVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.DeleteVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumberFromUser = "DisassociatePhoneNumberFromUser"

// DisassociatePhoneNumberFromUserRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumberFromUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumberFromUser for more information on using the DisassociatePhoneNumberFromUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociatePhoneNumberFromUserRequest method.
//    req, resp := client.DisassociatePhoneNumberFromUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser
func (c *Chime) DisassociatePhoneNumberFromUserRequest(input *DisassociatePhoneNumberFromUserInput) (req *request.Request, output *DisassociatePhoneNumberFromUserOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumberFromUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=disassociate-phone-number",
	}

	if input == nil {
		input = &DisassociatePhoneNumberFromUserInput{}
	}

	output = &DisassociatePhoneNumberFromUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociatePhoneNumberFromUser API operation for Amazon Chime.
//
// Disassociates the primary provisioned phone number from the specified Amazon
// Chime user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumberFromUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumberFromUser
func (c *Chime) DisassociatePhoneNumberFromUser(input *DisassociatePhoneNumberFromUserInput) (*DisassociatePhoneNumberFromUserOutput, error) {
	req, out := c.DisassociatePhoneNumberFromUserRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumberFromUserWithContext is the same as DisassociatePhoneNumberFromUser with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumberFromUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociatePhoneNumberFromUserWithContext(ctx aws.Context, input *DisassociatePhoneNumberFromUserInput, opts ...request.Option) (*DisassociatePhoneNumberFromUserOutput, error) {
	req, out := c.DisassociatePhoneNumberFromUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnector = "DisassociatePhoneNumbersFromVoiceConnector"

// DisassociatePhoneNumbersFromVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnector for more information on using the DisassociatePhoneNumbersFromVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorRequest method.
//    req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorRequest(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnector,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnector API operation for Amazon Chime.
//
// Disassociates the specified phone numbers from the specified Amazon Chime
// Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumbersFromVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnector
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnector(input *DisassociatePhoneNumbersFromVoiceConnectorInput) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorWithContext is the same as DisassociatePhoneNumbersFromVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumbersFromVoiceConnectorGroup = "DisassociatePhoneNumbersFromVoiceConnectorGroup"

// DisassociatePhoneNumbersFromVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumbersFromVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for more information on using the DisassociatePhoneNumbersFromVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociatePhoneNumbersFromVoiceConnectorGroupRequest method.
//    req, resp := client.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (req *request.Request, output *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumbersFromVoiceConnectorGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}?operation=disassociate-phone-numbers",
	}

	if input == nil {
		input = &DisassociatePhoneNumbersFromVoiceConnectorGroupInput{}
	}

	output = &DisassociatePhoneNumbersFromVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociatePhoneNumbersFromVoiceConnectorGroup API operation for Amazon Chime.
//
// Disassociates the specified phone numbers from the specified Amazon Chime
// Voice Connector group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociatePhoneNumbersFromVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociatePhoneNumbersFromVoiceConnectorGroup
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroup(input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext is the same as DisassociatePhoneNumbersFromVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumbersFromVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext(ctx aws.Context, input *DisassociatePhoneNumbersFromVoiceConnectorGroupInput, opts ...request.Option) (*DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error) {
	req, out := c.DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSigninDelegateGroupsFromAccount = "DisassociateSigninDelegateGroupsFromAccount"

// DisassociateSigninDelegateGroupsFromAccountRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSigninDelegateGroupsFromAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSigninDelegateGroupsFromAccount for more information on using the DisassociateSigninDelegateGroupsFromAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateSigninDelegateGroupsFromAccountRequest method.
//    req, resp := client.DisassociateSigninDelegateGroupsFromAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount
func (c *Chime) DisassociateSigninDelegateGroupsFromAccountRequest(input *DisassociateSigninDelegateGroupsFromAccountInput) (req *request.Request, output *DisassociateSigninDelegateGroupsFromAccountOutput) {
	op := &request.Operation{
		Name:       opDisassociateSigninDelegateGroupsFromAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}?operation=disassociate-signin-delegate-groups",
	}

	if input == nil {
		input = &DisassociateSigninDelegateGroupsFromAccountInput{}
	}

	output = &DisassociateSigninDelegateGroupsFromAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSigninDelegateGroupsFromAccount API operation for Amazon Chime.
//
// Disassociates the specified sign-in delegate groups from the specified Amazon
// Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation DisassociateSigninDelegateGroupsFromAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/DisassociateSigninDelegateGroupsFromAccount
func (c *Chime) DisassociateSigninDelegateGroupsFromAccount(input *DisassociateSigninDelegateGroupsFromAccountInput) (*DisassociateSigninDelegateGroupsFromAccountOutput, error) {
	req, out := c.DisassociateSigninDelegateGroupsFromAccountRequest(input)
	return out, req.Send()
}

// DisassociateSigninDelegateGroupsFromAccountWithContext is the same as DisassociateSigninDelegateGroupsFromAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSigninDelegateGroupsFromAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) DisassociateSigninDelegateGroupsFromAccountWithContext(ctx aws.Context, input *DisassociateSigninDelegateGroupsFromAccountInput, opts ...request.Option) (*DisassociateSigninDelegateGroupsFromAccountOutput, error) {
	req, out := c.DisassociateSigninDelegateGroupsFromAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountRequest method.
//    req, resp := client.GetAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *GetAccountOutput) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &GetAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime account, such as account
// type and supported licenses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccount
func (c *Chime) GetAccount(input *GetAccountInput) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*GetAccountOutput, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for Amazon Chime.
//
// Retrieves account settings for the specified Amazon Chime account ID, such
// as remote control and dial out settings. For more information about these
// settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAccountSettings
func (c *Chime) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttendee = "GetAttendee"

// GetAttendeeRequest generates a "aws/request.Request" representing the
// client's request for the GetAttendee operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttendee for more information on using the GetAttendee
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAttendeeRequest method.
//    req, resp := client.GetAttendeeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee
func (c *Chime) GetAttendeeRequest(input *GetAttendeeInput) (req *request.Request, output *GetAttendeeOutput) {
	op := &request.Operation{
		Name:       opGetAttendee,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees/{attendeeId}",
	}

	if input == nil {
		input = &GetAttendeeInput{}
	}

	output = &GetAttendeeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttendee API operation for Amazon Chime.
//
// Gets the Amazon Chime SDK attendee details for a specified meeting ID and
// attendee ID. For more information about the Amazon Chime SDK, see Using the
// Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetAttendee for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetAttendee
func (c *Chime) GetAttendee(input *GetAttendeeInput) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	return out, req.Send()
}

// GetAttendeeWithContext is the same as GetAttendee with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttendee for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetAttendeeWithContext(ctx aws.Context, input *GetAttendeeInput, opts ...request.Option) (*GetAttendeeOutput, error) {
	req, out := c.GetAttendeeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBot = "GetBot"

// GetBotRequest generates a "aws/request.Request" representing the
// client's request for the GetBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBot for more information on using the GetBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBotRequest method.
//    req, resp := client.GetBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot
func (c *Chime) GetBotRequest(input *GetBotInput) (req *request.Request, output *GetBotOutput) {
	op := &request.Operation{
		Name:       opGetBot,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}",
	}

	if input == nil {
		input = &GetBotInput{}
	}

	output = &GetBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBot API operation for Amazon Chime.
//
// Retrieves details for the specified bot, such as bot email address, bot type,
// status, and display name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetBot for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetBot
func (c *Chime) GetBot(input *GetBotInput) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	return out, req.Send()
}

// GetBotWithContext is the same as GetBot with the addition of
// the ability to pass a context and additional request options.
//
// See GetBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetBotWithContext(ctx aws.Context, input *GetBotInput, opts ...request.Option) (*GetBotOutput, error) {
	req, out := c.GetBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventsConfiguration = "GetEventsConfiguration"

// GetEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventsConfiguration for more information on using the GetEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventsConfigurationRequest method.
//    req, resp := client.GetEventsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration
func (c *Chime) GetEventsConfigurationRequest(input *GetEventsConfigurationInput) (req *request.Request, output *GetEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetEventsConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &GetEventsConfigurationInput{}
	}

	output = &GetEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventsConfiguration API operation for Amazon Chime.
//
// Gets details for an events configuration that allows a bot to receive outgoing
// events, such as an HTTPS endpoint or Lambda function ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetEventsConfiguration for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetEventsConfiguration
func (c *Chime) GetEventsConfiguration(input *GetEventsConfigurationInput) (*GetEventsConfigurationOutput, error) {
	req, out := c.GetEventsConfigurationRequest(input)
	return out, req.Send()
}

// GetEventsConfigurationWithContext is the same as GetEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetEventsConfigurationWithContext(ctx aws.Context, input *GetEventsConfigurationInput, opts ...request.Option) (*GetEventsConfigurationOutput, error) {
	req, out := c.GetEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGlobalSettings = "GetGlobalSettings"

// GetGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGlobalSettings for more information on using the GetGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGlobalSettingsRequest method.
//    req, resp := client.GetGlobalSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings
func (c *Chime) GetGlobalSettingsRequest(input *GetGlobalSettingsInput) (req *request.Request, output *GetGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opGetGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &GetGlobalSettingsInput{}
	}

	output = &GetGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGlobalSettings API operation for Amazon Chime.
//
// Retrieves global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetGlobalSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetGlobalSettings
func (c *Chime) GetGlobalSettings(input *GetGlobalSettingsInput) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	return out, req.Send()
}

// GetGlobalSettingsWithContext is the same as GetGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetGlobalSettingsWithContext(ctx aws.Context, input *GetGlobalSettingsInput, opts ...request.Option) (*GetGlobalSettingsOutput, error) {
	req, out := c.GetGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMeeting = "GetMeeting"

// GetMeetingRequest generates a "aws/request.Request" representing the
// client's request for the GetMeeting operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMeeting for more information on using the GetMeeting
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMeetingRequest method.
//    req, resp := client.GetMeetingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting
func (c *Chime) GetMeetingRequest(input *GetMeetingInput) (req *request.Request, output *GetMeetingOutput) {
	op := &request.Operation{
		Name:       opGetMeeting,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}",
	}

	if input == nil {
		input = &GetMeetingInput{}
	}

	output = &GetMeetingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMeeting API operation for Amazon Chime.
//
// Gets the Amazon Chime SDK meeting details for the specified meeting ID. For
// more information about the Amazon Chime SDK, see Using the Amazon Chime SDK
// (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html) in the Amazon
// Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetMeeting for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetMeeting
func (c *Chime) GetMeeting(input *GetMeetingInput) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	return out, req.Send()
}

// GetMeetingWithContext is the same as GetMeeting with the addition of
// the ability to pass a context and additional request options.
//
// See GetMeeting for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetMeetingWithContext(ctx aws.Context, input *GetMeetingInput, opts ...request.Option) (*GetMeetingOutput, error) {
	req, out := c.GetMeetingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumber = "GetPhoneNumber"

// GetPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumber for more information on using the GetPhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPhoneNumberRequest method.
//    req, resp := client.GetPhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber
func (c *Chime) GetPhoneNumberRequest(input *GetPhoneNumberInput) (req *request.Request, output *GetPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumber,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &GetPhoneNumberInput{}
	}

	output = &GetPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumber API operation for Amazon Chime.
//
// Retrieves details for the specified phone number ID, such as associations,
// capabilities, and product type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumber
func (c *Chime) GetPhoneNumber(input *GetPhoneNumberInput) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	return out, req.Send()
}

// GetPhoneNumberWithContext is the same as GetPhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberWithContext(ctx aws.Context, input *GetPhoneNumberInput, opts ...request.Option) (*GetPhoneNumberOutput, error) {
	req, out := c.GetPhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberOrder = "GetPhoneNumberOrder"

// GetPhoneNumberOrderRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberOrder operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberOrder for more information on using the GetPhoneNumberOrder
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPhoneNumberOrderRequest method.
//    req, resp := client.GetPhoneNumberOrderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder
func (c *Chime) GetPhoneNumberOrderRequest(input *GetPhoneNumberOrderInput) (req *request.Request, output *GetPhoneNumberOrderOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberOrder,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders/{phoneNumberOrderId}",
	}

	if input == nil {
		input = &GetPhoneNumberOrderInput{}
	}

	output = &GetPhoneNumberOrderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberOrder API operation for Amazon Chime.
//
// Retrieves details for the specified phone number order, such as order creation
// timestamp, phone numbers in E.164 format, product type, and order status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumberOrder for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberOrder
func (c *Chime) GetPhoneNumberOrder(input *GetPhoneNumberOrderInput) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	return out, req.Send()
}

// GetPhoneNumberOrderWithContext is the same as GetPhoneNumberOrder with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberOrder for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberOrderWithContext(ctx aws.Context, input *GetPhoneNumberOrderInput, opts ...request.Option) (*GetPhoneNumberOrderOutput, error) {
	req, out := c.GetPhoneNumberOrderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPhoneNumberSettings = "GetPhoneNumberSettings"

// GetPhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetPhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPhoneNumberSettings for more information on using the GetPhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPhoneNumberSettingsRequest method.
//    req, resp := client.GetPhoneNumberSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings
func (c *Chime) GetPhoneNumberSettingsRequest(input *GetPhoneNumberSettingsInput) (req *request.Request, output *GetPhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opGetPhoneNumberSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &GetPhoneNumberSettingsInput{}
	}

	output = &GetPhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPhoneNumberSettings API operation for Amazon Chime.
//
// Retrieves the phone number settings for the administrator's AWS account,
// such as the default outbound calling name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetPhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetPhoneNumberSettings
func (c *Chime) GetPhoneNumberSettings(input *GetPhoneNumberSettingsInput) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// GetPhoneNumberSettingsWithContext is the same as GetPhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetPhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetPhoneNumberSettingsWithContext(ctx aws.Context, input *GetPhoneNumberSettingsInput, opts ...request.Option) (*GetPhoneNumberSettingsOutput, error) {
	req, out := c.GetPhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRoom = "GetRoom"

// GetRoomRequest generates a "aws/request.Request" representing the
// client's request for the GetRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRoom for more information on using the GetRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRoomRequest method.
//    req, resp := client.GetRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom
func (c *Chime) GetRoomRequest(input *GetRoomInput) (req *request.Request, output *GetRoomOutput) {
	op := &request.Operation{
		Name:       opGetRoom,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &GetRoomInput{}
	}

	output = &GetRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRoom API operation for Amazon Chime.
//
// Retrieves room details, such as the room name, for a room in an Amazon Chime
// Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetRoom for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetRoom
func (c *Chime) GetRoom(input *GetRoomInput) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	return out, req.Send()
}

// GetRoomWithContext is the same as GetRoom with the addition of
// the ability to pass a context and additional request options.
//
// See GetRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetRoomWithContext(ctx aws.Context, input *GetRoomInput, opts ...request.Option) (*GetRoomOutput, error) {
	req, out := c.GetRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUser for more information on using the GetUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUser API operation for Amazon Chime.
//
// Retrieves details for the specified user ID, such as primary email address,
// license type, and personal meeting PIN.
//
// To retrieve user details with an email address instead of a user ID, use
// the ListUsers action, and then filter by email address.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUser
func (c *Chime) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	return out, req.Send()
}

// GetUserWithContext is the same as GetUser with the addition of
// the ability to pass a context and additional request options.
//
// See GetUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetUserWithContext(ctx aws.Context, input *GetUserInput, opts ...request.Option) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUserSettings = "GetUserSettings"

// GetUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUserSettings for more information on using the GetUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUserSettingsRequest method.
//    req, resp := client.GetUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings
func (c *Chime) GetUserSettingsRequest(input *GetUserSettingsInput) (req *request.Request, output *GetUserSettingsOutput) {
	op := &request.Operation{
		Name:       opGetUserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users/{userId}/settings",
	}

	if input == nil {
		input = &GetUserSettingsInput{}
	}

	output = &GetUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserSettings API operation for Amazon Chime.
//
// Retrieves settings for the specified user ID, such as any associated phone
// number settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetUserSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings
func (c *Chime) GetUserSettings(input *GetUserSettingsInput) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	return out, req.Send()
}

// GetUserSettingsWithContext is the same as GetUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetUserSettingsWithContext(ctx aws.Context, input *GetUserSettingsInput, opts ...request.Option) (*GetUserSettingsOutput, error) {
	req, out := c.GetUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnector = "GetVoiceConnector"

// GetVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnector for more information on using the GetVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorRequest method.
//    req, resp := client.GetVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector
func (c *Chime) GetVoiceConnectorRequest(input *GetVoiceConnectorInput) (req *request.Request, output *GetVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnector,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &GetVoiceConnectorInput{}
	}

	output = &GetVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnector API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime Voice Connector, such as
// timestamps, name, outbound host, and encryption requirements.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnector
func (c *Chime) GetVoiceConnector(input *GetVoiceConnectorInput) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorWithContext is the same as GetVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorWithContext(ctx aws.Context, input *GetVoiceConnectorInput, opts ...request.Option) (*GetVoiceConnectorOutput, error) {
	req, out := c.GetVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorGroup = "GetVoiceConnectorGroup"

// GetVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorGroup for more information on using the GetVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorGroupRequest method.
//    req, resp := client.GetVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup
func (c *Chime) GetVoiceConnectorGroupRequest(input *GetVoiceConnectorGroupInput) (req *request.Request, output *GetVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &GetVoiceConnectorGroupInput{}
	}

	output = &GetVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorGroup API operation for Amazon Chime.
//
// Retrieves details for the specified Amazon Chime Voice Connector group, such
// as timestamps, name, and associated VoiceConnectorItems.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorGroup
func (c *Chime) GetVoiceConnectorGroup(input *GetVoiceConnectorGroupInput) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorGroupWithContext is the same as GetVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorGroupWithContext(ctx aws.Context, input *GetVoiceConnectorGroupInput, opts ...request.Option) (*GetVoiceConnectorGroupOutput, error) {
	req, out := c.GetVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorLoggingConfiguration = "GetVoiceConnectorLoggingConfiguration"

// GetVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorLoggingConfiguration for more information on using the GetVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorLoggingConfigurationRequest method.
//    req, resp := client.GetVoiceConnectorLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration
func (c *Chime) GetVoiceConnectorLoggingConfigurationRequest(input *GetVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *GetVoiceConnectorLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorLoggingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorLoggingConfigurationInput{}
	}

	output = &GetVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorLoggingConfiguration API operation for Amazon Chime.
//
// Retrieves the logging configuration details for the specified Amazon Chime
// Voice Connector. Shows whether SIP message logs are enabled for sending to
// Amazon CloudWatch Logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorLoggingConfiguration
func (c *Chime) GetVoiceConnectorLoggingConfiguration(input *GetVoiceConnectorLoggingConfigurationInput) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorLoggingConfigurationWithContext is the same as GetVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorOrigination = "GetVoiceConnectorOrigination"

// GetVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorOrigination for more information on using the GetVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorOriginationRequest method.
//    req, resp := client.GetVoiceConnectorOriginationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination
func (c *Chime) GetVoiceConnectorOriginationRequest(input *GetVoiceConnectorOriginationInput) (req *request.Request, output *GetVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorOrigination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &GetVoiceConnectorOriginationInput{}
	}

	output = &GetVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorOrigination API operation for Amazon Chime.
//
// Retrieves origination setting details for the specified Amazon Chime Voice
// Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorOrigination
func (c *Chime) GetVoiceConnectorOrigination(input *GetVoiceConnectorOriginationInput) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorOriginationWithContext is the same as GetVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorOriginationWithContext(ctx aws.Context, input *GetVoiceConnectorOriginationInput, opts ...request.Option) (*GetVoiceConnectorOriginationOutput, error) {
	req, out := c.GetVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorStreamingConfiguration = "GetVoiceConnectorStreamingConfiguration"

// GetVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorStreamingConfiguration for more information on using the GetVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorStreamingConfigurationRequest method.
//    req, resp := client.GetVoiceConnectorStreamingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration
func (c *Chime) GetVoiceConnectorStreamingConfigurationRequest(input *GetVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *GetVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorStreamingConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &GetVoiceConnectorStreamingConfigurationInput{}
	}

	output = &GetVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Retrieves the streaming configuration details for the specified Amazon Chime
// Voice Connector. Shows whether media streaming is enabled for sending to
// Amazon Kinesis. It also shows the retention period, in hours, for the Amazon
// Kinesis data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorStreamingConfiguration
func (c *Chime) GetVoiceConnectorStreamingConfiguration(input *GetVoiceConnectorStreamingConfigurationInput) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorStreamingConfigurationWithContext is the same as GetVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *GetVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*GetVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.GetVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTermination = "GetVoiceConnectorTermination"

// GetVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTermination for more information on using the GetVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorTerminationRequest method.
//    req, resp := client.GetVoiceConnectorTerminationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination
func (c *Chime) GetVoiceConnectorTerminationRequest(input *GetVoiceConnectorTerminationInput) (req *request.Request, output *GetVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorTermination,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationInput{}
	}

	output = &GetVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTermination API operation for Amazon Chime.
//
// Retrieves termination setting details for the specified Amazon Chime Voice
// Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTermination
func (c *Chime) GetVoiceConnectorTermination(input *GetVoiceConnectorTerminationInput) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationWithContext is the same as GetVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorTerminationWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationInput, opts ...request.Option) (*GetVoiceConnectorTerminationOutput, error) {
	req, out := c.GetVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVoiceConnectorTerminationHealth = "GetVoiceConnectorTerminationHealth"

// GetVoiceConnectorTerminationHealthRequest generates a "aws/request.Request" representing the
// client's request for the GetVoiceConnectorTerminationHealth operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVoiceConnectorTerminationHealth for more information on using the GetVoiceConnectorTerminationHealth
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVoiceConnectorTerminationHealthRequest method.
//    req, resp := client.GetVoiceConnectorTerminationHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth
func (c *Chime) GetVoiceConnectorTerminationHealthRequest(input *GetVoiceConnectorTerminationHealthInput) (req *request.Request, output *GetVoiceConnectorTerminationHealthOutput) {
	op := &request.Operation{
		Name:       opGetVoiceConnectorTerminationHealth,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/health",
	}

	if input == nil {
		input = &GetVoiceConnectorTerminationHealthInput{}
	}

	output = &GetVoiceConnectorTerminationHealthOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVoiceConnectorTerminationHealth API operation for Amazon Chime.
//
// Retrieves information about the last time a SIP OPTIONS ping was received
// from your SIP infrastructure for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation GetVoiceConnectorTerminationHealth for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetVoiceConnectorTerminationHealth
func (c *Chime) GetVoiceConnectorTerminationHealth(input *GetVoiceConnectorTerminationHealthInput) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	return out, req.Send()
}

// GetVoiceConnectorTerminationHealthWithContext is the same as GetVoiceConnectorTerminationHealth with the addition of
// the ability to pass a context and additional request options.
//
// See GetVoiceConnectorTerminationHealth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) GetVoiceConnectorTerminationHealthWithContext(ctx aws.Context, input *GetVoiceConnectorTerminationHealthInput, opts ...request.Option) (*GetVoiceConnectorTerminationHealthOutput, error) {
	req, out := c.GetVoiceConnectorTerminationHealthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opInviteUsers = "InviteUsers"

// InviteUsersRequest generates a "aws/request.Request" representing the
// client's request for the InviteUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See InviteUsers for more information on using the InviteUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the InviteUsersRequest method.
//    req, resp := client.InviteUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsersRequest(input *InviteUsersInput) (req *request.Request, output *InviteUsersOutput) {
	op := &request.Operation{
		Name:       opInviteUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users?operation=add",
	}

	if input == nil {
		input = &InviteUsersInput{}
	}

	output = &InviteUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InviteUsers API operation for Amazon Chime.
//
// Sends email to a maximum of 50 users, inviting them to the specified Amazon
// Chime Team account. Only Team account types are currently supported for this
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation InviteUsers for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/InviteUsers
func (c *Chime) InviteUsers(input *InviteUsersInput) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	return out, req.Send()
}

// InviteUsersWithContext is the same as InviteUsers with the addition of
// the ability to pass a context and additional request options.
//
// See InviteUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) InviteUsersWithContext(ctx aws.Context, input *InviteUsersInput, opts ...request.Option) (*InviteUsersOutput, error) {
	req, out := c.InviteUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccounts = "ListAccounts"

// ListAccountsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccounts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccounts for more information on using the ListAccounts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountsRequest method.
//    req, resp := client.ListAccountsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccountsRequest(input *ListAccountsInput) (req *request.Request, output *ListAccountsOutput) {
	op := &request.Operation{
		Name:       opListAccounts,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsInput{}
	}

	output = &ListAccountsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccounts API operation for Amazon Chime.
//
// Lists the Amazon Chime accounts under the administrator's AWS account. You
// can filter accounts by account name prefix. To find out which Amazon Chime
// account a user belongs to, you can filter by the user's email address, which
// returns one account result.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAccounts for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAccounts
func (c *Chime) ListAccounts(input *ListAccountsInput) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	return out, req.Send()
}

// ListAccountsWithContext is the same as ListAccounts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccounts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsWithContext(ctx aws.Context, input *ListAccountsInput, opts ...request.Option) (*ListAccountsOutput, error) {
	req, out := c.ListAccountsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsPages iterates over the pages of a ListAccounts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccounts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccounts operation.
//    pageNum := 0
//    err := client.ListAccountsPages(params,
//        func(page *chime.ListAccountsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListAccountsPages(input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool) error {
	return c.ListAccountsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsPagesWithContext same as ListAccountsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAccountsPagesWithContext(ctx aws.Context, input *ListAccountsInput, fn func(*ListAccountsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAttendees = "ListAttendees"

// ListAttendeesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttendees operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttendees for more information on using the ListAttendees
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttendeesRequest method.
//    req, resp := client.ListAttendeesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees
func (c *Chime) ListAttendeesRequest(input *ListAttendeesInput) (req *request.Request, output *ListAttendeesOutput) {
	op := &request.Operation{
		Name:       opListAttendees,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings/{meetingId}/attendees",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttendeesInput{}
	}

	output = &ListAttendeesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttendees API operation for Amazon Chime.
//
// Lists the attendees for the specified Amazon Chime SDK meeting. For more
// information about the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListAttendees for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListAttendees
func (c *Chime) ListAttendees(input *ListAttendeesInput) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	return out, req.Send()
}

// ListAttendeesWithContext is the same as ListAttendees with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttendees for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAttendeesWithContext(ctx aws.Context, input *ListAttendeesInput, opts ...request.Option) (*ListAttendeesOutput, error) {
	req, out := c.ListAttendeesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttendeesPages iterates over the pages of a ListAttendees operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttendees method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttendees operation.
//    pageNum := 0
//    err := client.ListAttendeesPages(params,
//        func(page *chime.ListAttendeesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListAttendeesPages(input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool) error {
	return c.ListAttendeesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttendeesPagesWithContext same as ListAttendeesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListAttendeesPagesWithContext(ctx aws.Context, input *ListAttendeesInput, fn func(*ListAttendeesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttendeesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttendeesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttendeesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBots = "ListBots"

// ListBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBots for more information on using the ListBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBotsRequest method.
//    req, resp := client.ListBotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots
func (c *Chime) ListBotsRequest(input *ListBotsInput) (req *request.Request, output *ListBotsOutput) {
	op := &request.Operation{
		Name:       opListBots,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/bots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotsInput{}
	}

	output = &ListBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBots API operation for Amazon Chime.
//
// Lists the bots associated with the administrator's Amazon Chime Enterprise
// account ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListBots for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListBots
func (c *Chime) ListBots(input *ListBotsInput) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	return out, req.Send()
}

// ListBotsWithContext is the same as ListBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListBotsWithContext(ctx aws.Context, input *ListBotsInput, opts ...request.Option) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotsPages iterates over the pages of a ListBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBots operation.
//    pageNum := 0
//    err := client.ListBotsPages(params,
//        func(page *chime.ListBotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListBotsPages(input *ListBotsInput, fn func(*ListBotsOutput, bool) bool) error {
	return c.ListBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotsPagesWithContext same as ListBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListBotsPagesWithContext(ctx aws.Context, input *ListBotsInput, fn func(*ListBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMeetings = "ListMeetings"

// ListMeetingsRequest generates a "aws/request.Request" representing the
// client's request for the ListMeetings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeetings for more information on using the ListMeetings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMeetingsRequest method.
//    req, resp := client.ListMeetingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings
func (c *Chime) ListMeetingsRequest(input *ListMeetingsInput) (req *request.Request, output *ListMeetingsOutput) {
	op := &request.Operation{
		Name:       opListMeetings,
		HTTPMethod: "GET",
		HTTPPath:   "/meetings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeetingsInput{}
	}

	output = &ListMeetingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMeetings API operation for Amazon Chime.
//
// Lists up to 100 active Amazon Chime SDK meetings. For more information about
// the Amazon Chime SDK, see Using the Amazon Chime SDK (https://docs.aws.amazon.com/chime/latest/dg/meetings-sdk.html)
// in the Amazon Chime Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListMeetings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListMeetings
func (c *Chime) ListMeetings(input *ListMeetingsInput) (*ListMeetingsOutput, error) {
	req, out := c.ListMeetingsRequest(input)
	return out, req.Send()
}

// ListMeetingsWithContext is the same as ListMeetings with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeetings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListMeetingsWithContext(ctx aws.Context, input *ListMeetingsInput, opts ...request.Option) (*ListMeetingsOutput, error) {
	req, out := c.ListMeetingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeetingsPages iterates over the pages of a ListMeetings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeetings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMeetings operation.
//    pageNum := 0
//    err := client.ListMeetingsPages(params,
//        func(page *chime.ListMeetingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListMeetingsPages(input *ListMeetingsInput, fn func(*ListMeetingsOutput, bool) bool) error {
	return c.ListMeetingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeetingsPagesWithContext same as ListMeetingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListMeetingsPagesWithContext(ctx aws.Context, input *ListMeetingsInput, fn func(*ListMeetingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeetingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeetingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMeetingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumberOrders = "ListPhoneNumberOrders"

// ListPhoneNumberOrdersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumberOrders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumberOrders for more information on using the ListPhoneNumberOrders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPhoneNumberOrdersRequest method.
//    req, resp := client.ListPhoneNumberOrdersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders
func (c *Chime) ListPhoneNumberOrdersRequest(input *ListPhoneNumberOrdersInput) (req *request.Request, output *ListPhoneNumberOrdersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumberOrders,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumberOrdersInput{}
	}

	output = &ListPhoneNumberOrdersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumberOrders API operation for Amazon Chime.
//
// Lists the phone number orders for the administrator's Amazon Chime account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListPhoneNumberOrders for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders
func (c *Chime) ListPhoneNumberOrders(input *ListPhoneNumberOrdersInput) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	return out, req.Send()
}

// ListPhoneNumberOrdersWithContext is the same as ListPhoneNumberOrders with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumberOrders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumberOrdersWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, opts ...request.Option) (*ListPhoneNumberOrdersOutput, error) {
	req, out := c.ListPhoneNumberOrdersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumberOrdersPages iterates over the pages of a ListPhoneNumberOrders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumberOrders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPhoneNumberOrders operation.
//    pageNum := 0
//    err := client.ListPhoneNumberOrdersPages(params,
//        func(page *chime.ListPhoneNumberOrdersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListPhoneNumberOrdersPages(input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool) error {
	return c.ListPhoneNumberOrdersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumberOrdersPagesWithContext same as ListPhoneNumberOrdersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumberOrdersPagesWithContext(ctx aws.Context, input *ListPhoneNumberOrdersInput, fn func(*ListPhoneNumberOrdersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumberOrdersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumberOrdersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumberOrdersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbers for more information on using the ListPhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPhoneNumbersRequest method.
//    req, resp := client.ListPhoneNumbersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers
func (c *Chime) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) (req *request.Request, output *ListPhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	output = &ListPhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbers API operation for Amazon Chime.
//
// Lists the phone numbers for the specified Amazon Chime account, Amazon Chime
// user, Amazon Chime Voice Connector, or Amazon Chime Voice Connector group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListPhoneNumbers for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumbers
func (c *Chime) ListPhoneNumbers(input *ListPhoneNumbersInput) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	return out, req.Send()
}

// ListPhoneNumbersWithContext is the same as ListPhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumbersWithContext(ctx aws.Context, input *ListPhoneNumbersInput, opts ...request.Option) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersPages iterates over the pages of a ListPhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPhoneNumbers operation.
//    pageNum := 0
//    err := client.ListPhoneNumbersPages(params,
//        func(page *chime.ListPhoneNumbersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListPhoneNumbersPages(input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool) error {
	return c.ListPhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersPagesWithContext same as ListPhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListPhoneNumbersPagesWithContext(ctx aws.Context, input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoomMemberships = "ListRoomMemberships"

// ListRoomMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the ListRoomMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoomMemberships for more information on using the ListRoomMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoomMembershipsRequest method.
//    req, resp := client.ListRoomMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships
func (c *Chime) ListRoomMembershipsRequest(input *ListRoomMembershipsInput) (req *request.Request, output *ListRoomMembershipsOutput) {
	op := &request.Operation{
		Name:       opListRoomMemberships,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomMembershipsInput{}
	}

	output = &ListRoomMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoomMemberships API operation for Amazon Chime.
//
// Lists the membership details for the specified room in an Amazon Chime Enterprise
// account, such as the members' IDs, email addresses, and names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListRoomMemberships for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRoomMemberships
func (c *Chime) ListRoomMemberships(input *ListRoomMembershipsInput) (*ListRoomMembershipsOutput, error) {
	req, out := c.ListRoomMembershipsRequest(input)
	return out, req.Send()
}

// ListRoomMembershipsWithContext is the same as ListRoomMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoomMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomMembershipsWithContext(ctx aws.Context, input *ListRoomMembershipsInput, opts ...request.Option) (*ListRoomMembershipsOutput, error) {
	req, out := c.ListRoomMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoomMembershipsPages iterates over the pages of a ListRoomMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoomMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoomMemberships operation.
//    pageNum := 0
//    err := client.ListRoomMembershipsPages(params,
//        func(page *chime.ListRoomMembershipsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListRoomMembershipsPages(input *ListRoomMembershipsInput, fn func(*ListRoomMembershipsOutput, bool) bool) error {
	return c.ListRoomMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoomMembershipsPagesWithContext same as ListRoomMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomMembershipsPagesWithContext(ctx aws.Context, input *ListRoomMembershipsInput, fn func(*ListRoomMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoomMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoomMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoomMembershipsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRooms = "ListRooms"

// ListRoomsRequest generates a "aws/request.Request" representing the
// client's request for the ListRooms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRooms for more information on using the ListRooms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRoomsRequest method.
//    req, resp := client.ListRoomsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms
func (c *Chime) ListRoomsRequest(input *ListRoomsInput) (req *request.Request, output *ListRoomsOutput) {
	op := &request.Operation{
		Name:       opListRooms,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/rooms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoomsInput{}
	}

	output = &ListRoomsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRooms API operation for Amazon Chime.
//
// Lists the room details for the specified Amazon Chime Enterprise account.
// Optionally, filter the results by a member ID (user ID or bot ID) to see
// a list of rooms that the member belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListRooms for usage and error information.
//
// Returned Error Types:
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListRooms
func (c *Chime) ListRooms(input *ListRoomsInput) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	return out, req.Send()
}

// ListRoomsWithContext is the same as ListRooms with the addition of
// the ability to pass a context and additional request options.
//
// See ListRooms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomsWithContext(ctx aws.Context, input *ListRoomsInput, opts ...request.Option) (*ListRoomsOutput, error) {
	req, out := c.ListRoomsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoomsPages iterates over the pages of a ListRooms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRooms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRooms operation.
//    pageNum := 0
//    err := client.ListRoomsPages(params,
//        func(page *chime.ListRoomsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListRoomsPages(input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool) error {
	return c.ListRoomsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoomsPagesWithContext same as ListRoomsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListRoomsPagesWithContext(ctx aws.Context, input *ListRoomsInput, fn func(*ListRoomsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoomsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoomsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoomsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Chime.
//
// Lists the users that belong to the specified Amazon Chime account. You can
// specify an email address to list only the user that the email address belongs
// to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListUsers
func (c *Chime) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *chime.ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVoiceConnectorGroups = "ListVoiceConnectorGroups"

// ListVoiceConnectorGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorGroups for more information on using the ListVoiceConnectorGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVoiceConnectorGroupsRequest method.
//    req, resp := client.ListVoiceConnectorGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups
func (c *Chime) ListVoiceConnectorGroupsRequest(input *ListVoiceConnectorGroupsInput) (req *request.Request, output *ListVoiceConnectorGroupsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectorGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connector-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorGroupsInput{}
	}

	output = &ListVoiceConnectorGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorGroups API operation for Amazon Chime.
//
// Lists the Amazon Chime Voice Connector groups for the administrator's AWS
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectorGroups for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorGroups
func (c *Chime) ListVoiceConnectorGroups(input *ListVoiceConnectorGroupsInput) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorGroupsWithContext is the same as ListVoiceConnectorGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListVoiceConnectorGroupsWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, opts ...request.Option) (*ListVoiceConnectorGroupsOutput, error) {
	req, out := c.ListVoiceConnectorGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorGroupsPages iterates over the pages of a ListVoiceConnectorGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectorGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVoiceConnectorGroups operation.
//    pageNum := 0
//    err := client.ListVoiceConnectorGroupsPages(params,
//        func(page *chime.ListVoiceConnectorGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListVoiceConnectorGroupsPages(input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool) error {
	return c.ListVoiceConnectorGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorGroupsPagesWithContext same as ListVoiceConnectorGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListVoiceConnectorGroupsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorGroupsInput, fn func(*ListVoiceConnectorGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVoiceConnectorTerminationCredentials = "ListVoiceConnectorTerminationCredentials"

// ListVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectorTerminationCredentials for more information on using the ListVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVoiceConnectorTerminationCredentialsRequest method.
//    req, resp := client.ListVoiceConnectorTerminationCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials
func (c *Chime) ListVoiceConnectorTerminationCredentialsRequest(input *ListVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *ListVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectorTerminationCredentials,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials",
	}

	if input == nil {
		input = &ListVoiceConnectorTerminationCredentialsInput{}
	}

	output = &ListVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Lists the SIP credentials for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials
func (c *Chime) ListVoiceConnectorTerminationCredentials(input *ListVoiceConnectorTerminationCredentialsInput) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorTerminationCredentialsWithContext is the same as ListVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *ListVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*ListVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.ListVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListVoiceConnectors = "ListVoiceConnectors"

// ListVoiceConnectorsRequest generates a "aws/request.Request" representing the
// client's request for the ListVoiceConnectors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVoiceConnectors for more information on using the ListVoiceConnectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVoiceConnectorsRequest method.
//    req, resp := client.ListVoiceConnectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors
func (c *Chime) ListVoiceConnectorsRequest(input *ListVoiceConnectorsInput) (req *request.Request, output *ListVoiceConnectorsOutput) {
	op := &request.Operation{
		Name:       opListVoiceConnectors,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVoiceConnectorsInput{}
	}

	output = &ListVoiceConnectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVoiceConnectors API operation for Amazon Chime.
//
// Lists the Amazon Chime Voice Connectors for the administrator's AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ListVoiceConnectors for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectors
func (c *Chime) ListVoiceConnectors(input *ListVoiceConnectorsInput) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	return out, req.Send()
}

// ListVoiceConnectorsWithContext is the same as ListVoiceConnectors with the addition of
// the ability to pass a context and additional request options.
//
// See ListVoiceConnectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListVoiceConnectorsWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, opts ...request.Option) (*ListVoiceConnectorsOutput, error) {
	req, out := c.ListVoiceConnectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVoiceConnectorsPages iterates over the pages of a ListVoiceConnectors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVoiceConnectors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVoiceConnectors operation.
//    pageNum := 0
//    err := client.ListVoiceConnectorsPages(params,
//        func(page *chime.ListVoiceConnectorsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Chime) ListVoiceConnectorsPages(input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool) error {
	return c.ListVoiceConnectorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVoiceConnectorsPagesWithContext same as ListVoiceConnectorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ListVoiceConnectorsPagesWithContext(ctx aws.Context, input *ListVoiceConnectorsInput, fn func(*ListVoiceConnectorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVoiceConnectorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVoiceConnectorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVoiceConnectorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opLogoutUser = "LogoutUser"

// LogoutUserRequest generates a "aws/request.Request" representing the
// client's request for the LogoutUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LogoutUser for more information on using the LogoutUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LogoutUserRequest method.
//    req, resp := client.LogoutUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUserRequest(input *LogoutUserInput) (req *request.Request, output *LogoutUserOutput) {
	op := &request.Operation{
		Name:       opLogoutUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=logout",
	}

	if input == nil {
		input = &LogoutUserInput{}
	}

	output = &LogoutUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// LogoutUser API operation for Amazon Chime.
//
// Logs out the specified user from all of the devices they are currently logged
// into.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation LogoutUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/LogoutUser
func (c *Chime) LogoutUser(input *LogoutUserInput) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	return out, req.Send()
}

// LogoutUserWithContext is the same as LogoutUser with the addition of
// the ability to pass a context and additional request options.
//
// See LogoutUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) LogoutUserWithContext(ctx aws.Context, input *LogoutUserInput, opts ...request.Option) (*LogoutUserOutput, error) {
	req, out := c.LogoutUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutEventsConfiguration = "PutEventsConfiguration"

// PutEventsConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutEventsConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventsConfiguration for more information on using the PutEventsConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventsConfigurationRequest method.
//    req, resp := client.PutEventsConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration
func (c *Chime) PutEventsConfigurationRequest(input *PutEventsConfigurationInput) (req *request.Request, output *PutEventsConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutEventsConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}/events-configuration",
	}

	if input == nil {
		input = &PutEventsConfigurationInput{}
	}

	output = &PutEventsConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventsConfiguration API operation for Amazon Chime.
//
// Creates an events configuration that allows a bot to receive outgoing events
// sent by Amazon Chime. Choose either an HTTPS endpoint or a Lambda function
// ARN. For more information, see Bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutEventsConfiguration for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutEventsConfiguration
func (c *Chime) PutEventsConfiguration(input *PutEventsConfigurationInput) (*PutEventsConfigurationOutput, error) {
	req, out := c.PutEventsConfigurationRequest(input)
	return out, req.Send()
}

// PutEventsConfigurationWithContext is the same as PutEventsConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventsConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutEventsConfigurationWithContext(ctx aws.Context, input *PutEventsConfigurationInput, opts ...request.Option) (*PutEventsConfigurationOutput, error) {
	req, out := c.PutEventsConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorLoggingConfiguration = "PutVoiceConnectorLoggingConfiguration"

// PutVoiceConnectorLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorLoggingConfiguration for more information on using the PutVoiceConnectorLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutVoiceConnectorLoggingConfigurationRequest method.
//    req, resp := client.PutVoiceConnectorLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration
func (c *Chime) PutVoiceConnectorLoggingConfigurationRequest(input *PutVoiceConnectorLoggingConfigurationInput) (req *request.Request, output *PutVoiceConnectorLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorLoggingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/logging-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorLoggingConfigurationInput{}
	}

	output = &PutVoiceConnectorLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorLoggingConfiguration API operation for Amazon Chime.
//
// Adds a logging configuration for the specified Amazon Chime Voice Connector.
// The logging configuration specifies whether SIP message logs are enabled
// for sending to Amazon CloudWatch Logs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorLoggingConfiguration
func (c *Chime) PutVoiceConnectorLoggingConfiguration(input *PutVoiceConnectorLoggingConfigurationInput) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorLoggingConfigurationWithContext is the same as PutVoiceConnectorLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutVoiceConnectorLoggingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorLoggingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorLoggingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorOrigination = "PutVoiceConnectorOrigination"

// PutVoiceConnectorOriginationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorOrigination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorOrigination for more information on using the PutVoiceConnectorOrigination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutVoiceConnectorOriginationRequest method.
//    req, resp := client.PutVoiceConnectorOriginationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination
func (c *Chime) PutVoiceConnectorOriginationRequest(input *PutVoiceConnectorOriginationInput) (req *request.Request, output *PutVoiceConnectorOriginationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorOrigination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/origination",
	}

	if input == nil {
		input = &PutVoiceConnectorOriginationInput{}
	}

	output = &PutVoiceConnectorOriginationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorOrigination API operation for Amazon Chime.
//
// Adds origination settings for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorOrigination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorOrigination
func (c *Chime) PutVoiceConnectorOrigination(input *PutVoiceConnectorOriginationInput) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorOriginationWithContext is the same as PutVoiceConnectorOrigination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorOrigination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutVoiceConnectorOriginationWithContext(ctx aws.Context, input *PutVoiceConnectorOriginationInput, opts ...request.Option) (*PutVoiceConnectorOriginationOutput, error) {
	req, out := c.PutVoiceConnectorOriginationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorStreamingConfiguration = "PutVoiceConnectorStreamingConfiguration"

// PutVoiceConnectorStreamingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorStreamingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorStreamingConfiguration for more information on using the PutVoiceConnectorStreamingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutVoiceConnectorStreamingConfigurationRequest method.
//    req, resp := client.PutVoiceConnectorStreamingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration
func (c *Chime) PutVoiceConnectorStreamingConfigurationRequest(input *PutVoiceConnectorStreamingConfigurationInput) (req *request.Request, output *PutVoiceConnectorStreamingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorStreamingConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/streaming-configuration",
	}

	if input == nil {
		input = &PutVoiceConnectorStreamingConfigurationInput{}
	}

	output = &PutVoiceConnectorStreamingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorStreamingConfiguration API operation for Amazon Chime.
//
// Adds a streaming configuration for the specified Amazon Chime Voice Connector.
// The streaming configuration specifies whether media streaming is enabled
// for sending to Amazon Kinesis. It also sets the retention period, in hours,
// for the Amazon Kinesis data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorStreamingConfiguration for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorStreamingConfiguration
func (c *Chime) PutVoiceConnectorStreamingConfiguration(input *PutVoiceConnectorStreamingConfigurationInput) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorStreamingConfigurationWithContext is the same as PutVoiceConnectorStreamingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorStreamingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutVoiceConnectorStreamingConfigurationWithContext(ctx aws.Context, input *PutVoiceConnectorStreamingConfigurationInput, opts ...request.Option) (*PutVoiceConnectorStreamingConfigurationOutput, error) {
	req, out := c.PutVoiceConnectorStreamingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTermination = "PutVoiceConnectorTermination"

// PutVoiceConnectorTerminationRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTermination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTermination for more information on using the PutVoiceConnectorTermination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutVoiceConnectorTerminationRequest method.
//    req, resp := client.PutVoiceConnectorTerminationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination
func (c *Chime) PutVoiceConnectorTerminationRequest(input *PutVoiceConnectorTerminationInput) (req *request.Request, output *PutVoiceConnectorTerminationOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorTermination,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationInput{}
	}

	output = &PutVoiceConnectorTerminationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutVoiceConnectorTermination API operation for Amazon Chime.
//
// Adds termination settings for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorTermination for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTermination
func (c *Chime) PutVoiceConnectorTermination(input *PutVoiceConnectorTerminationInput) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationWithContext is the same as PutVoiceConnectorTermination with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTermination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutVoiceConnectorTerminationWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationInput, opts ...request.Option) (*PutVoiceConnectorTerminationOutput, error) {
	req, out := c.PutVoiceConnectorTerminationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutVoiceConnectorTerminationCredentials = "PutVoiceConnectorTerminationCredentials"

// PutVoiceConnectorTerminationCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the PutVoiceConnectorTerminationCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutVoiceConnectorTerminationCredentials for more information on using the PutVoiceConnectorTerminationCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutVoiceConnectorTerminationCredentialsRequest method.
//    req, resp := client.PutVoiceConnectorTerminationCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials
func (c *Chime) PutVoiceConnectorTerminationCredentialsRequest(input *PutVoiceConnectorTerminationCredentialsInput) (req *request.Request, output *PutVoiceConnectorTerminationCredentialsOutput) {
	op := &request.Operation{
		Name:       opPutVoiceConnectorTerminationCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials?operation=put",
	}

	if input == nil {
		input = &PutVoiceConnectorTerminationCredentialsInput{}
	}

	output = &PutVoiceConnectorTerminationCredentialsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutVoiceConnectorTerminationCredentials API operation for Amazon Chime.
//
// Adds termination SIP credentials for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation PutVoiceConnectorTerminationCredentials for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/PutVoiceConnectorTerminationCredentials
func (c *Chime) PutVoiceConnectorTerminationCredentials(input *PutVoiceConnectorTerminationCredentialsInput) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	return out, req.Send()
}

// PutVoiceConnectorTerminationCredentialsWithContext is the same as PutVoiceConnectorTerminationCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See PutVoiceConnectorTerminationCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) PutVoiceConnectorTerminationCredentialsWithContext(ctx aws.Context, input *PutVoiceConnectorTerminationCredentialsInput, opts ...request.Option) (*PutVoiceConnectorTerminationCredentialsOutput, error) {
	req, out := c.PutVoiceConnectorTerminationCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegenerateSecurityToken = "RegenerateSecurityToken"

// RegenerateSecurityTokenRequest generates a "aws/request.Request" representing the
// client's request for the RegenerateSecurityToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegenerateSecurityToken for more information on using the RegenerateSecurityToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegenerateSecurityTokenRequest method.
//    req, resp := client.RegenerateSecurityTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken
func (c *Chime) RegenerateSecurityTokenRequest(input *RegenerateSecurityTokenInput) (req *request.Request, output *RegenerateSecurityTokenOutput) {
	op := &request.Operation{
		Name:       opRegenerateSecurityToken,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}?operation=regenerate-security-token",
	}

	if input == nil {
		input = &RegenerateSecurityTokenInput{}
	}

	output = &RegenerateSecurityTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegenerateSecurityToken API operation for Amazon Chime.
//
// Regenerates the security token for a bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RegenerateSecurityToken for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RegenerateSecurityToken
func (c *Chime) RegenerateSecurityToken(input *RegenerateSecurityTokenInput) (*RegenerateSecurityTokenOutput, error) {
	req, out := c.RegenerateSecurityTokenRequest(input)
	return out, req.Send()
}

// RegenerateSecurityTokenWithContext is the same as RegenerateSecurityToken with the addition of
// the ability to pass a context and additional request options.
//
// See RegenerateSecurityToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RegenerateSecurityTokenWithContext(ctx aws.Context, input *RegenerateSecurityTokenInput, opts ...request.Option) (*RegenerateSecurityTokenOutput, error) {
	req, out := c.RegenerateSecurityTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResetPersonalPIN = "ResetPersonalPIN"

// ResetPersonalPINRequest generates a "aws/request.Request" representing the
// client's request for the ResetPersonalPIN operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResetPersonalPIN for more information on using the ResetPersonalPIN
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ResetPersonalPINRequest method.
//    req, resp := client.ResetPersonalPINRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPINRequest(input *ResetPersonalPINInput) (req *request.Request, output *ResetPersonalPINOutput) {
	op := &request.Operation{
		Name:       opResetPersonalPIN,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}?operation=reset-personal-pin",
	}

	if input == nil {
		input = &ResetPersonalPINInput{}
	}

	output = &ResetPersonalPINOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetPersonalPIN API operation for Amazon Chime.
//
// Resets the personal meeting PIN for the specified user on an Amazon Chime
// account. Returns the User object with the updated personal meeting PIN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation ResetPersonalPIN for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ResetPersonalPIN
func (c *Chime) ResetPersonalPIN(input *ResetPersonalPINInput) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	return out, req.Send()
}

// ResetPersonalPINWithContext is the same as ResetPersonalPIN with the addition of
// the ability to pass a context and additional request options.
//
// See ResetPersonalPIN for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) ResetPersonalPINWithContext(ctx aws.Context, input *ResetPersonalPINInput, opts ...request.Option) (*ResetPersonalPINOutput, error) {
	req, out := c.ResetPersonalPINRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestorePhoneNumber = "RestorePhoneNumber"

// RestorePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the RestorePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestorePhoneNumber for more information on using the RestorePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestorePhoneNumberRequest method.
//    req, resp := client.RestorePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber
func (c *Chime) RestorePhoneNumberRequest(input *RestorePhoneNumberInput) (req *request.Request, output *RestorePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opRestorePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}?operation=restore",
	}

	if input == nil {
		input = &RestorePhoneNumberInput{}
	}

	output = &RestorePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestorePhoneNumber API operation for Amazon Chime.
//
// Moves a phone number from the Deletion queue back into the phone number Inventory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation RestorePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ResourceLimitExceededException
//   The request exceeds the resource limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/RestorePhoneNumber
func (c *Chime) RestorePhoneNumber(input *RestorePhoneNumberInput) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	return out, req.Send()
}

// RestorePhoneNumberWithContext is the same as RestorePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See RestorePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) RestorePhoneNumberWithContext(ctx aws.Context, input *RestorePhoneNumberInput, opts ...request.Option) (*RestorePhoneNumberOutput, error) {
	req, out := c.RestorePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAvailablePhoneNumbers = "SearchAvailablePhoneNumbers"

// SearchAvailablePhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the SearchAvailablePhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAvailablePhoneNumbers for more information on using the SearchAvailablePhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchAvailablePhoneNumbersRequest method.
//    req, resp := client.SearchAvailablePhoneNumbersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers
func (c *Chime) SearchAvailablePhoneNumbersRequest(input *SearchAvailablePhoneNumbersInput) (req *request.Request, output *SearchAvailablePhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opSearchAvailablePhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/search?type=phone-numbers",
	}

	if input == nil {
		input = &SearchAvailablePhoneNumbersInput{}
	}

	output = &SearchAvailablePhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAvailablePhoneNumbers API operation for Amazon Chime.
//
// Searches phone numbers that can be ordered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation SearchAvailablePhoneNumbers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * AccessDeniedException
//   You don't have permissions to perform the requested operation.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/SearchAvailablePhoneNumbers
func (c *Chime) SearchAvailablePhoneNumbers(input *SearchAvailablePhoneNumbersInput) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersWithContext is the same as SearchAvailablePhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAvailablePhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) SearchAvailablePhoneNumbersWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, opts ...request.Option) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccount = "UpdateAccount"

// UpdateAccountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccount for more information on using the UpdateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountRequest method.
//    req, resp := client.UpdateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccountRequest(input *UpdateAccountInput) (req *request.Request, output *UpdateAccountOutput) {
	op := &request.Operation{
		Name:       opUpdateAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}",
	}

	if input == nil {
		input = &UpdateAccountInput{}
	}

	output = &UpdateAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccount API operation for Amazon Chime.
//
// Updates account details for the specified Amazon Chime account. Currently,
// only account name updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccount for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccount
func (c *Chime) UpdateAccount(input *UpdateAccountInput) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	return out, req.Send()
}

// UpdateAccountWithContext is the same as UpdateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountWithContext(ctx aws.Context, input *UpdateAccountInput, opts ...request.Option) (*UpdateAccountOutput, error) {
	req, out := c.UpdateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountSettingsRequest method.
//    req, resp := client.UpdateAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/settings",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountSettings API operation for Amazon Chime.
//
// Updates the settings for the specified Amazon Chime account. You can update
// settings for remote control of shared screens, or for the dial-out option.
// For more information about these settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateAccountSettings
func (c *Chime) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBot = "UpdateBot"

// UpdateBotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBot for more information on using the UpdateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBotRequest method.
//    req, resp := client.UpdateBotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot
func (c *Chime) UpdateBotRequest(input *UpdateBotInput) (req *request.Request, output *UpdateBotOutput) {
	op := &request.Operation{
		Name:       opUpdateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/bots/{botId}",
	}

	if input == nil {
		input = &UpdateBotInput{}
	}

	output = &UpdateBotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBot API operation for Amazon Chime.
//
// Updates the status of the specified bot, such as starting or stopping the
// bot from running in your Amazon Chime Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateBot for usage and error information.
//
// Returned Error Types:
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateBot
func (c *Chime) UpdateBot(input *UpdateBotInput) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	return out, req.Send()
}

// UpdateBotWithContext is the same as UpdateBot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateBotWithContext(ctx aws.Context, input *UpdateBotInput, opts ...request.Option) (*UpdateBotOutput, error) {
	req, out := c.UpdateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalSettings for more information on using the UpdateGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGlobalSettingsRequest method.
//    req, resp := client.UpdateGlobalSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings
func (c *Chime) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) (req *request.Request, output *UpdateGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	output = &UpdateGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGlobalSettings API operation for Amazon Chime.
//
// Updates global settings for the administrator's AWS account, such as Amazon
// Chime Business Calling and Amazon Chime Voice Connector settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateGlobalSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateGlobalSettings
func (c *Chime) UpdateGlobalSettings(input *UpdateGlobalSettingsInput) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalSettingsWithContext is the same as UpdateGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateGlobalSettingsWithContext(ctx aws.Context, input *UpdateGlobalSettingsInput, opts ...request.Option) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumber = "UpdatePhoneNumber"

// UpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumber for more information on using the UpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePhoneNumberRequest method.
//    req, resp := client.UpdatePhoneNumberRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber
func (c *Chime) UpdatePhoneNumberRequest(input *UpdatePhoneNumberInput) (req *request.Request, output *UpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-numbers/{phoneNumberId}",
	}

	if input == nil {
		input = &UpdatePhoneNumberInput{}
	}

	output = &UpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePhoneNumber API operation for Amazon Chime.
//
// Updates phone number details, such as product type or calling name, for the
// specified phone number ID. You can update one phone number detail at a time.
// For example, you can update either the product type or the calling name in
// one action.
//
// For toll-free numbers, you must use the Amazon Chime Voice Connector product
// type.
//
// Updates to outbound calling names can take up to 72 hours to complete. Pending
// updates to outbound calling names must be complete before you can request
// another update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumber
func (c *Chime) UpdatePhoneNumber(input *UpdatePhoneNumberInput) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberWithContext is the same as UpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdatePhoneNumberWithContext(ctx aws.Context, input *UpdatePhoneNumberInput, opts ...request.Option) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumberSettings = "UpdatePhoneNumberSettings"

// UpdatePhoneNumberSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumberSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumberSettings for more information on using the UpdatePhoneNumberSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePhoneNumberSettingsRequest method.
//    req, resp := client.UpdatePhoneNumberSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings
func (c *Chime) UpdatePhoneNumberSettingsRequest(input *UpdatePhoneNumberSettingsInput) (req *request.Request, output *UpdatePhoneNumberSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumberSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/settings/phone-number",
	}

	if input == nil {
		input = &UpdatePhoneNumberSettingsInput{}
	}

	output = &UpdatePhoneNumberSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePhoneNumberSettings API operation for Amazon Chime.
//
// Updates the phone number settings for the administrator's AWS account, such
// as the default outbound calling name. You can update the default outbound
// calling name once every seven days. Outbound calling names can take up to
// 72 hours to update.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdatePhoneNumberSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdatePhoneNumberSettings
func (c *Chime) UpdatePhoneNumberSettings(input *UpdatePhoneNumberSettingsInput) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberSettingsWithContext is the same as UpdatePhoneNumberSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumberSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdatePhoneNumberSettingsWithContext(ctx aws.Context, input *UpdatePhoneNumberSettingsInput, opts ...request.Option) (*UpdatePhoneNumberSettingsOutput, error) {
	req, out := c.UpdatePhoneNumberSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoom = "UpdateRoom"

// UpdateRoomRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoom operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoom for more information on using the UpdateRoom
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoomRequest method.
//    req, resp := client.UpdateRoomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom
func (c *Chime) UpdateRoomRequest(input *UpdateRoomInput) (req *request.Request, output *UpdateRoomOutput) {
	op := &request.Operation{
		Name:       opUpdateRoom,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}",
	}

	if input == nil {
		input = &UpdateRoomInput{}
	}

	output = &UpdateRoomOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoom API operation for Amazon Chime.
//
// Updates room details, such as the room name, for a room in an Amazon Chime
// Enterprise account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateRoom for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoom
func (c *Chime) UpdateRoom(input *UpdateRoomInput) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	return out, req.Send()
}

// UpdateRoomWithContext is the same as UpdateRoom with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoom for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateRoomWithContext(ctx aws.Context, input *UpdateRoomInput, opts ...request.Option) (*UpdateRoomOutput, error) {
	req, out := c.UpdateRoomRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoomMembership = "UpdateRoomMembership"

// UpdateRoomMembershipRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoomMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoomMembership for more information on using the UpdateRoomMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRoomMembershipRequest method.
//    req, resp := client.UpdateRoomMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership
func (c *Chime) UpdateRoomMembershipRequest(input *UpdateRoomMembershipInput) (req *request.Request, output *UpdateRoomMembershipOutput) {
	op := &request.Operation{
		Name:       opUpdateRoomMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/rooms/{roomId}/memberships/{memberId}",
	}

	if input == nil {
		input = &UpdateRoomMembershipInput{}
	}

	output = &UpdateRoomMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRoomMembership API operation for Amazon Chime.
//
// Updates room membership details, such as the member role, for a room in an
// Amazon Chime Enterprise account. The member role designates whether the member
// is a chat room administrator or a general chat room member. The member role
// can be updated only for user IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateRoomMembership for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateRoomMembership
func (c *Chime) UpdateRoomMembership(input *UpdateRoomMembershipInput) (*UpdateRoomMembershipOutput, error) {
	req, out := c.UpdateRoomMembershipRequest(input)
	return out, req.Send()
}

// UpdateRoomMembershipWithContext is the same as UpdateRoomMembership with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoomMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateRoomMembershipWithContext(ctx aws.Context, input *UpdateRoomMembershipInput, opts ...request.Option) (*UpdateRoomMembershipOutput, error) {
	req, out := c.UpdateRoomMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUser for more information on using the UpdateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/accounts/{accountId}/users/{userId}",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUser API operation for Amazon Chime.
//
// Updates user details for a specified user ID. Currently, only LicenseType
// updates are supported for this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateUser for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUser
func (c *Chime) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	return out, req.Send()
}

// UpdateUserWithContext is the same as UpdateUser with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateUserWithContext(ctx aws.Context, input *UpdateUserInput, opts ...request.Option) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSettings = "UpdateUserSettings"

// UpdateUserSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSettings for more information on using the UpdateUserSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserSettingsRequest method.
//    req, resp := client.UpdateUserSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings
func (c *Chime) UpdateUserSettingsRequest(input *UpdateUserSettingsInput) (req *request.Request, output *UpdateUserSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{accountId}/users/{userId}/settings",
	}

	if input == nil {
		input = &UpdateUserSettingsInput{}
	}

	output = &UpdateUserSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserSettings API operation for Amazon Chime.
//
// Updates the settings for the specified user, such as phone number settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateUserSettings for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateUserSettings
func (c *Chime) UpdateUserSettings(input *UpdateUserSettingsInput) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	return out, req.Send()
}

// UpdateUserSettingsWithContext is the same as UpdateUserSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateUserSettingsWithContext(ctx aws.Context, input *UpdateUserSettingsInput, opts ...request.Option) (*UpdateUserSettingsOutput, error) {
	req, out := c.UpdateUserSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnector = "UpdateVoiceConnector"

// UpdateVoiceConnectorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnector operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnector for more information on using the UpdateVoiceConnector
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVoiceConnectorRequest method.
//    req, resp := client.UpdateVoiceConnectorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector
func (c *Chime) UpdateVoiceConnectorRequest(input *UpdateVoiceConnectorInput) (req *request.Request, output *UpdateVoiceConnectorOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceConnector,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorInput{}
	}

	output = &UpdateVoiceConnectorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnector API operation for Amazon Chime.
//
// Updates details for the specified Amazon Chime Voice Connector.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateVoiceConnector for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnector
func (c *Chime) UpdateVoiceConnector(input *UpdateVoiceConnectorInput) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorWithContext is the same as UpdateVoiceConnector with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnector for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateVoiceConnectorWithContext(ctx aws.Context, input *UpdateVoiceConnectorInput, opts ...request.Option) (*UpdateVoiceConnectorOutput, error) {
	req, out := c.UpdateVoiceConnectorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVoiceConnectorGroup = "UpdateVoiceConnectorGroup"

// UpdateVoiceConnectorGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVoiceConnectorGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVoiceConnectorGroup for more information on using the UpdateVoiceConnectorGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVoiceConnectorGroupRequest method.
//    req, resp := client.UpdateVoiceConnectorGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup
func (c *Chime) UpdateVoiceConnectorGroupRequest(input *UpdateVoiceConnectorGroupInput) (req *request.Request, output *UpdateVoiceConnectorGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateVoiceConnectorGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/voice-connector-groups/{voiceConnectorGroupId}",
	}

	if input == nil {
		input = &UpdateVoiceConnectorGroupInput{}
	}

	output = &UpdateVoiceConnectorGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVoiceConnectorGroup API operation for Amazon Chime.
//
// Updates details for the specified Amazon Chime Voice Connector group, such
// as the name and Amazon Chime Voice Connector priority ranking.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Chime's
// API operation UpdateVoiceConnectorGroup for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedClientException
//   The client is not currently authorized to make the request.
//
//   * NotFoundException
//   One or more of the resources in the request does not exist in the system.
//
//   * ForbiddenException
//   The client is permanently forbidden from making the request. For example,
//   when a user tries to create an account from an unsupported Region.
//
//   * BadRequestException
//   The input parameters don't match the service's restrictions.
//
//   * ConflictException
//   The request could not be processed because of conflict in the current state
//   of the resource.
//
//   * ThrottledClientException
//   The client exceeded its request rate limit.
//
//   * ServiceUnavailableException
//   The service is currently unavailable.
//
//   * ServiceFailureException
//   The service encountered an unexpected error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/UpdateVoiceConnectorGroup
func (c *Chime) UpdateVoiceConnectorGroup(input *UpdateVoiceConnectorGroupInput) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	return out, req.Send()
}

// UpdateVoiceConnectorGroupWithContext is the same as UpdateVoiceConnectorGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVoiceConnectorGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Chime) UpdateVoiceConnectorGroupWithContext(ctx aws.Context, input *UpdateVoiceConnectorGroupInput, opts ...request.Option) (*UpdateVoiceConnectorGroupOutput, error) {
	req, out := c.UpdateVoiceConnectorGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don't have permissions to perform the requested operation.
type AccessDeniedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AccessDeniedException) OrigErr() error {
	return nil
}

func (s AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s AccessDeniedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AccessDeniedException) RequestID() string {
	return s.respMetadata.RequestID
}

// The Amazon Chime account details. An AWS account can have multiple Amazon
// Chime accounts.
type Account struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `type:"string" required:"true"`

	// The Amazon Chime account type. For more information about different account
	// types, see Managing Your Amazon Chime Accounts (https://docs.aws.amazon.com/chime/latest/ag/manage-chime-account.html)
	// in the Amazon Chime Administration Guide.
	AccountType *string `type:"string" enum:"AccountType"`

	// The AWS account ID.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// The Amazon Chime account creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The default license for the Amazon Chime account.
	DefaultLicense *string `type:"string" enum:"License"`

	// The Amazon Chime account name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The sign-in delegate groups associated with the account.
	SigninDelegateGroups []*SigninDelegateGroup `type:"list"`

	// Supported licenses for the Amazon Chime account.
	SupportedLicenses []*string `type:"list"`
}

// String returns the string representation
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Account) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Account) SetAccountId(v string) *Account {
	s.AccountId = &v
	return s
}

// SetAccountType sets the AccountType field's value.
func (s *Account) SetAccountType(v string) *Account {
	s.AccountType = &v
	return s
}

// SetAwsAccountId sets the AwsAccountId field's value.
func (s *Account) SetAwsAccountId(v string) *Account {
	s.AwsAccountId = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Account) SetCreatedTimestamp(v time.Time) *Account {
	s.CreatedTimestamp = &v
	return s
}

// SetDefaultLicense sets the DefaultLicense field's value.
func (s *Account) SetDefaultLicense(v string) *Account {
	s.DefaultLicense = &v
	return s
}

// SetName sets the Name field's value.
func (s *Account) SetName(v string) *Account {
	s.Name = &v
	return s
}

// SetSigninDelegateGroups sets the SigninDelegateGroups field's value.
func (s *Account) SetSigninDelegateGroups(v []*SigninDelegateGroup) *Account {
	s.SigninDelegateGroups = v
	return s
}

// SetSupportedLicenses sets the SupportedLicenses field's value.
func (s *Account) SetSupportedLicenses(v []*string) *Account {
	s.SupportedLicenses = v
	return s
}

// Settings related to the Amazon Chime account. This includes settings that
// start or stop remote control of shared screens, or start or stop the dial-out
// option in the Amazon Chime web application. For more information about these
// settings, see Use the Policies Page (https://docs.aws.amazon.com/chime/latest/ag/policies.html)
// in the Amazon Chime Administration Guide.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// Setting that stops or starts remote control of shared screens during meetings.
	DisableRemoteControl *bool `type:"boolean"`

	// Setting that allows meeting participants to choose the Call me at a phone
	// number option. For more information, see Join a Meeting without the Amazon
	// Chime App (https://docs.aws.amazon.com/chime/latest/ug/chime-join-meeting.html).
	EnableDialOut *bool `type:"boolean"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetDisableRemoteControl sets the DisableRemoteControl field's value.
func (s *AccountSettings) SetDisableRemoteControl(v bool) *AccountSettings {
	s.DisableRemoteControl = &v
	return s
}

// SetEnableDialOut sets the EnableDialOut field's value.
func (s *AccountSettings) SetEnableDialOut(v bool) *AccountSettings {
	s.EnableDialOut = &v
	return s
}

// The Alexa for Business metadata associated with an Amazon Chime user, used
// to integrate Alexa for Business with a device.
type AlexaForBusinessMetadata struct {
	_ struct{} `type:"structure"`

	// The ARN of the room resource.
	AlexaForBusinessRoomArn *string `type:"string" sensitive:"true"`

	// Starts or stops Alexa for Business.
	IsAlexaForBusinessEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s AlexaForBusinessMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AlexaForBusinessMetadata) GoString() string {
	return s.String()
}

// SetAlexaForBusinessRoomArn sets the AlexaForBusinessRoomArn field's value.
func (s *AlexaForBusinessMetadata) SetAlexaForBusinessRoomArn(v string) *AlexaForBusinessMetadata {
	s.AlexaForBusinessRoomArn = &v
	return s
}

// SetIsAlexaForBusinessEnabled sets the IsAlexaForBusinessEnabled field's value.
func (s *AlexaForBusinessMetadata) SetIsAlexaForBusinessEnabled(v bool) *AlexaForBusinessMetadata {
	s.IsAlexaForBusinessEnabled = &v
	return s
}

type AssociatePhoneNumberWithUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The phone number, in E.164 format.
	//
	// E164PhoneNumber is a required field
	E164PhoneNumber *string `type:"string" required:"true" sensitive:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociatePhoneNumberWithUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumberWithUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumberWithUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumberWithUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.E164PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumber"))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociatePhoneNumberWithUserInput) SetAccountId(v string) *AssociatePhoneNumberWithUserInput {
	s.AccountId = &v
	return s
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *AssociatePhoneNumberWithUserInput) SetE164PhoneNumber(v string) *AssociatePhoneNumberWithUserInput {
	s.E164PhoneNumber = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *AssociatePhoneNumberWithUserInput) SetUserId(v string) *AssociatePhoneNumberWithUserInput {
	s.UserId = &v
	return s
}

type AssociatePhoneNumberWithUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociatePhoneNumberWithUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumberWithUserOutput) GoString() string {
	return s.String()
}

type AssociatePhoneNumbersWithVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []*string `type:"list"`

	// If true, associates the provided phone numbers with the provided Amazon Chime
	// Voice Connector Group and removes any previously existing associations. If
	// false, does not associate any phone numbers that have previously existing
	// associations.
	ForceAssociate *bool `type:"boolean"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *AssociatePhoneNumbersWithVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorGroupOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorGroupOutput {
	s.PhoneNumberErrors = v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []*string `type:"list"`

	// If true, associates the provided phone numbers with the provided Amazon Chime
	// Voice Connector and removes any previously existing associations. If false,
	// does not associate any phone numbers that have previously existing associations.
	ForceAssociate *bool `type:"boolean"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumbersWithVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetE164PhoneNumbers(v []*string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.E164PhoneNumbers = v
	return s
}

// SetForceAssociate sets the ForceAssociate field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetForceAssociate(v bool) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.ForceAssociate = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorInput) SetVoiceConnectorId(v string) *AssociatePhoneNumbersWithVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type AssociatePhoneNumbersWithVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociatePhoneNumbersWithVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *AssociatePhoneNumbersWithVoiceConnectorOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *AssociatePhoneNumbersWithVoiceConnectorOutput {
	s.PhoneNumberErrors = v
	return s
}

type AssociateSigninDelegateGroupsWithAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The sign-in delegate groups.
	//
	// SigninDelegateGroups is a required field
	SigninDelegateGroups []*SigninDelegateGroup `type:"list" required:"true"`
}

// String returns the string representation
func (s AssociateSigninDelegateGroupsWithAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSigninDelegateGroupsWithAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSigninDelegateGroupsWithAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSigninDelegateGroupsWithAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.SigninDelegateGroups == nil {
		invalidParams.Add(request.NewErrParamRequired("SigninDelegateGroups"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *AssociateSigninDelegateGroupsWithAccountInput) SetAccountId(v string) *AssociateSigninDelegateGroupsWithAccountInput {
	s.AccountId = &v
	return s
}

// SetSigninDelegateGroups sets the SigninDelegateGroups field's value.
func (s *AssociateSigninDelegateGroupsWithAccountInput) SetSigninDelegateGroups(v []*SigninDelegateGroup) *AssociateSigninDelegateGroupsWithAccountInput {
	s.SigninDelegateGroups = v
	return s
}

type AssociateSigninDelegateGroupsWithAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateSigninDelegateGroupsWithAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateSigninDelegateGroupsWithAccountOutput) GoString() string {
	return s.String()
}

// An Amazon Chime SDK meeting attendee. Includes a unique AttendeeId and JoinToken.
// The JoinToken allows a client to authenticate and join as the specified attendee.
// The JoinToken expires when the meeting ends or when DeleteAttendee is called.
// After that, the attendee is unable to join the meeting.
//
// We recommend securely transferring each JoinToken from your server application
// to the client so that no other client has access to the token except for
// the one authorized to represent the attendee.
type Attendee struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	AttendeeId *string `type:"string"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`

	// The join token used by the Amazon Chime SDK attendee.
	JoinToken *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Attendee) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attendee) GoString() string {
	return s.String()
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *Attendee) SetAttendeeId(v string) *Attendee {
	s.AttendeeId = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *Attendee) SetExternalUserId(v string) *Attendee {
	s.ExternalUserId = &v
	return s
}

// SetJoinToken sets the JoinToken field's value.
func (s *Attendee) SetJoinToken(v string) *Attendee {
	s.JoinToken = &v
	return s
}

// The input parameters don't match the service's restrictions.
type BadRequestException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s BadRequestException) OrigErr() error {
	return nil
}

func (s BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s BadRequestException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s BadRequestException) RequestID() string {
	return s.respMetadata.RequestID
}

type BatchCreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The request containing the attendees to create.
	//
	// Attendees is a required field
	Attendees []*CreateAttendeeRequestItem `type:"list" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateAttendeeInput"}
	if s.Attendees == nil {
		invalidParams.Add(request.NewErrParamRequired("Attendees"))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}
	if s.Attendees != nil {
		for i, v := range s.Attendees {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attendees", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeInput) SetAttendees(v []*CreateAttendeeRequestItem) *BatchCreateAttendeeInput {
	s.Attendees = v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *BatchCreateAttendeeInput) SetMeetingId(v string) *BatchCreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type BatchCreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendees IDs and join tokens.
	Attendees []*Attendee `type:"list"`

	// If the action fails for one or more of the attendees in the request, a list
	// of the attendees is returned, along with error codes and error messages.
	Errors []*CreateAttendeeError `type:"list"`
}

// String returns the string representation
func (s BatchCreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *BatchCreateAttendeeOutput) SetAttendees(v []*Attendee) *BatchCreateAttendeeOutput {
	s.Attendees = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateAttendeeOutput) SetErrors(v []*CreateAttendeeError) *BatchCreateAttendeeOutput {
	s.Errors = v
	return s
}

type BatchCreateRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The list of membership items.
	//
	// MembershipItemList is a required field
	MembershipItemList []*MembershipItem `type:"list" required:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s BatchCreateRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateRoomMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchCreateRoomMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchCreateRoomMembershipInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MembershipItemList == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipItemList"))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchCreateRoomMembershipInput) SetAccountId(v string) *BatchCreateRoomMembershipInput {
	s.AccountId = &v
	return s
}

// SetMembershipItemList sets the MembershipItemList field's value.
func (s *BatchCreateRoomMembershipInput) SetMembershipItemList(v []*MembershipItem) *BatchCreateRoomMembershipInput {
	s.MembershipItemList = v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *BatchCreateRoomMembershipInput) SetRoomId(v string) *BatchCreateRoomMembershipInput {
	s.RoomId = &v
	return s
}

type BatchCreateRoomMembershipOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the member IDs in the request, a list
	// of the member IDs is returned, along with error codes and error messages.
	Errors []*MemberError `type:"list"`
}

// String returns the string representation
func (s BatchCreateRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchCreateRoomMembershipOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchCreateRoomMembershipOutput) SetErrors(v []*MemberError) *BatchCreateRoomMembershipOutput {
	s.Errors = v
	return s
}

type BatchDeletePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// List of phone number IDs.
	//
	// PhoneNumberIds is a required field
	PhoneNumberIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeletePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeletePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeletePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeletePhoneNumberInput"}
	if s.PhoneNumberIds == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberIds"))
	}
	if s.PhoneNumberIds != nil && len(s.PhoneNumberIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberIds sets the PhoneNumberIds field's value.
func (s *BatchDeletePhoneNumberInput) SetPhoneNumberIds(v []*string) *BatchDeletePhoneNumberInput {
	s.PhoneNumberIds = v
	return s
}

type BatchDeletePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s BatchDeletePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeletePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *BatchDeletePhoneNumberOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *BatchDeletePhoneNumberOutput {
	s.PhoneNumberErrors = v
	return s
}

type BatchSuspendUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs to suspend.
	//
	// UserIdList is a required field
	UserIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchSuspendUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSuspendUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchSuspendUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchSuspendUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchSuspendUserInput) SetAccountId(v string) *BatchSuspendUserInput {
	s.AccountId = &v
	return s
}

// SetUserIdList sets the UserIdList field's value.
func (s *BatchSuspendUserInput) SetUserIdList(v []*string) *BatchSuspendUserInput {
	s.UserIdList = v
	return s
}

type BatchSuspendUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchSuspendUser action fails for one or more of the user IDs in the
	// request, a list of the user IDs is returned, along with error codes and error
	// messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchSuspendUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSuspendUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchSuspendUserOutput) SetUserErrors(v []*UserError) *BatchSuspendUserOutput {
	s.UserErrors = v
	return s
}

type BatchUnsuspendUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs to unsuspend.
	//
	// UserIdList is a required field
	UserIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUnsuspendUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUnsuspendUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUnsuspendUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUnsuspendUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchUnsuspendUserInput) SetAccountId(v string) *BatchUnsuspendUserInput {
	s.AccountId = &v
	return s
}

// SetUserIdList sets the UserIdList field's value.
func (s *BatchUnsuspendUserInput) SetUserIdList(v []*string) *BatchUnsuspendUserInput {
	s.UserIdList = v
	return s
}

type BatchUnsuspendUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchUnsuspendUser action fails for one or more of the user IDs in
	// the request, a list of the user IDs is returned, along with error codes and
	// error messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchUnsuspendUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUnsuspendUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchUnsuspendUserOutput) SetUserErrors(v []*UserError) *BatchUnsuspendUserOutput {
	s.UserErrors = v
	return s
}

type BatchUpdatePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The request containing the phone number IDs and product types or calling
	// names to update.
	//
	// UpdatePhoneNumberRequestItems is a required field
	UpdatePhoneNumberRequestItems []*UpdatePhoneNumberRequestItem `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdatePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdatePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdatePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdatePhoneNumberInput"}
	if s.UpdatePhoneNumberRequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdatePhoneNumberRequestItems"))
	}
	if s.UpdatePhoneNumberRequestItems != nil {
		for i, v := range s.UpdatePhoneNumberRequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdatePhoneNumberRequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUpdatePhoneNumberRequestItems sets the UpdatePhoneNumberRequestItems field's value.
func (s *BatchUpdatePhoneNumberInput) SetUpdatePhoneNumberRequestItems(v []*UpdatePhoneNumberRequestItem) *BatchUpdatePhoneNumberInput {
	s.UpdatePhoneNumberRequestItems = v
	return s
}

type BatchUpdatePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s BatchUpdatePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdatePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *BatchUpdatePhoneNumberOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *BatchUpdatePhoneNumberOutput {
	s.PhoneNumberErrors = v
	return s
}

type BatchUpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The request containing the user IDs and details to update.
	//
	// UpdateUserRequestItems is a required field
	UpdateUserRequestItems []*UpdateUserRequestItem `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchUpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchUpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchUpdateUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UpdateUserRequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateUserRequestItems"))
	}
	if s.UpdateUserRequestItems != nil {
		for i, v := range s.UpdateUserRequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UpdateUserRequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *BatchUpdateUserInput) SetAccountId(v string) *BatchUpdateUserInput {
	s.AccountId = &v
	return s
}

// SetUpdateUserRequestItems sets the UpdateUserRequestItems field's value.
func (s *BatchUpdateUserInput) SetUpdateUserRequestItems(v []*UpdateUserRequestItem) *BatchUpdateUserInput {
	s.UpdateUserRequestItems = v
	return s
}

type BatchUpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// If the BatchUpdateUser action fails for one or more of the user IDs in the
	// request, a list of the user IDs is returned, along with error codes and error
	// messages.
	UserErrors []*UserError `type:"list"`
}

// String returns the string representation
func (s BatchUpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchUpdateUserOutput) GoString() string {
	return s.String()
}

// SetUserErrors sets the UserErrors field's value.
func (s *BatchUpdateUserOutput) SetUserErrors(v []*UserError) *BatchUpdateUserOutput {
	s.UserErrors = v
	return s
}

// A resource that allows Enterprise account administrators to configure an
// interface to receive events from Amazon Chime.
type Bot struct {
	_ struct{} `type:"structure"`

	// The bot email address.
	BotEmail *string `type:"string" sensitive:"true"`

	// The bot ID.
	BotId *string `type:"string"`

	// The bot type.
	BotType *string `type:"string" enum:"BotType"`

	// The bot creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// When true, the bot is stopped from running in your account.
	Disabled *bool `type:"boolean"`

	// The bot display name.
	DisplayName *string `type:"string" sensitive:"true"`

	// The security token used to authenticate Amazon Chime with the outgoing event
	// endpoint.
	SecurityToken *string `type:"string" sensitive:"true"`

	// The updated bot timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The unique ID for the bot user.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s Bot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Bot) GoString() string {
	return s.String()
}

// SetBotEmail sets the BotEmail field's value.
func (s *Bot) SetBotEmail(v string) *Bot {
	s.BotEmail = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *Bot) SetBotId(v string) *Bot {
	s.BotId = &v
	return s
}

// SetBotType sets the BotType field's value.
func (s *Bot) SetBotType(v string) *Bot {
	s.BotType = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Bot) SetCreatedTimestamp(v time.Time) *Bot {
	s.CreatedTimestamp = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *Bot) SetDisabled(v bool) *Bot {
	s.Disabled = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Bot) SetDisplayName(v string) *Bot {
	s.DisplayName = &v
	return s
}

// SetSecurityToken sets the SecurityToken field's value.
func (s *Bot) SetSecurityToken(v string) *Bot {
	s.SecurityToken = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *Bot) SetUpdatedTimestamp(v time.Time) *Bot {
	s.UpdatedTimestamp = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *Bot) SetUserId(v string) *Bot {
	s.UserId = &v
	return s
}

// The Amazon Chime Business Calling settings for the administrator's AWS account.
// Includes any Amazon S3 buckets designated for storing call detail records.
type BusinessCallingSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string `type:"string"`
}

// String returns the string representation
func (s BusinessCallingSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BusinessCallingSettings) GoString() string {
	return s.String()
}

// SetCdrBucket sets the CdrBucket field's value.
func (s *BusinessCallingSettings) SetCdrBucket(v string) *BusinessCallingSettings {
	s.CdrBucket = &v
	return s
}

// The request could not be processed because of conflict in the current state
// of the resource.
type ConflictException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ConflictException) OrigErr() error {
	return nil
}

func (s ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ConflictException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ConflictException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateAccountInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime account.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateAccountInput) SetName(v string) *CreateAccountInput {
	s.Name = &v
	return s
}

type CreateAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s CreateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *CreateAccountOutput) SetAccount(v *Account) *CreateAccountOutput {
	s.Account = v
	return s
}

// The list of errors returned when errors are encountered during the BatchCreateAttendee
// and CreateAttendee actions. This includes external user IDs, error codes,
// and error messages.
type CreateAttendeeError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	ExternalUserId *string `min:"2" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s CreateAttendeeError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAttendeeError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *CreateAttendeeError) SetErrorCode(v string) *CreateAttendeeError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *CreateAttendeeError) SetErrorMessage(v string) *CreateAttendeeError {
	s.ErrorMessage = &v
	return s
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeError) SetExternalUserId(v string) *CreateAttendeeError {
	s.ExternalUserId = &v
	return s
}

type CreateAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeInput"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeInput) SetExternalUserId(v string) *CreateAttendeeInput {
	s.ExternalUserId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *CreateAttendeeInput) SetMeetingId(v string) *CreateAttendeeInput {
	s.MeetingId = &v
	return s
}

type CreateAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The attendee information, including attendee ID and join token.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation
func (s CreateAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *CreateAttendeeOutput) SetAttendee(v *Attendee) *CreateAttendeeOutput {
	s.Attendee = v
	return s
}

// The Amazon Chime SDK attendee fields to create, used with the BatchCreateAttendee
// action.
type CreateAttendeeRequestItem struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK external user ID. Links the attendee to an identity
	// managed by a builder application.
	//
	// ExternalUserId is a required field
	ExternalUserId *string `min:"2" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateAttendeeRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAttendeeRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttendeeRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttendeeRequestItem"}
	if s.ExternalUserId == nil {
		invalidParams.Add(request.NewErrParamRequired("ExternalUserId"))
	}
	if s.ExternalUserId != nil && len(*s.ExternalUserId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ExternalUserId", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExternalUserId sets the ExternalUserId field's value.
func (s *CreateAttendeeRequestItem) SetExternalUserId(v string) *CreateAttendeeRequestItem {
	s.ExternalUserId = &v
	return s
}

type CreateBotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot display name.
	//
	// DisplayName is a required field
	DisplayName *string `type:"string" required:"true" sensitive:"true"`

	// The domain of the Amazon Chime Enterprise account.
	Domain *string `type:"string"`
}

// String returns the string representation
func (s CreateBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBotInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateBotInput) SetAccountId(v string) *CreateBotInput {
	s.AccountId = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateBotInput) SetDisplayName(v string) *CreateBotInput {
	s.DisplayName = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateBotInput) SetDomain(v string) *CreateBotInput {
	s.Domain = &v
	return s
}

type CreateBotOutput struct {
	_ struct{} `type:"structure"`

	// The bot details.
	Bot *Bot `type:"structure"`
}

// String returns the string representation
func (s CreateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBotOutput) GoString() string {
	return s.String()
}

// SetBot sets the Bot field's value.
func (s *CreateBotOutput) SetBot(v *Bot) *CreateBotOutput {
	s.Bot = v
	return s
}

type CreateMeetingInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the client request. Use a different token for different
	// meetings.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The Region in which to create the meeting. Available values: ap-northeast-1,
	// ap-southeast-1, ap-southeast-2, ca-central-1, eu-central-1, eu-north-1, eu-west-1,
	// eu-west-2, eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2.
	MediaRegion *string `type:"string"`

	// Reserved.
	MeetingHostId *string `min:"2" type:"string" sensitive:"true"`

	// The configuration for resource targets to receive notifications when meeting
	// and attendee events occur.
	NotificationsConfiguration *MeetingNotificationConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMeetingInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.MeetingHostId != nil && len(*s.MeetingHostId) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingHostId", 2))
	}
	if s.NotificationsConfiguration != nil {
		if err := s.NotificationsConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NotificationsConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateMeetingInput) SetClientRequestToken(v string) *CreateMeetingInput {
	s.ClientRequestToken = &v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *CreateMeetingInput) SetMediaRegion(v string) *CreateMeetingInput {
	s.MediaRegion = &v
	return s
}

// SetMeetingHostId sets the MeetingHostId field's value.
func (s *CreateMeetingInput) SetMeetingHostId(v string) *CreateMeetingInput {
	s.MeetingHostId = &v
	return s
}

// SetNotificationsConfiguration sets the NotificationsConfiguration field's value.
func (s *CreateMeetingInput) SetNotificationsConfiguration(v *MeetingNotificationConfiguration) *CreateMeetingInput {
	s.NotificationsConfiguration = v
	return s
}

type CreateMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The meeting information, including the meeting ID and MediaPlacement.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation
func (s CreateMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *CreateMeetingOutput) SetMeeting(v *Meeting) *CreateMeetingOutput {
	s.Meeting = v
	return s
}

type CreatePhoneNumberOrderInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	//
	// E164PhoneNumbers is a required field
	E164PhoneNumbers []*string `type:"list" required:"true"`

	// The phone number product type.
	//
	// ProductType is a required field
	ProductType *string `type:"string" required:"true" enum:"PhoneNumberProductType"`
}

// String returns the string representation
func (s CreatePhoneNumberOrderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePhoneNumberOrderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePhoneNumberOrderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePhoneNumberOrderInput"}
	if s.E164PhoneNumbers == nil {
		invalidParams.Add(request.NewErrParamRequired("E164PhoneNumbers"))
	}
	if s.ProductType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *CreatePhoneNumberOrderInput) SetE164PhoneNumbers(v []*string) *CreatePhoneNumberOrderInput {
	s.E164PhoneNumbers = v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *CreatePhoneNumberOrderInput) SetProductType(v string) *CreatePhoneNumberOrderInput {
	s.ProductType = &v
	return s
}

type CreatePhoneNumberOrderOutput struct {
	_ struct{} `type:"structure"`

	// The phone number order details.
	PhoneNumberOrder *PhoneNumberOrder `type:"structure"`
}

// String returns the string representation
func (s CreatePhoneNumberOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePhoneNumberOrderOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberOrder sets the PhoneNumberOrder field's value.
func (s *CreatePhoneNumberOrderOutput) SetPhoneNumberOrder(v *PhoneNumberOrder) *CreatePhoneNumberOrderOutput {
	s.PhoneNumberOrder = v
	return s
}

type CreateRoomInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The idempotency token for the request.
	ClientRequestToken *string `min:"2" type:"string" idempotencyToken:"true" sensitive:"true"`

	// The room name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s CreateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoomInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 2))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateRoomInput) SetAccountId(v string) *CreateRoomInput {
	s.AccountId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateRoomInput) SetClientRequestToken(v string) *CreateRoomInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRoomInput) SetName(v string) *CreateRoomInput {
	s.Name = &v
	return s
}

type CreateRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The Amazon Chime member ID (user ID or bot ID).
	//
	// MemberId is a required field
	MemberId *string `type:"string" required:"true"`

	// The role of the member.
	Role *string `type:"string" enum:"RoomMembershipRole"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoomMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoomMembershipInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateRoomMembershipInput) SetAccountId(v string) *CreateRoomMembershipInput {
	s.AccountId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *CreateRoomMembershipInput) SetMemberId(v string) *CreateRoomMembershipInput {
	s.MemberId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateRoomMembershipInput) SetRole(v string) *CreateRoomMembershipInput {
	s.Role = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *CreateRoomMembershipInput) SetRoomId(v string) *CreateRoomMembershipInput {
	s.RoomId = &v
	return s
}

type CreateRoomMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The room membership details.
	RoomMembership *RoomMembership `type:"structure"`
}

// String returns the string representation
func (s CreateRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomMembershipOutput) GoString() string {
	return s.String()
}

// SetRoomMembership sets the RoomMembership field's value.
func (s *CreateRoomMembershipOutput) SetRoomMembership(v *RoomMembership) *CreateRoomMembershipOutput {
	s.RoomMembership = v
	return s
}

type CreateRoomOutput struct {
	_ struct{} `type:"structure"`

	// The room details.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s CreateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoomOutput) GoString() string {
	return s.String()
}

// SetRoom sets the Room field's value.
func (s *CreateRoomOutput) SetRoom(v *Room) *CreateRoomOutput {
	s.Room = v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user's email address.
	Email *string `type:"string" sensitive:"true"`

	// The user type.
	UserType *string `type:"string" enum:"UserType"`

	// The user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *CreateUserInput) SetAccountId(v string) *CreateUserInput {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateUserInput) SetEmail(v string) *CreateUserInput {
	s.Email = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *CreateUserInput) SetUserType(v string) *CreateUserInput {
	s.UserType = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserInput) SetUsername(v string) *CreateUserInput {
	s.Username = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The user on the Amazon Chime account.
	User *User `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *CreateUserOutput) SetUser(v *User) *CreateUserOutput {
	s.User = v
	return s
}

type CreateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime Voice Connector group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Chime Voice Connectors to route inbound calls to.
	VoiceConnectorItems []*VoiceConnectorItem `type:"list"`
}

// String returns the string representation
func (s CreateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVoiceConnectorGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateVoiceConnectorGroupInput) SetName(v string) *CreateVoiceConnectorGroupInput {
	s.Name = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *CreateVoiceConnectorGroupInput) SetVoiceConnectorItems(v []*VoiceConnectorItem) *CreateVoiceConnectorGroupInput {
	s.VoiceConnectorItems = v
	return s
}

type CreateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group details.
	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation
func (s CreateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *CreateVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *CreateVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type CreateVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// The AWS Region in which the Amazon Chime Voice Connector is created. Default
	// value: us-east-1.
	AwsRegion *string `type:"string" enum:"VoiceConnectorAwsRegion"`

	// The name of the Amazon Chime Voice Connector.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// When enabled, requires encryption for the Amazon Chime Voice Connector.
	//
	// RequireEncryption is a required field
	RequireEncryption *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s CreateVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVoiceConnectorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequireEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("RequireEncryption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *CreateVoiceConnectorInput) SetAwsRegion(v string) *CreateVoiceConnectorInput {
	s.AwsRegion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVoiceConnectorInput) SetName(v string) *CreateVoiceConnectorInput {
	s.Name = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *CreateVoiceConnectorInput) SetRequireEncryption(v bool) *CreateVoiceConnectorInput {
	s.RequireEncryption = &v
	return s
}

type CreateVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector details.
	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation
func (s CreateVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *CreateVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *CreateVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

// The SIP credentials used to authenticate requests to your Amazon Chime Voice
// Connector.
type Credential struct {
	_ struct{} `type:"structure"`

	// The RFC2617 compliant password associated with the SIP credentials, in US-ASCII
	// format.
	Password *string `type:"string" sensitive:"true"`

	// The RFC2617 compliant user name associated with the SIP credentials, in US-ASCII
	// format.
	Username *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s Credential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credential) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *Credential) SetPassword(v string) *Credential {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Credential) SetUsername(v string) *Credential {
	s.Username = &v
	return s
}

type DeleteAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteAccountInput) SetAccountId(v string) *DeleteAccountInput {
	s.AccountId = &v
	return s
}

type DeleteAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountOutput) GoString() string {
	return s.String()
}

type DeleteAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"attendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *DeleteAttendeeInput) SetAttendeeId(v string) *DeleteAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteAttendeeInput) SetMeetingId(v string) *DeleteAttendeeInput {
	s.MeetingId = &v
	return s
}

type DeleteAttendeeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAttendeeOutput) GoString() string {
	return s.String()
}

type DeleteEventsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventsConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteEventsConfigurationInput) SetAccountId(v string) *DeleteEventsConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *DeleteEventsConfigurationInput) SetBotId(v string) *DeleteEventsConfigurationInput {
	s.BotId = &v
	return s
}

type DeleteEventsConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEventsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventsConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteMeetingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *DeleteMeetingInput) SetMeetingId(v string) *DeleteMeetingInput {
	s.MeetingId = &v
	return s
}

type DeleteMeetingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMeetingOutput) GoString() string {
	return s.String()
}

type DeletePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The phone number ID.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *DeletePhoneNumberInput) SetPhoneNumberId(v string) *DeletePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type DeletePhoneNumberOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePhoneNumberOutput) GoString() string {
	return s.String()
}

type DeleteRoomInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The chat room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoomInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteRoomInput) SetAccountId(v string) *DeleteRoomInput {
	s.AccountId = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *DeleteRoomInput) SetRoomId(v string) *DeleteRoomInput {
	s.RoomId = &v
	return s
}

type DeleteRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The member ID (user ID or bot ID).
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" type:"string" required:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoomMembershipInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DeleteRoomMembershipInput) SetAccountId(v string) *DeleteRoomMembershipInput {
	s.AccountId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *DeleteRoomMembershipInput) SetMemberId(v string) *DeleteRoomMembershipInput {
	s.MemberId = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *DeleteRoomMembershipInput) SetRoomId(v string) *DeleteRoomMembershipInput {
	s.RoomId = &v
	return s
}

type DeleteRoomMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomMembershipOutput) GoString() string {
	return s.String()
}

type DeleteRoomOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoomOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *DeleteVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *DeleteVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type DeleteVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorOriginationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorStreamingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The RFC2617 compliant username associated with the SIP credentials, in US-ASCII
	// format.
	Usernames []*string `type:"list"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorTerminationCredentialsInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsernames sets the Usernames field's value.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) SetUsernames(v []*string) *DeleteVoiceConnectorTerminationCredentialsInput {
	s.Usernames = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

type DeleteVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVoiceConnectorTerminationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DeleteVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *DeleteVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type DeleteVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

type DisassociatePhoneNumberFromUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociatePhoneNumberFromUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumberFromUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumberFromUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePhoneNumberFromUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DisassociatePhoneNumberFromUserInput) SetAccountId(v string) *DisassociatePhoneNumberFromUserInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *DisassociatePhoneNumberFromUserInput) SetUserId(v string) *DisassociatePhoneNumberFromUserInput {
	s.UserId = &v
	return s
}

type DisassociatePhoneNumberFromUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociatePhoneNumberFromUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumberFromUserOutput) GoString() string {
	return s.String()
}

type DisassociatePhoneNumbersFromVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []*string `type:"list"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePhoneNumbersFromVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) SetE164PhoneNumbers(v []*string) *DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
	s.E164PhoneNumbers = v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *DisassociatePhoneNumbersFromVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *DisassociatePhoneNumbersFromVoiceConnectorGroupOutput {
	s.PhoneNumberErrors = v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []*string `type:"list"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociatePhoneNumbersFromVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) SetE164PhoneNumbers(v []*string) *DisassociatePhoneNumbersFromVoiceConnectorInput {
	s.E164PhoneNumbers = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorInput) SetVoiceConnectorId(v string) *DisassociatePhoneNumbersFromVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type DisassociatePhoneNumbersFromVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// If the action fails for one or more of the phone numbers in the request,
	// a list of the phone numbers is returned, along with error codes and error
	// messages.
	PhoneNumberErrors []*PhoneNumberError `type:"list"`
}

// String returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociatePhoneNumbersFromVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberErrors sets the PhoneNumberErrors field's value.
func (s *DisassociatePhoneNumbersFromVoiceConnectorOutput) SetPhoneNumberErrors(v []*PhoneNumberError) *DisassociatePhoneNumbersFromVoiceConnectorOutput {
	s.PhoneNumberErrors = v
	return s
}

type DisassociateSigninDelegateGroupsFromAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The sign-in delegate group names.
	//
	// GroupNames is a required field
	GroupNames []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DisassociateSigninDelegateGroupsFromAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateSigninDelegateGroupsFromAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateSigninDelegateGroupsFromAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateSigninDelegateGroupsFromAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.GroupNames == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupNames"))
	}
	if s.GroupNames != nil && len(s.GroupNames) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupNames", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *DisassociateSigninDelegateGroupsFromAccountInput) SetAccountId(v string) *DisassociateSigninDelegateGroupsFromAccountInput {
	s.AccountId = &v
	return s
}

// SetGroupNames sets the GroupNames field's value.
func (s *DisassociateSigninDelegateGroupsFromAccountInput) SetGroupNames(v []*string) *DisassociateSigninDelegateGroupsFromAccountInput {
	s.GroupNames = v
	return s
}

type DisassociateSigninDelegateGroupsFromAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateSigninDelegateGroupsFromAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateSigninDelegateGroupsFromAccountOutput) GoString() string {
	return s.String()
}

// The configuration that allows a bot to receive outgoing events. Can be either
// an HTTPS endpoint or a Lambda function ARN.
type EventsConfiguration struct {
	_ struct{} `type:"structure"`

	// The bot ID.
	BotId *string `type:"string"`

	// Lambda function ARN that allows a bot to receive outgoing events.
	LambdaFunctionArn *string `type:"string" sensitive:"true"`

	// HTTPS endpoint that allows a bot to receive outgoing events.
	OutboundEventsHTTPSEndpoint *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s EventsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventsConfiguration) GoString() string {
	return s.String()
}

// SetBotId sets the BotId field's value.
func (s *EventsConfiguration) SetBotId(v string) *EventsConfiguration {
	s.BotId = &v
	return s
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *EventsConfiguration) SetLambdaFunctionArn(v string) *EventsConfiguration {
	s.LambdaFunctionArn = &v
	return s
}

// SetOutboundEventsHTTPSEndpoint sets the OutboundEventsHTTPSEndpoint field's value.
func (s *EventsConfiguration) SetOutboundEventsHTTPSEndpoint(v string) *EventsConfiguration {
	s.OutboundEventsHTTPSEndpoint = &v
	return s
}

// The client is permanently forbidden from making the request. For example,
// when a user tries to create an account from an unsupported Region.
type ForbiddenException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ForbiddenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ForbiddenException) GoString() string {
	return s.String()
}

func newErrorForbiddenException(v protocol.ResponseMetadata) error {
	return &ForbiddenException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ForbiddenException) Code() string {
	return "ForbiddenException"
}

// Message returns the exception's message.
func (s ForbiddenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ForbiddenException) OrigErr() error {
	return nil
}

func (s ForbiddenException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ForbiddenException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ForbiddenException) RequestID() string {
	return s.respMetadata.RequestID
}

type GetAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccountInput) SetAccountId(v string) *GetAccountInput {
	s.AccountId = &v
	return s
}

type GetAccountOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s GetAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *GetAccountOutput) SetAccount(v *Account) *GetAccountOutput {
	s.Account = v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetAccountSettingsInput) SetAccountId(v string) *GetAccountSettingsInput {
	s.AccountId = &v
	return s
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account settings.
	AccountSettings *AccountSettings `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

type GetAttendeeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee ID.
	//
	// AttendeeId is a required field
	AttendeeId *string `location:"uri" locationName:"attendeeId" type:"string" required:"true"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAttendeeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAttendeeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttendeeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttendeeInput"}
	if s.AttendeeId == nil {
		invalidParams.Add(request.NewErrParamRequired("AttendeeId"))
	}
	if s.AttendeeId != nil && len(*s.AttendeeId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttendeeId", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttendeeId sets the AttendeeId field's value.
func (s *GetAttendeeInput) SetAttendeeId(v string) *GetAttendeeInput {
	s.AttendeeId = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetAttendeeInput) SetMeetingId(v string) *GetAttendeeInput {
	s.MeetingId = &v
	return s
}

type GetAttendeeOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendee *Attendee `type:"structure"`
}

// String returns the string representation
func (s GetAttendeeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAttendeeOutput) GoString() string {
	return s.String()
}

// SetAttendee sets the Attendee field's value.
func (s *GetAttendeeOutput) SetAttendee(v *Attendee) *GetAttendeeOutput {
	s.Attendee = v
	return s
}

type GetBotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBotInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetBotInput) SetAccountId(v string) *GetBotInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *GetBotInput) SetBotId(v string) *GetBotInput {
	s.BotId = &v
	return s
}

type GetBotOutput struct {
	_ struct{} `type:"structure"`

	// The chat bot details.
	Bot *Bot `type:"structure"`
}

// String returns the string representation
func (s GetBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBotOutput) GoString() string {
	return s.String()
}

// SetBot sets the Bot field's value.
func (s *GetBotOutput) SetBot(v *Bot) *GetBotOutput {
	s.Bot = v
	return s
}

type GetEventsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventsConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetEventsConfigurationInput) SetAccountId(v string) *GetEventsConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *GetEventsConfigurationInput) SetBotId(v string) *GetEventsConfigurationInput {
	s.BotId = &v
	return s
}

type GetEventsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The events configuration details.
	EventsConfiguration *EventsConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetEventsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventsConfigurationOutput) GoString() string {
	return s.String()
}

// SetEventsConfiguration sets the EventsConfiguration field's value.
func (s *GetEventsConfigurationOutput) SetEventsConfiguration(v *EventsConfiguration) *GetEventsConfigurationOutput {
	s.EventsConfiguration = v
	return s
}

type GetGlobalSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGlobalSettingsInput) GoString() string {
	return s.String()
}

type GetGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Business Calling settings.
	BusinessCalling *BusinessCallingSettings `type:"structure"`

	// The Amazon Chime Voice Connector settings.
	VoiceConnector *VoiceConnectorSettings `type:"structure"`
}

// String returns the string representation
func (s GetGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGlobalSettingsOutput) GoString() string {
	return s.String()
}

// SetBusinessCalling sets the BusinessCalling field's value.
func (s *GetGlobalSettingsOutput) SetBusinessCalling(v *BusinessCallingSettings) *GetGlobalSettingsOutput {
	s.BusinessCalling = v
	return s
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *GetGlobalSettingsOutput) SetVoiceConnector(v *VoiceConnectorSettings) *GetGlobalSettingsOutput {
	s.VoiceConnector = v
	return s
}

type GetMeetingInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMeetingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMeetingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMeetingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMeetingInput"}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeetingId sets the MeetingId field's value.
func (s *GetMeetingInput) SetMeetingId(v string) *GetMeetingInput {
	s.MeetingId = &v
	return s
}

type GetMeetingOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting information.
	Meeting *Meeting `type:"structure"`
}

// String returns the string representation
func (s GetMeetingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMeetingOutput) GoString() string {
	return s.String()
}

// SetMeeting sets the Meeting field's value.
func (s *GetMeetingOutput) SetMeeting(v *Meeting) *GetMeetingOutput {
	s.Meeting = v
	return s
}

type GetPhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The phone number ID.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *GetPhoneNumberInput) SetPhoneNumberId(v string) *GetPhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type GetPhoneNumberOrderInput struct {
	_ struct{} `type:"structure"`

	// The ID for the phone number order.
	//
	// PhoneNumberOrderId is a required field
	PhoneNumberOrderId *string `location:"uri" locationName:"phoneNumberOrderId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPhoneNumberOrderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberOrderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPhoneNumberOrderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPhoneNumberOrderInput"}
	if s.PhoneNumberOrderId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberOrderId"))
	}
	if s.PhoneNumberOrderId != nil && len(*s.PhoneNumberOrderId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberOrderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberOrderId sets the PhoneNumberOrderId field's value.
func (s *GetPhoneNumberOrderInput) SetPhoneNumberOrderId(v string) *GetPhoneNumberOrderInput {
	s.PhoneNumberOrderId = &v
	return s
}

type GetPhoneNumberOrderOutput struct {
	_ struct{} `type:"structure"`

	// The phone number order details.
	PhoneNumberOrder *PhoneNumberOrder `type:"structure"`
}

// String returns the string representation
func (s GetPhoneNumberOrderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberOrderOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberOrder sets the PhoneNumberOrder field's value.
func (s *GetPhoneNumberOrderOutput) SetPhoneNumberOrder(v *PhoneNumberOrder) *GetPhoneNumberOrderOutput {
	s.PhoneNumberOrder = v
	return s
}

type GetPhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The phone number details.
	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation
func (s GetPhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *GetPhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *GetPhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

type GetPhoneNumberSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetPhoneNumberSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberSettingsInput) GoString() string {
	return s.String()
}

type GetPhoneNumberSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The default outbound calling name for the account.
	CallingName *string `type:"string" sensitive:"true"`

	// The updated outbound calling name timestamp, in ISO 8601 format.
	CallingNameUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetPhoneNumberSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPhoneNumberSettingsOutput) GoString() string {
	return s.String()
}

// SetCallingName sets the CallingName field's value.
func (s *GetPhoneNumberSettingsOutput) SetCallingName(v string) *GetPhoneNumberSettingsOutput {
	s.CallingName = &v
	return s
}

// SetCallingNameUpdatedTimestamp sets the CallingNameUpdatedTimestamp field's value.
func (s *GetPhoneNumberSettingsOutput) SetCallingNameUpdatedTimestamp(v time.Time) *GetPhoneNumberSettingsOutput {
	s.CallingNameUpdatedTimestamp = &v
	return s
}

type GetRoomInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoomInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetRoomInput) SetAccountId(v string) *GetRoomInput {
	s.AccountId = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *GetRoomInput) SetRoomId(v string) *GetRoomInput {
	s.RoomId = &v
	return s
}

type GetRoomOutput struct {
	_ struct{} `type:"structure"`

	// The room details.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s GetRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoomOutput) GoString() string {
	return s.String()
}

// SetRoom sets the Room field's value.
func (s *GetRoomOutput) SetRoom(v *Room) *GetRoomOutput {
	s.Room = v
	return s
}

type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetUserInput) SetAccountId(v string) *GetUserInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserInput) SetUserId(v string) *GetUserInput {
	s.UserId = &v
	return s
}

type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// The user details.
	User *User `type:"structure"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *GetUserOutput) SetUser(v *User) *GetUserOutput {
	s.User = v
	return s
}

type GetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *GetUserSettingsInput) SetAccountId(v string) *GetUserSettingsInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *GetUserSettingsInput) SetUserId(v string) *GetUserSettingsInput {
	s.UserId = &v
	return s
}

type GetUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user settings.
	UserSettings *UserSettings `type:"structure"`
}

// String returns the string representation
func (s GetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserSettingsOutput) GoString() string {
	return s.String()
}

// SetUserSettings sets the UserSettings field's value.
func (s *GetUserSettingsOutput) SetUserSettings(v *UserSettings) *GetUserSettingsOutput {
	s.UserSettings = v
	return s
}

type GetVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorGroupInput"}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *GetVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *GetVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

type GetVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group details.
	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *GetVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *GetVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type GetVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorInput) SetVoiceConnectorId(v string) *GetVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorLoggingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorLoggingConfigurationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorLoggingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The logging configuration details.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *GetVoiceConnectorLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *GetVoiceConnectorLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type GetVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorOriginationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`

	// The origination setting details.
	Origination *Origination `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

// SetOrigination sets the Origination field's value.
func (s *GetVoiceConnectorOriginationOutput) SetOrigination(v *Origination) *GetVoiceConnectorOriginationOutput {
	s.Origination = v
	return s
}

type GetVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector details.
	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *GetVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *GetVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

type GetVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorStreamingConfigurationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The streaming configuration details.
	StreamingConfiguration *StreamingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *GetVoiceConnectorStreamingConfigurationOutput) SetStreamingConfiguration(v *StreamingConfiguration) *GetVoiceConnectorStreamingConfigurationOutput {
	s.StreamingConfiguration = v
	return s
}

type GetVoiceConnectorTerminationHealthInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorTerminationHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorTerminationHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorTerminationHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorTerminationHealthInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorTerminationHealthInput) SetVoiceConnectorId(v string) *GetVoiceConnectorTerminationHealthInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorTerminationHealthOutput struct {
	_ struct{} `type:"structure"`

	// The termination health details.
	TerminationHealth *TerminationHealth `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorTerminationHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorTerminationHealthOutput) GoString() string {
	return s.String()
}

// SetTerminationHealth sets the TerminationHealth field's value.
func (s *GetVoiceConnectorTerminationHealthOutput) SetTerminationHealth(v *TerminationHealth) *GetVoiceConnectorTerminationHealthOutput {
	s.TerminationHealth = v
	return s
}

type GetVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVoiceConnectorTerminationInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *GetVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *GetVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type GetVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`

	// The termination setting details.
	Termination *Termination `type:"structure"`
}

// String returns the string representation
func (s GetVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

// SetTermination sets the Termination field's value.
func (s *GetVoiceConnectorTerminationOutput) SetTermination(v *Termination) *GetVoiceConnectorTerminationOutput {
	s.Termination = v
	return s
}

// Invitation object returned after emailing users to invite them to join the
// Amazon Chime Team account.
type Invite struct {
	_ struct{} `type:"structure"`

	// The email address to which the invite is sent.
	EmailAddress *string `type:"string" sensitive:"true"`

	// The status of the invite email.
	EmailStatus *string `type:"string" enum:"EmailStatus"`

	// The invite ID.
	InviteId *string `type:"string"`

	// The status of the invite.
	Status *string `type:"string" enum:"InviteStatus"`
}

// String returns the string representation
func (s Invite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Invite) GoString() string {
	return s.String()
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Invite) SetEmailAddress(v string) *Invite {
	s.EmailAddress = &v
	return s
}

// SetEmailStatus sets the EmailStatus field's value.
func (s *Invite) SetEmailStatus(v string) *Invite {
	s.EmailStatus = &v
	return s
}

// SetInviteId sets the InviteId field's value.
func (s *Invite) SetInviteId(v string) *Invite {
	s.InviteId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Invite) SetStatus(v string) *Invite {
	s.Status = &v
	return s
}

type InviteUsersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user email addresses to which to send the email invitation.
	//
	// UserEmailList is a required field
	UserEmailList []*string `type:"list" required:"true"`

	// The user type.
	UserType *string `type:"string" enum:"UserType"`
}

// String returns the string representation
func (s InviteUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InviteUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InviteUsersInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserEmailList == nil {
		invalidParams.Add(request.NewErrParamRequired("UserEmailList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *InviteUsersInput) SetAccountId(v string) *InviteUsersInput {
	s.AccountId = &v
	return s
}

// SetUserEmailList sets the UserEmailList field's value.
func (s *InviteUsersInput) SetUserEmailList(v []*string) *InviteUsersInput {
	s.UserEmailList = v
	return s
}

// SetUserType sets the UserType field's value.
func (s *InviteUsersInput) SetUserType(v string) *InviteUsersInput {
	s.UserType = &v
	return s
}

type InviteUsersOutput struct {
	_ struct{} `type:"structure"`

	// The email invitation details.
	Invites []*Invite `type:"list"`
}

// String returns the string representation
func (s InviteUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InviteUsersOutput) GoString() string {
	return s.String()
}

// SetInvites sets the Invites field's value.
func (s *InviteUsersOutput) SetInvites(v []*Invite) *InviteUsersOutput {
	s.Invites = v
	return s
}

type ListAccountsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. Defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Amazon Chime account name prefix with which to filter results.
	Name *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// User email address with which to filter results.
	UserEmail *string `location:"querystring" locationName:"user-email" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s ListAccountsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsInput) SetMaxResults(v int64) *ListAccountsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListAccountsInput) SetName(v string) *ListAccountsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsInput) SetNextToken(v string) *ListAccountsInput {
	s.NextToken = &v
	return s
}

// SetUserEmail sets the UserEmail field's value.
func (s *ListAccountsInput) SetUserEmail(v string) *ListAccountsInput {
	s.UserEmail = &v
	return s
}

type ListAccountsOutput struct {
	_ struct{} `type:"structure"`

	// List of Amazon Chime accounts and account details.
	Accounts []*Account `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAccountsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountsOutput) GoString() string {
	return s.String()
}

// SetAccounts sets the Accounts field's value.
func (s *ListAccountsOutput) SetAccounts(v []*Account) *ListAccountsOutput {
	s.Accounts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsOutput) SetNextToken(v string) *ListAccountsOutput {
	s.NextToken = &v
	return s
}

type ListAttendeesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The Amazon Chime SDK meeting ID.
	//
	// MeetingId is a required field
	MeetingId *string `location:"uri" locationName:"meetingId" type:"string" required:"true"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListAttendeesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttendeesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttendeesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttendeesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.MeetingId == nil {
		invalidParams.Add(request.NewErrParamRequired("MeetingId"))
	}
	if s.MeetingId != nil && len(*s.MeetingId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeetingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttendeesInput) SetMaxResults(v int64) *ListAttendeesInput {
	s.MaxResults = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *ListAttendeesInput) SetMeetingId(v string) *ListAttendeesInput {
	s.MeetingId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesInput) SetNextToken(v string) *ListAttendeesInput {
	s.NextToken = &v
	return s
}

type ListAttendeesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK attendee information.
	Attendees []*Attendee `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListAttendeesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttendeesOutput) GoString() string {
	return s.String()
}

// SetAttendees sets the Attendees field's value.
func (s *ListAttendeesOutput) SetAttendees(v []*Attendee) *ListAttendeesOutput {
	s.Attendees = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttendeesOutput) SetNextToken(v string) *ListAttendeesOutput {
	s.NextToken = &v
	return s
}

type ListBotsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call. The default is
	// 10.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListBotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBotsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListBotsInput) SetAccountId(v string) *ListBotsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBotsInput) SetMaxResults(v int64) *ListBotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotsInput) SetNextToken(v string) *ListBotsInput {
	s.NextToken = &v
	return s
}

type ListBotsOutput struct {
	_ struct{} `type:"structure"`

	// List of bots and bot details.
	Bots []*Bot `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListBotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBotsOutput) GoString() string {
	return s.String()
}

// SetBots sets the Bots field's value.
func (s *ListBotsOutput) SetBots(v []*Bot) *ListBotsOutput {
	s.Bots = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBotsOutput) SetNextToken(v string) *ListBotsOutput {
	s.NextToken = &v
	return s
}

type ListMeetingsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListMeetingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeetingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMeetingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMeetingsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMeetingsInput) SetMaxResults(v int64) *ListMeetingsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeetingsInput) SetNextToken(v string) *ListMeetingsInput {
	s.NextToken = &v
	return s
}

type ListMeetingsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime SDK meeting information.
	Meetings []*Meeting `type:"list"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListMeetingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMeetingsOutput) GoString() string {
	return s.String()
}

// SetMeetings sets the Meetings field's value.
func (s *ListMeetingsOutput) SetMeetings(v []*Meeting) *ListMeetingsOutput {
	s.Meetings = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeetingsOutput) SetNextToken(v string) *ListMeetingsOutput {
	s.NextToken = &v
	return s
}

type ListPhoneNumberOrdersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListPhoneNumberOrdersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumberOrdersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumberOrdersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPhoneNumberOrdersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPhoneNumberOrdersInput) SetMaxResults(v int64) *ListPhoneNumberOrdersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumberOrdersInput) SetNextToken(v string) *ListPhoneNumberOrdersInput {
	s.NextToken = &v
	return s
}

type ListPhoneNumberOrdersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The phone number order details.
	PhoneNumberOrders []*PhoneNumberOrder `type:"list"`
}

// String returns the string representation
func (s ListPhoneNumberOrdersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumberOrdersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumberOrdersOutput) SetNextToken(v string) *ListPhoneNumberOrdersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumberOrders sets the PhoneNumberOrders field's value.
func (s *ListPhoneNumberOrdersOutput) SetPhoneNumberOrders(v []*PhoneNumberOrder) *ListPhoneNumberOrdersOutput {
	s.PhoneNumberOrders = v
	return s
}

type ListPhoneNumbersInput struct {
	_ struct{} `type:"structure"`

	// The filter to use to limit the number of results.
	FilterName *string `location:"querystring" locationName:"filter-name" type:"string" enum:"PhoneNumberAssociationName"`

	// The value to use for the filter.
	FilterValue *string `location:"querystring" locationName:"filter-value" type:"string"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The phone number product type.
	ProductType *string `location:"querystring" locationName:"product-type" type:"string" enum:"PhoneNumberProductType"`

	// The phone number status.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"PhoneNumberStatus"`
}

// String returns the string representation
func (s ListPhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPhoneNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilterName sets the FilterName field's value.
func (s *ListPhoneNumbersInput) SetFilterName(v string) *ListPhoneNumbersInput {
	s.FilterName = &v
	return s
}

// SetFilterValue sets the FilterValue field's value.
func (s *ListPhoneNumbersInput) SetFilterValue(v string) *ListPhoneNumbersInput {
	s.FilterValue = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPhoneNumbersInput) SetMaxResults(v int64) *ListPhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersInput) SetNextToken(v string) *ListPhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *ListPhoneNumbersInput) SetProductType(v string) *ListPhoneNumbersInput {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListPhoneNumbersInput) SetStatus(v string) *ListPhoneNumbersInput {
	s.Status = &v
	return s
}

type ListPhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The phone number details.
	PhoneNumbers []*PhoneNumber `type:"list"`
}

// String returns the string representation
func (s ListPhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPhoneNumbersOutput) SetNextToken(v string) *ListPhoneNumbersOutput {
	s.NextToken = &v
	return s
}

// SetPhoneNumbers sets the PhoneNumbers field's value.
func (s *ListPhoneNumbersOutput) SetPhoneNumbers(v []*PhoneNumber) *ListPhoneNumbersOutput {
	s.PhoneNumbers = v
	return s
}

type ListRoomMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRoomMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoomMembershipsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoomMembershipsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoomMembershipsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRoomMembershipsInput) SetAccountId(v string) *ListRoomMembershipsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoomMembershipsInput) SetMaxResults(v int64) *ListRoomMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomMembershipsInput) SetNextToken(v string) *ListRoomMembershipsInput {
	s.NextToken = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *ListRoomMembershipsInput) SetRoomId(v string) *ListRoomMembershipsInput {
	s.RoomId = &v
	return s
}

type ListRoomMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The room membership details.
	RoomMemberships []*RoomMembership `type:"list"`
}

// String returns the string representation
func (s ListRoomMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoomMembershipsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomMembershipsOutput) SetNextToken(v string) *ListRoomMembershipsOutput {
	s.NextToken = &v
	return s
}

// SetRoomMemberships sets the RoomMemberships field's value.
func (s *ListRoomMembershipsOutput) SetRoomMemberships(v []*RoomMembership) *ListRoomMembershipsOutput {
	s.RoomMemberships = v
	return s
}

type ListRoomsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The member ID (user ID or bot ID).
	MemberId *string `location:"querystring" locationName:"member-id" type:"string"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListRoomsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoomsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRoomsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRoomsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRoomsInput) SetAccountId(v string) *ListRoomsInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRoomsInput) SetMaxResults(v int64) *ListRoomsInput {
	s.MaxResults = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *ListRoomsInput) SetMemberId(v string) *ListRoomsInput {
	s.MemberId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomsInput) SetNextToken(v string) *ListRoomsInput {
	s.NextToken = &v
	return s
}

type ListRoomsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The room details.
	Rooms []*Room `type:"list"`
}

// String returns the string representation
func (s ListRoomsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRoomsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRoomsOutput) SetNextToken(v string) *ListRoomsOutput {
	s.NextToken = &v
	return s
}

// SetRooms sets the Rooms field's value.
func (s *ListRoomsOutput) SetRooms(v []*Room) *ListRoomsOutput {
	s.Rooms = v
	return s
}

type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of results to return in a single call. Defaults to 100.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// Optional. The user email address used to filter results. Maximum 1.
	UserEmail *string `location:"querystring" locationName:"user-email" type:"string" sensitive:"true"`

	// The user type.
	UserType *string `location:"querystring" locationName:"user-type" type:"string" enum:"UserType"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListUsersInput) SetAccountId(v string) *ListUsersInput {
	s.AccountId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsersInput) SetMaxResults(v int64) *ListUsersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersInput) SetNextToken(v string) *ListUsersInput {
	s.NextToken = &v
	return s
}

// SetUserEmail sets the UserEmail field's value.
func (s *ListUsersInput) SetUserEmail(v string) *ListUsersInput {
	s.UserEmail = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *ListUsersInput) SetUserType(v string) *ListUsersInput {
	s.UserType = &v
	return s
}

type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// List of users and user details.
	Users []*User `type:"list"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsersOutput) SetNextToken(v string) *ListUsersOutput {
	s.NextToken = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

type ListVoiceConnectorGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListVoiceConnectorGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVoiceConnectorGroupsInput) SetMaxResults(v int64) *ListVoiceConnectorGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorGroupsInput) SetNextToken(v string) *ListVoiceConnectorGroupsInput {
	s.NextToken = &v
	return s
}

type ListVoiceConnectorGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The details of the Amazon Chime Voice Connector groups.
	VoiceConnectorGroups []*VoiceConnectorGroup `type:"list"`
}

// String returns the string representation
func (s ListVoiceConnectorGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorGroupsOutput) SetNextToken(v string) *ListVoiceConnectorGroupsOutput {
	s.NextToken = &v
	return s
}

// SetVoiceConnectorGroups sets the VoiceConnectorGroups field's value.
func (s *ListVoiceConnectorGroupsOutput) SetVoiceConnectorGroups(v []*VoiceConnectorGroup) *ListVoiceConnectorGroupsOutput {
	s.VoiceConnectorGroups = v
	return s
}

type ListVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorTerminationCredentialsInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *ListVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *ListVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type ListVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A list of user names.
	Usernames []*string `type:"list"`
}

// String returns the string representation
func (s ListVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

// SetUsernames sets the Usernames field's value.
func (s *ListVoiceConnectorTerminationCredentialsOutput) SetUsernames(v []*string) *ListVoiceConnectorTerminationCredentialsOutput {
	s.Usernames = v
	return s
}

type ListVoiceConnectorsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListVoiceConnectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVoiceConnectorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVoiceConnectorsInput) SetMaxResults(v int64) *ListVoiceConnectorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorsInput) SetNextToken(v string) *ListVoiceConnectorsInput {
	s.NextToken = &v
	return s
}

type ListVoiceConnectorsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The details of the Amazon Chime Voice Connectors.
	VoiceConnectors []*VoiceConnector `type:"list"`
}

// String returns the string representation
func (s ListVoiceConnectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVoiceConnectorsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVoiceConnectorsOutput) SetNextToken(v string) *ListVoiceConnectorsOutput {
	s.NextToken = &v
	return s
}

// SetVoiceConnectors sets the VoiceConnectors field's value.
func (s *ListVoiceConnectorsOutput) SetVoiceConnectors(v []*VoiceConnector) *ListVoiceConnectorsOutput {
	s.VoiceConnectors = v
	return s
}

// The logging configuration associated with an Amazon Chime Voice Connector.
// Specifies whether SIP message logs are enabled for sending to Amazon CloudWatch
// Logs.
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// When true, enables SIP message logs for sending to Amazon CloudWatch Logs.
	EnableSIPLogs *bool `type:"boolean"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// SetEnableSIPLogs sets the EnableSIPLogs field's value.
func (s *LoggingConfiguration) SetEnableSIPLogs(v bool) *LoggingConfiguration {
	s.EnableSIPLogs = &v
	return s
}

type LogoutUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s LogoutUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogoutUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LogoutUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LogoutUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *LogoutUserInput) SetAccountId(v string) *LogoutUserInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *LogoutUserInput) SetUserId(v string) *LogoutUserInput {
	s.UserId = &v
	return s
}

type LogoutUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s LogoutUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogoutUserOutput) GoString() string {
	return s.String()
}

// A set of endpoints used by clients to connect to the media service group
// for a Amazon Chime SDK meeting.
type MediaPlacement struct {
	_ struct{} `type:"structure"`

	// The audio fallback URL.
	AudioFallbackUrl *string `type:"string"`

	// The audio host URL.
	AudioHostUrl *string `type:"string"`

	// The screen data URL.
	ScreenDataUrl *string `type:"string"`

	// The screen sharing URL.
	ScreenSharingUrl *string `type:"string"`

	// The screen viewing URL.
	ScreenViewingUrl *string `type:"string"`

	// The signaling URL.
	SignalingUrl *string `type:"string"`

	// The turn control URL.
	TurnControlUrl *string `type:"string"`
}

// String returns the string representation
func (s MediaPlacement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MediaPlacement) GoString() string {
	return s.String()
}

// SetAudioFallbackUrl sets the AudioFallbackUrl field's value.
func (s *MediaPlacement) SetAudioFallbackUrl(v string) *MediaPlacement {
	s.AudioFallbackUrl = &v
	return s
}

// SetAudioHostUrl sets the AudioHostUrl field's value.
func (s *MediaPlacement) SetAudioHostUrl(v string) *MediaPlacement {
	s.AudioHostUrl = &v
	return s
}

// SetScreenDataUrl sets the ScreenDataUrl field's value.
func (s *MediaPlacement) SetScreenDataUrl(v string) *MediaPlacement {
	s.ScreenDataUrl = &v
	return s
}

// SetScreenSharingUrl sets the ScreenSharingUrl field's value.
func (s *MediaPlacement) SetScreenSharingUrl(v string) *MediaPlacement {
	s.ScreenSharingUrl = &v
	return s
}

// SetScreenViewingUrl sets the ScreenViewingUrl field's value.
func (s *MediaPlacement) SetScreenViewingUrl(v string) *MediaPlacement {
	s.ScreenViewingUrl = &v
	return s
}

// SetSignalingUrl sets the SignalingUrl field's value.
func (s *MediaPlacement) SetSignalingUrl(v string) *MediaPlacement {
	s.SignalingUrl = &v
	return s
}

// SetTurnControlUrl sets the TurnControlUrl field's value.
func (s *MediaPlacement) SetTurnControlUrl(v string) *MediaPlacement {
	s.TurnControlUrl = &v
	return s
}

// A meeting created using the Amazon Chime SDK.
type Meeting struct {
	_ struct{} `type:"structure"`

	// The media placement for the meeting.
	MediaPlacement *MediaPlacement `type:"structure"`

	// The Region in which to create the meeting. Available values: ap-northeast-1,
	// ap-southeast-1, ap-southeast-2, ca-central-1, eu-central-1, eu-north-1, eu-west-1,
	// eu-west-2, eu-west-3, sa-east-1, us-east-1, us-east-2, us-west-1, us-west-2.
	MediaRegion *string `type:"string"`

	// The Amazon Chime SDK meeting ID.
	MeetingId *string `type:"string"`
}

// String returns the string representation
func (s Meeting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Meeting) GoString() string {
	return s.String()
}

// SetMediaPlacement sets the MediaPlacement field's value.
func (s *Meeting) SetMediaPlacement(v *MediaPlacement) *Meeting {
	s.MediaPlacement = v
	return s
}

// SetMediaRegion sets the MediaRegion field's value.
func (s *Meeting) SetMediaRegion(v string) *Meeting {
	s.MediaRegion = &v
	return s
}

// SetMeetingId sets the MeetingId field's value.
func (s *Meeting) SetMeetingId(v string) *Meeting {
	s.MeetingId = &v
	return s
}

// The configuration for resource targets to receive notifications when Amazon
// Chime SDK meeting and attendee events occur.
type MeetingNotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The SNS topic ARN.
	SnsTopicArn *string `min:"1" type:"string" sensitive:"true"`

	// The SQS queue ARN.
	SqsQueueArn *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation
func (s MeetingNotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MeetingNotificationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MeetingNotificationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MeetingNotificationConfiguration"}
	if s.SnsTopicArn != nil && len(*s.SnsTopicArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnsTopicArn", 1))
	}
	if s.SqsQueueArn != nil && len(*s.SqsQueueArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqsQueueArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *MeetingNotificationConfiguration) SetSnsTopicArn(v string) *MeetingNotificationConfiguration {
	s.SnsTopicArn = &v
	return s
}

// SetSqsQueueArn sets the SqsQueueArn field's value.
func (s *MeetingNotificationConfiguration) SetSqsQueueArn(v string) *MeetingNotificationConfiguration {
	s.SqsQueueArn = &v
	return s
}

// The member details, such as email address, name, member ID, and member type.
type Member struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The member email address.
	Email *string `type:"string" sensitive:"true"`

	// The member name.
	FullName *string `type:"string" sensitive:"true"`

	// The member ID (user ID or bot ID).
	MemberId *string `type:"string"`

	// The member type.
	MemberType *string `type:"string" enum:"MemberType"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Member) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Member) SetAccountId(v string) *Member {
	s.AccountId = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *Member) SetEmail(v string) *Member {
	s.Email = &v
	return s
}

// SetFullName sets the FullName field's value.
func (s *Member) SetFullName(v string) *Member {
	s.FullName = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *Member) SetMemberId(v string) *Member {
	s.MemberId = &v
	return s
}

// SetMemberType sets the MemberType field's value.
func (s *Member) SetMemberType(v string) *Member {
	s.MemberType = &v
	return s
}

// The list of errors returned when a member action results in an error.
type MemberError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The member ID.
	MemberId *string `type:"string"`
}

// String returns the string representation
func (s MemberError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *MemberError) SetErrorCode(v string) *MemberError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *MemberError) SetErrorMessage(v string) *MemberError {
	s.ErrorMessage = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *MemberError) SetMemberId(v string) *MemberError {
	s.MemberId = &v
	return s
}

// Membership details, such as member ID and member role.
type MembershipItem struct {
	_ struct{} `type:"structure"`

	// The member ID.
	MemberId *string `type:"string"`

	// The member role.
	Role *string `type:"string" enum:"RoomMembershipRole"`
}

// String returns the string representation
func (s MembershipItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MembershipItem) GoString() string {
	return s.String()
}

// SetMemberId sets the MemberId field's value.
func (s *MembershipItem) SetMemberId(v string) *MembershipItem {
	s.MemberId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *MembershipItem) SetRole(v string) *MembershipItem {
	s.Role = &v
	return s
}

// One or more of the resources in the request does not exist in the system.
type NotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NotFoundException) OrigErr() error {
	return nil
}

func (s NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s NotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// A phone number for which an order has been placed.
type OrderedPhoneNumber struct {
	_ struct{} `type:"structure"`

	// The phone number, in E.164 format.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	// The phone number status.
	Status *string `type:"string" enum:"OrderedPhoneNumberStatus"`
}

// String returns the string representation
func (s OrderedPhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderedPhoneNumber) GoString() string {
	return s.String()
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *OrderedPhoneNumber) SetE164PhoneNumber(v string) *OrderedPhoneNumber {
	s.E164PhoneNumber = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OrderedPhoneNumber) SetStatus(v string) *OrderedPhoneNumber {
	s.Status = &v
	return s
}

// Origination settings enable your SIP hosts to receive inbound calls using
// your Amazon Chime Voice Connector.
type Origination struct {
	_ struct{} `type:"structure"`

	// When origination settings are disabled, inbound calls are not enabled for
	// your Amazon Chime Voice Connector.
	Disabled *bool `type:"boolean"`

	// The call distribution properties defined for your SIP hosts. Valid range:
	// Minimum value of 1. Maximum value of 20.
	Routes []*OriginationRoute `type:"list"`
}

// String returns the string representation
func (s Origination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Origination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Origination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Origination"}
	if s.Routes != nil {
		for i, v := range s.Routes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Routes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisabled sets the Disabled field's value.
func (s *Origination) SetDisabled(v bool) *Origination {
	s.Disabled = &v
	return s
}

// SetRoutes sets the Routes field's value.
func (s *Origination) SetRoutes(v []*OriginationRoute) *Origination {
	s.Routes = v
	return s
}

// Origination routes define call distribution properties for your SIP hosts
// to receive inbound calls using your Amazon Chime Voice Connector. Limit:
// Ten origination routes for each Amazon Chime Voice Connector.
type OriginationRoute struct {
	_ struct{} `type:"structure"`

	// The FQDN or IP address to contact for origination traffic.
	Host *string `type:"string"`

	// The designated origination route port. Defaults to 5060.
	Port *int64 `type:"integer"`

	// The priority associated with the host, with 1 being the highest priority.
	// Higher priority hosts are attempted first.
	Priority *int64 `min:"1" type:"integer"`

	// The protocol to use for the origination route. Encryption-enabled Amazon
	// Chime Voice Connectors use TCP protocol by default.
	Protocol *string `type:"string" enum:"OriginationRouteProtocol"`

	// The weight associated with the host. If hosts are equal in priority, calls
	// are distributed among them based on their relative weight.
	Weight *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s OriginationRoute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginationRoute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OriginationRoute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OriginationRoute"}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.Weight != nil && *s.Weight < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Weight", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *OriginationRoute) SetHost(v string) *OriginationRoute {
	s.Host = &v
	return s
}

// SetPort sets the Port field's value.
func (s *OriginationRoute) SetPort(v int64) *OriginationRoute {
	s.Port = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *OriginationRoute) SetPriority(v int64) *OriginationRoute {
	s.Priority = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *OriginationRoute) SetProtocol(v string) *OriginationRoute {
	s.Protocol = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *OriginationRoute) SetWeight(v int64) *OriginationRoute {
	s.Weight = &v
	return s
}

// A phone number used for Amazon Chime Business Calling or an Amazon Chime
// Voice Connector.
type PhoneNumber struct {
	_ struct{} `type:"structure"`

	// The phone number associations.
	Associations []*PhoneNumberAssociation `type:"list"`

	// The outbound calling name associated with the phone number.
	CallingName *string `type:"string" sensitive:"true"`

	// The outbound calling name status.
	CallingNameStatus *string `type:"string" enum:"CallingNameStatus"`

	// The phone number capabilities.
	Capabilities *PhoneNumberCapabilities `type:"structure"`

	// The phone number creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The deleted phone number timestamp, in ISO 8601 format.
	DeletionTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The phone number, in E.164 format.
	E164PhoneNumber *string `type:"string" sensitive:"true"`

	// The phone number ID.
	PhoneNumberId *string `type:"string"`

	// The phone number product type.
	ProductType *string `type:"string" enum:"PhoneNumberProductType"`

	// The phone number status.
	Status *string `type:"string" enum:"PhoneNumberStatus"`

	// The phone number type.
	Type *string `type:"string" enum:"PhoneNumberType"`

	// The updated phone number timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PhoneNumber) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumber) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *PhoneNumber) SetAssociations(v []*PhoneNumberAssociation) *PhoneNumber {
	s.Associations = v
	return s
}

// SetCallingName sets the CallingName field's value.
func (s *PhoneNumber) SetCallingName(v string) *PhoneNumber {
	s.CallingName = &v
	return s
}

// SetCallingNameStatus sets the CallingNameStatus field's value.
func (s *PhoneNumber) SetCallingNameStatus(v string) *PhoneNumber {
	s.CallingNameStatus = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *PhoneNumber) SetCapabilities(v *PhoneNumberCapabilities) *PhoneNumber {
	s.Capabilities = v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PhoneNumber) SetCreatedTimestamp(v time.Time) *PhoneNumber {
	s.CreatedTimestamp = &v
	return s
}

// SetDeletionTimestamp sets the DeletionTimestamp field's value.
func (s *PhoneNumber) SetDeletionTimestamp(v time.Time) *PhoneNumber {
	s.DeletionTimestamp = &v
	return s
}

// SetE164PhoneNumber sets the E164PhoneNumber field's value.
func (s *PhoneNumber) SetE164PhoneNumber(v string) *PhoneNumber {
	s.E164PhoneNumber = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *PhoneNumber) SetPhoneNumberId(v string) *PhoneNumber {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *PhoneNumber) SetProductType(v string) *PhoneNumber {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PhoneNumber) SetStatus(v string) *PhoneNumber {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *PhoneNumber) SetType(v string) *PhoneNumber {
	s.Type = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *PhoneNumber) SetUpdatedTimestamp(v time.Time) *PhoneNumber {
	s.UpdatedTimestamp = &v
	return s
}

// The phone number associations, such as Amazon Chime account ID, Amazon Chime
// user ID, Amazon Chime Voice Connector ID, or Amazon Chime Voice Connector
// group ID.
type PhoneNumberAssociation struct {
	_ struct{} `type:"structure"`

	// The timestamp of the phone number association, in ISO 8601 format.
	AssociatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Defines the association with an Amazon Chime account ID, user ID, Amazon
	// Chime Voice Connector ID, or Amazon Chime Voice Connector group ID.
	Name *string `type:"string" enum:"PhoneNumberAssociationName"`

	// Contains the ID for the entity specified in Name.
	Value *string `type:"string"`
}

// String returns the string representation
func (s PhoneNumberAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberAssociation) GoString() string {
	return s.String()
}

// SetAssociatedTimestamp sets the AssociatedTimestamp field's value.
func (s *PhoneNumberAssociation) SetAssociatedTimestamp(v time.Time) *PhoneNumberAssociation {
	s.AssociatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *PhoneNumberAssociation) SetName(v string) *PhoneNumberAssociation {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PhoneNumberAssociation) SetValue(v string) *PhoneNumberAssociation {
	s.Value = &v
	return s
}

// The phone number capabilities for Amazon Chime Business Calling phone numbers,
// such as enabled inbound and outbound calling and text messaging.
type PhoneNumberCapabilities struct {
	_ struct{} `type:"structure"`

	// Allows or denies inbound calling for the specified phone number.
	InboundCall *bool `type:"boolean"`

	// Allows or denies inbound MMS messaging for the specified phone number.
	InboundMMS *bool `type:"boolean"`

	// Allows or denies inbound SMS messaging for the specified phone number.
	InboundSMS *bool `type:"boolean"`

	// Allows or denies outbound calling for the specified phone number.
	OutboundCall *bool `type:"boolean"`

	// Allows or denies outbound MMS messaging for the specified phone number.
	OutboundMMS *bool `type:"boolean"`

	// Allows or denies outbound SMS messaging for the specified phone number.
	OutboundSMS *bool `type:"boolean"`
}

// String returns the string representation
func (s PhoneNumberCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberCapabilities) GoString() string {
	return s.String()
}

// SetInboundCall sets the InboundCall field's value.
func (s *PhoneNumberCapabilities) SetInboundCall(v bool) *PhoneNumberCapabilities {
	s.InboundCall = &v
	return s
}

// SetInboundMMS sets the InboundMMS field's value.
func (s *PhoneNumberCapabilities) SetInboundMMS(v bool) *PhoneNumberCapabilities {
	s.InboundMMS = &v
	return s
}

// SetInboundSMS sets the InboundSMS field's value.
func (s *PhoneNumberCapabilities) SetInboundSMS(v bool) *PhoneNumberCapabilities {
	s.InboundSMS = &v
	return s
}

// SetOutboundCall sets the OutboundCall field's value.
func (s *PhoneNumberCapabilities) SetOutboundCall(v bool) *PhoneNumberCapabilities {
	s.OutboundCall = &v
	return s
}

// SetOutboundMMS sets the OutboundMMS field's value.
func (s *PhoneNumberCapabilities) SetOutboundMMS(v bool) *PhoneNumberCapabilities {
	s.OutboundMMS = &v
	return s
}

// SetOutboundSMS sets the OutboundSMS field's value.
func (s *PhoneNumberCapabilities) SetOutboundSMS(v bool) *PhoneNumberCapabilities {
	s.OutboundSMS = &v
	return s
}

// If the phone number action fails for one or more of the phone numbers in
// the request, a list of the phone numbers is returned, along with error codes
// and error messages.
type PhoneNumberError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The phone number ID for which the action failed.
	PhoneNumberId *string `type:"string"`
}

// String returns the string representation
func (s PhoneNumberError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PhoneNumberError) SetErrorCode(v string) *PhoneNumberError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PhoneNumberError) SetErrorMessage(v string) *PhoneNumberError {
	s.ErrorMessage = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *PhoneNumberError) SetPhoneNumberId(v string) *PhoneNumberError {
	s.PhoneNumberId = &v
	return s
}

// The details of a phone number order created for Amazon Chime.
type PhoneNumberOrder struct {
	_ struct{} `type:"structure"`

	// The phone number order creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The ordered phone number details, such as the phone number in E.164 format
	// and the phone number status.
	OrderedPhoneNumbers []*OrderedPhoneNumber `type:"list"`

	// The phone number order ID.
	PhoneNumberOrderId *string `type:"string"`

	// The phone number order product type.
	ProductType *string `type:"string" enum:"PhoneNumberProductType"`

	// The status of the phone number order.
	Status *string `type:"string" enum:"PhoneNumberOrderStatus"`

	// The updated phone number order timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PhoneNumberOrder) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneNumberOrder) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *PhoneNumberOrder) SetCreatedTimestamp(v time.Time) *PhoneNumberOrder {
	s.CreatedTimestamp = &v
	return s
}

// SetOrderedPhoneNumbers sets the OrderedPhoneNumbers field's value.
func (s *PhoneNumberOrder) SetOrderedPhoneNumbers(v []*OrderedPhoneNumber) *PhoneNumberOrder {
	s.OrderedPhoneNumbers = v
	return s
}

// SetPhoneNumberOrderId sets the PhoneNumberOrderId field's value.
func (s *PhoneNumberOrder) SetPhoneNumberOrderId(v string) *PhoneNumberOrder {
	s.PhoneNumberOrderId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *PhoneNumberOrder) SetProductType(v string) *PhoneNumberOrder {
	s.ProductType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PhoneNumberOrder) SetStatus(v string) *PhoneNumberOrder {
	s.Status = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *PhoneNumberOrder) SetUpdatedTimestamp(v time.Time) *PhoneNumberOrder {
	s.UpdatedTimestamp = &v
	return s
}

type PutEventsConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`

	// Lambda function ARN that allows the bot to receive outgoing events.
	LambdaFunctionArn *string `type:"string" sensitive:"true"`

	// HTTPS endpoint that allows the bot to receive outgoing events.
	OutboundEventsHTTPSEndpoint *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s PutEventsConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventsConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventsConfigurationInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *PutEventsConfigurationInput) SetAccountId(v string) *PutEventsConfigurationInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *PutEventsConfigurationInput) SetBotId(v string) *PutEventsConfigurationInput {
	s.BotId = &v
	return s
}

// SetLambdaFunctionArn sets the LambdaFunctionArn field's value.
func (s *PutEventsConfigurationInput) SetLambdaFunctionArn(v string) *PutEventsConfigurationInput {
	s.LambdaFunctionArn = &v
	return s
}

// SetOutboundEventsHTTPSEndpoint sets the OutboundEventsHTTPSEndpoint field's value.
func (s *PutEventsConfigurationInput) SetOutboundEventsHTTPSEndpoint(v string) *PutEventsConfigurationInput {
	s.OutboundEventsHTTPSEndpoint = &v
	return s
}

type PutEventsConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The configuration that allows a bot to receive outgoing events. Can be either
	// an HTTPS endpoint or a Lambda function ARN.
	EventsConfiguration *EventsConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutEventsConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventsConfigurationOutput) GoString() string {
	return s.String()
}

// SetEventsConfiguration sets the EventsConfiguration field's value.
func (s *PutEventsConfigurationOutput) SetEventsConfiguration(v *EventsConfiguration) *PutEventsConfigurationOutput {
	s.EventsConfiguration = v
	return s
}

type PutVoiceConnectorLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The logging configuration details to add.
	//
	// LoggingConfiguration is a required field
	LoggingConfiguration *LoggingConfiguration `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorLoggingConfigurationInput"}
	if s.LoggingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfiguration"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutVoiceConnectorLoggingConfigurationInput) SetLoggingConfiguration(v *LoggingConfiguration) *PutVoiceConnectorLoggingConfigurationInput {
	s.LoggingConfiguration = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorLoggingConfigurationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorLoggingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The updated logging configuration details.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutVoiceConnectorLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *PutVoiceConnectorLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type PutVoiceConnectorOriginationInput struct {
	_ struct{} `type:"structure"`

	// The origination setting details to add.
	//
	// Origination is a required field
	Origination *Origination `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorOriginationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorOriginationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorOriginationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorOriginationInput"}
	if s.Origination == nil {
		invalidParams.Add(request.NewErrParamRequired("Origination"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.Origination != nil {
		if err := s.Origination.Validate(); err != nil {
			invalidParams.AddNested("Origination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrigination sets the Origination field's value.
func (s *PutVoiceConnectorOriginationInput) SetOrigination(v *Origination) *PutVoiceConnectorOriginationInput {
	s.Origination = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorOriginationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorOriginationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorOriginationOutput struct {
	_ struct{} `type:"structure"`

	// The updated origination setting details.
	Origination *Origination `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorOriginationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorOriginationOutput) GoString() string {
	return s.String()
}

// SetOrigination sets the Origination field's value.
func (s *PutVoiceConnectorOriginationOutput) SetOrigination(v *Origination) *PutVoiceConnectorOriginationOutput {
	s.Origination = v
	return s
}

type PutVoiceConnectorStreamingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The streaming configuration details to add.
	//
	// StreamingConfiguration is a required field
	StreamingConfiguration *StreamingConfiguration `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorStreamingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorStreamingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorStreamingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorStreamingConfigurationInput"}
	if s.StreamingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingConfiguration"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.StreamingConfiguration != nil {
		if err := s.StreamingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("StreamingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *PutVoiceConnectorStreamingConfigurationInput) SetStreamingConfiguration(v *StreamingConfiguration) *PutVoiceConnectorStreamingConfigurationInput {
	s.StreamingConfiguration = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorStreamingConfigurationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorStreamingConfigurationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorStreamingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The updated streaming configuration details.
	StreamingConfiguration *StreamingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorStreamingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorStreamingConfigurationOutput) GoString() string {
	return s.String()
}

// SetStreamingConfiguration sets the StreamingConfiguration field's value.
func (s *PutVoiceConnectorStreamingConfigurationOutput) SetStreamingConfiguration(v *StreamingConfiguration) *PutVoiceConnectorStreamingConfigurationOutput {
	s.StreamingConfiguration = v
	return s
}

type PutVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The termination SIP credentials.
	Credentials []*Credential `type:"list"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorTerminationCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorTerminationCredentialsInput"}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCredentials sets the Credentials field's value.
func (s *PutVoiceConnectorTerminationCredentialsInput) SetCredentials(v []*Credential) *PutVoiceConnectorTerminationCredentialsInput {
	s.Credentials = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorTerminationCredentialsInput) SetVoiceConnectorId(v string) *PutVoiceConnectorTerminationCredentialsInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorTerminationCredentialsOutput) GoString() string {
	return s.String()
}

type PutVoiceConnectorTerminationInput struct {
	_ struct{} `type:"structure"`

	// The termination setting details to add.
	//
	// Termination is a required field
	Termination *Termination `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutVoiceConnectorTerminationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorTerminationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutVoiceConnectorTerminationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutVoiceConnectorTerminationInput"}
	if s.Termination == nil {
		invalidParams.Add(request.NewErrParamRequired("Termination"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}
	if s.Termination != nil {
		if err := s.Termination.Validate(); err != nil {
			invalidParams.AddNested("Termination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTermination sets the Termination field's value.
func (s *PutVoiceConnectorTerminationInput) SetTermination(v *Termination) *PutVoiceConnectorTerminationInput {
	s.Termination = v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *PutVoiceConnectorTerminationInput) SetVoiceConnectorId(v string) *PutVoiceConnectorTerminationInput {
	s.VoiceConnectorId = &v
	return s
}

type PutVoiceConnectorTerminationOutput struct {
	_ struct{} `type:"structure"`

	// The updated termination setting details.
	Termination *Termination `type:"structure"`
}

// String returns the string representation
func (s PutVoiceConnectorTerminationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutVoiceConnectorTerminationOutput) GoString() string {
	return s.String()
}

// SetTermination sets the Termination field's value.
func (s *PutVoiceConnectorTerminationOutput) SetTermination(v *Termination) *PutVoiceConnectorTerminationOutput {
	s.Termination = v
	return s
}

type RegenerateSecurityTokenInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`
}

// String returns the string representation
func (s RegenerateSecurityTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegenerateSecurityTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegenerateSecurityTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegenerateSecurityTokenInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *RegenerateSecurityTokenInput) SetAccountId(v string) *RegenerateSecurityTokenInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *RegenerateSecurityTokenInput) SetBotId(v string) *RegenerateSecurityTokenInput {
	s.BotId = &v
	return s
}

type RegenerateSecurityTokenOutput struct {
	_ struct{} `type:"structure"`

	// A resource that allows Enterprise account administrators to configure an
	// interface to receive events from Amazon Chime.
	Bot *Bot `type:"structure"`
}

// String returns the string representation
func (s RegenerateSecurityTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegenerateSecurityTokenOutput) GoString() string {
	return s.String()
}

// SetBot sets the Bot field's value.
func (s *RegenerateSecurityTokenOutput) SetBot(v *Bot) *RegenerateSecurityTokenOutput {
	s.Bot = v
	return s
}

type ResetPersonalPINInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s ResetPersonalPINInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPersonalPINInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetPersonalPINInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetPersonalPINInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ResetPersonalPINInput) SetAccountId(v string) *ResetPersonalPINInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ResetPersonalPINInput) SetUserId(v string) *ResetPersonalPINInput {
	s.UserId = &v
	return s
}

type ResetPersonalPINOutput struct {
	_ struct{} `type:"structure"`

	// The user details and new personal meeting PIN.
	User *User `type:"structure"`
}

// String returns the string representation
func (s ResetPersonalPINOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetPersonalPINOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *ResetPersonalPINOutput) SetUser(v *User) *ResetPersonalPINOutput {
	s.User = v
	return s
}

// The request exceeds the resource limit.
type ResourceLimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceLimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceLimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type RestorePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The phone number.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true"`
}

// String returns the string representation
func (s RestorePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestorePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestorePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestorePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *RestorePhoneNumberInput) SetPhoneNumberId(v string) *RestorePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

type RestorePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The phone number details.
	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation
func (s RestorePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestorePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *RestorePhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *RestorePhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

// The Amazon Chime chat room details.
type Room struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The identifier of the room creator.
	CreatedBy *string `type:"string"`

	// The room creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The room name.
	Name *string `type:"string" sensitive:"true"`

	// The room ID.
	RoomId *string `type:"string"`

	// The room update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Room) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Room) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Room) SetAccountId(v string) *Room {
	s.AccountId = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Room) SetCreatedBy(v string) *Room {
	s.CreatedBy = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *Room) SetCreatedTimestamp(v time.Time) *Room {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *Room) SetName(v string) *Room {
	s.Name = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *Room) SetRoomId(v string) *Room {
	s.RoomId = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *Room) SetUpdatedTimestamp(v time.Time) *Room {
	s.UpdatedTimestamp = &v
	return s
}

// The room membership details.
type RoomMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the user that invited the room member.
	InvitedBy *string `type:"string"`

	// The member details, such as email address, name, member ID, and member type.
	Member *Member `type:"structure"`

	// The membership role.
	Role *string `type:"string" enum:"RoomMembershipRole"`

	// The room ID.
	RoomId *string `type:"string"`

	// The room membership update timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s RoomMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoomMembership) GoString() string {
	return s.String()
}

// SetInvitedBy sets the InvitedBy field's value.
func (s *RoomMembership) SetInvitedBy(v string) *RoomMembership {
	s.InvitedBy = &v
	return s
}

// SetMember sets the Member field's value.
func (s *RoomMembership) SetMember(v *Member) *RoomMembership {
	s.Member = v
	return s
}

// SetRole sets the Role field's value.
func (s *RoomMembership) SetRole(v string) *RoomMembership {
	s.Role = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *RoomMembership) SetRoomId(v string) *RoomMembership {
	s.RoomId = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *RoomMembership) SetUpdatedTimestamp(v time.Time) *RoomMembership {
	s.UpdatedTimestamp = &v
	return s
}

type SearchAvailablePhoneNumbersInput struct {
	_ struct{} `type:"structure"`

	// The area code used to filter results.
	AreaCode *string `location:"querystring" locationName:"area-code" type:"string"`

	// The city used to filter results.
	City *string `location:"querystring" locationName:"city" type:"string"`

	// The country used to filter results.
	Country *string `location:"querystring" locationName:"country" type:"string"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`

	// The state used to filter results.
	State *string `location:"querystring" locationName:"state" type:"string"`

	// The toll-free prefix that you use to filter results.
	TollFreePrefix *string `location:"querystring" locationName:"toll-free-prefix" min:"3" type:"string"`
}

// String returns the string representation
func (s SearchAvailablePhoneNumbersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchAvailablePhoneNumbersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchAvailablePhoneNumbersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchAvailablePhoneNumbersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TollFreePrefix != nil && len(*s.TollFreePrefix) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TollFreePrefix", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAreaCode sets the AreaCode field's value.
func (s *SearchAvailablePhoneNumbersInput) SetAreaCode(v string) *SearchAvailablePhoneNumbersInput {
	s.AreaCode = &v
	return s
}

// SetCity sets the City field's value.
func (s *SearchAvailablePhoneNumbersInput) SetCity(v string) *SearchAvailablePhoneNumbersInput {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *SearchAvailablePhoneNumbersInput) SetCountry(v string) *SearchAvailablePhoneNumbersInput {
	s.Country = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchAvailablePhoneNumbersInput) SetMaxResults(v int64) *SearchAvailablePhoneNumbersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchAvailablePhoneNumbersInput) SetNextToken(v string) *SearchAvailablePhoneNumbersInput {
	s.NextToken = &v
	return s
}

// SetState sets the State field's value.
func (s *SearchAvailablePhoneNumbersInput) SetState(v string) *SearchAvailablePhoneNumbersInput {
	s.State = &v
	return s
}

// SetTollFreePrefix sets the TollFreePrefix field's value.
func (s *SearchAvailablePhoneNumbersInput) SetTollFreePrefix(v string) *SearchAvailablePhoneNumbersInput {
	s.TollFreePrefix = &v
	return s
}

type SearchAvailablePhoneNumbersOutput struct {
	_ struct{} `type:"structure"`

	// List of phone numbers, in E.164 format.
	E164PhoneNumbers []*string `type:"list"`
}

// String returns the string representation
func (s SearchAvailablePhoneNumbersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchAvailablePhoneNumbersOutput) GoString() string {
	return s.String()
}

// SetE164PhoneNumbers sets the E164PhoneNumbers field's value.
func (s *SearchAvailablePhoneNumbersOutput) SetE164PhoneNumbers(v []*string) *SearchAvailablePhoneNumbersOutput {
	s.E164PhoneNumbers = v
	return s
}

// The service encountered an unexpected error.
type ServiceFailureException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceFailureException) GoString() string {
	return s.String()
}

func newErrorServiceFailureException(v protocol.ResponseMetadata) error {
	return &ServiceFailureException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceFailureException) Code() string {
	return "ServiceFailureException"
}

// Message returns the exception's message.
func (s ServiceFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceFailureException) OrigErr() error {
	return nil
}

func (s ServiceFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceFailureException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceFailureException) RequestID() string {
	return s.respMetadata.RequestID
}

// The service is currently unavailable.
type ServiceUnavailableException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceUnavailableException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceUnavailableException) RequestID() string {
	return s.respMetadata.RequestID
}

// An Active Directory (AD) group whose members are granted permission to act
// as delegates.
type SigninDelegateGroup struct {
	_ struct{} `type:"structure"`

	// The group name.
	GroupName *string `type:"string"`
}

// String returns the string representation
func (s SigninDelegateGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigninDelegateGroup) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *SigninDelegateGroup) SetGroupName(v string) *SigninDelegateGroup {
	s.GroupName = &v
	return s
}

// The streaming configuration associated with an Amazon Chime Voice Connector.
// Specifies whether media streaming is enabled for sending to Amazon Kinesis,
// and shows the retention period for the Amazon Kinesis data, in hours.
type StreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// The retention period, in hours, for the Amazon Kinesis data.
	//
	// DataRetentionInHours is a required field
	DataRetentionInHours *int64 `type:"integer" required:"true"`

	// When true, media streaming to Amazon Kinesis is turned off.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s StreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StreamingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StreamingConfiguration"}
	if s.DataRetentionInHours == nil {
		invalidParams.Add(request.NewErrParamRequired("DataRetentionInHours"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataRetentionInHours sets the DataRetentionInHours field's value.
func (s *StreamingConfiguration) SetDataRetentionInHours(v int64) *StreamingConfiguration {
	s.DataRetentionInHours = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *StreamingConfiguration) SetDisabled(v bool) *StreamingConfiguration {
	s.Disabled = &v
	return s
}

// Settings that allow management of telephony permissions for an Amazon Chime
// user, such as inbound and outbound calling and text messaging.
type TelephonySettings struct {
	_ struct{} `type:"structure"`

	// Allows or denies inbound calling.
	//
	// InboundCalling is a required field
	InboundCalling *bool `type:"boolean" required:"true"`

	// Allows or denies outbound calling.
	//
	// OutboundCalling is a required field
	OutboundCalling *bool `type:"boolean" required:"true"`

	// Allows or denies SMS messaging.
	//
	// SMS is a required field
	SMS *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TelephonySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TelephonySettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TelephonySettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TelephonySettings"}
	if s.InboundCalling == nil {
		invalidParams.Add(request.NewErrParamRequired("InboundCalling"))
	}
	if s.OutboundCalling == nil {
		invalidParams.Add(request.NewErrParamRequired("OutboundCalling"))
	}
	if s.SMS == nil {
		invalidParams.Add(request.NewErrParamRequired("SMS"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInboundCalling sets the InboundCalling field's value.
func (s *TelephonySettings) SetInboundCalling(v bool) *TelephonySettings {
	s.InboundCalling = &v
	return s
}

// SetOutboundCalling sets the OutboundCalling field's value.
func (s *TelephonySettings) SetOutboundCalling(v bool) *TelephonySettings {
	s.OutboundCalling = &v
	return s
}

// SetSMS sets the SMS field's value.
func (s *TelephonySettings) SetSMS(v bool) *TelephonySettings {
	s.SMS = &v
	return s
}

// Termination settings enable your SIP hosts to make outbound calls using your
// Amazon Chime Voice Connector.
type Termination struct {
	_ struct{} `type:"structure"`

	// The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
	CallingRegions []*string `type:"list"`

	// The IP addresses allowed to make calls, in CIDR format. Required.
	CidrAllowedList []*string `type:"list"`

	// The limit on calls per second. Max value based on account service quota.
	// Default value of 1.
	CpsLimit *int64 `min:"1" type:"integer"`

	// The default caller ID phone number.
	DefaultPhoneNumber *string `type:"string" sensitive:"true"`

	// When termination settings are disabled, outbound calls can not be made.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s Termination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Termination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Termination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Termination"}
	if s.CpsLimit != nil && *s.CpsLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CpsLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingRegions sets the CallingRegions field's value.
func (s *Termination) SetCallingRegions(v []*string) *Termination {
	s.CallingRegions = v
	return s
}

// SetCidrAllowedList sets the CidrAllowedList field's value.
func (s *Termination) SetCidrAllowedList(v []*string) *Termination {
	s.CidrAllowedList = v
	return s
}

// SetCpsLimit sets the CpsLimit field's value.
func (s *Termination) SetCpsLimit(v int64) *Termination {
	s.CpsLimit = &v
	return s
}

// SetDefaultPhoneNumber sets the DefaultPhoneNumber field's value.
func (s *Termination) SetDefaultPhoneNumber(v string) *Termination {
	s.DefaultPhoneNumber = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *Termination) SetDisabled(v bool) *Termination {
	s.Disabled = &v
	return s
}

// The termination health details, including the source IP address and timestamp
// of the last successful SIP OPTIONS message from your SIP infrastructure.
type TerminationHealth struct {
	_ struct{} `type:"structure"`

	// The source IP address.
	Source *string `type:"string"`

	// The timestamp, in ISO 8601 format.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s TerminationHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminationHealth) GoString() string {
	return s.String()
}

// SetSource sets the Source field's value.
func (s *TerminationHealth) SetSource(v string) *TerminationHealth {
	s.Source = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *TerminationHealth) SetTimestamp(v time.Time) *TerminationHealth {
	s.Timestamp = &v
	return s
}

// The client exceeded its request rate limit.
type ThrottledClientException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottledClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottledClientException) GoString() string {
	return s.String()
}

func newErrorThrottledClientException(v protocol.ResponseMetadata) error {
	return &ThrottledClientException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ThrottledClientException) Code() string {
	return "ThrottledClientException"
}

// Message returns the exception's message.
func (s ThrottledClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ThrottledClientException) OrigErr() error {
	return nil
}

func (s ThrottledClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ThrottledClientException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ThrottledClientException) RequestID() string {
	return s.respMetadata.RequestID
}

// The client is not currently authorized to make the request.
type UnauthorizedClientException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnauthorizedClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnauthorizedClientException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedClientException(v protocol.ResponseMetadata) error {
	return &UnauthorizedClientException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UnauthorizedClientException) Code() string {
	return "UnauthorizedClientException"
}

// Message returns the exception's message.
func (s UnauthorizedClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UnauthorizedClientException) OrigErr() error {
	return nil
}

func (s UnauthorizedClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s UnauthorizedClientException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UnauthorizedClientException) RequestID() string {
	return s.respMetadata.RequestID
}

// The request was well-formed but was unable to be followed due to semantic
// errors.
type UnprocessableEntityException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Code_ *string `locationName:"Code" type:"string" enum:"ErrorCode"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s UnprocessableEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnprocessableEntityException) GoString() string {
	return s.String()
}

func newErrorUnprocessableEntityException(v protocol.ResponseMetadata) error {
	return &UnprocessableEntityException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s UnprocessableEntityException) Code() string {
	return "UnprocessableEntityException"
}

// Message returns the exception's message.
func (s UnprocessableEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s UnprocessableEntityException) OrigErr() error {
	return nil
}

func (s UnprocessableEntityException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s UnprocessableEntityException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s UnprocessableEntityException) RequestID() string {
	return s.respMetadata.RequestID
}

type UpdateAccountInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The new name for the specified Amazon Chime account.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateAccountInput) SetAccountId(v string) *UpdateAccountInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAccountInput) SetName(v string) *UpdateAccountInput {
	s.Name = &v
	return s
}

type UpdateAccountOutput struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Chime account details.
	Account *Account `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountOutput) GoString() string {
	return s.String()
}

// SetAccount sets the Account field's value.
func (s *UpdateAccountOutput) SetAccount(v *Account) *UpdateAccountOutput {
	s.Account = v
	return s
}

type UpdateAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The Amazon Chime account settings to update.
	//
	// AccountSettings is a required field
	AccountSettings *AccountSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.AccountSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountSettings"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateAccountSettingsInput) SetAccountId(v string) *UpdateAccountSettingsInput {
	s.AccountId = &v
	return s
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *UpdateAccountSettingsInput) SetAccountSettings(v *AccountSettings) *UpdateAccountSettingsInput {
	s.AccountSettings = v
	return s
}

type UpdateAccountSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountSettingsOutput) GoString() string {
	return s.String()
}

type UpdateBotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The bot ID.
	//
	// BotId is a required field
	BotId *string `location:"uri" locationName:"botId" type:"string" required:"true"`

	// When true, stops the specified bot from running in your account.
	Disabled *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBotInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.BotId == nil {
		invalidParams.Add(request.NewErrParamRequired("BotId"))
	}
	if s.BotId != nil && len(*s.BotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BotId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateBotInput) SetAccountId(v string) *UpdateBotInput {
	s.AccountId = &v
	return s
}

// SetBotId sets the BotId field's value.
func (s *UpdateBotInput) SetBotId(v string) *UpdateBotInput {
	s.BotId = &v
	return s
}

// SetDisabled sets the Disabled field's value.
func (s *UpdateBotInput) SetDisabled(v bool) *UpdateBotInput {
	s.Disabled = &v
	return s
}

type UpdateBotOutput struct {
	_ struct{} `type:"structure"`

	// The updated bot details.
	Bot *Bot `type:"structure"`
}

// String returns the string representation
func (s UpdateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBotOutput) GoString() string {
	return s.String()
}

// SetBot sets the Bot field's value.
func (s *UpdateBotOutput) SetBot(v *Bot) *UpdateBotOutput {
	s.Bot = v
	return s
}

type UpdateGlobalSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Business Calling settings.
	//
	// BusinessCalling is a required field
	BusinessCalling *BusinessCallingSettings `type:"structure" required:"true"`

	// The Amazon Chime Voice Connector settings.
	//
	// VoiceConnector is a required field
	VoiceConnector *VoiceConnectorSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalSettingsInput"}
	if s.BusinessCalling == nil {
		invalidParams.Add(request.NewErrParamRequired("BusinessCalling"))
	}
	if s.VoiceConnector == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnector"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBusinessCalling sets the BusinessCalling field's value.
func (s *UpdateGlobalSettingsInput) SetBusinessCalling(v *BusinessCallingSettings) *UpdateGlobalSettingsInput {
	s.BusinessCalling = v
	return s
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *UpdateGlobalSettingsInput) SetVoiceConnector(v *VoiceConnectorSettings) *UpdateGlobalSettingsInput {
	s.VoiceConnector = v
	return s
}

type UpdateGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalSettingsOutput) GoString() string {
	return s.String()
}

type UpdatePhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// The outbound calling name associated with the phone number.
	CallingName *string `type:"string" sensitive:"true"`

	// The phone number ID.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"phoneNumberId" type:"string" required:"true"`

	// The product type.
	ProductType *string `type:"string" enum:"PhoneNumberProductType"`
}

// String returns the string representation
func (s UpdatePhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberInput"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberInput) SetCallingName(v string) *UpdatePhoneNumberInput {
	s.CallingName = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberInput) SetPhoneNumberId(v string) *UpdatePhoneNumberInput {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *UpdatePhoneNumberInput) SetProductType(v string) *UpdatePhoneNumberInput {
	s.ProductType = &v
	return s
}

type UpdatePhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The updated phone number details.
	PhoneNumber *PhoneNumber `type:"structure"`
}

// String returns the string representation
func (s UpdatePhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdatePhoneNumberOutput) SetPhoneNumber(v *PhoneNumber) *UpdatePhoneNumberOutput {
	s.PhoneNumber = v
	return s
}

// The phone number ID, product type, or calling name fields to update, used
// with the BatchUpdatePhoneNumber and UpdatePhoneNumber actions.
type UpdatePhoneNumberRequestItem struct {
	_ struct{} `type:"structure"`

	// The outbound calling name to update.
	CallingName *string `type:"string" sensitive:"true"`

	// The phone number ID to update.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `type:"string" required:"true"`

	// The product type to update.
	ProductType *string `type:"string" enum:"PhoneNumberProductType"`
}

// String returns the string representation
func (s UpdatePhoneNumberRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePhoneNumberRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberRequestItem"}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberRequestItem) SetCallingName(v string) *UpdatePhoneNumberRequestItem {
	s.CallingName = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *UpdatePhoneNumberRequestItem) SetPhoneNumberId(v string) *UpdatePhoneNumberRequestItem {
	s.PhoneNumberId = &v
	return s
}

// SetProductType sets the ProductType field's value.
func (s *UpdatePhoneNumberRequestItem) SetProductType(v string) *UpdatePhoneNumberRequestItem {
	s.ProductType = &v
	return s
}

type UpdatePhoneNumberSettingsInput struct {
	_ struct{} `type:"structure"`

	// The default outbound calling name for the account.
	//
	// CallingName is a required field
	CallingName *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s UpdatePhoneNumberSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePhoneNumberSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePhoneNumberSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePhoneNumberSettingsInput"}
	if s.CallingName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallingName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallingName sets the CallingName field's value.
func (s *UpdatePhoneNumberSettingsInput) SetCallingName(v string) *UpdatePhoneNumberSettingsInput {
	s.CallingName = &v
	return s
}

type UpdatePhoneNumberSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdatePhoneNumberSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePhoneNumberSettingsOutput) GoString() string {
	return s.String()
}

type UpdateRoomInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The room name.
	Name *string `type:"string" sensitive:"true"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRoomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoomInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateRoomInput) SetAccountId(v string) *UpdateRoomInput {
	s.AccountId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRoomInput) SetName(v string) *UpdateRoomInput {
	s.Name = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *UpdateRoomInput) SetRoomId(v string) *UpdateRoomInput {
	s.RoomId = &v
	return s
}

type UpdateRoomMembershipInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The member ID.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" type:"string" required:"true"`

	// The role of the member.
	Role *string `type:"string" enum:"RoomMembershipRole"`

	// The room ID.
	//
	// RoomId is a required field
	RoomId *string `location:"uri" locationName:"roomId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRoomMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRoomMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRoomMembershipInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.MemberId == nil {
		invalidParams.Add(request.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MemberId", 1))
	}
	if s.RoomId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoomId"))
	}
	if s.RoomId != nil && len(*s.RoomId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoomId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateRoomMembershipInput) SetAccountId(v string) *UpdateRoomMembershipInput {
	s.AccountId = &v
	return s
}

// SetMemberId sets the MemberId field's value.
func (s *UpdateRoomMembershipInput) SetMemberId(v string) *UpdateRoomMembershipInput {
	s.MemberId = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateRoomMembershipInput) SetRole(v string) *UpdateRoomMembershipInput {
	s.Role = &v
	return s
}

// SetRoomId sets the RoomId field's value.
func (s *UpdateRoomMembershipInput) SetRoomId(v string) *UpdateRoomMembershipInput {
	s.RoomId = &v
	return s
}

type UpdateRoomMembershipOutput struct {
	_ struct{} `type:"structure"`

	// The room membership details.
	RoomMembership *RoomMembership `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomMembershipOutput) GoString() string {
	return s.String()
}

// SetRoomMembership sets the RoomMembership field's value.
func (s *UpdateRoomMembershipOutput) SetRoomMembership(v *RoomMembership) *UpdateRoomMembershipOutput {
	s.RoomMembership = v
	return s
}

type UpdateRoomOutput struct {
	_ struct{} `type:"structure"`

	// The room details.
	Room *Room `type:"structure"`
}

// String returns the string representation
func (s UpdateRoomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRoomOutput) GoString() string {
	return s.String()
}

// SetRoom sets the Room field's value.
func (s *UpdateRoomOutput) SetRoom(v *Room) *UpdateRoomOutput {
	s.Room = v
	return s
}

type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata `type:"structure"`

	// The user license type to update. This must be a supported license type for
	// the Amazon Chime account that the user belongs to.
	LicenseType *string `type:"string" enum:"License"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`

	// The user type.
	UserType *string `type:"string" enum:"UserType"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateUserInput) SetAccountId(v string) *UpdateUserInput {
	s.AccountId = &v
	return s
}

// SetAlexaForBusinessMetadata sets the AlexaForBusinessMetadata field's value.
func (s *UpdateUserInput) SetAlexaForBusinessMetadata(v *AlexaForBusinessMetadata) *UpdateUserInput {
	s.AlexaForBusinessMetadata = v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateUserInput) SetLicenseType(v string) *UpdateUserInput {
	s.LicenseType = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserInput) SetUserId(v string) *UpdateUserInput {
	s.UserId = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *UpdateUserInput) SetUserType(v string) *UpdateUserInput {
	s.UserType = &v
	return s
}

type UpdateUserOutput struct {
	_ struct{} `type:"structure"`

	// The updated user details.
	User *User `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *UpdateUserOutput) SetUser(v *User) *UpdateUserOutput {
	s.User = v
	return s
}

// The user ID and user fields to update, used with the BatchUpdateUser action.
type UpdateUserRequestItem struct {
	_ struct{} `type:"structure"`

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata `type:"structure"`

	// The user license type.
	LicenseType *string `type:"string" enum:"License"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`

	// The user type.
	UserType *string `type:"string" enum:"UserType"`
}

// String returns the string representation
func (s UpdateUserRequestItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserRequestItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserRequestItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserRequestItem"}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlexaForBusinessMetadata sets the AlexaForBusinessMetadata field's value.
func (s *UpdateUserRequestItem) SetAlexaForBusinessMetadata(v *AlexaForBusinessMetadata) *UpdateUserRequestItem {
	s.AlexaForBusinessMetadata = v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *UpdateUserRequestItem) SetLicenseType(v string) *UpdateUserRequestItem {
	s.LicenseType = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserRequestItem) SetUserId(v string) *UpdateUserRequestItem {
	s.UserId = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *UpdateUserRequestItem) SetUserType(v string) *UpdateUserRequestItem {
	s.UserType = &v
	return s
}

type UpdateUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`

	// The user settings to update.
	//
	// UserSettings is a required field
	UserSettings *UserSettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserSettingsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 1))
	}
	if s.UserId == nil {
		invalidParams.Add(request.NewErrParamRequired("UserId"))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserId", 1))
	}
	if s.UserSettings == nil {
		invalidParams.Add(request.NewErrParamRequired("UserSettings"))
	}
	if s.UserSettings != nil {
		if err := s.UserSettings.Validate(); err != nil {
			invalidParams.AddNested("UserSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *UpdateUserSettingsInput) SetAccountId(v string) *UpdateUserSettingsInput {
	s.AccountId = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UpdateUserSettingsInput) SetUserId(v string) *UpdateUserSettingsInput {
	s.UserId = &v
	return s
}

// SetUserSettings sets the UserSettings field's value.
func (s *UpdateUserSettingsInput) SetUserSettings(v *UserSettings) *UpdateUserSettingsInput {
	s.UserSettings = v
	return s
}

type UpdateUserSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserSettingsOutput) GoString() string {
	return s.String()
}

type UpdateVoiceConnectorGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime Voice Connector group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Amazon Chime Voice Connector group ID.
	//
	// VoiceConnectorGroupId is a required field
	VoiceConnectorGroupId *string `location:"uri" locationName:"voiceConnectorGroupId" type:"string" required:"true"`

	// The VoiceConnectorItems to associate with the group.
	//
	// VoiceConnectorItems is a required field
	VoiceConnectorItems []*VoiceConnectorItem `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateVoiceConnectorGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceConnectorGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceConnectorGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVoiceConnectorGroupInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.VoiceConnectorGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorGroupId"))
	}
	if s.VoiceConnectorGroupId != nil && len(*s.VoiceConnectorGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorGroupId", 1))
	}
	if s.VoiceConnectorItems == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorItems"))
	}
	if s.VoiceConnectorItems != nil {
		for i, v := range s.VoiceConnectorItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VoiceConnectorItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateVoiceConnectorGroupInput) SetName(v string) *UpdateVoiceConnectorGroupInput {
	s.Name = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *UpdateVoiceConnectorGroupInput) SetVoiceConnectorGroupId(v string) *UpdateVoiceConnectorGroupInput {
	s.VoiceConnectorGroupId = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *UpdateVoiceConnectorGroupInput) SetVoiceConnectorItems(v []*VoiceConnectorItem) *UpdateVoiceConnectorGroupInput {
	s.VoiceConnectorItems = v
	return s
}

type UpdateVoiceConnectorGroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Chime Voice Connector group details.
	VoiceConnectorGroup *VoiceConnectorGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateVoiceConnectorGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceConnectorGroupOutput) GoString() string {
	return s.String()
}

// SetVoiceConnectorGroup sets the VoiceConnectorGroup field's value.
func (s *UpdateVoiceConnectorGroupOutput) SetVoiceConnectorGroup(v *VoiceConnectorGroup) *UpdateVoiceConnectorGroupOutput {
	s.VoiceConnectorGroup = v
	return s
}

type UpdateVoiceConnectorInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Chime Voice Connector.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// When enabled, requires encryption for the Amazon Chime Voice Connector.
	//
	// RequireEncryption is a required field
	RequireEncryption *bool `type:"boolean" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVoiceConnectorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceConnectorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVoiceConnectorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVoiceConnectorInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RequireEncryption == nil {
		invalidParams.Add(request.NewErrParamRequired("RequireEncryption"))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}
	if s.VoiceConnectorId != nil && len(*s.VoiceConnectorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VoiceConnectorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateVoiceConnectorInput) SetName(v string) *UpdateVoiceConnectorInput {
	s.Name = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *UpdateVoiceConnectorInput) SetRequireEncryption(v bool) *UpdateVoiceConnectorInput {
	s.RequireEncryption = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *UpdateVoiceConnectorInput) SetVoiceConnectorId(v string) *UpdateVoiceConnectorInput {
	s.VoiceConnectorId = &v
	return s
}

type UpdateVoiceConnectorOutput struct {
	_ struct{} `type:"structure"`

	// The updated Amazon Chime Voice Connector details.
	VoiceConnector *VoiceConnector `type:"structure"`
}

// String returns the string representation
func (s UpdateVoiceConnectorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVoiceConnectorOutput) GoString() string {
	return s.String()
}

// SetVoiceConnector sets the VoiceConnector field's value.
func (s *UpdateVoiceConnectorOutput) SetVoiceConnector(v *VoiceConnector) *UpdateVoiceConnectorOutput {
	s.VoiceConnector = v
	return s
}

// The user on the Amazon Chime account.
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	AccountId *string `type:"string"`

	// The Alexa for Business metadata.
	AlexaForBusinessMetadata *AlexaForBusinessMetadata `type:"structure"`

	// The display name of the user.
	DisplayName *string `type:"string" sensitive:"true"`

	// Date and time when the user is invited to the Amazon Chime account, in ISO
	// 8601 format.
	InvitedOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The license type for the user.
	LicenseType *string `type:"string" enum:"License"`

	// The user's personal meeting PIN.
	PersonalPIN *string `type:"string"`

	// The primary email address of the user.
	PrimaryEmail *string `type:"string" sensitive:"true"`

	// The primary phone number associated with the user.
	PrimaryProvisionedNumber *string `type:"string" sensitive:"true"`

	// Date and time when the user is registered, in ISO 8601 format.
	RegisteredOn *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `type:"string" required:"true"`

	// The user invite status.
	UserInvitationStatus *string `type:"string" enum:"InviteStatus"`

	// The user registration status.
	UserRegistrationStatus *string `type:"string" enum:"RegistrationStatus"`

	// The user type.
	UserType *string `type:"string" enum:"UserType"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *User) SetAccountId(v string) *User {
	s.AccountId = &v
	return s
}

// SetAlexaForBusinessMetadata sets the AlexaForBusinessMetadata field's value.
func (s *User) SetAlexaForBusinessMetadata(v *AlexaForBusinessMetadata) *User {
	s.AlexaForBusinessMetadata = v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *User) SetDisplayName(v string) *User {
	s.DisplayName = &v
	return s
}

// SetInvitedOn sets the InvitedOn field's value.
func (s *User) SetInvitedOn(v time.Time) *User {
	s.InvitedOn = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *User) SetLicenseType(v string) *User {
	s.LicenseType = &v
	return s
}

// SetPersonalPIN sets the PersonalPIN field's value.
func (s *User) SetPersonalPIN(v string) *User {
	s.PersonalPIN = &v
	return s
}

// SetPrimaryEmail sets the PrimaryEmail field's value.
func (s *User) SetPrimaryEmail(v string) *User {
	s.PrimaryEmail = &v
	return s
}

// SetPrimaryProvisionedNumber sets the PrimaryProvisionedNumber field's value.
func (s *User) SetPrimaryProvisionedNumber(v string) *User {
	s.PrimaryProvisionedNumber = &v
	return s
}

// SetRegisteredOn sets the RegisteredOn field's value.
func (s *User) SetRegisteredOn(v time.Time) *User {
	s.RegisteredOn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *User) SetUserId(v string) *User {
	s.UserId = &v
	return s
}

// SetUserInvitationStatus sets the UserInvitationStatus field's value.
func (s *User) SetUserInvitationStatus(v string) *User {
	s.UserInvitationStatus = &v
	return s
}

// SetUserRegistrationStatus sets the UserRegistrationStatus field's value.
func (s *User) SetUserRegistrationStatus(v string) *User {
	s.UserRegistrationStatus = &v
	return s
}

// SetUserType sets the UserType field's value.
func (s *User) SetUserType(v string) *User {
	s.UserType = &v
	return s
}

// The list of errors returned when errors are encountered during the BatchSuspendUser,
// BatchUnsuspendUser, or BatchUpdateUser actions. This includes user IDs, error
// codes, and error messages.
type UserError struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string" enum:"ErrorCode"`

	// The error message.
	ErrorMessage *string `type:"string"`

	// The user ID for which the action failed.
	UserId *string `type:"string"`
}

// String returns the string representation
func (s UserError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *UserError) SetErrorCode(v string) *UserError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *UserError) SetErrorMessage(v string) *UserError {
	s.ErrorMessage = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserError) SetUserId(v string) *UserError {
	s.UserId = &v
	return s
}

// Settings associated with an Amazon Chime user, including inbound and outbound
// calling and text messaging.
type UserSettings struct {
	_ struct{} `type:"structure"`

	// The telephony settings associated with the user.
	//
	// Telephony is a required field
	Telephony *TelephonySettings `type:"structure" required:"true"`
}

// String returns the string representation
func (s UserSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserSettings"}
	if s.Telephony == nil {
		invalidParams.Add(request.NewErrParamRequired("Telephony"))
	}
	if s.Telephony != nil {
		if err := s.Telephony.Validate(); err != nil {
			invalidParams.AddNested("Telephony", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTelephony sets the Telephony field's value.
func (s *UserSettings) SetTelephony(v *TelephonySettings) *UserSettings {
	s.Telephony = v
	return s
}

// The Amazon Chime Voice Connector configuration, including outbound host name
// and encryption settings.
type VoiceConnector struct {
	_ struct{} `type:"structure"`

	// The AWS Region in which the Amazon Chime Voice Connector is created. Default:
	// us-east-1.
	AwsRegion *string `type:"string" enum:"VoiceConnectorAwsRegion"`

	// The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the Amazon Chime Voice Connector.
	Name *string `min:"1" type:"string"`

	// The outbound host name for the Amazon Chime Voice Connector.
	OutboundHostName *string `type:"string"`

	// Designates whether encryption is required for the Amazon Chime Voice Connector.
	RequireEncryption *bool `type:"boolean"`

	// The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Chime Voice Connector ID.
	VoiceConnectorId *string `type:"string"`
}

// String returns the string representation
func (s VoiceConnector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceConnector) GoString() string {
	return s.String()
}

// SetAwsRegion sets the AwsRegion field's value.
func (s *VoiceConnector) SetAwsRegion(v string) *VoiceConnector {
	s.AwsRegion = &v
	return s
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *VoiceConnector) SetCreatedTimestamp(v time.Time) *VoiceConnector {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *VoiceConnector) SetName(v string) *VoiceConnector {
	s.Name = &v
	return s
}

// SetOutboundHostName sets the OutboundHostName field's value.
func (s *VoiceConnector) SetOutboundHostName(v string) *VoiceConnector {
	s.OutboundHostName = &v
	return s
}

// SetRequireEncryption sets the RequireEncryption field's value.
func (s *VoiceConnector) SetRequireEncryption(v bool) *VoiceConnector {
	s.RequireEncryption = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *VoiceConnector) SetUpdatedTimestamp(v time.Time) *VoiceConnector {
	s.UpdatedTimestamp = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *VoiceConnector) SetVoiceConnectorId(v string) *VoiceConnector {
	s.VoiceConnectorId = &v
	return s
}

// The Amazon Chime Voice Connector group configuration, including associated
// Amazon Chime Voice Connectors. You can include Amazon Chime Voice Connectors
// from different AWS Regions in your group. This creates a fault tolerant mechanism
// for fallback in case of availability events.
type VoiceConnectorGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector group creation timestamp, in ISO 8601 format.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the Amazon Chime Voice Connector group.
	Name *string `min:"1" type:"string"`

	// The updated Amazon Chime Voice Connector group timestamp, in ISO 8601 format.
	UpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Chime Voice Connector group ID.
	VoiceConnectorGroupId *string `type:"string"`

	// The Amazon Chime Voice Connectors to which to route inbound calls.
	VoiceConnectorItems []*VoiceConnectorItem `type:"list"`
}

// String returns the string representation
func (s VoiceConnectorGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceConnectorGroup) GoString() string {
	return s.String()
}

// SetCreatedTimestamp sets the CreatedTimestamp field's value.
func (s *VoiceConnectorGroup) SetCreatedTimestamp(v time.Time) *VoiceConnectorGroup {
	s.CreatedTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *VoiceConnectorGroup) SetName(v string) *VoiceConnectorGroup {
	s.Name = &v
	return s
}

// SetUpdatedTimestamp sets the UpdatedTimestamp field's value.
func (s *VoiceConnectorGroup) SetUpdatedTimestamp(v time.Time) *VoiceConnectorGroup {
	s.UpdatedTimestamp = &v
	return s
}

// SetVoiceConnectorGroupId sets the VoiceConnectorGroupId field's value.
func (s *VoiceConnectorGroup) SetVoiceConnectorGroupId(v string) *VoiceConnectorGroup {
	s.VoiceConnectorGroupId = &v
	return s
}

// SetVoiceConnectorItems sets the VoiceConnectorItems field's value.
func (s *VoiceConnectorGroup) SetVoiceConnectorItems(v []*VoiceConnectorItem) *VoiceConnectorGroup {
	s.VoiceConnectorItems = v
	return s
}

// For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors
// to which to route inbound calls. Includes priority configuration settings.
// Limit: 3 VoiceConnectorItems per Amazon Chime Voice Connector group.
type VoiceConnectorItem struct {
	_ struct{} `type:"structure"`

	// The priority associated with the Amazon Chime Voice Connector, with 1 being
	// the highest priority. Higher priority Amazon Chime Voice Connectors are attempted
	// first.
	//
	// Priority is a required field
	Priority *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VoiceConnectorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceConnectorItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VoiceConnectorItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VoiceConnectorItem"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.Priority != nil && *s.Priority < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Priority", 1))
	}
	if s.VoiceConnectorId == nil {
		invalidParams.Add(request.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPriority sets the Priority field's value.
func (s *VoiceConnectorItem) SetPriority(v int64) *VoiceConnectorItem {
	s.Priority = &v
	return s
}

// SetVoiceConnectorId sets the VoiceConnectorId field's value.
func (s *VoiceConnectorItem) SetVoiceConnectorId(v string) *VoiceConnectorItem {
	s.VoiceConnectorId = &v
	return s
}

// The Amazon Chime Voice Connector settings. Includes any Amazon S3 buckets
// designated for storing call detail records.
type VoiceConnectorSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket designated for call detail record storage.
	CdrBucket *string `type:"string"`
}

// String returns the string representation
func (s VoiceConnectorSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VoiceConnectorSettings) GoString() string {
	return s.String()
}

// SetCdrBucket sets the CdrBucket field's value.
func (s *VoiceConnectorSettings) SetCdrBucket(v string) *VoiceConnectorSettings {
	s.CdrBucket = &v
	return s
}

const (
	// AccountTypeTeam is a AccountType enum value
	AccountTypeTeam = "Team"

	// AccountTypeEnterpriseDirectory is a AccountType enum value
	AccountTypeEnterpriseDirectory = "EnterpriseDirectory"

	// AccountTypeEnterpriseLwa is a AccountType enum value
	AccountTypeEnterpriseLwa = "EnterpriseLWA"

	// AccountTypeEnterpriseOidc is a AccountType enum value
	AccountTypeEnterpriseOidc = "EnterpriseOIDC"
)

const (
	// BotTypeChatBot is a BotType enum value
	BotTypeChatBot = "ChatBot"
)

const (
	// CallingNameStatusUnassigned is a CallingNameStatus enum value
	CallingNameStatusUnassigned = "Unassigned"

	// CallingNameStatusUpdateInProgress is a CallingNameStatus enum value
	CallingNameStatusUpdateInProgress = "UpdateInProgress"

	// CallingNameStatusUpdateSucceeded is a CallingNameStatus enum value
	CallingNameStatusUpdateSucceeded = "UpdateSucceeded"

	// CallingNameStatusUpdateFailed is a CallingNameStatus enum value
	CallingNameStatusUpdateFailed = "UpdateFailed"
)

const (
	// EmailStatusNotSent is a EmailStatus enum value
	EmailStatusNotSent = "NotSent"

	// EmailStatusSent is a EmailStatus enum value
	EmailStatusSent = "Sent"

	// EmailStatusFailed is a EmailStatus enum value
	EmailStatusFailed = "Failed"
)

const (
	// ErrorCodeBadRequest is a ErrorCode enum value
	ErrorCodeBadRequest = "BadRequest"

	// ErrorCodeConflict is a ErrorCode enum value
	ErrorCodeConflict = "Conflict"

	// ErrorCodeForbidden is a ErrorCode enum value
	ErrorCodeForbidden = "Forbidden"

	// ErrorCodeNotFound is a ErrorCode enum value
	ErrorCodeNotFound = "NotFound"

	// ErrorCodePreconditionFailed is a ErrorCode enum value
	ErrorCodePreconditionFailed = "PreconditionFailed"

	// ErrorCodeResourceLimitExceeded is a ErrorCode enum value
	ErrorCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ErrorCodeServiceFailure is a ErrorCode enum value
	ErrorCodeServiceFailure = "ServiceFailure"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeServiceUnavailable is a ErrorCode enum value
	ErrorCodeServiceUnavailable = "ServiceUnavailable"

	// ErrorCodeThrottled is a ErrorCode enum value
	ErrorCodeThrottled = "Throttled"

	// ErrorCodeUnauthorized is a ErrorCode enum value
	ErrorCodeUnauthorized = "Unauthorized"

	// ErrorCodeUnprocessable is a ErrorCode enum value
	ErrorCodeUnprocessable = "Unprocessable"

	// ErrorCodeVoiceConnectorGroupAssociationsExist is a ErrorCode enum value
	ErrorCodeVoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"

	// ErrorCodePhoneNumberAssociationsExist is a ErrorCode enum value
	ErrorCodePhoneNumberAssociationsExist = "PhoneNumberAssociationsExist"
)

const (
	// InviteStatusPending is a InviteStatus enum value
	InviteStatusPending = "Pending"

	// InviteStatusAccepted is a InviteStatus enum value
	InviteStatusAccepted = "Accepted"

	// InviteStatusFailed is a InviteStatus enum value
	InviteStatusFailed = "Failed"
)

const (
	// LicenseBasic is a License enum value
	LicenseBasic = "Basic"

	// LicensePlus is a License enum value
	LicensePlus = "Plus"

	// LicensePro is a License enum value
	LicensePro = "Pro"

	// LicenseProTrial is a License enum value
	LicenseProTrial = "ProTrial"
)

const (
	// MemberTypeUser is a MemberType enum value
	MemberTypeUser = "User"

	// MemberTypeBot is a MemberType enum value
	MemberTypeBot = "Bot"

	// MemberTypeWebhook is a MemberType enum value
	MemberTypeWebhook = "Webhook"
)

const (
	// OrderedPhoneNumberStatusProcessing is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusProcessing = "Processing"

	// OrderedPhoneNumberStatusAcquired is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusAcquired = "Acquired"

	// OrderedPhoneNumberStatusFailed is a OrderedPhoneNumberStatus enum value
	OrderedPhoneNumberStatusFailed = "Failed"
)

const (
	// OriginationRouteProtocolTcp is a OriginationRouteProtocol enum value
	OriginationRouteProtocolTcp = "TCP"

	// OriginationRouteProtocolUdp is a OriginationRouteProtocol enum value
	OriginationRouteProtocolUdp = "UDP"
)

const (
	// PhoneNumberAssociationNameAccountId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameAccountId = "AccountId"

	// PhoneNumberAssociationNameUserId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameUserId = "UserId"

	// PhoneNumberAssociationNameVoiceConnectorId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameVoiceConnectorId = "VoiceConnectorId"

	// PhoneNumberAssociationNameVoiceConnectorGroupId is a PhoneNumberAssociationName enum value
	PhoneNumberAssociationNameVoiceConnectorGroupId = "VoiceConnectorGroupId"
)

const (
	// PhoneNumberOrderStatusProcessing is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusProcessing = "Processing"

	// PhoneNumberOrderStatusSuccessful is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusSuccessful = "Successful"

	// PhoneNumberOrderStatusFailed is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusFailed = "Failed"

	// PhoneNumberOrderStatusPartial is a PhoneNumberOrderStatus enum value
	PhoneNumberOrderStatusPartial = "Partial"
)

const (
	// PhoneNumberProductTypeBusinessCalling is a PhoneNumberProductType enum value
	PhoneNumberProductTypeBusinessCalling = "BusinessCalling"

	// PhoneNumberProductTypeVoiceConnector is a PhoneNumberProductType enum value
	PhoneNumberProductTypeVoiceConnector = "VoiceConnector"
)

const (
	// PhoneNumberStatusAcquireInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusAcquireInProgress = "AcquireInProgress"

	// PhoneNumberStatusAcquireFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusAcquireFailed = "AcquireFailed"

	// PhoneNumberStatusUnassigned is a PhoneNumberStatus enum value
	PhoneNumberStatusUnassigned = "Unassigned"

	// PhoneNumberStatusAssigned is a PhoneNumberStatus enum value
	PhoneNumberStatusAssigned = "Assigned"

	// PhoneNumberStatusReleaseInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusReleaseInProgress = "ReleaseInProgress"

	// PhoneNumberStatusDeleteInProgress is a PhoneNumberStatus enum value
	PhoneNumberStatusDeleteInProgress = "DeleteInProgress"

	// PhoneNumberStatusReleaseFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusReleaseFailed = "ReleaseFailed"

	// PhoneNumberStatusDeleteFailed is a PhoneNumberStatus enum value
	PhoneNumberStatusDeleteFailed = "DeleteFailed"
)

const (
	// PhoneNumberTypeLocal is a PhoneNumberType enum value
	PhoneNumberTypeLocal = "Local"

	// PhoneNumberTypeTollFree is a PhoneNumberType enum value
	PhoneNumberTypeTollFree = "TollFree"
)

const (
	// RegistrationStatusUnregistered is a RegistrationStatus enum value
	RegistrationStatusUnregistered = "Unregistered"

	// RegistrationStatusRegistered is a RegistrationStatus enum value
	RegistrationStatusRegistered = "Registered"

	// RegistrationStatusSuspended is a RegistrationStatus enum value
	RegistrationStatusSuspended = "Suspended"
)

const (
	// RoomMembershipRoleAdministrator is a RoomMembershipRole enum value
	RoomMembershipRoleAdministrator = "Administrator"

	// RoomMembershipRoleMember is a RoomMembershipRole enum value
	RoomMembershipRoleMember = "Member"
)

const (
	// UserTypePrivateUser is a UserType enum value
	UserTypePrivateUser = "PrivateUser"

	// UserTypeSharedDevice is a UserType enum value
	UserTypeSharedDevice = "SharedDevice"
)

const (
	// VoiceConnectorAwsRegionUsEast1 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionUsEast1 = "us-east-1"

	// VoiceConnectorAwsRegionUsWest2 is a VoiceConnectorAwsRegion enum value
	VoiceConnectorAwsRegionUsWest2 = "us-west-2"
)
