// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package groundstation

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelContact = "CancelContact"

// CancelContactRequest generates a "aws/request.Request" representing the
// client's request for the CancelContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelContact for more information on using the CancelContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelContactRequest method.
//    req, resp := client.CancelContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact
func (c *GroundStation) CancelContactRequest(input *CancelContactInput) (req *request.Request, output *CancelContactOutput) {
	op := &request.Operation{
		Name:       opCancelContact,
		HTTPMethod: "DELETE",
		HTTPPath:   "/contact/{contactId}",
	}

	if input == nil {
		input = &CancelContactInput{}
	}

	output = &CancelContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelContact API operation for AWS Ground Station.
//
// Cancels a contact with a specified contact ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation CancelContact for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CancelContact
func (c *GroundStation) CancelContact(input *CancelContactInput) (*CancelContactOutput, error) {
	req, out := c.CancelContactRequest(input)
	return out, req.Send()
}

// CancelContactWithContext is the same as CancelContact with the addition of
// the ability to pass a context and additional request options.
//
// See CancelContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) CancelContactWithContext(ctx aws.Context, input *CancelContactInput, opts ...request.Option) (*CancelContactOutput, error) {
	req, out := c.CancelContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfig = "CreateConfig"

// CreateConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfig for more information on using the CreateConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConfigRequest method.
//    req, resp := client.CreateConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig
func (c *GroundStation) CreateConfigRequest(input *CreateConfigInput) (req *request.Request, output *CreateConfigOutput) {
	op := &request.Operation{
		Name:       opCreateConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/config",
	}

	if input == nil {
		input = &CreateConfigInput{}
	}

	output = &CreateConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfig API operation for AWS Ground Station.
//
// Creates a Config with the specified configData parameters.
//
// Only one type of configData can be specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation CreateConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceLimitExceededException
//   Account limits for this resource have been exceeded.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateConfig
func (c *GroundStation) CreateConfig(input *CreateConfigInput) (*CreateConfigOutput, error) {
	req, out := c.CreateConfigRequest(input)
	return out, req.Send()
}

// CreateConfigWithContext is the same as CreateConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) CreateConfigWithContext(ctx aws.Context, input *CreateConfigInput, opts ...request.Option) (*CreateConfigOutput, error) {
	req, out := c.CreateConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDataflowEndpointGroup = "CreateDataflowEndpointGroup"

// CreateDataflowEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataflowEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataflowEndpointGroup for more information on using the CreateDataflowEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataflowEndpointGroupRequest method.
//    req, resp := client.CreateDataflowEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup
func (c *GroundStation) CreateDataflowEndpointGroupRequest(input *CreateDataflowEndpointGroupInput) (req *request.Request, output *CreateDataflowEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDataflowEndpointGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/dataflowEndpointGroup",
	}

	if input == nil {
		input = &CreateDataflowEndpointGroupInput{}
	}

	output = &CreateDataflowEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataflowEndpointGroup API operation for AWS Ground Station.
//
// Creates a DataflowEndpoint group containing the specified list of DataflowEndpoint
// objects.
//
// The name field in each endpoint is used in your mission profile DataflowEndpointConfig
// to specify which endpoints to use during a contact.
//
// When a contact uses multiple DataflowEndpointConfig objects, each Config
// must match a DataflowEndpoint in the same group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation CreateDataflowEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateDataflowEndpointGroup
func (c *GroundStation) CreateDataflowEndpointGroup(input *CreateDataflowEndpointGroupInput) (*CreateDataflowEndpointGroupOutput, error) {
	req, out := c.CreateDataflowEndpointGroupRequest(input)
	return out, req.Send()
}

// CreateDataflowEndpointGroupWithContext is the same as CreateDataflowEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataflowEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) CreateDataflowEndpointGroupWithContext(ctx aws.Context, input *CreateDataflowEndpointGroupInput, opts ...request.Option) (*CreateDataflowEndpointGroupOutput, error) {
	req, out := c.CreateDataflowEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMissionProfile = "CreateMissionProfile"

// CreateMissionProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateMissionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMissionProfile for more information on using the CreateMissionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateMissionProfileRequest method.
//    req, resp := client.CreateMissionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile
func (c *GroundStation) CreateMissionProfileRequest(input *CreateMissionProfileInput) (req *request.Request, output *CreateMissionProfileOutput) {
	op := &request.Operation{
		Name:       opCreateMissionProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/missionprofile",
	}

	if input == nil {
		input = &CreateMissionProfileInput{}
	}

	output = &CreateMissionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMissionProfile API operation for AWS Ground Station.
//
// Creates a mission profile.
//
// dataflowEdges is a list of lists of strings. Each lower level list of strings
// has two elements: a from ARN and a to ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation CreateMissionProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/CreateMissionProfile
func (c *GroundStation) CreateMissionProfile(input *CreateMissionProfileInput) (*CreateMissionProfileOutput, error) {
	req, out := c.CreateMissionProfileRequest(input)
	return out, req.Send()
}

// CreateMissionProfileWithContext is the same as CreateMissionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMissionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) CreateMissionProfileWithContext(ctx aws.Context, input *CreateMissionProfileInput, opts ...request.Option) (*CreateMissionProfileOutput, error) {
	req, out := c.CreateMissionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfig = "DeleteConfig"

// DeleteConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfig for more information on using the DeleteConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConfigRequest method.
//    req, resp := client.DeleteConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig
func (c *GroundStation) DeleteConfigRequest(input *DeleteConfigInput) (req *request.Request, output *DeleteConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/config/{configType}/{configId}",
	}

	if input == nil {
		input = &DeleteConfigInput{}
	}

	output = &DeleteConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConfig API operation for AWS Ground Station.
//
// Deletes a Config.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation DeleteConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteConfig
func (c *GroundStation) DeleteConfig(input *DeleteConfigInput) (*DeleteConfigOutput, error) {
	req, out := c.DeleteConfigRequest(input)
	return out, req.Send()
}

// DeleteConfigWithContext is the same as DeleteConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) DeleteConfigWithContext(ctx aws.Context, input *DeleteConfigInput, opts ...request.Option) (*DeleteConfigOutput, error) {
	req, out := c.DeleteConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataflowEndpointGroup = "DeleteDataflowEndpointGroup"

// DeleteDataflowEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataflowEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataflowEndpointGroup for more information on using the DeleteDataflowEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataflowEndpointGroupRequest method.
//    req, resp := client.DeleteDataflowEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup
func (c *GroundStation) DeleteDataflowEndpointGroupRequest(input *DeleteDataflowEndpointGroupInput) (req *request.Request, output *DeleteDataflowEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDataflowEndpointGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
	}

	if input == nil {
		input = &DeleteDataflowEndpointGroupInput{}
	}

	output = &DeleteDataflowEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDataflowEndpointGroup API operation for AWS Ground Station.
//
// Deletes a dataflow endpoint group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation DeleteDataflowEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteDataflowEndpointGroup
func (c *GroundStation) DeleteDataflowEndpointGroup(input *DeleteDataflowEndpointGroupInput) (*DeleteDataflowEndpointGroupOutput, error) {
	req, out := c.DeleteDataflowEndpointGroupRequest(input)
	return out, req.Send()
}

// DeleteDataflowEndpointGroupWithContext is the same as DeleteDataflowEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataflowEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) DeleteDataflowEndpointGroupWithContext(ctx aws.Context, input *DeleteDataflowEndpointGroupInput, opts ...request.Option) (*DeleteDataflowEndpointGroupOutput, error) {
	req, out := c.DeleteDataflowEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMissionProfile = "DeleteMissionProfile"

// DeleteMissionProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMissionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMissionProfile for more information on using the DeleteMissionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMissionProfileRequest method.
//    req, resp := client.DeleteMissionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile
func (c *GroundStation) DeleteMissionProfileRequest(input *DeleteMissionProfileInput) (req *request.Request, output *DeleteMissionProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteMissionProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/missionprofile/{missionProfileId}",
	}

	if input == nil {
		input = &DeleteMissionProfileInput{}
	}

	output = &DeleteMissionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteMissionProfile API operation for AWS Ground Station.
//
// Deletes a mission profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation DeleteMissionProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DeleteMissionProfile
func (c *GroundStation) DeleteMissionProfile(input *DeleteMissionProfileInput) (*DeleteMissionProfileOutput, error) {
	req, out := c.DeleteMissionProfileRequest(input)
	return out, req.Send()
}

// DeleteMissionProfileWithContext is the same as DeleteMissionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMissionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) DeleteMissionProfileWithContext(ctx aws.Context, input *DeleteMissionProfileInput, opts ...request.Option) (*DeleteMissionProfileOutput, error) {
	req, out := c.DeleteMissionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContact = "DescribeContact"

// DescribeContactRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContact for more information on using the DescribeContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeContactRequest method.
//    req, resp := client.DescribeContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact
func (c *GroundStation) DescribeContactRequest(input *DescribeContactInput) (req *request.Request, output *DescribeContactOutput) {
	op := &request.Operation{
		Name:       opDescribeContact,
		HTTPMethod: "GET",
		HTTPPath:   "/contact/{contactId}",
	}

	if input == nil {
		input = &DescribeContactInput{}
	}

	output = &DescribeContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContact API operation for AWS Ground Station.
//
// Describes an existing contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation DescribeContact for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/DescribeContact
func (c *GroundStation) DescribeContact(input *DescribeContactInput) (*DescribeContactOutput, error) {
	req, out := c.DescribeContactRequest(input)
	return out, req.Send()
}

// DescribeContactWithContext is the same as DescribeContact with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) DescribeContactWithContext(ctx aws.Context, input *DescribeContactInput, opts ...request.Option) (*DescribeContactOutput, error) {
	req, out := c.DescribeContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfig = "GetConfig"

// GetConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfig for more information on using the GetConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetConfigRequest method.
//    req, resp := client.GetConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig
func (c *GroundStation) GetConfigRequest(input *GetConfigInput) (req *request.Request, output *GetConfigOutput) {
	op := &request.Operation{
		Name:       opGetConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/config/{configType}/{configId}",
	}

	if input == nil {
		input = &GetConfigInput{}
	}

	output = &GetConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfig API operation for AWS Ground Station.
//
// Returns Config information.
//
// Only one Config response can be returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation GetConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetConfig
func (c *GroundStation) GetConfig(input *GetConfigInput) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	return out, req.Send()
}

// GetConfigWithContext is the same as GetConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) GetConfigWithContext(ctx aws.Context, input *GetConfigInput, opts ...request.Option) (*GetConfigOutput, error) {
	req, out := c.GetConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataflowEndpointGroup = "GetDataflowEndpointGroup"

// GetDataflowEndpointGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetDataflowEndpointGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataflowEndpointGroup for more information on using the GetDataflowEndpointGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataflowEndpointGroupRequest method.
//    req, resp := client.GetDataflowEndpointGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup
func (c *GroundStation) GetDataflowEndpointGroupRequest(input *GetDataflowEndpointGroupInput) (req *request.Request, output *GetDataflowEndpointGroupOutput) {
	op := &request.Operation{
		Name:       opGetDataflowEndpointGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/dataflowEndpointGroup/{dataflowEndpointGroupId}",
	}

	if input == nil {
		input = &GetDataflowEndpointGroupInput{}
	}

	output = &GetDataflowEndpointGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataflowEndpointGroup API operation for AWS Ground Station.
//
// Returns the dataflow endpoint group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation GetDataflowEndpointGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetDataflowEndpointGroup
func (c *GroundStation) GetDataflowEndpointGroup(input *GetDataflowEndpointGroupInput) (*GetDataflowEndpointGroupOutput, error) {
	req, out := c.GetDataflowEndpointGroupRequest(input)
	return out, req.Send()
}

// GetDataflowEndpointGroupWithContext is the same as GetDataflowEndpointGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataflowEndpointGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) GetDataflowEndpointGroupWithContext(ctx aws.Context, input *GetDataflowEndpointGroupInput, opts ...request.Option) (*GetDataflowEndpointGroupOutput, error) {
	req, out := c.GetDataflowEndpointGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMinuteUsage = "GetMinuteUsage"

// GetMinuteUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetMinuteUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMinuteUsage for more information on using the GetMinuteUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMinuteUsageRequest method.
//    req, resp := client.GetMinuteUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage
func (c *GroundStation) GetMinuteUsageRequest(input *GetMinuteUsageInput) (req *request.Request, output *GetMinuteUsageOutput) {
	op := &request.Operation{
		Name:       opGetMinuteUsage,
		HTTPMethod: "POST",
		HTTPPath:   "/minute-usage",
	}

	if input == nil {
		input = &GetMinuteUsageInput{}
	}

	output = &GetMinuteUsageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMinuteUsage API operation for AWS Ground Station.
//
// Returns the number of minutes used by account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation GetMinuteUsage for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMinuteUsage
func (c *GroundStation) GetMinuteUsage(input *GetMinuteUsageInput) (*GetMinuteUsageOutput, error) {
	req, out := c.GetMinuteUsageRequest(input)
	return out, req.Send()
}

// GetMinuteUsageWithContext is the same as GetMinuteUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetMinuteUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) GetMinuteUsageWithContext(ctx aws.Context, input *GetMinuteUsageInput, opts ...request.Option) (*GetMinuteUsageOutput, error) {
	req, out := c.GetMinuteUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMissionProfile = "GetMissionProfile"

// GetMissionProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetMissionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMissionProfile for more information on using the GetMissionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMissionProfileRequest method.
//    req, resp := client.GetMissionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile
func (c *GroundStation) GetMissionProfileRequest(input *GetMissionProfileInput) (req *request.Request, output *GetMissionProfileOutput) {
	op := &request.Operation{
		Name:       opGetMissionProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/missionprofile/{missionProfileId}",
	}

	if input == nil {
		input = &GetMissionProfileInput{}
	}

	output = &GetMissionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMissionProfile API operation for AWS Ground Station.
//
// Returns a mission profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation GetMissionProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetMissionProfile
func (c *GroundStation) GetMissionProfile(input *GetMissionProfileInput) (*GetMissionProfileOutput, error) {
	req, out := c.GetMissionProfileRequest(input)
	return out, req.Send()
}

// GetMissionProfileWithContext is the same as GetMissionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetMissionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) GetMissionProfileWithContext(ctx aws.Context, input *GetMissionProfileInput, opts ...request.Option) (*GetMissionProfileOutput, error) {
	req, out := c.GetMissionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSatellite = "GetSatellite"

// GetSatelliteRequest generates a "aws/request.Request" representing the
// client's request for the GetSatellite operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSatellite for more information on using the GetSatellite
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSatelliteRequest method.
//    req, resp := client.GetSatelliteRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite
func (c *GroundStation) GetSatelliteRequest(input *GetSatelliteInput) (req *request.Request, output *GetSatelliteOutput) {
	op := &request.Operation{
		Name:       opGetSatellite,
		HTTPMethod: "GET",
		HTTPPath:   "/satellite/{satelliteId}",
	}

	if input == nil {
		input = &GetSatelliteInput{}
	}

	output = &GetSatelliteOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSatellite API operation for AWS Ground Station.
//
// Returns a satellite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation GetSatellite for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/GetSatellite
func (c *GroundStation) GetSatellite(input *GetSatelliteInput) (*GetSatelliteOutput, error) {
	req, out := c.GetSatelliteRequest(input)
	return out, req.Send()
}

// GetSatelliteWithContext is the same as GetSatellite with the addition of
// the ability to pass a context and additional request options.
//
// See GetSatellite for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) GetSatelliteWithContext(ctx aws.Context, input *GetSatelliteInput, opts ...request.Option) (*GetSatelliteOutput, error) {
	req, out := c.GetSatelliteRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListConfigs = "ListConfigs"

// ListConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfigs for more information on using the ListConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListConfigsRequest method.
//    req, resp := client.ListConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs
func (c *GroundStation) ListConfigsRequest(input *ListConfigsInput) (req *request.Request, output *ListConfigsOutput) {
	op := &request.Operation{
		Name:       opListConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/config",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigsInput{}
	}

	output = &ListConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfigs API operation for AWS Ground Station.
//
// Returns a list of Config objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListConfigs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListConfigs
func (c *GroundStation) ListConfigs(input *ListConfigsInput) (*ListConfigsOutput, error) {
	req, out := c.ListConfigsRequest(input)
	return out, req.Send()
}

// ListConfigsWithContext is the same as ListConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListConfigsWithContext(ctx aws.Context, input *ListConfigsInput, opts ...request.Option) (*ListConfigsOutput, error) {
	req, out := c.ListConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfigsPages iterates over the pages of a ListConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListConfigs operation.
//    pageNum := 0
//    err := client.ListConfigsPages(params,
//        func(page *groundstation.ListConfigsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListConfigsPages(input *ListConfigsInput, fn func(*ListConfigsOutput, bool) bool) error {
	return c.ListConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfigsPagesWithContext same as ListConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListConfigsPagesWithContext(ctx aws.Context, input *ListConfigsInput, fn func(*ListConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContacts = "ListContacts"

// ListContactsRequest generates a "aws/request.Request" representing the
// client's request for the ListContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContacts for more information on using the ListContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListContactsRequest method.
//    req, resp := client.ListContactsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts
func (c *GroundStation) ListContactsRequest(input *ListContactsInput) (req *request.Request, output *ListContactsOutput) {
	op := &request.Operation{
		Name:       opListContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/contacts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactsInput{}
	}

	output = &ListContactsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContacts API operation for AWS Ground Station.
//
// Returns a list of contacts.
//
// If statusList contains AVAILABLE, the request must include groundStation,
// missionprofileArn, and satelliteArn.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListContacts for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListContacts
func (c *GroundStation) ListContacts(input *ListContactsInput) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	return out, req.Send()
}

// ListContactsWithContext is the same as ListContacts with the addition of
// the ability to pass a context and additional request options.
//
// See ListContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListContactsWithContext(ctx aws.Context, input *ListContactsInput, opts ...request.Option) (*ListContactsOutput, error) {
	req, out := c.ListContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactsPages iterates over the pages of a ListContacts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContacts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListContacts operation.
//    pageNum := 0
//    err := client.ListContactsPages(params,
//        func(page *groundstation.ListContactsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListContactsPages(input *ListContactsInput, fn func(*ListContactsOutput, bool) bool) error {
	return c.ListContactsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactsPagesWithContext same as ListContactsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListContactsPagesWithContext(ctx aws.Context, input *ListContactsInput, fn func(*ListContactsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDataflowEndpointGroups = "ListDataflowEndpointGroups"

// ListDataflowEndpointGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataflowEndpointGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataflowEndpointGroups for more information on using the ListDataflowEndpointGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataflowEndpointGroupsRequest method.
//    req, resp := client.ListDataflowEndpointGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups
func (c *GroundStation) ListDataflowEndpointGroupsRequest(input *ListDataflowEndpointGroupsInput) (req *request.Request, output *ListDataflowEndpointGroupsOutput) {
	op := &request.Operation{
		Name:       opListDataflowEndpointGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/dataflowEndpointGroup",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDataflowEndpointGroupsInput{}
	}

	output = &ListDataflowEndpointGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataflowEndpointGroups API operation for AWS Ground Station.
//
// Returns a list of DataflowEndpoint groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListDataflowEndpointGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListDataflowEndpointGroups
func (c *GroundStation) ListDataflowEndpointGroups(input *ListDataflowEndpointGroupsInput) (*ListDataflowEndpointGroupsOutput, error) {
	req, out := c.ListDataflowEndpointGroupsRequest(input)
	return out, req.Send()
}

// ListDataflowEndpointGroupsWithContext is the same as ListDataflowEndpointGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataflowEndpointGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListDataflowEndpointGroupsWithContext(ctx aws.Context, input *ListDataflowEndpointGroupsInput, opts ...request.Option) (*ListDataflowEndpointGroupsOutput, error) {
	req, out := c.ListDataflowEndpointGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDataflowEndpointGroupsPages iterates over the pages of a ListDataflowEndpointGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDataflowEndpointGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDataflowEndpointGroups operation.
//    pageNum := 0
//    err := client.ListDataflowEndpointGroupsPages(params,
//        func(page *groundstation.ListDataflowEndpointGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListDataflowEndpointGroupsPages(input *ListDataflowEndpointGroupsInput, fn func(*ListDataflowEndpointGroupsOutput, bool) bool) error {
	return c.ListDataflowEndpointGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDataflowEndpointGroupsPagesWithContext same as ListDataflowEndpointGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListDataflowEndpointGroupsPagesWithContext(ctx aws.Context, input *ListDataflowEndpointGroupsInput, fn func(*ListDataflowEndpointGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDataflowEndpointGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDataflowEndpointGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDataflowEndpointGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListGroundStations = "ListGroundStations"

// ListGroundStationsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroundStations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGroundStations for more information on using the ListGroundStations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGroundStationsRequest method.
//    req, resp := client.ListGroundStationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations
func (c *GroundStation) ListGroundStationsRequest(input *ListGroundStationsInput) (req *request.Request, output *ListGroundStationsOutput) {
	op := &request.Operation{
		Name:       opListGroundStations,
		HTTPMethod: "GET",
		HTTPPath:   "/groundstation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGroundStationsInput{}
	}

	output = &ListGroundStationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroundStations API operation for AWS Ground Station.
//
// Returns a list of ground stations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListGroundStations for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListGroundStations
func (c *GroundStation) ListGroundStations(input *ListGroundStationsInput) (*ListGroundStationsOutput, error) {
	req, out := c.ListGroundStationsRequest(input)
	return out, req.Send()
}

// ListGroundStationsWithContext is the same as ListGroundStations with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroundStations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListGroundStationsWithContext(ctx aws.Context, input *ListGroundStationsInput, opts ...request.Option) (*ListGroundStationsOutput, error) {
	req, out := c.ListGroundStationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListGroundStationsPages iterates over the pages of a ListGroundStations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroundStations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroundStations operation.
//    pageNum := 0
//    err := client.ListGroundStationsPages(params,
//        func(page *groundstation.ListGroundStationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListGroundStationsPages(input *ListGroundStationsInput, fn func(*ListGroundStationsOutput, bool) bool) error {
	return c.ListGroundStationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListGroundStationsPagesWithContext same as ListGroundStationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListGroundStationsPagesWithContext(ctx aws.Context, input *ListGroundStationsInput, fn func(*ListGroundStationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListGroundStationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListGroundStationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListGroundStationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMissionProfiles = "ListMissionProfiles"

// ListMissionProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListMissionProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMissionProfiles for more information on using the ListMissionProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListMissionProfilesRequest method.
//    req, resp := client.ListMissionProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles
func (c *GroundStation) ListMissionProfilesRequest(input *ListMissionProfilesInput) (req *request.Request, output *ListMissionProfilesOutput) {
	op := &request.Operation{
		Name:       opListMissionProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/missionprofile",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMissionProfilesInput{}
	}

	output = &ListMissionProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMissionProfiles API operation for AWS Ground Station.
//
// Returns a list of mission profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListMissionProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListMissionProfiles
func (c *GroundStation) ListMissionProfiles(input *ListMissionProfilesInput) (*ListMissionProfilesOutput, error) {
	req, out := c.ListMissionProfilesRequest(input)
	return out, req.Send()
}

// ListMissionProfilesWithContext is the same as ListMissionProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListMissionProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListMissionProfilesWithContext(ctx aws.Context, input *ListMissionProfilesInput, opts ...request.Option) (*ListMissionProfilesOutput, error) {
	req, out := c.ListMissionProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMissionProfilesPages iterates over the pages of a ListMissionProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMissionProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMissionProfiles operation.
//    pageNum := 0
//    err := client.ListMissionProfilesPages(params,
//        func(page *groundstation.ListMissionProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListMissionProfilesPages(input *ListMissionProfilesInput, fn func(*ListMissionProfilesOutput, bool) bool) error {
	return c.ListMissionProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMissionProfilesPagesWithContext same as ListMissionProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListMissionProfilesPagesWithContext(ctx aws.Context, input *ListMissionProfilesInput, fn func(*ListMissionProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMissionProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMissionProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMissionProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSatellites = "ListSatellites"

// ListSatellitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSatellites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSatellites for more information on using the ListSatellites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSatellitesRequest method.
//    req, resp := client.ListSatellitesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites
func (c *GroundStation) ListSatellitesRequest(input *ListSatellitesInput) (req *request.Request, output *ListSatellitesOutput) {
	op := &request.Operation{
		Name:       opListSatellites,
		HTTPMethod: "GET",
		HTTPPath:   "/satellite",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSatellitesInput{}
	}

	output = &ListSatellitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSatellites API operation for AWS Ground Station.
//
// Returns a list of satellites.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListSatellites for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListSatellites
func (c *GroundStation) ListSatellites(input *ListSatellitesInput) (*ListSatellitesOutput, error) {
	req, out := c.ListSatellitesRequest(input)
	return out, req.Send()
}

// ListSatellitesWithContext is the same as ListSatellites with the addition of
// the ability to pass a context and additional request options.
//
// See ListSatellites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListSatellitesWithContext(ctx aws.Context, input *ListSatellitesInput, opts ...request.Option) (*ListSatellitesOutput, error) {
	req, out := c.ListSatellitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSatellitesPages iterates over the pages of a ListSatellites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSatellites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSatellites operation.
//    pageNum := 0
//    err := client.ListSatellitesPages(params,
//        func(page *groundstation.ListSatellitesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *GroundStation) ListSatellitesPages(input *ListSatellitesInput, fn func(*ListSatellitesOutput, bool) bool) error {
	return c.ListSatellitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSatellitesPagesWithContext same as ListSatellitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListSatellitesPagesWithContext(ctx aws.Context, input *ListSatellitesInput, fn func(*ListSatellitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSatellitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSatellitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSatellitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource
func (c *GroundStation) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Ground Station.
//
// Returns a list of tags for a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ListTagsForResource
func (c *GroundStation) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReserveContact = "ReserveContact"

// ReserveContactRequest generates a "aws/request.Request" representing the
// client's request for the ReserveContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReserveContact for more information on using the ReserveContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReserveContactRequest method.
//    req, resp := client.ReserveContactRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact
func (c *GroundStation) ReserveContactRequest(input *ReserveContactInput) (req *request.Request, output *ReserveContactOutput) {
	op := &request.Operation{
		Name:       opReserveContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact",
	}

	if input == nil {
		input = &ReserveContactInput{}
	}

	output = &ReserveContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReserveContact API operation for AWS Ground Station.
//
// Reserves a contact using specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation ReserveContact for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/ReserveContact
func (c *GroundStation) ReserveContact(input *ReserveContactInput) (*ReserveContactOutput, error) {
	req, out := c.ReserveContactRequest(input)
	return out, req.Send()
}

// ReserveContactWithContext is the same as ReserveContact with the addition of
// the ability to pass a context and additional request options.
//
// See ReserveContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) ReserveContactWithContext(ctx aws.Context, input *ReserveContactInput, opts ...request.Option) (*ReserveContactOutput, error) {
	req, out := c.ReserveContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource
func (c *GroundStation) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Ground Station.
//
// Assigns a tag to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/TagResource
func (c *GroundStation) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource
func (c *GroundStation) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Ground Station.
//
// Deassigns a resource tag.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UntagResource
func (c *GroundStation) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfig = "UpdateConfig"

// UpdateConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfig for more information on using the UpdateConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConfigRequest method.
//    req, resp := client.UpdateConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig
func (c *GroundStation) UpdateConfigRequest(input *UpdateConfigInput) (req *request.Request, output *UpdateConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/config/{configType}/{configId}",
	}

	if input == nil {
		input = &UpdateConfigInput{}
	}

	output = &UpdateConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfig API operation for AWS Ground Station.
//
// Updates the Config used when scheduling contacts.
//
// Updating a Config will not update the execution parameters for existing future
// contacts scheduled with this Config.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation UpdateConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateConfig
func (c *GroundStation) UpdateConfig(input *UpdateConfigInput) (*UpdateConfigOutput, error) {
	req, out := c.UpdateConfigRequest(input)
	return out, req.Send()
}

// UpdateConfigWithContext is the same as UpdateConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) UpdateConfigWithContext(ctx aws.Context, input *UpdateConfigInput, opts ...request.Option) (*UpdateConfigOutput, error) {
	req, out := c.UpdateConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMissionProfile = "UpdateMissionProfile"

// UpdateMissionProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMissionProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMissionProfile for more information on using the UpdateMissionProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMissionProfileRequest method.
//    req, resp := client.UpdateMissionProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile
func (c *GroundStation) UpdateMissionProfileRequest(input *UpdateMissionProfileInput) (req *request.Request, output *UpdateMissionProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateMissionProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/missionprofile/{missionProfileId}",
	}

	if input == nil {
		input = &UpdateMissionProfileInput{}
	}

	output = &UpdateMissionProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMissionProfile API operation for AWS Ground Station.
//
// Updates a mission profile.
//
// Updating a mission profile will not update the execution parameters for existing
// future contacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Ground Station's
// API operation UpdateMissionProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   One or more parameters are not valid.
//
//   * DependencyException
//   Dependency encountered an error.
//
//   * ResourceNotFoundException
//   Resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/groundstation-2019-05-23/UpdateMissionProfile
func (c *GroundStation) UpdateMissionProfile(input *UpdateMissionProfileInput) (*UpdateMissionProfileOutput, error) {
	req, out := c.UpdateMissionProfileRequest(input)
	return out, req.Send()
}

// UpdateMissionProfileWithContext is the same as UpdateMissionProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMissionProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GroundStation) UpdateMissionProfileWithContext(ctx aws.Context, input *UpdateMissionProfileInput, opts ...request.Option) (*UpdateMissionProfileOutput, error) {
	req, out := c.UpdateMissionProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Information about how AWS Ground Station should configure an antenna for
// downlink during a contact.
type AntennaDownlinkConfig struct {
	_ struct{} `type:"structure"`

	// Object that describes a spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AntennaDownlinkConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AntennaDownlinkConfig"}
	if s.SpectrumConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SpectrumConfig"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpectrumConfig sets the SpectrumConfig field's value.
func (s *AntennaDownlinkConfig) SetSpectrumConfig(v *SpectrumConfig) *AntennaDownlinkConfig {
	s.SpectrumConfig = v
	return s
}

// Information about how AWS Ground Station should conﬁgure an antenna for
// downlink demod decode during a contact.
type AntennaDownlinkDemodDecodeConfig struct {
	_ struct{} `type:"structure"`

	// Information about the decode Config.
	//
	// DecodeConfig is a required field
	DecodeConfig *DecodeConfig `locationName:"decodeConfig" type:"structure" required:"true"`

	// Information about the demodulation Config.
	//
	// DemodulationConfig is a required field
	DemodulationConfig *DemodulationConfig `locationName:"demodulationConfig" type:"structure" required:"true"`

	// Information about the spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *SpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaDownlinkDemodDecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AntennaDownlinkDemodDecodeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaDownlinkDemodDecodeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AntennaDownlinkDemodDecodeConfig"}
	if s.DecodeConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DecodeConfig"))
	}
	if s.DemodulationConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("DemodulationConfig"))
	}
	if s.SpectrumConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SpectrumConfig"))
	}
	if s.DecodeConfig != nil {
		if err := s.DecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("DecodeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.DemodulationConfig != nil {
		if err := s.DemodulationConfig.Validate(); err != nil {
			invalidParams.AddNested("DemodulationConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDecodeConfig sets the DecodeConfig field's value.
func (s *AntennaDownlinkDemodDecodeConfig) SetDecodeConfig(v *DecodeConfig) *AntennaDownlinkDemodDecodeConfig {
	s.DecodeConfig = v
	return s
}

// SetDemodulationConfig sets the DemodulationConfig field's value.
func (s *AntennaDownlinkDemodDecodeConfig) SetDemodulationConfig(v *DemodulationConfig) *AntennaDownlinkDemodDecodeConfig {
	s.DemodulationConfig = v
	return s
}

// SetSpectrumConfig sets the SpectrumConfig field's value.
func (s *AntennaDownlinkDemodDecodeConfig) SetSpectrumConfig(v *SpectrumConfig) *AntennaDownlinkDemodDecodeConfig {
	s.SpectrumConfig = v
	return s
}

// Information about the uplink Config of an antenna.
type AntennaUplinkConfig struct {
	_ struct{} `type:"structure"`

	// Information about the uplink spectral Config.
	//
	// SpectrumConfig is a required field
	SpectrumConfig *UplinkSpectrumConfig `locationName:"spectrumConfig" type:"structure" required:"true"`

	// EIRP of the target.
	//
	// TargetEirp is a required field
	TargetEirp *Eirp `locationName:"targetEirp" type:"structure" required:"true"`
}

// String returns the string representation
func (s AntennaUplinkConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AntennaUplinkConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AntennaUplinkConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AntennaUplinkConfig"}
	if s.SpectrumConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SpectrumConfig"))
	}
	if s.TargetEirp == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEirp"))
	}
	if s.SpectrumConfig != nil {
		if err := s.SpectrumConfig.Validate(); err != nil {
			invalidParams.AddNested("SpectrumConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetEirp != nil {
		if err := s.TargetEirp.Validate(); err != nil {
			invalidParams.AddNested("TargetEirp", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSpectrumConfig sets the SpectrumConfig field's value.
func (s *AntennaUplinkConfig) SetSpectrumConfig(v *UplinkSpectrumConfig) *AntennaUplinkConfig {
	s.SpectrumConfig = v
	return s
}

// SetTargetEirp sets the TargetEirp field's value.
func (s *AntennaUplinkConfig) SetTargetEirp(v *Eirp) *AntennaUplinkConfig {
	s.TargetEirp = v
	return s
}

type CancelContactInput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	//
	// ContactId is a required field
	ContactId *string `location:"uri" locationName:"contactId" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *CancelContactInput) SetContactId(v string) *CancelContactInput {
	s.ContactId = &v
	return s
}

type CancelContactOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`
}

// String returns the string representation
func (s CancelContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *CancelContactOutput) SetContactId(v string) *CancelContactOutput {
	s.ContactId = &v
	return s
}

// An item in a list of Config objects.
type ConfigListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType *string `locationName:"configType" type:"string" enum:"ConfigCapabilityType"`

	// Name of a Config.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s ConfigListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigListItem) GoString() string {
	return s.String()
}

// SetConfigArn sets the ConfigArn field's value.
func (s *ConfigListItem) SetConfigArn(v string) *ConfigListItem {
	s.ConfigArn = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *ConfigListItem) SetConfigId(v string) *ConfigListItem {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *ConfigListItem) SetConfigType(v string) *ConfigListItem {
	s.ConfigType = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfigListItem) SetName(v string) *ConfigListItem {
	s.Name = &v
	return s
}

// Object containing the parameters of a Config.
//
// See the subtype definitions for what each type of Config contains.
type ConfigTypeData struct {
	_ struct{} `type:"structure"`

	// Information about how AWS Ground Station should configure an antenna for
	// downlink during a contact.
	AntennaDownlinkConfig *AntennaDownlinkConfig `locationName:"antennaDownlinkConfig" type:"structure"`

	// Information about how AWS Ground Station should conﬁgure an antenna for
	// downlink demod decode during a contact.
	AntennaDownlinkDemodDecodeConfig *AntennaDownlinkDemodDecodeConfig `locationName:"antennaDownlinkDemodDecodeConfig" type:"structure"`

	// Information about how AWS Ground Station should conﬁgure an antenna for
	// uplink during a contact.
	AntennaUplinkConfig *AntennaUplinkConfig `locationName:"antennaUplinkConfig" type:"structure"`

	// Information about the dataflow endpoint Config.
	DataflowEndpointConfig *DataflowEndpointConfig `locationName:"dataflowEndpointConfig" type:"structure"`

	// Object that determines whether tracking should be used during a contact executed
	// with this Config in the mission profile.
	TrackingConfig *TrackingConfig `locationName:"trackingConfig" type:"structure"`

	// Information about an uplink echo Config.
	//
	// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
	// are used when this UplinkEchoConfig is used in a contact.
	UplinkEchoConfig *UplinkEchoConfig `locationName:"uplinkEchoConfig" type:"structure"`
}

// String returns the string representation
func (s ConfigTypeData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigTypeData) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigTypeData) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfigTypeData"}
	if s.AntennaDownlinkConfig != nil {
		if err := s.AntennaDownlinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.AntennaDownlinkDemodDecodeConfig != nil {
		if err := s.AntennaDownlinkDemodDecodeConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaDownlinkDemodDecodeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.AntennaUplinkConfig != nil {
		if err := s.AntennaUplinkConfig.Validate(); err != nil {
			invalidParams.AddNested("AntennaUplinkConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.DataflowEndpointConfig != nil {
		if err := s.DataflowEndpointConfig.Validate(); err != nil {
			invalidParams.AddNested("DataflowEndpointConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.TrackingConfig != nil {
		if err := s.TrackingConfig.Validate(); err != nil {
			invalidParams.AddNested("TrackingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.UplinkEchoConfig != nil {
		if err := s.UplinkEchoConfig.Validate(); err != nil {
			invalidParams.AddNested("UplinkEchoConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAntennaDownlinkConfig sets the AntennaDownlinkConfig field's value.
func (s *ConfigTypeData) SetAntennaDownlinkConfig(v *AntennaDownlinkConfig) *ConfigTypeData {
	s.AntennaDownlinkConfig = v
	return s
}

// SetAntennaDownlinkDemodDecodeConfig sets the AntennaDownlinkDemodDecodeConfig field's value.
func (s *ConfigTypeData) SetAntennaDownlinkDemodDecodeConfig(v *AntennaDownlinkDemodDecodeConfig) *ConfigTypeData {
	s.AntennaDownlinkDemodDecodeConfig = v
	return s
}

// SetAntennaUplinkConfig sets the AntennaUplinkConfig field's value.
func (s *ConfigTypeData) SetAntennaUplinkConfig(v *AntennaUplinkConfig) *ConfigTypeData {
	s.AntennaUplinkConfig = v
	return s
}

// SetDataflowEndpointConfig sets the DataflowEndpointConfig field's value.
func (s *ConfigTypeData) SetDataflowEndpointConfig(v *DataflowEndpointConfig) *ConfigTypeData {
	s.DataflowEndpointConfig = v
	return s
}

// SetTrackingConfig sets the TrackingConfig field's value.
func (s *ConfigTypeData) SetTrackingConfig(v *TrackingConfig) *ConfigTypeData {
	s.TrackingConfig = v
	return s
}

// SetUplinkEchoConfig sets the UplinkEchoConfig field's value.
func (s *ConfigTypeData) SetUplinkEchoConfig(v *UplinkEchoConfig) *ConfigTypeData {
	s.UplinkEchoConfig = v
	return s
}

// Data describing a contact.
type ContactData struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`

	// Status of a contact.
	ContactStatus *string `locationName:"contactStatus" type:"string" enum:"ContactStatus"`

	// End time of a contact.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Error message of a contact.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Name of a ground station.
	GroundStation *string `locationName:"groundStation" type:"string"`

	// Maximum elevation angle of a contact.
	MaximumElevation *Elevation `locationName:"maximumElevation" type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	PostPassEndTime *time.Time `locationName:"postPassEndTime" type:"timestamp"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	PrePassStartTime *time.Time `locationName:"prePassStartTime" type:"timestamp"`

	// Region of a contact.
	Region *string `locationName:"region" type:"string"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// Start time of a contact.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Tags assigned to a contact.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ContactData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContactData) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *ContactData) SetContactId(v string) *ContactData {
	s.ContactId = &v
	return s
}

// SetContactStatus sets the ContactStatus field's value.
func (s *ContactData) SetContactStatus(v string) *ContactData {
	s.ContactStatus = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *ContactData) SetEndTime(v time.Time) *ContactData {
	s.EndTime = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ContactData) SetErrorMessage(v string) *ContactData {
	s.ErrorMessage = &v
	return s
}

// SetGroundStation sets the GroundStation field's value.
func (s *ContactData) SetGroundStation(v string) *ContactData {
	s.GroundStation = &v
	return s
}

// SetMaximumElevation sets the MaximumElevation field's value.
func (s *ContactData) SetMaximumElevation(v *Elevation) *ContactData {
	s.MaximumElevation = v
	return s
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *ContactData) SetMissionProfileArn(v string) *ContactData {
	s.MissionProfileArn = &v
	return s
}

// SetPostPassEndTime sets the PostPassEndTime field's value.
func (s *ContactData) SetPostPassEndTime(v time.Time) *ContactData {
	s.PostPassEndTime = &v
	return s
}

// SetPrePassStartTime sets the PrePassStartTime field's value.
func (s *ContactData) SetPrePassStartTime(v time.Time) *ContactData {
	s.PrePassStartTime = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ContactData) SetRegion(v string) *ContactData {
	s.Region = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *ContactData) SetSatelliteArn(v string) *ContactData {
	s.SatelliteArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ContactData) SetStartTime(v time.Time) *ContactData {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContactData) SetTags(v map[string]*string) *ContactData {
	s.Tags = v
	return s
}

type CreateConfigInput struct {
	_ struct{} `type:"structure"`

	// Parameters of a Config.
	//
	// ConfigData is a required field
	ConfigData *ConfigTypeData `locationName:"configData" type:"structure" required:"true"`

	// Name of a Config.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Tags assigned to a Config.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfigInput"}
	if s.ConfigData == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigData"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConfigData != nil {
		if err := s.ConfigData.Validate(); err != nil {
			invalidParams.AddNested("ConfigData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigData sets the ConfigData field's value.
func (s *CreateConfigInput) SetConfigData(v *ConfigTypeData) *CreateConfigInput {
	s.ConfigData = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfigInput) SetName(v string) *CreateConfigInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfigInput) SetTags(v map[string]*string) *CreateConfigInput {
	s.Tags = v
	return s
}

type CreateConfigOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType *string `locationName:"configType" type:"string" enum:"ConfigCapabilityType"`
}

// String returns the string representation
func (s CreateConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigOutput) GoString() string {
	return s.String()
}

// SetConfigArn sets the ConfigArn field's value.
func (s *CreateConfigOutput) SetConfigArn(v string) *CreateConfigOutput {
	s.ConfigArn = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *CreateConfigOutput) SetConfigId(v string) *CreateConfigOutput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *CreateConfigOutput) SetConfigType(v string) *CreateConfigOutput {
	s.ConfigType = &v
	return s
}

type CreateDataflowEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// Endpoint details of each endpoint in the dataflow endpoint group.
	//
	// EndpointDetails is a required field
	EndpointDetails []*EndpointDetails `locationName:"endpointDetails" type:"list" required:"true"`

	// Tags of a dataflow endpoint group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDataflowEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataflowEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataflowEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataflowEndpointGroupInput"}
	if s.EndpointDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointDetails"))
	}
	if s.EndpointDetails != nil {
		for i, v := range s.EndpointDetails {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EndpointDetails", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointDetails sets the EndpointDetails field's value.
func (s *CreateDataflowEndpointGroupInput) SetEndpointDetails(v []*EndpointDetails) *CreateDataflowEndpointGroupInput {
	s.EndpointDetails = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataflowEndpointGroupInput) SetTags(v map[string]*string) *CreateDataflowEndpointGroupInput {
	s.Tags = v
	return s
}

type CreateDataflowEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s CreateDataflowEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataflowEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *CreateDataflowEndpointGroupOutput) SetDataflowEndpointGroupId(v string) *CreateDataflowEndpointGroupOutput {
	s.DataflowEndpointGroupId = &v
	return s
}

type CreateMissionProfileInput struct {
	_ struct{} `type:"structure"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	ContactPostPassDurationSeconds *int64 `locationName:"contactPostPassDurationSeconds" min:"1" type:"integer"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	ContactPrePassDurationSeconds *int64 `locationName:"contactPrePassDurationSeconds" min:"1" type:"integer"`

	// A list of lists of ARNs. Each list of ARNs is an edge, with a from Config
	// and a to Config.
	//
	// DataflowEdges is a required field
	DataflowEdges [][]*string `locationName:"dataflowEdges" type:"list" required:"true"`

	// Smallest amount of time in seconds that you’d like to see for an available
	// contact. AWS Ground Station will not present you with contacts shorter than
	// this duration.
	//
	// MinimumViableContactDurationSeconds is a required field
	MinimumViableContactDurationSeconds *int64 `locationName:"minimumViableContactDurationSeconds" min:"1" type:"integer" required:"true"`

	// Name of a mission profile.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Tags assigned to a mission profile.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// ARN of a tracking Config.
	//
	// TrackingConfigArn is a required field
	TrackingConfigArn *string `locationName:"trackingConfigArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateMissionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMissionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMissionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMissionProfileInput"}
	if s.ContactPostPassDurationSeconds != nil && *s.ContactPostPassDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ContactPostPassDurationSeconds", 1))
	}
	if s.ContactPrePassDurationSeconds != nil && *s.ContactPrePassDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ContactPrePassDurationSeconds", 1))
	}
	if s.DataflowEdges == nil {
		invalidParams.Add(request.NewErrParamRequired("DataflowEdges"))
	}
	if s.MinimumViableContactDurationSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("MinimumViableContactDurationSeconds"))
	}
	if s.MinimumViableContactDurationSeconds != nil && *s.MinimumViableContactDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumViableContactDurationSeconds", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrackingConfigArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrackingConfigArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactPostPassDurationSeconds sets the ContactPostPassDurationSeconds field's value.
func (s *CreateMissionProfileInput) SetContactPostPassDurationSeconds(v int64) *CreateMissionProfileInput {
	s.ContactPostPassDurationSeconds = &v
	return s
}

// SetContactPrePassDurationSeconds sets the ContactPrePassDurationSeconds field's value.
func (s *CreateMissionProfileInput) SetContactPrePassDurationSeconds(v int64) *CreateMissionProfileInput {
	s.ContactPrePassDurationSeconds = &v
	return s
}

// SetDataflowEdges sets the DataflowEdges field's value.
func (s *CreateMissionProfileInput) SetDataflowEdges(v [][]*string) *CreateMissionProfileInput {
	s.DataflowEdges = v
	return s
}

// SetMinimumViableContactDurationSeconds sets the MinimumViableContactDurationSeconds field's value.
func (s *CreateMissionProfileInput) SetMinimumViableContactDurationSeconds(v int64) *CreateMissionProfileInput {
	s.MinimumViableContactDurationSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateMissionProfileInput) SetName(v string) *CreateMissionProfileInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMissionProfileInput) SetTags(v map[string]*string) *CreateMissionProfileInput {
	s.Tags = v
	return s
}

// SetTrackingConfigArn sets the TrackingConfigArn field's value.
func (s *CreateMissionProfileInput) SetTrackingConfigArn(v string) *CreateMissionProfileInput {
	s.TrackingConfigArn = &v
	return s
}

type CreateMissionProfileOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`
}

// String returns the string representation
func (s CreateMissionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMissionProfileOutput) GoString() string {
	return s.String()
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *CreateMissionProfileOutput) SetMissionProfileId(v string) *CreateMissionProfileOutput {
	s.MissionProfileId = &v
	return s
}

// Information about the ground station data.
type Data struct {
	_ struct{} `type:"structure"`

	// UUID of a ground station.
	GroundStationId *string `locationName:"groundStationId" type:"string"`

	// Name of a ground station.
	GroundStationName *string `locationName:"groundStationName" type:"string"`

	// Ground station Region.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s Data) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Data) GoString() string {
	return s.String()
}

// SetGroundStationId sets the GroundStationId field's value.
func (s *Data) SetGroundStationId(v string) *Data {
	s.GroundStationId = &v
	return s
}

// SetGroundStationName sets the GroundStationName field's value.
func (s *Data) SetGroundStationName(v string) *Data {
	s.GroundStationName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Data) SetRegion(v string) *Data {
	s.Region = &v
	return s
}

// Information about a dataflow endpoint.
type DataflowEndpoint struct {
	_ struct{} `type:"structure"`

	// Socket address of a dataflow endpoint.
	Address *SocketAddress `locationName:"address" type:"structure"`

	// Name of a dataflow endpoint.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Status of a dataflow endpoint.
	Status *string `locationName:"status" type:"string" enum:"EndpointStatus"`
}

// String returns the string representation
func (s DataflowEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataflowEndpoint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpoint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataflowEndpoint"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *DataflowEndpoint) SetAddress(v *SocketAddress) *DataflowEndpoint {
	s.Address = v
	return s
}

// SetName sets the Name field's value.
func (s *DataflowEndpoint) SetName(v string) *DataflowEndpoint {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DataflowEndpoint) SetStatus(v string) *DataflowEndpoint {
	s.Status = &v
	return s
}

// Information about the dataflow endpoint Config.
type DataflowEndpointConfig struct {
	_ struct{} `type:"structure"`

	// Name of a dataflow endpoint.
	//
	// DataflowEndpointName is a required field
	DataflowEndpointName *string `locationName:"dataflowEndpointName" type:"string" required:"true"`

	// Region of a dataflow endpoint.
	DataflowEndpointRegion *string `locationName:"dataflowEndpointRegion" type:"string"`
}

// String returns the string representation
func (s DataflowEndpointConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataflowEndpointConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataflowEndpointConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataflowEndpointConfig"}
	if s.DataflowEndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataflowEndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataflowEndpointName sets the DataflowEndpointName field's value.
func (s *DataflowEndpointConfig) SetDataflowEndpointName(v string) *DataflowEndpointConfig {
	s.DataflowEndpointName = &v
	return s
}

// SetDataflowEndpointRegion sets the DataflowEndpointRegion field's value.
func (s *DataflowEndpointConfig) SetDataflowEndpointRegion(v string) *DataflowEndpointConfig {
	s.DataflowEndpointRegion = &v
	return s
}

// Item in a list of DataflowEndpoint groups.
type DataflowEndpointListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a dataflow endpoint group.
	DataflowEndpointGroupArn *string `locationName:"dataflowEndpointGroupArn" type:"string"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s DataflowEndpointListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataflowEndpointListItem) GoString() string {
	return s.String()
}

// SetDataflowEndpointGroupArn sets the DataflowEndpointGroupArn field's value.
func (s *DataflowEndpointListItem) SetDataflowEndpointGroupArn(v string) *DataflowEndpointListItem {
	s.DataflowEndpointGroupArn = &v
	return s
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *DataflowEndpointListItem) SetDataflowEndpointGroupId(v string) *DataflowEndpointListItem {
	s.DataflowEndpointGroupId = &v
	return s
}

// Information about the decode Config.
type DecodeConfig struct {
	_ struct{} `type:"structure"`

	// Unvalidated JSON of a decode Config.
	//
	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DecodeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecodeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecodeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecodeConfig"}
	if s.UnvalidatedJSON == nil {
		invalidParams.Add(request.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnvalidatedJSON sets the UnvalidatedJSON field's value.
func (s *DecodeConfig) SetUnvalidatedJSON(v string) *DecodeConfig {
	s.UnvalidatedJSON = &v
	return s
}

type DeleteConfigInput struct {
	_ struct{} `type:"structure"`

	// UUID of a Config.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"configId" type:"string" required:"true"`

	// Type of a Config.
	//
	// ConfigType is a required field
	ConfigType *string `location:"uri" locationName:"configType" type:"string" required:"true" enum:"ConfigCapabilityType"`
}

// String returns the string representation
func (s DeleteConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfigInput"}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}
	if s.ConfigType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigType"))
	}
	if s.ConfigType != nil && len(*s.ConfigType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteConfigInput) SetConfigId(v string) *DeleteConfigInput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *DeleteConfigInput) SetConfigType(v string) *DeleteConfigInput {
	s.ConfigType = &v
	return s
}

type DeleteConfigOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType *string `locationName:"configType" type:"string" enum:"ConfigCapabilityType"`
}

// String returns the string representation
func (s DeleteConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigOutput) GoString() string {
	return s.String()
}

// SetConfigArn sets the ConfigArn field's value.
func (s *DeleteConfigOutput) SetConfigArn(v string) *DeleteConfigOutput {
	s.ConfigArn = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *DeleteConfigOutput) SetConfigId(v string) *DeleteConfigOutput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *DeleteConfigOutput) SetConfigType(v string) *DeleteConfigOutput {
	s.ConfigType = &v
	return s
}

type DeleteDataflowEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// UUID of a dataflow endpoint group.
	//
	// DataflowEndpointGroupId is a required field
	DataflowEndpointGroupId *string `location:"uri" locationName:"dataflowEndpointGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDataflowEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataflowEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataflowEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataflowEndpointGroupInput"}
	if s.DataflowEndpointGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataflowEndpointGroupId"))
	}
	if s.DataflowEndpointGroupId != nil && len(*s.DataflowEndpointGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataflowEndpointGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *DeleteDataflowEndpointGroupInput) SetDataflowEndpointGroupId(v string) *DeleteDataflowEndpointGroupInput {
	s.DataflowEndpointGroupId = &v
	return s
}

type DeleteDataflowEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`
}

// String returns the string representation
func (s DeleteDataflowEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataflowEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *DeleteDataflowEndpointGroupOutput) SetDataflowEndpointGroupId(v string) *DeleteDataflowEndpointGroupOutput {
	s.DataflowEndpointGroupId = &v
	return s
}

type DeleteMissionProfileInput struct {
	_ struct{} `type:"structure"`

	// UUID of a mission profile.
	//
	// MissionProfileId is a required field
	MissionProfileId *string `location:"uri" locationName:"missionProfileId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMissionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMissionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMissionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMissionProfileInput"}
	if s.MissionProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("MissionProfileId"))
	}
	if s.MissionProfileId != nil && len(*s.MissionProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MissionProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *DeleteMissionProfileInput) SetMissionProfileId(v string) *DeleteMissionProfileInput {
	s.MissionProfileId = &v
	return s
}

type DeleteMissionProfileOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`
}

// String returns the string representation
func (s DeleteMissionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMissionProfileOutput) GoString() string {
	return s.String()
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *DeleteMissionProfileOutput) SetMissionProfileId(v string) *DeleteMissionProfileOutput {
	s.MissionProfileId = &v
	return s
}

// Information about the demodulation Config.
type DemodulationConfig struct {
	_ struct{} `type:"structure"`

	// Unvalidated JSON of a demodulation Config.
	//
	// UnvalidatedJSON is a required field
	UnvalidatedJSON *string `locationName:"unvalidatedJSON" min:"2" type:"string" required:"true"`
}

// String returns the string representation
func (s DemodulationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DemodulationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DemodulationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DemodulationConfig"}
	if s.UnvalidatedJSON == nil {
		invalidParams.Add(request.NewErrParamRequired("UnvalidatedJSON"))
	}
	if s.UnvalidatedJSON != nil && len(*s.UnvalidatedJSON) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("UnvalidatedJSON", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnvalidatedJSON sets the UnvalidatedJSON field's value.
func (s *DemodulationConfig) SetUnvalidatedJSON(v string) *DemodulationConfig {
	s.UnvalidatedJSON = &v
	return s
}

// Dependency encountered an error.
type DependencyException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`

	ParameterName *string `locationName:"parameterName" type:"string"`
}

// String returns the string representation
func (s DependencyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DependencyException) GoString() string {
	return s.String()
}

func newErrorDependencyException(v protocol.ResponseMetadata) error {
	return &DependencyException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DependencyException) Code() string {
	return "DependencyException"
}

// Message returns the exception's message.
func (s DependencyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DependencyException) OrigErr() error {
	return nil
}

func (s DependencyException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s DependencyException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DependencyException) RequestID() string {
	return s.respMetadata.RequestID
}

type DescribeContactInput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	//
	// ContactId is a required field
	ContactId *string `location:"uri" locationName:"contactId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeContactInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactId sets the ContactId field's value.
func (s *DescribeContactInput) SetContactId(v string) *DescribeContactInput {
	s.ContactId = &v
	return s
}

type DescribeContactOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`

	// Status of a contact.
	ContactStatus *string `locationName:"contactStatus" type:"string" enum:"ContactStatus"`

	// End time of a contact.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Error message for a contact.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// Ground station for a contact.
	GroundStation *string `locationName:"groundStation" type:"string"`

	// Maximum elevation angle of a contact.
	MaximumElevation *Elevation `locationName:"maximumElevation" type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	PostPassEndTime *time.Time `locationName:"postPassEndTime" type:"timestamp"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	PrePassStartTime *time.Time `locationName:"prePassStartTime" type:"timestamp"`

	// Region of a contact.
	Region *string `locationName:"region" type:"string"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// Start time of a contact.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Tags assigned to a contact.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *DescribeContactOutput) SetContactId(v string) *DescribeContactOutput {
	s.ContactId = &v
	return s
}

// SetContactStatus sets the ContactStatus field's value.
func (s *DescribeContactOutput) SetContactStatus(v string) *DescribeContactOutput {
	s.ContactStatus = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeContactOutput) SetEndTime(v time.Time) *DescribeContactOutput {
	s.EndTime = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeContactOutput) SetErrorMessage(v string) *DescribeContactOutput {
	s.ErrorMessage = &v
	return s
}

// SetGroundStation sets the GroundStation field's value.
func (s *DescribeContactOutput) SetGroundStation(v string) *DescribeContactOutput {
	s.GroundStation = &v
	return s
}

// SetMaximumElevation sets the MaximumElevation field's value.
func (s *DescribeContactOutput) SetMaximumElevation(v *Elevation) *DescribeContactOutput {
	s.MaximumElevation = v
	return s
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *DescribeContactOutput) SetMissionProfileArn(v string) *DescribeContactOutput {
	s.MissionProfileArn = &v
	return s
}

// SetPostPassEndTime sets the PostPassEndTime field's value.
func (s *DescribeContactOutput) SetPostPassEndTime(v time.Time) *DescribeContactOutput {
	s.PostPassEndTime = &v
	return s
}

// SetPrePassStartTime sets the PrePassStartTime field's value.
func (s *DescribeContactOutput) SetPrePassStartTime(v time.Time) *DescribeContactOutput {
	s.PrePassStartTime = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DescribeContactOutput) SetRegion(v string) *DescribeContactOutput {
	s.Region = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *DescribeContactOutput) SetSatelliteArn(v string) *DescribeContactOutput {
	s.SatelliteArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeContactOutput) SetStartTime(v time.Time) *DescribeContactOutput {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeContactOutput) SetTags(v map[string]*string) *DescribeContactOutput {
	s.Tags = v
	return s
}

// Object that represents EIRP.
type Eirp struct {
	_ struct{} `type:"structure"`

	// Units of an EIRP.
	//
	// Units is a required field
	Units *string `locationName:"units" type:"string" required:"true" enum:"EirpUnits"`

	// Value of an EIRP.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Eirp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Eirp) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Eirp) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Eirp"}
	if s.Units == nil {
		invalidParams.Add(request.NewErrParamRequired("Units"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnits sets the Units field's value.
func (s *Eirp) SetUnits(v string) *Eirp {
	s.Units = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Eirp) SetValue(v float64) *Eirp {
	s.Value = &v
	return s
}

// Elevation angle of the satellite in the sky during a contact.
type Elevation struct {
	_ struct{} `type:"structure"`

	// Elevation angle units.
	//
	// Unit is a required field
	Unit *string `locationName:"unit" type:"string" required:"true" enum:"AngleUnits"`

	// Elevation angle value.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Elevation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Elevation) GoString() string {
	return s.String()
}

// SetUnit sets the Unit field's value.
func (s *Elevation) SetUnit(v string) *Elevation {
	s.Unit = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Elevation) SetValue(v float64) *Elevation {
	s.Value = &v
	return s
}

// Information about the endpoint details.
type EndpointDetails struct {
	_ struct{} `type:"structure"`

	// A dataflow endpoint.
	Endpoint *DataflowEndpoint `locationName:"endpoint" type:"structure"`

	// Endpoint security details.
	SecurityDetails *SecurityDetails `locationName:"securityDetails" type:"structure"`
}

// String returns the string representation
func (s EndpointDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EndpointDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EndpointDetails"}
	if s.Endpoint != nil {
		if err := s.Endpoint.Validate(); err != nil {
			invalidParams.AddNested("Endpoint", err.(request.ErrInvalidParams))
		}
	}
	if s.SecurityDetails != nil {
		if err := s.SecurityDetails.Validate(); err != nil {
			invalidParams.AddNested("SecurityDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpoint sets the Endpoint field's value.
func (s *EndpointDetails) SetEndpoint(v *DataflowEndpoint) *EndpointDetails {
	s.Endpoint = v
	return s
}

// SetSecurityDetails sets the SecurityDetails field's value.
func (s *EndpointDetails) SetSecurityDetails(v *SecurityDetails) *EndpointDetails {
	s.SecurityDetails = v
	return s
}

// Object that describes the frequency.
type Frequency struct {
	_ struct{} `type:"structure"`

	// Frequency units.
	//
	// Units is a required field
	Units *string `locationName:"units" type:"string" required:"true" enum:"FrequencyUnits"`

	// Frequency value.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s Frequency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Frequency) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Frequency) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Frequency"}
	if s.Units == nil {
		invalidParams.Add(request.NewErrParamRequired("Units"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnits sets the Units field's value.
func (s *Frequency) SetUnits(v string) *Frequency {
	s.Units = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Frequency) SetValue(v float64) *Frequency {
	s.Value = &v
	return s
}

// Object that describes the frequency bandwidth.
type FrequencyBandwidth struct {
	_ struct{} `type:"structure"`

	// Frequency bandwidth units.
	//
	// Units is a required field
	Units *string `locationName:"units" type:"string" required:"true" enum:"BandwidthUnits"`

	// Frequency bandwidth value.
	//
	// Value is a required field
	Value *float64 `locationName:"value" type:"double" required:"true"`
}

// String returns the string representation
func (s FrequencyBandwidth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FrequencyBandwidth) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrequencyBandwidth) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrequencyBandwidth"}
	if s.Units == nil {
		invalidParams.Add(request.NewErrParamRequired("Units"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUnits sets the Units field's value.
func (s *FrequencyBandwidth) SetUnits(v string) *FrequencyBandwidth {
	s.Units = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FrequencyBandwidth) SetValue(v float64) *FrequencyBandwidth {
	s.Value = &v
	return s
}

type GetConfigInput struct {
	_ struct{} `type:"structure"`

	// UUID of a Config.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"configId" type:"string" required:"true"`

	// Type of a Config.
	//
	// ConfigType is a required field
	ConfigType *string `location:"uri" locationName:"configType" type:"string" required:"true" enum:"ConfigCapabilityType"`
}

// String returns the string representation
func (s GetConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfigInput"}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}
	if s.ConfigType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigType"))
	}
	if s.ConfigType != nil && len(*s.ConfigType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigId sets the ConfigId field's value.
func (s *GetConfigInput) SetConfigId(v string) *GetConfigInput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *GetConfigInput) SetConfigType(v string) *GetConfigInput {
	s.ConfigType = &v
	return s
}

type GetConfigOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a Config
	//
	// ConfigArn is a required field
	ConfigArn *string `locationName:"configArn" type:"string" required:"true"`

	// Data elements in a Config.
	//
	// ConfigData is a required field
	ConfigData *ConfigTypeData `locationName:"configData" type:"structure" required:"true"`

	// UUID of a Config.
	//
	// ConfigId is a required field
	ConfigId *string `locationName:"configId" type:"string" required:"true"`

	// Type of a Config.
	ConfigType *string `locationName:"configType" type:"string" enum:"ConfigCapabilityType"`

	// Name of a Config.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Tags assigned to a Config.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetConfigOutput) GoString() string {
	return s.String()
}

// SetConfigArn sets the ConfigArn field's value.
func (s *GetConfigOutput) SetConfigArn(v string) *GetConfigOutput {
	s.ConfigArn = &v
	return s
}

// SetConfigData sets the ConfigData field's value.
func (s *GetConfigOutput) SetConfigData(v *ConfigTypeData) *GetConfigOutput {
	s.ConfigData = v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *GetConfigOutput) SetConfigId(v string) *GetConfigOutput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *GetConfigOutput) SetConfigType(v string) *GetConfigOutput {
	s.ConfigType = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetConfigOutput) SetName(v string) *GetConfigOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetConfigOutput) SetTags(v map[string]*string) *GetConfigOutput {
	s.Tags = v
	return s
}

type GetDataflowEndpointGroupInput struct {
	_ struct{} `type:"structure"`

	// UUID of a dataflow endpoint group.
	//
	// DataflowEndpointGroupId is a required field
	DataflowEndpointGroupId *string `location:"uri" locationName:"dataflowEndpointGroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDataflowEndpointGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataflowEndpointGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataflowEndpointGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataflowEndpointGroupInput"}
	if s.DataflowEndpointGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataflowEndpointGroupId"))
	}
	if s.DataflowEndpointGroupId != nil && len(*s.DataflowEndpointGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataflowEndpointGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *GetDataflowEndpointGroupInput) SetDataflowEndpointGroupId(v string) *GetDataflowEndpointGroupInput {
	s.DataflowEndpointGroupId = &v
	return s
}

type GetDataflowEndpointGroupOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a dataflow endpoint group.
	DataflowEndpointGroupArn *string `locationName:"dataflowEndpointGroupArn" type:"string"`

	// UUID of a dataflow endpoint group.
	DataflowEndpointGroupId *string `locationName:"dataflowEndpointGroupId" type:"string"`

	// Details of a dataflow endpoint.
	EndpointsDetails []*EndpointDetails `locationName:"endpointsDetails" type:"list"`

	// Tags assigned to a dataflow endpoint group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s GetDataflowEndpointGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataflowEndpointGroupOutput) GoString() string {
	return s.String()
}

// SetDataflowEndpointGroupArn sets the DataflowEndpointGroupArn field's value.
func (s *GetDataflowEndpointGroupOutput) SetDataflowEndpointGroupArn(v string) *GetDataflowEndpointGroupOutput {
	s.DataflowEndpointGroupArn = &v
	return s
}

// SetDataflowEndpointGroupId sets the DataflowEndpointGroupId field's value.
func (s *GetDataflowEndpointGroupOutput) SetDataflowEndpointGroupId(v string) *GetDataflowEndpointGroupOutput {
	s.DataflowEndpointGroupId = &v
	return s
}

// SetEndpointsDetails sets the EndpointsDetails field's value.
func (s *GetDataflowEndpointGroupOutput) SetEndpointsDetails(v []*EndpointDetails) *GetDataflowEndpointGroupOutput {
	s.EndpointsDetails = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDataflowEndpointGroupOutput) SetTags(v map[string]*string) *GetDataflowEndpointGroupOutput {
	s.Tags = v
	return s
}

type GetMinuteUsageInput struct {
	_ struct{} `type:"structure"`

	// The month being requested, with a value of 1-12.
	//
	// Month is a required field
	Month *int64 `locationName:"month" type:"integer" required:"true"`

	// The year being requested, in the format of YYYY.
	//
	// Year is a required field
	Year *int64 `locationName:"year" type:"integer" required:"true"`
}

// String returns the string representation
func (s GetMinuteUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMinuteUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMinuteUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMinuteUsageInput"}
	if s.Month == nil {
		invalidParams.Add(request.NewErrParamRequired("Month"))
	}
	if s.Year == nil {
		invalidParams.Add(request.NewErrParamRequired("Year"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonth sets the Month field's value.
func (s *GetMinuteUsageInput) SetMonth(v int64) *GetMinuteUsageInput {
	s.Month = &v
	return s
}

// SetYear sets the Year field's value.
func (s *GetMinuteUsageInput) SetYear(v int64) *GetMinuteUsageInput {
	s.Year = &v
	return s
}

type GetMinuteUsageOutput struct {
	_ struct{} `type:"structure"`

	// Estimated number of minutes remaining for an account, specific to the month
	// being requested.
	EstimatedMinutesRemaining *int64 `locationName:"estimatedMinutesRemaining" type:"integer"`

	// Returns whether or not an account has signed up for the reserved minutes
	// pricing plan, specific to the month being requested.
	IsReservedMinutesCustomer *bool `locationName:"isReservedMinutesCustomer" type:"boolean"`

	// Total number of reserved minutes allocated, specific to the month being requested.
	TotalReservedMinuteAllocation *int64 `locationName:"totalReservedMinuteAllocation" type:"integer"`

	// Total scheduled minutes for an account, specific to the month being requested.
	TotalScheduledMinutes *int64 `locationName:"totalScheduledMinutes" type:"integer"`

	// Upcoming minutes scheduled for an account, specific to the month being requested.
	UpcomingMinutesScheduled *int64 `locationName:"upcomingMinutesScheduled" type:"integer"`
}

// String returns the string representation
func (s GetMinuteUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMinuteUsageOutput) GoString() string {
	return s.String()
}

// SetEstimatedMinutesRemaining sets the EstimatedMinutesRemaining field's value.
func (s *GetMinuteUsageOutput) SetEstimatedMinutesRemaining(v int64) *GetMinuteUsageOutput {
	s.EstimatedMinutesRemaining = &v
	return s
}

// SetIsReservedMinutesCustomer sets the IsReservedMinutesCustomer field's value.
func (s *GetMinuteUsageOutput) SetIsReservedMinutesCustomer(v bool) *GetMinuteUsageOutput {
	s.IsReservedMinutesCustomer = &v
	return s
}

// SetTotalReservedMinuteAllocation sets the TotalReservedMinuteAllocation field's value.
func (s *GetMinuteUsageOutput) SetTotalReservedMinuteAllocation(v int64) *GetMinuteUsageOutput {
	s.TotalReservedMinuteAllocation = &v
	return s
}

// SetTotalScheduledMinutes sets the TotalScheduledMinutes field's value.
func (s *GetMinuteUsageOutput) SetTotalScheduledMinutes(v int64) *GetMinuteUsageOutput {
	s.TotalScheduledMinutes = &v
	return s
}

// SetUpcomingMinutesScheduled sets the UpcomingMinutesScheduled field's value.
func (s *GetMinuteUsageOutput) SetUpcomingMinutesScheduled(v int64) *GetMinuteUsageOutput {
	s.UpcomingMinutesScheduled = &v
	return s
}

type GetMissionProfileInput struct {
	_ struct{} `type:"structure"`

	// UUID of a mission profile.
	//
	// MissionProfileId is a required field
	MissionProfileId *string `location:"uri" locationName:"missionProfileId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMissionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMissionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMissionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMissionProfileInput"}
	if s.MissionProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("MissionProfileId"))
	}
	if s.MissionProfileId != nil && len(*s.MissionProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MissionProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *GetMissionProfileInput) SetMissionProfileId(v string) *GetMissionProfileInput {
	s.MissionProfileId = &v
	return s
}

type GetMissionProfileOutput struct {
	_ struct{} `type:"structure"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	ContactPostPassDurationSeconds *int64 `locationName:"contactPostPassDurationSeconds" min:"1" type:"integer"`

	// Amount of time prior to contact start you’d like to receive a CloudWatch
	// event indicating an upcoming pass.
	ContactPrePassDurationSeconds *int64 `locationName:"contactPrePassDurationSeconds" min:"1" type:"integer"`

	// A list of lists of ARNs. Each list of ARNs is an edge, with a from Config
	// and a to Config.
	DataflowEdges [][]*string `locationName:"dataflowEdges" type:"list"`

	// Smallest amount of time in seconds that you’d like to see for an available
	// contact. AWS Ground Station will not present you with contacts shorter than
	// this duration.
	MinimumViableContactDurationSeconds *int64 `locationName:"minimumViableContactDurationSeconds" min:"1" type:"integer"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`

	// Name of a mission profile.
	Name *string `locationName:"name" type:"string"`

	// Region of a mission profile.
	Region *string `locationName:"region" type:"string"`

	// Tags assigned to a mission profile.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// ARN of a tracking Config.
	TrackingConfigArn *string `locationName:"trackingConfigArn" type:"string"`
}

// String returns the string representation
func (s GetMissionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMissionProfileOutput) GoString() string {
	return s.String()
}

// SetContactPostPassDurationSeconds sets the ContactPostPassDurationSeconds field's value.
func (s *GetMissionProfileOutput) SetContactPostPassDurationSeconds(v int64) *GetMissionProfileOutput {
	s.ContactPostPassDurationSeconds = &v
	return s
}

// SetContactPrePassDurationSeconds sets the ContactPrePassDurationSeconds field's value.
func (s *GetMissionProfileOutput) SetContactPrePassDurationSeconds(v int64) *GetMissionProfileOutput {
	s.ContactPrePassDurationSeconds = &v
	return s
}

// SetDataflowEdges sets the DataflowEdges field's value.
func (s *GetMissionProfileOutput) SetDataflowEdges(v [][]*string) *GetMissionProfileOutput {
	s.DataflowEdges = v
	return s
}

// SetMinimumViableContactDurationSeconds sets the MinimumViableContactDurationSeconds field's value.
func (s *GetMissionProfileOutput) SetMinimumViableContactDurationSeconds(v int64) *GetMissionProfileOutput {
	s.MinimumViableContactDurationSeconds = &v
	return s
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *GetMissionProfileOutput) SetMissionProfileArn(v string) *GetMissionProfileOutput {
	s.MissionProfileArn = &v
	return s
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *GetMissionProfileOutput) SetMissionProfileId(v string) *GetMissionProfileOutput {
	s.MissionProfileId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetMissionProfileOutput) SetName(v string) *GetMissionProfileOutput {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *GetMissionProfileOutput) SetRegion(v string) *GetMissionProfileOutput {
	s.Region = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetMissionProfileOutput) SetTags(v map[string]*string) *GetMissionProfileOutput {
	s.Tags = v
	return s
}

// SetTrackingConfigArn sets the TrackingConfigArn field's value.
func (s *GetMissionProfileOutput) SetTrackingConfigArn(v string) *GetMissionProfileOutput {
	s.TrackingConfigArn = &v
	return s
}

type GetSatelliteInput struct {
	_ struct{} `type:"structure"`

	// UUID of a satellite.
	//
	// SatelliteId is a required field
	SatelliteId *string `location:"uri" locationName:"satelliteId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSatelliteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSatelliteInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSatelliteInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSatelliteInput"}
	if s.SatelliteId == nil {
		invalidParams.Add(request.NewErrParamRequired("SatelliteId"))
	}
	if s.SatelliteId != nil && len(*s.SatelliteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SatelliteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSatelliteId sets the SatelliteId field's value.
func (s *GetSatelliteInput) SetSatelliteId(v string) *GetSatelliteInput {
	s.SatelliteId = &v
	return s
}

type GetSatelliteOutput struct {
	_ struct{} `type:"structure"`

	// A list of ground stations to which the satellite is on-boarded.
	GroundStations []*string `locationName:"groundStations" type:"list"`

	// NORAD satellite ID number.
	NoradSatelliteID *int64 `locationName:"noradSatelliteID" min:"1" type:"integer"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// UUID of a satellite.
	SatelliteId *string `locationName:"satelliteId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetSatelliteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSatelliteOutput) GoString() string {
	return s.String()
}

// SetGroundStations sets the GroundStations field's value.
func (s *GetSatelliteOutput) SetGroundStations(v []*string) *GetSatelliteOutput {
	s.GroundStations = v
	return s
}

// SetNoradSatelliteID sets the NoradSatelliteID field's value.
func (s *GetSatelliteOutput) SetNoradSatelliteID(v int64) *GetSatelliteOutput {
	s.NoradSatelliteID = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *GetSatelliteOutput) SetSatelliteArn(v string) *GetSatelliteOutput {
	s.SatelliteArn = &v
	return s
}

// SetSatelliteId sets the SatelliteId field's value.
func (s *GetSatelliteOutput) SetSatelliteId(v string) *GetSatelliteOutput {
	s.SatelliteId = &v
	return s
}

// One or more parameters are not valid.
type InvalidParameterException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`

	ParameterName *string `locationName:"parameterName" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidParameterException) OrigErr() error {
	return nil
}

func (s InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidParameterException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidParameterException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListConfigsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of Configs returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token returned in the request of a previous ListConfigs call. Used to
	// get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfigsInput) SetMaxResults(v int64) *ListConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigsInput) SetNextToken(v string) *ListConfigsInput {
	s.NextToken = &v
	return s
}

type ListConfigsOutput struct {
	_ struct{} `type:"structure"`

	// List of Config items.
	ConfigList []*ConfigListItem `locationName:"configList" type:"list"`

	// Next token returned in the response of a previous ListConfigs call. Used
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListConfigsOutput) GoString() string {
	return s.String()
}

// SetConfigList sets the ConfigList field's value.
func (s *ListConfigsOutput) SetConfigList(v []*ConfigListItem) *ListConfigsOutput {
	s.ConfigList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfigsOutput) SetNextToken(v string) *ListConfigsOutput {
	s.NextToken = &v
	return s
}

type ListContactsInput struct {
	_ struct{} `type:"structure"`

	// End time of a contact.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// Name of a ground station.
	GroundStation *string `locationName:"groundStation" type:"string"`

	// Maximum number of contacts returned.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// Next token returned in the request of a previous ListContacts call. Used
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// Start time of a contact.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// Status of a contact reservation.
	//
	// StatusList is a required field
	StatusList []*string `locationName:"statusList" type:"list" required:"true"`
}

// String returns the string representation
func (s ListContactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContactsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListContactsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListContactsInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}
	if s.StatusList == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListContactsInput) SetEndTime(v time.Time) *ListContactsInput {
	s.EndTime = &v
	return s
}

// SetGroundStation sets the GroundStation field's value.
func (s *ListContactsInput) SetGroundStation(v string) *ListContactsInput {
	s.GroundStation = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListContactsInput) SetMaxResults(v int64) *ListContactsInput {
	s.MaxResults = &v
	return s
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *ListContactsInput) SetMissionProfileArn(v string) *ListContactsInput {
	s.MissionProfileArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsInput) SetNextToken(v string) *ListContactsInput {
	s.NextToken = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *ListContactsInput) SetSatelliteArn(v string) *ListContactsInput {
	s.SatelliteArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListContactsInput) SetStartTime(v time.Time) *ListContactsInput {
	s.StartTime = &v
	return s
}

// SetStatusList sets the StatusList field's value.
func (s *ListContactsInput) SetStatusList(v []*string) *ListContactsInput {
	s.StatusList = v
	return s
}

type ListContactsOutput struct {
	_ struct{} `type:"structure"`

	// List of contacts.
	ContactList []*ContactData `locationName:"contactList" type:"list"`

	// Next token returned in the response of a previous ListContacts call. Used
	// to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListContactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListContactsOutput) GoString() string {
	return s.String()
}

// SetContactList sets the ContactList field's value.
func (s *ListContactsOutput) SetContactList(v []*ContactData) *ListContactsOutput {
	s.ContactList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListContactsOutput) SetNextToken(v string) *ListContactsOutput {
	s.NextToken = &v
	return s
}

type ListDataflowEndpointGroupsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of dataflow endpoint groups returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token returned in the request of a previous ListDataflowEndpointGroups
	// call. Used to get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDataflowEndpointGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataflowEndpointGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataflowEndpointGroupsInput) SetMaxResults(v int64) *ListDataflowEndpointGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataflowEndpointGroupsInput) SetNextToken(v string) *ListDataflowEndpointGroupsInput {
	s.NextToken = &v
	return s
}

type ListDataflowEndpointGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of dataflow endpoint groups.
	DataflowEndpointGroupList []*DataflowEndpointListItem `locationName:"dataflowEndpointGroupList" type:"list"`

	// Next token returned in the response of a previous ListDataflowEndpointGroups
	// call. Used to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListDataflowEndpointGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDataflowEndpointGroupsOutput) GoString() string {
	return s.String()
}

// SetDataflowEndpointGroupList sets the DataflowEndpointGroupList field's value.
func (s *ListDataflowEndpointGroupsOutput) SetDataflowEndpointGroupList(v []*DataflowEndpointListItem) *ListDataflowEndpointGroupsOutput {
	s.DataflowEndpointGroupList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataflowEndpointGroupsOutput) SetNextToken(v string) *ListDataflowEndpointGroupsOutput {
	s.NextToken = &v
	return s
}

type ListGroundStationsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of ground stations returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token that can be supplied in the next call to get the next page of
	// ground stations.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Satellite ID to retrieve on-boarded ground stations.
	SatelliteId *string `location:"querystring" locationName:"satelliteId" type:"string"`
}

// String returns the string representation
func (s ListGroundStationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroundStationsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListGroundStationsInput) SetMaxResults(v int64) *ListGroundStationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroundStationsInput) SetNextToken(v string) *ListGroundStationsInput {
	s.NextToken = &v
	return s
}

// SetSatelliteId sets the SatelliteId field's value.
func (s *ListGroundStationsInput) SetSatelliteId(v string) *ListGroundStationsInput {
	s.SatelliteId = &v
	return s
}

type ListGroundStationsOutput struct {
	_ struct{} `type:"structure"`

	// List of ground stations.
	GroundStationList []*Data `locationName:"groundStationList" type:"list"`

	// Next token that can be supplied in the next call to get the next page of
	// ground stations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListGroundStationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroundStationsOutput) GoString() string {
	return s.String()
}

// SetGroundStationList sets the GroundStationList field's value.
func (s *ListGroundStationsOutput) SetGroundStationList(v []*Data) *ListGroundStationsOutput {
	s.GroundStationList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListGroundStationsOutput) SetNextToken(v string) *ListGroundStationsOutput {
	s.NextToken = &v
	return s
}

type ListMissionProfilesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of mission profiles returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token returned in the request of a previous ListMissionProfiles call.
	// Used to get the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMissionProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMissionProfilesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMissionProfilesInput) SetMaxResults(v int64) *ListMissionProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMissionProfilesInput) SetNextToken(v string) *ListMissionProfilesInput {
	s.NextToken = &v
	return s
}

type ListMissionProfilesOutput struct {
	_ struct{} `type:"structure"`

	// List of mission profiles.
	MissionProfileList []*MissionProfileListItem `locationName:"missionProfileList" type:"list"`

	// Next token returned in the response of a previous ListMissionProfiles call.
	// Used to get the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListMissionProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMissionProfilesOutput) GoString() string {
	return s.String()
}

// SetMissionProfileList sets the MissionProfileList field's value.
func (s *ListMissionProfilesOutput) SetMissionProfileList(v []*MissionProfileListItem) *ListMissionProfilesOutput {
	s.MissionProfileList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMissionProfilesOutput) SetNextToken(v string) *ListMissionProfilesOutput {
	s.NextToken = &v
	return s
}

type ListSatellitesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of satellites returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// Next token that can be supplied in the next call to get the next page of
	// satellites.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListSatellitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSatellitesInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSatellitesInput) SetMaxResults(v int64) *ListSatellitesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSatellitesInput) SetNextToken(v string) *ListSatellitesInput {
	s.NextToken = &v
	return s
}

type ListSatellitesOutput struct {
	_ struct{} `type:"structure"`

	// Next token that can be supplied in the next call to get the next page of
	// satellites.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of satellites.
	Satellites []*SatelliteListItem `locationName:"satellites" type:"list"`
}

// String returns the string representation
func (s ListSatellitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSatellitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSatellitesOutput) SetNextToken(v string) *ListSatellitesOutput {
	s.NextToken = &v
	return s
}

// SetSatellites sets the Satellites field's value.
func (s *ListSatellitesOutput) SetSatellites(v []*SatelliteListItem) *ListSatellitesOutput {
	s.Satellites = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of a resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags assigned to a resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Item in a list of mission profiles.
type MissionProfileListItem struct {
	_ struct{} `type:"structure"`

	// ARN of a mission profile.
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`

	// Name of a mission profile.
	Name *string `locationName:"name" type:"string"`

	// Region of a mission profile.
	Region *string `locationName:"region" type:"string"`
}

// String returns the string representation
func (s MissionProfileListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MissionProfileListItem) GoString() string {
	return s.String()
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *MissionProfileListItem) SetMissionProfileArn(v string) *MissionProfileListItem {
	s.MissionProfileArn = &v
	return s
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *MissionProfileListItem) SetMissionProfileId(v string) *MissionProfileListItem {
	s.MissionProfileId = &v
	return s
}

// SetName sets the Name field's value.
func (s *MissionProfileListItem) SetName(v string) *MissionProfileListItem {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *MissionProfileListItem) SetRegion(v string) *MissionProfileListItem {
	s.Region = &v
	return s
}

type ReserveContactInput struct {
	_ struct{} `type:"structure"`

	// End time of a contact.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" required:"true"`

	// Name of a ground station.
	//
	// GroundStation is a required field
	GroundStation *string `locationName:"groundStation" type:"string" required:"true"`

	// ARN of a mission profile.
	//
	// MissionProfileArn is a required field
	MissionProfileArn *string `locationName:"missionProfileArn" type:"string" required:"true"`

	// ARN of a satellite
	//
	// SatelliteArn is a required field
	SatelliteArn *string `locationName:"satelliteArn" type:"string" required:"true"`

	// Start time of a contact.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" required:"true"`

	// Tags assigned to a contact.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ReserveContactInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReserveContactInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReserveContactInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReserveContactInput"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.GroundStation == nil {
		invalidParams.Add(request.NewErrParamRequired("GroundStation"))
	}
	if s.MissionProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("MissionProfileArn"))
	}
	if s.SatelliteArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SatelliteArn"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ReserveContactInput) SetEndTime(v time.Time) *ReserveContactInput {
	s.EndTime = &v
	return s
}

// SetGroundStation sets the GroundStation field's value.
func (s *ReserveContactInput) SetGroundStation(v string) *ReserveContactInput {
	s.GroundStation = &v
	return s
}

// SetMissionProfileArn sets the MissionProfileArn field's value.
func (s *ReserveContactInput) SetMissionProfileArn(v string) *ReserveContactInput {
	s.MissionProfileArn = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *ReserveContactInput) SetSatelliteArn(v string) *ReserveContactInput {
	s.SatelliteArn = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ReserveContactInput) SetStartTime(v time.Time) *ReserveContactInput {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ReserveContactInput) SetTags(v map[string]*string) *ReserveContactInput {
	s.Tags = v
	return s
}

type ReserveContactOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a contact.
	ContactId *string `locationName:"contactId" type:"string"`
}

// String returns the string representation
func (s ReserveContactOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReserveContactOutput) GoString() string {
	return s.String()
}

// SetContactId sets the ContactId field's value.
func (s *ReserveContactOutput) SetContactId(v string) *ReserveContactOutput {
	s.ContactId = &v
	return s
}

// Account limits for this resource have been exceeded.
type ResourceLimitExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`

	ParameterName *string `locationName:"parameterName" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceLimitExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceLimitExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// Resource was not found.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Item in a list of satellites.
type SatelliteListItem struct {
	_ struct{} `type:"structure"`

	// A list of ground stations to which the satellite is on-boarded.
	GroundStations []*string `locationName:"groundStations" type:"list"`

	// NORAD satellite ID number.
	NoradSatelliteID *int64 `locationName:"noradSatelliteID" min:"1" type:"integer"`

	// ARN of a satellite.
	SatelliteArn *string `locationName:"satelliteArn" type:"string"`

	// UUID of a satellite.
	SatelliteId *string `locationName:"satelliteId" min:"1" type:"string"`
}

// String returns the string representation
func (s SatelliteListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SatelliteListItem) GoString() string {
	return s.String()
}

// SetGroundStations sets the GroundStations field's value.
func (s *SatelliteListItem) SetGroundStations(v []*string) *SatelliteListItem {
	s.GroundStations = v
	return s
}

// SetNoradSatelliteID sets the NoradSatelliteID field's value.
func (s *SatelliteListItem) SetNoradSatelliteID(v int64) *SatelliteListItem {
	s.NoradSatelliteID = &v
	return s
}

// SetSatelliteArn sets the SatelliteArn field's value.
func (s *SatelliteListItem) SetSatelliteArn(v string) *SatelliteListItem {
	s.SatelliteArn = &v
	return s
}

// SetSatelliteId sets the SatelliteId field's value.
func (s *SatelliteListItem) SetSatelliteId(v string) *SatelliteListItem {
	s.SatelliteId = &v
	return s
}

// Information about endpoints.
type SecurityDetails struct {
	_ struct{} `type:"structure"`

	// ARN to a role needed for connecting streams to your instances.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The security groups to attach to the elastic network interfaces.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list" required:"true"`

	// A list of subnets where AWS Ground Station places elastic network interfaces
	// to send streams to your instances.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`
}

// String returns the string representation
func (s SecurityDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityDetails) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SecurityDetails) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SecurityDetails"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *SecurityDetails) SetRoleArn(v string) *SecurityDetails {
	s.RoleArn = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *SecurityDetails) SetSecurityGroupIds(v []*string) *SecurityDetails {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *SecurityDetails) SetSubnetIds(v []*string) *SecurityDetails {
	s.SubnetIds = v
	return s
}

// Information about the socket address.
type SocketAddress struct {
	_ struct{} `type:"structure"`

	// Name of a socket address.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Port of a socket address.
	//
	// Port is a required field
	Port *int64 `locationName:"port" type:"integer" required:"true"`
}

// String returns the string representation
func (s SocketAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SocketAddress) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SocketAddress) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SocketAddress"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Port == nil {
		invalidParams.Add(request.NewErrParamRequired("Port"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SocketAddress) SetName(v string) *SocketAddress {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SocketAddress) SetPort(v int64) *SocketAddress {
	s.Port = &v
	return s
}

// Object that describes a spectral Config.
type SpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Bandwidth of a spectral Config.
	//
	// Bandwidth is a required field
	Bandwidth *FrequencyBandwidth `locationName:"bandwidth" type:"structure" required:"true"`

	// Center frequency of a spectral Config.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	// Polarization of a spectral Config.
	Polarization *string `locationName:"polarization" type:"string" enum:"Polarization"`
}

// String returns the string representation
func (s SpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SpectrumConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SpectrumConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SpectrumConfig"}
	if s.Bandwidth == nil {
		invalidParams.Add(request.NewErrParamRequired("Bandwidth"))
	}
	if s.CenterFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("CenterFrequency"))
	}
	if s.Bandwidth != nil {
		if err := s.Bandwidth.Validate(); err != nil {
			invalidParams.AddNested("Bandwidth", err.(request.ErrInvalidParams))
		}
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *SpectrumConfig) SetBandwidth(v *FrequencyBandwidth) *SpectrumConfig {
	s.Bandwidth = v
	return s
}

// SetCenterFrequency sets the CenterFrequency field's value.
func (s *SpectrumConfig) SetCenterFrequency(v *Frequency) *SpectrumConfig {
	s.CenterFrequency = v
	return s
}

// SetPolarization sets the Polarization field's value.
func (s *SpectrumConfig) SetPolarization(v string) *SpectrumConfig {
	s.Polarization = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of a resource tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Tags assigned to a resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Object that determines whether tracking should be used during a contact executed
// with this Config in the mission profile.
type TrackingConfig struct {
	_ struct{} `type:"structure"`

	// Current setting for autotrack.
	//
	// Autotrack is a required field
	Autotrack *string `locationName:"autotrack" type:"string" required:"true" enum:"Criticality"`
}

// String returns the string representation
func (s TrackingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrackingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrackingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrackingConfig"}
	if s.Autotrack == nil {
		invalidParams.Add(request.NewErrParamRequired("Autotrack"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutotrack sets the Autotrack field's value.
func (s *TrackingConfig) SetAutotrack(v string) *TrackingConfig {
	s.Autotrack = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ARN of a resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Keys of a resource tag.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateConfigInput struct {
	_ struct{} `type:"structure"`

	// Parameters of a Config.
	//
	// ConfigData is a required field
	ConfigData *ConfigTypeData `locationName:"configData" type:"structure" required:"true"`

	// UUID of a Config.
	//
	// ConfigId is a required field
	ConfigId *string `location:"uri" locationName:"configId" type:"string" required:"true"`

	// Type of a Config.
	//
	// ConfigType is a required field
	ConfigType *string `location:"uri" locationName:"configType" type:"string" required:"true" enum:"ConfigCapabilityType"`

	// Name of a Config.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfigInput"}
	if s.ConfigData == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigData"))
	}
	if s.ConfigId == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigId"))
	}
	if s.ConfigId != nil && len(*s.ConfigId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigId", 1))
	}
	if s.ConfigType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfigType"))
	}
	if s.ConfigType != nil && len(*s.ConfigType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfigType", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ConfigData != nil {
		if err := s.ConfigData.Validate(); err != nil {
			invalidParams.AddNested("ConfigData", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfigData sets the ConfigData field's value.
func (s *UpdateConfigInput) SetConfigData(v *ConfigTypeData) *UpdateConfigInput {
	s.ConfigData = v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *UpdateConfigInput) SetConfigId(v string) *UpdateConfigInput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *UpdateConfigInput) SetConfigType(v string) *UpdateConfigInput {
	s.ConfigType = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConfigInput) SetName(v string) *UpdateConfigInput {
	s.Name = &v
	return s
}

type UpdateConfigOutput struct {
	_ struct{} `type:"structure"`

	// ARN of a Config.
	ConfigArn *string `locationName:"configArn" type:"string"`

	// UUID of a Config.
	ConfigId *string `locationName:"configId" type:"string"`

	// Type of a Config.
	ConfigType *string `locationName:"configType" type:"string" enum:"ConfigCapabilityType"`
}

// String returns the string representation
func (s UpdateConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigOutput) GoString() string {
	return s.String()
}

// SetConfigArn sets the ConfigArn field's value.
func (s *UpdateConfigOutput) SetConfigArn(v string) *UpdateConfigOutput {
	s.ConfigArn = &v
	return s
}

// SetConfigId sets the ConfigId field's value.
func (s *UpdateConfigOutput) SetConfigId(v string) *UpdateConfigOutput {
	s.ConfigId = &v
	return s
}

// SetConfigType sets the ConfigType field's value.
func (s *UpdateConfigOutput) SetConfigType(v string) *UpdateConfigOutput {
	s.ConfigType = &v
	return s
}

type UpdateMissionProfileInput struct {
	_ struct{} `type:"structure"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	ContactPostPassDurationSeconds *int64 `locationName:"contactPostPassDurationSeconds" min:"1" type:"integer"`

	// Amount of time after a contact ends that you’d like to receive a CloudWatch
	// event indicating the pass has finished.
	ContactPrePassDurationSeconds *int64 `locationName:"contactPrePassDurationSeconds" min:"1" type:"integer"`

	// A list of lists of ARNs. Each list of ARNs is an edge, with a from Config
	// and a to Config.
	DataflowEdges [][]*string `locationName:"dataflowEdges" type:"list"`

	// Smallest amount of time in seconds that you’d like to see for an available
	// contact. AWS Ground Station will not present you with contacts shorter than
	// this duration.
	MinimumViableContactDurationSeconds *int64 `locationName:"minimumViableContactDurationSeconds" min:"1" type:"integer"`

	// UUID of a mission profile.
	//
	// MissionProfileId is a required field
	MissionProfileId *string `location:"uri" locationName:"missionProfileId" type:"string" required:"true"`

	// Name of a mission profile.
	Name *string `locationName:"name" min:"1" type:"string"`

	// ARN of a tracking Config.
	TrackingConfigArn *string `locationName:"trackingConfigArn" type:"string"`
}

// String returns the string representation
func (s UpdateMissionProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMissionProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMissionProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMissionProfileInput"}
	if s.ContactPostPassDurationSeconds != nil && *s.ContactPostPassDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ContactPostPassDurationSeconds", 1))
	}
	if s.ContactPrePassDurationSeconds != nil && *s.ContactPrePassDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ContactPrePassDurationSeconds", 1))
	}
	if s.MinimumViableContactDurationSeconds != nil && *s.MinimumViableContactDurationSeconds < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumViableContactDurationSeconds", 1))
	}
	if s.MissionProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("MissionProfileId"))
	}
	if s.MissionProfileId != nil && len(*s.MissionProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MissionProfileId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactPostPassDurationSeconds sets the ContactPostPassDurationSeconds field's value.
func (s *UpdateMissionProfileInput) SetContactPostPassDurationSeconds(v int64) *UpdateMissionProfileInput {
	s.ContactPostPassDurationSeconds = &v
	return s
}

// SetContactPrePassDurationSeconds sets the ContactPrePassDurationSeconds field's value.
func (s *UpdateMissionProfileInput) SetContactPrePassDurationSeconds(v int64) *UpdateMissionProfileInput {
	s.ContactPrePassDurationSeconds = &v
	return s
}

// SetDataflowEdges sets the DataflowEdges field's value.
func (s *UpdateMissionProfileInput) SetDataflowEdges(v [][]*string) *UpdateMissionProfileInput {
	s.DataflowEdges = v
	return s
}

// SetMinimumViableContactDurationSeconds sets the MinimumViableContactDurationSeconds field's value.
func (s *UpdateMissionProfileInput) SetMinimumViableContactDurationSeconds(v int64) *UpdateMissionProfileInput {
	s.MinimumViableContactDurationSeconds = &v
	return s
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *UpdateMissionProfileInput) SetMissionProfileId(v string) *UpdateMissionProfileInput {
	s.MissionProfileId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateMissionProfileInput) SetName(v string) *UpdateMissionProfileInput {
	s.Name = &v
	return s
}

// SetTrackingConfigArn sets the TrackingConfigArn field's value.
func (s *UpdateMissionProfileInput) SetTrackingConfigArn(v string) *UpdateMissionProfileInput {
	s.TrackingConfigArn = &v
	return s
}

type UpdateMissionProfileOutput struct {
	_ struct{} `type:"structure"`

	// UUID of a mission profile.
	MissionProfileId *string `locationName:"missionProfileId" type:"string"`
}

// String returns the string representation
func (s UpdateMissionProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMissionProfileOutput) GoString() string {
	return s.String()
}

// SetMissionProfileId sets the MissionProfileId field's value.
func (s *UpdateMissionProfileOutput) SetMissionProfileId(v string) *UpdateMissionProfileOutput {
	s.MissionProfileId = &v
	return s
}

// Information about an uplink echo Config.
//
// Parameters from the AntennaUplinkConfig, corresponding to the specified AntennaUplinkConfigArn,
// are used when this UplinkEchoConfig is used in a contact.
type UplinkEchoConfig struct {
	_ struct{} `type:"structure"`

	// ARN of an uplink Config.
	//
	// AntennaUplinkConfigArn is a required field
	AntennaUplinkConfigArn *string `locationName:"antennaUplinkConfigArn" type:"string" required:"true"`

	// Whether or not an uplink Config is enabled.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`
}

// String returns the string representation
func (s UplinkEchoConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UplinkEchoConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkEchoConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UplinkEchoConfig"}
	if s.AntennaUplinkConfigArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AntennaUplinkConfigArn"))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAntennaUplinkConfigArn sets the AntennaUplinkConfigArn field's value.
func (s *UplinkEchoConfig) SetAntennaUplinkConfigArn(v string) *UplinkEchoConfig {
	s.AntennaUplinkConfigArn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UplinkEchoConfig) SetEnabled(v bool) *UplinkEchoConfig {
	s.Enabled = &v
	return s
}

// Information about the uplink spectral Config.
type UplinkSpectrumConfig struct {
	_ struct{} `type:"structure"`

	// Center frequency of an uplink spectral Config.
	//
	// CenterFrequency is a required field
	CenterFrequency *Frequency `locationName:"centerFrequency" type:"structure" required:"true"`

	// Polarization of an uplink spectral Config.
	Polarization *string `locationName:"polarization" type:"string" enum:"Polarization"`
}

// String returns the string representation
func (s UplinkSpectrumConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UplinkSpectrumConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UplinkSpectrumConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UplinkSpectrumConfig"}
	if s.CenterFrequency == nil {
		invalidParams.Add(request.NewErrParamRequired("CenterFrequency"))
	}
	if s.CenterFrequency != nil {
		if err := s.CenterFrequency.Validate(); err != nil {
			invalidParams.AddNested("CenterFrequency", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCenterFrequency sets the CenterFrequency field's value.
func (s *UplinkSpectrumConfig) SetCenterFrequency(v *Frequency) *UplinkSpectrumConfig {
	s.CenterFrequency = v
	return s
}

// SetPolarization sets the Polarization field's value.
func (s *UplinkSpectrumConfig) SetPolarization(v string) *UplinkSpectrumConfig {
	s.Polarization = &v
	return s
}

const (
	// AngleUnitsDegreeAngle is a AngleUnits enum value
	AngleUnitsDegreeAngle = "DEGREE_ANGLE"

	// AngleUnitsRadian is a AngleUnits enum value
	AngleUnitsRadian = "RADIAN"
)

const (
	// BandwidthUnitsGhz is a BandwidthUnits enum value
	BandwidthUnitsGhz = "GHz"

	// BandwidthUnitsMhz is a BandwidthUnits enum value
	BandwidthUnitsMhz = "MHz"

	// BandwidthUnitsKHz is a BandwidthUnits enum value
	BandwidthUnitsKHz = "kHz"
)

const (
	// ConfigCapabilityTypeAntennaDownlink is a ConfigCapabilityType enum value
	ConfigCapabilityTypeAntennaDownlink = "antenna-downlink"

	// ConfigCapabilityTypeAntennaDownlinkDemodDecode is a ConfigCapabilityType enum value
	ConfigCapabilityTypeAntennaDownlinkDemodDecode = "antenna-downlink-demod-decode"

	// ConfigCapabilityTypeAntennaUplink is a ConfigCapabilityType enum value
	ConfigCapabilityTypeAntennaUplink = "antenna-uplink"

	// ConfigCapabilityTypeDataflowEndpoint is a ConfigCapabilityType enum value
	ConfigCapabilityTypeDataflowEndpoint = "dataflow-endpoint"

	// ConfigCapabilityTypeTracking is a ConfigCapabilityType enum value
	ConfigCapabilityTypeTracking = "tracking"

	// ConfigCapabilityTypeUplinkEcho is a ConfigCapabilityType enum value
	ConfigCapabilityTypeUplinkEcho = "uplink-echo"
)

const (
	// ContactStatusAvailable is a ContactStatus enum value
	ContactStatusAvailable = "AVAILABLE"

	// ContactStatusAwsCancelled is a ContactStatus enum value
	ContactStatusAwsCancelled = "AWS_CANCELLED"

	// ContactStatusCancelled is a ContactStatus enum value
	ContactStatusCancelled = "CANCELLED"

	// ContactStatusCancelling is a ContactStatus enum value
	ContactStatusCancelling = "CANCELLING"

	// ContactStatusCompleted is a ContactStatus enum value
	ContactStatusCompleted = "COMPLETED"

	// ContactStatusFailed is a ContactStatus enum value
	ContactStatusFailed = "FAILED"

	// ContactStatusFailedToSchedule is a ContactStatus enum value
	ContactStatusFailedToSchedule = "FAILED_TO_SCHEDULE"

	// ContactStatusPass is a ContactStatus enum value
	ContactStatusPass = "PASS"

	// ContactStatusPostpass is a ContactStatus enum value
	ContactStatusPostpass = "POSTPASS"

	// ContactStatusPrepass is a ContactStatus enum value
	ContactStatusPrepass = "PREPASS"

	// ContactStatusScheduled is a ContactStatus enum value
	ContactStatusScheduled = "SCHEDULED"

	// ContactStatusScheduling is a ContactStatus enum value
	ContactStatusScheduling = "SCHEDULING"
)

const (
	// CriticalityPreferred is a Criticality enum value
	CriticalityPreferred = "PREFERRED"

	// CriticalityRemoved is a Criticality enum value
	CriticalityRemoved = "REMOVED"

	// CriticalityRequired is a Criticality enum value
	CriticalityRequired = "REQUIRED"
)

const (
	// EirpUnitsDBw is a EirpUnits enum value
	EirpUnitsDBw = "dBW"
)

const (
	// EndpointStatusCreated is a EndpointStatus enum value
	EndpointStatusCreated = "created"

	// EndpointStatusCreating is a EndpointStatus enum value
	EndpointStatusCreating = "creating"

	// EndpointStatusDeleted is a EndpointStatus enum value
	EndpointStatusDeleted = "deleted"

	// EndpointStatusDeleting is a EndpointStatus enum value
	EndpointStatusDeleting = "deleting"

	// EndpointStatusFailed is a EndpointStatus enum value
	EndpointStatusFailed = "failed"
)

const (
	// FrequencyUnitsGhz is a FrequencyUnits enum value
	FrequencyUnitsGhz = "GHz"

	// FrequencyUnitsMhz is a FrequencyUnits enum value
	FrequencyUnitsMhz = "MHz"

	// FrequencyUnitsKHz is a FrequencyUnits enum value
	FrequencyUnitsKHz = "kHz"
)

const (
	// PolarizationLeftHand is a Polarization enum value
	PolarizationLeftHand = "LEFT_HAND"

	// PolarizationNone is a Polarization enum value
	PolarizationNone = "NONE"

	// PolarizationRightHand is a Polarization enum value
	PolarizationRightHand = "RIGHT_HAND"
)
