/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.maven.jline.MessageUtils;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

@Deprecated
public abstract class AbstractMavenTransferListener
extends AbstractTransferListener {
    private static final String ESC = "\u001b";
    private static final String ANSI_DARK_SET = "\u001b[90m";
    private static final String ANSI_DARK_RESET = "\u001b[0m";
    protected PrintStream out;

    protected AbstractMavenTransferListener(PrintStream out) {
        this.out = out;
    }

    public void transferInitiated(TransferEvent event) {
        String darkOn = MessageUtils.isColorEnabled() ? ANSI_DARK_SET : "";
        String darkOff = MessageUtils.isColorEnabled() ? ANSI_DARK_RESET : "";
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        StringBuilder message = new StringBuilder();
        message.append(darkOn).append(action).append(' ').append(direction).append(' ');
        message.append(darkOff).append(resource.getRepositoryId());
        message.append(darkOn).append(": ").append(resource.getRepositoryUrl());
        message.append(darkOff).append(resource.getResourceName());
        this.out.println(message.toString());
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.out.println("[WARNING] " + event.getException().getMessage() + " from " + resource.getRepositoryId() + " for " + resource.getRepositoryUrl() + resource.getResourceName());
    }

    public void transferSucceeded(TransferEvent event) {
        String darkOn = MessageUtils.isColorEnabled() ? ANSI_DARK_SET : "";
        String darkOff = MessageUtils.isColorEnabled() ? ANSI_DARK_RESET : "";
        String action = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
        String direction = event.getRequestType() == TransferEvent.RequestType.PUT ? "to" : "from";
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        FileSizeFormat format = new FileSizeFormat(Locale.ENGLISH);
        StringBuilder message = new StringBuilder();
        message.append(action).append(darkOn).append(' ').append(direction).append(' ');
        message.append(darkOff).append(resource.getRepositoryId());
        message.append(darkOn).append(": ").append(resource.getRepositoryUrl());
        message.append(darkOff).append(resource.getResourceName());
        message.append(darkOn).append(" (").append(format.format(contentLength));
        long duration = System.currentTimeMillis() - resource.getTransferStartTime();
        if (duration > 0L) {
            double bytesPerSecond = (double)contentLength / ((double)duration / 1000.0);
            message.append(" at ").append(format.format((long)bytesPerSecond)).append("/s");
        }
        message.append(')').append(darkOff);
        this.out.println(message.toString());
    }

    static class FileSizeFormat {
        private DecimalFormat smallFormat;
        private DecimalFormat largeFormat;

        FileSizeFormat(Locale locale) {
            this.smallFormat = new DecimalFormat("#0.0", new DecimalFormatSymbols(locale));
            this.largeFormat = new DecimalFormat("###0", new DecimalFormatSymbols(locale));
        }

        public String format(long size) {
            return this.format(size, null);
        }

        public String format(long size, ScaleUnit unit) {
            return this.format(size, unit, false);
        }

        public String format(long size, ScaleUnit unit, boolean omitSymbol) {
            if (size < 0L) {
                throw new IllegalArgumentException("file size cannot be negative: " + size);
            }
            if (unit == null) {
                unit = ScaleUnit.getScaleUnit(size);
            }
            double scaledSize = (double)size / (double)unit.bytes();
            Object scaledSymbol = " " + unit.symbol();
            if (omitSymbol) {
                scaledSymbol = "";
            }
            if (unit == ScaleUnit.BYTE) {
                return this.largeFormat.format(size) + (String)scaledSymbol;
            }
            if (scaledSize < 0.05 || scaledSize >= 10.0) {
                return this.largeFormat.format(scaledSize) + (String)scaledSymbol;
            }
            return this.smallFormat.format(scaledSize) + (String)scaledSymbol;
        }

        public String formatProgress(long progressedSize, long size) {
            if (progressedSize < 0L) {
                throw new IllegalArgumentException("progressed file size cannot be negative: " + progressedSize);
            }
            if (size >= 0L && progressedSize > size) {
                throw new IllegalArgumentException("progressed file size cannot be greater than size: " + progressedSize + " > " + size);
            }
            if (size >= 0L && progressedSize != size) {
                ScaleUnit unit = ScaleUnit.getScaleUnit(size);
                String formattedProgressedSize = this.format(progressedSize, unit, true);
                String formattedSize = this.format(size, unit);
                return formattedProgressedSize + "/" + formattedSize;
            }
            return this.format(progressedSize);
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        static enum ScaleUnit {
            BYTE{

                @Override
                public long bytes() {
                    return 1L;
                }

                @Override
                public String symbol() {
                    return "B";
                }
            }
            ,
            KILOBYTE{

                @Override
                public long bytes() {
                    return 1000L;
                }

                @Override
                public String symbol() {
                    return "kB";
                }
            }
            ,
            MEGABYTE{

                @Override
                public long bytes() {
                    return KILOBYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "MB";
                }
            }
            ,
            GIGABYTE{

                @Override
                public long bytes() {
                    return MEGABYTE.bytes() * KILOBYTE.bytes();
                }

                @Override
                public String symbol() {
                    return "GB";
                }
            };


            public abstract long bytes();

            public abstract String symbol();

            public static ScaleUnit getScaleUnit(long size) {
                if (size < 0L) {
                    throw new IllegalArgumentException("file size cannot be negative: " + size);
                }
                if (size >= GIGABYTE.bytes()) {
                    return GIGABYTE;
                }
                if (size >= MEGABYTE.bytes()) {
                    return MEGABYTE;
                }
                if (size >= KILOBYTE.bytes()) {
                    return KILOBYTE;
                }
                return BYTE;
            }
        }
    }
}

