/* -*- mode: c; c-basic-offset: 4; -*- */
#include "nds_matlab_config.h"

#include "nds_os.h"

#include <mex.h>

#if _WIN32
#define SNPRINTF sprintf_s
#else
#define SNPRINTF snprintf
#endif

#define MAX_HOST_LENGTH 256
#define _STRINGIFY(arg) #arg
#define STRINGIFY(arg) _STRINGIFY(arg)

/*
 * In MATLAB 2006b a.k.a. 7.2.0, MATLAB added two typedefs, mwSize and mwIndex.
 * Before 2006b, most places where mwSize and mwIndex were used were ints, but
 * in 2006b they become size_t or int if a 32-bit compatibility flag
 * (MX_COMPAT_32) was turned on.
 *
 * In Octave, mwSize and mwIndex are always typedef'd as int.
 */
#ifdef MX_API_VER
#if MX_API_VER < 0x07030000
typedef int mwSize;
typedef int mwIndex;
#if (!defined(SIZEOF_MWSIZE)) || (SIZEOF_MWSIZE == 0)
#undef  SIZEOF_MWSIZE
#define SIZEOF_MWSIZE SIZEOF_INT
#endif
#endif
#endif

/*  Copy the contents of the specfied field of an input array to the 
 *  specified field of the output array
 */
void copy_mxarray(const mxArray* iarray, int ifield, mwSize inx, 
		  mxArray* oarray, int ofield, mwSize oinx);

/*  Get the specified integer data item from the array.
 */
int get_mxarray_int(const mxArray* array, int field, mwSize inx);

/*  Get the specified float data item from the array.
 */
double get_mxarray_float(const mxArray* array, int field, mwSize inx);

/*  Parse the server name specifier into a hostname and port number.
 *  The server name specifier is split at the first occurrence of a
 *  colon ':', if any, by replacing it with a null character '\0'.
 *  If the string contained a colon, then port is set to its integer
 *  conversion or 0 if the conversion fails.
 */
void parse_host_name(char* in, short* port);

/*  Put the specified bool (logical) data into the array.
 */
int put_mxarray_bool(mxArray* array, int field, mwSize inx, int val);

/*  Put the specified double data into the array.
 */
int put_mxarray_double(mxArray* array, int field, mwSize inx, double val);

/*  Put the specified float data into the array.
 */
int put_mxarray_float(mxArray* array, int field, mwSize inx, float val);

/*  Put the specified int data into the array.
 */
int put_mxarray_int(mxArray* array, int field, mwSize inx, int val);

/*  Put the specified int data into the array.
 */
int put_mxarray_str(mxArray* array, int field, mwSize inx, const char* val);

void stride_copy( void* dest, void* src, mwSize n, mwSize stride );

