#!/usr/bin/env python

#
# Copyright (C) 2015 LIGO Lab
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

import json
import optparse
import os
import shutil
import socket
#import stat
import subprocess
import sys
import threading
import tempfile

import replay

scripts = {}

def run_script(conn, test_name):
	global scripts

	try:
		f = conn.makefile()
		scripts[test_name](f, f)
	except replay.CloseButNoAbort:
				print "Closing connection, test not complete however"
	finally:
		conn.close()

def make_addr(addr):
	host, port = addr.split(':', 1)
	return (host, int(port))

def listen(s):
	try:
		while True:
			s.listen(2)
			conn, addr = s.accept()
			print "Connection from %s running %s" % (str(addr), options.test_name)
			#try:
			#	run_script(conn, options.test_name)
			#finally:
			#	conn.close()
			serve_thread = threading.Thread(target = run_script, args=(conn, options.test_name))
			serve_thread.daemon = True
			serve_thread.start()
	finally:
		s.shutdown()
		s.close()


parser = optparse.OptionParser()
parser.disable_interspersed_args()
parser.add_option('-l', '--listen', help="address:port to listen on.  [%default]", action="store", type="string", dest="listen_addr", default="127.0.0.1:0")
parser.add_option('-i', '--input', help="script file to load [%default]", action="store", type="string", dest="script_file", default="script.json")
parser.add_option('-t', '--name', help="The name of the test to run [%default]", action="store", type="string", dest="test_name", default="recorded_script")

(options, args) = parser.parse_args()
listen_addr = make_addr(options.listen_addr)

s = socket.socket(socket.AF_INET, socket.SOCK_STREAM, socket.IPPROTO_TCP)
s.bind(listen_addr)
host, port = s.getsockname()
print 'Test server listening on %s:%d' % (host, port)
with open(options.script_file, "rt") as f:
	scripts = replay.load_scripts(f)

listen_as_daemon = False
if not args == []:
	listen_as_daemon = True

listen_thread = threading.Thread(target = listen, args=(s,))
listen_thread.daemon = listen_as_daemon
listen_thread.start()

if not args == []:
	os.environ['NDS_TEST_HOST'] = str(host)
	os.environ['NDS_TEST_PORT'] = str(port)
	db_dir = tempfile.mkdtemp()
	try:
	    os.environ['NDS2_CHANNEL_DB_DIR'] = db_dir
	    print 'Testing with read-writable database...'
	    status = subprocess.call(args)
	    #if status == 0:
	    #    for filename in os.listdir(db_dir):
	    #        os.chmod(os.path.join(db_dir, filename), stat.S_IREAD)
	    #    print 'Testing with read-only database...'
	    #    status = subprocess.call(args)
	finally:
	    shutil.rmtree(db_dir)
	sys.exit(status)
#else:
#	listen(s)

