<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/ilert/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/ilert/metadata.yaml"
sidebar_label: "ilert"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# ilert


<img src="https://netdata.cloud/img/ilert.svg" width="150"/>


ilert is an alerting and incident management tool. It helps teams reduce response times by enhancing monitoring and ticketing tools with reliable alerts, automatic escalations, on-call schedules, and features for incident response, communication, and status updates.
Sending notification to ilert via Netdata's Agent alert notification feature includes links, images and resolving of corresponding alerts.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup


### Prerequisites

#### 

- A Netdata alert source in ilert. You can create a [Netdata alert source](https://docs.ilert.com/inbound-integrations/netdata) in [ilert](https://www.ilert.com/).
- Access to the terminal where Netdata Agent is running



### Configuration

#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| SEND_ILERT | Set `SEND_ILERT` to YES | YES | yes |
| ILERT_ALERT_SOURCE_URL | Set `ILERT_ALERT_SOURCE_URL` to your Netdata alert source url in ilert. |  | yes |


</details>



#### via File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```

##### Examples

###### Basic Configuration



```yaml
SEND_ILERT="YES"
ILERT_ALERT_SOURCE_URL="https://api.ilert.com/api/v1/events/netdata/{API-KEY}"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


