<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/x509check/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/x509check/metadata.yaml"
sidebar_label: "X.509 certificate"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Synthetic Checks"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# X.509 certificate


<img src="https://netdata.cloud/img/lock.svg" width="150"/>


Plugin: go.d.plugin
Module: x509check

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview



This collectors monitors x509 certificates expiration time and revocation status.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per source

These metrics refer to the SSL certificate.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| source | Same as the "source" configuration option. |
| common_name | The common name (CN) extracted from the certificate. |
| depth | The depth of the certificate within the certificate chain. The leaf certificate has a depth of 0, and subsequent certificates (intermediate certificates) have increasing depth values. The root certificate is at the highest depth. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| x509check.time_until_expiration | expiry | seconds |
| x509check.revocation_status | not_revoked, revoked | boolean |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ x509check_days_until_expiration ](https://github.com/netdata/netdata/blob/master/src/health/health.d/x509check.conf) | x509check.time_until_expiration | SSL cert expiring soon (${label:source} cn:${label:common_name}) |
| [ x509check_revocation_status ](https://github.com/netdata/netdata/blob/master/src/health/health.d/x509check.conf) | x509check.revocation_status | SSL cert revoked (${label:source}) |


## Setup


You can configure the **x509check** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **x509check**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/x509check.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | source | Certificate source. Allowed schemes: https, tcp, tcp4, tcp6, udp, udp4, udp6, file, smtp. |  | no |
|  | timeout | SSL connection timeout (seconds). | 2 | no |
| **Validation** | check_full_chain | Monitor expiration time for all certificates in the chain (including intermediates and root). | no | no |
|  | check_revocation_status | Check the revocation status of the certificate. | no | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **x509check** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the x509check data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _x509check_ (or scroll the list) to locate the **x509check** collector.
5. Click the **+** next to the **x509check** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/x509check.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/x509check.conf
```

##### Examples

###### Website certificate

Website certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_site_cert
    source: https://my_site.org:443

```
</details>

###### Local file certificate

Local file certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_file_cert
    source: file:///home/me/cert.pem

```
</details>

###### SMTP certificate

SMTP certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_smtp_cert
    source: smtp://smtp.my_mail.org:587

```
</details>

###### Multi-instance

> **Note**: When you define more than one job, their names must be unique.

Check the expiration status of the multiple websites' certificates.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: my_site_cert1
    source: https://my_site1.org:443

  - name: my_site_cert2
    source: https://my_site1.org:443

  - name: my_site_cert3
    source: https://my_site3.org:443

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `x509check` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m x509check
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m x509check -j jobName
  ```

### Getting Logs

If you're encountering problems with the `x509check` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep x509check
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep x509check /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep x509check
```


