(**
  * Library for decoding AAC and AAC+ streams.
  *
  * @author Samuel Mimram
  *)

(** Internal state of a decoder. *)
type t

(** An error occured... *)
exception Error of int

(** Get the error message corresponding to a raised [Error]. *)
val get_error_message : int -> string

(** Create a new decoder. *)
val create : unit -> t

(** Close a decoder. *)
val close : t -> unit

(** [init dec buf ofs len] initializes a decoder given the [len] bytes of data
  * in [buf] starting at offset [ofs]. It returns the samplerate and the number
  * of channels of the stream.
  *)
val init : t -> string -> int -> int -> int * int

(** [decode dec buf ofs len] decodes at most [len] bytes of data in [buf]
  * starting at offset [ofs]. It returns the number of bytes actually decoded
  * and the decoded data (non-interleaved).
  *)
val decode : t -> string -> int -> int -> int * (float array array)

(** Heuristic guess of the offset of the begining of a frame. *)
val find_frame : string -> int
