(* $Id: hydro_string.mli 17191 2008-03-28 00:11:27Z gerd $ *)

(** Parse/print various data structures as strings *)

(** The syntax of the string representations is defined in the
    ICE manual.
 *)

val identity_of_string : string -> Hydro_types.identity
val string_of_identity : Hydro_types.identity -> string

val endpoints_of_string : string -> Hydro_types.endpoint array
val string_of_endpoints : Hydro_types.endpoint array -> string

val proxy_addr_of_string : string -> Hydro_types.proxy_addr
val string_of_proxy_addr : Hydro_types.proxy_addr -> string

