(*
  FreeTDS interface for OCamlDBI.
  Copyright (C) 2004 Kenneth Knowles
  
  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)


type recordset = {
    rs_names : string array;
    rs_rows : Dbi.sql_t array array;
}

(* Note the extended methods rs_* *)
class statement :
    connection ->
    Ct.command ->
  object
    method connection : Dbi.connection
    method execute : Dbi.sql_t list -> unit
    method fetch1 : unit -> Dbi.sql_t list
    method fetch1hash : unit -> (string * Dbi.sql_t) list
    method fetch1int : unit -> int
    method fetch1string : unit -> string
    method fetchall : unit -> Dbi.sql_t list list
    method finish : unit -> unit
    method fold_left : ('a -> Dbi.sql_t list -> 'a) -> 'a -> 'a
    method fold_right : (Dbi.sql_t list -> 'b -> 'b) -> 'b -> 'b
    method iter : (Dbi.sql_t list -> unit) -> unit
    method map : (Dbi.sql_t list -> 'c) -> 'c list
    method names : string list
    method serial : string -> int

    method rs_count : int
    method rs_fetch_nth : int -> recordset
    method rs_fetch_all : recordset list
  end
  

(* Note the extended methods:
   set_debug_level
   debug_level
   ex_multi
   raw_connection *)
and connection :
  ?host:string ->
  ?port:string ->
  ?user:string ->
  ?password:string ->
  string ->
object
  method close : unit -> unit
  method closed : bool
  method commit : unit -> unit
  method database : string
  method database_type : string
  method debug : bool
  method debug_level : int
  method ex : string -> Dbi.sql_t list -> Dbi.statement
  method ex_multi : string -> Dbi.sql_t list -> statement
  method host : string option
  method id : int
  method password : string option
  method ping : unit -> bool
  method port : string option
  method prepare : string -> Dbi.statement
  method prepare_cached : string -> Dbi.statement
  method raw_connection : Ct.connection
  method register_postrollback : (unit -> unit) -> Dbi.postrollback_handle
  method register_precommit : (unit -> unit) -> Dbi.precommit_handle
  method rollback : unit -> unit
  method set_debug : bool -> unit
  method set_debug_level : int -> unit
  method unregister_postrollback : Dbi.postrollback_handle -> unit
  method unregister_precommit : Dbi.precommit_handle -> unit
  method user : string option
end

val connect : ?host:string -> ?port:string ->
  ?user:string -> ?password:string -> string -> connection
(** Functional version of [new Dbi.connection ...] *)
val close : connection -> unit
(** Functional version of [dbh#close ()] *)
val closed : connection -> bool
(** Functional version of [dbh#closed] *)
val commit : connection -> unit
(** Functional version of [dbh#commit ()] *)
val ping : connection -> bool
(** Functional version of [dbh#ping ()] *)
val rollback : connection -> unit
(** Functional version of [dbh#rollback ()] *)
