package test_core_unicode

// This file contains test data licensed under the Unicode Consortium that has
// been converted to a format that will work within Odin.
//
// The Unicode license to which said test data is under is included verbatim
// within this file, along with the names of the files from which the test data
// has been converted.

/*
UNICODE LICENSE V3

COPYRIGHT AND PERMISSION NOTICE

Copyright © 1991-2024 Unicode, Inc.

NOTICE TO USER: Carefully read the following legal agreement. BY
DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.

Permission is hereby granted, free of charge, to any person obtaining a
copy of data files and any associated documentation (the "Data Files") or
software and any associated documentation (the "Software") to deal in the
Data Files or Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, and/or sell
copies of the Data Files or Software, and to permit persons to whom the
Data Files or Software are furnished to do so, provided that either (a)
this copyright and permission notice appear with all copies of the Data
Files or Software, or (b) this copyright and permission notice appear in
associated Documentation.

THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
THIRD PARTY RIGHTS.

IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
FILES OR SOFTWARE.

Except as contained in this notice, the name of a copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in these Data Files or Software without prior written
authorization of the copyright holder.
*/


// https://unicode.org/Public/15.1.0/ucd/auxiliary/GraphemeBreakTest.txt
//
// GraphemeBreakTest-15.1.0.txt
// Date: 2023-08-07, 15:52:55 GMT
// © 2023 Unicode®, Inc.
// Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
// For terms of use, see https://www.unicode.org/terms_of_use.html
@(rodata)
official_grapheme_break_test_cases := []Test_Case {
{"\u0020\u0020", 2},
{"\u0020\u0308\u0020", 2},
{"\u0020\u000D", 2},
{"\u0020\u0308\u000D", 2},
{"\u0020\u000A", 2},
{"\u0020\u0308\u000A", 2},
{"\u0020\u0001", 2},
{"\u0020\u0308\u0001", 2},
{"\u0020\u034F", 1},
{"\u0020\u0308\u034F", 1},
{"\u0020\U0001F1E6", 2},
{"\u0020\u0308\U0001F1E6", 2},
{"\u0020\u0600", 2},
{"\u0020\u0308\u0600", 2},
{"\u0020\u0A03", 1},
{"\u0020\u0308\u0A03", 1},
{"\u0020\u1100", 2},
{"\u0020\u0308\u1100", 2},
{"\u0020\u1160", 2},
{"\u0020\u0308\u1160", 2},
{"\u0020\u11A8", 2},
{"\u0020\u0308\u11A8", 2},
{"\u0020\uAC00", 2},
{"\u0020\u0308\uAC00", 2},
{"\u0020\uAC01", 2},
{"\u0020\u0308\uAC01", 2},
{"\u0020\u0900", 1},
{"\u0020\u0308\u0900", 1},
{"\u0020\u0903", 1},
{"\u0020\u0308\u0903", 1},
{"\u0020\u0904", 2},
{"\u0020\u0308\u0904", 2},
{"\u0020\u0D4E", 2},
{"\u0020\u0308\u0D4E", 2},
{"\u0020\u0915", 2},
{"\u0020\u0308\u0915", 2},
{"\u0020\u231A", 2},
{"\u0020\u0308\u231A", 2},
{"\u0020\u0300", 1},
{"\u0020\u0308\u0300", 1},
{"\u0020\u093C", 1},
{"\u0020\u0308\u093C", 1},
{"\u0020\u094D", 1},
{"\u0020\u0308\u094D", 1},
{"\u0020\u200D", 1},
{"\u0020\u0308\u200D", 1},
{"\u0020\u0378", 2},
{"\u0020\u0308\u0378", 2},
{"\u000D\u0020", 2},
{"\u000D\u0308\u0020", 3},
{"\u000D\u000D", 2},
{"\u000D\u0308\u000D", 3},
{"\u000D\u000A", 1},
{"\u000D\u0308\u000A", 3},
{"\u000D\u0001", 2},
{"\u000D\u0308\u0001", 3},
{"\u000D\u034F", 2},
{"\u000D\u0308\u034F", 2},
{"\u000D\U0001F1E6", 2},
{"\u000D\u0308\U0001F1E6", 3},
{"\u000D\u0600", 2},
{"\u000D\u0308\u0600", 3},
{"\u000D\u0A03", 2},
{"\u000D\u0308\u0A03", 2},
{"\u000D\u1100", 2},
{"\u000D\u0308\u1100", 3},
{"\u000D\u1160", 2},
{"\u000D\u0308\u1160", 3},
{"\u000D\u11A8", 2},
{"\u000D\u0308\u11A8", 3},
{"\u000D\uAC00", 2},
{"\u000D\u0308\uAC00", 3},
{"\u000D\uAC01", 2},
{"\u000D\u0308\uAC01", 3},
{"\u000D\u0900", 2},
{"\u000D\u0308\u0900", 2},
{"\u000D\u0903", 2},
{"\u000D\u0308\u0903", 2},
{"\u000D\u0904", 2},
{"\u000D\u0308\u0904", 3},
{"\u000D\u0D4E", 2},
{"\u000D\u0308\u0D4E", 3},
{"\u000D\u0915", 2},
{"\u000D\u0308\u0915", 3},
{"\u000D\u231A", 2},
{"\u000D\u0308\u231A", 3},
{"\u000D\u0300", 2},
{"\u000D\u0308\u0300", 2},
{"\u000D\u093C", 2},
{"\u000D\u0308\u093C", 2},
{"\u000D\u094D", 2},
{"\u000D\u0308\u094D", 2},
{"\u000D\u200D", 2},
{"\u000D\u0308\u200D", 2},
{"\u000D\u0378", 2},
{"\u000D\u0308\u0378", 3},
{"\u000A\u0020", 2},
{"\u000A\u0308\u0020", 3},
{"\u000A\u000D", 2},
{"\u000A\u0308\u000D", 3},
{"\u000A\u000A", 2},
{"\u000A\u0308\u000A", 3},
{"\u000A\u0001", 2},
{"\u000A\u0308\u0001", 3},
{"\u000A\u034F", 2},
{"\u000A\u0308\u034F", 2},
{"\u000A\U0001F1E6", 2},
{"\u000A\u0308\U0001F1E6", 3},
{"\u000A\u0600", 2},
{"\u000A\u0308\u0600", 3},
{"\u000A\u0A03", 2},
{"\u000A\u0308\u0A03", 2},
{"\u000A\u1100", 2},
{"\u000A\u0308\u1100", 3},
{"\u000A\u1160", 2},
{"\u000A\u0308\u1160", 3},
{"\u000A\u11A8", 2},
{"\u000A\u0308\u11A8", 3},
{"\u000A\uAC00", 2},
{"\u000A\u0308\uAC00", 3},
{"\u000A\uAC01", 2},
{"\u000A\u0308\uAC01", 3},
{"\u000A\u0900", 2},
{"\u000A\u0308\u0900", 2},
{"\u000A\u0903", 2},
{"\u000A\u0308\u0903", 2},
{"\u000A\u0904", 2},
{"\u000A\u0308\u0904", 3},
{"\u000A\u0D4E", 2},
{"\u000A\u0308\u0D4E", 3},
{"\u000A\u0915", 2},
{"\u000A\u0308\u0915", 3},
{"\u000A\u231A", 2},
{"\u000A\u0308\u231A", 3},
{"\u000A\u0300", 2},
{"\u000A\u0308\u0300", 2},
{"\u000A\u093C", 2},
{"\u000A\u0308\u093C", 2},
{"\u000A\u094D", 2},
{"\u000A\u0308\u094D", 2},
{"\u000A\u200D", 2},
{"\u000A\u0308\u200D", 2},
{"\u000A\u0378", 2},
{"\u000A\u0308\u0378", 3},
{"\u0001\u0020", 2},
{"\u0001\u0308\u0020", 3},
{"\u0001\u000D", 2},
{"\u0001\u0308\u000D", 3},
{"\u0001\u000A", 2},
{"\u0001\u0308\u000A", 3},
{"\u0001\u0001", 2},
{"\u0001\u0308\u0001", 3},
{"\u0001\u034F", 2},
{"\u0001\u0308\u034F", 2},
{"\u0001\U0001F1E6", 2},
{"\u0001\u0308\U0001F1E6", 3},
{"\u0001\u0600", 2},
{"\u0001\u0308\u0600", 3},
{"\u0001\u0A03", 2},
{"\u0001\u0308\u0A03", 2},
{"\u0001\u1100", 2},
{"\u0001\u0308\u1100", 3},
{"\u0001\u1160", 2},
{"\u0001\u0308\u1160", 3},
{"\u0001\u11A8", 2},
{"\u0001\u0308\u11A8", 3},
{"\u0001\uAC00", 2},
{"\u0001\u0308\uAC00", 3},
{"\u0001\uAC01", 2},
{"\u0001\u0308\uAC01", 3},
{"\u0001\u0900", 2},
{"\u0001\u0308\u0900", 2},
{"\u0001\u0903", 2},
{"\u0001\u0308\u0903", 2},
{"\u0001\u0904", 2},
{"\u0001\u0308\u0904", 3},
{"\u0001\u0D4E", 2},
{"\u0001\u0308\u0D4E", 3},
{"\u0001\u0915", 2},
{"\u0001\u0308\u0915", 3},
{"\u0001\u231A", 2},
{"\u0001\u0308\u231A", 3},
{"\u0001\u0300", 2},
{"\u0001\u0308\u0300", 2},
{"\u0001\u093C", 2},
{"\u0001\u0308\u093C", 2},
{"\u0001\u094D", 2},
{"\u0001\u0308\u094D", 2},
{"\u0001\u200D", 2},
{"\u0001\u0308\u200D", 2},
{"\u0001\u0378", 2},
{"\u0001\u0308\u0378", 3},
{"\u034F\u0020", 2},
{"\u034F\u0308\u0020", 2},
{"\u034F\u000D", 2},
{"\u034F\u0308\u000D", 2},
{"\u034F\u000A", 2},
{"\u034F\u0308\u000A", 2},
{"\u034F\u0001", 2},
{"\u034F\u0308\u0001", 2},
{"\u034F\u034F", 1},
{"\u034F\u0308\u034F", 1},
{"\u034F\U0001F1E6", 2},
{"\u034F\u0308\U0001F1E6", 2},
{"\u034F\u0600", 2},
{"\u034F\u0308\u0600", 2},
{"\u034F\u0A03", 1},
{"\u034F\u0308\u0A03", 1},
{"\u034F\u1100", 2},
{"\u034F\u0308\u1100", 2},
{"\u034F\u1160", 2},
{"\u034F\u0308\u1160", 2},
{"\u034F\u11A8", 2},
{"\u034F\u0308\u11A8", 2},
{"\u034F\uAC00", 2},
{"\u034F\u0308\uAC00", 2},
{"\u034F\uAC01", 2},
{"\u034F\u0308\uAC01", 2},
{"\u034F\u0900", 1},
{"\u034F\u0308\u0900", 1},
{"\u034F\u0903", 1},
{"\u034F\u0308\u0903", 1},
{"\u034F\u0904", 2},
{"\u034F\u0308\u0904", 2},
{"\u034F\u0D4E", 2},
{"\u034F\u0308\u0D4E", 2},
{"\u034F\u0915", 2},
{"\u034F\u0308\u0915", 2},
{"\u034F\u231A", 2},
{"\u034F\u0308\u231A", 2},
{"\u034F\u0300", 1},
{"\u034F\u0308\u0300", 1},
{"\u034F\u093C", 1},
{"\u034F\u0308\u093C", 1},
{"\u034F\u094D", 1},
{"\u034F\u0308\u094D", 1},
{"\u034F\u200D", 1},
{"\u034F\u0308\u200D", 1},
{"\u034F\u0378", 2},
{"\u034F\u0308\u0378", 2},
{"\U0001F1E6\u0020", 2},
{"\U0001F1E6\u0308\u0020", 2},
{"\U0001F1E6\u000D", 2},
{"\U0001F1E6\u0308\u000D", 2},
{"\U0001F1E6\u000A", 2},
{"\U0001F1E6\u0308\u000A", 2},
{"\U0001F1E6\u0001", 2},
{"\U0001F1E6\u0308\u0001", 2},
{"\U0001F1E6\u034F", 1},
{"\U0001F1E6\u0308\u034F", 1},
{"\U0001F1E6\U0001F1E6", 1},
{"\U0001F1E6\u0308\U0001F1E6", 2},
{"\U0001F1E6\u0600", 2},
{"\U0001F1E6\u0308\u0600", 2},
{"\U0001F1E6\u0A03", 1},
{"\U0001F1E6\u0308\u0A03", 1},
{"\U0001F1E6\u1100", 2},
{"\U0001F1E6\u0308\u1100", 2},
{"\U0001F1E6\u1160", 2},
{"\U0001F1E6\u0308\u1160", 2},
{"\U0001F1E6\u11A8", 2},
{"\U0001F1E6\u0308\u11A8", 2},
{"\U0001F1E6\uAC00", 2},
{"\U0001F1E6\u0308\uAC00", 2},
{"\U0001F1E6\uAC01", 2},
{"\U0001F1E6\u0308\uAC01", 2},
{"\U0001F1E6\u0900", 1},
{"\U0001F1E6\u0308\u0900", 1},
{"\U0001F1E6\u0903", 1},
{"\U0001F1E6\u0308\u0903", 1},
{"\U0001F1E6\u0904", 2},
{"\U0001F1E6\u0308\u0904", 2},
{"\U0001F1E6\u0D4E", 2},
{"\U0001F1E6\u0308\u0D4E", 2},
{"\U0001F1E6\u0915", 2},
{"\U0001F1E6\u0308\u0915", 2},
{"\U0001F1E6\u231A", 2},
{"\U0001F1E6\u0308\u231A", 2},
{"\U0001F1E6\u0300", 1},
{"\U0001F1E6\u0308\u0300", 1},
{"\U0001F1E6\u093C", 1},
{"\U0001F1E6\u0308\u093C", 1},
{"\U0001F1E6\u094D", 1},
{"\U0001F1E6\u0308\u094D", 1},
{"\U0001F1E6\u200D", 1},
{"\U0001F1E6\u0308\u200D", 1},
{"\U0001F1E6\u0378", 2},
{"\U0001F1E6\u0308\u0378", 2},
{"\u0600\u0020", 1},
{"\u0600\u0308\u0020", 2},
{"\u0600\u000D", 2},
{"\u0600\u0308\u000D", 2},
{"\u0600\u000A", 2},
{"\u0600\u0308\u000A", 2},
{"\u0600\u0001", 2},
{"\u0600\u0308\u0001", 2},
{"\u0600\u034F", 1},
{"\u0600\u0308\u034F", 1},
{"\u0600\U0001F1E6", 1},
{"\u0600\u0308\U0001F1E6", 2},
{"\u0600\u0600", 1},
{"\u0600\u0308\u0600", 2},
{"\u0600\u0A03", 1},
{"\u0600\u0308\u0A03", 1},
{"\u0600\u1100", 1},
{"\u0600\u0308\u1100", 2},
{"\u0600\u1160", 1},
{"\u0600\u0308\u1160", 2},
{"\u0600\u11A8", 1},
{"\u0600\u0308\u11A8", 2},
{"\u0600\uAC00", 1},
{"\u0600\u0308\uAC00", 2},
{"\u0600\uAC01", 1},
{"\u0600\u0308\uAC01", 2},
{"\u0600\u0900", 1},
{"\u0600\u0308\u0900", 1},
{"\u0600\u0903", 1},
{"\u0600\u0308\u0903", 1},
{"\u0600\u0904", 1},
{"\u0600\u0308\u0904", 2},
{"\u0600\u0D4E", 1},
{"\u0600\u0308\u0D4E", 2},
{"\u0600\u0915", 1},
{"\u0600\u0308\u0915", 2},
{"\u0600\u231A", 1},
{"\u0600\u0308\u231A", 2},
{"\u0600\u0300", 1},
{"\u0600\u0308\u0300", 1},
{"\u0600\u093C", 1},
{"\u0600\u0308\u093C", 1},
{"\u0600\u094D", 1},
{"\u0600\u0308\u094D", 1},
{"\u0600\u200D", 1},
{"\u0600\u0308\u200D", 1},
{"\u0600\u0378", 1},
{"\u0600\u0308\u0378", 2},
{"\u0A03\u0020", 2},
{"\u0A03\u0308\u0020", 2},
{"\u0A03\u000D", 2},
{"\u0A03\u0308\u000D", 2},
{"\u0A03\u000A", 2},
{"\u0A03\u0308\u000A", 2},
{"\u0A03\u0001", 2},
{"\u0A03\u0308\u0001", 2},
{"\u0A03\u034F", 1},
{"\u0A03\u0308\u034F", 1},
{"\u0A03\U0001F1E6", 2},
{"\u0A03\u0308\U0001F1E6", 2},
{"\u0A03\u0600", 2},
{"\u0A03\u0308\u0600", 2},
{"\u0A03\u0A03", 1},
{"\u0A03\u0308\u0A03", 1},
{"\u0A03\u1100", 2},
{"\u0A03\u0308\u1100", 2},
{"\u0A03\u1160", 2},
{"\u0A03\u0308\u1160", 2},
{"\u0A03\u11A8", 2},
{"\u0A03\u0308\u11A8", 2},
{"\u0A03\uAC00", 2},
{"\u0A03\u0308\uAC00", 2},
{"\u0A03\uAC01", 2},
{"\u0A03\u0308\uAC01", 2},
{"\u0A03\u0900", 1},
{"\u0A03\u0308\u0900", 1},
{"\u0A03\u0903", 1},
{"\u0A03\u0308\u0903", 1},
{"\u0A03\u0904", 2},
{"\u0A03\u0308\u0904", 2},
{"\u0A03\u0D4E", 2},
{"\u0A03\u0308\u0D4E", 2},
{"\u0A03\u0915", 2},
{"\u0A03\u0308\u0915", 2},
{"\u0A03\u231A", 2},
{"\u0A03\u0308\u231A", 2},
{"\u0A03\u0300", 1},
{"\u0A03\u0308\u0300", 1},
{"\u0A03\u093C", 1},
{"\u0A03\u0308\u093C", 1},
{"\u0A03\u094D", 1},
{"\u0A03\u0308\u094D", 1},
{"\u0A03\u200D", 1},
{"\u0A03\u0308\u200D", 1},
{"\u0A03\u0378", 2},
{"\u0A03\u0308\u0378", 2},
{"\u1100\u0020", 2},
{"\u1100\u0308\u0020", 2},
{"\u1100\u000D", 2},
{"\u1100\u0308\u000D", 2},
{"\u1100\u000A", 2},
{"\u1100\u0308\u000A", 2},
{"\u1100\u0001", 2},
{"\u1100\u0308\u0001", 2},
{"\u1100\u034F", 1},
{"\u1100\u0308\u034F", 1},
{"\u1100\U0001F1E6", 2},
{"\u1100\u0308\U0001F1E6", 2},
{"\u1100\u0600", 2},
{"\u1100\u0308\u0600", 2},
{"\u1100\u0A03", 1},
{"\u1100\u0308\u0A03", 1},
{"\u1100\u1100", 1},
{"\u1100\u0308\u1100", 2},
{"\u1100\u1160", 1},
{"\u1100\u0308\u1160", 2},
{"\u1100\u11A8", 2},
{"\u1100\u0308\u11A8", 2},
{"\u1100\uAC00", 1},
{"\u1100\u0308\uAC00", 2},
{"\u1100\uAC01", 1},
{"\u1100\u0308\uAC01", 2},
{"\u1100\u0900", 1},
{"\u1100\u0308\u0900", 1},
{"\u1100\u0903", 1},
{"\u1100\u0308\u0903", 1},
{"\u1100\u0904", 2},
{"\u1100\u0308\u0904", 2},
{"\u1100\u0D4E", 2},
{"\u1100\u0308\u0D4E", 2},
{"\u1100\u0915", 2},
{"\u1100\u0308\u0915", 2},
{"\u1100\u231A", 2},
{"\u1100\u0308\u231A", 2},
{"\u1100\u0300", 1},
{"\u1100\u0308\u0300", 1},
{"\u1100\u093C", 1},
{"\u1100\u0308\u093C", 1},
{"\u1100\u094D", 1},
{"\u1100\u0308\u094D", 1},
{"\u1100\u200D", 1},
{"\u1100\u0308\u200D", 1},
{"\u1100\u0378", 2},
{"\u1100\u0308\u0378", 2},
{"\u1160\u0020", 2},
{"\u1160\u0308\u0020", 2},
{"\u1160\u000D", 2},
{"\u1160\u0308\u000D", 2},
{"\u1160\u000A", 2},
{"\u1160\u0308\u000A", 2},
{"\u1160\u0001", 2},
{"\u1160\u0308\u0001", 2},
{"\u1160\u034F", 1},
{"\u1160\u0308\u034F", 1},
{"\u1160\U0001F1E6", 2},
{"\u1160\u0308\U0001F1E6", 2},
{"\u1160\u0600", 2},
{"\u1160\u0308\u0600", 2},
{"\u1160\u0A03", 1},
{"\u1160\u0308\u0A03", 1},
{"\u1160\u1100", 2},
{"\u1160\u0308\u1100", 2},
{"\u1160\u1160", 1},
{"\u1160\u0308\u1160", 2},
{"\u1160\u11A8", 1},
{"\u1160\u0308\u11A8", 2},
{"\u1160\uAC00", 2},
{"\u1160\u0308\uAC00", 2},
{"\u1160\uAC01", 2},
{"\u1160\u0308\uAC01", 2},
{"\u1160\u0900", 1},
{"\u1160\u0308\u0900", 1},
{"\u1160\u0903", 1},
{"\u1160\u0308\u0903", 1},
{"\u1160\u0904", 2},
{"\u1160\u0308\u0904", 2},
{"\u1160\u0D4E", 2},
{"\u1160\u0308\u0D4E", 2},
{"\u1160\u0915", 2},
{"\u1160\u0308\u0915", 2},
{"\u1160\u231A", 2},
{"\u1160\u0308\u231A", 2},
{"\u1160\u0300", 1},
{"\u1160\u0308\u0300", 1},
{"\u1160\u093C", 1},
{"\u1160\u0308\u093C", 1},
{"\u1160\u094D", 1},
{"\u1160\u0308\u094D", 1},
{"\u1160\u200D", 1},
{"\u1160\u0308\u200D", 1},
{"\u1160\u0378", 2},
{"\u1160\u0308\u0378", 2},
{"\u11A8\u0020", 2},
{"\u11A8\u0308\u0020", 2},
{"\u11A8\u000D", 2},
{"\u11A8\u0308\u000D", 2},
{"\u11A8\u000A", 2},
{"\u11A8\u0308\u000A", 2},
{"\u11A8\u0001", 2},
{"\u11A8\u0308\u0001", 2},
{"\u11A8\u034F", 1},
{"\u11A8\u0308\u034F", 1},
{"\u11A8\U0001F1E6", 2},
{"\u11A8\u0308\U0001F1E6", 2},
{"\u11A8\u0600", 2},
{"\u11A8\u0308\u0600", 2},
{"\u11A8\u0A03", 1},
{"\u11A8\u0308\u0A03", 1},
{"\u11A8\u1100", 2},
{"\u11A8\u0308\u1100", 2},
{"\u11A8\u1160", 2},
{"\u11A8\u0308\u1160", 2},
{"\u11A8\u11A8", 1},
{"\u11A8\u0308\u11A8", 2},
{"\u11A8\uAC00", 2},
{"\u11A8\u0308\uAC00", 2},
{"\u11A8\uAC01", 2},
{"\u11A8\u0308\uAC01", 2},
{"\u11A8\u0900", 1},
{"\u11A8\u0308\u0900", 1},
{"\u11A8\u0903", 1},
{"\u11A8\u0308\u0903", 1},
{"\u11A8\u0904", 2},
{"\u11A8\u0308\u0904", 2},
{"\u11A8\u0D4E", 2},
{"\u11A8\u0308\u0D4E", 2},
{"\u11A8\u0915", 2},
{"\u11A8\u0308\u0915", 2},
{"\u11A8\u231A", 2},
{"\u11A8\u0308\u231A", 2},
{"\u11A8\u0300", 1},
{"\u11A8\u0308\u0300", 1},
{"\u11A8\u093C", 1},
{"\u11A8\u0308\u093C", 1},
{"\u11A8\u094D", 1},
{"\u11A8\u0308\u094D", 1},
{"\u11A8\u200D", 1},
{"\u11A8\u0308\u200D", 1},
{"\u11A8\u0378", 2},
{"\u11A8\u0308\u0378", 2},
{"\uAC00\u0020", 2},
{"\uAC00\u0308\u0020", 2},
{"\uAC00\u000D", 2},
{"\uAC00\u0308\u000D", 2},
{"\uAC00\u000A", 2},
{"\uAC00\u0308\u000A", 2},
{"\uAC00\u0001", 2},
{"\uAC00\u0308\u0001", 2},
{"\uAC00\u034F", 1},
{"\uAC00\u0308\u034F", 1},
{"\uAC00\U0001F1E6", 2},
{"\uAC00\u0308\U0001F1E6", 2},
{"\uAC00\u0600", 2},
{"\uAC00\u0308\u0600", 2},
{"\uAC00\u0A03", 1},
{"\uAC00\u0308\u0A03", 1},
{"\uAC00\u1100", 2},
{"\uAC00\u0308\u1100", 2},
{"\uAC00\u1160", 1},
{"\uAC00\u0308\u1160", 2},
{"\uAC00\u11A8", 1},
{"\uAC00\u0308\u11A8", 2},
{"\uAC00\uAC00", 2},
{"\uAC00\u0308\uAC00", 2},
{"\uAC00\uAC01", 2},
{"\uAC00\u0308\uAC01", 2},
{"\uAC00\u0900", 1},
{"\uAC00\u0308\u0900", 1},
{"\uAC00\u0903", 1},
{"\uAC00\u0308\u0903", 1},
{"\uAC00\u0904", 2},
{"\uAC00\u0308\u0904", 2},
{"\uAC00\u0D4E", 2},
{"\uAC00\u0308\u0D4E", 2},
{"\uAC00\u0915", 2},
{"\uAC00\u0308\u0915", 2},
{"\uAC00\u231A", 2},
{"\uAC00\u0308\u231A", 2},
{"\uAC00\u0300", 1},
{"\uAC00\u0308\u0300", 1},
{"\uAC00\u093C", 1},
{"\uAC00\u0308\u093C", 1},
{"\uAC00\u094D", 1},
{"\uAC00\u0308\u094D", 1},
{"\uAC00\u200D", 1},
{"\uAC00\u0308\u200D", 1},
{"\uAC00\u0378", 2},
{"\uAC00\u0308\u0378", 2},
{"\uAC01\u0020", 2},
{"\uAC01\u0308\u0020", 2},
{"\uAC01\u000D", 2},
{"\uAC01\u0308\u000D", 2},
{"\uAC01\u000A", 2},
{"\uAC01\u0308\u000A", 2},
{"\uAC01\u0001", 2},
{"\uAC01\u0308\u0001", 2},
{"\uAC01\u034F", 1},
{"\uAC01\u0308\u034F", 1},
{"\uAC01\U0001F1E6", 2},
{"\uAC01\u0308\U0001F1E6", 2},
{"\uAC01\u0600", 2},
{"\uAC01\u0308\u0600", 2},
{"\uAC01\u0A03", 1},
{"\uAC01\u0308\u0A03", 1},
{"\uAC01\u1100", 2},
{"\uAC01\u0308\u1100", 2},
{"\uAC01\u1160", 2},
{"\uAC01\u0308\u1160", 2},
{"\uAC01\u11A8", 1},
{"\uAC01\u0308\u11A8", 2},
{"\uAC01\uAC00", 2},
{"\uAC01\u0308\uAC00", 2},
{"\uAC01\uAC01", 2},
{"\uAC01\u0308\uAC01", 2},
{"\uAC01\u0900", 1},
{"\uAC01\u0308\u0900", 1},
{"\uAC01\u0903", 1},
{"\uAC01\u0308\u0903", 1},
{"\uAC01\u0904", 2},
{"\uAC01\u0308\u0904", 2},
{"\uAC01\u0D4E", 2},
{"\uAC01\u0308\u0D4E", 2},
{"\uAC01\u0915", 2},
{"\uAC01\u0308\u0915", 2},
{"\uAC01\u231A", 2},
{"\uAC01\u0308\u231A", 2},
{"\uAC01\u0300", 1},
{"\uAC01\u0308\u0300", 1},
{"\uAC01\u093C", 1},
{"\uAC01\u0308\u093C", 1},
{"\uAC01\u094D", 1},
{"\uAC01\u0308\u094D", 1},
{"\uAC01\u200D", 1},
{"\uAC01\u0308\u200D", 1},
{"\uAC01\u0378", 2},
{"\uAC01\u0308\u0378", 2},
{"\u0900\u0020", 2},
{"\u0900\u0308\u0020", 2},
{"\u0900\u000D", 2},
{"\u0900\u0308\u000D", 2},
{"\u0900\u000A", 2},
{"\u0900\u0308\u000A", 2},
{"\u0900\u0001", 2},
{"\u0900\u0308\u0001", 2},
{"\u0900\u034F", 1},
{"\u0900\u0308\u034F", 1},
{"\u0900\U0001F1E6", 2},
{"\u0900\u0308\U0001F1E6", 2},
{"\u0900\u0600", 2},
{"\u0900\u0308\u0600", 2},
{"\u0900\u0A03", 1},
{"\u0900\u0308\u0A03", 1},
{"\u0900\u1100", 2},
{"\u0900\u0308\u1100", 2},
{"\u0900\u1160", 2},
{"\u0900\u0308\u1160", 2},
{"\u0900\u11A8", 2},
{"\u0900\u0308\u11A8", 2},
{"\u0900\uAC00", 2},
{"\u0900\u0308\uAC00", 2},
{"\u0900\uAC01", 2},
{"\u0900\u0308\uAC01", 2},
{"\u0900\u0900", 1},
{"\u0900\u0308\u0900", 1},
{"\u0900\u0903", 1},
{"\u0900\u0308\u0903", 1},
{"\u0900\u0904", 2},
{"\u0900\u0308\u0904", 2},
{"\u0900\u0D4E", 2},
{"\u0900\u0308\u0D4E", 2},
{"\u0900\u0915", 2},
{"\u0900\u0308\u0915", 2},
{"\u0900\u231A", 2},
{"\u0900\u0308\u231A", 2},
{"\u0900\u0300", 1},
{"\u0900\u0308\u0300", 1},
{"\u0900\u093C", 1},
{"\u0900\u0308\u093C", 1},
{"\u0900\u094D", 1},
{"\u0900\u0308\u094D", 1},
{"\u0900\u200D", 1},
{"\u0900\u0308\u200D", 1},
{"\u0900\u0378", 2},
{"\u0900\u0308\u0378", 2},
{"\u0903\u0020", 2},
{"\u0903\u0308\u0020", 2},
{"\u0903\u000D", 2},
{"\u0903\u0308\u000D", 2},
{"\u0903\u000A", 2},
{"\u0903\u0308\u000A", 2},
{"\u0903\u0001", 2},
{"\u0903\u0308\u0001", 2},
{"\u0903\u034F", 1},
{"\u0903\u0308\u034F", 1},
{"\u0903\U0001F1E6", 2},
{"\u0903\u0308\U0001F1E6", 2},
{"\u0903\u0600", 2},
{"\u0903\u0308\u0600", 2},
{"\u0903\u0A03", 1},
{"\u0903\u0308\u0A03", 1},
{"\u0903\u1100", 2},
{"\u0903\u0308\u1100", 2},
{"\u0903\u1160", 2},
{"\u0903\u0308\u1160", 2},
{"\u0903\u11A8", 2},
{"\u0903\u0308\u11A8", 2},
{"\u0903\uAC00", 2},
{"\u0903\u0308\uAC00", 2},
{"\u0903\uAC01", 2},
{"\u0903\u0308\uAC01", 2},
{"\u0903\u0900", 1},
{"\u0903\u0308\u0900", 1},
{"\u0903\u0903", 1},
{"\u0903\u0308\u0903", 1},
{"\u0903\u0904", 2},
{"\u0903\u0308\u0904", 2},
{"\u0903\u0D4E", 2},
{"\u0903\u0308\u0D4E", 2},
{"\u0903\u0915", 2},
{"\u0903\u0308\u0915", 2},
{"\u0903\u231A", 2},
{"\u0903\u0308\u231A", 2},
{"\u0903\u0300", 1},
{"\u0903\u0308\u0300", 1},
{"\u0903\u093C", 1},
{"\u0903\u0308\u093C", 1},
{"\u0903\u094D", 1},
{"\u0903\u0308\u094D", 1},
{"\u0903\u200D", 1},
{"\u0903\u0308\u200D", 1},
{"\u0903\u0378", 2},
{"\u0903\u0308\u0378", 2},
{"\u0904\u0020", 2},
{"\u0904\u0308\u0020", 2},
{"\u0904\u000D", 2},
{"\u0904\u0308\u000D", 2},
{"\u0904\u000A", 2},
{"\u0904\u0308\u000A", 2},
{"\u0904\u0001", 2},
{"\u0904\u0308\u0001", 2},
{"\u0904\u034F", 1},
{"\u0904\u0308\u034F", 1},
{"\u0904\U0001F1E6", 2},
{"\u0904\u0308\U0001F1E6", 2},
{"\u0904\u0600", 2},
{"\u0904\u0308\u0600", 2},
{"\u0904\u0A03", 1},
{"\u0904\u0308\u0A03", 1},
{"\u0904\u1100", 2},
{"\u0904\u0308\u1100", 2},
{"\u0904\u1160", 2},
{"\u0904\u0308\u1160", 2},
{"\u0904\u11A8", 2},
{"\u0904\u0308\u11A8", 2},
{"\u0904\uAC00", 2},
{"\u0904\u0308\uAC00", 2},
{"\u0904\uAC01", 2},
{"\u0904\u0308\uAC01", 2},
{"\u0904\u0900", 1},
{"\u0904\u0308\u0900", 1},
{"\u0904\u0903", 1},
{"\u0904\u0308\u0903", 1},
{"\u0904\u0904", 2},
{"\u0904\u0308\u0904", 2},
{"\u0904\u0D4E", 2},
{"\u0904\u0308\u0D4E", 2},
{"\u0904\u0915", 2},
{"\u0904\u0308\u0915", 2},
{"\u0904\u231A", 2},
{"\u0904\u0308\u231A", 2},
{"\u0904\u0300", 1},
{"\u0904\u0308\u0300", 1},
{"\u0904\u093C", 1},
{"\u0904\u0308\u093C", 1},
{"\u0904\u094D", 1},
{"\u0904\u0308\u094D", 1},
{"\u0904\u200D", 1},
{"\u0904\u0308\u200D", 1},
{"\u0904\u0378", 2},
{"\u0904\u0308\u0378", 2},
{"\u0D4E\u0020", 1},
{"\u0D4E\u0308\u0020", 2},
{"\u0D4E\u000D", 2},
{"\u0D4E\u0308\u000D", 2},
{"\u0D4E\u000A", 2},
{"\u0D4E\u0308\u000A", 2},
{"\u0D4E\u0001", 2},
{"\u0D4E\u0308\u0001", 2},
{"\u0D4E\u034F", 1},
{"\u0D4E\u0308\u034F", 1},
{"\u0D4E\U0001F1E6", 1},
{"\u0D4E\u0308\U0001F1E6", 2},
{"\u0D4E\u0600", 1},
{"\u0D4E\u0308\u0600", 2},
{"\u0D4E\u0A03", 1},
{"\u0D4E\u0308\u0A03", 1},
{"\u0D4E\u1100", 1},
{"\u0D4E\u0308\u1100", 2},
{"\u0D4E\u1160", 1},
{"\u0D4E\u0308\u1160", 2},
{"\u0D4E\u11A8", 1},
{"\u0D4E\u0308\u11A8", 2},
{"\u0D4E\uAC00", 1},
{"\u0D4E\u0308\uAC00", 2},
{"\u0D4E\uAC01", 1},
{"\u0D4E\u0308\uAC01", 2},
{"\u0D4E\u0900", 1},
{"\u0D4E\u0308\u0900", 1},
{"\u0D4E\u0903", 1},
{"\u0D4E\u0308\u0903", 1},
{"\u0D4E\u0904", 1},
{"\u0D4E\u0308\u0904", 2},
{"\u0D4E\u0D4E", 1},
{"\u0D4E\u0308\u0D4E", 2},
{"\u0D4E\u0915", 1},
{"\u0D4E\u0308\u0915", 2},
{"\u0D4E\u231A", 1},
{"\u0D4E\u0308\u231A", 2},
{"\u0D4E\u0300", 1},
{"\u0D4E\u0308\u0300", 1},
{"\u0D4E\u093C", 1},
{"\u0D4E\u0308\u093C", 1},
{"\u0D4E\u094D", 1},
{"\u0D4E\u0308\u094D", 1},
{"\u0D4E\u200D", 1},
{"\u0D4E\u0308\u200D", 1},
{"\u0D4E\u0378", 1},
{"\u0D4E\u0308\u0378", 2},
{"\u0915\u0020", 2},
{"\u0915\u0308\u0020", 2},
{"\u0915\u000D", 2},
{"\u0915\u0308\u000D", 2},
{"\u0915\u000A", 2},
{"\u0915\u0308\u000A", 2},
{"\u0915\u0001", 2},
{"\u0915\u0308\u0001", 2},
{"\u0915\u034F", 1},
{"\u0915\u0308\u034F", 1},
{"\u0915\U0001F1E6", 2},
{"\u0915\u0308\U0001F1E6", 2},
{"\u0915\u0600", 2},
{"\u0915\u0308\u0600", 2},
{"\u0915\u0A03", 1},
{"\u0915\u0308\u0A03", 1},
{"\u0915\u1100", 2},
{"\u0915\u0308\u1100", 2},
{"\u0915\u1160", 2},
{"\u0915\u0308\u1160", 2},
{"\u0915\u11A8", 2},
{"\u0915\u0308\u11A8", 2},
{"\u0915\uAC00", 2},
{"\u0915\u0308\uAC00", 2},
{"\u0915\uAC01", 2},
{"\u0915\u0308\uAC01", 2},
{"\u0915\u0900", 1},
{"\u0915\u0308\u0900", 1},
{"\u0915\u0903", 1},
{"\u0915\u0308\u0903", 1},
{"\u0915\u0904", 2},
{"\u0915\u0308\u0904", 2},
{"\u0915\u0D4E", 2},
{"\u0915\u0308\u0D4E", 2},
{"\u0915\u0915", 2},
{"\u0915\u0308\u0915", 2},
{"\u0915\u231A", 2},
{"\u0915\u0308\u231A", 2},
{"\u0915\u0300", 1},
{"\u0915\u0308\u0300", 1},
{"\u0915\u093C", 1},
{"\u0915\u0308\u093C", 1},
{"\u0915\u094D", 1},
{"\u0915\u0308\u094D", 1},
{"\u0915\u200D", 1},
{"\u0915\u0308\u200D", 1},
{"\u0915\u0378", 2},
{"\u0915\u0308\u0378", 2},
{"\u231A\u0020", 2},
{"\u231A\u0308\u0020", 2},
{"\u231A\u000D", 2},
{"\u231A\u0308\u000D", 2},
{"\u231A\u000A", 2},
{"\u231A\u0308\u000A", 2},
{"\u231A\u0001", 2},
{"\u231A\u0308\u0001", 2},
{"\u231A\u034F", 1},
{"\u231A\u0308\u034F", 1},
{"\u231A\U0001F1E6", 2},
{"\u231A\u0308\U0001F1E6", 2},
{"\u231A\u0600", 2},
{"\u231A\u0308\u0600", 2},
{"\u231A\u0A03", 1},
{"\u231A\u0308\u0A03", 1},
{"\u231A\u1100", 2},
{"\u231A\u0308\u1100", 2},
{"\u231A\u1160", 2},
{"\u231A\u0308\u1160", 2},
{"\u231A\u11A8", 2},
{"\u231A\u0308\u11A8", 2},
{"\u231A\uAC00", 2},
{"\u231A\u0308\uAC00", 2},
{"\u231A\uAC01", 2},
{"\u231A\u0308\uAC01", 2},
{"\u231A\u0900", 1},
{"\u231A\u0308\u0900", 1},
{"\u231A\u0903", 1},
{"\u231A\u0308\u0903", 1},
{"\u231A\u0904", 2},
{"\u231A\u0308\u0904", 2},
{"\u231A\u0D4E", 2},
{"\u231A\u0308\u0D4E", 2},
{"\u231A\u0915", 2},
{"\u231A\u0308\u0915", 2},
{"\u231A\u231A", 2},
{"\u231A\u0308\u231A", 2},
{"\u231A\u0300", 1},
{"\u231A\u0308\u0300", 1},
{"\u231A\u093C", 1},
{"\u231A\u0308\u093C", 1},
{"\u231A\u094D", 1},
{"\u231A\u0308\u094D", 1},
{"\u231A\u200D", 1},
{"\u231A\u0308\u200D", 1},
{"\u231A\u0378", 2},
{"\u231A\u0308\u0378", 2},
{"\u0300\u0020", 2},
{"\u0300\u0308\u0020", 2},
{"\u0300\u000D", 2},
{"\u0300\u0308\u000D", 2},
{"\u0300\u000A", 2},
{"\u0300\u0308\u000A", 2},
{"\u0300\u0001", 2},
{"\u0300\u0308\u0001", 2},
{"\u0300\u034F", 1},
{"\u0300\u0308\u034F", 1},
{"\u0300\U0001F1E6", 2},
{"\u0300\u0308\U0001F1E6", 2},
{"\u0300\u0600", 2},
{"\u0300\u0308\u0600", 2},
{"\u0300\u0A03", 1},
{"\u0300\u0308\u0A03", 1},
{"\u0300\u1100", 2},
{"\u0300\u0308\u1100", 2},
{"\u0300\u1160", 2},
{"\u0300\u0308\u1160", 2},
{"\u0300\u11A8", 2},
{"\u0300\u0308\u11A8", 2},
{"\u0300\uAC00", 2},
{"\u0300\u0308\uAC00", 2},
{"\u0300\uAC01", 2},
{"\u0300\u0308\uAC01", 2},
{"\u0300\u0900", 1},
{"\u0300\u0308\u0900", 1},
{"\u0300\u0903", 1},
{"\u0300\u0308\u0903", 1},
{"\u0300\u0904", 2},
{"\u0300\u0308\u0904", 2},
{"\u0300\u0D4E", 2},
{"\u0300\u0308\u0D4E", 2},
{"\u0300\u0915", 2},
{"\u0300\u0308\u0915", 2},
{"\u0300\u231A", 2},
{"\u0300\u0308\u231A", 2},
{"\u0300\u0300", 1},
{"\u0300\u0308\u0300", 1},
{"\u0300\u093C", 1},
{"\u0300\u0308\u093C", 1},
{"\u0300\u094D", 1},
{"\u0300\u0308\u094D", 1},
{"\u0300\u200D", 1},
{"\u0300\u0308\u200D", 1},
{"\u0300\u0378", 2},
{"\u0300\u0308\u0378", 2},
{"\u093C\u0020", 2},
{"\u093C\u0308\u0020", 2},
{"\u093C\u000D", 2},
{"\u093C\u0308\u000D", 2},
{"\u093C\u000A", 2},
{"\u093C\u0308\u000A", 2},
{"\u093C\u0001", 2},
{"\u093C\u0308\u0001", 2},
{"\u093C\u034F", 1},
{"\u093C\u0308\u034F", 1},
{"\u093C\U0001F1E6", 2},
{"\u093C\u0308\U0001F1E6", 2},
{"\u093C\u0600", 2},
{"\u093C\u0308\u0600", 2},
{"\u093C\u0A03", 1},
{"\u093C\u0308\u0A03", 1},
{"\u093C\u1100", 2},
{"\u093C\u0308\u1100", 2},
{"\u093C\u1160", 2},
{"\u093C\u0308\u1160", 2},
{"\u093C\u11A8", 2},
{"\u093C\u0308\u11A8", 2},
{"\u093C\uAC00", 2},
{"\u093C\u0308\uAC00", 2},
{"\u093C\uAC01", 2},
{"\u093C\u0308\uAC01", 2},
{"\u093C\u0900", 1},
{"\u093C\u0308\u0900", 1},
{"\u093C\u0903", 1},
{"\u093C\u0308\u0903", 1},
{"\u093C\u0904", 2},
{"\u093C\u0308\u0904", 2},
{"\u093C\u0D4E", 2},
{"\u093C\u0308\u0D4E", 2},
{"\u093C\u0915", 2},
{"\u093C\u0308\u0915", 2},
{"\u093C\u231A", 2},
{"\u093C\u0308\u231A", 2},
{"\u093C\u0300", 1},
{"\u093C\u0308\u0300", 1},
{"\u093C\u093C", 1},
{"\u093C\u0308\u093C", 1},
{"\u093C\u094D", 1},
{"\u093C\u0308\u094D", 1},
{"\u093C\u200D", 1},
{"\u093C\u0308\u200D", 1},
{"\u093C\u0378", 2},
{"\u093C\u0308\u0378", 2},
{"\u094D\u0020", 2},
{"\u094D\u0308\u0020", 2},
{"\u094D\u000D", 2},
{"\u094D\u0308\u000D", 2},
{"\u094D\u000A", 2},
{"\u094D\u0308\u000A", 2},
{"\u094D\u0001", 2},
{"\u094D\u0308\u0001", 2},
{"\u094D\u034F", 1},
{"\u094D\u0308\u034F", 1},
{"\u094D\U0001F1E6", 2},
{"\u094D\u0308\U0001F1E6", 2},
{"\u094D\u0600", 2},
{"\u094D\u0308\u0600", 2},
{"\u094D\u0A03", 1},
{"\u094D\u0308\u0A03", 1},
{"\u094D\u1100", 2},
{"\u094D\u0308\u1100", 2},
{"\u094D\u1160", 2},
{"\u094D\u0308\u1160", 2},
{"\u094D\u11A8", 2},
{"\u094D\u0308\u11A8", 2},
{"\u094D\uAC00", 2},
{"\u094D\u0308\uAC00", 2},
{"\u094D\uAC01", 2},
{"\u094D\u0308\uAC01", 2},
{"\u094D\u0900", 1},
{"\u094D\u0308\u0900", 1},
{"\u094D\u0903", 1},
{"\u094D\u0308\u0903", 1},
{"\u094D\u0904", 2},
{"\u094D\u0308\u0904", 2},
{"\u094D\u0D4E", 2},
{"\u094D\u0308\u0D4E", 2},
{"\u094D\u0915", 2},
{"\u094D\u0308\u0915", 2},
{"\u094D\u231A", 2},
{"\u094D\u0308\u231A", 2},
{"\u094D\u0300", 1},
{"\u094D\u0308\u0300", 1},
{"\u094D\u093C", 1},
{"\u094D\u0308\u093C", 1},
{"\u094D\u094D", 1},
{"\u094D\u0308\u094D", 1},
{"\u094D\u200D", 1},
{"\u094D\u0308\u200D", 1},
{"\u094D\u0378", 2},
{"\u094D\u0308\u0378", 2},
{"\u200D\u0020", 2},
{"\u200D\u0308\u0020", 2},
{"\u200D\u000D", 2},
{"\u200D\u0308\u000D", 2},
{"\u200D\u000A", 2},
{"\u200D\u0308\u000A", 2},
{"\u200D\u0001", 2},
{"\u200D\u0308\u0001", 2},
{"\u200D\u034F", 1},
{"\u200D\u0308\u034F", 1},
{"\u200D\U0001F1E6", 2},
{"\u200D\u0308\U0001F1E6", 2},
{"\u200D\u0600", 2},
{"\u200D\u0308\u0600", 2},
{"\u200D\u0A03", 1},
{"\u200D\u0308\u0A03", 1},
{"\u200D\u1100", 2},
{"\u200D\u0308\u1100", 2},
{"\u200D\u1160", 2},
{"\u200D\u0308\u1160", 2},
{"\u200D\u11A8", 2},
{"\u200D\u0308\u11A8", 2},
{"\u200D\uAC00", 2},
{"\u200D\u0308\uAC00", 2},
{"\u200D\uAC01", 2},
{"\u200D\u0308\uAC01", 2},
{"\u200D\u0900", 1},
{"\u200D\u0308\u0900", 1},
{"\u200D\u0903", 1},
{"\u200D\u0308\u0903", 1},
{"\u200D\u0904", 2},
{"\u200D\u0308\u0904", 2},
{"\u200D\u0D4E", 2},
{"\u200D\u0308\u0D4E", 2},
{"\u200D\u0915", 2},
{"\u200D\u0308\u0915", 2},
{"\u200D\u231A", 2},
{"\u200D\u0308\u231A", 2},
{"\u200D\u0300", 1},
{"\u200D\u0308\u0300", 1},
{"\u200D\u093C", 1},
{"\u200D\u0308\u093C", 1},
{"\u200D\u094D", 1},
{"\u200D\u0308\u094D", 1},
{"\u200D\u200D", 1},
{"\u200D\u0308\u200D", 1},
{"\u200D\u0378", 2},
{"\u200D\u0308\u0378", 2},
{"\u0378\u0020", 2},
{"\u0378\u0308\u0020", 2},
{"\u0378\u000D", 2},
{"\u0378\u0308\u000D", 2},
{"\u0378\u000A", 2},
{"\u0378\u0308\u000A", 2},
{"\u0378\u0001", 2},
{"\u0378\u0308\u0001", 2},
{"\u0378\u034F", 1},
{"\u0378\u0308\u034F", 1},
{"\u0378\U0001F1E6", 2},
{"\u0378\u0308\U0001F1E6", 2},
{"\u0378\u0600", 2},
{"\u0378\u0308\u0600", 2},
{"\u0378\u0A03", 1},
{"\u0378\u0308\u0A03", 1},
{"\u0378\u1100", 2},
{"\u0378\u0308\u1100", 2},
{"\u0378\u1160", 2},
{"\u0378\u0308\u1160", 2},
{"\u0378\u11A8", 2},
{"\u0378\u0308\u11A8", 2},
{"\u0378\uAC00", 2},
{"\u0378\u0308\uAC00", 2},
{"\u0378\uAC01", 2},
{"\u0378\u0308\uAC01", 2},
{"\u0378\u0900", 1},
{"\u0378\u0308\u0900", 1},
{"\u0378\u0903", 1},
{"\u0378\u0308\u0903", 1},
{"\u0378\u0904", 2},
{"\u0378\u0308\u0904", 2},
{"\u0378\u0D4E", 2},
{"\u0378\u0308\u0D4E", 2},
{"\u0378\u0915", 2},
{"\u0378\u0308\u0915", 2},
{"\u0378\u231A", 2},
{"\u0378\u0308\u231A", 2},
{"\u0378\u0300", 1},
{"\u0378\u0308\u0300", 1},
{"\u0378\u093C", 1},
{"\u0378\u0308\u093C", 1},
{"\u0378\u094D", 1},
{"\u0378\u0308\u094D", 1},
{"\u0378\u200D", 1},
{"\u0378\u0308\u200D", 1},
{"\u0378\u0378", 2},
{"\u0378\u0308\u0378", 2},
{"\u000D\u000A\u0061\u000A\u0308", 4},
{"\u0061\u0308", 1},
{"\u0020\u200D\u0646", 2},
{"\u0646\u200D\u0020", 2},
{"\u1100\u1100", 1},
{"\uAC00\u11A8\u1100", 2},
{"\uAC01\u11A8\u1100", 2},
{"\U0001F1E6\U0001F1E7\U0001F1E8\u0062", 3},
{"\u0061\U0001F1E6\U0001F1E7\U0001F1E8\u0062", 4},
{"\u0061\U0001F1E6\U0001F1E7\u200D\U0001F1E8\u0062", 4},
{"\u0061\U0001F1E6\u200D\U0001F1E7\U0001F1E8\u0062", 4},
{"\u0061\U0001F1E6\U0001F1E7\U0001F1E8\U0001F1E9\u0062", 4},
{"\u0061\u200D", 1},
{"\u0061\u0308\u0062", 2},
{"\u0061\u0903\u0062", 2},
{"\u0061\u0600\u0062", 2},
{"\U0001F476\U0001F3FF\U0001F476", 2},
{"\u0061\U0001F3FF\U0001F476", 2},
{"\u0061\U0001F3FF\U0001F476\u200D\U0001F6D1", 2},
{"\U0001F476\U0001F3FF\u0308\u200D\U0001F476\U0001F3FF", 1},
{"\U0001F6D1\u200D\U0001F6D1", 1},
{"\u0061\u200D\U0001F6D1", 2},
{"\u2701\u200D\u2701", 1},
{"\u0061\u200D\u2701", 2},
{"\u0915\u0924", 2},
{"\u0915\u094D\u0924", 1},
{"\u0915\u094D\u094D\u0924", 1},
{"\u0915\u094D\u200D\u0924", 1},
{"\u0915\u093C\u200D\u094D\u0924", 1},
{"\u0915\u093C\u094D\u200D\u0924", 1},
{"\u0915\u094D\u0924\u094D\u092F", 1},
{"\u0915\u094D\u0061", 2},
{"\u0061\u094D\u0924", 2},
{"\u003F\u094D\u0924", 2},
{"\u0915\u094D\u094D\u0924", 1},
}

// (Note that the test cases below only include the multi-codepoint cases
//  listed in the file, as these were the only relevant ones for counting
//  grapheme cluster boundaries.)
//
// https://unicode.org/Public/emoji/15.1/emoji-test.txt
//
// emoji-test.txt
// Date: 2023-06-05, 21:39:54 GMT
// © 2023 Unicode®, Inc.
// Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
// For terms of use, see https://www.unicode.org/terms_of_use.html
@(rodata)
official_emoji_test_cases := []Test_Case {
{"\u263A\uFE0F", 1},
{"\U0001F636\u200D\U0001F32B\uFE0F", 1},
{"\U0001F636\u200D\U0001F32B", 1},
{"\U0001F62E\u200D\U0001F4A8", 1},
{"\U0001F642\u200D\u2194\uFE0F", 1},
{"\U0001F642\u200D\u2194", 1},
{"\U0001F642\u200D\u2195\uFE0F", 1},
{"\U0001F642\u200D\u2195", 1},
{"\U0001F635\u200D\U0001F4AB", 1},
{"\u2639\uFE0F", 1},
{"\u2620\uFE0F", 1},
{"\u2763\uFE0F", 1},
{"\u2764\uFE0F\u200D\U0001F525", 1},
{"\u2764\u200D\U0001F525", 1},
{"\u2764\uFE0F\u200D\U0001FA79", 1},
{"\u2764\u200D\U0001FA79", 1},
{"\u2764\uFE0F", 1},
{"\U0001F573\uFE0F", 1},
{"\U0001F441\uFE0F\u200D\U0001F5E8\uFE0F", 1},
{"\U0001F441\u200D\U0001F5E8\uFE0F", 1},
{"\U0001F441\uFE0F\u200D\U0001F5E8", 1},
{"\U0001F441\u200D\U0001F5E8", 1},
{"\U0001F5E8\uFE0F", 1},
{"\U0001F5EF\uFE0F", 1},
{"\U0001F44B\U0001F3FB", 1},
{"\U0001F44B\U0001F3FC", 1},
{"\U0001F44B\U0001F3FD", 1},
{"\U0001F44B\U0001F3FE", 1},
{"\U0001F44B\U0001F3FF", 1},
{"\U0001F91A\U0001F3FB", 1},
{"\U0001F91A\U0001F3FC", 1},
{"\U0001F91A\U0001F3FD", 1},
{"\U0001F91A\U0001F3FE", 1},
{"\U0001F91A\U0001F3FF", 1},
{"\U0001F590\uFE0F", 1},
{"\U0001F590\U0001F3FB", 1},
{"\U0001F590\U0001F3FC", 1},
{"\U0001F590\U0001F3FD", 1},
{"\U0001F590\U0001F3FE", 1},
{"\U0001F590\U0001F3FF", 1},
{"\u270B\U0001F3FB", 1},
{"\u270B\U0001F3FC", 1},
{"\u270B\U0001F3FD", 1},
{"\u270B\U0001F3FE", 1},
{"\u270B\U0001F3FF", 1},
{"\U0001F596\U0001F3FB", 1},
{"\U0001F596\U0001F3FC", 1},
{"\U0001F596\U0001F3FD", 1},
{"\U0001F596\U0001F3FE", 1},
{"\U0001F596\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FB", 1},
{"\U0001FAF1\U0001F3FC", 1},
{"\U0001FAF1\U0001F3FD", 1},
{"\U0001FAF1\U0001F3FE", 1},
{"\U0001FAF1\U0001F3FF", 1},
{"\U0001FAF2\U0001F3FB", 1},
{"\U0001FAF2\U0001F3FC", 1},
{"\U0001FAF2\U0001F3FD", 1},
{"\U0001FAF2\U0001F3FE", 1},
{"\U0001FAF2\U0001F3FF", 1},
{"\U0001FAF3\U0001F3FB", 1},
{"\U0001FAF3\U0001F3FC", 1},
{"\U0001FAF3\U0001F3FD", 1},
{"\U0001FAF3\U0001F3FE", 1},
{"\U0001FAF3\U0001F3FF", 1},
{"\U0001FAF4\U0001F3FB", 1},
{"\U0001FAF4\U0001F3FC", 1},
{"\U0001FAF4\U0001F3FD", 1},
{"\U0001FAF4\U0001F3FE", 1},
{"\U0001FAF4\U0001F3FF", 1},
{"\U0001FAF7\U0001F3FB", 1},
{"\U0001FAF7\U0001F3FC", 1},
{"\U0001FAF7\U0001F3FD", 1},
{"\U0001FAF7\U0001F3FE", 1},
{"\U0001FAF7\U0001F3FF", 1},
{"\U0001FAF8\U0001F3FB", 1},
{"\U0001FAF8\U0001F3FC", 1},
{"\U0001FAF8\U0001F3FD", 1},
{"\U0001FAF8\U0001F3FE", 1},
{"\U0001FAF8\U0001F3FF", 1},
{"\U0001F44C\U0001F3FB", 1},
{"\U0001F44C\U0001F3FC", 1},
{"\U0001F44C\U0001F3FD", 1},
{"\U0001F44C\U0001F3FE", 1},
{"\U0001F44C\U0001F3FF", 1},
{"\U0001F90C\U0001F3FB", 1},
{"\U0001F90C\U0001F3FC", 1},
{"\U0001F90C\U0001F3FD", 1},
{"\U0001F90C\U0001F3FE", 1},
{"\U0001F90C\U0001F3FF", 1},
{"\U0001F90F\U0001F3FB", 1},
{"\U0001F90F\U0001F3FC", 1},
{"\U0001F90F\U0001F3FD", 1},
{"\U0001F90F\U0001F3FE", 1},
{"\U0001F90F\U0001F3FF", 1},
{"\u270C\uFE0F", 1},
{"\u270C\U0001F3FB", 1},
{"\u270C\U0001F3FC", 1},
{"\u270C\U0001F3FD", 1},
{"\u270C\U0001F3FE", 1},
{"\u270C\U0001F3FF", 1},
{"\U0001F91E\U0001F3FB", 1},
{"\U0001F91E\U0001F3FC", 1},
{"\U0001F91E\U0001F3FD", 1},
{"\U0001F91E\U0001F3FE", 1},
{"\U0001F91E\U0001F3FF", 1},
{"\U0001FAF0\U0001F3FB", 1},
{"\U0001FAF0\U0001F3FC", 1},
{"\U0001FAF0\U0001F3FD", 1},
{"\U0001FAF0\U0001F3FE", 1},
{"\U0001FAF0\U0001F3FF", 1},
{"\U0001F91F\U0001F3FB", 1},
{"\U0001F91F\U0001F3FC", 1},
{"\U0001F91F\U0001F3FD", 1},
{"\U0001F91F\U0001F3FE", 1},
{"\U0001F91F\U0001F3FF", 1},
{"\U0001F918\U0001F3FB", 1},
{"\U0001F918\U0001F3FC", 1},
{"\U0001F918\U0001F3FD", 1},
{"\U0001F918\U0001F3FE", 1},
{"\U0001F918\U0001F3FF", 1},
{"\U0001F919\U0001F3FB", 1},
{"\U0001F919\U0001F3FC", 1},
{"\U0001F919\U0001F3FD", 1},
{"\U0001F919\U0001F3FE", 1},
{"\U0001F919\U0001F3FF", 1},
{"\U0001F448\U0001F3FB", 1},
{"\U0001F448\U0001F3FC", 1},
{"\U0001F448\U0001F3FD", 1},
{"\U0001F448\U0001F3FE", 1},
{"\U0001F448\U0001F3FF", 1},
{"\U0001F449\U0001F3FB", 1},
{"\U0001F449\U0001F3FC", 1},
{"\U0001F449\U0001F3FD", 1},
{"\U0001F449\U0001F3FE", 1},
{"\U0001F449\U0001F3FF", 1},
{"\U0001F446\U0001F3FB", 1},
{"\U0001F446\U0001F3FC", 1},
{"\U0001F446\U0001F3FD", 1},
{"\U0001F446\U0001F3FE", 1},
{"\U0001F446\U0001F3FF", 1},
{"\U0001F595\U0001F3FB", 1},
{"\U0001F595\U0001F3FC", 1},
{"\U0001F595\U0001F3FD", 1},
{"\U0001F595\U0001F3FE", 1},
{"\U0001F595\U0001F3FF", 1},
{"\U0001F447\U0001F3FB", 1},
{"\U0001F447\U0001F3FC", 1},
{"\U0001F447\U0001F3FD", 1},
{"\U0001F447\U0001F3FE", 1},
{"\U0001F447\U0001F3FF", 1},
{"\u261D\uFE0F", 1},
{"\u261D\U0001F3FB", 1},
{"\u261D\U0001F3FC", 1},
{"\u261D\U0001F3FD", 1},
{"\u261D\U0001F3FE", 1},
{"\u261D\U0001F3FF", 1},
{"\U0001FAF5\U0001F3FB", 1},
{"\U0001FAF5\U0001F3FC", 1},
{"\U0001FAF5\U0001F3FD", 1},
{"\U0001FAF5\U0001F3FE", 1},
{"\U0001FAF5\U0001F3FF", 1},
{"\U0001F44D\U0001F3FB", 1},
{"\U0001F44D\U0001F3FC", 1},
{"\U0001F44D\U0001F3FD", 1},
{"\U0001F44D\U0001F3FE", 1},
{"\U0001F44D\U0001F3FF", 1},
{"\U0001F44E\U0001F3FB", 1},
{"\U0001F44E\U0001F3FC", 1},
{"\U0001F44E\U0001F3FD", 1},
{"\U0001F44E\U0001F3FE", 1},
{"\U0001F44E\U0001F3FF", 1},
{"\u270A\U0001F3FB", 1},
{"\u270A\U0001F3FC", 1},
{"\u270A\U0001F3FD", 1},
{"\u270A\U0001F3FE", 1},
{"\u270A\U0001F3FF", 1},
{"\U0001F44A\U0001F3FB", 1},
{"\U0001F44A\U0001F3FC", 1},
{"\U0001F44A\U0001F3FD", 1},
{"\U0001F44A\U0001F3FE", 1},
{"\U0001F44A\U0001F3FF", 1},
{"\U0001F91B\U0001F3FB", 1},
{"\U0001F91B\U0001F3FC", 1},
{"\U0001F91B\U0001F3FD", 1},
{"\U0001F91B\U0001F3FE", 1},
{"\U0001F91B\U0001F3FF", 1},
{"\U0001F91C\U0001F3FB", 1},
{"\U0001F91C\U0001F3FC", 1},
{"\U0001F91C\U0001F3FD", 1},
{"\U0001F91C\U0001F3FE", 1},
{"\U0001F91C\U0001F3FF", 1},
{"\U0001F44F\U0001F3FB", 1},
{"\U0001F44F\U0001F3FC", 1},
{"\U0001F44F\U0001F3FD", 1},
{"\U0001F44F\U0001F3FE", 1},
{"\U0001F44F\U0001F3FF", 1},
{"\U0001F64C\U0001F3FB", 1},
{"\U0001F64C\U0001F3FC", 1},
{"\U0001F64C\U0001F3FD", 1},
{"\U0001F64C\U0001F3FE", 1},
{"\U0001F64C\U0001F3FF", 1},
{"\U0001FAF6\U0001F3FB", 1},
{"\U0001FAF6\U0001F3FC", 1},
{"\U0001FAF6\U0001F3FD", 1},
{"\U0001FAF6\U0001F3FE", 1},
{"\U0001FAF6\U0001F3FF", 1},
{"\U0001F450\U0001F3FB", 1},
{"\U0001F450\U0001F3FC", 1},
{"\U0001F450\U0001F3FD", 1},
{"\U0001F450\U0001F3FE", 1},
{"\U0001F450\U0001F3FF", 1},
{"\U0001F932\U0001F3FB", 1},
{"\U0001F932\U0001F3FC", 1},
{"\U0001F932\U0001F3FD", 1},
{"\U0001F932\U0001F3FE", 1},
{"\U0001F932\U0001F3FF", 1},
{"\U0001F91D\U0001F3FB", 1},
{"\U0001F91D\U0001F3FC", 1},
{"\U0001F91D\U0001F3FD", 1},
{"\U0001F91D\U0001F3FE", 1},
{"\U0001F91D\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FB\u200D\U0001FAF2\U0001F3FC", 1},
{"\U0001FAF1\U0001F3FB\u200D\U0001FAF2\U0001F3FD", 1},
{"\U0001FAF1\U0001F3FB\u200D\U0001FAF2\U0001F3FE", 1},
{"\U0001FAF1\U0001F3FB\u200D\U0001FAF2\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FC\u200D\U0001FAF2\U0001F3FB", 1},
{"\U0001FAF1\U0001F3FC\u200D\U0001FAF2\U0001F3FD", 1},
{"\U0001FAF1\U0001F3FC\u200D\U0001FAF2\U0001F3FE", 1},
{"\U0001FAF1\U0001F3FC\u200D\U0001FAF2\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FD\u200D\U0001FAF2\U0001F3FB", 1},
{"\U0001FAF1\U0001F3FD\u200D\U0001FAF2\U0001F3FC", 1},
{"\U0001FAF1\U0001F3FD\u200D\U0001FAF2\U0001F3FE", 1},
{"\U0001FAF1\U0001F3FD\u200D\U0001FAF2\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FE\u200D\U0001FAF2\U0001F3FB", 1},
{"\U0001FAF1\U0001F3FE\u200D\U0001FAF2\U0001F3FC", 1},
{"\U0001FAF1\U0001F3FE\u200D\U0001FAF2\U0001F3FD", 1},
{"\U0001FAF1\U0001F3FE\u200D\U0001FAF2\U0001F3FF", 1},
{"\U0001FAF1\U0001F3FF\u200D\U0001FAF2\U0001F3FB", 1},
{"\U0001FAF1\U0001F3FF\u200D\U0001FAF2\U0001F3FC", 1},
{"\U0001FAF1\U0001F3FF\u200D\U0001FAF2\U0001F3FD", 1},
{"\U0001FAF1\U0001F3FF\u200D\U0001FAF2\U0001F3FE", 1},
{"\U0001F64F\U0001F3FB", 1},
{"\U0001F64F\U0001F3FC", 1},
{"\U0001F64F\U0001F3FD", 1},
{"\U0001F64F\U0001F3FE", 1},
{"\U0001F64F\U0001F3FF", 1},
{"\u270D\uFE0F", 1},
{"\u270D\U0001F3FB", 1},
{"\u270D\U0001F3FC", 1},
{"\u270D\U0001F3FD", 1},
{"\u270D\U0001F3FE", 1},
{"\u270D\U0001F3FF", 1},
{"\U0001F485\U0001F3FB", 1},
{"\U0001F485\U0001F3FC", 1},
{"\U0001F485\U0001F3FD", 1},
{"\U0001F485\U0001F3FE", 1},
{"\U0001F485\U0001F3FF", 1},
{"\U0001F933\U0001F3FB", 1},
{"\U0001F933\U0001F3FC", 1},
{"\U0001F933\U0001F3FD", 1},
{"\U0001F933\U0001F3FE", 1},
{"\U0001F933\U0001F3FF", 1},
{"\U0001F4AA\U0001F3FB", 1},
{"\U0001F4AA\U0001F3FC", 1},
{"\U0001F4AA\U0001F3FD", 1},
{"\U0001F4AA\U0001F3FE", 1},
{"\U0001F4AA\U0001F3FF", 1},
{"\U0001F9B5\U0001F3FB", 1},
{"\U0001F9B5\U0001F3FC", 1},
{"\U0001F9B5\U0001F3FD", 1},
{"\U0001F9B5\U0001F3FE", 1},
{"\U0001F9B5\U0001F3FF", 1},
{"\U0001F9B6\U0001F3FB", 1},
{"\U0001F9B6\U0001F3FC", 1},
{"\U0001F9B6\U0001F3FD", 1},
{"\U0001F9B6\U0001F3FE", 1},
{"\U0001F9B6\U0001F3FF", 1},
{"\U0001F442\U0001F3FB", 1},
{"\U0001F442\U0001F3FC", 1},
{"\U0001F442\U0001F3FD", 1},
{"\U0001F442\U0001F3FE", 1},
{"\U0001F442\U0001F3FF", 1},
{"\U0001F9BB\U0001F3FB", 1},
{"\U0001F9BB\U0001F3FC", 1},
{"\U0001F9BB\U0001F3FD", 1},
{"\U0001F9BB\U0001F3FE", 1},
{"\U0001F9BB\U0001F3FF", 1},
{"\U0001F443\U0001F3FB", 1},
{"\U0001F443\U0001F3FC", 1},
{"\U0001F443\U0001F3FD", 1},
{"\U0001F443\U0001F3FE", 1},
{"\U0001F443\U0001F3FF", 1},
{"\U0001F441\uFE0F", 1},
{"\U0001F476\U0001F3FB", 1},
{"\U0001F476\U0001F3FC", 1},
{"\U0001F476\U0001F3FD", 1},
{"\U0001F476\U0001F3FE", 1},
{"\U0001F476\U0001F3FF", 1},
{"\U0001F9D2\U0001F3FB", 1},
{"\U0001F9D2\U0001F3FC", 1},
{"\U0001F9D2\U0001F3FD", 1},
{"\U0001F9D2\U0001F3FE", 1},
{"\U0001F9D2\U0001F3FF", 1},
{"\U0001F466\U0001F3FB", 1},
{"\U0001F466\U0001F3FC", 1},
{"\U0001F466\U0001F3FD", 1},
{"\U0001F466\U0001F3FE", 1},
{"\U0001F466\U0001F3FF", 1},
{"\U0001F467\U0001F3FB", 1},
{"\U0001F467\U0001F3FC", 1},
{"\U0001F467\U0001F3FD", 1},
{"\U0001F467\U0001F3FE", 1},
{"\U0001F467\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FF", 1},
{"\U0001F471\U0001F3FB", 1},
{"\U0001F471\U0001F3FC", 1},
{"\U0001F471\U0001F3FD", 1},
{"\U0001F471\U0001F3FE", 1},
{"\U0001F471\U0001F3FF", 1},
{"\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FF", 1},
{"\U0001F9D4\U0001F3FB", 1},
{"\U0001F9D4\U0001F3FC", 1},
{"\U0001F9D4\U0001F3FD", 1},
{"\U0001F9D4\U0001F3FE", 1},
{"\U0001F9D4\U0001F3FF", 1},
{"\U0001F9D4\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\u200D\u2642", 1},
{"\U0001F9D4\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\U0001F3FB\u200D\u2642", 1},
{"\U0001F9D4\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\U0001F3FC\u200D\u2642", 1},
{"\U0001F9D4\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\U0001F3FD\u200D\u2642", 1},
{"\U0001F9D4\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\U0001F3FE\u200D\u2642", 1},
{"\U0001F9D4\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9D4\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D4\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\u200D\u2640", 1},
{"\U0001F9D4\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\U0001F3FB\u200D\u2640", 1},
{"\U0001F9D4\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\U0001F3FC\u200D\u2640", 1},
{"\U0001F9D4\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\U0001F3FD\u200D\u2640", 1},
{"\U0001F9D4\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\U0001F3FE\u200D\u2640", 1},
{"\U0001F9D4\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9D4\U0001F3FF\u200D\u2640", 1},
{"\U0001F468\u200D\U0001F9B0", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9B0", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9B0", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9B0", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9B0", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9B0", 1},
{"\U0001F468\u200D\U0001F9B1", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9B1", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9B1", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9B1", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9B1", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9B1", 1},
{"\U0001F468\u200D\U0001F9B3", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9B3", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9B3", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9B3", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9B3", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9B3", 1},
{"\U0001F468\u200D\U0001F9B2", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9B2", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9B2", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9B2", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9B2", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FF", 1},
{"\U0001F469\u200D\U0001F9B0", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9B0", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9B0", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9B0", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9B0", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9B0", 1},
{"\U0001F9D1\u200D\U0001F9B0", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9B0", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9B0", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9B0", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9B0", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9B0", 1},
{"\U0001F469\u200D\U0001F9B1", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9B1", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9B1", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9B1", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9B1", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9B1", 1},
{"\U0001F9D1\u200D\U0001F9B1", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9B1", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9B1", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9B1", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9B1", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9B1", 1},
{"\U0001F469\u200D\U0001F9B3", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9B3", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9B3", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9B3", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9B3", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9B3", 1},
{"\U0001F9D1\u200D\U0001F9B3", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9B3", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9B3", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9B3", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9B3", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9B3", 1},
{"\U0001F469\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9B2", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9B2", 1},
{"\U0001F9D1\u200D\U0001F9B2", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9B2", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9B2", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9B2", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9B2", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9B2", 1},
{"\U0001F471\u200D\u2640\uFE0F", 1},
{"\U0001F471\u200D\u2640", 1},
{"\U0001F471\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F471\U0001F3FB\u200D\u2640", 1},
{"\U0001F471\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F471\U0001F3FC\u200D\u2640", 1},
{"\U0001F471\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F471\U0001F3FD\u200D\u2640", 1},
{"\U0001F471\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F471\U0001F3FE\u200D\u2640", 1},
{"\U0001F471\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F471\U0001F3FF\u200D\u2640", 1},
{"\U0001F471\u200D\u2642\uFE0F", 1},
{"\U0001F471\u200D\u2642", 1},
{"\U0001F471\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F471\U0001F3FB\u200D\u2642", 1},
{"\U0001F471\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F471\U0001F3FC\u200D\u2642", 1},
{"\U0001F471\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F471\U0001F3FD\u200D\u2642", 1},
{"\U0001F471\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F471\U0001F3FE\u200D\u2642", 1},
{"\U0001F471\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F471\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D3\U0001F3FB", 1},
{"\U0001F9D3\U0001F3FC", 1},
{"\U0001F9D3\U0001F3FD", 1},
{"\U0001F9D3\U0001F3FE", 1},
{"\U0001F9D3\U0001F3FF", 1},
{"\U0001F474\U0001F3FB", 1},
{"\U0001F474\U0001F3FC", 1},
{"\U0001F474\U0001F3FD", 1},
{"\U0001F474\U0001F3FE", 1},
{"\U0001F474\U0001F3FF", 1},
{"\U0001F475\U0001F3FB", 1},
{"\U0001F475\U0001F3FC", 1},
{"\U0001F475\U0001F3FD", 1},
{"\U0001F475\U0001F3FE", 1},
{"\U0001F475\U0001F3FF", 1},
{"\U0001F64D\U0001F3FB", 1},
{"\U0001F64D\U0001F3FC", 1},
{"\U0001F64D\U0001F3FD", 1},
{"\U0001F64D\U0001F3FE", 1},
{"\U0001F64D\U0001F3FF", 1},
{"\U0001F64D\u200D\u2642\uFE0F", 1},
{"\U0001F64D\u200D\u2642", 1},
{"\U0001F64D\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F64D\U0001F3FB\u200D\u2642", 1},
{"\U0001F64D\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F64D\U0001F3FC\u200D\u2642", 1},
{"\U0001F64D\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F64D\U0001F3FD\u200D\u2642", 1},
{"\U0001F64D\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F64D\U0001F3FE\u200D\u2642", 1},
{"\U0001F64D\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F64D\U0001F3FF\u200D\u2642", 1},
{"\U0001F64D\u200D\u2640\uFE0F", 1},
{"\U0001F64D\u200D\u2640", 1},
{"\U0001F64D\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F64D\U0001F3FB\u200D\u2640", 1},
{"\U0001F64D\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F64D\U0001F3FC\u200D\u2640", 1},
{"\U0001F64D\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F64D\U0001F3FD\u200D\u2640", 1},
{"\U0001F64D\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F64D\U0001F3FE\u200D\u2640", 1},
{"\U0001F64D\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F64D\U0001F3FF\u200D\u2640", 1},
{"\U0001F64E\U0001F3FB", 1},
{"\U0001F64E\U0001F3FC", 1},
{"\U0001F64E\U0001F3FD", 1},
{"\U0001F64E\U0001F3FE", 1},
{"\U0001F64E\U0001F3FF", 1},
{"\U0001F64E\u200D\u2642\uFE0F", 1},
{"\U0001F64E\u200D\u2642", 1},
{"\U0001F64E\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F64E\U0001F3FB\u200D\u2642", 1},
{"\U0001F64E\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F64E\U0001F3FC\u200D\u2642", 1},
{"\U0001F64E\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F64E\U0001F3FD\u200D\u2642", 1},
{"\U0001F64E\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F64E\U0001F3FE\u200D\u2642", 1},
{"\U0001F64E\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F64E\U0001F3FF\u200D\u2642", 1},
{"\U0001F64E\u200D\u2640\uFE0F", 1},
{"\U0001F64E\u200D\u2640", 1},
{"\U0001F64E\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F64E\U0001F3FB\u200D\u2640", 1},
{"\U0001F64E\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F64E\U0001F3FC\u200D\u2640", 1},
{"\U0001F64E\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F64E\U0001F3FD\u200D\u2640", 1},
{"\U0001F64E\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F64E\U0001F3FE\u200D\u2640", 1},
{"\U0001F64E\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F64E\U0001F3FF\u200D\u2640", 1},
{"\U0001F645\U0001F3FB", 1},
{"\U0001F645\U0001F3FC", 1},
{"\U0001F645\U0001F3FD", 1},
{"\U0001F645\U0001F3FE", 1},
{"\U0001F645\U0001F3FF", 1},
{"\U0001F645\u200D\u2642\uFE0F", 1},
{"\U0001F645\u200D\u2642", 1},
{"\U0001F645\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F645\U0001F3FB\u200D\u2642", 1},
{"\U0001F645\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F645\U0001F3FC\u200D\u2642", 1},
{"\U0001F645\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F645\U0001F3FD\u200D\u2642", 1},
{"\U0001F645\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F645\U0001F3FE\u200D\u2642", 1},
{"\U0001F645\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F645\U0001F3FF\u200D\u2642", 1},
{"\U0001F645\u200D\u2640\uFE0F", 1},
{"\U0001F645\u200D\u2640", 1},
{"\U0001F645\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F645\U0001F3FB\u200D\u2640", 1},
{"\U0001F645\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F645\U0001F3FC\u200D\u2640", 1},
{"\U0001F645\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F645\U0001F3FD\u200D\u2640", 1},
{"\U0001F645\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F645\U0001F3FE\u200D\u2640", 1},
{"\U0001F645\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F645\U0001F3FF\u200D\u2640", 1},
{"\U0001F646\U0001F3FB", 1},
{"\U0001F646\U0001F3FC", 1},
{"\U0001F646\U0001F3FD", 1},
{"\U0001F646\U0001F3FE", 1},
{"\U0001F646\U0001F3FF", 1},
{"\U0001F646\u200D\u2642\uFE0F", 1},
{"\U0001F646\u200D\u2642", 1},
{"\U0001F646\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F646\U0001F3FB\u200D\u2642", 1},
{"\U0001F646\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F646\U0001F3FC\u200D\u2642", 1},
{"\U0001F646\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F646\U0001F3FD\u200D\u2642", 1},
{"\U0001F646\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F646\U0001F3FE\u200D\u2642", 1},
{"\U0001F646\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F646\U0001F3FF\u200D\u2642", 1},
{"\U0001F646\u200D\u2640\uFE0F", 1},
{"\U0001F646\u200D\u2640", 1},
{"\U0001F646\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F646\U0001F3FB\u200D\u2640", 1},
{"\U0001F646\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F646\U0001F3FC\u200D\u2640", 1},
{"\U0001F646\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F646\U0001F3FD\u200D\u2640", 1},
{"\U0001F646\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F646\U0001F3FE\u200D\u2640", 1},
{"\U0001F646\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F646\U0001F3FF\u200D\u2640", 1},
{"\U0001F481\U0001F3FB", 1},
{"\U0001F481\U0001F3FC", 1},
{"\U0001F481\U0001F3FD", 1},
{"\U0001F481\U0001F3FE", 1},
{"\U0001F481\U0001F3FF", 1},
{"\U0001F481\u200D\u2642\uFE0F", 1},
{"\U0001F481\u200D\u2642", 1},
{"\U0001F481\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F481\U0001F3FB\u200D\u2642", 1},
{"\U0001F481\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F481\U0001F3FC\u200D\u2642", 1},
{"\U0001F481\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F481\U0001F3FD\u200D\u2642", 1},
{"\U0001F481\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F481\U0001F3FE\u200D\u2642", 1},
{"\U0001F481\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F481\U0001F3FF\u200D\u2642", 1},
{"\U0001F481\u200D\u2640\uFE0F", 1},
{"\U0001F481\u200D\u2640", 1},
{"\U0001F481\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F481\U0001F3FB\u200D\u2640", 1},
{"\U0001F481\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F481\U0001F3FC\u200D\u2640", 1},
{"\U0001F481\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F481\U0001F3FD\u200D\u2640", 1},
{"\U0001F481\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F481\U0001F3FE\u200D\u2640", 1},
{"\U0001F481\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F481\U0001F3FF\u200D\u2640", 1},
{"\U0001F64B\U0001F3FB", 1},
{"\U0001F64B\U0001F3FC", 1},
{"\U0001F64B\U0001F3FD", 1},
{"\U0001F64B\U0001F3FE", 1},
{"\U0001F64B\U0001F3FF", 1},
{"\U0001F64B\u200D\u2642\uFE0F", 1},
{"\U0001F64B\u200D\u2642", 1},
{"\U0001F64B\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F64B\U0001F3FB\u200D\u2642", 1},
{"\U0001F64B\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F64B\U0001F3FC\u200D\u2642", 1},
{"\U0001F64B\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F64B\U0001F3FD\u200D\u2642", 1},
{"\U0001F64B\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F64B\U0001F3FE\u200D\u2642", 1},
{"\U0001F64B\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F64B\U0001F3FF\u200D\u2642", 1},
{"\U0001F64B\u200D\u2640\uFE0F", 1},
{"\U0001F64B\u200D\u2640", 1},
{"\U0001F64B\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F64B\U0001F3FB\u200D\u2640", 1},
{"\U0001F64B\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F64B\U0001F3FC\u200D\u2640", 1},
{"\U0001F64B\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F64B\U0001F3FD\u200D\u2640", 1},
{"\U0001F64B\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F64B\U0001F3FE\u200D\u2640", 1},
{"\U0001F64B\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F64B\U0001F3FF\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FB", 1},
{"\U0001F9CF\U0001F3FC", 1},
{"\U0001F9CF\U0001F3FD", 1},
{"\U0001F9CF\U0001F3FE", 1},
{"\U0001F9CF\U0001F3FF", 1},
{"\U0001F9CF\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\u200D\u2642", 1},
{"\U0001F9CF\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\U0001F3FB\u200D\u2642", 1},
{"\U0001F9CF\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\U0001F3FC\u200D\u2642", 1},
{"\U0001F9CF\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\U0001F3FD\u200D\u2642", 1},
{"\U0001F9CF\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\U0001F3FE\u200D\u2642", 1},
{"\U0001F9CF\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9CF\U0001F3FF\u200D\u2642", 1},
{"\U0001F9CF\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\U0001F3FB\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\U0001F3FC\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\U0001F3FD\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\U0001F3FE\u200D\u2640", 1},
{"\U0001F9CF\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9CF\U0001F3FF\u200D\u2640", 1},
{"\U0001F647\U0001F3FB", 1},
{"\U0001F647\U0001F3FC", 1},
{"\U0001F647\U0001F3FD", 1},
{"\U0001F647\U0001F3FE", 1},
{"\U0001F647\U0001F3FF", 1},
{"\U0001F647\u200D\u2642\uFE0F", 1},
{"\U0001F647\u200D\u2642", 1},
{"\U0001F647\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F647\U0001F3FB\u200D\u2642", 1},
{"\U0001F647\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F647\U0001F3FC\u200D\u2642", 1},
{"\U0001F647\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F647\U0001F3FD\u200D\u2642", 1},
{"\U0001F647\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F647\U0001F3FE\u200D\u2642", 1},
{"\U0001F647\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F647\U0001F3FF\u200D\u2642", 1},
{"\U0001F647\u200D\u2640\uFE0F", 1},
{"\U0001F647\u200D\u2640", 1},
{"\U0001F647\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F647\U0001F3FB\u200D\u2640", 1},
{"\U0001F647\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F647\U0001F3FC\u200D\u2640", 1},
{"\U0001F647\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F647\U0001F3FD\u200D\u2640", 1},
{"\U0001F647\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F647\U0001F3FE\u200D\u2640", 1},
{"\U0001F647\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F647\U0001F3FF\u200D\u2640", 1},
{"\U0001F926\U0001F3FB", 1},
{"\U0001F926\U0001F3FC", 1},
{"\U0001F926\U0001F3FD", 1},
{"\U0001F926\U0001F3FE", 1},
{"\U0001F926\U0001F3FF", 1},
{"\U0001F926\u200D\u2642\uFE0F", 1},
{"\U0001F926\u200D\u2642", 1},
{"\U0001F926\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F926\U0001F3FB\u200D\u2642", 1},
{"\U0001F926\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F926\U0001F3FC\u200D\u2642", 1},
{"\U0001F926\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F926\U0001F3FD\u200D\u2642", 1},
{"\U0001F926\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F926\U0001F3FE\u200D\u2642", 1},
{"\U0001F926\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F926\U0001F3FF\u200D\u2642", 1},
{"\U0001F926\u200D\u2640\uFE0F", 1},
{"\U0001F926\u200D\u2640", 1},
{"\U0001F926\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F926\U0001F3FB\u200D\u2640", 1},
{"\U0001F926\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F926\U0001F3FC\u200D\u2640", 1},
{"\U0001F926\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F926\U0001F3FD\u200D\u2640", 1},
{"\U0001F926\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F926\U0001F3FE\u200D\u2640", 1},
{"\U0001F926\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F926\U0001F3FF\u200D\u2640", 1},
{"\U0001F937\U0001F3FB", 1},
{"\U0001F937\U0001F3FC", 1},
{"\U0001F937\U0001F3FD", 1},
{"\U0001F937\U0001F3FE", 1},
{"\U0001F937\U0001F3FF", 1},
{"\U0001F937\u200D\u2642\uFE0F", 1},
{"\U0001F937\u200D\u2642", 1},
{"\U0001F937\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F937\U0001F3FB\u200D\u2642", 1},
{"\U0001F937\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F937\U0001F3FC\u200D\u2642", 1},
{"\U0001F937\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F937\U0001F3FD\u200D\u2642", 1},
{"\U0001F937\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F937\U0001F3FE\u200D\u2642", 1},
{"\U0001F937\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F937\U0001F3FF\u200D\u2642", 1},
{"\U0001F937\u200D\u2640\uFE0F", 1},
{"\U0001F937\u200D\u2640", 1},
{"\U0001F937\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F937\U0001F3FB\u200D\u2640", 1},
{"\U0001F937\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F937\U0001F3FC\u200D\u2640", 1},
{"\U0001F937\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F937\U0001F3FD\u200D\u2640", 1},
{"\U0001F937\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F937\U0001F3FE\u200D\u2640", 1},
{"\U0001F937\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F937\U0001F3FF\u200D\u2640", 1},
{"\U0001F9D1\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\u200D\u2695", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2695", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2695", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2695", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2695", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2695\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2695", 1},
{"\U0001F468\u200D\u2695\uFE0F", 1},
{"\U0001F468\u200D\u2695", 1},
{"\U0001F468\U0001F3FB\u200D\u2695\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\u2695", 1},
{"\U0001F468\U0001F3FC\u200D\u2695\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\u2695", 1},
{"\U0001F468\U0001F3FD\u200D\u2695\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\u2695", 1},
{"\U0001F468\U0001F3FE\u200D\u2695\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\u2695", 1},
{"\U0001F468\U0001F3FF\u200D\u2695\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\u2695", 1},
{"\U0001F469\u200D\u2695\uFE0F", 1},
{"\U0001F469\u200D\u2695", 1},
{"\U0001F469\U0001F3FB\u200D\u2695\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\u2695", 1},
{"\U0001F469\U0001F3FC\u200D\u2695\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\u2695", 1},
{"\U0001F469\U0001F3FD\u200D\u2695\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\u2695", 1},
{"\U0001F469\U0001F3FE\u200D\u2695\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\u2695", 1},
{"\U0001F469\U0001F3FF\u200D\u2695\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\u2695", 1},
{"\U0001F9D1\u200D\U0001F393", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F393", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F393", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F393", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F393", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F393", 1},
{"\U0001F468\u200D\U0001F393", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F393", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F393", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F393", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F393", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F393", 1},
{"\U0001F469\u200D\U0001F393", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F393", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F393", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F393", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F393", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F393", 1},
{"\U0001F9D1\u200D\U0001F3EB", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F3EB", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F3EB", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F3EB", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F3EB", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F3EB", 1},
{"\U0001F468\u200D\U0001F3EB", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F3EB", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F3EB", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F3EB", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F3EB", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F3EB", 1},
{"\U0001F469\u200D\U0001F3EB", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F3EB", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F3EB", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F3EB", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F3EB", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F3EB", 1},
{"\U0001F9D1\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\u200D\u2696", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2696", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2696", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2696", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2696", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2696\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2696", 1},
{"\U0001F468\u200D\u2696\uFE0F", 1},
{"\U0001F468\u200D\u2696", 1},
{"\U0001F468\U0001F3FB\u200D\u2696\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\u2696", 1},
{"\U0001F468\U0001F3FC\u200D\u2696\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\u2696", 1},
{"\U0001F468\U0001F3FD\u200D\u2696\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\u2696", 1},
{"\U0001F468\U0001F3FE\u200D\u2696\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\u2696", 1},
{"\U0001F468\U0001F3FF\u200D\u2696\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\u2696", 1},
{"\U0001F469\u200D\u2696\uFE0F", 1},
{"\U0001F469\u200D\u2696", 1},
{"\U0001F469\U0001F3FB\u200D\u2696\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\u2696", 1},
{"\U0001F469\U0001F3FC\u200D\u2696\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\u2696", 1},
{"\U0001F469\U0001F3FD\u200D\u2696\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\u2696", 1},
{"\U0001F469\U0001F3FE\u200D\u2696\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\u2696", 1},
{"\U0001F469\U0001F3FF\u200D\u2696\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\u2696", 1},
{"\U0001F9D1\u200D\U0001F33E", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F33E", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F33E", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F33E", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F33E", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F33E", 1},
{"\U0001F468\u200D\U0001F33E", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F33E", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F33E", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F33E", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F33E", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F33E", 1},
{"\U0001F469\u200D\U0001F33E", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F33E", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F33E", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F33E", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F33E", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F33E", 1},
{"\U0001F9D1\u200D\U0001F373", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F373", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F373", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F373", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F373", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F373", 1},
{"\U0001F468\u200D\U0001F373", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F373", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F373", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F373", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F373", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F373", 1},
{"\U0001F469\u200D\U0001F373", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F373", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F373", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F373", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F373", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F373", 1},
{"\U0001F9D1\u200D\U0001F527", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F527", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F527", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F527", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F527", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F527", 1},
{"\U0001F468\u200D\U0001F527", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F527", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F527", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F527", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F527", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F527", 1},
{"\U0001F469\u200D\U0001F527", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F527", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F527", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F527", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F527", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F527", 1},
{"\U0001F9D1\u200D\U0001F3ED", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F3ED", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F3ED", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F3ED", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F3ED", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F3ED", 1},
{"\U0001F468\u200D\U0001F3ED", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F3ED", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F3ED", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F3ED", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F3ED", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F3ED", 1},
{"\U0001F469\u200D\U0001F3ED", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F3ED", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F3ED", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F3ED", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F3ED", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F3ED", 1},
{"\U0001F9D1\u200D\U0001F4BC", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F4BC", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F4BC", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F4BC", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F4BC", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F4BC", 1},
{"\U0001F468\u200D\U0001F4BC", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F4BC", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F4BC", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F4BC", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F4BC", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F4BC", 1},
{"\U0001F469\u200D\U0001F4BC", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F4BC", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F4BC", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F4BC", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F4BC", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F4BC", 1},
{"\U0001F9D1\u200D\U0001F52C", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F52C", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F52C", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F52C", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F52C", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F52C", 1},
{"\U0001F468\u200D\U0001F52C", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F52C", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F52C", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F52C", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F52C", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F52C", 1},
{"\U0001F469\u200D\U0001F52C", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F52C", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F52C", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F52C", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F52C", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F52C", 1},
{"\U0001F9D1\u200D\U0001F4BB", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F4BB", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F4BB", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F4BB", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F4BB", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F4BB", 1},
{"\U0001F468\u200D\U0001F4BB", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F4BB", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F4BB", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F4BB", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F4BB", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F4BB", 1},
{"\U0001F469\u200D\U0001F4BB", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F4BB", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F4BB", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F4BB", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F4BB", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F4BB", 1},
{"\U0001F9D1\u200D\U0001F3A4", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F3A4", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F3A4", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F3A4", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F3A4", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F3A4", 1},
{"\U0001F468\u200D\U0001F3A4", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F3A4", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F3A4", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F3A4", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F3A4", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F3A4", 1},
{"\U0001F469\u200D\U0001F3A4", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F3A4", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F3A4", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F3A4", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F3A4", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F3A4", 1},
{"\U0001F9D1\u200D\U0001F3A8", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F3A8", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F3A8", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F3A8", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F3A8", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F3A8", 1},
{"\U0001F468\u200D\U0001F3A8", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F3A8", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F3A8", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F3A8", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F3A8", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F3A8", 1},
{"\U0001F469\u200D\U0001F3A8", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F3A8", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F3A8", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F3A8", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F3A8", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F3A8", 1},
{"\U0001F9D1\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\u200D\u2708", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2708", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2708", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2708", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2708", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2708\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2708", 1},
{"\U0001F468\u200D\u2708\uFE0F", 1},
{"\U0001F468\u200D\u2708", 1},
{"\U0001F468\U0001F3FB\u200D\u2708\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\u2708", 1},
{"\U0001F468\U0001F3FC\u200D\u2708\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\u2708", 1},
{"\U0001F468\U0001F3FD\u200D\u2708\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\u2708", 1},
{"\U0001F468\U0001F3FE\u200D\u2708\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\u2708", 1},
{"\U0001F468\U0001F3FF\u200D\u2708\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\u2708", 1},
{"\U0001F469\u200D\u2708\uFE0F", 1},
{"\U0001F469\u200D\u2708", 1},
{"\U0001F469\U0001F3FB\u200D\u2708\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\u2708", 1},
{"\U0001F469\U0001F3FC\u200D\u2708\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\u2708", 1},
{"\U0001F469\U0001F3FD\u200D\u2708\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\u2708", 1},
{"\U0001F469\U0001F3FE\u200D\u2708\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\u2708", 1},
{"\U0001F469\U0001F3FF\u200D\u2708\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\u2708", 1},
{"\U0001F9D1\u200D\U0001F680", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F680", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F680", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F680", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F680", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F680", 1},
{"\U0001F468\u200D\U0001F680", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F680", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F680", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F680", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F680", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F680", 1},
{"\U0001F469\u200D\U0001F680", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F680", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F680", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F680", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F680", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F680", 1},
{"\U0001F9D1\u200D\U0001F692", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F692", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F692", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F692", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F692", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F692", 1},
{"\U0001F468\u200D\U0001F692", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F692", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F692", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F692", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F692", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F692", 1},
{"\U0001F469\u200D\U0001F692", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F692", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F692", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F692", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F692", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F692", 1},
{"\U0001F46E\U0001F3FB", 1},
{"\U0001F46E\U0001F3FC", 1},
{"\U0001F46E\U0001F3FD", 1},
{"\U0001F46E\U0001F3FE", 1},
{"\U0001F46E\U0001F3FF", 1},
{"\U0001F46E\u200D\u2642\uFE0F", 1},
{"\U0001F46E\u200D\u2642", 1},
{"\U0001F46E\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F46E\U0001F3FB\u200D\u2642", 1},
{"\U0001F46E\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F46E\U0001F3FC\u200D\u2642", 1},
{"\U0001F46E\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F46E\U0001F3FD\u200D\u2642", 1},
{"\U0001F46E\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F46E\U0001F3FE\u200D\u2642", 1},
{"\U0001F46E\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F46E\U0001F3FF\u200D\u2642", 1},
{"\U0001F46E\u200D\u2640\uFE0F", 1},
{"\U0001F46E\u200D\u2640", 1},
{"\U0001F46E\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F46E\U0001F3FB\u200D\u2640", 1},
{"\U0001F46E\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F46E\U0001F3FC\u200D\u2640", 1},
{"\U0001F46E\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F46E\U0001F3FD\u200D\u2640", 1},
{"\U0001F46E\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F46E\U0001F3FE\u200D\u2640", 1},
{"\U0001F46E\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F46E\U0001F3FF\u200D\u2640", 1},
{"\U0001F575\uFE0F", 1},
{"\U0001F575\U0001F3FB", 1},
{"\U0001F575\U0001F3FC", 1},
{"\U0001F575\U0001F3FD", 1},
{"\U0001F575\U0001F3FE", 1},
{"\U0001F575\U0001F3FF", 1},
{"\U0001F575\uFE0F\u200D\u2642\uFE0F", 1},
{"\U0001F575\u200D\u2642\uFE0F", 1},
{"\U0001F575\uFE0F\u200D\u2642", 1},
{"\U0001F575\u200D\u2642", 1},
{"\U0001F575\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F575\U0001F3FB\u200D\u2642", 1},
{"\U0001F575\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F575\U0001F3FC\u200D\u2642", 1},
{"\U0001F575\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F575\U0001F3FD\u200D\u2642", 1},
{"\U0001F575\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F575\U0001F3FE\u200D\u2642", 1},
{"\U0001F575\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F575\U0001F3FF\u200D\u2642", 1},
{"\U0001F575\uFE0F\u200D\u2640\uFE0F", 1},
{"\U0001F575\u200D\u2640\uFE0F", 1},
{"\U0001F575\uFE0F\u200D\u2640", 1},
{"\U0001F575\u200D\u2640", 1},
{"\U0001F575\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F575\U0001F3FB\u200D\u2640", 1},
{"\U0001F575\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F575\U0001F3FC\u200D\u2640", 1},
{"\U0001F575\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F575\U0001F3FD\u200D\u2640", 1},
{"\U0001F575\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F575\U0001F3FE\u200D\u2640", 1},
{"\U0001F575\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F575\U0001F3FF\u200D\u2640", 1},
{"\U0001F482\U0001F3FB", 1},
{"\U0001F482\U0001F3FC", 1},
{"\U0001F482\U0001F3FD", 1},
{"\U0001F482\U0001F3FE", 1},
{"\U0001F482\U0001F3FF", 1},
{"\U0001F482\u200D\u2642\uFE0F", 1},
{"\U0001F482\u200D\u2642", 1},
{"\U0001F482\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F482\U0001F3FB\u200D\u2642", 1},
{"\U0001F482\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F482\U0001F3FC\u200D\u2642", 1},
{"\U0001F482\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F482\U0001F3FD\u200D\u2642", 1},
{"\U0001F482\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F482\U0001F3FE\u200D\u2642", 1},
{"\U0001F482\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F482\U0001F3FF\u200D\u2642", 1},
{"\U0001F482\u200D\u2640\uFE0F", 1},
{"\U0001F482\u200D\u2640", 1},
{"\U0001F482\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F482\U0001F3FB\u200D\u2640", 1},
{"\U0001F482\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F482\U0001F3FC\u200D\u2640", 1},
{"\U0001F482\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F482\U0001F3FD\u200D\u2640", 1},
{"\U0001F482\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F482\U0001F3FE\u200D\u2640", 1},
{"\U0001F482\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F482\U0001F3FF\u200D\u2640", 1},
{"\U0001F977\U0001F3FB", 1},
{"\U0001F977\U0001F3FC", 1},
{"\U0001F977\U0001F3FD", 1},
{"\U0001F977\U0001F3FE", 1},
{"\U0001F977\U0001F3FF", 1},
{"\U0001F477\U0001F3FB", 1},
{"\U0001F477\U0001F3FC", 1},
{"\U0001F477\U0001F3FD", 1},
{"\U0001F477\U0001F3FE", 1},
{"\U0001F477\U0001F3FF", 1},
{"\U0001F477\u200D\u2642\uFE0F", 1},
{"\U0001F477\u200D\u2642", 1},
{"\U0001F477\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F477\U0001F3FB\u200D\u2642", 1},
{"\U0001F477\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F477\U0001F3FC\u200D\u2642", 1},
{"\U0001F477\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F477\U0001F3FD\u200D\u2642", 1},
{"\U0001F477\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F477\U0001F3FE\u200D\u2642", 1},
{"\U0001F477\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F477\U0001F3FF\u200D\u2642", 1},
{"\U0001F477\u200D\u2640\uFE0F", 1},
{"\U0001F477\u200D\u2640", 1},
{"\U0001F477\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F477\U0001F3FB\u200D\u2640", 1},
{"\U0001F477\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F477\U0001F3FC\u200D\u2640", 1},
{"\U0001F477\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F477\U0001F3FD\u200D\u2640", 1},
{"\U0001F477\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F477\U0001F3FE\u200D\u2640", 1},
{"\U0001F477\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F477\U0001F3FF\u200D\u2640", 1},
{"\U0001FAC5\U0001F3FB", 1},
{"\U0001FAC5\U0001F3FC", 1},
{"\U0001FAC5\U0001F3FD", 1},
{"\U0001FAC5\U0001F3FE", 1},
{"\U0001FAC5\U0001F3FF", 1},
{"\U0001F934\U0001F3FB", 1},
{"\U0001F934\U0001F3FC", 1},
{"\U0001F934\U0001F3FD", 1},
{"\U0001F934\U0001F3FE", 1},
{"\U0001F934\U0001F3FF", 1},
{"\U0001F478\U0001F3FB", 1},
{"\U0001F478\U0001F3FC", 1},
{"\U0001F478\U0001F3FD", 1},
{"\U0001F478\U0001F3FE", 1},
{"\U0001F478\U0001F3FF", 1},
{"\U0001F473\U0001F3FB", 1},
{"\U0001F473\U0001F3FC", 1},
{"\U0001F473\U0001F3FD", 1},
{"\U0001F473\U0001F3FE", 1},
{"\U0001F473\U0001F3FF", 1},
{"\U0001F473\u200D\u2642\uFE0F", 1},
{"\U0001F473\u200D\u2642", 1},
{"\U0001F473\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F473\U0001F3FB\u200D\u2642", 1},
{"\U0001F473\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F473\U0001F3FC\u200D\u2642", 1},
{"\U0001F473\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F473\U0001F3FD\u200D\u2642", 1},
{"\U0001F473\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F473\U0001F3FE\u200D\u2642", 1},
{"\U0001F473\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F473\U0001F3FF\u200D\u2642", 1},
{"\U0001F473\u200D\u2640\uFE0F", 1},
{"\U0001F473\u200D\u2640", 1},
{"\U0001F473\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F473\U0001F3FB\u200D\u2640", 1},
{"\U0001F473\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F473\U0001F3FC\u200D\u2640", 1},
{"\U0001F473\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F473\U0001F3FD\u200D\u2640", 1},
{"\U0001F473\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F473\U0001F3FE\u200D\u2640", 1},
{"\U0001F473\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F473\U0001F3FF\u200D\u2640", 1},
{"\U0001F472\U0001F3FB", 1},
{"\U0001F472\U0001F3FC", 1},
{"\U0001F472\U0001F3FD", 1},
{"\U0001F472\U0001F3FE", 1},
{"\U0001F472\U0001F3FF", 1},
{"\U0001F9D5\U0001F3FB", 1},
{"\U0001F9D5\U0001F3FC", 1},
{"\U0001F9D5\U0001F3FD", 1},
{"\U0001F9D5\U0001F3FE", 1},
{"\U0001F9D5\U0001F3FF", 1},
{"\U0001F935\U0001F3FB", 1},
{"\U0001F935\U0001F3FC", 1},
{"\U0001F935\U0001F3FD", 1},
{"\U0001F935\U0001F3FE", 1},
{"\U0001F935\U0001F3FF", 1},
{"\U0001F935\u200D\u2642\uFE0F", 1},
{"\U0001F935\u200D\u2642", 1},
{"\U0001F935\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F935\U0001F3FB\u200D\u2642", 1},
{"\U0001F935\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F935\U0001F3FC\u200D\u2642", 1},
{"\U0001F935\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F935\U0001F3FD\u200D\u2642", 1},
{"\U0001F935\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F935\U0001F3FE\u200D\u2642", 1},
{"\U0001F935\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F935\U0001F3FF\u200D\u2642", 1},
{"\U0001F935\u200D\u2640\uFE0F", 1},
{"\U0001F935\u200D\u2640", 1},
{"\U0001F935\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F935\U0001F3FB\u200D\u2640", 1},
{"\U0001F935\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F935\U0001F3FC\u200D\u2640", 1},
{"\U0001F935\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F935\U0001F3FD\u200D\u2640", 1},
{"\U0001F935\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F935\U0001F3FE\u200D\u2640", 1},
{"\U0001F935\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F935\U0001F3FF\u200D\u2640", 1},
{"\U0001F470\U0001F3FB", 1},
{"\U0001F470\U0001F3FC", 1},
{"\U0001F470\U0001F3FD", 1},
{"\U0001F470\U0001F3FE", 1},
{"\U0001F470\U0001F3FF", 1},
{"\U0001F470\u200D\u2642\uFE0F", 1},
{"\U0001F470\u200D\u2642", 1},
{"\U0001F470\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F470\U0001F3FB\u200D\u2642", 1},
{"\U0001F470\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F470\U0001F3FC\u200D\u2642", 1},
{"\U0001F470\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F470\U0001F3FD\u200D\u2642", 1},
{"\U0001F470\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F470\U0001F3FE\u200D\u2642", 1},
{"\U0001F470\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F470\U0001F3FF\u200D\u2642", 1},
{"\U0001F470\u200D\u2640\uFE0F", 1},
{"\U0001F470\u200D\u2640", 1},
{"\U0001F470\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F470\U0001F3FB\u200D\u2640", 1},
{"\U0001F470\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F470\U0001F3FC\u200D\u2640", 1},
{"\U0001F470\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F470\U0001F3FD\u200D\u2640", 1},
{"\U0001F470\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F470\U0001F3FE\u200D\u2640", 1},
{"\U0001F470\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F470\U0001F3FF\u200D\u2640", 1},
{"\U0001F930\U0001F3FB", 1},
{"\U0001F930\U0001F3FC", 1},
{"\U0001F930\U0001F3FD", 1},
{"\U0001F930\U0001F3FE", 1},
{"\U0001F930\U0001F3FF", 1},
{"\U0001FAC3\U0001F3FB", 1},
{"\U0001FAC3\U0001F3FC", 1},
{"\U0001FAC3\U0001F3FD", 1},
{"\U0001FAC3\U0001F3FE", 1},
{"\U0001FAC3\U0001F3FF", 1},
{"\U0001FAC4\U0001F3FB", 1},
{"\U0001FAC4\U0001F3FC", 1},
{"\U0001FAC4\U0001F3FD", 1},
{"\U0001FAC4\U0001F3FE", 1},
{"\U0001FAC4\U0001F3FF", 1},
{"\U0001F931\U0001F3FB", 1},
{"\U0001F931\U0001F3FC", 1},
{"\U0001F931\U0001F3FD", 1},
{"\U0001F931\U0001F3FE", 1},
{"\U0001F931\U0001F3FF", 1},
{"\U0001F469\u200D\U0001F37C", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F37C", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F37C", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F37C", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F37C", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F37C", 1},
{"\U0001F468\u200D\U0001F37C", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F37C", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F37C", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F37C", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F37C", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F37C", 1},
{"\U0001F9D1\u200D\U0001F37C", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F37C", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F37C", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F37C", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F37C", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F37C", 1},
{"\U0001F47C\U0001F3FB", 1},
{"\U0001F47C\U0001F3FC", 1},
{"\U0001F47C\U0001F3FD", 1},
{"\U0001F47C\U0001F3FE", 1},
{"\U0001F47C\U0001F3FF", 1},
{"\U0001F385\U0001F3FB", 1},
{"\U0001F385\U0001F3FC", 1},
{"\U0001F385\U0001F3FD", 1},
{"\U0001F385\U0001F3FE", 1},
{"\U0001F385\U0001F3FF", 1},
{"\U0001F936\U0001F3FB", 1},
{"\U0001F936\U0001F3FC", 1},
{"\U0001F936\U0001F3FD", 1},
{"\U0001F936\U0001F3FE", 1},
{"\U0001F936\U0001F3FF", 1},
{"\U0001F9D1\u200D\U0001F384", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F384", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F384", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F384", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F384", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F384", 1},
{"\U0001F9B8\U0001F3FB", 1},
{"\U0001F9B8\U0001F3FC", 1},
{"\U0001F9B8\U0001F3FD", 1},
{"\U0001F9B8\U0001F3FE", 1},
{"\U0001F9B8\U0001F3FF", 1},
{"\U0001F9B8\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\u200D\u2642", 1},
{"\U0001F9B8\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\U0001F3FB\u200D\u2642", 1},
{"\U0001F9B8\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\U0001F3FC\u200D\u2642", 1},
{"\U0001F9B8\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\U0001F3FD\u200D\u2642", 1},
{"\U0001F9B8\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\U0001F3FE\u200D\u2642", 1},
{"\U0001F9B8\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9B8\U0001F3FF\u200D\u2642", 1},
{"\U0001F9B8\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\u200D\u2640", 1},
{"\U0001F9B8\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\U0001F3FB\u200D\u2640", 1},
{"\U0001F9B8\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\U0001F3FC\u200D\u2640", 1},
{"\U0001F9B8\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\U0001F3FD\u200D\u2640", 1},
{"\U0001F9B8\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\U0001F3FE\u200D\u2640", 1},
{"\U0001F9B8\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9B8\U0001F3FF\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FB", 1},
{"\U0001F9B9\U0001F3FC", 1},
{"\U0001F9B9\U0001F3FD", 1},
{"\U0001F9B9\U0001F3FE", 1},
{"\U0001F9B9\U0001F3FF", 1},
{"\U0001F9B9\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\u200D\u2642", 1},
{"\U0001F9B9\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\U0001F3FB\u200D\u2642", 1},
{"\U0001F9B9\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\U0001F3FC\u200D\u2642", 1},
{"\U0001F9B9\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\U0001F3FD\u200D\u2642", 1},
{"\U0001F9B9\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\U0001F3FE\u200D\u2642", 1},
{"\U0001F9B9\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9B9\U0001F3FF\u200D\u2642", 1},
{"\U0001F9B9\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\U0001F3FB\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\U0001F3FC\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\U0001F3FD\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\U0001F3FE\u200D\u2640", 1},
{"\U0001F9B9\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9B9\U0001F3FF\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FB", 1},
{"\U0001F9D9\U0001F3FC", 1},
{"\U0001F9D9\U0001F3FD", 1},
{"\U0001F9D9\U0001F3FE", 1},
{"\U0001F9D9\U0001F3FF", 1},
{"\U0001F9D9\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\u200D\u2642", 1},
{"\U0001F9D9\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\U0001F3FB\u200D\u2642", 1},
{"\U0001F9D9\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\U0001F3FC\u200D\u2642", 1},
{"\U0001F9D9\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\U0001F3FD\u200D\u2642", 1},
{"\U0001F9D9\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\U0001F3FE\u200D\u2642", 1},
{"\U0001F9D9\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9D9\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D9\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\U0001F3FB\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\U0001F3FC\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\U0001F3FD\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\U0001F3FE\u200D\u2640", 1},
{"\U0001F9D9\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9D9\U0001F3FF\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FB", 1},
{"\U0001F9DA\U0001F3FC", 1},
{"\U0001F9DA\U0001F3FD", 1},
{"\U0001F9DA\U0001F3FE", 1},
{"\U0001F9DA\U0001F3FF", 1},
{"\U0001F9DA\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\u200D\u2642", 1},
{"\U0001F9DA\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\U0001F3FB\u200D\u2642", 1},
{"\U0001F9DA\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\U0001F3FC\u200D\u2642", 1},
{"\U0001F9DA\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\U0001F3FD\u200D\u2642", 1},
{"\U0001F9DA\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\U0001F3FE\u200D\u2642", 1},
{"\U0001F9DA\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9DA\U0001F3FF\u200D\u2642", 1},
{"\U0001F9DA\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\U0001F3FB\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\U0001F3FC\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\U0001F3FD\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\U0001F3FE\u200D\u2640", 1},
{"\U0001F9DA\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9DA\U0001F3FF\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FB", 1},
{"\U0001F9DB\U0001F3FC", 1},
{"\U0001F9DB\U0001F3FD", 1},
{"\U0001F9DB\U0001F3FE", 1},
{"\U0001F9DB\U0001F3FF", 1},
{"\U0001F9DB\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\u200D\u2642", 1},
{"\U0001F9DB\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\U0001F3FB\u200D\u2642", 1},
{"\U0001F9DB\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\U0001F3FC\u200D\u2642", 1},
{"\U0001F9DB\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\U0001F3FD\u200D\u2642", 1},
{"\U0001F9DB\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\U0001F3FE\u200D\u2642", 1},
{"\U0001F9DB\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9DB\U0001F3FF\u200D\u2642", 1},
{"\U0001F9DB\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\U0001F3FB\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\U0001F3FC\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\U0001F3FD\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\U0001F3FE\u200D\u2640", 1},
{"\U0001F9DB\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9DB\U0001F3FF\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FB", 1},
{"\U0001F9DC\U0001F3FC", 1},
{"\U0001F9DC\U0001F3FD", 1},
{"\U0001F9DC\U0001F3FE", 1},
{"\U0001F9DC\U0001F3FF", 1},
{"\U0001F9DC\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\u200D\u2642", 1},
{"\U0001F9DC\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\U0001F3FB\u200D\u2642", 1},
{"\U0001F9DC\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\U0001F3FC\u200D\u2642", 1},
{"\U0001F9DC\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\U0001F3FD\u200D\u2642", 1},
{"\U0001F9DC\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\U0001F3FE\u200D\u2642", 1},
{"\U0001F9DC\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9DC\U0001F3FF\u200D\u2642", 1},
{"\U0001F9DC\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\U0001F3FB\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\U0001F3FC\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\U0001F3FD\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\U0001F3FE\u200D\u2640", 1},
{"\U0001F9DC\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9DC\U0001F3FF\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FB", 1},
{"\U0001F9DD\U0001F3FC", 1},
{"\U0001F9DD\U0001F3FD", 1},
{"\U0001F9DD\U0001F3FE", 1},
{"\U0001F9DD\U0001F3FF", 1},
{"\U0001F9DD\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\u200D\u2642", 1},
{"\U0001F9DD\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\U0001F3FB\u200D\u2642", 1},
{"\U0001F9DD\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\U0001F3FC\u200D\u2642", 1},
{"\U0001F9DD\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\U0001F3FD\u200D\u2642", 1},
{"\U0001F9DD\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\U0001F3FE\u200D\u2642", 1},
{"\U0001F9DD\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9DD\U0001F3FF\u200D\u2642", 1},
{"\U0001F9DD\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\U0001F3FB\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\U0001F3FC\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\U0001F3FD\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\U0001F3FE\u200D\u2640", 1},
{"\U0001F9DD\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9DD\U0001F3FF\u200D\u2640", 1},
{"\U0001F9DE\u200D\u2642\uFE0F", 1},
{"\U0001F9DE\u200D\u2642", 1},
{"\U0001F9DE\u200D\u2640\uFE0F", 1},
{"\U0001F9DE\u200D\u2640", 1},
{"\U0001F9DF\u200D\u2642\uFE0F", 1},
{"\U0001F9DF\u200D\u2642", 1},
{"\U0001F9DF\u200D\u2640\uFE0F", 1},
{"\U0001F9DF\u200D\u2640", 1},
{"\U0001F486\U0001F3FB", 1},
{"\U0001F486\U0001F3FC", 1},
{"\U0001F486\U0001F3FD", 1},
{"\U0001F486\U0001F3FE", 1},
{"\U0001F486\U0001F3FF", 1},
{"\U0001F486\u200D\u2642\uFE0F", 1},
{"\U0001F486\u200D\u2642", 1},
{"\U0001F486\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F486\U0001F3FB\u200D\u2642", 1},
{"\U0001F486\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F486\U0001F3FC\u200D\u2642", 1},
{"\U0001F486\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F486\U0001F3FD\u200D\u2642", 1},
{"\U0001F486\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F486\U0001F3FE\u200D\u2642", 1},
{"\U0001F486\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F486\U0001F3FF\u200D\u2642", 1},
{"\U0001F486\u200D\u2640\uFE0F", 1},
{"\U0001F486\u200D\u2640", 1},
{"\U0001F486\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F486\U0001F3FB\u200D\u2640", 1},
{"\U0001F486\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F486\U0001F3FC\u200D\u2640", 1},
{"\U0001F486\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F486\U0001F3FD\u200D\u2640", 1},
{"\U0001F486\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F486\U0001F3FE\u200D\u2640", 1},
{"\U0001F486\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F486\U0001F3FF\u200D\u2640", 1},
{"\U0001F487\U0001F3FB", 1},
{"\U0001F487\U0001F3FC", 1},
{"\U0001F487\U0001F3FD", 1},
{"\U0001F487\U0001F3FE", 1},
{"\U0001F487\U0001F3FF", 1},
{"\U0001F487\u200D\u2642\uFE0F", 1},
{"\U0001F487\u200D\u2642", 1},
{"\U0001F487\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F487\U0001F3FB\u200D\u2642", 1},
{"\U0001F487\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F487\U0001F3FC\u200D\u2642", 1},
{"\U0001F487\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F487\U0001F3FD\u200D\u2642", 1},
{"\U0001F487\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F487\U0001F3FE\u200D\u2642", 1},
{"\U0001F487\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F487\U0001F3FF\u200D\u2642", 1},
{"\U0001F487\u200D\u2640\uFE0F", 1},
{"\U0001F487\u200D\u2640", 1},
{"\U0001F487\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F487\U0001F3FB\u200D\u2640", 1},
{"\U0001F487\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F487\U0001F3FC\u200D\u2640", 1},
{"\U0001F487\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F487\U0001F3FD\u200D\u2640", 1},
{"\U0001F487\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F487\U0001F3FE\u200D\u2640", 1},
{"\U0001F487\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F487\U0001F3FF\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FB", 1},
{"\U0001F6B6\U0001F3FC", 1},
{"\U0001F6B6\U0001F3FD", 1},
{"\U0001F6B6\U0001F3FE", 1},
{"\U0001F6B6\U0001F3FF", 1},
{"\U0001F6B6\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\u200D\u2642", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642", 1},
{"\U0001F6B6\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640", 1},
{"\U0001F6B6\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FB\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FC\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FD\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FE\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FF\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u27A1", 1},
{"\U0001F6B6\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2640\u200D\u27A1", 1},
{"\U0001F6B6\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\u200D\u2642\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FB\u200D\u2642\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FC\u200D\u2642\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FD\u200D\u2642\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FE\u200D\u2642\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F6B6\U0001F3FF\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CD\U0001F3FB", 1},
{"\U0001F9CD\U0001F3FC", 1},
{"\U0001F9CD\U0001F3FD", 1},
{"\U0001F9CD\U0001F3FE", 1},
{"\U0001F9CD\U0001F3FF", 1},
{"\U0001F9CD\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\u200D\u2642", 1},
{"\U0001F9CD\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\U0001F3FB\u200D\u2642", 1},
{"\U0001F9CD\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\U0001F3FC\u200D\u2642", 1},
{"\U0001F9CD\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\U0001F3FD\u200D\u2642", 1},
{"\U0001F9CD\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\U0001F3FE\u200D\u2642", 1},
{"\U0001F9CD\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9CD\U0001F3FF\u200D\u2642", 1},
{"\U0001F9CD\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\u200D\u2640", 1},
{"\U0001F9CD\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\U0001F3FB\u200D\u2640", 1},
{"\U0001F9CD\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\U0001F3FC\u200D\u2640", 1},
{"\U0001F9CD\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\U0001F3FD\u200D\u2640", 1},
{"\U0001F9CD\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\U0001F3FE\u200D\u2640", 1},
{"\U0001F9CD\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9CD\U0001F3FF\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FB", 1},
{"\U0001F9CE\U0001F3FC", 1},
{"\U0001F9CE\U0001F3FD", 1},
{"\U0001F9CE\U0001F3FE", 1},
{"\U0001F9CE\U0001F3FF", 1},
{"\U0001F9CE\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\u200D\u2642", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642", 1},
{"\U0001F9CE\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640", 1},
{"\U0001F9CE\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FB\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FC\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FD\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FE\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FF\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u27A1", 1},
{"\U0001F9CE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2640\u200D\u27A1", 1},
{"\U0001F9CE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FB\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FC\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FD\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FE\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F9CE\U0001F3FF\u200D\u2642\u200D\u27A1", 1},
{"\U0001F9D1\u200D\U0001F9AF", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9AF", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9AF", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9AF", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9AF", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9AF", 1},
{"\U0001F9D1\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\u200D\U0001F9AF", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9AF", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9AF", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9AF", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9AF", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9AF", 1},
{"\U0001F468\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\u200D\U0001F9AF", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9AF", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9AF", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9AF", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9AF", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9AF", 1},
{"\U0001F469\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9AF\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9AF\u200D\u27A1", 1},
{"\U0001F9D1\u200D\U0001F9BC", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BC", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BC", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BC", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BC", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BC", 1},
{"\U0001F9D1\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\u200D\U0001F9BC", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BC", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BC", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BC", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BC", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BC", 1},
{"\U0001F468\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\u200D\U0001F9BC", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BC", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BC", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BC", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BC", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BC", 1},
{"\U0001F469\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BC\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BC\u200D\u27A1", 1},
{"\U0001F9D1\u200D\U0001F9BD", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BD", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BD", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BD", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BD", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BD", 1},
{"\U0001F9D1\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\u200D\U0001F9BD", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BD", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BD", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BD", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BD", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BD", 1},
{"\U0001F468\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\u200D\U0001F9BD", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BD", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BD", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BD", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BD", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BD", 1},
{"\U0001F469\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BD\u200D\u27A1\uFE0F", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F9BD\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB", 1},
{"\U0001F3C3\U0001F3FC", 1},
{"\U0001F3C3\U0001F3FD", 1},
{"\U0001F3C3\U0001F3FE", 1},
{"\U0001F3C3\U0001F3FF", 1},
{"\U0001F3C3\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\u200D\u2642", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642", 1},
{"\U0001F3C3\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\u200D\u2640", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640", 1},
{"\U0001F3C3\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FC\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FD\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FE\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FF\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u27A1", 1},
{"\U0001F3C3\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2640\u200D\u27A1", 1},
{"\U0001F3C3\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\u200D\u2642\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FB\u200D\u2642\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FC\u200D\u2642\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FD\u200D\u2642\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FE\u200D\u2642\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642\u200D\u27A1\uFE0F", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642\uFE0F\u200D\u27A1", 1},
{"\U0001F3C3\U0001F3FF\u200D\u2642\u200D\u27A1", 1},
{"\U0001F483\U0001F3FB", 1},
{"\U0001F483\U0001F3FC", 1},
{"\U0001F483\U0001F3FD", 1},
{"\U0001F483\U0001F3FE", 1},
{"\U0001F483\U0001F3FF", 1},
{"\U0001F57A\U0001F3FB", 1},
{"\U0001F57A\U0001F3FC", 1},
{"\U0001F57A\U0001F3FD", 1},
{"\U0001F57A\U0001F3FE", 1},
{"\U0001F57A\U0001F3FF", 1},
{"\U0001F574\uFE0F", 1},
{"\U0001F574\U0001F3FB", 1},
{"\U0001F574\U0001F3FC", 1},
{"\U0001F574\U0001F3FD", 1},
{"\U0001F574\U0001F3FE", 1},
{"\U0001F574\U0001F3FF", 1},
{"\U0001F46F\u200D\u2642\uFE0F", 1},
{"\U0001F46F\u200D\u2642", 1},
{"\U0001F46F\u200D\u2640\uFE0F", 1},
{"\U0001F46F\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FB", 1},
{"\U0001F9D6\U0001F3FC", 1},
{"\U0001F9D6\U0001F3FD", 1},
{"\U0001F9D6\U0001F3FE", 1},
{"\U0001F9D6\U0001F3FF", 1},
{"\U0001F9D6\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\u200D\u2642", 1},
{"\U0001F9D6\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\U0001F3FB\u200D\u2642", 1},
{"\U0001F9D6\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\U0001F3FC\u200D\u2642", 1},
{"\U0001F9D6\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\U0001F3FD\u200D\u2642", 1},
{"\U0001F9D6\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\U0001F3FE\u200D\u2642", 1},
{"\U0001F9D6\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9D6\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D6\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\U0001F3FB\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\U0001F3FC\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\U0001F3FD\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\U0001F3FE\u200D\u2640", 1},
{"\U0001F9D6\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9D6\U0001F3FF\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FB", 1},
{"\U0001F9D7\U0001F3FC", 1},
{"\U0001F9D7\U0001F3FD", 1},
{"\U0001F9D7\U0001F3FE", 1},
{"\U0001F9D7\U0001F3FF", 1},
{"\U0001F9D7\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\u200D\u2642", 1},
{"\U0001F9D7\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\U0001F3FB\u200D\u2642", 1},
{"\U0001F9D7\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\U0001F3FC\u200D\u2642", 1},
{"\U0001F9D7\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\U0001F3FD\u200D\u2642", 1},
{"\U0001F9D7\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\U0001F3FE\u200D\u2642", 1},
{"\U0001F9D7\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9D7\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D7\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\U0001F3FB\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\U0001F3FC\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\U0001F3FD\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\U0001F3FE\u200D\u2640", 1},
{"\U0001F9D7\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9D7\U0001F3FF\u200D\u2640", 1},
{"\U0001F3C7\U0001F3FB", 1},
{"\U0001F3C7\U0001F3FC", 1},
{"\U0001F3C7\U0001F3FD", 1},
{"\U0001F3C7\U0001F3FE", 1},
{"\U0001F3C7\U0001F3FF", 1},
{"\u26F7\uFE0F", 1},
{"\U0001F3C2\U0001F3FB", 1},
{"\U0001F3C2\U0001F3FC", 1},
{"\U0001F3C2\U0001F3FD", 1},
{"\U0001F3C2\U0001F3FE", 1},
{"\U0001F3C2\U0001F3FF", 1},
{"\U0001F3CC\uFE0F", 1},
{"\U0001F3CC\U0001F3FB", 1},
{"\U0001F3CC\U0001F3FC", 1},
{"\U0001F3CC\U0001F3FD", 1},
{"\U0001F3CC\U0001F3FE", 1},
{"\U0001F3CC\U0001F3FF", 1},
{"\U0001F3CC\uFE0F\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\uFE0F\u200D\u2642", 1},
{"\U0001F3CC\u200D\u2642", 1},
{"\U0001F3CC\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\U0001F3FB\u200D\u2642", 1},
{"\U0001F3CC\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\U0001F3FC\u200D\u2642", 1},
{"\U0001F3CC\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\U0001F3FD\u200D\u2642", 1},
{"\U0001F3CC\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\U0001F3FE\u200D\u2642", 1},
{"\U0001F3CC\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F3CC\U0001F3FF\u200D\u2642", 1},
{"\U0001F3CC\uFE0F\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\uFE0F\u200D\u2640", 1},
{"\U0001F3CC\u200D\u2640", 1},
{"\U0001F3CC\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\U0001F3FB\u200D\u2640", 1},
{"\U0001F3CC\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\U0001F3FC\u200D\u2640", 1},
{"\U0001F3CC\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\U0001F3FD\u200D\u2640", 1},
{"\U0001F3CC\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\U0001F3FE\u200D\u2640", 1},
{"\U0001F3CC\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F3CC\U0001F3FF\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FB", 1},
{"\U0001F3C4\U0001F3FC", 1},
{"\U0001F3C4\U0001F3FD", 1},
{"\U0001F3C4\U0001F3FE", 1},
{"\U0001F3C4\U0001F3FF", 1},
{"\U0001F3C4\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\u200D\u2642", 1},
{"\U0001F3C4\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\U0001F3FB\u200D\u2642", 1},
{"\U0001F3C4\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\U0001F3FC\u200D\u2642", 1},
{"\U0001F3C4\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\U0001F3FD\u200D\u2642", 1},
{"\U0001F3C4\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\U0001F3FE\u200D\u2642", 1},
{"\U0001F3C4\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F3C4\U0001F3FF\u200D\u2642", 1},
{"\U0001F3C4\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\U0001F3FB\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\U0001F3FC\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\U0001F3FD\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\U0001F3FE\u200D\u2640", 1},
{"\U0001F3C4\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F3C4\U0001F3FF\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FB", 1},
{"\U0001F6A3\U0001F3FC", 1},
{"\U0001F6A3\U0001F3FD", 1},
{"\U0001F6A3\U0001F3FE", 1},
{"\U0001F6A3\U0001F3FF", 1},
{"\U0001F6A3\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\u200D\u2642", 1},
{"\U0001F6A3\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\U0001F3FB\u200D\u2642", 1},
{"\U0001F6A3\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\U0001F3FC\u200D\u2642", 1},
{"\U0001F6A3\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\U0001F3FD\u200D\u2642", 1},
{"\U0001F6A3\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\U0001F3FE\u200D\u2642", 1},
{"\U0001F6A3\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F6A3\U0001F3FF\u200D\u2642", 1},
{"\U0001F6A3\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\U0001F3FB\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\U0001F3FC\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\U0001F3FD\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\U0001F3FE\u200D\u2640", 1},
{"\U0001F6A3\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F6A3\U0001F3FF\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FB", 1},
{"\U0001F3CA\U0001F3FC", 1},
{"\U0001F3CA\U0001F3FD", 1},
{"\U0001F3CA\U0001F3FE", 1},
{"\U0001F3CA\U0001F3FF", 1},
{"\U0001F3CA\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\u200D\u2642", 1},
{"\U0001F3CA\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\U0001F3FB\u200D\u2642", 1},
{"\U0001F3CA\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\U0001F3FC\u200D\u2642", 1},
{"\U0001F3CA\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\U0001F3FD\u200D\u2642", 1},
{"\U0001F3CA\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\U0001F3FE\u200D\u2642", 1},
{"\U0001F3CA\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F3CA\U0001F3FF\u200D\u2642", 1},
{"\U0001F3CA\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\U0001F3FB\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\U0001F3FC\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\U0001F3FD\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\U0001F3FE\u200D\u2640", 1},
{"\U0001F3CA\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F3CA\U0001F3FF\u200D\u2640", 1},
{"\u26F9\uFE0F", 1},
{"\u26F9\U0001F3FB", 1},
{"\u26F9\U0001F3FC", 1},
{"\u26F9\U0001F3FD", 1},
{"\u26F9\U0001F3FE", 1},
{"\u26F9\U0001F3FF", 1},
{"\u26F9\uFE0F\u200D\u2642\uFE0F", 1},
{"\u26F9\u200D\u2642\uFE0F", 1},
{"\u26F9\uFE0F\u200D\u2642", 1},
{"\u26F9\u200D\u2642", 1},
{"\u26F9\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\u26F9\U0001F3FB\u200D\u2642", 1},
{"\u26F9\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\u26F9\U0001F3FC\u200D\u2642", 1},
{"\u26F9\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\u26F9\U0001F3FD\u200D\u2642", 1},
{"\u26F9\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\u26F9\U0001F3FE\u200D\u2642", 1},
{"\u26F9\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\u26F9\U0001F3FF\u200D\u2642", 1},
{"\u26F9\uFE0F\u200D\u2640\uFE0F", 1},
{"\u26F9\u200D\u2640\uFE0F", 1},
{"\u26F9\uFE0F\u200D\u2640", 1},
{"\u26F9\u200D\u2640", 1},
{"\u26F9\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\u26F9\U0001F3FB\u200D\u2640", 1},
{"\u26F9\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\u26F9\U0001F3FC\u200D\u2640", 1},
{"\u26F9\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\u26F9\U0001F3FD\u200D\u2640", 1},
{"\u26F9\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\u26F9\U0001F3FE\u200D\u2640", 1},
{"\u26F9\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\u26F9\U0001F3FF\u200D\u2640", 1},
{"\U0001F3CB\uFE0F", 1},
{"\U0001F3CB\U0001F3FB", 1},
{"\U0001F3CB\U0001F3FC", 1},
{"\U0001F3CB\U0001F3FD", 1},
{"\U0001F3CB\U0001F3FE", 1},
{"\U0001F3CB\U0001F3FF", 1},
{"\U0001F3CB\uFE0F\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\uFE0F\u200D\u2642", 1},
{"\U0001F3CB\u200D\u2642", 1},
{"\U0001F3CB\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\U0001F3FB\u200D\u2642", 1},
{"\U0001F3CB\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\U0001F3FC\u200D\u2642", 1},
{"\U0001F3CB\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\U0001F3FD\u200D\u2642", 1},
{"\U0001F3CB\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\U0001F3FE\u200D\u2642", 1},
{"\U0001F3CB\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F3CB\U0001F3FF\u200D\u2642", 1},
{"\U0001F3CB\uFE0F\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\uFE0F\u200D\u2640", 1},
{"\U0001F3CB\u200D\u2640", 1},
{"\U0001F3CB\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\U0001F3FB\u200D\u2640", 1},
{"\U0001F3CB\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\U0001F3FC\u200D\u2640", 1},
{"\U0001F3CB\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\U0001F3FD\u200D\u2640", 1},
{"\U0001F3CB\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\U0001F3FE\u200D\u2640", 1},
{"\U0001F3CB\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F3CB\U0001F3FF\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FB", 1},
{"\U0001F6B4\U0001F3FC", 1},
{"\U0001F6B4\U0001F3FD", 1},
{"\U0001F6B4\U0001F3FE", 1},
{"\U0001F6B4\U0001F3FF", 1},
{"\U0001F6B4\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\u200D\u2642", 1},
{"\U0001F6B4\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\U0001F3FB\u200D\u2642", 1},
{"\U0001F6B4\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\U0001F3FC\u200D\u2642", 1},
{"\U0001F6B4\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\U0001F3FD\u200D\u2642", 1},
{"\U0001F6B4\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\U0001F3FE\u200D\u2642", 1},
{"\U0001F6B4\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F6B4\U0001F3FF\u200D\u2642", 1},
{"\U0001F6B4\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\U0001F3FB\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\U0001F3FC\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\U0001F3FD\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\U0001F3FE\u200D\u2640", 1},
{"\U0001F6B4\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F6B4\U0001F3FF\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FB", 1},
{"\U0001F6B5\U0001F3FC", 1},
{"\U0001F6B5\U0001F3FD", 1},
{"\U0001F6B5\U0001F3FE", 1},
{"\U0001F6B5\U0001F3FF", 1},
{"\U0001F6B5\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\u200D\u2642", 1},
{"\U0001F6B5\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\U0001F3FB\u200D\u2642", 1},
{"\U0001F6B5\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\U0001F3FC\u200D\u2642", 1},
{"\U0001F6B5\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\U0001F3FD\u200D\u2642", 1},
{"\U0001F6B5\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\U0001F3FE\u200D\u2642", 1},
{"\U0001F6B5\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F6B5\U0001F3FF\u200D\u2642", 1},
{"\U0001F6B5\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\U0001F3FB\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\U0001F3FC\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\U0001F3FD\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\U0001F3FE\u200D\u2640", 1},
{"\U0001F6B5\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F6B5\U0001F3FF\u200D\u2640", 1},
{"\U0001F938\U0001F3FB", 1},
{"\U0001F938\U0001F3FC", 1},
{"\U0001F938\U0001F3FD", 1},
{"\U0001F938\U0001F3FE", 1},
{"\U0001F938\U0001F3FF", 1},
{"\U0001F938\u200D\u2642\uFE0F", 1},
{"\U0001F938\u200D\u2642", 1},
{"\U0001F938\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F938\U0001F3FB\u200D\u2642", 1},
{"\U0001F938\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F938\U0001F3FC\u200D\u2642", 1},
{"\U0001F938\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F938\U0001F3FD\u200D\u2642", 1},
{"\U0001F938\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F938\U0001F3FE\u200D\u2642", 1},
{"\U0001F938\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F938\U0001F3FF\u200D\u2642", 1},
{"\U0001F938\u200D\u2640\uFE0F", 1},
{"\U0001F938\u200D\u2640", 1},
{"\U0001F938\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F938\U0001F3FB\u200D\u2640", 1},
{"\U0001F938\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F938\U0001F3FC\u200D\u2640", 1},
{"\U0001F938\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F938\U0001F3FD\u200D\u2640", 1},
{"\U0001F938\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F938\U0001F3FE\u200D\u2640", 1},
{"\U0001F938\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F938\U0001F3FF\u200D\u2640", 1},
{"\U0001F93C\u200D\u2642\uFE0F", 1},
{"\U0001F93C\u200D\u2642", 1},
{"\U0001F93C\u200D\u2640\uFE0F", 1},
{"\U0001F93C\u200D\u2640", 1},
{"\U0001F93D\U0001F3FB", 1},
{"\U0001F93D\U0001F3FC", 1},
{"\U0001F93D\U0001F3FD", 1},
{"\U0001F93D\U0001F3FE", 1},
{"\U0001F93D\U0001F3FF", 1},
{"\U0001F93D\u200D\u2642\uFE0F", 1},
{"\U0001F93D\u200D\u2642", 1},
{"\U0001F93D\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F93D\U0001F3FB\u200D\u2642", 1},
{"\U0001F93D\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F93D\U0001F3FC\u200D\u2642", 1},
{"\U0001F93D\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F93D\U0001F3FD\u200D\u2642", 1},
{"\U0001F93D\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F93D\U0001F3FE\u200D\u2642", 1},
{"\U0001F93D\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F93D\U0001F3FF\u200D\u2642", 1},
{"\U0001F93D\u200D\u2640\uFE0F", 1},
{"\U0001F93D\u200D\u2640", 1},
{"\U0001F93D\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F93D\U0001F3FB\u200D\u2640", 1},
{"\U0001F93D\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F93D\U0001F3FC\u200D\u2640", 1},
{"\U0001F93D\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F93D\U0001F3FD\u200D\u2640", 1},
{"\U0001F93D\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F93D\U0001F3FE\u200D\u2640", 1},
{"\U0001F93D\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F93D\U0001F3FF\u200D\u2640", 1},
{"\U0001F93E\U0001F3FB", 1},
{"\U0001F93E\U0001F3FC", 1},
{"\U0001F93E\U0001F3FD", 1},
{"\U0001F93E\U0001F3FE", 1},
{"\U0001F93E\U0001F3FF", 1},
{"\U0001F93E\u200D\u2642\uFE0F", 1},
{"\U0001F93E\u200D\u2642", 1},
{"\U0001F93E\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F93E\U0001F3FB\u200D\u2642", 1},
{"\U0001F93E\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F93E\U0001F3FC\u200D\u2642", 1},
{"\U0001F93E\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F93E\U0001F3FD\u200D\u2642", 1},
{"\U0001F93E\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F93E\U0001F3FE\u200D\u2642", 1},
{"\U0001F93E\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F93E\U0001F3FF\u200D\u2642", 1},
{"\U0001F93E\u200D\u2640\uFE0F", 1},
{"\U0001F93E\u200D\u2640", 1},
{"\U0001F93E\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F93E\U0001F3FB\u200D\u2640", 1},
{"\U0001F93E\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F93E\U0001F3FC\u200D\u2640", 1},
{"\U0001F93E\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F93E\U0001F3FD\u200D\u2640", 1},
{"\U0001F93E\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F93E\U0001F3FE\u200D\u2640", 1},
{"\U0001F93E\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F93E\U0001F3FF\u200D\u2640", 1},
{"\U0001F939\U0001F3FB", 1},
{"\U0001F939\U0001F3FC", 1},
{"\U0001F939\U0001F3FD", 1},
{"\U0001F939\U0001F3FE", 1},
{"\U0001F939\U0001F3FF", 1},
{"\U0001F939\u200D\u2642\uFE0F", 1},
{"\U0001F939\u200D\u2642", 1},
{"\U0001F939\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F939\U0001F3FB\u200D\u2642", 1},
{"\U0001F939\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F939\U0001F3FC\u200D\u2642", 1},
{"\U0001F939\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F939\U0001F3FD\u200D\u2642", 1},
{"\U0001F939\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F939\U0001F3FE\u200D\u2642", 1},
{"\U0001F939\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F939\U0001F3FF\u200D\u2642", 1},
{"\U0001F939\u200D\u2640\uFE0F", 1},
{"\U0001F939\u200D\u2640", 1},
{"\U0001F939\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F939\U0001F3FB\u200D\u2640", 1},
{"\U0001F939\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F939\U0001F3FC\u200D\u2640", 1},
{"\U0001F939\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F939\U0001F3FD\u200D\u2640", 1},
{"\U0001F939\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F939\U0001F3FE\u200D\u2640", 1},
{"\U0001F939\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F939\U0001F3FF\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FB", 1},
{"\U0001F9D8\U0001F3FC", 1},
{"\U0001F9D8\U0001F3FD", 1},
{"\U0001F9D8\U0001F3FE", 1},
{"\U0001F9D8\U0001F3FF", 1},
{"\U0001F9D8\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\u200D\u2642", 1},
{"\U0001F9D8\U0001F3FB\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\U0001F3FB\u200D\u2642", 1},
{"\U0001F9D8\U0001F3FC\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\U0001F3FC\u200D\u2642", 1},
{"\U0001F9D8\U0001F3FD\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\U0001F3FD\u200D\u2642", 1},
{"\U0001F9D8\U0001F3FE\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\U0001F3FE\u200D\u2642", 1},
{"\U0001F9D8\U0001F3FF\u200D\u2642\uFE0F", 1},
{"\U0001F9D8\U0001F3FF\u200D\u2642", 1},
{"\U0001F9D8\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FB\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\U0001F3FB\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FC\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\U0001F3FC\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FD\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\U0001F3FD\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FE\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\U0001F3FE\u200D\u2640", 1},
{"\U0001F9D8\U0001F3FF\u200D\u2640\uFE0F", 1},
{"\U0001F9D8\U0001F3FF\u200D\u2640", 1},
{"\U0001F6C0\U0001F3FB", 1},
{"\U0001F6C0\U0001F3FC", 1},
{"\U0001F6C0\U0001F3FD", 1},
{"\U0001F6C0\U0001F3FE", 1},
{"\U0001F6C0\U0001F3FF", 1},
{"\U0001F6CC\U0001F3FB", 1},
{"\U0001F6CC\U0001F3FC", 1},
{"\U0001F6CC\U0001F3FD", 1},
{"\U0001F6CC\U0001F3FE", 1},
{"\U0001F6CC\U0001F3FF", 1},
{"\U0001F9D1\u200D\U0001F91D\u200D\U0001F9D1", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FB\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FC\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FD\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FE\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FF\u200D\U0001F91D\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F46D\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F46D\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F46D\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F46D\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F46D\U0001F3FF", 1},
{"\U0001F46B\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F46B\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F46B\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F46B\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F46B\U0001F3FF", 1},
{"\U0001F46C\U0001F3FB", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FB\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F46C\U0001F3FC", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FC\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F46C\U0001F3FD", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FD\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F46C\U0001F3FE", 1},
{"\U0001F468\U0001F3FE\u200D\U0001F91D\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FF\u200D\U0001F91D\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F46C\U0001F3FF", 1},
{"\U0001F48F\U0001F3FB", 1},
{"\U0001F48F\U0001F3FC", 1},
{"\U0001F48F\U0001F3FD", 1},
{"\U0001F48F\U0001F3FE", 1},
{"\U0001F48F\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F469\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468", 1},
{"\U0001F469\u200D\u2764\u200D\U0001F48B\u200D\U0001F468", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468", 1},
{"\U0001F468\u200D\u2764\u200D\U0001F48B\u200D\U0001F468", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469", 1},
{"\U0001F469\u200D\u2764\u200D\U0001F48B\u200D\U0001F469", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F48B\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F491\U0001F3FB", 1},
{"\U0001F491\U0001F3FC", 1},
{"\U0001F491\U0001F3FD", 1},
{"\U0001F491\U0001F3FE", 1},
{"\U0001F491\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FB\u200D\u2764\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FC\u200D\u2764\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FD\u200D\u2764\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FE\u200D\u2764\u200D\U0001F9D1\U0001F3FF", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F9D1\U0001F3FB", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F9D1\U0001F3FC", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F9D1\U0001F3FD", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F9D1\U0001F3FF\u200D\u2764\u200D\U0001F9D1\U0001F3FE", 1},
{"\U0001F469\u200D\u2764\uFE0F\u200D\U0001F468", 1},
{"\U0001F469\u200D\u2764\u200D\U0001F468", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\u200D\u2764\uFE0F\u200D\U0001F468", 1},
{"\U0001F468\u200D\u2764\u200D\U0001F468", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FB\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FC\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FD\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FE\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FB", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FC", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FD", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FE", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F468\U0001F3FF\u200D\u2764\u200D\U0001F468\U0001F3FF", 1},
{"\U0001F469\u200D\u2764\uFE0F\u200D\U0001F469", 1},
{"\U0001F469\u200D\u2764\u200D\U0001F469", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FB\u200D\u2764\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FC\u200D\u2764\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FD\u200D\u2764\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FE\u200D\u2764\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F469\U0001F3FB", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F469\U0001F3FC", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F469\U0001F3FD", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F469\U0001F3FE", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\uFE0F\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F469\U0001F3FF\u200D\u2764\u200D\U0001F469\U0001F3FF", 1},
{"\U0001F468\u200D\U0001F469\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F469\u200D\U0001F467", 1},
{"\U0001F468\u200D\U0001F469\u200D\U0001F467\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F469\u200D\U0001F466\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F469\u200D\U0001F467\u200D\U0001F467", 1},
{"\U0001F468\u200D\U0001F468\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F468\u200D\U0001F467", 1},
{"\U0001F468\u200D\U0001F468\u200D\U0001F467\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F468\u200D\U0001F466\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F468\u200D\U0001F467\u200D\U0001F467", 1},
{"\U0001F469\u200D\U0001F469\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F469\u200D\U0001F467", 1},
{"\U0001F469\u200D\U0001F469\u200D\U0001F467\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F469\u200D\U0001F466\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F469\u200D\U0001F467\u200D\U0001F467", 1},
{"\U0001F468\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F466\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F467", 1},
{"\U0001F468\u200D\U0001F467\u200D\U0001F466", 1},
{"\U0001F468\u200D\U0001F467\u200D\U0001F467", 1},
{"\U0001F469\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F466\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F467", 1},
{"\U0001F469\u200D\U0001F467\u200D\U0001F466", 1},
{"\U0001F469\u200D\U0001F467\u200D\U0001F467", 1},
{"\U0001F5E3\uFE0F", 1},
{"\U0001F9D1\u200D\U0001F9D1\u200D\U0001F9D2", 1},
{"\U0001F9D1\u200D\U0001F9D1\u200D\U0001F9D2\u200D\U0001F9D2", 1},
{"\U0001F9D1\u200D\U0001F9D2", 1},
{"\U0001F9D1\u200D\U0001F9D2\u200D\U0001F9D2", 1},
{"\U0001F415\u200D\U0001F9BA", 1},
{"\U0001F408\u200D\u2B1B", 1},
{"\U0001F43F\uFE0F", 1},
{"\U0001F43B\u200D\u2744\uFE0F", 1},
{"\U0001F43B\u200D\u2744", 1},
{"\U0001F54A\uFE0F", 1},
{"\U0001F426\u200D\u2B1B", 1},
{"\U0001F426\u200D\U0001F525", 1},
{"\U0001F577\uFE0F", 1},
{"\U0001F578\uFE0F", 1},
{"\U0001F3F5\uFE0F", 1},
{"\u2618\uFE0F", 1},
{"\U0001F34B\u200D\U0001F7E9", 1},
{"\U0001F336\uFE0F", 1},
{"\U0001F344\u200D\U0001F7EB", 1},
{"\U0001F37D\uFE0F", 1},
{"\U0001F5FA\uFE0F", 1},
{"\U0001F3D4\uFE0F", 1},
{"\u26F0\uFE0F", 1},
{"\U0001F3D5\uFE0F", 1},
{"\U0001F3D6\uFE0F", 1},
{"\U0001F3DC\uFE0F", 1},
{"\U0001F3DD\uFE0F", 1},
{"\U0001F3DE\uFE0F", 1},
{"\U0001F3DF\uFE0F", 1},
{"\U0001F3DB\uFE0F", 1},
{"\U0001F3D7\uFE0F", 1},
{"\U0001F3D8\uFE0F", 1},
{"\U0001F3DA\uFE0F", 1},
{"\u26E9\uFE0F", 1},
{"\U0001F3D9\uFE0F", 1},
{"\u2668\uFE0F", 1},
{"\U0001F3CE\uFE0F", 1},
{"\U0001F3CD\uFE0F", 1},
{"\U0001F6E3\uFE0F", 1},
{"\U0001F6E4\uFE0F", 1},
{"\U0001F6E2\uFE0F", 1},
{"\U0001F6F3\uFE0F", 1},
{"\u26F4\uFE0F", 1},
{"\U0001F6E5\uFE0F", 1},
{"\u2708\uFE0F", 1},
{"\U0001F6E9\uFE0F", 1},
{"\U0001F6F0\uFE0F", 1},
{"\U0001F6CE\uFE0F", 1},
{"\u23F1\uFE0F", 1},
{"\u23F2\uFE0F", 1},
{"\U0001F570\uFE0F", 1},
{"\U0001F321\uFE0F", 1},
{"\u2600\uFE0F", 1},
{"\u2601\uFE0F", 1},
{"\u26C8\uFE0F", 1},
{"\U0001F324\uFE0F", 1},
{"\U0001F325\uFE0F", 1},
{"\U0001F326\uFE0F", 1},
{"\U0001F327\uFE0F", 1},
{"\U0001F328\uFE0F", 1},
{"\U0001F329\uFE0F", 1},
{"\U0001F32A\uFE0F", 1},
{"\U0001F32B\uFE0F", 1},
{"\U0001F32C\uFE0F", 1},
{"\u2602\uFE0F", 1},
{"\u26F1\uFE0F", 1},
{"\u2744\uFE0F", 1},
{"\u2603\uFE0F", 1},
{"\u2604\uFE0F", 1},
{"\U0001F397\uFE0F", 1},
{"\U0001F39F\uFE0F", 1},
{"\U0001F396\uFE0F", 1},
{"\u26F8\uFE0F", 1},
{"\U0001F579\uFE0F", 1},
{"\u2660\uFE0F", 1},
{"\u2665\uFE0F", 1},
{"\u2666\uFE0F", 1},
{"\u2663\uFE0F", 1},
{"\u265F\uFE0F", 1},
{"\U0001F5BC\uFE0F", 1},
{"\U0001F576\uFE0F", 1},
{"\U0001F6CD\uFE0F", 1},
{"\u26D1\uFE0F", 1},
{"\U0001F399\uFE0F", 1},
{"\U0001F39A\uFE0F", 1},
{"\U0001F39B\uFE0F", 1},
{"\u260E\uFE0F", 1},
{"\U0001F5A5\uFE0F", 1},
{"\U0001F5A8\uFE0F", 1},
{"\u2328\uFE0F", 1},
{"\U0001F5B1\uFE0F", 1},
{"\U0001F5B2\uFE0F", 1},
{"\U0001F39E\uFE0F", 1},
{"\U0001F4FD\uFE0F", 1},
{"\U0001F56F\uFE0F", 1},
{"\U0001F5DE\uFE0F", 1},
{"\U0001F3F7\uFE0F", 1},
{"\u2709\uFE0F", 1},
{"\U0001F5F3\uFE0F", 1},
{"\u270F\uFE0F", 1},
{"\u2712\uFE0F", 1},
{"\U0001F58B\uFE0F", 1},
{"\U0001F58A\uFE0F", 1},
{"\U0001F58C\uFE0F", 1},
{"\U0001F58D\uFE0F", 1},
{"\U0001F5C2\uFE0F", 1},
{"\U0001F5D2\uFE0F", 1},
{"\U0001F5D3\uFE0F", 1},
{"\U0001F587\uFE0F", 1},
{"\u2702\uFE0F", 1},
{"\U0001F5C3\uFE0F", 1},
{"\U0001F5C4\uFE0F", 1},
{"\U0001F5D1\uFE0F", 1},
{"\U0001F5DD\uFE0F", 1},
{"\u26CF\uFE0F", 1},
{"\u2692\uFE0F", 1},
{"\U0001F6E0\uFE0F", 1},
{"\U0001F5E1\uFE0F", 1},
{"\u2694\uFE0F", 1},
{"\U0001F6E1\uFE0F", 1},
{"\u2699\uFE0F", 1},
{"\U0001F5DC\uFE0F", 1},
{"\u2696\uFE0F", 1},
{"\u26D3\uFE0F\u200D\U0001F4A5", 1},
{"\u26D3\u200D\U0001F4A5", 1},
{"\u26D3\uFE0F", 1},
{"\u2697\uFE0F", 1},
{"\U0001F6CF\uFE0F", 1},
{"\U0001F6CB\uFE0F", 1},
{"\u26B0\uFE0F", 1},
{"\u26B1\uFE0F", 1},
{"\u26A0\uFE0F", 1},
{"\u2622\uFE0F", 1},
{"\u2623\uFE0F", 1},
{"\u2B06\uFE0F", 1},
{"\u2197\uFE0F", 1},
{"\u27A1\uFE0F", 1},
{"\u2198\uFE0F", 1},
{"\u2B07\uFE0F", 1},
{"\u2199\uFE0F", 1},
{"\u2B05\uFE0F", 1},
{"\u2196\uFE0F", 1},
{"\u2195\uFE0F", 1},
{"\u2194\uFE0F", 1},
{"\u21A9\uFE0F", 1},
{"\u21AA\uFE0F", 1},
{"\u2934\uFE0F", 1},
{"\u2935\uFE0F", 1},
{"\u269B\uFE0F", 1},
{"\U0001F549\uFE0F", 1},
{"\u2721\uFE0F", 1},
{"\u2638\uFE0F", 1},
{"\u262F\uFE0F", 1},
{"\u271D\uFE0F", 1},
{"\u2626\uFE0F", 1},
{"\u262A\uFE0F", 1},
{"\u262E\uFE0F", 1},
{"\u25B6\uFE0F", 1},
{"\u23ED\uFE0F", 1},
{"\u23EF\uFE0F", 1},
{"\u25C0\uFE0F", 1},
{"\u23EE\uFE0F", 1},
{"\u23F8\uFE0F", 1},
{"\u23F9\uFE0F", 1},
{"\u23FA\uFE0F", 1},
{"\u23CF\uFE0F", 1},
{"\u2640\uFE0F", 1},
{"\u2642\uFE0F", 1},
{"\u26A7\uFE0F", 1},
{"\u2716\uFE0F", 1},
{"\u267E\uFE0F", 1},
{"\u203C\uFE0F", 1},
{"\u2049\uFE0F", 1},
{"\u3030\uFE0F", 1},
{"\u2695\uFE0F", 1},
{"\u267B\uFE0F", 1},
{"\u269C\uFE0F", 1},
{"\u2611\uFE0F", 1},
{"\u2714\uFE0F", 1},
{"\u303D\uFE0F", 1},
{"\u2733\uFE0F", 1},
{"\u2734\uFE0F", 1},
{"\u2747\uFE0F", 1},
{"\u00A9\uFE0F", 1},
{"\u00AE\uFE0F", 1},
{"\u2122\uFE0F", 1},
{"\u0023\uFE0F\u20E3", 1},
{"\u0023\u20E3", 1},
{"\u002A\uFE0F\u20E3", 1},
{"\u002A\u20E3", 1},
{"\u0030\uFE0F\u20E3", 1},
{"\u0030\u20E3", 1},
{"\u0031\uFE0F\u20E3", 1},
{"\u0031\u20E3", 1},
{"\u0032\uFE0F\u20E3", 1},
{"\u0032\u20E3", 1},
{"\u0033\uFE0F\u20E3", 1},
{"\u0033\u20E3", 1},
{"\u0034\uFE0F\u20E3", 1},
{"\u0034\u20E3", 1},
{"\u0035\uFE0F\u20E3", 1},
{"\u0035\u20E3", 1},
{"\u0036\uFE0F\u20E3", 1},
{"\u0036\u20E3", 1},
{"\u0037\uFE0F\u20E3", 1},
{"\u0037\u20E3", 1},
{"\u0038\uFE0F\u20E3", 1},
{"\u0038\u20E3", 1},
{"\u0039\uFE0F\u20E3", 1},
{"\u0039\u20E3", 1},
{"\U0001F170\uFE0F", 1},
{"\U0001F171\uFE0F", 1},
{"\u2139\uFE0F", 1},
{"\u24C2\uFE0F", 1},
{"\U0001F17E\uFE0F", 1},
{"\U0001F17F\uFE0F", 1},
{"\U0001F202\uFE0F", 1},
{"\U0001F237\uFE0F", 1},
{"\u3297\uFE0F", 1},
{"\u3299\uFE0F", 1},
{"\u25FC\uFE0F", 1},
{"\u25FB\uFE0F", 1},
{"\u25AA\uFE0F", 1},
{"\u25AB\uFE0F", 1},
{"\U0001F3F3\uFE0F", 1},
{"\U0001F3F3\uFE0F\u200D\U0001F308", 1},
{"\U0001F3F3\u200D\U0001F308", 1},
{"\U0001F3F3\uFE0F\u200D\u26A7\uFE0F", 1},
{"\U0001F3F3\u200D\u26A7\uFE0F", 1},
{"\U0001F3F3\uFE0F\u200D\u26A7", 1},
{"\U0001F3F3\u200D\u26A7", 1},
{"\U0001F3F4\u200D\u2620\uFE0F", 1},
{"\U0001F3F4\u200D\u2620", 1},
{"\U0001F1E6\U0001F1E8", 1},
{"\U0001F1E6\U0001F1E9", 1},
{"\U0001F1E6\U0001F1EA", 1},
{"\U0001F1E6\U0001F1EB", 1},
{"\U0001F1E6\U0001F1EC", 1},
{"\U0001F1E6\U0001F1EE", 1},
{"\U0001F1E6\U0001F1F1", 1},
{"\U0001F1E6\U0001F1F2", 1},
{"\U0001F1E6\U0001F1F4", 1},
{"\U0001F1E6\U0001F1F6", 1},
{"\U0001F1E6\U0001F1F7", 1},
{"\U0001F1E6\U0001F1F8", 1},
{"\U0001F1E6\U0001F1F9", 1},
{"\U0001F1E6\U0001F1FA", 1},
{"\U0001F1E6\U0001F1FC", 1},
{"\U0001F1E6\U0001F1FD", 1},
{"\U0001F1E6\U0001F1FF", 1},
{"\U0001F1E7\U0001F1E6", 1},
{"\U0001F1E7\U0001F1E7", 1},
{"\U0001F1E7\U0001F1E9", 1},
{"\U0001F1E7\U0001F1EA", 1},
{"\U0001F1E7\U0001F1EB", 1},
{"\U0001F1E7\U0001F1EC", 1},
{"\U0001F1E7\U0001F1ED", 1},
{"\U0001F1E7\U0001F1EE", 1},
{"\U0001F1E7\U0001F1EF", 1},
{"\U0001F1E7\U0001F1F1", 1},
{"\U0001F1E7\U0001F1F2", 1},
{"\U0001F1E7\U0001F1F3", 1},
{"\U0001F1E7\U0001F1F4", 1},
{"\U0001F1E7\U0001F1F6", 1},
{"\U0001F1E7\U0001F1F7", 1},
{"\U0001F1E7\U0001F1F8", 1},
{"\U0001F1E7\U0001F1F9", 1},
{"\U0001F1E7\U0001F1FB", 1},
{"\U0001F1E7\U0001F1FC", 1},
{"\U0001F1E7\U0001F1FE", 1},
{"\U0001F1E7\U0001F1FF", 1},
{"\U0001F1E8\U0001F1E6", 1},
{"\U0001F1E8\U0001F1E8", 1},
{"\U0001F1E8\U0001F1E9", 1},
{"\U0001F1E8\U0001F1EB", 1},
{"\U0001F1E8\U0001F1EC", 1},
{"\U0001F1E8\U0001F1ED", 1},
{"\U0001F1E8\U0001F1EE", 1},
{"\U0001F1E8\U0001F1F0", 1},
{"\U0001F1E8\U0001F1F1", 1},
{"\U0001F1E8\U0001F1F2", 1},
{"\U0001F1E8\U0001F1F3", 1},
{"\U0001F1E8\U0001F1F4", 1},
{"\U0001F1E8\U0001F1F5", 1},
{"\U0001F1E8\U0001F1F7", 1},
{"\U0001F1E8\U0001F1FA", 1},
{"\U0001F1E8\U0001F1FB", 1},
{"\U0001F1E8\U0001F1FC", 1},
{"\U0001F1E8\U0001F1FD", 1},
{"\U0001F1E8\U0001F1FE", 1},
{"\U0001F1E8\U0001F1FF", 1},
{"\U0001F1E9\U0001F1EA", 1},
{"\U0001F1E9\U0001F1EC", 1},
{"\U0001F1E9\U0001F1EF", 1},
{"\U0001F1E9\U0001F1F0", 1},
{"\U0001F1E9\U0001F1F2", 1},
{"\U0001F1E9\U0001F1F4", 1},
{"\U0001F1E9\U0001F1FF", 1},
{"\U0001F1EA\U0001F1E6", 1},
{"\U0001F1EA\U0001F1E8", 1},
{"\U0001F1EA\U0001F1EA", 1},
{"\U0001F1EA\U0001F1EC", 1},
{"\U0001F1EA\U0001F1ED", 1},
{"\U0001F1EA\U0001F1F7", 1},
{"\U0001F1EA\U0001F1F8", 1},
{"\U0001F1EA\U0001F1F9", 1},
{"\U0001F1EA\U0001F1FA", 1},
{"\U0001F1EB\U0001F1EE", 1},
{"\U0001F1EB\U0001F1EF", 1},
{"\U0001F1EB\U0001F1F0", 1},
{"\U0001F1EB\U0001F1F2", 1},
{"\U0001F1EB\U0001F1F4", 1},
{"\U0001F1EB\U0001F1F7", 1},
{"\U0001F1EC\U0001F1E6", 1},
{"\U0001F1EC\U0001F1E7", 1},
{"\U0001F1EC\U0001F1E9", 1},
{"\U0001F1EC\U0001F1EA", 1},
{"\U0001F1EC\U0001F1EB", 1},
{"\U0001F1EC\U0001F1EC", 1},
{"\U0001F1EC\U0001F1ED", 1},
{"\U0001F1EC\U0001F1EE", 1},
{"\U0001F1EC\U0001F1F1", 1},
{"\U0001F1EC\U0001F1F2", 1},
{"\U0001F1EC\U0001F1F3", 1},
{"\U0001F1EC\U0001F1F5", 1},
{"\U0001F1EC\U0001F1F6", 1},
{"\U0001F1EC\U0001F1F7", 1},
{"\U0001F1EC\U0001F1F8", 1},
{"\U0001F1EC\U0001F1F9", 1},
{"\U0001F1EC\U0001F1FA", 1},
{"\U0001F1EC\U0001F1FC", 1},
{"\U0001F1EC\U0001F1FE", 1},
{"\U0001F1ED\U0001F1F0", 1},
{"\U0001F1ED\U0001F1F2", 1},
{"\U0001F1ED\U0001F1F3", 1},
{"\U0001F1ED\U0001F1F7", 1},
{"\U0001F1ED\U0001F1F9", 1},
{"\U0001F1ED\U0001F1FA", 1},
{"\U0001F1EE\U0001F1E8", 1},
{"\U0001F1EE\U0001F1E9", 1},
{"\U0001F1EE\U0001F1EA", 1},
{"\U0001F1EE\U0001F1F1", 1},
{"\U0001F1EE\U0001F1F2", 1},
{"\U0001F1EE\U0001F1F3", 1},
{"\U0001F1EE\U0001F1F4", 1},
{"\U0001F1EE\U0001F1F6", 1},
{"\U0001F1EE\U0001F1F7", 1},
{"\U0001F1EE\U0001F1F8", 1},
{"\U0001F1EE\U0001F1F9", 1},
{"\U0001F1EF\U0001F1EA", 1},
{"\U0001F1EF\U0001F1F2", 1},
{"\U0001F1EF\U0001F1F4", 1},
{"\U0001F1EF\U0001F1F5", 1},
{"\U0001F1F0\U0001F1EA", 1},
{"\U0001F1F0\U0001F1EC", 1},
{"\U0001F1F0\U0001F1ED", 1},
{"\U0001F1F0\U0001F1EE", 1},
{"\U0001F1F0\U0001F1F2", 1},
{"\U0001F1F0\U0001F1F3", 1},
{"\U0001F1F0\U0001F1F5", 1},
{"\U0001F1F0\U0001F1F7", 1},
{"\U0001F1F0\U0001F1FC", 1},
{"\U0001F1F0\U0001F1FE", 1},
{"\U0001F1F0\U0001F1FF", 1},
{"\U0001F1F1\U0001F1E6", 1},
{"\U0001F1F1\U0001F1E7", 1},
{"\U0001F1F1\U0001F1E8", 1},
{"\U0001F1F1\U0001F1EE", 1},
{"\U0001F1F1\U0001F1F0", 1},
{"\U0001F1F1\U0001F1F7", 1},
{"\U0001F1F1\U0001F1F8", 1},
{"\U0001F1F1\U0001F1F9", 1},
{"\U0001F1F1\U0001F1FA", 1},
{"\U0001F1F1\U0001F1FB", 1},
{"\U0001F1F1\U0001F1FE", 1},
{"\U0001F1F2\U0001F1E6", 1},
{"\U0001F1F2\U0001F1E8", 1},
{"\U0001F1F2\U0001F1E9", 1},
{"\U0001F1F2\U0001F1EA", 1},
{"\U0001F1F2\U0001F1EB", 1},
{"\U0001F1F2\U0001F1EC", 1},
{"\U0001F1F2\U0001F1ED", 1},
{"\U0001F1F2\U0001F1F0", 1},
{"\U0001F1F2\U0001F1F1", 1},
{"\U0001F1F2\U0001F1F2", 1},
{"\U0001F1F2\U0001F1F3", 1},
{"\U0001F1F2\U0001F1F4", 1},
{"\U0001F1F2\U0001F1F5", 1},
{"\U0001F1F2\U0001F1F6", 1},
{"\U0001F1F2\U0001F1F7", 1},
{"\U0001F1F2\U0001F1F8", 1},
{"\U0001F1F2\U0001F1F9", 1},
{"\U0001F1F2\U0001F1FA", 1},
{"\U0001F1F2\U0001F1FB", 1},
{"\U0001F1F2\U0001F1FC", 1},
{"\U0001F1F2\U0001F1FD", 1},
{"\U0001F1F2\U0001F1FE", 1},
{"\U0001F1F2\U0001F1FF", 1},
{"\U0001F1F3\U0001F1E6", 1},
{"\U0001F1F3\U0001F1E8", 1},
{"\U0001F1F3\U0001F1EA", 1},
{"\U0001F1F3\U0001F1EB", 1},
{"\U0001F1F3\U0001F1EC", 1},
{"\U0001F1F3\U0001F1EE", 1},
{"\U0001F1F3\U0001F1F1", 1},
{"\U0001F1F3\U0001F1F4", 1},
{"\U0001F1F3\U0001F1F5", 1},
{"\U0001F1F3\U0001F1F7", 1},
{"\U0001F1F3\U0001F1FA", 1},
{"\U0001F1F3\U0001F1FF", 1},
{"\U0001F1F4\U0001F1F2", 1},
{"\U0001F1F5\U0001F1E6", 1},
{"\U0001F1F5\U0001F1EA", 1},
{"\U0001F1F5\U0001F1EB", 1},
{"\U0001F1F5\U0001F1EC", 1},
{"\U0001F1F5\U0001F1ED", 1},
{"\U0001F1F5\U0001F1F0", 1},
{"\U0001F1F5\U0001F1F1", 1},
{"\U0001F1F5\U0001F1F2", 1},
{"\U0001F1F5\U0001F1F3", 1},
{"\U0001F1F5\U0001F1F7", 1},
{"\U0001F1F5\U0001F1F8", 1},
{"\U0001F1F5\U0001F1F9", 1},
{"\U0001F1F5\U0001F1FC", 1},
{"\U0001F1F5\U0001F1FE", 1},
{"\U0001F1F6\U0001F1E6", 1},
{"\U0001F1F7\U0001F1EA", 1},
{"\U0001F1F7\U0001F1F4", 1},
{"\U0001F1F7\U0001F1F8", 1},
{"\U0001F1F7\U0001F1FA", 1},
{"\U0001F1F7\U0001F1FC", 1},
{"\U0001F1F8\U0001F1E6", 1},
{"\U0001F1F8\U0001F1E7", 1},
{"\U0001F1F8\U0001F1E8", 1},
{"\U0001F1F8\U0001F1E9", 1},
{"\U0001F1F8\U0001F1EA", 1},
{"\U0001F1F8\U0001F1EC", 1},
{"\U0001F1F8\U0001F1ED", 1},
{"\U0001F1F8\U0001F1EE", 1},
{"\U0001F1F8\U0001F1EF", 1},
{"\U0001F1F8\U0001F1F0", 1},
{"\U0001F1F8\U0001F1F1", 1},
{"\U0001F1F8\U0001F1F2", 1},
{"\U0001F1F8\U0001F1F3", 1},
{"\U0001F1F8\U0001F1F4", 1},
{"\U0001F1F8\U0001F1F7", 1},
{"\U0001F1F8\U0001F1F8", 1},
{"\U0001F1F8\U0001F1F9", 1},
{"\U0001F1F8\U0001F1FB", 1},
{"\U0001F1F8\U0001F1FD", 1},
{"\U0001F1F8\U0001F1FE", 1},
{"\U0001F1F8\U0001F1FF", 1},
{"\U0001F1F9\U0001F1E6", 1},
{"\U0001F1F9\U0001F1E8", 1},
{"\U0001F1F9\U0001F1E9", 1},
{"\U0001F1F9\U0001F1EB", 1},
{"\U0001F1F9\U0001F1EC", 1},
{"\U0001F1F9\U0001F1ED", 1},
{"\U0001F1F9\U0001F1EF", 1},
{"\U0001F1F9\U0001F1F0", 1},
{"\U0001F1F9\U0001F1F1", 1},
{"\U0001F1F9\U0001F1F2", 1},
{"\U0001F1F9\U0001F1F3", 1},
{"\U0001F1F9\U0001F1F4", 1},
{"\U0001F1F9\U0001F1F7", 1},
{"\U0001F1F9\U0001F1F9", 1},
{"\U0001F1F9\U0001F1FB", 1},
{"\U0001F1F9\U0001F1FC", 1},
{"\U0001F1F9\U0001F1FF", 1},
{"\U0001F1FA\U0001F1E6", 1},
{"\U0001F1FA\U0001F1EC", 1},
{"\U0001F1FA\U0001F1F2", 1},
{"\U0001F1FA\U0001F1F3", 1},
{"\U0001F1FA\U0001F1F8", 1},
{"\U0001F1FA\U0001F1FE", 1},
{"\U0001F1FA\U0001F1FF", 1},
{"\U0001F1FB\U0001F1E6", 1},
{"\U0001F1FB\U0001F1E8", 1},
{"\U0001F1FB\U0001F1EA", 1},
{"\U0001F1FB\U0001F1EC", 1},
{"\U0001F1FB\U0001F1EE", 1},
{"\U0001F1FB\U0001F1F3", 1},
{"\U0001F1FB\U0001F1FA", 1},
{"\U0001F1FC\U0001F1EB", 1},
{"\U0001F1FC\U0001F1F8", 1},
{"\U0001F1FD\U0001F1F0", 1},
{"\U0001F1FE\U0001F1EA", 1},
{"\U0001F1FE\U0001F1F9", 1},
{"\U0001F1FF\U0001F1E6", 1},
{"\U0001F1FF\U0001F1F2", 1},
{"\U0001F1FF\U0001F1FC", 1},
{"\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F", 1},
{"\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F", 1},
{"\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F", 1},
}
