/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ILibraryDependentCore;
import com.ibm.j9ddr.corereaders.ILibraryResolver;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.LibraryDataSource;
import com.ibm.j9ddr.corereaders.LibraryResolverFactory;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFAMD64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFARM32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import com.ibm.j9ddr.corereaders.elf.ELFIA32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFPPC32DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFPPC64DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFS39031DumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFS39064DumpReader;
import com.ibm.j9ddr.corereaders.elf.LinuxProcessAddressSpace;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.SectionHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.unwind.Unwind;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.memory.MemoryRange;
import com.ibm.j9ddr.corereaders.memory.MissingFileModule;
import com.ibm.j9ddr.corereaders.memory.Module;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.Register;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public abstract class ELFDumpReader
implements ILibraryDependentCore {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    public static final String USELOADEDLIBRARIES = "com.ibm.j9ddr.corereaders.elf.ELFDumpReader.USELOADEDLIBRARIES";
    public static final String KNOWNLIBPATHS_PROPERTY = "com.ibm.j9ddr.corereaders.elf.ELFDumpReader.KNOWNLIBPATHS";
    public static final String[] KNOWNLIBPATHS_DEFAULT_32 = new String[]{"/lib", "/usr/lib", "/usr/local/lib"};
    public static final String[] KNOWNLIBPATHS_DEFAULT_64 = new String[]{"/lib64", "/usr/lib64", "/usr/local/lib64"};
    private static final String[] KNOWNLIBPATHSGLOBAL;
    private final String[] knownLibPaths;
    protected final ELFFileReader _reader;
    protected final LinuxProcessAddressSpace _process;
    protected final ILibraryResolver _resolver;
    private List<DataEntry> _processEntries = new ArrayList<DataEntry>();
    private List<DataEntry> _threadEntries = new ArrayList<DataEntry>();
    private List<DataEntry> _auxiliaryVectorEntries = new ArrayList<DataEntry>();
    private List<DataEntry> _highwordRegisterEntries = new ArrayList<DataEntry>();
    private int _pid;
    private String _executableFileName;
    private String _commandLine;
    private String _executablePathOverride;
    private int _signalNumber = -1;
    private IModule _executable;
    private List<IModule> _modules;
    private CorruptDataException _modulesException;
    private long _platformIdAddress = 0L;
    private boolean useLoadedLibraries = false;
    private ArrayList<ELFFileReader> openFileTracker = new ArrayList();
    private Unwind unwinder = null;

    protected ELFDumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        this._reader = eLFFileReader;
        this._process = new LinuxProcessAddressSpace(this._reader.addressSizeBits() / 8, this._reader.getByteOrder(), this);
        this.unwinder = new Unwind(this._process);
        this._resolver = eLFFileReader.getFile() == null ? LibraryResolverFactory.getResolverForCoreFile(eLFFileReader.getStream()) : LibraryResolverFactory.getResolverForCoreFile(eLFFileReader.getFile());
        boolean bl = this.useLoadedLibraries = System.getProperty(USELOADEDLIBRARIES) != null;
        this.knownLibPaths = KNOWNLIBPATHSGLOBAL != null ? KNOWNLIBPATHSGLOBAL : (this._reader.is64Bit() ? KNOWNLIBPATHS_DEFAULT_64 : KNOWNLIBPATHS_DEFAULT_32);
        this.processProgramHeader();
        this.processAuxiliaryHeader();
        this.readProcessData();
        try {
            this._executablePathOverride = System.getProperty("com.ibm.j9ddr.corereaders.exepath");
            this.readModules();
        }
        catch (Exception exception) {
            this._modulesException = new CorruptDataException(exception);
        }
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
        if (this._executable != null && this._executable instanceof ELFFileReader) {
            ((ELFFileReader)((Object)this._executable)).is.close();
        }
        for (IModule object : this._modules) {
            if (!(object instanceof ELFFileReader)) continue;
            ((ELFFileReader)((Object)object)).is.close();
        }
        for (ELFFileReader eLFFileReader : this.openFileTracker) {
            if (eLFFileReader == null) continue;
            eLFFileReader.close();
        }
        this._resolver.dispose();
    }

    public static ELFDumpReader getELFDumpReader(ELFFileReader eLFFileReader) throws IOException, InvalidDumpFormatException {
        switch (eLFFileReader.getMachineType()) {
            case 3: {
                return new ELFIA32DumpReader(eLFFileReader);
            }
            case 62: {
                return new ELFAMD64DumpReader(eLFFileReader);
            }
            case 20: {
                return new ELFPPC32DumpReader(eLFFileReader);
            }
            case 21: {
                return new ELFPPC64DumpReader(eLFFileReader);
            }
            case 22: {
                if (eLFFileReader.is64Bit()) {
                    return new ELFS39064DumpReader(eLFFileReader);
                }
                return new ELFS39031DumpReader(eLFFileReader);
            }
            case 40: {
                if (eLFFileReader.is64Bit()) {
                    throw new IOException("Unsupported architecture - ARM 64");
                }
                return new ELFARM32DumpReader(eLFFileReader);
            }
        }
        throw new IOException("Unrecognised machine type: " + eLFFileReader.getMachineType());
    }

    public static ELFDumpReader getELFDumpReader(File file) throws IOException, InvalidDumpFormatException {
        ELFFileReader eLFFileReader = ELFFileReader.getELFFileReader(file);
        return ELFDumpReader.getELFDumpReader(eLFFileReader);
    }

    public static ELFDumpReader getELFDumpReader(ImageInputStream imageInputStream) throws IOException, InvalidDumpFormatException {
        ELFFileReader eLFFileReader = ELFFileReader.getELFFileReader(imageInputStream);
        return ELFDumpReader.getELFDumpReader(eLFFileReader);
    }

    public List<IAddressSpace> getAddressSpaces() {
        return Collections.singletonList(this._process);
    }

    @Override
    public String getDumpFormat() {
        return "ELF";
    }

    @Override
    public Platform getPlatform() {
        return Platform.LINUX;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("system.type", "Linux");
        properties.setProperty("cpu.type", this.getProcessorType());
        properties.setProperty("cpu.subtype", this.getProcessorSubType());
        return properties;
    }

    public String getCommandLine() throws CorruptDataException {
        return this._commandLine;
    }

    private void readProcessData() throws IOException {
        if (this._processEntries.size() == 0) {
            throw new IOException("No process entries found in Elf file.");
        }
        if (this._processEntries.size() != 1) {
            throw new IOException("Unexpected number of process entries found in ELF file. Expected 1, found " + this._processEntries.size());
        }
        DataEntry dataEntry = this._processEntries.get(0);
        this._reader.seek(dataEntry.offset);
        this._reader.readByte();
        this._reader.readByte();
        this._reader.readByte();
        this._reader.readByte();
        this._reader.seek(dataEntry.offset + this._reader.padToWordBoundary(4L));
        this._reader.readElfWord();
        this.readUID();
        this.readUID();
        this._pid = this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.seek(dataEntry.offset + dataEntry.size - 96L);
        this._executableFileName = new String(this._reader.readBytes(16), "ASCII").trim();
        try {
            this._commandLine = new String(this._reader.readBytes(80), "ASCII").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private void readModules() throws IOException {
        if (this._executable == null || this._executable instanceof MissingFileModule) {
            this._modulesException = null;
            this._modules = new LinkedList<IModule>();
            this.readProcessData();
            LibraryDataSource libraryDataSource = this.findExecutableOnDiskOrAppended();
            ELFFileReader eLFFileReader = null;
            if (libraryDataSource != null && libraryDataSource.getType() != LibraryDataSource.Source.NOT_FOUND && !this.useLoadedLibraries) {
                try {
                    eLFFileReader = this.getELFReaderFromDataSource(libraryDataSource);
                }
                catch (InvalidDumpFormatException invalidDumpFormatException) {
                    // empty catch block
                }
                if (null != eLFFileReader) {
                    this.createAllModules(eLFFileReader, libraryDataSource.getName());
                }
            } else if (this._executable instanceof MissingFileModule) {
                logger.log(Level.FINE, "Libraries unavailable, falling back to loaded modules within the core file.");
                eLFFileReader = this.getELFReaderForExecutableWithinCoreFile();
                if (null != eLFFileReader) {
                    this.createAllModules(eLFFileReader, this._executablePathOverride);
                } else {
                    this._executable = new MissingFileModule(this._process, this._executableFileName, Collections.emptyList());
                }
            } else {
                this._executable = new MissingFileModule(this._process, this._executableFileName, Collections.emptyList());
            }
        }
    }

    private void createAllModules(ELFFileReader eLFFileReader, String string) throws IOException {
        LinkedList<IModule> linkedList = new LinkedList<IModule>();
        long l = eLFFileReader.getBaseAddress();
        TreeMap<Long, ELFFileReader> treeMap = this.getElfReadersForModulesWithinCoreFile(eLFFileReader, string);
        Map<Long, String> map = this.readLibraryNamesFromDebugData(eLFFileReader, treeMap, eLFFileReader);
        for (Map.Entry entry : treeMap.entrySet()) {
            IModule iModule;
            long l2 = (Long)entry.getKey();
            ELFFileReader eLFFileReader2 = (ELFFileReader)entry.getValue();
            String string2 = eLFFileReader2.readSONAME(this._reader);
            if ("lib.so".equals(string2)) {
                string2 = string;
            }
            String string3 = map.get(l2);
            ELFFileReader eLFFileReader3 = null;
            if (string3 != null) {
                string2 = string3;
                eLFFileReader3 = this.getReaderForModuleOnDiskOrAppended(string3);
            } else {
                eLFFileReader3 = this.getReaderForModuleOnDiskOrAppended(string2);
            }
            if (!eLFFileReader2.isCompatibleWith(eLFFileReader3)) {
                eLFFileReader3 = null;
            }
            if ((iModule = this.createModuleFromElfReader(l2, string2, eLFFileReader2, eLFFileReader3)) == null) continue;
            linkedList.add(iModule);
        }
        this._modules.addAll(linkedList);
        ELFFileReader eLFFileReader4 = this.getReaderForModuleOnDiskOrAppended(string);
        this._executable = this.createModuleFromElfReader(l, string, eLFFileReader, eLFFileReader4);
    }

    private ELFFileReader getELFReaderForExecutableWithinCoreFile() {
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isLoadable()) continue;
            try {
                ELFFileReader eLFFileReader = ELFFileReader.getELFFileReaderWithOffset(this._reader.getStream(), programHeaderEntry.fileOffset);
                if (!eLFFileReader.isExecutable()) continue;
                return eLFFileReader;
            }
            catch (IOException iOException) {
            }
            catch (InvalidDumpFormatException invalidDumpFormatException) {
            }
        }
        return null;
    }

    private TreeMap<Long, ELFFileReader> getElfReadersForModulesWithinCoreFile(ELFFileReader eLFFileReader, String string) {
        TreeMap<Long, ELFFileReader> treeMap = new TreeMap<Long, ELFFileReader>();
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            if (!programHeaderEntry.isLoadable() || programHeaderEntry.fileSize == 0L) continue;
            try {
                ELFFileReader eLFFileReader2 = this.getReaderFromOffsetWithinCoreFile(this._reader.getStream(), programHeaderEntry.fileOffset);
                if (eLFFileReader2 == null) continue;
                treeMap.put(programHeaderEntry.virtualAddress, eLFFileReader2);
            }
            catch (IOException iOException) {
                logger.log(Level.FINER, "IOException reading module from: " + this._reader.getSourceName() + " @ " + Long.toHexString(programHeaderEntry.fileOffset));
            }
        }
        return treeMap;
    }

    private ELFFileReader getELFReaderFromDataSource(LibraryDataSource libraryDataSource) throws IOException, InvalidDumpFormatException {
        ELFFileReader eLFFileReader = null;
        switch (libraryDataSource.getType()) {
            case FILE: {
                eLFFileReader = ELFFileReader.getELFFileReader(libraryDataSource.getFile());
                break;
            }
            case STREAM: {
                eLFFileReader = ELFFileReader.getELFFileReader(libraryDataSource.getStream());
            }
        }
        this.openFileTracker.add(eLFFileReader);
        return eLFFileReader;
    }

    private Map<Long, String> readLibraryNamesFromDebugData(ELFFileReader eLFFileReader, Map<Long, ELFFileReader> map, ELFFileReader eLFFileReader2) throws IOException {
        long l;
        long l2;
        TreeMap<Long, String> treeMap = new TreeMap<Long, String>();
        ProgramHeaderEntry programHeaderEntry = eLFFileReader.getDynamicTableEntry();
        if (programHeaderEntry == null) {
            return treeMap;
        }
        long l3 = programHeaderEntry.virtualAddress;
        if (!this.isReadableAddress(l3)) {
            return treeMap;
        }
        this._reader.seekToAddress(l3);
        do {
            l2 = this._reader.readElfWord();
            l = this._reader.readElfWord();
            if (l2 >= 0L && l2 <= 33L || l2 >= 0x60000000L && l2 <= 0x6FFFFFFFL || l2 >= 0x70000000L && l2 <= Integer.MAX_VALUE) continue;
            logger.log(Level.WARNING, "Error reading dynamic section. Invalid tag value '0x" + Long.toHexString(l2) + "'. The core file is invalid and the results may unpredictable");
        } while (l2 != 0L && l2 != 21L);
        if (l2 != 21L) {
            return treeMap;
        }
        this._reader.seekToAddress(l);
        this._reader.readElfWord();
        long l4 = this._reader.readElfWord();
        while (0L != l4) {
            this._reader.seekToAddress(l4);
            long l5 = this._reader.readElfWord();
            long l6 = this._reader.readElfWord();
            this._reader.readElfWord();
            l4 = this._reader.readElfWord();
            if (0L == l5) continue;
            String string = null;
            try {
                string = this._process.readStringAt(l6);
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
            if (null == string || string.length() == 0) continue;
            if (string.startsWith("/")) {
                treeMap.put(l5, string);
                continue;
            }
            ELFFileReader eLFFileReader3 = map.get(l5);
            if (eLFFileReader3 == null) continue;
            String string2 = eLFFileReader3.readSONAME(eLFFileReader2);
            treeMap.put(l5, string2);
        }
        return treeMap;
    }

    private IModule createModuleFromElfReader(long l, String string, ELFFileReader eLFFileReader, ELFFileReader eLFFileReader2) {
        Collection<? extends IMemorySource> collection;
        Properties properties;
        if (string == null) {
            return null;
        }
        if (eLFFileReader == null) {
            return new MissingFileModule(this._process, string, Collections.emptyList());
        }
        List<? extends ISymbol> list = null;
        Map<Long, String> map = null;
        List<SectionHeaderEntry> list2 = null;
        ProgramHeaderEntry programHeaderEntry = null;
        for (ProgramHeaderEntry object : eLFFileReader.getProgramHeaderEntries()) {
            if (!object.isEhFrame()) continue;
            programHeaderEntry = object;
        }
        try {
            if (programHeaderEntry != null) {
                this.unwinder.addCallFrameInformation(l, programHeaderEntry, string);
            }
        }
        catch (MemoryFault memoryFault) {
            logger.log(Level.FINER, "MemoryFault reading GNU_EH_FRAME data for module with name " + string + " and base address " + Long.toHexString(l));
        }
        catch (CorruptDataException corruptDataException) {
            logger.log(Level.FINER, "CorruptDataException reading GNU_EH_FRAME data for module with name " + string + " and base address " + Long.toHexString(l));
        }
        catch (IOException iOException) {
            logger.log(Level.FINER, "IOException reading GNU_EH_FRAME data for module with name " + string + " and base address " + Long.toHexString(l));
        }
        try {
            if (eLFFileReader2 != null) {
                list = eLFFileReader2.getSymbols(l, true);
                map = eLFFileReader2.getSectionHeaderStringTable();
                list2 = eLFFileReader2.getSectionHeaderEntries();
            } else {
                list = eLFFileReader.getSymbols(l, false);
                map = eLFFileReader.getSectionHeaderStringTable();
                list2 = eLFFileReader.getSectionHeaderEntries();
            }
            properties = eLFFileReader.getProperties();
            collection = eLFFileReader.getMemoryRanges(l, list2, map);
        }
        catch (IOException iOException) {
            logger.log(Level.FINER, "Error generating module with name " + string + " and base address " + Long.toHexString(l));
            return null;
        }
        ArrayList arrayList = new ArrayList(collection.size());
        for (IMemorySource iMemorySource : collection) {
            IMemorySource iMemorySource2 = this._process.getRangeForAddress(iMemorySource.getBaseAddress());
            if (iMemorySource.getBaseAddress() == l) continue;
            if (null != iMemorySource2) {
                if (!iMemorySource2.isBacked() && iMemorySource.getSize() > 0L) {
                    this._process.removeMemorySource(iMemorySource2);
                    this._process.addMemorySource(iMemorySource);
                }
            } else if (iMemorySource.getSize() > 0L) {
                this._process.addMemorySource(iMemorySource);
            }
            arrayList.add(iMemorySource);
        }
        return new Module(this._process, string, list, arrayList, l, properties);
    }

    private boolean isValidAddress(long l) {
        IMemorySource iMemorySource = this._process.getRangeForAddress(l);
        return iMemorySource != null;
    }

    private boolean isReadableAddress(long l) {
        try {
            this._process.getByteAt(l);
            return true;
        }
        catch (MemoryFault memoryFault) {
            return false;
        }
    }

    private LibraryDataSource findExecutableOnDiskOrAppended() {
        Object object;
        int n;
        if (this._executablePathOverride != null) {
            try {
                LibraryDataSource libraryDataSource = this._resolver.getLibrary(this._executablePathOverride, false);
                return libraryDataSource;
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.fine("Could not resolve executable, have the native libraries been collected ?");
                logger.logp(Level.FINER, "com.ibm.j9ddr.corereaders.elf.ELFDumpReader", "findExecutableOnDiskOrAppended", "IOException resolving library", fileNotFoundException);
            }
        }
        if ((n = this._commandLine.indexOf(" ")) != -1) {
            object = this._commandLine.substring(0, n);
            try {
                LibraryDataSource libraryDataSource = this._resolver.getLibrary((String)object, true);
                return libraryDataSource;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            object = this._resolver.getLibrary(this._executableFileName, true);
            return object;
        }
        catch (IOException iOException) {
            return new LibraryDataSource(this._executableFileName);
        }
    }

    protected abstract long readUID() throws IOException;

    protected abstract String getProcessorType();

    protected abstract SortedMap<String, Number> readRegisters() throws IOException;

    protected abstract String getStackPointerRegisterName();

    protected abstract long getBasePointerFrom(Map<String, Number> var1);

    protected abstract long getInstructionPointerFrom(Map<String, Number> var1);

    protected abstract long getLinkRegisterFrom(Map<String, Number> var1);

    protected abstract void readHighwordRegisters(DataEntry var1, Map<String, Number> var2) throws IOException, InvalidDumpFormatException;

    protected long getStackPointerFrom(Map<String, Number> map) {
        return map.get(this.getStackPointerRegisterName()).longValue();
    }

    protected long getOffsetToIPFromBP() {
        return 1L;
    }

    protected String getProcessorSubType() {
        try {
            String string = this.readStringAt(this._platformIdAddress);
            if (string == null) {
                return "unknown";
            }
            return string;
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public String readStringAt(long l) throws IOException {
        String string = null;
        if (this.isReadableAddress(l)) {
            StringBuffer stringBuffer = new StringBuffer();
            this._reader.seekToAddress(l);
            byte by = this._reader.readByte();
            while (0 != by) {
                stringBuffer.append(new String(new byte[]{by}, "ASCII"));
                by = this._reader.readByte();
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private void processProgramHeader() throws IOException {
        for (ProgramHeaderEntry programHeaderEntry : this._reader.getProgramHeaderEntries()) {
            IMemorySource iMemorySource;
            if (programHeaderEntry.isNote()) {
                this.readNotes(programHeaderEntry);
            }
            if ((iMemorySource = programHeaderEntry.asMemorySource()).getTopAddress() == -1L && iMemorySource.getBaseAddress() == 0L) continue;
            this._process.addMemorySource(iMemorySource);
        }
    }

    private void processAuxiliaryHeader() throws IOException {
        for (DataEntry dataEntry : this._auxiliaryVectorEntries) {
            this.readAuxiliaryVector(dataEntry);
        }
    }

    private void readNotes(ProgramHeaderEntry programHeaderEntry) throws IOException {
        long l = programHeaderEntry.fileOffset;
        long l2 = l + programHeaderEntry.fileSize;
        while (l >= programHeaderEntry.fileOffset && l < l2) {
            l = this.readNote(l);
        }
    }

    private long readNote(long l) throws IOException {
        this._reader.seek(l);
        long l2 = ELFDumpReader.padToIntBoundary(this._reader.readInt());
        long l3 = this._reader.readInt();
        long l4 = this._reader.readInt();
        this._reader.readBytes((int)l2);
        long l5 = l + 12L + l2;
        if (1L == l4) {
            this._threadEntries.add(new DataEntry(l5, l3));
        } else if (3L == l4) {
            this._processEntries.add(new DataEntry(l5, l3));
        } else if (6L == l4) {
            this._auxiliaryVectorEntries.add(new DataEntry(l5, l3));
        } else if (768L == l4) {
            this._highwordRegisterEntries.add(new DataEntry(l5, l3));
        }
        return l5 + ELFDumpReader.padToIntBoundary(l3);
    }

    private static long padToIntBoundary(long l) {
        return (l + 3L) / 4L * 4L;
    }

    private void readAuxiliaryVector(DataEntry dataEntry) throws IOException {
        this._reader.seek(dataEntry.offset);
        if (0L != dataEntry.size) {
            long l = this._reader.readElfWord();
            while (0L != l) {
                if (15L == l) {
                    this._platformIdAddress = this._reader.readElfWord();
                } else if (9L == l) {
                    this._reader.readElfWord();
                } else if (16L == l) {
                    this._reader.readElfWord();
                } else {
                    this._reader.readElfWord();
                }
                l = this._reader.readElfWord();
            }
        }
    }

    public IModule getExecutable() throws CorruptDataException {
        if (this._modulesException != null) {
            throw this._modulesException;
        }
        return this._executable;
    }

    public List<? extends IModule> getModules() throws CorruptDataException {
        if (this._modulesException != null) {
            throw this._modulesException;
        }
        return this._modules;
    }

    public long getProcessId() {
        return this._pid;
    }

    public List<? extends IOSThread> getThreads() {
        ArrayList<IOSThread> arrayList = new ArrayList<IOSThread>(this._threadEntries.size());
        for (DataEntry dataEntry : this._threadEntries) {
            try {
                arrayList.add(this.readThread(dataEntry));
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    private IOSThread readThread(DataEntry dataEntry) throws IOException {
        this._reader.seek(dataEntry.offset);
        this._signalNumber = this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readShort();
        this._reader.readShort();
        this._reader.readElfWord();
        this._reader.readElfWord();
        long l = (long)this._reader.readInt() & 0xFFFFFFFFL;
        this._reader.readInt();
        this._reader.readInt();
        this._reader.readInt();
        long l2 = this._reader.readElfWord();
        long l3 = this._reader.readElfWord();
        long l4 = this._reader.readElfWord();
        long l5 = this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        this._reader.readElfWord();
        SortedMap<String, Number> sortedMap = this.readRegisters();
        Properties properties = new Properties();
        properties.setProperty("Thread user time secs", Long.toString(l2));
        properties.setProperty("Thread user time usecs", Long.toString(l3));
        properties.setProperty("Thread sys time secs", Long.toString(l4));
        properties.setProperty("Thread sys time usecs", Long.toString(l5));
        if (l == (long)this._pid) {
            for (DataEntry dataEntry2 : this._highwordRegisterEntries) {
                try {
                    this.readHighwordRegisters(dataEntry2, sortedMap);
                }
                catch (InvalidDumpFormatException invalidDumpFormatException) {
                    logger.warning(invalidDumpFormatException.toString());
                }
            }
        }
        return new LinuxThread(l, sortedMap, properties);
    }

    public int getSignalNumber() {
        if (this._signalNumber == -1) {
            this.getThreads();
        }
        return this._signalNumber;
    }

    protected abstract String[] getDwarfRegisterKeys();

    protected long maskInstructionPointer(long l) {
        return l;
    }

    @Override
    public void executablePathHint(String string) {
        this._executablePathOverride = string;
        try {
            this.readModules();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private ELFFileReader getReaderFromOffsetWithinCoreFile(ImageInputStream imageInputStream, long l) throws IOException {
        ELFFileReader eLFFileReader = null;
        try {
            eLFFileReader = ELFFileReader.getELFFileReaderWithOffset(imageInputStream, l);
        }
        catch (InvalidDumpFormatException invalidDumpFormatException) {
            return null;
        }
        return eLFFileReader;
    }

    private ELFFileReader getReaderForModuleOnDiskOrAppended(String string) throws IOException {
        if (string != null) {
            try {
                String[] stringArray = this._resolver.getLibrary(string);
                if (stringArray != null && LibraryDataSource.Source.NOT_FOUND != stringArray.getType()) {
                    ELFFileReader eLFFileReader = this.getELFReaderFromDataSource((LibraryDataSource)stringArray);
                    return eLFFileReader;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (InvalidDumpFormatException invalidDumpFormatException) {
                // empty catch block
            }
            if (!string.startsWith("/")) {
                for (String string2 : this.knownLibPaths) {
                    String string3 = string2.endsWith("/") ? string2 + string : string2 + "/" + string;
                    try {
                        LibraryDataSource libraryDataSource = this._resolver.getLibrary(string3);
                        if (libraryDataSource != null && LibraryDataSource.Source.NOT_FOUND != libraryDataSource.getType()) {
                            ELFFileReader eLFFileReader = this.getELFReaderFromDataSource(libraryDataSource);
                            return eLFFileReader;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (InvalidDumpFormatException invalidDumpFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    static {
        String string = System.getProperty(KNOWNLIBPATHS_PROPERTY);
        KNOWNLIBPATHSGLOBAL = string != null ? string.split(File.pathSeparator) : null;
    }

    public class RegisterComparator
    implements Comparator<String> {
        @Override
        public int compare(String string, String string2) {
            int n = string.length() - 1;
            if (n >= 1 && Character.isDigit(string.charAt(n)) && Character.isLetter(string.charAt(n - 1))) {
                string = string.substring(0, n) + "0" + string.substring(n);
            }
            if ((n = string2.length() - 1) >= 1 && Character.isDigit(string2.charAt(n)) && Character.isLetter(string2.charAt(n - 1))) {
                string2 = string2.substring(0, n) + "0" + string2.substring(n);
            }
            return string.compareTo(string2);
        }
    }

    protected class LinuxThread
    implements IOSThread {
        private final Map<String, Number> registers;
        private final Properties properties;
        private final long tid;
        private final List<IMemoryRange> memoryRanges = new LinkedList<IMemoryRange>();
        private final List<IOSStackFrame> stackFrames = new LinkedList<IOSStackFrame>();
        private boolean stackWalked = false;

        private LinuxThread(long l, Map<String, Number> map, Properties properties) {
            this.registers = map;
            this.properties = properties;
            this.tid = l;
        }

        @Override
        public Collection<? extends IMemoryRange> getMemoryRanges() {
            this.getStackFrames();
            return this.memoryRanges;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        public List<? extends IRegister> getRegisters() {
            ArrayList<Register> arrayList = new ArrayList<Register>(this.registers.size());
            for (String string : this.registers.keySet()) {
                Number number = this.registers.get(string);
                arrayList.add(new Register(string, number));
            }
            return arrayList;
        }

        @Override
        public long getInstructionPointer() {
            if (this.registers != null) {
                return ELFDumpReader.this.getInstructionPointerFrom(this.registers);
            }
            return 0L;
        }

        @Override
        public List<? extends IOSStackFrame> getStackFrames() {
            if (!this.stackWalked) {
                this.walkStack();
                this.stackWalked = true;
            }
            return this.stackFrames;
        }

        public void walkStack() {
            long l = ELFDumpReader.this.getStackPointerFrom(this.registers);
            long l2 = ELFDumpReader.this.getBasePointerFrom(this.registers);
            long l3 = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this.getInstructionPointerFrom(this.registers));
            if (0L == l3 || !ELFDumpReader.this.isValidAddress(l3)) {
                l3 = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this.getLinkRegisterFrom(this.registers));
            }
            if (0L != l3 && ELFDumpReader.this.isValidAddress(l3) && ELFDumpReader.this.isValidAddress(l)) {
                IMemorySource iMemorySource = ELFDumpReader.this._process.getRangeForAddress(l);
                this.memoryRanges.add(new MemoryRange(ELFDumpReader.this._process.getAddressSpace(), iMemorySource, "stack"));
                UnwindTable unwindTable = null;
                try {
                    if (ELFDumpReader.this.unwinder == null) {
                        ELFDumpReader.this.unwinder = new Unwind(ELFDumpReader.this._process);
                    }
                    unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(l3);
                    Map<String, Number> map = this.registers;
                    if (unwindTable != null) {
                        map = unwindTable.apply(map, ELFDumpReader.this.getDwarfRegisterKeys());
                        long l4 = unwindTable.getFrameAddress();
                        map.put(ELFDumpReader.this.getStackPointerRegisterName(), l4);
                        OSStackFrame oSStackFrame = new OSStackFrame(l4, l3);
                        this.stackFrames.add(oSStackFrame);
                        l3 = ELFDumpReader.this.maskInstructionPointer(unwindTable.getReturnAddress());
                        unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(l3);
                    }
                    int n = 0;
                    while (l3 != 0L && ELFDumpReader.this.isValidAddress(l3) && n++ < 256) {
                        long l5;
                        if (unwindTable != null) {
                            map = unwindTable.apply(map, ELFDumpReader.this.getDwarfRegisterKeys());
                            l5 = unwindTable.getFrameAddress();
                            map.put(ELFDumpReader.this.getStackPointerRegisterName(), l5);
                            OSStackFrame oSStackFrame = new OSStackFrame(l5, l3);
                            this.stackFrames.add(oSStackFrame);
                            l3 = ELFDumpReader.this.maskInstructionPointer(unwindTable.getReturnAddress());
                            unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(l3);
                            continue;
                        }
                        if (l2 != 0L) {
                            if (ELFDumpReader.this.isValidAddress(l3)) {
                                this.stackFrames.add(new OSStackFrame(l2, l3));
                            }
                            l5 = l2;
                            l2 = ELFDumpReader.this._process.getPointerAt(l5);
                            l3 = ELFDumpReader.this.maskInstructionPointer(ELFDumpReader.this._process.getPointerAt(l5 += (long)ELFDumpReader.this._process.bytesPerPointer() * ELFDumpReader.this.getOffsetToIPFromBP()));
                            unwindTable = ELFDumpReader.this.unwinder.getUnwindTableForInstructionAddress(l3);
                            continue;
                        }
                        logger.log(Level.FINER, "Base pointer is zero");
                    }
                }
                catch (MemoryFault memoryFault) {
                    logger.log(Level.FINER, "MemoryFault reading stack @ " + String.format("0x%x", memoryFault.getAddress()) + " for thread " + this.tid);
                }
                catch (CorruptDataException corruptDataException) {
                    logger.log(Level.FINER, "CorruptDataException reading stack from: " + ELFDumpReader.this._reader.getSourceName() + " for thread " + this.tid);
                }
                catch (IOException iOException) {
                    logger.log(Level.FINER, "IOException reading stack from: " + ELFDumpReader.this._reader.getSourceName() + " for thread " + this.tid);
                }
            }
        }

        private void dumpRegisters(Map<String, Number> map) {
            System.err.printf("-------------------------\n", new Object[0]);
            int n = 0;
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : map.keySet()) {
                if (string == null) continue;
                linkedList.add(string);
            }
            Collections.sort(linkedList);
            for (String string : linkedList) {
                System.err.printf("%s = 0x%x (%d) ", string, map.get(string), map.get(string));
                if (++n % 4 != 0) continue;
                System.err.println();
            }
            System.err.println();
        }

        @Override
        public long getThreadId() throws CorruptDataException {
            return this.tid;
        }

        @Override
        public long getBasePointer() {
            return ELFDumpReader.this.getBasePointerFrom(this.registers);
        }

        @Override
        public long getStackPointer() {
            return ELFDumpReader.this.getStackPointerFrom(this.registers);
        }
    }
}

