/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import java.util.Collection;
import java.util.Collections;

public abstract class BaseModule
implements IModule {
    protected final String name;
    protected final Collection<? extends IMemoryRange> memoryRanges;
    protected final IProcess process;
    protected final long loadAddress;

    public BaseModule(IProcess iProcess, String string, Collection<? extends IMemoryRange> collection, long l) {
        this.name = string;
        this.memoryRanges = Collections.unmodifiableCollection(collection);
        this.process = iProcess;
        this.loadAddress = l;
    }

    @Override
    public Collection<? extends IMemoryRange> getMemoryRanges() {
        return this.memoryRanges;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.memoryRanges == null ? 0 : this.memoryRanges.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.process == null ? 0 : this.process.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BaseModule)) {
            return false;
        }
        BaseModule baseModule = (BaseModule)object;
        if (this.memoryRanges == null ? baseModule.memoryRanges != null : !this.memoryRanges.equals(baseModule.memoryRanges)) {
            return false;
        }
        if (this.name == null ? baseModule.name != null : !this.name.equals(baseModule.name)) {
            return false;
        }
        return !(this.process == null ? baseModule.process != null : !this.process.equals(baseModule.process));
    }

    @Override
    public long getLoadAddress() {
        return this.loadAddress;
    }
}

