/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader;

import com.ibm.j9ddr.corereaders.tdump.zebedee.dumpreader.AddressSpace;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public final class AddressSpaceImageInputStream
extends ImageInputStreamImpl {
    private AddressSpace space;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public AddressSpaceImageInputStream(AddressSpace addressSpace) {
        this.space = addressSpace;
    }

    @Override
    public int read() throws IOException {
        return this.space.read(this.streamPos++);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.space.read(this.streamPos, byArray, n, n2);
        this.streamPos += (long)n2;
        return n2;
    }

    @Override
    public void seek(long l) throws IOException {
        if (l <= 0L) {
            throw new IOException("attempt to seek to invalid pos: 0x" + AddressSpaceImageInputStream.hex(l));
        }
        super.seek(l);
        if (log.isLoggable(Level.FINER)) {
            log.finer("seek to 0x" + AddressSpaceImageInputStream.hex(l) + " streamPos now 0x" + AddressSpaceImageInputStream.hex(this.streamPos));
        }
    }

    @Override
    public int readInt() throws IOException {
        int n = this.space.readInt(this.streamPos);
        this.streamPos += 4L;
        return n;
    }

    @Override
    public long readUnsignedInt() throws IOException {
        long l = this.space.readUnsignedInt(this.streamPos);
        this.streamPos += 4L;
        return l;
    }

    @Override
    public long readLong() throws IOException {
        long l = this.space.readLong(this.streamPos);
        this.streamPos += 8L;
        return l;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }
}

