/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.Template;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;

public class TemplateField {
    private Template template;
    private Element element;
    private int offset;
    private boolean isBitField;
    int bitLength = -1;
    private String name;
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    TemplateField(String string, Template template, Element element, int n) {
        this.template = template;
        this.element = element;
        this.offset = n;
        this.name = string;
        if ((n & 7) != 0 || (this.bitLength() & 7) != 0) {
            this.isBitField = true;
        }
    }

    public boolean isBitField() {
        return this.isBitField;
    }

    public int byteLength() {
        return this.bitLength() / 8;
    }

    public int bitLength() {
        if (this.bitLength != -1) {
            return this.bitLength;
        }
        if (this.element == null) {
            return 0;
        }
        if (this.element.getTagName().equals("array")) {
            Element element = (Element)this.element.getElementsByTagName("item").item(0);
            this.bitLength = Integer.parseInt(this.element.getAttribute("length")) * Integer.parseInt(element.getAttribute("length"));
        } else if (this.element.getTagName().equals("item")) {
            this.bitLength = Integer.parseInt(this.element.getAttribute("length"));
        } else {
            throw new Error("unknown element tag: " + this.element.getTagName());
        }
        return this.bitLength;
    }

    public String getName() {
        return this.name;
    }

    public long readLong(ImageInputStream imageInputStream, long l) throws IOException {
        imageInputStream.seek(l + (long)(this.offset / 8));
        long l2 = 0L;
        if (this.isBitField) {
            if (this.bitLength() > 64) {
                throw new Error("request for long value for field " + this.name + " which has length of " + this.bitLength() + " bits");
            }
            imageInputStream.setBitOffset(this.offset & 7);
            l2 = imageInputStream.readBits(this.bitLength());
            int n = 64 - this.bitLength();
            l2 <<= n;
            l2 >>= n;
        } else if (this.byteLength() == 1) {
            l2 = imageInputStream.readByte();
        } else if (this.byteLength() == 4) {
            l2 = this.isPointer() ? imageInputStream.readUnsignedInt() : (long)imageInputStream.readInt();
        } else if (this.byteLength() == 8) {
            l2 = imageInputStream.readLong();
        } else if (this.byteLength() > 0 && this.byteLength() < 8) {
            int n;
            for (n = 0; n < this.byteLength(); ++n) {
                l2 <<= 8;
                l2 |= (long)imageInputStream.readUnsignedByte();
            }
            if (!this.isPointer()) {
                n = 64 - this.byteLength() * 8;
                l2 <<= n;
                l2 >>= n;
            }
        } else {
            throw new Error("request for long value for field " + this.name + " which has length of " + this.byteLength());
        }
        log.fine("for field " + this.name + " of type " + this.element.getTagName() + " read value of 0x" + TemplateField.hex(l2));
        return l2;
    }

    public boolean isPointer() {
        return this.element.getElementsByTagName("pointer").getLength() != 0;
    }

    public int getOffset() {
        return this.offset / 8;
    }

    public int getBitOffset() {
        return this.offset;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }
}

