/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCArrayObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.GC_ArrayletObjectModelPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectContiguousPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm29.structure.GC_ArrayletObjectModelBase;
import com.ibm.j9ddr.vm29.structure.J9IndexableObjectContiguous;
import com.ibm.j9ddr.vm29.structure.J9IndexableObjectDiscontiguous;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.NoSuchElementException;

public abstract class GCArrayletObjectModelBase_V1
extends GCArrayObjectModel {
    protected GC_ArrayletObjectModelPointer arrayletObjectModel = GC_ArrayletObjectModelPointer.cast(GCBase.getExtensions().indexableObjectModel());
    protected VoidPointer arrayletRangeBase = this.arrayletObjectModel._arrayletRangeBase();
    protected VoidPointer arrayletRangeTop = this.arrayletObjectModel._arrayletRangeTop();
    protected UDATA largestDesirableArraySpineSize = this.arrayletObjectModel._largestDesirableArraySpineSize();
    protected UDATA arrayletLeafSize;
    protected UDATA arrayletLeafLogSize;
    protected UDATA arrayletLeafSizeMask;

    public GCArrayletObjectModelBase_V1() throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = GCBase.getJavaVM();
        this.arrayletLeafSize = j9JavaVMPointer.arrayletLeafSize();
        this.arrayletLeafLogSize = j9JavaVMPointer.arrayletLeafLogSize();
        this.arrayletLeafSizeMask = this.arrayletLeafSize.sub(1L);
    }

    protected UDATA getSpineSize(long l, UDATA uDATA, UDATA uDATA2, boolean bl) throws CorruptDataException {
        UDATA uDATA3 = this.getHeaderSize(l);
        UDATA uDATA4 = this.getSpineSizeWithoutHeader(l, uDATA, uDATA2, bl);
        return uDATA4.add(uDATA3);
    }

    @Override
    public UDATA getSizeInElements(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        U32 u32 = J9IndexableObjectHelper.size(j9IndexableObjectPointer);
        if (u32.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return new UDATA(u32);
    }

    protected UDATA getHeaderSize(long l) {
        long l2 = GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous != l ? J9IndexableObjectDiscontiguous.SIZEOF : J9IndexableObjectContiguous.SIZEOF;
        return new UDATA(l2);
    }

    @Override
    public UDATA getHeaderSize(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        UDATA uDATA = J9IndexableObjectContiguousPointer.cast(j9IndexableObjectPointer).size();
        long l = uDATA.eq(0L) ? J9IndexableObjectDiscontiguous.SIZEOF : J9IndexableObjectContiguous.SIZEOF;
        return new UDATA(l);
    }

    protected UDATA getSpineSizeWithoutHeader(long l, UDATA uDATA, UDATA uDATA2, boolean bl) throws CorruptDataException {
        UDATA uDATA3 = new UDATA(0L);
        UDATA uDATA4 = new UDATA(0L);
        if (GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous != l && !uDATA2.eq(0L)) {
            if (bl) {
                uDATA4 = new UDATA(ObjectModel.getObjectAlignmentInBytes() - ObjectReferencePointer.SIZEOF);
            }
            uDATA3 = uDATA.mult(ObjectReferencePointer.SIZEOF);
        }
        UDATA uDATA5 = new UDATA(0L);
        if (GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous == l) {
            uDATA5 = uDATA2;
        } else if (GC_ArrayletObjectModelBase.ArrayLayout.Hybrid == l) {
            uDATA5 = uDATA2.bitAnd(this.arrayletLeafSizeMask);
        }
        return uDATA4.add(uDATA3).add(uDATA5);
    }

    protected UDATA getSpineSize(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        long l = this.getArrayLayout(j9IndexableObjectPointer);
        boolean bl = this.shouldAlignSpineDataSection(J9IndexableObjectHelper.clazz(j9IndexableObjectPointer));
        UDATA uDATA = this.getDataSizeInBytes(j9IndexableObjectPointer);
        UDATA uDATA2 = this.numArraylets(uDATA);
        return this.getSpineSize(l, uDATA2, uDATA, bl);
    }

    protected long getArrayLayout(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        if (!J9IndexableObjectContiguousPointer.cast(j9IndexableObjectPointer).size().eq(0L)) {
            return GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous;
        }
        if (j9IndexableObjectPointer.gte(this.arrayletRangeBase) && j9IndexableObjectPointer.lt(this.arrayletRangeTop)) {
            UDATA uDATA = this.getDataSizeInBytes(j9IndexableObjectPointer);
            long l = this.getArrayLayout(J9IndexableObjectHelper.clazz(j9IndexableObjectPointer), uDATA);
            return l;
        }
        return GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous;
    }

    protected long getArrayLayout(J9ArrayClassPointer j9ArrayClassPointer, UDATA uDATA) throws CorruptDataException {
        UDATA uDATA2;
        long l = GC_ArrayletObjectModelBase.ArrayLayout.Illegal;
        UDATA uDATA3 = uDATA2 = new UDATA(0L);
        if (GCExtensions.isVLHGC()) {
            uDATA2 = uDATA2.add(ObjectModel.getObjectAlignmentInBytes());
        }
        if (this.largestDesirableArraySpineSize.eq(UDATA.MAX) || uDATA.lte(this.largestDesirableArraySpineSize.sub(uDATA3).sub(J9IndexableObjectContiguous.SIZEOF))) {
            l = GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous;
            if (uDATA.eq(0L)) {
                l = GC_ArrayletObjectModelBase.ArrayLayout.Discontiguous;
            }
        } else {
            UDATA uDATA4;
            UDATA uDATA5 = uDATA.bitAnd(this.arrayletLeafSizeMask);
            UDATA uDATA6 = this.numArraylets(uDATA);
            boolean bl = this.shouldAlignSpineDataSection(j9ArrayClassPointer);
            UDATA uDATA7 = this.getSpineSize(GC_ArrayletObjectModelBase.ArrayLayout.Hybrid, uDATA6, uDATA, bl);
            UDATA uDATA8 = uDATA4 = ObjectModel.adjustSizeInBytes(uDATA7);
            if (GCExtensions.isVLHGC()) {
                uDATA8.add(ObjectModel.getObjectAlignmentInBytes());
            }
            l = uDATA5.gt(0) && uDATA8.lte(this.largestDesirableArraySpineSize) ? GC_ArrayletObjectModelBase.ArrayLayout.Hybrid : GC_ArrayletObjectModelBase.ArrayLayout.Discontiguous;
        }
        return l;
    }

    @Override
    public UDATA getDataSizeInBytes(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        J9ArrayClassPointer j9ArrayClassPointer = J9IndexableObjectHelper.clazz(j9IndexableObjectPointer);
        UDATA uDATA = J9ROMArrayClassPointer.cast(j9ArrayClassPointer.romClass()).arrayShape();
        UDATA uDATA2 = this.getSizeInElements(j9IndexableObjectPointer);
        UDATA uDATA3 = uDATA2.leftShift(uDATA.bitAnd(65535).intValue());
        return UDATA.roundToSizeofUDATA(uDATA3);
    }

    @Override
    public ObjectReferencePointer getArrayoidPointer(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return ObjectReferencePointer.cast(j9IndexableObjectPointer.addOffset(J9IndexableObjectDiscontiguous.SIZEOF));
    }

    @Override
    public VoidPointer getDataPointerForContiguous(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return VoidPointer.cast(j9IndexableObjectPointer.addOffset(J9IndexableObjectContiguous.SIZEOF));
    }

    @Override
    public UDATA getHashcodeOffset(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        long l = this.getArrayLayout(j9IndexableObjectPointer);
        J9ArrayClassPointer j9ArrayClassPointer = J9IndexableObjectHelper.clazz(j9IndexableObjectPointer);
        UDATA uDATA = J9ROMArrayClassPointer.cast(j9ArrayClassPointer.romClass()).arrayShape();
        UDATA uDATA2 = this.getSizeInElements(j9IndexableObjectPointer);
        UDATA uDATA3 = uDATA2.leftShift(uDATA.bitAnd(65535).intValue());
        UDATA uDATA4 = this.numArraylets(uDATA3);
        boolean bl = this.shouldAlignSpineDataSection(j9ArrayClassPointer);
        UDATA uDATA5 = this.getSpineSize(l, uDATA4, uDATA3, bl);
        return U32.roundToSizeofU32(uDATA5);
    }

    @Override
    public boolean isInlineContiguousArraylet(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        return this.getArrayLayout(j9IndexableObjectPointer) == GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous;
    }

    protected boolean shouldAlignSpineDataSection(J9ArrayClassPointer j9ArrayClassPointer) throws CorruptDataException {
        return this.shouldAlignSpineDataSection(J9ClassPointer.cast(j9ArrayClassPointer));
    }

    protected boolean shouldAlignSpineDataSection(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        UDATA uDATA;
        boolean bl = false;
        if (J9BuildFlags.gc_compressedPointers) {
            bl = true;
        } else if (!J9BuildFlags.env_data64 && (uDATA = ObjectModel.getClassShape(j9ClassPointer)).eq(J9Object.OBJECT_HEADER_SHAPE_DOUBLES)) {
            bl = true;
        }
        return bl;
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        UDATA uDATA;
        boolean bl = this.isInlineContiguousArraylet(j9IndexableObjectPointer);
        UDATA uDATA2 = new UDATA((long)n * (long)n2);
        if (bl) {
            return VoidPointer.cast(this.getDataPointerForContiguous(j9IndexableObjectPointer).addOffset(uDATA2));
        }
        ObjectReferencePointer objectReferencePointer = this.getArrayoidPointer(j9IndexableObjectPointer);
        VoidPointer voidPointer = VoidPointer.cast(objectReferencePointer.at(uDATA = uDATA2.rightShift(this.arrayletLeafLogSize)));
        if (voidPointer.isNull()) {
            throw new NoSuchElementException("Arraylet leaf not yet initialized");
        }
        UDATA uDATA3 = uDATA2.bitAnd(this.arrayletLeafSizeMask);
        return voidPointer.addOffset(uDATA3);
    }

    protected UDATA numArraylets(UDATA uDATA) throws CorruptDataException {
        UDATA uDATA2 = new UDATA(1L);
        if (!UDATA.MAX.eq(this.arrayletLeafSize)) {
            UDATA uDATA3 = UDATA.MAX.eq(uDATA) ? UDATA.MAX : uDATA.add(1L);
            uDATA2 = uDATA3.rightShift(this.arrayletLeafLogSize).add(uDATA3.bitAnd(this.arrayletLeafSizeMask).add(this.arrayletLeafSizeMask).rightShift(this.arrayletLeafLogSize));
        }
        return uDATA2;
    }

    protected UDATA numExternalArraylets(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        UDATA uDATA = new UDATA(0L);
        if (this.getArrayLayout(j9IndexableObjectPointer) != GC_ArrayletObjectModelBase.ArrayLayout.InlineContiguous) {
            uDATA = this.numArraylets(this.getDataSizeInBytes(j9IndexableObjectPointer));
            uDATA = uDATA.sub(1L);
        }
        return uDATA;
    }

    protected UDATA externalArrayletsSize(J9IndexableObjectPointer j9IndexableObjectPointer) throws CorruptDataException {
        UDATA uDATA = this.numExternalArraylets(j9IndexableObjectPointer);
        return uDATA.mult(this.arrayletLeafSize);
    }
}

