/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectHash;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCObjectModel;
import com.ibm.j9ddr.vm29.pointer.I32Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.GC_ObjectModelPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.structure.GC_ObjectModel;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.structure.J9Object;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

class GCObjectModel_V1
extends GCObjectModel {
    private J9JavaVMPointer vm;
    private J9ClassPointer classClass;
    private J9ClassPointer classLoaderClass;
    private J9ClassPointer atomicMarkableReferenceClass;
    private VoidPointer tenureBase;
    private UDATA tenureSize;
    private static final long OBJECT_HEADER_REMEMBERED_BITS = J9Object.OBJECT_HEADER_AGE_MASK & (J9Consts.J9_GC_ARRAYLET_LAYOUT_MASK ^ 0xFFFFFFFFFFFFFFFFL);
    private static final long STATE_REMEMBERED = J9Consts.J9_OBJECT_HEADER_REMEMBERED_BITS_TO_SET & OBJECT_HEADER_REMEMBERED_BITS;
    private static final long OBSOLETE_OBJECT_ALIGNMENT_IN_BYTES = 8L;

    protected GCObjectModel_V1() throws CorruptDataException {
        GC_ObjectModelPointer gC_ObjectModelPointer = GCObjectModel_V1.getExtensions().objectModel();
        this.vm = GCBase.getJavaVM();
        this.classClass = gC_ObjectModelPointer._classClass();
        this.classLoaderClass = gC_ObjectModelPointer._classLoaderClass();
        this.atomicMarkableReferenceClass = gC_ObjectModelPointer._atomicMarkableReferenceClass();
        this.tenureBase = GCObjectModel_V1.getExtensions()._tenureBase();
        this.tenureSize = GCObjectModel_V1.getExtensions()._tenureSize();
    }

    @Override
    public U32 getAge(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(j9ObjectPointer).bitAnd(J9Object.OBJECT_HEADER_AGE_MASK).rightShift((int)J9Object.OBJECT_HEADER_AGE_SHIFT);
    }

    @Override
    public UDATA getConsumedSizeInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = this.getSizeInBytesWithHeader(j9ObjectPointer);
        if (this.hasBeenMoved(j9ObjectPointer) && this.getHashcodeOffset(j9ObjectPointer).eq(uDATA)) {
            uDATA = uDATA.add(UDATA.SIZEOF);
        }
        return this.adjustSizeInBytes(uDATA);
    }

    @Override
    public UDATA getClassShape(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return this.getClassShape(J9ObjectHelper.clazz(j9ObjectPointer));
    }

    @Override
    public UDATA getSizeInBytesDeadObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (this.isSingleSlotDeadObject(j9ObjectPointer)) {
            return this.getSizeInBytesSingleSlotDeadObject(j9ObjectPointer);
        }
        return this.getSizeInBytesMultiSlotDeadObject(j9ObjectPointer);
    }

    @Override
    public UDATA getSizeInBytesMultiSlotDeadObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromJ9Object(j9ObjectPointer).getSize();
    }

    @Override
    public UDATA getSizeInBytesSingleSlotDeadObject(J9ObjectPointer j9ObjectPointer) {
        return new UDATA(UDATA.SIZEOF);
    }

    @Override
    public long getObjectAlignmentInBytes() {
        long l = 0L;
        try {
            l = this.vm.omrVM()._objectAlignmentInBytes().longValue();
            if (0L == l) {
                l = 8L;
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
            l = 8L;
        }
        catch (CorruptDataException corruptDataException) {
            l = 8L;
        }
        return l;
    }

    @Override
    public UDATA getSizeInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (this.isIndexable(j9ObjectPointer)) {
            return this.indexableObjectModel.getSizeInBytesWithHeader(J9IndexableObjectPointer.cast(j9ObjectPointer));
        }
        return this.mixedObjectModel.getSizeInBytesWithHeader(j9ObjectPointer);
    }

    @Override
    public UDATA getTotalFootprintInBytesWithHeader(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (this.isIndexable(j9ObjectPointer)) {
            return this.adjustSizeInBytes(this.indexableObjectModel.getTotalFootprintInBytesWithHeader(J9IndexableObjectPointer.cast(j9ObjectPointer)));
        }
        return this.adjustSizeInBytes(this.mixedObjectModel.getSizeInBytesWithHeader(j9ObjectPointer));
    }

    @Override
    public boolean isDeadObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(j9ObjectPointer).allBitsIn(J9Consts.J9_GC_OBJ_HEAP_HOLE);
    }

    @Override
    public boolean isIndexable(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return this.isIndexable(J9ObjectHelper.clazz(j9ObjectPointer));
    }

    @Override
    public boolean isIndexable(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return J9ClassHelper.isArrayClass(j9ClassPointer);
    }

    @Override
    public boolean isOld(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        VoidPointer voidPointer = this.tenureBase.addOffset(this.tenureSize);
        return j9ObjectPointer.gte(this.tenureBase) && j9ObjectPointer.lt(voidPointer);
    }

    @Override
    public boolean isRemembered(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return this.getRememberedBits(j9ObjectPointer).gte(new UDATA(STATE_REMEMBERED));
    }

    @Override
    public boolean isSingleSlotDeadObject(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(j9ObjectPointer).bitAnd(J9Consts.J9_GC_OBJ_HEAP_HOLE_MASK).eq(J9Consts.J9_GC_SINGLE_SLOT_HOLE);
    }

    @Override
    public UDATA adjustSizeInBytes(UDATA uDATA) {
        long l = uDATA.longValue();
        if (!J9BuildFlags.env_data64 || J9BuildFlags.gc_compressedPointers) {
            l = l + (ObjectModel.getObjectAlignmentInBytes() - 1L) & (ObjectModel.getObjectAlignmentInBytes() - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (J9BuildFlags.gc_minimumObjectSize && l < J9Consts.J9_GC_MINIMUM_OBJECT_SIZE) {
            l = J9Consts.J9_GC_MINIMUM_OBJECT_SIZE;
        }
        return new UDATA(l);
    }

    @Override
    public UDATA getSizeInElements(J9ObjectPointer j9ObjectPointer) throws IllegalArgumentException, CorruptDataException {
        if (this.isIndexable(j9ObjectPointer)) {
            return this.indexableObjectModel.getSizeInElements(J9IndexableObjectPointer.cast(j9ObjectPointer));
        }
        throw new IllegalArgumentException("this API is only valid on indexable objects");
    }

    @Override
    public UDATA getRememberedBits(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        return J9ObjectHelper.flags(j9ObjectPointer).bitAnd(new UDATA(OBJECT_HEADER_REMEMBERED_BITS));
    }

    @Override
    public long getScanType(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        J9ClassPointer j9ClassPointer = J9ObjectHelper.clazz(j9ObjectPointer);
        return this.getScanType(j9ClassPointer);
    }

    private long getScanType(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        long l = this.getClassShape(j9ClassPointer).longValue();
        long l2 = l == J9Object.OBJECT_HEADER_SHAPE_MIXED ? (J9ClassHelper.classFlags(j9ClassPointer).anyBitsIn(J9JavaAccessFlags.J9AccClassReferenceMask) ? GC_ObjectModel.ScanType.SCAN_REFERENCE_MIXED_OBJECT : (J9ClassHelper.classFlags(j9ClassPointer).anyBitsIn(J9JavaAccessFlags.J9AccClassGCSpecial) ? this.getSpecialClassScanType(j9ClassPointer) : GC_ObjectModel.ScanType.SCAN_MIXED_OBJECT)) : (l == J9Object.OBJECT_HEADER_SHAPE_POINTERS ? GC_ObjectModel.ScanType.SCAN_POINTER_ARRAY_OBJECT : (l == J9Object.OBJECT_HEADER_SHAPE_DOUBLES || l == J9Object.OBJECT_HEADER_SHAPE_BYTES || l == J9Object.OBJECT_HEADER_SHAPE_WORDS || l == J9Object.OBJECT_HEADER_SHAPE_LONGS ? GC_ObjectModel.ScanType.SCAN_PRIMITIVE_ARRAY_OBJECT : GC_ObjectModel.ScanType.SCAN_INVALID_OBJECT));
        return l2;
    }

    private long getSpecialClassScanType(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        long l = GC_ObjectModel.ScanType.SCAN_MIXED_OBJECT;
        l = j9ClassPointer.eq(this.classClass) ? GC_ObjectModel.ScanType.SCAN_CLASS_OBJECT : (this.classLoaderClass.notNull() && J9ClassHelper.isSameOrSuperClassOf(this.classLoaderClass, j9ClassPointer) ? GC_ObjectModel.ScanType.SCAN_CLASSLOADER_OBJECT : (this.atomicMarkableReferenceClass.notNull() && J9ClassHelper.isSameOrSuperClassOf(this.atomicMarkableReferenceClass, j9ClassPointer) ? GC_ObjectModel.ScanType.SCAN_ATOMIC_MARKABLE_REFERENCE_OBJECT : GC_ObjectModel.ScanType.SCAN_INVALID_OBJECT));
        return l;
    }

    @Override
    public I32 getObjectHashCode(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        I32 i32 = new I32(0L);
        i32 = J9BuildFlags.gc_modronCompaction || J9BuildFlags.gc_generational ? (this.hasBeenMoved(j9ObjectPointer) ? I32Pointer.cast(j9ObjectPointer).addOffset(this.getHashcodeOffset(j9ObjectPointer).longValue()).at(0L) : ObjectHash.convertObjectAddressToHash(this.vm, j9ObjectPointer)) : ObjectHash.convertObjectAddressToHash(this.vm, j9ObjectPointer);
        return i32;
    }

    @Override
    public boolean hasBeenHashed(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (J9BuildFlags.interp_flagsInClassSlot) {
            return J9ObjectHelper.flags(j9ObjectPointer).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_HASHED_MASK_IN_CLASS);
        }
        return J9ObjectHelper.flags(j9ObjectPointer).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_HASHED);
    }

    @Override
    public boolean hasBeenMoved(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (J9BuildFlags.interp_flagsInClassSlot) {
            return J9ObjectHelper.flags(j9ObjectPointer).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_MOVED_IN_CLASS);
        }
        return J9ObjectHelper.flags(j9ObjectPointer).allBitsIn(J9Object.OBJECT_HEADER_HAS_BEEN_MOVED);
    }

    @Override
    public UDATA getHashcodeOffset(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        UDATA uDATA = new UDATA(0L);
        uDATA = this.isIndexable(j9ObjectPointer) ? this.indexableObjectModel.getHashcodeOffset(J9IndexableObjectPointer.cast(j9ObjectPointer)) : this.mixedObjectModel.getHashcodeOffset(j9ObjectPointer);
        return uDATA;
    }

    @Override
    public UDATA getHeaderSize(J9ObjectPointer j9ObjectPointer) throws CorruptDataException {
        if (this.isIndexable(j9ObjectPointer)) {
            return this.indexableObjectModel.getHeaderSize(J9IndexableObjectPointer.cast(j9ObjectPointer));
        }
        return this.mixedObjectModel.getHeaderSize(j9ObjectPointer);
    }

    @Override
    public UDATA getClassShape(J9ClassPointer j9ClassPointer) throws CorruptDataException {
        return new UDATA(J9ClassHelper.classFlags(j9ClassPointer).longValue() >> (int)J9JavaAccessFlags.J9AccClassRAMShapeShift & J9Object.OBJECT_HEADER_SHAPE_MASK);
    }

    @Override
    public VoidPointer getElementAddress(J9IndexableObjectPointer j9IndexableObjectPointer, int n, int n2) throws CorruptDataException {
        return this.indexableObjectModel.getElementAddress(j9IndexableObjectPointer, n, n2);
    }
}

