/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.UnsupportedEncodingException;

public class U8Pointer
extends Pointer {
    public static final int SIZEOF = 1;
    public static final U8Pointer NULL = new U8Pointer(0L);

    protected U8Pointer(long l) {
        super(l);
    }

    public static U8Pointer cast(AbstractPointer abstractPointer) {
        return U8Pointer.cast(abstractPointer.getAddress());
    }

    public static U8Pointer cast(UDATA uDATA) {
        return U8Pointer.cast(uDATA.longValue());
    }

    public static U8Pointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new U8Pointer(l);
    }

    @Override
    public U8 at(long l) throws CorruptDataException {
        return new U8(this.getByteAtOffset(l * 1L));
    }

    @Override
    public U8 at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    public U8Pointer untag() {
        throw new UnsupportedOperationException("Use UPointer.untag(long mask) instead.");
    }

    @Override
    public U8Pointer untag(long l) {
        return new U8Pointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public U8Pointer add(long l) {
        return new U8Pointer(this.address + 1L * l);
    }

    @Override
    public U8Pointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public U8Pointer addOffset(long l) {
        return new U8Pointer(this.address + l);
    }

    @Override
    public U8Pointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    public String getCStringAtOffset(long l) throws CorruptDataException {
        return this.getCStringAtOffset(l, Long.MAX_VALUE);
    }

    public String getCStringAtOffset(long l, long l2) throws CorruptDataException {
        int n = 0;
        while (0 != this.getByteAtOffset(l + (long)n) && (long)n < l2) {
            ++n;
        }
        byte[] byArray = new byte[n];
        this.getBytesAtOffset(l, byArray);
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    @Override
    public U8Pointer sub(long l) {
        return new U8Pointer(this.address - 1L * l);
    }

    @Override
    public U8Pointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public U8Pointer subOffset(long l) {
        return new U8Pointer(this.address - l);
    }

    @Override
    public U8Pointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return 1L;
    }
}

