/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgROMClassBuilderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9DbgStringInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9InternHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SRPHashTableInternalPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SRPHashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedInternSRPHashTableEntryPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9SharedInvariantInternTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9TranslationBufferSetPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9SharedInternSRPHashTableEntry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class WalkInternTableCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");
    private static final String tab = "\t";

    public WalkInternTableCommand() {
        this.addCommand("walkinterntable", "1|2|3|4|5|6|help", "Prints string intern table information or help");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            if (stringArray.length != 0) {
                if (stringArray.length == 1) {
                    if (stringArray[0].trim().equalsIgnoreCase("help")) {
                        this.printUsage(printStream);
                        return;
                    }
                    try {
                        int n = Integer.parseInt(stringArray[0]);
                        this.runWalkInternTableSelection(n, printStream, context, false);
                        return;
                    }
                    catch (NumberFormatException numberFormatException) {
                        printStream.append("Error: Invalid Option :" + stringArray[0] + nl);
                        this.printUsage(printStream);
                        return;
                    }
                }
                printStream.append("Error: Too many options : ");
                for (int i = 0; i < stringArray.length; ++i) {
                    printStream.append(stringArray[i].toString());
                    if (i + 1 >= stringArray.length) continue;
                    printStream.append(", ");
                }
                printStream.append(nl + "!walkintertable expects none(to print usage and valid args) or one integer arg." + nl);
                this.printUsage(printStream);
                return;
            }
            this.printUsage(printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void runSubMenu(Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        printStream.append("!walkinterntable sub menu command >  " + nl);
        try {
            String string;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                printStream.append("Exception occured while reading the user input" + nl);
                iOException.printStackTrace();
                return;
            }
            try {
                if (string.compareToIgnoreCase("exit") == 0) {
                    printStream.append("Exiting !walkinterntable sub menu..." + nl);
                    return;
                }
                int n = Integer.parseInt(string);
                this.runWalkInternTableSelection(n, printStream, context, true);
            }
            catch (NumberFormatException numberFormatException) {
                string = string.trim();
                if (string.toLowerCase().equals("quit")) {
                    printStream.println("To quit, please go back to main menu. (Type \"exit\")" + nl);
                }
                String[] stringArray = string.split("\\s");
                String[] stringArray2 = new String[stringArray.length - 1];
                for (int i = 1; i < stringArray.length; ++i) {
                    stringArray2[i - 1] = stringArray[i];
                }
                context.execute(stringArray[0].toLowerCase(), stringArray2, printStream);
            }
            this.runSubMenu(context, printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    private void runWalkInternTableSelection(int n, PrintStream printStream, Context context, boolean bl) throws CorruptDataException, DDRInteractiveCommandException {
        switch (n) {
            case 1: {
                this.printSharedTableStructure(printStream);
                break;
            }
            case 2: {
                this.printLocalTableStructure(printStream);
                break;
            }
            case 3: {
                this.walkSharedTable(printStream);
                break;
            }
            case 4: {
                this.walkLocalTable(printStream);
                break;
            }
            case 5: {
                this.walkSharedTable(printStream);
                this.walkLocalTable(printStream);
                break;
            }
            case 6: {
                this.printSubMenu(printStream);
                if (bl) break;
                this.runSubMenu(context, printStream);
                break;
            }
            default: {
                printStream.append("Error: Invalid option = " + n + nl);
                this.printMainOptions(printStream);
            }
        }
    }

    private void printSharedTableStructure(PrintStream printStream) throws CorruptDataException {
        J9SRPHashTableInternalPointer j9SRPHashTableInternalPointer;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9SharedInvariantInternTablePointer j9SharedInvariantInternTablePointer = j9JavaVMPointer.sharedInvariantInternTable();
        if (!j9SharedInvariantInternTablePointer.isNull()) {
            printStream.println(j9SharedInvariantInternTablePointer.formatFullInteractive());
        }
        printStream.append("Total Shared Weight : " + j9SharedInvariantInternTablePointer.totalSharedWeightPtr().at(0L).longValue() + nl);
        J9SRPHashTablePointer j9SRPHashTablePointer = j9SharedInvariantInternTablePointer.sharedInvariantSRPHashtable();
        if (!j9SRPHashTablePointer.isNull()) {
            printStream.println(j9SRPHashTablePointer.formatFullInteractive());
        }
        if (!(j9SRPHashTableInternalPointer = j9SRPHashTablePointer.srpHashtableInternal()).isNull()) {
            printStream.println(j9SRPHashTableInternalPointer.formatFullInteractive());
        }
    }

    private void printLocalTableStructure(PrintStream printStream) throws CorruptDataException {
        J9DbgStringInternTablePointer j9DbgStringInternTablePointer = this.getRomClassBuilderPtr(printStream);
        if (!j9DbgStringInternTablePointer.isNull()) {
            printStream.println(j9DbgStringInternTablePointer.formatFullInteractive());
        }
    }

    private void walkSharedTable(PrintStream printStream) throws CorruptDataException {
        int n = 0;
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        J9SharedInvariantInternTablePointer j9SharedInvariantInternTablePointer = j9JavaVMPointer.sharedInvariantInternTable();
        if (!j9SharedInvariantInternTablePointer.isNull()) {
            J9SharedInternSRPHashTableEntryPointer j9SharedInternSRPHashTableEntryPointer = j9SharedInvariantInternTablePointer.headNode();
            int n2 = 1;
            printStream.append("=================================================================================" + nl);
            printStream.append(this.tab(2) + "WALKING SHARED INTERN SRP HASHTABLE (SRPHashTable " + j9SharedInvariantInternTablePointer.sharedInvariantSRPHashtable().getHexAddress() + ")" + nl);
            printStream.append(this.tab(2) + "FROM: MRU (MOST RECENTLY USED)" + nl);
            printStream.append(this.tab(2) + "TO: LRU (LEAST RECENTLY USED)" + nl);
            printStream.append("=================================================================================" + nl);
            while (!j9SharedInternSRPHashTableEntryPointer.isNull()) {
                printStream.append(n2 + "." + tab + "Shared Table Entry < !J9SharedInternSRPHashTableEntry " + j9SharedInternSRPHashTableEntryPointer.getHexAddress() + " Flags: " + j9SharedInternSRPHashTableEntryPointer.flags().getHexValue() + " IWeight: " + j9SharedInternSRPHashTableEntryPointer.internWeight().longValue() + " IsUTF8Shared: " + j9SharedInternSRPHashTableEntryPointer.flags().allBitsIn(J9SharedInternSRPHashTableEntry.STRINGINTERNTABLES_NODE_FLAG_UTF8_IS_SHARED) + ">" + tab + "UTF8 <Add: " + j9SharedInternSRPHashTableEntryPointer.utf8SRP().getHexAddress() + " Data: \"" + J9UTF8Helper.stringValue(j9SharedInternSRPHashTableEntryPointer.utf8SRP()) + "\">" + nl);
                n = (int)((long)n + j9SharedInternSRPHashTableEntryPointer.internWeight().longValue());
                j9SharedInternSRPHashTableEntryPointer = j9SharedInternSRPHashTableEntryPointer.nextNode();
                ++n2;
            }
            printStream.append("Total Weight = " + n + nl);
            printStream.append("=================================================================================" + nl);
            printStream.append(this.tab(2) + "WALKING SHARED INTERN SRP HASHTABLE COMPLETED" + nl);
            printStream.append("=================================================================================" + nl);
        }
    }

    private void walkLocalTable(PrintStream printStream) throws CorruptDataException {
        int n = 0;
        J9DbgStringInternTablePointer j9DbgStringInternTablePointer = this.getRomClassBuilderPtr(printStream);
        if (j9DbgStringInternTablePointer.isNull()) {
            printStream.append("StringInternTable is null" + nl);
            return;
        }
        J9InternHashTableEntryPointer j9InternHashTableEntryPointer = j9DbgStringInternTablePointer.headNode();
        if (j9InternHashTableEntryPointer.isNull()) {
            printStream.append("HeadNode is null" + nl);
            return;
        }
        int n2 = 1;
        printStream.append("=================================================================================" + nl);
        printStream.append(this.tab(2) + "WALKING LOCAL INTERN HASHTABLE (stringInternTable )" + j9DbgStringInternTablePointer.getHexAddress() + ")" + nl);
        printStream.append(this.tab(2) + "FROM: MRU (MOST RECENTLY USED)" + nl);
        printStream.append(this.tab(2) + "TO: LRU (LEAST RECENTLY USED)" + nl);
        printStream.append("=================================================================================" + nl);
        while (!j9InternHashTableEntryPointer.isNull()) {
            printStream.append(n2 + "." + tab + "Local Table Entry < !J9InternHashTableEntry " + j9InternHashTableEntryPointer.getHexAddress() + " Flags: " + j9InternHashTableEntryPointer.flags().getHexValue() + " IWeight: " + j9InternHashTableEntryPointer.internWeight().longValue() + " ClassLoader: !J9ClassLoader " + j9InternHashTableEntryPointer.classLoader().getHexAddress() + ">" + tab + "UTF8 <Add: " + j9InternHashTableEntryPointer.utf8().getHexAddress() + " Data: \"" + J9UTF8Helper.stringValue(j9InternHashTableEntryPointer.utf8()) + "\">" + nl);
            n = (int)((long)n + j9InternHashTableEntryPointer.internWeight().longValue());
            j9InternHashTableEntryPointer = j9InternHashTableEntryPointer.nextNode();
            ++n2;
        }
        printStream.append("Total Weight = " + n + nl);
        printStream.append("=================================================================================" + nl);
        printStream.append(this.tab(2) + "WALKING LOCAL INTERN HASHTABLE COMPLETED" + nl);
        printStream.append("=================================================================================" + nl);
    }

    private void printSubMenu(PrintStream printStream) {
        printStream.append("INFO: You are in !walkinterntable sub menu." + nl);
        this.printMainOptions(printStream);
        printStream.append("6" + this.tab(1) + "To print this menu again" + nl);
        printStream.append("Type 'exit' to exit the sub menu and go back to the main menu. " + nl);
        printStream.append("Enter one of the options above or any DDR command " + nl);
        printStream.append("? ");
    }

    private void printUsage(PrintStream printStream) {
        printStream.append("USAGE: !walkinterntable <Sub Menu Option>" + nl);
        this.printMainOptions(printStream);
        printStream.append("6" + this.tab(1) + "To go into !walkinterntable sub menu" + nl);
    }

    private void printMainOptions(PrintStream printStream) {
        printStream.append("Walkinterntable Sub Menu Options :" + nl);
        printStream.append("1" + this.tab(1) + "To Print Shared Table Structural Info" + nl);
        printStream.append("2" + this.tab(1) + "To Print Local Table Structural Info" + nl);
        printStream.append("3" + this.tab(1) + "To Walk Shared Intern Table (From: Most recently used To: Least recently used)" + nl);
        printStream.append("4" + this.tab(1) + "To Walk Local Intern Table (From: Most recently used To: Least recently used)" + nl);
        printStream.append("5" + this.tab(1) + "To Walk Both Shared&Local Intern Table (From: Most recently used To; Least recently used)" + nl);
    }

    private String tab(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + tab;
        }
        return string;
    }

    private J9DbgStringInternTablePointer getRomClassBuilderPtr(PrintStream printStream) throws CorruptDataException {
        J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (j9JavaVMPointer.isNull()) {
            printStream.append("VM can not be found " + nl);
            return null;
        }
        J9TranslationBufferSetPointer j9TranslationBufferSetPointer = j9JavaVMPointer.dynamicLoadBuffers();
        if (j9TranslationBufferSetPointer.isNull()) {
            printStream.append("J9TranslationBufferSet can not be found " + nl);
            return null;
        }
        J9DbgROMClassBuilderPointer j9DbgROMClassBuilderPointer = J9DbgROMClassBuilderPointer.cast(j9TranslationBufferSetPointer.romClassBuilder());
        if (j9DbgROMClassBuilderPointer.isNull()) {
            printStream.append("romClassBuilderPtr can not be found " + nl);
            return null;
        }
        return j9DbgROMClassBuilderPointer.stringInternTable();
    }
}

