/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.types;

import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.I64;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.IScalar;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;

public class U32
extends UDATA {
    public static final int SIZEOF = 4;
    public static final long MASK = 0xFFFFFFFFL;
    public static final U32 MIN = new U32(0L);
    public static final U32 MAX = new U32(0xFFFFFFFFL);

    public U32(long l) {
        super(l & 0xFFFFFFFFL);
    }

    public U32(Scalar scalar) {
        super(scalar);
    }

    public U32 add(int n) {
        return new U32(this.data + (long)n);
    }

    @Override
    public U32 add(UScalar uScalar) {
        return this.add(new U32(uScalar));
    }

    public U32 add(I32 i32) {
        return new U32(this.data + i32.data);
    }

    public U32 add(U32 u32) {
        return new U32(this.data + u32.data);
    }

    @Override
    public U64 add(U64 u64) {
        return new U64(this).add(u64);
    }

    public boolean eq(U64 u64) {
        return new U64(this).eq(u64);
    }

    public UDATA add(UDATA uDATA) {
        return new UDATA(this).add(uDATA);
    }

    public boolean eq(UDATA uDATA) {
        return new UDATA(this).eq(uDATA);
    }

    @Override
    public U32 add(IScalar iScalar) {
        return this.add(new U32(iScalar));
    }

    @Override
    public boolean eq(IScalar iScalar) {
        return this.eq(new U32(iScalar));
    }

    public I64 add(I64 i64) {
        return new I64(this).add(i64);
    }

    public boolean eq(I64 i64) {
        return new I64(this).eq(i64);
    }

    public IDATA add(IDATA iDATA) {
        return new IDATA(this).add(iDATA);
    }

    public U32 sub(int n) {
        return new U32(this.data - (long)n);
    }

    @Override
    public U32 sub(UScalar uScalar) {
        return this.sub(new U32(uScalar));
    }

    public U32 sub(U32 u32) {
        return new U32(this.data - u32.data);
    }

    @Override
    public U64 sub(U64 u64) {
        return new U64(this).sub(u64);
    }

    public UDATA sub(UDATA uDATA) {
        return new UDATA(this).sub(uDATA);
    }

    public U32 sub(IScalar iScalar) {
        return this.sub(new U32(iScalar));
    }

    public I64 sub(I64 i64) {
        return new I64(this).sub(i64);
    }

    @Override
    public UDATA sub(IDATA iDATA) {
        return new UDATA(this).sub(iDATA);
    }

    @Override
    public int intValue() {
        long l = this.data;
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new InvalidDataTypeException("U32 contains value larger than Integer.MAX_VALUE");
        }
        return (int)l;
    }

    @Override
    public U32 bitOr(int n) {
        return new U32(this.data | (long)n);
    }

    @Override
    public U32 bitOr(long l) {
        return new U32(this.data | l);
    }

    @Override
    public U32 bitOr(UScalar uScalar) {
        return this.bitOr(new U32(uScalar));
    }

    public U32 bitOr(U32 u32) {
        return new U32(this.data | u32.data);
    }

    @Override
    public U64 bitOr(U64 u64) {
        return new U64(this).bitOr(u64);
    }

    public UDATA bitOr(UDATA uDATA) {
        return new UDATA(this).bitOr(uDATA);
    }

    public U32 bitOr(IScalar iScalar) {
        return this.bitOr(new U32(iScalar));
    }

    public I64 bitOr(I64 i64) {
        return new I64(this).bitOr(i64);
    }

    @Override
    public UDATA bitOr(IDATA iDATA) {
        return new UDATA(this).bitOr(iDATA);
    }

    @Override
    public U32 bitXor(int n) {
        return new U32(this.data ^ (long)n);
    }

    @Override
    public U32 bitXor(long l) {
        return new U32(this.data ^ l);
    }

    @Override
    public U32 bitXor(Scalar scalar) {
        return this.bitXor(new U32(scalar));
    }

    public U32 bitXor(U32 u32) {
        return new U32(this.data ^ u32.data);
    }

    @Override
    public UDATA bitXor(UDATA uDATA) {
        return new UDATA(this).bitXor(uDATA);
    }

    public IDATA bitXor(IDATA iDATA) {
        return new IDATA(this).bitXor(iDATA);
    }

    @Override
    public U64 bitXor(U64 u64) {
        return new U64(this).bitXor(u64);
    }

    @Override
    public I64 bitXor(I64 i64) {
        return new I64(this).bitXor(i64);
    }

    @Override
    public U32 bitAnd(int n) {
        return new U32(this.data & (long)n);
    }

    @Override
    public U32 bitAnd(long l) {
        return new U32(this.data & l);
    }

    @Override
    public U32 bitAnd(UScalar uScalar) {
        return this.bitAnd(new U32(uScalar));
    }

    public U32 bitAnd(U32 u32) {
        return new U32(this.data & u32.data);
    }

    @Override
    public U64 bitAnd(U64 u64) {
        return new U64(this).bitAnd(u64);
    }

    public UDATA bitAnd(UDATA uDATA) {
        return new UDATA(this).bitAnd(uDATA);
    }

    public U32 bitAnd(IScalar iScalar) {
        return this.bitAnd(new U32(iScalar));
    }

    public I64 bitAnd(I64 i64) {
        return new I64(this).bitAnd(i64);
    }

    @Override
    public UDATA bitAnd(IDATA iDATA) {
        return new UDATA(this).bitAnd(iDATA);
    }

    @Override
    public U32 leftShift(int n) {
        return new U32(this.data << n);
    }

    @Override
    public U32 rightShift(int n) {
        return new U32(this.data >>> n);
    }

    @Override
    public U32 bitNot() {
        return new U32(this.data ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public U32 mult(int n) {
        return new U32(this.data * (long)n);
    }

    public U32 mult(U32 u32) {
        return new U32(this.data * u32.data);
    }

    @Override
    public int sizeof() {
        return 4;
    }
}

