/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import com.ibm.jvm.trace.format.api.ByteStream;
import com.ibm.jvm.trace.format.api.Message;
import com.ibm.jvm.trace.format.api.MessageFile;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePoint;
import com.ibm.jvm.trace.format.api.TracePointDebugInfo;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteOrder;

public class TracePointImpl
implements TracePoint {
    TraceContext context;
    String componentName = null;
    String containerComponentName = null;
    int tracepointID = -1;
    private byte[] parameterData = null;
    TraceThread thread = null;
    int tracepointLength = -1;
    private String padding = null;
    private static String compNamePadding = "          ";
    private static String tpIDPadding = "    ";
    private boolean isNormalTracepoint = true;
    private boolean isInvalid = false;
    long lostRecordCount = 0L;
    private long newTimerUpperWord = 0L;
    long time_lowerWord;
    BigInteger time_merged = BigInteger.ZERO;
    private Message message;
    byte[] debugData;
    TracePointDebugInfo debugInfo;
    static final String[] internedNames = new String[]{"j9vm", "j9mm", "j9jit", "j9bcu", "j9jcl", "j9scar", "j9bcverify"};
    static final byte[][] internedNamesAsBytes = new byte[internedNames.length][];

    public TracePointImpl(TraceContext traceContext, ByteStream byteStream, TraceThread traceThread) {
        this.context = traceContext;
        this.thread = traceThread;
        this.parseDataIntoTracepoint(byteStream);
        this.padding = traceContext.getPointerSize() == 4 ? "            " : "                    ";
    }

    private TracePointImpl parseDataIntoTracepoint(ByteStream byteStream) {
        int n;
        int n2;
        int n3;
        int n4;
        this.tracepointLength = n4 = byteStream.get() & 0xFF;
        boolean bl = false;
        if (n4 == 0) {
            this.context.error(this, "found a 0 byte length tracepoint on thread " + this.thread);
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.context.debugLevel > 0 && this.tracepointLength != 4) {
            this.debugData = new byte[n4 - 1];
            byteStream.get(this.debugData);
            byteStream = this.context.createByteStream(this.debugData);
            if (this.context.debugStream != null && this.context.debugLevel >= 5) {
                for (int i = 0; i < this.debugData.length; ++i) {
                    this.context.debugStream.print(this.debugData[i] + ", ");
                }
                this.context.debugStream.println();
            }
            bl = true;
        }
        byte[] byArray = new byte[3];
        byteStream.get(byArray);
        if (this.tracepointLength == 4) {
            n3 = byteStream.get();
            if (byArray[1] == 0 && byArray[2] == 0) {
                this.tracepointLength = n4 = (n3 & 0xFF) << 8 | byArray[0] & 0xFF;
                if (this.context.debugLevel > 0) {
                    this.debugData = new byte[n4 - 1];
                    byteStream.get(this.debugData);
                    byteStream = this.context.createByteStream(this.debugData);
                    if (this.context.debugStream != null && this.context.debugLevel >= 5) {
                        for (int i = 0; i < this.debugData.length; ++i) {
                            this.context.debugStream.print(this.debugData[i] + ", ");
                        }
                        this.context.debugStream.println();
                    }
                    bl = true;
                }
                byteStream.get(byArray);
            } else {
                this.context.error(this, "found a 4 byte length tracepoint, but it's center bytes are not null");
                this.isInvalid = true;
                this.isNormalTracepoint = false;
                return null;
            }
        }
        this.tracepointID = byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] & 0xFF;
        this.tracepointID &= 0x3FFF;
        if (this.tracepointLength == 8) {
            if (byArray[0] == 0 && byArray[1] == 1 && byArray[2] == 0) {
                this.lostRecordCount = byteStream.getUnsignedInt();
                if (this.lostRecordCount == 0L) {
                    this.lostRecordCount = -1L;
                }
                this.isNormalTracepoint = false;
                return this;
            }
            if (this.tracepointID == 0) {
                long l;
                this.isNormalTracepoint = false;
                this.newTimerUpperWord = l = byteStream.getUnsignedInt();
                if (this.context.debugStream != null) {
                    this.context.debug(this, 4, "Sequence wrap found, value = 0x" + Long.toString(l, 16));
                }
                return this;
            }
            this.context.error(this, "Special tracepoint (length is 8 bytes) but not sequence wrap or lost record, id = [" + byArray[0] + "," + byArray[1] + "," + byArray[2] + "]");
            if (!bl) {
                byteStream.skip(4);
            }
            this.isInvalid = true;
            return this;
        }
        if (this.tracepointLength < 8) {
            this.context.warning(this, "TracePointImpl.parseDataIntoTracepoint() detected invalid tracepoint length " + this.tracepointLength + " on thread " + this.thread);
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        this.time_lowerWord = byteStream.getUnsignedInt();
        n3 = byteStream.getInt();
        if (n3 <= 0 || n3 > this.tracepointLength - 8) {
            this.context.warning(this, "TracePointImpl.parseDataIntoTracepoint() detected bad component name length: " + n3);
            if (!bl) {
                byteStream.skip(this.tracepointLength - 8);
            }
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        byte[] byArray2 = new byte[n3];
        byteStream.get(byArray2);
        this.componentName = this.componentIntern(byArray2, 0, n3);
        if (this.componentName == null || this.componentName.length() == 0) {
            this.context.warning(this, "TracePointImpl.parseDataIntoTracepoint() detected bad component name");
            if (!bl) {
                byteStream.skip(this.tracepointLength - 8);
            }
            this.isInvalid = true;
            this.isNormalTracepoint = false;
            return this;
        }
        if (this.componentName.equals("INTERNALTRACECOMPONENT")) {
            this.componentName = "dg";
        } else {
            this.tracepointID -= 257;
        }
        int n5 = this.componentName.indexOf("(");
        if (n5 >= 0) {
            String string;
            n2 = this.componentName.indexOf(")");
            if (n2 < 0 || n2 < n5) {
                this.context.debug(this, 3, "Overriding closeBracketIndex - not found in [" + this.componentName + "]");
                n2 = this.componentName.length();
            }
            this.containerComponentName = this.componentName.substring(n5 + 1, n2);
            this.componentName = string = this.componentName.substring(0, n5);
        }
        if ((n = this.tracepointLength - (n2 = 12 + n3)) > 0) {
            this.parameterData = new byte[n];
            byteStream.get(this.parameterData);
        }
        this.message = this.context.messageFile.getMessageFromID(this.componentName, this.tracepointID);
        for (int i = 0; this.message.getType() == 13 && i < this.context.auxiliaryMessageFiles.size(); ++i) {
            MessageFile messageFile = (MessageFile)this.context.auxiliaryMessageFiles.get(i);
            if (this.context.debugStream != null) {
                this.context.debug(this, 4, "Looking in auxiliary message file " + messageFile.toString() + " for tracepoint " + this.componentName + "." + this.tracepointID);
            }
            this.message = messageFile.getMessageFromID(this.componentName, this.tracepointID);
        }
        if (this.message.getType() == 13 && !this.componentName.equals("ApplicationTrace")) {
            if (n > 0) {
                byte[] byArray3 = new byte[n + 2];
                System.arraycopy(this.parameterData, 0, byArray3, 2, this.parameterData.length);
                this.parameterData = byArray3;
                short s = (short)n;
                if (byteStream.order() == ByteOrder.LITTLE_ENDIAN) {
                    this.parameterData[0] = (byte)(0xFF & s);
                    this.parameterData[1] = (byte)(0xFF00 & s);
                } else {
                    this.parameterData[0] = (byte)(0xFF00 & s);
                    this.parameterData[1] = (byte)(0xFF & s);
                }
            } else {
                this.message = new Message(13, "trace point not present in dat file", this.tracepointID, -1, this.componentName, "", this.context);
            }
        }
        if (this.message != null) {
            this.message.addStatistic("bytes", this.tracepointLength);
            this.message.addStatistic("count", 1L);
        }
        return this;
    }

    long getLostRecordCount() {
        return this.lostRecordCount;
    }

    private boolean internListCompare(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5 = internedNamesAsBytes[n2].length;
        if (n5 != n3) {
            return false;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            if (byArray[n + n4] == internedNamesAsBytes[n2][n4]) continue;
            return false;
        }
        return n4 == byArray.length;
    }

    private String componentIntern(byte[] byArray, int n, int n2) {
        String string;
        int n3 = internedNames.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.internListCompare(byArray, n, i, n2)) continue;
            return internedNames[i];
        }
        try {
            string = new String(byArray, n, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, n, n2);
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "0x" + Long.toString(this.thread.getThreadID(), 16);
        stringBuffer.append(this.padding.substring(string.length()));
        stringBuffer.append(string);
        if (this.componentName.length() < compNamePadding.length()) {
            stringBuffer.append(compNamePadding.substring(this.componentName.length()));
        }
        stringBuffer.append(" ");
        stringBuffer.append(this.componentName);
        if (this.containerComponentName != null) {
            stringBuffer.append("(" + this.containerComponentName + ")");
        }
        stringBuffer.append(".");
        stringBuffer.append(this.tracepointID);
        if (Integer.toString(this.tracepointID).length() < tpIDPadding.length()) {
            stringBuffer.append(tpIDPadding.substring(Integer.toString(this.tracepointID).length()));
        }
        return stringBuffer.toString();
    }

    public int getTPID() {
        return this.tracepointID;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getContainerComponentName() {
        return this.containerComponentName;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    public String getParameterDataFormatted() {
        Message message = this.message;
        byte[] byArray = this.getParmData();
        String string = null;
        if (byArray == null) {
            byArray = new byte[1];
            try {
                string = message.getMessage(byArray, 0, 0);
            }
            catch (Exception exception) {
                string = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA UNAVAILABLE";
            }
        } else {
            try {
                string = message.getMessage(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                string = "FORMATTING PROBLEM OCCURRED WHILE PROCESSING THE RAW DATA FOR THIS TRACEPOINT - PARAMETER DATA MISMATCH";
            }
        }
        return string;
    }

    public byte[] getParmData() {
        return this.parameterData;
    }

    @Override
    public BigInteger getRawTime() {
        return this.time_merged;
    }

    public long getNewTimerUpperWord() {
        return this.newTimerUpperWord;
    }

    public boolean isNormalTracepoint() {
        return this.isNormalTracepoint;
    }

    @Override
    public String getFormattedParameters() {
        return this.getParameterDataFormatted();
    }

    @Override
    public String getFormattedTime() {
        return this.context.getFormattedTime(this.getRawTime());
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public int getTypeAsInt() {
        return this.message.getType();
    }

    @Override
    public int getID() {
        return this.getTPID();
    }

    @Override
    public long getTimestampMillis() {
        return 0L;
    }

    @Override
    public int getMicrosecondsCount() {
        return 0;
    }

    @Override
    public String getComponent() {
        return this.getComponentName();
    }

    @Override
    public String getContainerComponent() {
        return this.getContainerComponentName();
    }

    @Override
    public String getParameterFormattingTemplate() {
        return this.message.getFormattingTemplate();
    }

    @Override
    public Object[] getParameters() {
        try {
            return this.message.parseMessage(this.getParmData(), 0);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = new RuntimeException("Tracepoint: " + this.componentName + "." + this.tracepointID + ", template: " + this.getParameterFormattingTemplate(), runtimeException);
            runtimeException2.setStackTrace(runtimeException.getStackTrace());
            throw runtimeException2;
        }
    }

    @Override
    public String[] getGroups() {
        return null;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    @Override
    public String getType() {
        int n = this.message.getType();
        return TracePoint.types[n];
    }

    public String getDebugInfo() {
        if (this.debugInfo != null) {
            return "Record: " + this.debugInfo.record + ", offset: " + this.debugInfo.offset;
        }
        return "";
    }

    static {
        for (String string : internedNames) {
            int n = string.length();
            TracePointImpl.internedNamesAsBytes[var1_1] = new byte[n];
            for (int i = 0; i < n; ++i) {
                TracePointImpl.internedNamesAsBytes[var1_1][i] = (byte)string.charAt(i);
            }
        }
    }
}

