/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Properties;

public class JCImagePointer
implements ImagePointer {
    private final long fUnderlyingAddress;
    private final JCImageAddressSpace fResidentDomain;
    private static final String MEMORY_READ_ERROR = "Can't read into ImageAddressSpace yet";

    public JCImagePointer(JCImageAddressSpace jCImageAddressSpace, long l) throws JCInvalidArgumentsException {
        if (jCImageAddressSpace == null) {
            throw new JCInvalidArgumentsException("An image pointer must have an associated address space");
        }
        if (!jCImageAddressSpace.isValidAddressID(l)) {
            throw new JCInvalidArgumentsException("Invalid address 0x" + Long.toHexString(l));
        }
        this.fUnderlyingAddress = l;
        this.fResidentDomain = jCImageAddressSpace;
    }

    @Override
    public ImagePointer add(long l) {
        return this.fResidentDomain.getPointer(this.fUnderlyingAddress + l);
    }

    @Override
    public long getAddress() {
        return this.fUnderlyingAddress;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this.fResidentDomain;
    }

    @Override
    public ImagePointer getPointerAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public short getShortAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public boolean isExecutable() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public boolean isReadOnly() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public boolean isShared() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public byte getByteAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public double getDoubleAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public float getFloatAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public int getIntAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public long getLongAt(long l) throws MemoryAccessException, CorruptDataException {
        throw new MemoryAccessException(this.fResidentDomain.getPointer(l + this.fUnderlyingAddress), MEMORY_READ_ERROR);
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.fResidentDomain == null ? 0 : this.fResidentDomain.hashCode());
        n = 31 * n + (int)(this.fUnderlyingAddress ^ this.fUnderlyingAddress >>> 32);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        JCImagePointer jCImagePointer = (JCImagePointer)object;
        if (this.fResidentDomain == null ? jCImagePointer.fResidentDomain != null : !this.fResidentDomain.equals(jCImagePointer.fResidentDomain)) {
            return false;
        }
        return this.fUnderlyingAddress == jCImagePointer.fUnderlyingAddress;
    }
}

