/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.phd.PHDImageAddressSpace;
import com.ibm.dtfj.phd.PHDImageFactory;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.utils.ManagedImage;
import com.ibm.dtfj.utils.file.ManagedImageSource;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

public class PHDImage
implements ManagedImage {
    private final File file;
    private final ArrayList<ImageAddressSpace> addressList;
    private final Image meta;
    private final List<HeapdumpReader> closeList = new LinkedList<HeapdumpReader>();
    private final URI source;
    private ManagedImageSource imageSource = null;

    PHDImage(File file) throws IOException {
        this(file, null);
    }

    PHDImage(File file, Image image) throws IOException {
        this.file = file;
        this.meta = image;
        this.source = null;
        try {
            Object e;
            Object object;
            ImageAddressSpace imageAddressSpace = null;
            if (image != null && (object = image.getAddressSpaces()).hasNext() && !((e = object.next()) instanceof CorruptData)) {
                imageAddressSpace = (ImageAddressSpace)e;
            }
            object = new PHDImageAddressSpace(file, this, imageAddressSpace);
            this.addressList = new ArrayList();
            this.addressList.add((ImageAddressSpace)object);
        }
        catch (Error error) {
            if (error.getClass() == Error.class) {
                IOException iOException = new IOException(MessageFormat.format("Problem opening dump {0} metafile {1}", file, image));
                iOException.initCause(error);
                throw iOException;
            }
            throw error;
        }
    }

    PHDImage(URI uRI, ImageInputStream imageInputStream) throws IOException {
        this(uRI, imageInputStream, null);
    }

    PHDImage(URI uRI, ImageInputStream imageInputStream, Image image) throws IOException {
        this.source = uRI;
        this.file = null;
        this.meta = image;
        try {
            Object e;
            Object object;
            ImageAddressSpace imageAddressSpace = null;
            if (image != null && (object = image.getAddressSpaces()).hasNext() && !((e = object.next()) instanceof CorruptData)) {
                imageAddressSpace = (ImageAddressSpace)e;
            }
            object = new PHDImageAddressSpace(imageInputStream, this, imageAddressSpace);
            this.addressList = new ArrayList();
            this.addressList.add((ImageAddressSpace)object);
        }
        catch (Error error) {
            if (error.getClass() == Error.class) {
                IOException iOException = new IOException(MessageFormat.format("Problem opening dump {0} metafile {1}", this.file, image));
                iOException.initCause(error);
                throw iOException;
            }
            throw error;
        }
    }

    @Override
    public URI getSource() {
        if (this.source == null) {
            return this.file.toURI();
        }
        return this.source;
    }

    @Override
    public Iterator<ImageAddressSpace> getAddressSpaces() {
        return this.addressList.iterator();
    }

    @Override
    public long getCreationTime() throws DataUnavailable {
        String[] stringArray;
        if (this.file == null) {
            throw new DataUnavailable("File creation time not available.");
        }
        String string = this.file.getName();
        String string2 = "heapdump";
        int n = Math.max(0, string.indexOf(string2));
        if ((string = string.substring(n)).startsWith(string2)) {
            stringArray = "yyyyMMdd.HHmmss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)stringArray);
            ParsePosition parsePosition = new ParsePosition(0);
            for (int i = string2.length(); i < string.length(); ++i) {
                parsePosition.setIndex(i);
                Date date = simpleDateFormat.parse(string, parsePosition);
                if (date == null || date.before(PHDImageFactory.earliestDump) || !date.before(PHDImageFactory.latestDump)) continue;
                return date.getTime();
            }
        }
        stringArray = string.split("\\.");
        string2 = "heapdump";
        if ((stringArray.length == 3 || stringArray.length == 4 && stringArray[3].equals("gz")) && stringArray[0].startsWith(string2)) {
            try {
                Integer.parseInt(stringArray[0].substring(string2.length()));
                long l = Long.parseLong(stringArray[1]);
                Date date = new Date(l * 1000L);
                if (!date.before(PHDImageFactory.earliestDump) && date.before(PHDImageFactory.latestDump)) {
                    return date.getTime();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            if (this.meta != null) {
                return this.meta.getCreationTime();
            }
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        return this.file.lastModified();
    }

    @Override
    public String getHostName() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getHostName();
        }
        throw new DataUnavailable();
    }

    @Override
    public Iterator<InetAddress> getIPAddresses() throws DataUnavailable {
        throw new DataUnavailable();
    }

    @Override
    public long getInstalledMemory() throws DataUnavailable {
        if (this.meta != null) {
            return this.meta.getInstalledMemory();
        }
        throw new DataUnavailable();
    }

    @Override
    public int getProcessorCount() throws DataUnavailable {
        if (this.meta != null) {
            return this.meta.getProcessorCount();
        }
        throw new DataUnavailable();
    }

    @Override
    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getProcessorSubType();
        }
        throw new DataUnavailable();
    }

    @Override
    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getProcessorType();
        }
        throw new DataUnavailable();
    }

    @Override
    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getSystemSubType();
        }
        throw new DataUnavailable();
    }

    @Override
    public String getSystemType() throws DataUnavailable, CorruptDataException {
        if (this.meta != null) {
            return this.meta.getSystemType();
        }
        throw new DataUnavailable();
    }

    @Override
    public void close() {
        if (this.addressList != null) {
            this.addressList.clear();
        }
        if (this.meta != null) {
            this.meta.close();
        }
        for (HeapdumpReader heapdumpReader : this.closeList.toArray(new HeapdumpReader[0])) {
            if (heapdumpReader == null) continue;
            heapdumpReader.releaseResources();
        }
        if (this.imageSource != null && this.imageSource.getExtractedTo() != null) {
            this.imageSource.getExtractedTo().delete();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void registerReader(HeapdumpReader heapdumpReader) {
        this.closeList.add(heapdumpReader);
    }

    public void unregisterReader(HeapdumpReader heapdumpReader) {
        this.closeList.remove(heapdumpReader);
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }

    @Override
    public ManagedImageSource getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(ManagedImageSource managedImageSource) {
        this.imageSource = managedImageSource;
    }

    @Override
    public long getCreationTimeNanos() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable();
    }
}

