/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.phd.PHDCorruptImageSection;
import com.ibm.dtfj.phd.PHDCorruptJavaObject;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.phd.PHDJavaObject;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import com.ibm.dtfj.phd.parser.HeapdumpReader;
import com.ibm.dtfj.phd.parser.PortableHeapDumpListener;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.stream.ImageInputStream;

class PHDJavaHeap
implements JavaHeap {
    private static final boolean LOG = false;
    private final ImageAddressSpace space;
    protected final PHDJavaRuntime runtime;
    private final PHDImage image;
    private final File file;
    private final ImageInputStream stream;
    private final boolean isJ9V4;
    private final int STEP = (int)Math.min(10000000L, Runtime.getRuntime().maxMemory() / 32L);
    private final LinkedHashMap<Integer, CacheHeapSegment> cache = new LinkedHashMap();
    private final CachedReader readerCache;
    private boolean doneScan;
    private boolean lastSegment;
    private static final long[] NOREFS = new long[0];

    PHDJavaHeap(ImageInputStream imageInputStream, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime) throws IOException {
        this.image = pHDImage;
        this.space = imageAddressSpace;
        this.runtime = pHDJavaRuntime;
        HeapdumpReader heapdumpReader = new HeapdumpReader(imageInputStream, pHDImage);
        this.isJ9V4 = heapdumpReader.version() == 4 && heapdumpReader.isJ9();
        heapdumpReader.close();
        this.readerCache = new CachedReader(imageInputStream, pHDImage);
        this.stream = imageInputStream;
        this.file = null;
    }

    PHDJavaHeap(File file, PHDImage pHDImage, ImageAddressSpace imageAddressSpace, PHDJavaRuntime pHDJavaRuntime) throws IOException {
        this.file = file;
        this.image = pHDImage;
        this.space = imageAddressSpace;
        this.runtime = pHDJavaRuntime;
        HeapdumpReader heapdumpReader = new HeapdumpReader(file, pHDImage);
        this.isJ9V4 = heapdumpReader.version() == 4 && heapdumpReader.isJ9();
        heapdumpReader.close();
        this.readerCache = new CachedReader(file, pHDImage);
        this.stream = null;
    }

    @Override
    public String getName() {
        return "Java heap";
    }

    private Iterator<JavaObject> getObjects0() {
        try {
            return new Iterator<JavaObject>(){
                int[] count = new int[1];
                int prev;
                Iterator<JavaObject> it = PHDJavaHeap.this.getObjectsViaCache(PHDJavaHeap.access$000(PHDJavaHeap.this), this.count, false).values().iterator();

                @Override
                public boolean hasNext() {
                    if (this.it == null) {
                        return false;
                    }
                    if (this.it.hasNext()) {
                        return true;
                    }
                    boolean bl = PHDJavaHeap.this.withRefs(this.prev);
                    this.prev = this.count[0];
                    try {
                        this.it = PHDJavaHeap.this.getObjectsViaCache(PHDJavaHeap.this.STEP, this.count, bl).values().iterator();
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                    if (this.it.hasNext()) {
                        return true;
                    }
                    this.it = null;
                    return false;
                }

                @Override
                public JavaObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (IOException iOException) {
            return new ArrayList().iterator();
        }
    }

    private boolean withRefs(int n) {
        CacheHeapSegment cacheHeapSegment = this.cache.get(n);
        return cacheHeapSegment != null && cacheHeapSegment.withRefs;
    }

    Map<AddressKey, JavaObject> getObjectsViaCache(int n, int[] nArray, boolean bl) throws IOException {
        Map<AddressKey, JavaObject> map;
        SoftReference<Map<AddressKey, JavaObject>> softReference;
        int n2 = nArray[0];
        CacheHeapSegment cacheHeapSegment = this.cache.get(nArray[0]);
        if (cacheHeapSegment == null || (softReference = cacheHeapSegment.objects) == null || (map = softReference.get()) == null || bl && !cacheHeapSegment.withRefs) {
            map = this.getObjects(n, nArray, bl);
            if (cacheHeapSegment == null || n != cacheHeapSegment.maxSize || nArray[0] != cacheHeapSegment.nextIndex || bl != cacheHeapSegment.withRefs) {
                cacheHeapSegment = new CacheHeapSegment(n2, n, nArray[0], map, bl);
                this.cache.put(n2, cacheHeapSegment);
            } else {
                cacheHeapSegment.objects = softReference = new SoftReference<Map<AddressKey, JavaObject>>(map);
            }
        } else {
            nArray[0] = cacheHeapSegment.nextIndex;
        }
        if (map.size() == 0) {
            this.lastSegment = true;
        }
        if (this.lastSegment && !this.doneScan) {
            CacheHeapSegment cacheHeapSegment2 = this.cache.get(0);
            while (cacheHeapSegment2 != null) {
                if (cacheHeapSegment2.nextIndex == cacheHeapSegment2.index) {
                    this.doneScan = true;
                    break;
                }
                cacheHeapSegment2 = this.cache.get(cacheHeapSegment2.nextIndex);
            }
        }
        return map;
    }

    Map<AddressKey, JavaObject> getObjects(final int n, final int[] nArray, final boolean bl) throws IOException {
        boolean bl2;
        final LinkedHashMap<AddressKey, JavaObject> linkedHashMap = new LinkedHashMap<AddressKey, JavaObject>();
        final PHDJavaHeap pHDJavaHeap = this;
        final CachedReader.ReaderPos readerPos = this.readerCache.getReader(nArray[0]);
        final int n2 = readerPos.reader.version() == 4 && readerPos.reader.isJ9() ? 1 : 0;
        final long[] lArray = new long[1];
        try {
            bl2 = readerPos.reader.parse(new PortableHeapDumpListener(){
                int total;

                @Override
                public void classDump(long l, long l2, String string, int n4, int n22, int n3, LongEnumeration longEnumeration) throws Exception {
                }

                @Override
                public void objectArrayDump(long l, long l2, int n7, int n22, LongEnumeration longEnumeration, int n3, long l3) throws Exception {
                    lArray[0] = l;
                    if (readerPos.where++ >= nArray[0]) {
                        int n4 = 10 + longEnumeration.numberOfElements() / 1;
                        this.total += n4;
                        if (this.total == n4 || this.total < n) {
                            int n5 = longEnumeration.numberOfElements();
                            int n6 = Math.min(n2, n5);
                            PHDJavaObject.Builder builder = new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.arrayOf(l2, longEnumeration, n2), n7, n22);
                            PHDJavaObject pHDJavaObject = bl ? builder.refs(longEnumeration, n6).length(n3 - n6).instanceSize(l3).build() : builder.length(n3 - n6).instanceSize(l3).build();
                            linkedHashMap.put(AddressKey.getAddress(PHDJavaHeap.this, l), pHDJavaObject);
                            nArray[0] = readerPos.where;
                        }
                        if (this.total >= n) {
                            readerPos.reader.exitParse();
                        }
                    }
                    lArray[0] = 0L;
                }

                @Override
                public void objectDump(long l, long l2, int n4, int n22, LongEnumeration longEnumeration, long l3) throws Exception {
                    lArray[0] = l;
                    if (readerPos.where++ >= nArray[0]) {
                        int n3 = 10 + longEnumeration.numberOfElements() / 1;
                        this.total += n3;
                        if (this.total == n3 || this.total < n) {
                            PHDJavaObject.Builder builder = new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.findClass(l2), n4, n22).length(-1).instanceSize(l3);
                            PHDJavaObject pHDJavaObject = bl ? builder.refs(longEnumeration, 0).build() : builder.build();
                            linkedHashMap.put(AddressKey.getAddress(PHDJavaHeap.this, l), pHDJavaObject);
                            nArray[0] = readerPos.where;
                        }
                        if (this.total >= n) {
                            readerPos.reader.exitParse();
                        }
                    }
                    lArray[0] = 0L;
                }

                @Override
                public void primitiveArrayDump(long l, int n6, int n22, int n3, int n4, long l2) throws Exception {
                    lArray[0] = l;
                    if (readerPos.where++ >= nArray[0]) {
                        int n5 = 10;
                        this.total += n5;
                        if (this.total == n5 || this.total < n) {
                            linkedHashMap.put(AddressKey.getAddress(PHDJavaHeap.this, l), new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.findArrayOfType(n6), n3, n4).refsAsArray(NOREFS, 0).length(n22).instanceSize(l2).build());
                            nArray[0] = readerPos.where;
                        }
                        if (this.total >= n) {
                            readerPos.reader.exitParse();
                        }
                    }
                    lArray[0] = 0L;
                }
            });
        }
        catch (Exception exception) {
            if (nArray[0] == 0 || lArray[0] != 0L || linkedHashMap.size() > 0) {
                linkedHashMap.put(AddressKey.getAddress(this, lArray[0]), new PHDCorruptJavaObject("building object", this.space.getPointer(lArray[0]), exception));
                nArray[0] = nArray[0] + 1;
                bl2 = true;
            }
            bl2 = false;
        }
        if (bl2) {
            this.readerCache.returnReader(readerPos);
        }
        return linkedHashMap;
    }

    @Override
    public Iterator<ImageSection> getSections() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        long l = this.runtime.maxAddress;
        if (this.runtime.minAddress <= this.runtime.maxAddress) {
            ImagePointer imagePointer = this.space.getPointer(l);
            JavaObject javaObject = null;
            try {
                javaObject = this.getLastObject(imagePointer, this.runtime.maxObjClass, this.runtime.maxObjLen);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (javaObject != null) {
                    l += javaObject.getSize();
                }
                object = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minAddress), l - this.runtime.minAddress);
                arrayList.add(object);
            }
            catch (CorruptDataException corruptDataException) {
                PHDImageSection pHDImageSection = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minAddress), l - this.runtime.minAddress);
                arrayList.add(pHDImageSection);
                pHDImageSection = new PHDCorruptImageSection("Corrupt " + this.getName(), imagePointer, 8L);
                arrayList.add(pHDImageSection);
            }
        }
        if (this.runtime.minClassAddress <= this.runtime.maxClassAddress) {
            PHDImageSection pHDImageSection;
            long l2 = this.runtime.maxClassAddress;
            object = this.space.getPointer(l2);
            int n = arrayList.size();
            try {
                JavaObject javaObject;
                JavaClass javaClass = this.runtime.findClass(l2);
                long l3 = 8L;
                if (javaClass != null && (javaObject = javaClass.getObject()) != null && javaObject.getID().equals(javaClass.getID())) {
                    l3 = javaObject.getSize();
                }
                l2 += l3;
            }
            catch (CorruptDataException corruptDataException) {
                pHDImageSection = new PHDCorruptImageSection("Corrupt " + this.getName(), (ImagePointer)object, 8L);
                arrayList.add(pHDImageSection);
            }
            if (l2 < this.runtime.minAddress || l < this.runtime.minClassAddress) {
                pHDImageSection = new PHDImageSection(this.getName(), this.space.getPointer(this.runtime.minClassAddress), l2 - this.runtime.minClassAddress);
                arrayList.add(n, pHDImageSection);
            } else {
                long l4 = Math.min(this.runtime.minAddress, this.runtime.minClassAddress);
                long l5 = Math.max(l, l2);
                pHDImageSection = new PHDImageSection(this.getName(), this.space.getPointer(l4), l5 - l4);
                arrayList.set(0, pHDImageSection);
            }
        }
        return arrayList.iterator();
    }

    ImageAddressSpace getImageAddressSpace() {
        return this.space;
    }

    PHDJavaRuntime getJavaRuntime() {
        return this.runtime;
    }

    JavaObject getCachedObjectAtAddress(ImagePointer imagePointer, boolean bl) throws IOException {
        for (CacheHeapSegment cacheHeapSegment : this.cache.values()) {
            JavaObject javaObject;
            long l;
            SoftReference<Map<AddressKey, JavaObject>> softReference = cacheHeapSegment.objects;
            Map<AddressKey, JavaObject> map = softReference.get();
            if ((map == null || bl && !cacheHeapSegment.withRefs && map.get(AddressKey.getAddress(this, imagePointer.getAddress())) != null) && cacheHeapSegment.minAddress <= (l = imagePointer.getAddress()) && l <= cacheHeapSegment.maxAddress) {
                int[] nArray = new int[]{cacheHeapSegment.index};
                map = this.getObjects(cacheHeapSegment.maxSize, nArray, bl);
                cacheHeapSegment.withRefs = bl;
                cacheHeapSegment.objects = softReference = new SoftReference<Map<AddressKey, JavaObject>>(map);
            }
            if (map == null || (javaObject = map.get(AddressKey.getAddress(this, imagePointer.getAddress()))) == null) continue;
            return javaObject;
        }
        return null;
    }

    JavaObject getObjectAtAddress(ImagePointer imagePointer, boolean bl) {
        JavaObject javaObject = null;
        try {
            javaObject = this.getCachedObjectAtAddress(imagePointer, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (javaObject != null) {
            return javaObject;
        }
        if (!this.doneScan) {
            try {
                javaObject = this.getObjectAtAddress3(imagePointer, bl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return javaObject;
    }

    private JavaObject getObjectAtAddress3(ImagePointer imagePointer, boolean bl) throws IOException {
        Map<AddressKey, JavaObject> map;
        int[] nArray = new int[1];
        while (!(map = this.getObjectsViaCache(this.STEP, nArray, bl)).isEmpty()) {
            JavaObject javaObject = map.get(AddressKey.getAddress(this, imagePointer.getAddress()));
            if (javaObject == null) continue;
            return javaObject;
        }
        return null;
    }

    JavaObject getLastObject(ImagePointer imagePointer, long l, int n) throws IOException {
        JavaObject javaObject = this.getCachedObjectAtAddress(imagePointer, false);
        if (javaObject != null) {
            return javaObject;
        }
        long l2 = imagePointer.getAddress();
        if (l < 8L) {
            JavaClass javaClass = this.runtime.findArrayOfType((int)l);
            javaObject = new PHDJavaObject.Builder(this, l2, javaClass, 4, -1).length(n).refsAsArray(NOREFS, 0).build();
        } else if (n >= 0) {
            if (this.isJ9V4) {
                --n;
            }
            JavaClass javaClass = this.runtime.findArrayOfClass(l);
            javaObject = new PHDJavaObject.Builder(this, l2, javaClass, 4, -1).length(n).build();
        } else {
            JavaClass javaClass = this.runtime.findClass(l);
            javaObject = new PHDJavaObject.Builder(this, l2, javaClass, 4, -1).length(-1).build();
        }
        return javaObject;
    }

    @Override
    public Iterator<JavaObject> getObjects() {
        final PHDJavaHeap pHDJavaHeap = this;
        try {
            return new Iterator<JavaObject>(){
                HeapdumpReader reader = PHDJavaHeap.access$500(PHDJavaHeap.this) == null ? new HeapdumpReader(PHDJavaHeap.access$600(PHDJavaHeap.this), PHDJavaHeap.access$700(PHDJavaHeap.this)) : new HeapdumpReader(PHDJavaHeap.access$500(PHDJavaHeap.this), PHDJavaHeap.access$700(PHDJavaHeap.this));
                final int adjustLen = this.reader.version() == 4 && this.reader.isJ9() ? 1 : 0;
                final long[] current = new long[1];
                static final boolean withRefs = true;
                JavaObject jo;
                int count = 0;
                PortableHeapDumpListener listen = new PortableHeapDumpListener(){

                    @Override
                    public void classDump(long l, long l2, String string, int n, int n2, int n3, LongEnumeration longEnumeration) throws Exception {
                    }

                    @Override
                    public void objectArrayDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, int n3, long l3) throws Exception {
                        current[0] = l;
                        int n4 = longEnumeration.numberOfElements();
                        int n5 = Math.min(adjustLen, n4);
                        PHDJavaObject.Builder builder = new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.arrayOf(l2, longEnumeration, adjustLen), n, n2).instanceSize(l3);
                        jo = builder.refs(longEnumeration, n5).length(n3 - n5).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }

                    @Override
                    public void objectDump(long l, long l2, int n, int n2, LongEnumeration longEnumeration, long l3) throws Exception {
                        current[0] = l;
                        PHDJavaObject.Builder builder = new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.findClass(l2), n, n2).length(-1).instanceSize(l3);
                        jo = builder.refs(longEnumeration, 0).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }

                    @Override
                    public void primitiveArrayDump(long l, int n, int n2, int n3, int n4, long l2) throws Exception {
                        current[0] = l;
                        jo = new PHDJavaObject.Builder(pHDJavaHeap, l, PHDJavaHeap.this.runtime.findArrayOfType(n), n3, n4).refsAsArray(NOREFS, 0).length(n2).instanceSize(l2).build();
                        current[0] = 0L;
                        reader.exitParse();
                    }
                };

                @Override
                public boolean hasNext() {
                    if (this.jo == null) {
                        this.getNext();
                    }
                    return this.jo != null;
                }

                @Override
                public JavaObject next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    JavaObject javaObject = this.jo;
                    this.jo = null;
                    ++this.count;
                    return javaObject;
                }

                private void getNext() {
                    try {
                        if (this.reader != null && !this.reader.parse(this.listen)) {
                            this.reader.close();
                            this.reader = null;
                        }
                    }
                    catch (EOFException eOFException) {
                        this.jo = new PHDCorruptJavaObject("Truncated dump found while building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), eOFException);
                        this.reader.close();
                        this.reader = null;
                    }
                    catch (IOException iOException) {
                        this.jo = new PHDCorruptJavaObject("Corrupted dump found while building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), iOException);
                        this.reader.close();
                        this.reader = null;
                    }
                    catch (Exception exception) {
                        if (this.current[0] != 0L) {
                            this.jo = new PHDCorruptJavaObject("Building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(this.current[0]), exception);
                        }
                        this.jo = new PHDCorruptJavaObject("Building object " + this.count + "/" + this.reader.totalObjects(), PHDJavaHeap.this.space.getPointer(0L), exception);
                        this.reader.close();
                        this.reader = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                protected void finalize() throws Throwable {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
            };
        }
        catch (IOException iOException) {
            return new ArrayList().iterator();
        }
    }

    static /* synthetic */ ImageInputStream access$500(PHDJavaHeap pHDJavaHeap) {
        return pHDJavaHeap.stream;
    }

    static /* synthetic */ File access$600(PHDJavaHeap pHDJavaHeap) {
        return pHDJavaHeap.file;
    }

    static /* synthetic */ PHDImage access$700(PHDJavaHeap pHDJavaHeap) {
        return pHDJavaHeap.image;
    }

    static class CachedReader {
        File file;
        ImageInputStream stream;
        final PHDImage parentImage;
        List<ReaderPos> readers = new ArrayList<ReaderPos>();

        CachedReader(File file, PHDImage pHDImage) {
            this.file = file;
            this.parentImage = pHDImage;
        }

        CachedReader(ImageInputStream imageInputStream, PHDImage pHDImage) {
            this.stream = imageInputStream;
            this.parentImage = pHDImage;
        }

        ReaderPos getReader(int n) throws IOException {
            ReaderPos readerPos = null;
            for (ReaderPos readerPos2 : this.readers) {
                if (readerPos2.where > n || readerPos != null && readerPos.where >= readerPos2.where) continue;
                readerPos = readerPos2;
            }
            if (readerPos == null) {
                readerPos = new ReaderPos(this.parentImage);
            } else {
                this.readers.remove(readerPos);
            }
            return readerPos;
        }

        void returnReader(ReaderPos readerPos) {
            this.readers.add(readerPos);
        }

        class ReaderPos {
            int where;
            HeapdumpReader reader;

            ReaderPos(PHDImage pHDImage) throws IOException {
                this.reader = CachedReader.this.stream == null ? new HeapdumpReader(CachedReader.this.file, pHDImage) : new HeapdumpReader(CachedReader.this.stream, pHDImage);
                this.where = 0;
            }
        }
    }

    static class CacheHeapSegment {
        final int index;
        final int maxSize;
        final int nextIndex;
        SoftReference<Map<AddressKey, JavaObject>> objects;
        boolean withRefs;
        final long minAddress;
        final long maxAddress;

        CacheHeapSegment(int n, int n2, int n3, Map<AddressKey, JavaObject> map, boolean bl) {
            this.objects = new SoftReference<Map<AddressKey, JavaObject>>(map);
            long l = Long.MIN_VALUE;
            long l2 = Long.MAX_VALUE;
            for (JavaObject javaObject : map.values()) {
                if (javaObject instanceof CorruptData) continue;
                long l3 = javaObject.getID().getAddress();
                l = Math.max(l, l3);
                l2 = Math.min(l2, l3);
            }
            this.index = n;
            this.maxSize = n2;
            this.nextIndex = n3;
            this.maxAddress = l;
            this.minAddress = l2;
            this.withRefs = bl;
        }
    }

    private static final class LongAddressKey
    extends AddressKey {
        final long val;

        private LongAddressKey(long l) {
            this.val = l;
        }

        @Override
        long value(PHDJavaHeap pHDJavaHeap) {
            return this.val;
        }

        public int hashCode() {
            return (int)this.val ^ (int)(this.val >>> 32);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof LongAddressKey && this.val == ((LongAddressKey)object).val;
        }
    }

    private static final class IntAddressKey
    extends AddressKey {
        final int val;

        private IntAddressKey(int n) {
            this.val = n;
        }

        @Override
        long value(PHDJavaHeap pHDJavaHeap) {
            return pHDJavaHeap.runtime.expandAddress(this.val);
        }

        public int hashCode() {
            return this.val;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof IntAddressKey && this.val == ((IntAddressKey)object).val;
        }
    }

    static abstract class AddressKey {
        AddressKey() {
        }

        abstract long value(PHDJavaHeap var1);

        static AddressKey getAddress(PHDJavaHeap pHDJavaHeap, long l) {
            if (pHDJavaHeap.runtime.noCompress()) {
                throw new IllegalStateException("Unable to compress addresses");
            }
            int n = pHDJavaHeap.runtime.compressAddress(l);
            long l2 = pHDJavaHeap.runtime.expandAddress(n);
            if (l == l2) {
                return new IntAddressKey(n);
            }
            return new LongAddressKey(l);
        }
    }
}

