/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.utils.file;

import com.ibm.dtfj.utils.file.ManagedImageSource;
import com.ibm.dtfj.utils.file.SimpleFileManager;
import com.ibm.dtfj.utils.file.UnzipFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public abstract class CompressedFileManager
extends SimpleFileManager {
    protected final byte[] buffer = new byte[4096];

    public CompressedFileManager(File file) {
        super(file);
    }

    public abstract void extract(File var1) throws IOException;

    public abstract void extract(ManagedImageSource var1, File var2) throws IOException;

    public abstract ImageInputStream getStream(ManagedImageSource var1) throws IOException;

    protected void checkDirectoryToExtractTo(File file) {
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("The specified directory " + file.getAbsolutePath() + " is not a directory ");
            }
        } else {
            file.mkdirs();
        }
    }

    public ManagedImageSource getImageSource(String string) throws IOException {
        List<ManagedImageSource> list = this.getImageSources();
        if (list.contains(string)) {
            ManagedImageSource managedImageSource = list.get(list.indexOf(string));
            return managedImageSource;
        }
        throw new FileNotFoundException("The entry " + string + " was not found in " + this.managedFile.getAbsolutePath());
    }

    protected void extractEntry(InputStream inputStream, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        long l = 0L;
        try {
            logger.fine("Extracting " + file.getName() + " to " + file.getAbsolutePath());
            fileOutputStream = new FileOutputStream(file);
            int n = -1;
            while ((n = inputStream.read(this.buffer)) != -1) {
                l += (long)n;
                fileOutputStream.write(this.buffer, 0, n);
            }
        }
        catch (IOException iOException) {
            fileOutputStream.close();
            file.delete();
            throw new UnzipFailedException("Error occured when extracting " + file.getName() + " from archive to " + file.getAbsolutePath() + " : " + iOException.getMessage());
        }
        finally {
            logger.fine("Extracted " + l + " bytes");
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

