/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.ETypeInfo;
import sun.security.krb5.internal.ETypeInfo2;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAData {
    private int pADataType;
    private byte[] pADataValue = null;
    private static final byte TAG_PATYPE = 1;
    private static final byte TAG_PAVALUE = 2;

    private PAData() {
    }

    public PAData(int n, byte[] byArray) {
        this.pADataType = n;
        if (byArray != null) {
            this.pADataValue = (byte[])byArray.clone();
        }
    }

    public Object clone() {
        PAData pAData = new PAData();
        pAData.pADataType = this.pADataType;
        if (this.pADataValue != null) {
            pAData.pADataValue = new byte[this.pADataValue.length];
            System.arraycopy((Object)this.pADataValue, 0, (Object)pAData.pADataValue, 0, this.pADataValue.length);
        }
        return pAData;
    }

    public PAData(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.pADataType = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) == 2) {
            this.pADataValue = derValue2.getData().getOctetString();
        }
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.pADataType);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.pADataValue);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public int getType() {
        return this.pADataType;
    }

    public byte[] getValue() {
        return this.pADataValue == null ? null : (byte[])this.pADataValue.clone();
    }

    public static int getPreferredEType(PAData[] pADataArray, int n) throws IOException, Asn1Exception {
        if (pADataArray == null) {
            return n;
        }
        DerValue derValue = null;
        DerValue derValue2 = null;
        block4: for (PAData pAData : pADataArray) {
            if (pAData.getValue() == null) continue;
            switch (pAData.getType()) {
                case 11: {
                    derValue = new DerValue(pAData.getValue());
                    continue block4;
                }
                case 19: {
                    derValue2 = new DerValue(pAData.getValue());
                }
            }
        }
        if (derValue2 != null) {
            while (derValue2.data.available() > 0) {
                DerValue derValue3 = derValue2.data.getDerValue();
                ETypeInfo2 eTypeInfo2 = new ETypeInfo2(derValue3);
                if (eTypeInfo2.getParams() != null) continue;
                return eTypeInfo2.getEType();
            }
        }
        if (derValue != null && derValue.data.available() > 0) {
            DerValue derValue4 = derValue.data.getDerValue();
            ETypeInfo eTypeInfo = new ETypeInfo(derValue4);
            return eTypeInfo.getEType();
        }
        return n;
    }

    public static SaltAndParams getSaltAndParams(int n, PAData[] pADataArray) throws Asn1Exception, IOException {
        if (pADataArray == null) {
            return null;
        }
        DerValue derValue = null;
        DerValue derValue2 = null;
        String string = null;
        block5: for (PAData pAData : pADataArray) {
            if (pAData.getValue() == null) continue;
            switch (pAData.getType()) {
                case 3: {
                    string = new String(pAData.getValue(), KerberosString.MSNAME ? "UTF8" : "8859_1");
                    continue block5;
                }
                case 11: {
                    derValue = new DerValue(pAData.getValue());
                    continue block5;
                }
                case 19: {
                    derValue2 = new DerValue(pAData.getValue());
                }
            }
        }
        if (derValue2 != null) {
            while (derValue2.data.available() > 0) {
                DerValue derValue3 = derValue2.data.getDerValue();
                ETypeInfo2 eTypeInfo2 = new ETypeInfo2(derValue3);
                if (eTypeInfo2.getParams() != null || eTypeInfo2.getEType() != n) continue;
                return new SaltAndParams(eTypeInfo2.getSalt(), eTypeInfo2.getParams());
            }
        }
        if (derValue != null) {
            while (derValue.data.available() > 0) {
                DerValue derValue4 = derValue.data.getDerValue();
                ETypeInfo eTypeInfo = new ETypeInfo(derValue4);
                if (eTypeInfo.getEType() != n) continue;
                return new SaltAndParams(eTypeInfo.getSalt(), null);
            }
        }
        if (string != null) {
            return new SaltAndParams(string, null);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(">>>Pre-Authentication Data:\n\t PA-DATA type = ").append(this.pADataType).append('\n');
        switch (this.pADataType) {
            case 2: {
                stringBuilder.append("\t PA-ENC-TIMESTAMP");
                break;
            }
            case 11: {
                if (this.pADataValue == null) break;
                try {
                    DerValue derValue = new DerValue(this.pADataValue);
                    while (derValue.data.available() > 0) {
                        DerValue derValue2 = derValue.data.getDerValue();
                        ETypeInfo eTypeInfo = new ETypeInfo(derValue2);
                        stringBuilder.append("\t PA-ETYPE-INFO etype = ").append(eTypeInfo.getEType()).append(", salt = ").append(eTypeInfo.getSalt()).append('\n');
                    }
                    break;
                }
                catch (IOException | Asn1Exception exception) {
                    stringBuilder.append("\t <Unparseable PA-ETYPE-INFO>\n");
                    break;
                }
            }
            case 19: {
                if (this.pADataValue == null) break;
                try {
                    DerValue derValue = new DerValue(this.pADataValue);
                    while (derValue.data.available() > 0) {
                        DerValue derValue3 = derValue.data.getDerValue();
                        ETypeInfo2 eTypeInfo2 = new ETypeInfo2(derValue3);
                        stringBuilder.append("\t PA-ETYPE-INFO2 etype = ").append(eTypeInfo2.getEType()).append(", salt = ").append(eTypeInfo2.getSalt()).append(", s2kparams = ");
                        byte[] byArray = eTypeInfo2.getParams();
                        if (byArray == null) {
                            stringBuilder.append("null\n");
                            continue;
                        }
                        if (byArray.length == 0) {
                            stringBuilder.append("empty\n");
                            continue;
                        }
                        stringBuilder.append(new HexDumpEncoder().encodeBuffer(byArray));
                    }
                    break;
                }
                catch (IOException | Asn1Exception exception) {
                    stringBuilder.append("\t <Unparseable PA-ETYPE-INFO>\n");
                    break;
                }
            }
            case 129: {
                stringBuilder.append("\t PA-FOR-USER\n");
                break;
            }
        }
        return stringBuilder.toString();
    }

    public static class SaltAndParams {
        public final String salt;
        public final byte[] params;

        public SaltAndParams(String string, byte[] byArray) {
            if (string != null && string.isEmpty()) {
                string = null;
            }
            this.salt = string;
            this.params = byArray;
        }
    }
}

