/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import javax.crypto.BadPaddingException;
import jdk.crypto.jniprovider.NativeCrypto;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;

public final class NativeRSACore {
    private static NativeCrypto nativeCrypto = NativeCrypto.getNativeCrypto();

    public static int getByteLength(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        return n + 7 >> 3;
    }

    public static byte[] rsa(byte[] byArray, RSAPublicKeyImpl rSAPublicKeyImpl) throws BadPaddingException {
        return NativeRSACore.crypt_Native(byArray, rSAPublicKeyImpl);
    }

    public static byte[] rsa(byte[] byArray, RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, boolean bl) throws BadPaddingException {
        return NativeRSACore.crtCrypt_Native(byArray, rSAPrivateCrtKeyImpl, bl);
    }

    private static synchronized byte[] crypt_Native(byte[] byArray, RSAPublicKeyImpl rSAPublicKeyImpl) throws BadPaddingException {
        long l = rSAPublicKeyImpl.getNativePtr();
        if (l == -1L) {
            return null;
        }
        BigInteger bigInteger = rSAPublicKeyImpl.getModulus();
        byte[] byArray2 = new byte[NativeRSACore.getByteLength(bigInteger)];
        int n = nativeCrypto.RSAEP(byArray, byArray.length, byArray2, l);
        if (n == -1) {
            return null;
        }
        return byArray2;
    }

    private static synchronized byte[] crtCrypt_Native(byte[] byArray, RSAPrivateCrtKeyImpl rSAPrivateCrtKeyImpl, boolean bl) throws BadPaddingException {
        long l = rSAPrivateCrtKeyImpl.getNativePtr();
        if (l == -1L) {
            return null;
        }
        BigInteger bigInteger = rSAPrivateCrtKeyImpl.getModulus();
        int n = NativeRSACore.getByteLength(bigInteger);
        byte[] byArray2 = new byte[n];
        int n2 = bl ? n : -1;
        if ((n = nativeCrypto.RSADP(byArray, byArray.length, byArray2, n2, l)) == -1) {
            return null;
        }
        if (n == -2) {
            throw new BadPaddingException("RSA private key operation failed");
        }
        return byArray2;
    }
}

