/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.tools;

import com.ibm.jvm.dtfjview.Session;
import com.ibm.jvm.dtfjview.tools.CommandException;
import com.ibm.jvm.dtfjview.tools.IPipe;
import com.ibm.jvm.dtfjview.tools.ITool;
import com.ibm.jvm.dtfjview.tools.ParsedCommand;
import com.ibm.jvm.dtfjview.tools.ToolsRegistryOutputChannels;
import com.ibm.jvm.dtfjview.tools.impl.CharsFromTool;
import com.ibm.jvm.dtfjview.tools.impl.CharsToTool;
import com.ibm.jvm.dtfjview.tools.impl.CmdFileTool;
import com.ibm.jvm.dtfjview.tools.impl.GrepTool;
import com.ibm.jvm.dtfjview.tools.impl.HelpTool;
import com.ibm.jvm.dtfjview.tools.impl.HistoryTool;
import com.ibm.jvm.dtfjview.tools.impl.OutFileTool;
import com.ibm.jvm.dtfjview.tools.impl.TokensTool;
import com.ibm.jvm.dtfjview.tools.utils.StringReceiver;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ToolsRegistry {
    private List<ITool> toolList;
    private HistoryTool history;
    private Session session;
    private String charsetName;
    private static ToolsRegistry registry = null;

    public static void initialize(Session session) {
        ToolsRegistryOutputChannels.initialize(session.getCharset());
        if (null == registry) {
            registry = new ToolsRegistry(session);
            registry.initializeTools();
        }
    }

    public static void recordAndExecute(String string) throws CommandException {
        if (null != string && 0 < string.trim().length()) {
            try {
                ToolsRegistry.execute(string);
            }
            finally {
                ToolsRegistry.registry.history.record(string);
            }
        }
    }

    public static void execute(String string) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(string);
        ToolsRegistry.execute(parsedCommand.getCommand(), parsedCommand.getArguments());
    }

    public static void execute(String string, String[] stringArray) throws CommandException {
        PrintStream printStream = ToolsRegistryOutputChannels.newPrintStream();
        for (ITool iTool : ToolsRegistry.registry.toolList) {
            if (!iTool.accept(string, stringArray)) continue;
            iTool.process(string, stringArray, printStream);
            return;
        }
        ToolsRegistry.executeJdmpviewCommand(new ParsedCommand(string, stringArray).getCombinedCommandLine(), printStream);
    }

    public static void process(String string, PrintStream printStream) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(string);
        ToolsRegistry.process(parsedCommand.getCommand(), parsedCommand.getArguments(), printStream);
    }

    public static String process(String string) throws CommandException {
        ParsedCommand parsedCommand = ParsedCommand.parse(string);
        return ToolsRegistry.process(parsedCommand.getCommand(), parsedCommand.getArguments());
    }

    public static void process(String string, String[] stringArray, PrintStream printStream) throws CommandException {
        for (ITool iTool : ToolsRegistry.registry.toolList) {
            if (!iTool.accept(string, stringArray)) continue;
            iTool.process(string, stringArray, printStream);
            return;
        }
        ToolsRegistry.executeJdmpviewCommand(new ParsedCommand(string, stringArray).getCombinedCommandLine(), printStream);
    }

    public static String process(String string, String[] stringArray) throws CommandException {
        StringReceiver stringReceiver = new StringReceiver(ToolsRegistry.registry.charsetName);
        ToolsRegistry.process(string, stringArray, new PrintStream(stringReceiver));
        try {
            return stringReceiver.release();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CommandException(unsupportedEncodingException);
        }
    }

    public static void executeJdmpviewCommand(String string, PrintStream printStream) {
        ToolsRegistry.registry.session.execute(string, printStream);
    }

    public static boolean isPipeLineEnabled(String string, String[] stringArray) {
        for (ITool iTool : ToolsRegistry.registry.toolList) {
            if (!iTool.accept(string, stringArray) || !(iTool instanceof IPipe)) continue;
            return true;
        }
        return false;
    }

    public static void registerTool(ITool iTool) {
        ToolsRegistry.registry.toolList.add(iTool);
    }

    public static List<ITool> getAllTools() {
        return ToolsRegistry.registry.toolList;
    }

    private ToolsRegistry(Session session) {
        this.session = session;
        this.toolList = new ArrayList<ITool>();
        this.charsetName = session.getCharset();
    }

    private void initializeTools() {
        new HelpTool();
        this.history = new HistoryTool();
        new GrepTool();
        new CharsFromTool();
        new CharsToTool();
        new OutFileTool();
        new CmdFileTool(this.charsetName);
        new TokensTool();
    }
}

