/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.BytecodeGenerator;
import com.ibm.j9ddr.CTypeParser;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureTypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.stream.ImageInputStream;

public class StructureReader {
    public static final int VERSION = 1;
    public static final int J9_STRUCTURES_EYECATCHER = -87105864;
    private HashMap<String, StructureDescriptor> structures = null;
    private String packageDotBaseName;
    private String pointerDotName;
    private String pointerSlashName;
    private String structureDotName;
    private String structureSlashName;
    private static final Logger logger = Logger.getLogger("j9ddr.structure_reader");
    private StructureHeader header;
    public static final Class<?>[] STRUCTURE_CONSTRUCTOR_SIGNATURE = new Class[]{Long.TYPE};
    public static final byte BIT_FIELD_FORMAT_LITTLE_ENDIAN = 1;
    public static final byte BIT_FIELD_FORMAT_BIG_ENDIAN = 2;
    public static final int BIT_FIELD_CELL_SIZE = 32;
    private static final Pattern MULTI_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("/*") + ".*?" + Pattern.quote("*/"), 32);
    private static final Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile(Pattern.quote("//") + ".*$", 8);
    private static final Pattern MAP_PATTERN = Pattern.compile("(.*?)=(.*?)$", 8);
    private Long packageVersion;
    private String basePackage = "com.ibm.j9ddr.vm";
    private final StructureTypeManager typeManager;
    private static final Pattern CONTENTS_OF_ARRAY_PATTERN = Pattern.compile("(?<=\\[).*?(?=\\])");
    private static final Pattern SPACES_AFTER_SQUARE_BRACKETS_PATTERN = Pattern.compile("(?<=\\])\\s+");
    private static final Pattern SPACES_BEFORE_SQUARE_BRACKETS_PATTERN = Pattern.compile("\\s+(?=\\[)");
    private static final Pattern SPACES_AFTER_ASTERISKS_PATTERN = Pattern.compile("(?<=\\*)\\s+");
    private static final Pattern SPACES_BEFORE_ASTERISKS_PATTERN = Pattern.compile("\\s+(?=\\*)");
    private static final String VM_MAJOR_VERSION = "VM_MAJOR_VERSION";
    private static final String VM_MINOR_VERSION = "VM_MINOR_VERSION";
    private static final String ARM_SPLIT_DDR_HACK = "ARM_SPLIT_DDR_HACK";
    private static final String DDRALGORITHM_STRUCTURE_NAME = "DDRAlgorithmVersions";
    public static final String DDR_VERSIONED_PACKAGE_PREFIX = "com.ibm.j9ddr.vm";

    public StructureReader(ImageInputStream imageInputStream) throws IOException {
        this.parse(imageInputStream);
        this.setStream();
        this.applyAliases();
        this.typeManager = new StructureTypeManager(this.getStructures());
    }

    public StructureReader(InputStream inputStream) throws IOException {
        this.parse(inputStream);
        this.setStream();
        this.typeManager = new StructureTypeManager(this.getStructures());
    }

    public StructureHeader getHeader() {
        return this.header;
    }

    private void setStream() {
        StructureDescriptor structureDescriptor = this.structures.get(DDRALGORITHM_STRUCTURE_NAME);
        long l = 2L;
        long l2 = 3L;
        String string = "%2d";
        if (structureDescriptor != null) {
            for (ConstantDescriptor constantDescriptor : structureDescriptor.getConstants()) {
                String string2 = constantDescriptor.getName();
                if (string2.equals(VM_MAJOR_VERSION)) {
                    l = constantDescriptor.getValue();
                    continue;
                }
                if (string2.equals(VM_MINOR_VERSION)) {
                    l2 = constantDescriptor.getValue() / 10L;
                    continue;
                }
                if (!string2.equals(ARM_SPLIT_DDR_HACK) || constantDescriptor.getValue() != 1L) continue;
                string = "%2d_00";
            }
        }
        this.packageVersion = l * 10L + l2;
        String string3 = String.format(string, this.packageVersion);
        this.packageDotBaseName = DDR_VERSIONED_PACKAGE_PREFIX + (String)string3;
        this.pointerDotName = this.packageDotBaseName + ".pointer.generated";
        this.pointerSlashName = this.pointerDotName.replace('.', '/') + '/';
        this.structureDotName = this.packageDotBaseName + ".structure";
        this.structureSlashName = this.structureDotName.replace('.', '/') + '/';
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public long getPackageVersion() {
        if (this.packageVersion == null) {
            throw new IllegalStateException("The DDR version information is not yet available");
        }
        return this.packageVersion;
    }

    public String getPackageName(PackageNameType packageNameType) {
        if (this.packageVersion == null) {
            throw new IllegalStateException("The DDR version information is not yet available");
        }
        switch (packageNameType) {
            case PACKAGE_DOT_BASE_NAME: {
                return this.packageDotBaseName;
            }
            case POINTER_PACKAGE_DOT_NAME: {
                return this.pointerDotName;
            }
            case POINTER_PACKAGE_SLASH_NAME: {
                return this.pointerSlashName;
            }
            case STRUCTURE_PACKAGE_DOT_NAME: {
                return this.structureDotName;
            }
            case STRUCTURE_PACKAGE_SLASH_NAME: {
                return this.structureSlashName;
            }
        }
        throw new IllegalStateException("Unexpected PackageNameType");
    }

    private void applyAliases() throws IOException {
        Map<String, String> map = this.loadAliasMap();
        for (StructureDescriptor structureDescriptor : this.structures.values()) {
            for (FieldDescriptor fieldDescriptor : structureDescriptor.fields) {
                fieldDescriptor.applyAliases(map);
            }
        }
    }

    private Map<String, String> loadAliasMap() throws IOException {
        String string = this.loadAliasMapData();
        string = StructureReader.stripComments(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Matcher matcher = MAP_PATTERN.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            hashMap.put(string2.trim(), string3.trim());
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static String stripComments(String string) {
        string = StructureReader.filterOutPattern(string, MULTI_LINE_COMMENT_PATTERN);
        string = StructureReader.filterOutPattern(string, SINGLE_LINE_COMMENT_PATTERN);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadAliasMapData() throws IOException {
        String string;
        InputStream inputStream;
        String string2 = "/com/ibm/j9ddr/StructureAliases%d%s.dat";
        String string3 = "";
        if (this.packageVersion == 29L && !this.getBuildFlagValue("J9BuildFlags", "J9VM_OPT_USE_OMR_DDR", false)) {
            string3 = "-edg";
        }
        if (null == (inputStream = StructureReader.class.getResourceAsStream(string = String.format(string2, this.packageVersion, string3)))) {
            throw new RuntimeException("Failed to load alias map from resource: " + string + " - cannot continue");
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
            String string4 = stringBuilder.toString();
            return string4;
        }
    }

    public Set<String> getStructureNames() {
        return this.structures.keySet();
    }

    public boolean hasStructure(String string) {
        return this.structures.containsKey(string);
    }

    public int getStructureSizeOf(String string) {
        if (!this.hasStructure(string)) {
            return 0;
        }
        return this.structures.get(string).getSizeOf();
    }

    public Collection<StructureDescriptor> getStructures() {
        return this.structures.values();
    }

    public ArrayList<FieldDescriptor> getFields(String string) {
        StructureDescriptor structureDescriptor = this.structures.get(string);
        if (structureDescriptor == null) {
            throw new IllegalArgumentException("The structure [" + string + "] was not found");
        }
        return structureDescriptor.fields;
    }

    public ArrayList<ConstantDescriptor> getConstants(String string) {
        StructureDescriptor structureDescriptor = this.structures.get(string);
        if (structureDescriptor == null) {
            throw new IllegalArgumentException("The structure [" + string + "] was not found");
        }
        return structureDescriptor.constants;
    }

    private void parse(InputStream inputStream) throws IOException {
        this.header = new StructureHeader(inputStream);
        this.structures = new HashMap();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        StructureDescriptor structureDescriptor = null;
        while (string != null) {
            if (string.isEmpty()) continue;
            char c = string.charAt(0);
            switch (c) {
                case 'S': {
                    structureDescriptor = new StructureDescriptor(string);
                    this.structures.put(structureDescriptor.getName(), structureDescriptor);
                    break;
                }
                case 'F': {
                    if (structureDescriptor == null) {
                        throw new IllegalArgumentException("Superset stream is missing structure start line");
                    }
                    Collection<FieldDescriptor> collection = FieldDescriptor.inflate(string);
                    structureDescriptor.fields.addAll(collection);
                    break;
                }
                case 'C': {
                    if (structureDescriptor == null) {
                        throw new IllegalArgumentException("Superset stream is missing structure start line");
                    }
                    ConstantDescriptor constantDescriptor = new ConstantDescriptor(string);
                    structureDescriptor.constants.add(constantDescriptor);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Superset stream contained unknown line: %s", string));
                }
            }
            string = bufferedReader.readLine();
        }
    }

    public void addStructures(ImageInputStream imageInputStream) throws IOException {
        StructureHeader structureHeader = new StructureHeader(imageInputStream);
        this.checkBlobVersion();
        if (this.header.getSizeofBool() != structureHeader.getSizeofBool()) {
            throw new IOException("Invalid fragment definition : size of boolean is not the same");
        }
        if (this.header.getSizeofUDATA() != structureHeader.getSizeofUDATA()) {
            throw new IOException("Invalid fragment definition : size of UDATA is not the same");
        }
        this.parseStructures(imageInputStream, structureHeader);
    }

    private void parse(ImageInputStream imageInputStream) throws IOException {
        logger.logp(Level.FINE, null, null, "Parsing structures. Start address = {0}", Long.toHexString(imageInputStream.getStreamPosition()));
        this.header = new StructureHeader(imageInputStream);
        this.checkBlobVersion();
        this.parseStructures(imageInputStream, this.header);
    }

    private void checkBlobVersion() throws IOException {
        logger.logp(Level.FINE, null, null, "Stream core structure version = {0}", this.header.getCoreVersion());
        if (this.header.getCoreVersion() > 1) {
            throw new IOException("Core structure version " + this.header.getCoreVersion() + " > StructureReader version " + 1);
        }
    }

    private void parseStructures(ImageInputStream imageInputStream, StructureHeader structureHeader) throws IOException {
        logger.logp(Level.FINER, (String)null, (String)null, "structDataSize={0}, stringTableDataSize={1}, structureCount={2}", new Object[]{structureHeader.getStructDataSize(), structureHeader.getStringTableDataSize(), structureHeader.getStructureCount()});
        long l = imageInputStream.getStreamPosition() + (long)structureHeader.getStructDataSize();
        logger.logp(Level.FINER, null, null, "ddrStringTableStart=0x{0}", Long.toHexString(l));
        if (this.structures == null) {
            this.structures = new HashMap(structureHeader.getStructureCount());
        }
        for (int i = 0; i < structureHeader.getStructureCount(); ++i) {
            String string;
            int n;
            logger.logp(Level.FINER, null, null, "Reading structure on iteration {0}", i);
            StructureDescriptor structureDescriptor = new StructureDescriptor();
            structureDescriptor.name = StructureReader.readString(imageInputStream, l);
            if (structureDescriptor.name == null) {
                logger.logp(Level.FINE, null, null, "Structure name was null for structure {0}", i);
                throw new IllegalArgumentException(String.format("Structure name was null for structure %d", i));
            }
            if (structureDescriptor.name.isEmpty()) {
                logger.logp(Level.FINE, null, null, "Structure name was blank for structure {0}", i);
                throw new IllegalArgumentException(String.format("No name found for structure %d", i));
            }
            structureDescriptor.name = structureDescriptor.name.replace("__", "$");
            logger.logp(Level.FINE, null, null, "Reading structure {0}", structureDescriptor.name);
            structureDescriptor.pointerName = structureDescriptor.name + "Pointer";
            structureDescriptor.superName = StructureReader.readString(imageInputStream, l);
            structureDescriptor.superName = structureDescriptor.superName.replace("__", "$");
            structureDescriptor.sizeOf = imageInputStream.readInt();
            int n2 = imageInputStream.readInt();
            structureDescriptor.fields = new ArrayList(n2);
            int n3 = imageInputStream.readInt();
            structureDescriptor.constants = new ArrayList(n3);
            logger.logp(Level.FINER, (String)null, (String)null, "{0} super {1} sizeOf {2}", new Object[]{structureDescriptor.name, structureDescriptor.superName, structureDescriptor.sizeOf});
            for (n = 0; n < n2; ++n) {
                string = StructureReader.readString(imageInputStream, l);
                String string2 = string.replace(".", "$");
                String string3 = StructureReader.readString(imageInputStream, l);
                if (string2.equals("hashCode")) {
                    string2 = "_hashCode";
                }
                int n4 = imageInputStream.readInt();
                FieldDescriptor fieldDescriptor = new FieldDescriptor(n4, string3, string3, string2, string);
                structureDescriptor.fields.add(fieldDescriptor);
                logger.logp(Level.FINEST, (String)null, (String)null, "Field: {0}.{1} offset {2}, declaredType {3}", new Object[]{structureDescriptor.name, string2, n4, string3, string3});
            }
            for (n = 0; n < n3; ++n) {
                string = StructureReader.readString(imageInputStream, l);
                long l2 = imageInputStream.readLong();
                ConstantDescriptor constantDescriptor = new ConstantDescriptor(string, l2);
                structureDescriptor.constants.add(constantDescriptor);
                logger.logp(Level.FINEST, (String)null, (String)null, "Constant: {0}.{1}={2}", new Object[]{structureDescriptor.name, string, l2});
            }
            this.structures.put(structureDescriptor.name, structureDescriptor);
        }
        logger.logp(Level.FINE, null, null, "Finished parsing structures");
    }

    private static String readString(ImageInputStream imageInputStream, long l) {
        try {
            int n = imageInputStream.readInt();
            if (n == -1) {
                return "";
            }
            long l2 = imageInputStream.getStreamPosition();
            long l3 = l + (long)n;
            imageInputStream.seek(l3);
            int n2 = imageInputStream.readUnsignedShort();
            if (n2 > 200) {
                throw new IOException(String.format("Improbable string length: %d", n2));
            }
            byte[] byArray = new byte[n2];
            int n3 = imageInputStream.read(byArray);
            if (n3 != n2) {
                throw new IOException("StructureReader readString() Failed to read " + n2 + " at " + Long.toHexString(l3) + ". Result: " + n3);
            }
            String string = new String(byArray, StandardCharsets.UTF_8);
            imageInputStream.seek(l2);
            return string;
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            logger.logp(Level.FINE, null, null, stringWriter.toString());
            iOException.printStackTrace();
            return null;
        }
    }

    public byte[] getStructureClassBytes(String string) throws ClassNotFoundException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        StructureDescriptor structureDescriptor = this.structures.get(string2);
        if (structureDescriptor == null) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", string2));
        }
        String string3 = this.getPackageName(PackageNameType.STRUCTURE_PACKAGE_SLASH_NAME) + string2;
        return BytecodeGenerator.getStructureClassBytes(structureDescriptor, string3);
    }

    public byte[] getPointerClassBytes(String string) throws ClassNotFoundException {
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        String string3 = string2.endsWith("Pointer") ? string2.substring(0, string2.length() - 7) : string2;
        StructureDescriptor structureDescriptor = this.structures.get(string3);
        if (structureDescriptor == null) {
            throw new ClassNotFoundException(String.format("%s is not in core file.", string2));
        }
        String string4 = this.getPackageName(PackageNameType.POINTER_PACKAGE_SLASH_NAME) + string2;
        return BytecodeGenerator.getPointerClassBytes(this, this.typeManager, structureDescriptor, string4);
    }

    public long getConstantValue(String string, String string2, long l) {
        if (string2.equals("SIZEOF")) {
            return this.getStructureSizeOf(string);
        }
        for (ConstantDescriptor constantDescriptor : this.getConstants(string)) {
            if (!constantDescriptor.getName().equals(string2)) continue;
            return constantDescriptor.getValue();
        }
        return l;
    }

    public boolean getBuildFlagValue(String string, String string2, boolean bl) {
        long l = bl ? 1L : 0L;
        long l2 = this.getConstantValue(string, string2, l);
        return l2 != 0L;
    }

    public byte getSizeOfBool() {
        return this.header.getSizeofBool();
    }

    public byte getSizeOfUDATA() {
        return this.header.getSizeofUDATA();
    }

    public byte getBitFieldFormat() {
        return this.header.getBitfieldFormat();
    }

    public static String simplifyType(String string) {
        String string2 = string;
        string2 = StructureReader.filterOutPattern(string2, CONTENTS_OF_ARRAY_PATTERN);
        string2 = StructureReader.filterOutPattern(string2, SPACES_BEFORE_SQUARE_BRACKETS_PATTERN);
        string2 = StructureReader.filterOutPattern(string2, SPACES_AFTER_SQUARE_BRACKETS_PATTERN);
        string2 = StructureReader.filterOutPattern(string2, SPACES_BEFORE_ASTERISKS_PATTERN);
        string2 = StructureReader.filterOutPattern(string2, SPACES_AFTER_ASTERISKS_PATTERN);
        return string2;
    }

    static String filterOutPattern(String string, Pattern pattern) {
        return pattern.matcher(string).replaceAll("");
    }

    public static class FieldDescriptor
    implements Comparable<FieldDescriptor> {
        String type;
        String declaredType;
        String name;
        String declaredName;
        int offset;
        private static final Pattern QualifierPattern = Pattern.compile("\\s*\\b(const|volatile)\\b\\s*");
        private static final Pattern ScalarPattern = Pattern.compile("\\b([IU])_(?=\\d+|DATA\\b)");

        public FieldDescriptor(int n, String string, String string2, String string3, String string4) {
            this.type = string;
            this.declaredType = string2;
            this.name = string3;
            this.offset = n;
            this.declaredName = string4;
        }

        public void applyAliases(Map<String, String> map) {
            this.type = FieldDescriptor.unalias(this.declaredType, map);
            this.cleanUpTypes();
        }

        public void cleanUpTypes() {
            this.type = FieldDescriptor.stripUnderscore(this.type);
            this.type = FieldDescriptor.stripTypeQualifiers(this.type);
            this.declaredType = FieldDescriptor.stripUnderscore(this.declaredType);
        }

        private static String stripTypeQualifiers(String string) {
            return StructureReader.filterOutPattern(string, QualifierPattern).trim();
        }

        private static String stripUnderscore(String string) {
            return ScalarPattern.matcher(string).replaceAll("$1");
        }

        private static String unalias(String string, Map<String, String> map) {
            CTypeParser cTypeParser = new CTypeParser(string);
            String string2 = cTypeParser.getCoreType();
            if (map.containsKey(string2)) {
                string2 = map.get(string2);
            }
            return cTypeParser.getPrefix() + string2 + cTypeParser.getSuffix();
        }

        public String getName() {
            return this.name;
        }

        public String getDeclaredName() {
            return this.declaredName;
        }

        public String getType() {
            return this.type;
        }

        public String getDeclaredType() {
            return this.declaredType;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.type + " " + this.name + " Offset: " + this.offset;
        }

        @Override
        public int compareTo(FieldDescriptor fieldDescriptor) {
            return this.getName().compareTo(fieldDescriptor.getName());
        }

        public static Collection<FieldDescriptor> inflate(String string) {
            String[] stringArray = string.split("\\|");
            if (stringArray.length < 5 || (stringArray.length - 3) % 2 != 0) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", string));
            }
            int n = (stringArray.length - 3) / 2;
            ArrayList<FieldDescriptor> arrayList = new ArrayList<FieldDescriptor>(n);
            String string2 = stringArray[2];
            for (int i = 0; i < n; ++i) {
                String string3 = stringArray[1];
                if (i > 0) {
                    string3 = string3 + "_v" + i;
                }
                FieldDescriptor fieldDescriptor = new FieldDescriptor(0, stringArray[3 + i * 2], stringArray[4 + i * 2], string3, string2);
                arrayList.add(fieldDescriptor);
            }
            return arrayList;
        }

        public String deflate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("F|");
            stringBuilder.append(this.getName());
            stringBuilder.append("|");
            stringBuilder.append(this.getDeclaredName());
            stringBuilder.append("|");
            stringBuilder.append(StructureReader.simplifyType(this.getType()));
            stringBuilder.append("|");
            stringBuilder.append(StructureReader.simplifyType(this.getDeclaredType()));
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FieldDescriptor)) {
                return false;
            }
            FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
            return fieldDescriptor.deflate().equals(this.deflate());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class ConstantDescriptor
    implements Comparable<ConstantDescriptor> {
        String name;
        long value;

        public ConstantDescriptor(String string, long l) {
            this.name = string;
            this.value = l;
        }

        public ConstantDescriptor(String string) {
            this.inflate(string);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }

        public String getName() {
            return this.name;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(ConstantDescriptor constantDescriptor) {
            return this.getName().compareTo(constantDescriptor.getName());
        }

        private void inflate(String string) {
            String[] stringArray = string.split("\\|");
            if (stringArray.length != 2) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", string));
            }
            this.name = stringArray[1];
        }

        public String deflate() {
            return "C|" + this.getName();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ConstantDescriptor)) {
                return false;
            }
            ConstantDescriptor constantDescriptor = (ConstantDescriptor)object;
            return this.name.equals(constantDescriptor.name) && this.value == constantDescriptor.value;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class StructureDescriptor {
        String name;
        String superName;
        String pointerName;
        int sizeOf;
        ArrayList<FieldDescriptor> fields;
        ArrayList<ConstantDescriptor> constants;

        public StructureDescriptor() {
        }

        public StructureDescriptor(String string) {
            this.inflate(string);
        }

        public String toString() {
            return this.name + " extends " + this.superName;
        }

        public String getPointerName() {
            return this.name + "Pointer";
        }

        public String getName() {
            return this.name;
        }

        public String getSuperName() {
            return this.superName;
        }

        public ArrayList<FieldDescriptor> getFields() {
            return this.fields;
        }

        public ArrayList<ConstantDescriptor> getConstants() {
            return this.constants;
        }

        public int getSizeOf() {
            return this.sizeOf;
        }

        private void inflate(String string) {
            String[] stringArray = string.split("\\|");
            if (stringArray.length < 3 || stringArray.length > 4) {
                throw new IllegalArgumentException(String.format("Superset file line is invalid: %s", string));
            }
            this.constants = new ArrayList();
            this.fields = new ArrayList();
            this.name = stringArray[1];
            this.pointerName = stringArray[2];
            this.superName = stringArray.length == 4 ? stringArray[3] : "";
        }

        public String deflate() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("S|");
            stringBuilder.append(this.getName());
            stringBuilder.append("|");
            stringBuilder.append(this.getPointerName());
            stringBuilder.append("|");
            stringBuilder.append(this.getSuperName());
            return stringBuilder.toString();
        }
    }

    public static enum PackageNameType {
        PACKAGE_DOT_BASE_NAME,
        POINTER_PACKAGE_DOT_NAME,
        POINTER_PACKAGE_SLASH_NAME,
        STRUCTURE_PACKAGE_DOT_NAME,
        STRUCTURE_PACKAGE_SLASH_NAME;

    }
}

