/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class BuildVersionCommand
extends LoadCommand {
    int platform;
    int minOs;
    int sdk;
    int numTools;
    Version minOsVersion;
    Version sdkVersion;
    List<BuildToolVersion> tools;

    @Override
    public BuildVersionCommand readCommand(ImageInputStream imageInputStream, long l) throws IOException {
        super.readCommand(imageInputStream, l);
        this.minOs = imageInputStream.readInt();
        this.sdk = imageInputStream.readInt();
        this.minOsVersion = new Version(this.minOs);
        this.sdkVersion = new Version(this.sdk);
        this.numTools = imageInputStream.readInt();
        this.tools = new ArrayList<BuildToolVersion>(this.numTools);
        for (int i = 0; i < this.numTools; ++i) {
            BuildToolVersion buildToolVersion = new BuildToolVersion();
            buildToolVersion.toolType = imageInputStream.readInt();
            buildToolVersion.version = imageInputStream.readInt();
            this.tools.add(buildToolVersion);
        }
        return this;
    }

    public static class BuildToolVersion {
        public static final int TOOL_CLANG = 1;
        public static final int TOOL_SWIFT = 2;
        public static final int TOOL_LD = 3;
        int toolType;
        int version;
    }

    public static class Version {
        int major;
        int minor;
        int patch;

        public Version(int n) {
            int n2;
            for (n2 = 8; n2 > 4; --n2) {
                this.major = this.major * 10 + (n >>> n2 * 4 & 0xF);
            }
            for (n2 = 4; n2 > 2; --n2) {
                this.minor = this.minor * 10 + (n >>> n2 * 4 & 0xF);
            }
            for (n2 = 2; n2 > 0; --n2) {
                this.patch = this.patch * 10 + (n >>> n2 * 4 & 0xF);
            }
        }
    }
}

