/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCIterator;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MemorySegmentPointer;
import java.util.NoSuchElementException;

public class GCClassLoaderSegmentIterator
extends GCIterator {
    private J9ClassLoaderPointer classLoader;
    private J9MemorySegmentPointer memorySegment;
    private long flags;

    protected GCClassLoaderSegmentIterator(J9ClassLoaderPointer j9ClassLoaderPointer, long l) throws CorruptDataException {
        this.classLoader = j9ClassLoaderPointer;
        this.memorySegment = this.classLoader.classSegments();
        this.flags = l;
    }

    public static GCClassLoaderSegmentIterator fromJ9ClassLoader(J9ClassLoaderPointer j9ClassLoaderPointer, long l) throws CorruptDataException {
        return new GCClassLoaderSegmentIterator(j9ClassLoaderPointer, l);
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.memorySegment.notNull()) {
                if (this.memorySegment.type().allBitsIn(this.flags)) {
                    return true;
                }
                this.memorySegment = this.memorySegment.nextSegmentInClassLoader();
            }
            return false;
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error determining next segment", corruptDataException, true);
            return false;
        }
    }

    @Override
    public J9MemorySegmentPointer next() {
        try {
            if (this.hasNext()) {
                J9MemorySegmentPointer j9MemorySegmentPointer = this.memorySegment;
                this.memorySegment = this.memorySegment.nextSegmentInClassLoader();
                return j9MemorySegmentPointer;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Error returning next segment", corruptDataException, false);
            return null;
        }
    }

    @Override
    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

