/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackmap;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BCNames;
import com.ibm.j9ddr.vm29.j9.PCStack;
import com.ibm.j9ddr.vm29.j9.ROMHelp;
import com.ibm.j9ddr.vm29.j9.stackmap.MapHelpers;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMConstantPoolItemPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm29.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StackMap {
    private static Logger logger = Logger.getLogger("j9ddr.stackwalker.stackmap");
    private static IStackMap impl;

    public static int j9stackmap_StackBitsForPC(UDATA uDATA, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, int n) throws CorruptDataException {
        IStackMap iStackMap = StackMap.getImpl();
        return iStackMap.j9stackmap_StackBitsForPC(uDATA, j9ROMClassPointer, j9ROMMethodPointer, nArray, n);
    }

    private static IStackMap getImpl() {
        if (impl == null) {
            impl = StackMap.getImpl("ALG_STACK_MAP_VERSION");
        }
        return impl;
    }

    private static IStackMap getImpl(String string) {
        AlgorithmVersion algorithmVersion = AlgorithmVersion.getVersionOf(string);
        switch (algorithmVersion.getAlgorithmVersion()) {
            default: 
        }
        return new StackMap_V1();
    }

    private static class StackMap_V1
    implements IStackMap {
        public static final byte INT = 0;
        public static final byte OBJ = 1;
        public static final byte WALKED = 1;
        public static final byte STACK_REQUEST = 2;
        public static final int BCT_ERR_NO_ERROR = 0;
        public static final int BCT_ERR_STACK_MAP_FAILED = -5;
        private J9MappingStack resultStack;
        private J9MappingStack startStack;
        private J9MappingStack liveStack;
        private U8Pointer bcStart;
        private U8Pointer bcIndex;
        private U8Pointer bcEnd;
        private int exceptionsToWalk;
        private J9ExceptionInfoPointer exceptionData;
        private Stack<J9MappingStack> branchStack = new Stack();

        protected StackMap_V1() {
        }

        @Override
        public int j9stackmap_StackBitsForPC(UDATA uDATA, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer, int[] nArray, int n) throws CorruptDataException {
            logger.logp(Level.FINE, "StackMap_V1", "j9stackmap_StackBitsForPC", "romClass={0}, romMethod={1}, pc={2}", new Object[]{Long.toHexString(j9ROMClassPointer.getAddress()), Long.toHexString(j9ROMMethodPointer.getAddress()), uDATA});
            UDATA uDATA2 = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            U16 u16 = j9ROMMethodPointer.maxStack();
            byte[] byArray = new byte[uDATA2.intValue()];
            byArray[uDATA.intValue()] = 2;
            int n2 = this.mapStack(u16, byArray, j9ROMClassPointer, j9ROMMethodPointer);
            if (n2 == 0) {
                n2 = this.outputStackMap(nArray, n);
            }
            return n2;
        }

        private int mapStack(U16 u16, byte[] byArray, J9ROMClassPointer j9ROMClassPointer, J9ROMMethodPointer j9ROMMethodPointer) throws CorruptDataException {
            this.exceptionData = ROMHelp.J9_EXCEPTION_DATA_FROM_ROM_METHOD(j9ROMMethodPointer);
            J9ROMConstantPoolItemPointer j9ROMConstantPoolItemPointer = J9ROMConstantPoolItemPointer.cast(j9ROMClassPointer.add(1L));
            if (j9ROMMethodPointer.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasExceptionInfo)) {
                this.exceptionsToWalk = this.exceptionData.catchCount().intValue();
            }
            this.liveStack = this.startStack = new J9MappingStack(u16.intValue());
            this.bcIndex = this.bcStart = ROMHelp.J9_BYTECODE_START_FROM_ROM_METHOD(j9ROMMethodPointer);
            UDATA uDATA = ROMHelp.J9_BYTECODE_SIZE_FROM_ROM_METHOD(j9ROMMethodPointer);
            this.bcEnd = this.bcStart.add(uDATA);
            block7: while (this.bcIndex.lt(this.bcEnd)) {
                int n;
                block68: {
                    int n2;
                    int n3;
                    int n4;
                    block85: {
                        int n5;
                        char c;
                        J9UTF8Pointer j9UTF8Pointer;
                        block82: {
                            block81: {
                                block80: {
                                    block78: {
                                        block79: {
                                            block76: {
                                                block77: {
                                                    block75: {
                                                        byte by;
                                                        int n6;
                                                        block74: {
                                                            int n7;
                                                            block73: {
                                                                block72: {
                                                                    block71: {
                                                                        block70: {
                                                                            block69: {
                                                                                block67: {
                                                                                    int n8;
                                                                                    int n9 = (int)this.bcIndex.sub(UDATA.cast(this.bcStart)).getAddress();
                                                                                    n4 = this.bcIndex.at(0L).intValue();
                                                                                    if (byArray[n9] != 0) {
                                                                                        if ((byArray[n9] & 2) != 0) {
                                                                                            this.resultStack = this.liveStack;
                                                                                            return 0;
                                                                                        }
                                                                                        n8 = this.nextRoot();
                                                                                        if (n8 == 0) continue;
                                                                                        return n8;
                                                                                    }
                                                                                    byArray[n9] = 1;
                                                                                    n = 0xFF & PCStack.J9JavaInstructionSizeAndBranchActionTable[n4];
                                                                                    int n10 = 0xFF & PCStack.JavaStackActionTable[n4];
                                                                                    if (logger.isLoggable(Level.FINER)) {
                                                                                        logger.logp(Level.FINER, "StackMap_V1", "mapStack", "bcIndex=0x{0} pc={1}, bc={2}, size={3}, action=0x{4}", new Object[]{Long.toHexString(this.bcIndex.getAddress()), n9, n4, n, Long.toHexString(n10)});
                                                                                    }
                                                                                    if (n10 != 128) {
                                                                                        for (n3 = 0; n3 != (n10 & 7); ++n3) {
                                                                                            this.POP();
                                                                                        }
                                                                                        if (n10 >= 16) {
                                                                                            if (n10 >= 80) {
                                                                                                this.PUSH((byte)1);
                                                                                            } else {
                                                                                                this.PUSH((byte)0);
                                                                                                if (n10 >= 32) {
                                                                                                    this.PUSH((byte)0);
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                        if (n >>> 4 == 0) {
                                                                                            this.bcIndex = this.bcIndex.add(n);
                                                                                            if (n != 0) continue;
                                                                                            return -5;
                                                                                        }
                                                                                        switch (n >> 4) {
                                                                                            case 1: {
                                                                                                int n11 = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                                int n12 = n9 + n11;
                                                                                                if ((byArray[n12] & 1) == 0) {
                                                                                                    this.liveStack = this.pushStack(n12);
                                                                                                }
                                                                                                this.bcIndex = this.bcIndex.add(n & 7);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 2: {
                                                                                                int n12;
                                                                                                int n11;
                                                                                                if (n4 == 167) {
                                                                                                    n11 = new I16(MapHelpers.PARAM_16(this.bcIndex, 1)).intValue();
                                                                                                    n12 = n9 + n11;
                                                                                                } else {
                                                                                                    n11 = new I32(MapHelpers.PARAM_32(this.bcIndex, 1)).intValue();
                                                                                                    n12 = n9 + n11;
                                                                                                }
                                                                                                this.bcIndex = this.bcStart.add(n12);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 4: {
                                                                                                n8 = this.nextRoot();
                                                                                                if (n8 == 0) continue block7;
                                                                                                return n8;
                                                                                            }
                                                                                            case 5: {
                                                                                                int n13;
                                                                                                int n12;
                                                                                                this.bcIndex = this.bcIndex.add(4 - (n9 & 3));
                                                                                                int n11 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                                n7 = n9 + n11;
                                                                                                int n14 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                this.bcIndex = this.bcIndex.add(4L);
                                                                                                if (n4 == 170) {
                                                                                                    int n15 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                                    n13 = n15 - n14 + 1;
                                                                                                    n6 = 0;
                                                                                                } else {
                                                                                                    n13 = n14;
                                                                                                    n6 = 4;
                                                                                                }
                                                                                                while (n13 > 0) {
                                                                                                    this.bcIndex = this.bcIndex.add(n6);
                                                                                                    n11 = new I32(MapHelpers.PARAM_32(this.bcIndex, 0)).intValue();
                                                                                                    this.bcIndex = this.bcIndex.add(4L);
                                                                                                    n12 = n9 + n11;
                                                                                                    if ((byArray[n12] & 1) == 0) {
                                                                                                        this.liveStack = this.pushStack(n12);
                                                                                                    }
                                                                                                    --n13;
                                                                                                }
                                                                                                this.bcIndex = this.bcStart.add(n7);
                                                                                                continue block7;
                                                                                            }
                                                                                            case 7: {
                                                                                                return -5;
                                                                                            }
                                                                                        }
                                                                                        this.bcIndex.add(n & 7);
                                                                                        continue;
                                                                                    }
                                                                                    if (n4 != 18 && n4 != 19) break block67;
                                                                                    n2 = n4 == 18 ? MapHelpers.PARAM_8(this.bcIndex, 1).intValue() : MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                                                                    if (j9ROMConstantPoolItemPointer.add(n2).slot2().longValue() != 0L) {
                                                                                        this.PUSH((byte)1);
                                                                                    } else {
                                                                                        this.PUSH((byte)0);
                                                                                    }
                                                                                    break block68;
                                                                                }
                                                                                if (n4 != 89) break block69;
                                                                                by = this.POP();
                                                                                this.PUSH(by);
                                                                                this.PUSH(by);
                                                                                break block68;
                                                                            }
                                                                            if (n4 != 90) break block70;
                                                                            by = this.POP();
                                                                            n6 = this.POP();
                                                                            this.PUSH(by);
                                                                            this.PUSH(n6);
                                                                            this.PUSH(by);
                                                                            break block68;
                                                                        }
                                                                        if (n4 != 91) break block71;
                                                                        by = this.POP();
                                                                        n6 = this.POP();
                                                                        n7 = this.POP();
                                                                        this.PUSH(by);
                                                                        this.PUSH(n7);
                                                                        this.PUSH(n6);
                                                                        this.PUSH(by);
                                                                        break block68;
                                                                    }
                                                                    if (n4 != 92) break block72;
                                                                    n6 = this.POP();
                                                                    n7 = this.POP();
                                                                    this.PUSH(n7);
                                                                    this.PUSH(n6);
                                                                    this.PUSH(n7);
                                                                    this.PUSH(n6);
                                                                    break block68;
                                                                }
                                                                if (n4 != 93) break block73;
                                                                by = this.POP();
                                                                n6 = this.POP();
                                                                n7 = this.POP();
                                                                this.PUSH(n6);
                                                                this.PUSH(by);
                                                                this.PUSH(n7);
                                                                this.PUSH(n6);
                                                                this.PUSH(by);
                                                                break block68;
                                                            }
                                                            if (n4 != 94) break block74;
                                                            by = this.POP();
                                                            n6 = this.POP();
                                                            n7 = this.POP();
                                                            byte by2 = this.POP();
                                                            this.PUSH(n6);
                                                            this.PUSH(by);
                                                            this.PUSH((int)by2);
                                                            this.PUSH(n7);
                                                            this.PUSH(n6);
                                                            this.PUSH(by);
                                                            break block68;
                                                        }
                                                        if (n4 != 95) break block75;
                                                        by = this.POP();
                                                        n6 = this.POP();
                                                        this.PUSH(by);
                                                        this.PUSH(n6);
                                                        break block68;
                                                    }
                                                    if (n4 != 180) break block76;
                                                    this.POP();
                                                    n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                                    j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                                                    c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                                                    if (c != 'L' && c != '[') break block77;
                                                    this.PUSH((byte)1);
                                                    break block68;
                                                }
                                                this.PUSH((byte)0);
                                                if (c != 'J' && c != 'D') break block68;
                                                this.PUSH((byte)0);
                                                break block68;
                                            }
                                            if (n4 != 178) break block78;
                                            n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                            j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                                            c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                                            if (c != 'L' && c != '[') break block79;
                                            this.PUSH((byte)1);
                                            break block68;
                                        }
                                        this.PUSH((byte)0);
                                        if (c != 'J' && c != 'D') break block68;
                                        this.PUSH((byte)0);
                                        break block68;
                                    }
                                    if (n4 != 181) break block80;
                                    this.POP();
                                    n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                    j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                                    c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                                    this.POP();
                                    if (c == 'D' || c == 'J') {
                                        this.POP();
                                    }
                                    break block68;
                                }
                                if (n4 != 179 && n4 != BCNames.JBwithfield) break block81;
                                n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                                j9UTF8Pointer = J9ROMFieldRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                                c = J9UTF8Helper.stringValue(j9UTF8Pointer).charAt(0);
                                this.POP();
                                if (c == 'D' || c == 'J') {
                                    this.POP();
                                }
                                break block68;
                            }
                            if (n4 == BCNames.JBinvokeinterface2) {
                                this.bcIndex = this.bcIndex.add(2L);
                                continue;
                            }
                            if (n4 != BCNames.JBinvokehandle && n4 != BCNames.JBinvokehandlegeneric && n4 != 182 && n4 != 183 && n4 != BCNames.JBinvokespecialsplit && n4 != 185) break block82;
                            this.POP();
                            n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                            if (n4 == BCNames.JBinvokestaticsplit) {
                                n2 = j9ROMClassPointer.staticSplitMethodRefIndexes().at(n2).intValue();
                            } else if (n4 == BCNames.JBinvokespecialsplit) {
                                n2 = j9ROMClassPointer.specialSplitMethodRefIndexes().at(n2).intValue();
                            }
                            j9UTF8Pointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                            char[] cArray = J9UTF8Helper.stringValue(j9UTF8Pointer).toCharArray();
                            n5 = 0;
                            n5 = 1;
                            while (cArray[n5] != ')') {
                                block84: {
                                    block83: {
                                        this.POP();
                                        if (cArray[n5] != '[') break block83;
                                        while (cArray[++n5] == '[') {
                                        }
                                        if (cArray[n5] != 'L') break block84;
                                    }
                                    if (cArray[n5] == 'L') {
                                        while (cArray[++n5] != ';') {
                                        }
                                    } else if (cArray[n5] == 'D' || cArray[n5] == 'J') {
                                        this.POP();
                                    }
                                }
                                ++n5;
                            }
                            c = cArray[n5 + 1];
                            if (c != 'V') {
                                if (c == 'L' || c == '[') {
                                    this.PUSH((byte)1);
                                } else {
                                    this.PUSH((byte)0);
                                    if (c == 'J' || c == 'D') {
                                        this.PUSH((byte)0);
                                    }
                                }
                            }
                            if (n4 != BCNames.JBinvokeinterface2) break block68;
                            this.bcIndex = this.bcIndex.sub(2L);
                            break block68;
                        }
                        if (n4 != 184 && n4 != BCNames.JBinvokestaticsplit) break block85;
                        n2 = MapHelpers.PARAM_16(this.bcIndex, 1).intValue();
                        if (n4 == BCNames.JBinvokestaticsplit) {
                            n2 = j9ROMClassPointer.staticSplitMethodRefIndexes().at(n2).intValue();
                        } else if (n4 == BCNames.JBinvokespecialsplit) {
                            n2 = j9ROMClassPointer.specialSplitMethodRefIndexes().at(n2).intValue();
                        }
                        j9UTF8Pointer = J9ROMMethodRefPointer.cast(j9ROMConstantPoolItemPointer.add(n2)).nameAndSignature().signature();
                        char[] cArray = J9UTF8Helper.stringValue(j9UTF8Pointer).toCharArray();
                        n5 = 0;
                        n5 = 1;
                        while (cArray[n5] != ')') {
                            block87: {
                                block86: {
                                    this.POP();
                                    if (cArray[n5] != '[') break block86;
                                    while (cArray[++n5] == '[') {
                                    }
                                    if (cArray[n5] != 'L') break block87;
                                }
                                if (cArray[n5] == 'L') {
                                    while (cArray[++n5] != ';') {
                                    }
                                } else if (cArray[n5] == 'D' || cArray[n5] == 'J') {
                                    this.POP();
                                }
                            }
                            ++n5;
                        }
                        c = cArray[n5 + 1];
                        if (c != 'V') {
                            if (c == 'L' || c == '[') {
                                this.PUSH((byte)1);
                            } else {
                                this.PUSH((byte)0);
                                if (c == 'J' || c == 'D') {
                                    this.PUSH((byte)0);
                                }
                            }
                        }
                        if (n4 != BCNames.JBinvokeinterface2) break block68;
                        this.bcIndex = this.bcIndex.sub(2L);
                        break block68;
                    }
                    if (n4 == 197) {
                        n2 = MapHelpers.PARAM_8(this.bcIndex, 3).intValue();
                        for (n3 = 0; n3 < n2; ++n3) {
                            this.POP();
                        }
                        this.PUSH((byte)1);
                        break;
                    }
                }
                this.bcIndex = this.bcIndex.add(n & 7);
            }
            return -5;
        }

        private J9MappingStack pushStack(int n) {
            logger.logp(Level.FINEST, "StackMap_V1", "pushStack", "pushStack");
            this.liveStack.pc = n;
            this.branchStack.push(this.liveStack);
            this.liveStack = new J9MappingStack(this.liveStack);
            return this.liveStack;
        }

        private void popStack() {
            logger.logp(Level.FINEST, "StackMap_V1", "popStack", "popStack");
            this.liveStack = this.branchStack.pop();
            this.bcIndex = this.bcStart.add(this.liveStack.pc);
        }

        private int nextRoot() throws CorruptDataException {
            if (this.liveStack == this.startStack) {
                if (this.exceptionsToWalk != 0) {
                    J9ExceptionHandlerPointer j9ExceptionHandlerPointer = ROMHelp.J9EXCEPTIONINFO_HANDLERS(this.exceptionData);
                    this.liveStack.reset();
                    this.PUSH((byte)1);
                    while (this.exceptionsToWalk > 0) {
                        this.pushStack(j9ExceptionHandlerPointer.add(--this.exceptionsToWalk).handlerPC().intValue());
                    }
                } else {
                    return -5;
                }
            }
            this.popStack();
            return 0;
        }

        public byte POP() throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "POP", "POP()");
            return this.liveStack.POP();
        }

        private void PUSH(int n) throws CorruptDataException {
            this.PUSH((byte)n);
        }

        public void PUSH(byte by) throws CorruptDataException {
            logger.logp(Level.FINEST, "StackMap_V1", "PUSH", "PUSH({0})", by);
            this.liveStack.PUSH(by);
        }

        private int outputStackMap(int[] nArray, int n) throws CorruptDataException {
            int n2 = this.resultStack.stackSize();
            if (n2 > 0 && nArray != null) {
                for (int i = 0; i < n2 - n; ++i) {
                    this.resultStack.POP();
                }
                int n3 = n - 1 >> 5;
                nArray[n3] = 0;
                while (true) {
                    int n4 = n3;
                    nArray[n4] = nArray[n4] << 1;
                    if (this.resultStack.POP() == 1) {
                        int n5 = n3;
                        nArray[n5] = nArray[n5] | 1;
                    }
                    if (--n == 0) break;
                    if ((n & 0x1F) != 0) continue;
                    nArray[++n3] = 0;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("outputStackMap. bits = ");
                stringBuffer.append(n);
                stringBuffer.append(" resultsArray size = " + nArray.length);
                stringBuffer.append(" result: ");
                for (int i = 0; i < nArray.length; ++i) {
                    stringBuffer.append(Integer.toHexString(nArray[i]));
                }
                logger.logp(Level.FINE, "StackMap_V1", "outputStackMap", stringBuffer.toString());
            }
            return n2;
        }
    }

    private static class J9MappingStack {
        public int pc;
        private int topOfStack = 0;
        private byte[] stack;

        public J9MappingStack(int n) {
            this.stack = new byte[n];
        }

        public J9MappingStack(J9MappingStack j9MappingStack) {
            this.stack = new byte[j9MappingStack.stack.length];
            System.arraycopy(j9MappingStack.stack, 0, this.stack, 0, j9MappingStack.topOfStack);
            this.topOfStack = j9MappingStack.topOfStack;
        }

        public void PUSH(byte by) throws CorruptDataException {
            if (this.topOfStack >= this.stack.length) {
                throw new CorruptDataException("Operand stack overflow. Stack size = " + this.stack.length + ", top of stack " + this.topOfStack);
            }
            this.stack[this.topOfStack++] = by;
        }

        public byte POP() throws CorruptDataException {
            if (this.topOfStack == 0) {
                throw new CorruptDataException("Operand stack underflow in StackMap");
            }
            return this.stack[--this.topOfStack];
        }

        public void reset() {
            this.topOfStack = 0;
        }

        public int stackSize() {
            return this.topOfStack;
        }
    }

    private static interface IStackMap {
        public int j9stackmap_StackBitsForPC(UDATA var1, J9ROMClassPointer var2, J9ROMMethodPointer var3, int[] var4, int var5) throws CorruptDataException;
    }
}

