/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.Pointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

public class ObjectClassReferencePointer
extends Pointer {
    public static final ObjectClassReferencePointer NULL = new ObjectClassReferencePointer(0L);
    public static final long SIZEOF = J9BuildFlags.gc_compressedPointers ? 4L : (long)UDATA.SIZEOF;

    protected ObjectClassReferencePointer(long l) {
        super(l);
    }

    public static ObjectClassReferencePointer cast(AbstractPointer abstractPointer) {
        return ObjectClassReferencePointer.cast(abstractPointer.getAddress());
    }

    public static ObjectClassReferencePointer cast(UDATA uDATA) {
        return ObjectClassReferencePointer.cast(uDATA.longValue());
    }

    public static ObjectClassReferencePointer cast(long l) {
        if (l == 0L) {
            return NULL;
        }
        return new ObjectClassReferencePointer(l);
    }

    @Override
    public ObjectClassReferencePointer add(long l) {
        return new ObjectClassReferencePointer(this.address + SIZEOF * l);
    }

    @Override
    public ObjectClassReferencePointer add(Scalar scalar) {
        return this.add(scalar.longValue());
    }

    @Override
    public ObjectClassReferencePointer addOffset(long l) {
        return new ObjectClassReferencePointer(this.address + l);
    }

    @Override
    public ObjectClassReferencePointer addOffset(Scalar scalar) {
        return this.addOffset(scalar.longValue());
    }

    @Override
    public J9ClassPointer at(long l) throws CorruptDataException {
        if (J9BuildFlags.gc_compressedPointers) {
            return J9ClassPointer.cast(0xFFFFFFFFL & (long)this.getIntAtOffset(l * SIZEOF));
        }
        return J9ClassPointer.cast(this.getUDATAAtOffset(SIZEOF * l));
    }

    @Override
    public J9ClassPointer at(Scalar scalar) throws CorruptDataException {
        return this.at(scalar.longValue());
    }

    @Override
    protected long sizeOfBaseType() {
        return SIZEOF;
    }

    @Override
    public ObjectClassReferencePointer sub(long l) {
        return new ObjectClassReferencePointer(this.address - SIZEOF * l);
    }

    @Override
    public ObjectClassReferencePointer sub(Scalar scalar) {
        return this.sub(scalar.longValue());
    }

    @Override
    public ObjectClassReferencePointer subOffset(long l) {
        return new ObjectClassReferencePointer(this.address - l);
    }

    @Override
    public ObjectClassReferencePointer subOffset(Scalar scalar) {
        return this.subOffset(scalar.longValue());
    }

    @Override
    public ObjectClassReferencePointer untag(long l) {
        return new ObjectClassReferencePointer(this.address & (l ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ObjectClassReferencePointer untag() {
        return this.untag(SIZEOF - 1L);
    }
}

