/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.gc.GCJNIWeakGlobalReferenceIterator;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckJNIWeakGlobalReferences
extends Check {
    CheckJNIWeakGlobalReferences() {
    }

    @Override
    public void check() {
        try {
            VoidPointer voidPointer = VoidPointer.cast(this.getJavaVM().jniWeakGlobalReferences());
            GCJNIWeakGlobalReferenceIterator gCJNIWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
            while (gCJNIWeakGlobalReferenceIterator.hasNext()) {
                PointerPointer pointerPointer = PointerPointer.cast(gCJNIWeakGlobalReferenceIterator.nextAddress());
                if (!pointerPointer.notNull() || this._engine.checkSlotPool(pointerPointer, voidPointer) == 0) continue;
                return;
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    @Override
    public String getCheckName() {
        return "JNI WEAK GLOBAL REFS";
    }

    @Override
    public void print() {
        try {
            VoidPointer voidPointer = VoidPointer.cast(this.getJavaVM().jniWeakGlobalReferences());
            GCJNIWeakGlobalReferenceIterator gCJNIWeakGlobalReferenceIterator = GCJNIWeakGlobalReferenceIterator.from();
            ScanFormatter scanFormatter = new ScanFormatter(this, "jniWeakGlobalReferences", voidPointer);
            while (gCJNIWeakGlobalReferenceIterator.hasNext()) {
                J9ObjectPointer j9ObjectPointer = gCJNIWeakGlobalReferenceIterator.next();
                if (!j9ObjectPointer.notNull()) continue;
                scanFormatter.entry(j9ObjectPointer);
            }
            scanFormatter.end("jniWeakGlobalReferences", voidPointer);
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

