/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.IBootstrapRunnable;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckCycle;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckEngine;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporterTTY;
import java.io.PrintStream;
import java.util.List;

public class GCCheckRunner
implements IBootstrapRunnable {
    @Override
    public void run(IVMData iVMData, Object[] objectArray) {
        List list = (List)objectArray[0];
        String[] stringArray = list.toArray(new String[list.size()]);
        try {
            J9JavaVMPointer j9JavaVMPointer = J9RASHelper.getVM(DataType.getJ9RASPointer());
            GCCheckRunner.run(j9JavaVMPointer, stringArray, System.out);
        }
        catch (CorruptDataException corruptDataException) {
            corruptDataException.printStackTrace();
        }
    }

    public static void run(J9JavaVMPointer j9JavaVMPointer, String[] stringArray, PrintStream printStream) throws CorruptDataException {
        String string = stringArray.length > 0 ? stringArray[0] : "";
        CheckReporterTTY checkReporterTTY = new CheckReporterTTY(printStream);
        CheckEngine checkEngine = new CheckEngine(j9JavaVMPointer, checkReporterTTY);
        CheckCycle checkCycle = new CheckCycle(j9JavaVMPointer, checkEngine, string);
        printStream.println("Starting GC Check");
        long l = System.currentTimeMillis();
        checkCycle.run();
        long l2 = System.currentTimeMillis();
        printStream.println("Done (" + (l2 - l) + "ms)");
    }
}

