/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.view.dtfj.java;

import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import com.ibm.j9ddr.view.dtfj.java.helper.DTFJJavaFieldHelper;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.view.dtfj.DTFJContext;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaClass;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaField;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaObject;
import com.ibm.j9ddr.vm29.view.dtfj.java.DTFJJavaRuntime;
import java.util.Iterator;

public class DTFJJavaFieldInstance
extends DTFJJavaField {
    public DTFJJavaFieldInstance(DTFJJavaClass dTFJJavaClass, J9ObjectFieldOffset j9ObjectFieldOffset) throws CorruptDataException {
        super(dTFJJavaClass, j9ObjectFieldOffset);
    }

    public Object get(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            switch (this.getSigFlag()) {
                case 'Z': {
                    return this.getBoolean(javaObject);
                }
                case 'B': {
                    return this.getByte(javaObject);
                }
                case 'C': {
                    return Character.valueOf(this.getChar(javaObject));
                }
                case 'S': {
                    return this.getShort(javaObject);
                }
                case 'I': {
                    return this.getInt(javaObject);
                }
                case 'F': {
                    return new Float(this.getFloat(javaObject));
                }
                case 'J': {
                    return this.getLong(javaObject);
                }
                case 'D': {
                    return new Double(this.getDouble(javaObject));
                }
                case 'L': 
                case '[': {
                    J9ROMFieldShapePointer j9ROMFieldShapePointer = this.fieldOffset.getField();
                    DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
                    this.checkDataTypeConversion(dTFJJavaObject, 768);
                    J9ObjectPointer j9ObjectPointer = J9ObjectHelper.getObjectField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
                    if (j9ObjectPointer.isNull()) {
                        return null;
                    }
                    return new DTFJJavaObject(null, j9ObjectPointer);
                }
            }
            throw new IllegalArgumentException("Cannot determine the correct data type");
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    private JavaClass _findClassForName(String string) throws com.ibm.dtfj.image.CorruptDataException {
        DTFJJavaRuntime dTFJJavaRuntime = DTFJContext.getRuntime();
        Iterator iterator = dTFJJavaRuntime.getJavaClassLoaders();
        JavaClass javaClass = null;
        block0: while (iterator.hasNext() && null == javaClass) {
            JavaClassLoader javaClassLoader = (JavaClassLoader)iterator.next();
            Iterator iterator2 = javaClassLoader.getDefinedClasses();
            while (iterator2.hasNext() && null == javaClass) {
                JavaClass javaClass2 = (JavaClass)iterator2.next();
                if (!javaClass2.getName().equals(string)) continue;
                javaClass = javaClass2;
                continue block0;
            }
        }
        return javaClass;
    }

    public boolean getBoolean(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            this.checkDataTypeConversion(dTFJJavaObject, 1);
            boolean bl = J9ObjectHelper.getBooleanField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
            return bl;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public byte getByte(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 2);
            return (byte)l;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public char getChar(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            this.checkDataTypeConversion(dTFJJavaObject, 8);
            char c = J9ObjectHelper.getCharField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
            return c;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public double getDouble(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 254);
            return Double.longBitsToDouble(l);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public float getFloat(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 126);
            return Float.intBitsToFloat((int)l);
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public int getInt(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 30);
            return (int)l;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public long getLong(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 94);
            return l;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public short getShort(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            long l = this.checkDataTypeConversion(dTFJJavaObject, 6);
            return (short)l;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public String getString(JavaObject javaObject) throws com.ibm.dtfj.image.CorruptDataException, MemoryAccessException {
        if (null == javaObject) {
            throw new NullPointerException("JavaObject is null");
        }
        if (!DTFJJavaFieldHelper.fieldIsString(this)) {
            throw new IllegalArgumentException("JavaField.getString() called on non-String field.");
        }
        try {
            DTFJJavaObject dTFJJavaObject = this.validateJavaObject(javaObject);
            this.checkDataTypeConversion(dTFJJavaObject, 512);
            String string = J9ObjectHelper.getStringField(dTFJJavaObject.getJ9ObjectPointer(), this.fieldOffset);
            return string;
        }
        catch (Throwable throwable) {
            throw J9DDRDTFJUtils.handleAllButMemAccExAsCorruptDataException(DTFJContext.getProcess(), throwable, whitelist);
        }
    }

    public boolean isNestedPacked() {
        return false;
    }

    public boolean isNestedPackedArray() {
        return false;
    }

    public int getPackedLengthAnnotationValue() {
        return 0;
    }
}

