/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SampleTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static Font defaultFont;
    protected static ImageIcon collapsedIcon;
    protected static ImageIcon expandedIcon;
    protected static final Color SELECTED_BACKGROUND_COLOR;
    protected boolean selected;

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setText(string);
        this.setToolTipText(string);
        if (bl2) {
            this.setIcon(expandedIcon);
        } else if (!bl3) {
            this.setIcon(collapsedIcon);
        } else {
            this.setIcon(null);
        }
        SampleData sampleData = (SampleData)((DefaultMutableTreeNode)object).getUserObject();
        if (bl4) {
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setForeground(sampleData.getColor());
        }
        if (sampleData.getFont() == null) {
            this.setFont(defaultFont);
        } else {
            this.setFont(sampleData.getFont());
        }
        this.selected = bl;
        return this;
    }

    @Override
    public void paint(Graphics graphics) {
        Icon icon = this.getIcon();
        Color color = this.selected ? SELECTED_BACKGROUND_COLOR : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        graphics.setColor(color);
        if (icon != null && this.getText() != null) {
            int n = icon.getIconWidth() + this.getIconTextGap();
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            } else {
                graphics.fillRect(0, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
            }
        } else {
            graphics.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(graphics);
    }

    static {
        SELECTED_BACKGROUND_COLOR = "Nimbus".equals(UIManager.getLookAndFeel().getName()) ? new Color(0, 0, 0, 0) : Color.YELLOW;
        try {
            defaultFont = new Font("SansSerif", 0, 12);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            collapsedIcon = new ImageIcon(SampleTreeCellRenderer.class.getResource("/resources/images/collapsed.gif"));
            expandedIcon = new ImageIcon(SampleTreeCellRenderer.class.getResource("/resources/images/expanded.gif"));
        }
        catch (Exception exception) {
            System.out.println("Couldn't load images: " + exception);
        }
    }
}

