/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.List;

class InputFile
extends ProgramOption {
    List inputFiles = new LinkedList();

    InputFile() {
    }

    @Override
    String getDescription() {
        return "The binary trace file generated by IBM JVMs. For multi-generational trace files specify the file pattern instead. This option is required";
    }

    @Override
    String getName() {
        return "input_file";
    }

    @Override
    Object getValue() {
        return this.inputFiles;
    }

    @Override
    boolean required() {
        return true;
    }

    @Override
    void setDefault() {
        if (ProgramOption.AnonymousArgs.isEmpty()) {
            throw new IllegalArgumentException("An input file must be specified");
        }
        this.setValue((String)ProgramOption.AnonymousArgs.get(0));
    }

    @Override
    void setValue(String string) throws IllegalArgumentException {
        try {
            this.inputFiles.add(new RandomAccessFile(string, "r"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl = false;
            String string2 = string;
            if (string.indexOf(35) != -1) {
                throw new IllegalArgumentException("Support for generational files has been removed until file level sorting is implemented");
            }
            throw new IllegalArgumentException("The file \"" + string + "\" specified as the input file could not be found");
        }
    }
}

