/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaJitTarget;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaJitOptions
implements Cloneable {
    private static final int NUM_OPT_CODES = 15;
    private static final int OPT_CACHE_MODE = 14;
    private static final int OPT_ERROR_LOG_BUFFER_SIZE_BYTES = 6;
    private static final int OPT_FALLBACK_STRATEGY = 10;
    private static final int OPT_GENERATE_DEBUG_INFO = 11;
    private static final int OPT_GENERATE_LINE_INFO = 13;
    private static final int OPT_INFO_LOG_BUFFER_SIZE_BYTES = 4;
    private static final int OPT_LOG_VERBOSE = 12;
    private static final int OPT_MAX_REGISTERS = 0;
    private static final int OPT_OPTIMIZATION_LEVEL = 7;
    private static final int OPT_TARGET = 9;
    private static final int OPT_TARGET_FROM_CUCONTEXT = 8;
    private static final int OPT_THREADS_PER_BLOCK = 1;
    private static final int OPT_WALL_TIME = 2;
    private String errorLogBuffer = "";
    private String infoLogBuffer = "";
    private final AtomicLong nativeHandle = new AtomicLong();
    private int optionMask = 0;
    private final int[] optionValue = new int[15];
    private int threadsPerBlock = 0;
    private float wallTime = 0.0f;

    private static native long create(int[] var0) throws CudaException;

    private static native void destroy(long var0);

    private static native String getErrorLogBuffer(long var0);

    private static native String getInfoLogBuffer(long var0);

    private static native int getThreadsPerBlock(long var0);

    private static native float getWallTime(long var0);

    protected CudaJitOptions clone() {
        CudaJitOptions cudaJitOptions = new CudaJitOptions();
        cudaJitOptions.optionMask = this.optionMask;
        System.arraycopy((Object)this.optionValue, 0, (Object)cudaJitOptions.optionValue, 0, 15);
        return cudaJitOptions;
    }

    public String getErrorLogBuffer() {
        return this.errorLogBuffer;
    }

    long getHandle() throws CudaException {
        long l;
        while ((l = this.nativeHandle.get()) == 0L) {
            int n;
            int[] nArray = new int[Integer.bitCount(n) << 1];
            int n2 = 0;
            int n3 = 0;
            for (n = this.optionMask; n != 0; n >>= 1) {
                if ((n & 1) != 0) {
                    nArray[n2++] = n3;
                    nArray[n2++] = this.optionValue[n3];
                }
                ++n3;
            }
            l = CudaJitOptions.create(nArray);
            if (this.nativeHandle.compareAndSet(0L, l)) break;
            CudaJitOptions.destroy(l);
        }
        return l;
    }

    public String getInfoLogBuffer() {
        return this.infoLogBuffer;
    }

    public int getThreadsPerBlock() {
        return this.threadsPerBlock;
    }

    public float getWallTime() {
        return this.wallTime;
    }

    public CudaJitOptions recordWallTime() {
        return this.setOption(2, true);
    }

    void releaseHandle(boolean bl) {
        long l = this.nativeHandle.getAndSet(0L);
        if (l != 0L) {
            if (bl) {
                this.update(l);
            }
            CudaJitOptions.destroy(l);
        }
    }

    public CudaJitOptions setCacheMode(CacheMode cacheMode) {
        if (cacheMode == null) {
            cacheMode = CacheMode.DEFAULT;
        }
        return this.setOption(14, cacheMode.nativeMode);
    }

    public CudaJitOptions setErrorLogBufferSize(int n) {
        return this.setOption(6, n);
    }

    public CudaJitOptions setGenerateDebugInfo(boolean bl) {
        return this.setOption(11, bl);
    }

    public CudaJitOptions setGenerateLineInfo(boolean bl) {
        return this.setOption(13, bl);
    }

    public CudaJitOptions setInfoLogBufferSize(int n) {
        return this.setOption(4, n);
    }

    public CudaJitOptions setJitFallbackStrategy(Fallback fallback) {
        if (fallback == null) {
            fallback = Fallback.PreferPtx;
        }
        return this.setOption(10, fallback.nativeStrategy);
    }

    public CudaJitOptions setLogVerbose(boolean bl) {
        return this.setOption(12, bl);
    }

    public CudaJitOptions setMaxRegisters(int n) {
        return this.setOption(0, n);
    }

    public CudaJitOptions setOptimizationLevel(int n) {
        return this.setOption(7, n);
    }

    private CudaJitOptions setOption(int n, boolean bl) {
        return this.setOption(n, bl ? 1 : 0);
    }

    private CudaJitOptions setOption(int n, int n2) {
        this.releaseHandle(false);
        this.optionMask |= 1 << n;
        this.optionValue[n] = n2;
        return this;
    }

    public CudaJitOptions setTarget(CudaJitTarget cudaJitTarget) {
        return this.setOption(9, cudaJitTarget.nativeValue);
    }

    public CudaJitOptions setTargetFromCuContext() {
        return this.setOption(8, true);
    }

    public CudaJitOptions setThreadsPerBlock(int n) {
        return this.setOption(1, n);
    }

    CudaJitOptions update() {
        long l = this.nativeHandle.get();
        if (l != 0L) {
            this.update(l);
        }
        return this;
    }

    private void update(long l) {
        this.errorLogBuffer = CudaJitOptions.getErrorLogBuffer(l);
        this.infoLogBuffer = CudaJitOptions.getInfoLogBuffer(l);
        this.threadsPerBlock = CudaJitOptions.getThreadsPerBlock(l);
        this.wallTime = CudaJitOptions.getWallTime(l);
    }

    public static enum Fallback {
        PreferBinary(1),
        PreferPtx(2);

        final int nativeStrategy;

        private Fallback(int n2) {
            this.nativeStrategy = n2;
        }
    }

    public static enum CacheMode {
        DEFAULT(1),
        L1_DISABLED(2),
        L1_ENABLED(3);

        final int nativeMode;

        private CacheMode(int n2) {
            this.nativeMode = n2;
        }
    }
}

