/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaEvent;
import com.ibm.cuda.CudaException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaStream
implements AutoCloseable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_NON_BLOCKING = 1;
    final int deviceId;
    private final AtomicLong nativeHandle;

    private static native long create(int var0) throws CudaException;

    private static native long createWithPriority(int var0, int var1, int var2) throws CudaException;

    private static native void destroy(int var0, long var1) throws CudaException;

    private static native int getFlags(int var0, long var1) throws CudaException;

    private static native int getPriority(int var0, long var1) throws CudaException;

    private static native int query(int var0, long var1);

    private static native void synchronize(int var0, long var1) throws CudaException;

    private static native void waitFor(int var0, long var1, long var3) throws CudaException;

    public CudaStream(CudaDevice cudaDevice) throws CudaException {
        this.deviceId = cudaDevice.getDeviceId();
        this.nativeHandle = new AtomicLong(CudaStream.create(this.deviceId));
    }

    public CudaStream(CudaDevice cudaDevice, int n, int n2) throws CudaException {
        this.deviceId = cudaDevice.getDeviceId();
        this.nativeHandle = new AtomicLong(CudaStream.createWithPriority(this.deviceId, n, n2));
    }

    public void addCallback(Runnable runnable) throws CudaException {
        Objects.requireNonNull(runnable);
        CudaDevice.addCallback(this.deviceId, this.getHandle(), runnable);
    }

    @Override
    public void close() throws CudaException {
        long l = this.nativeHandle.getAndSet(0L);
        if (l != 0L) {
            CudaStream.destroy(this.deviceId, l);
        }
    }

    public int getFlags() throws CudaException {
        return CudaStream.getFlags(this.deviceId, this.getHandle());
    }

    long getHandle() {
        long l = this.nativeHandle.get();
        if (l == 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    public int getPriority() throws CudaException {
        return CudaStream.getPriority(this.deviceId, this.getHandle());
    }

    public int query() {
        return CudaStream.query(this.deviceId, this.getHandle());
    }

    public void synchronize() throws CudaException {
        CudaStream.synchronize(this.deviceId, this.getHandle());
    }

    public void waitFor(CudaEvent cudaEvent) throws CudaException {
        CudaStream.waitFor(this.deviceId, this.getHandle(), cudaEvent.getHandle());
    }
}

