/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lang.management;

import com.ibm.lang.management.internal.MemoryUsageUtil;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public class MemoryUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long total;
    private long free;
    private long swapTotal;
    private long swapFree;
    private long cached;
    private long buffered;
    private long timestamp;

    public MemoryUsage() {
    }

    private MemoryUsage(long l, long l2, long l3, long l4, long l5, long l6, long l7) throws IllegalArgumentException {
        if (l < 0L || l2 < 0L || l7 < 0L || l3 < 0L && l3 != -1L || l4 < 0L && l4 != -1L || l5 < 0L && l5 != -1L || l6 < 0L && l6 != -1L || l2 >= 0L && l >= 0L && l2 > l || l4 >= 0L && l3 >= 0L && l4 > l3 || l >= 0L && l5 >= 0L && l6 >= 0L && l2 >= 0L && l < l5 + l6 + l2) {
            throw new IllegalArgumentException();
        }
        this.total = l;
        this.free = l2;
        this.swapTotal = l3;
        this.swapFree = l4;
        this.cached = l5;
        this.buffered = l6;
        this.timestamp = l7;
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public long getSwapTotal() {
        return this.swapTotal;
    }

    public long getSwapFree() {
        return this.swapFree;
    }

    public long getCached() {
        return this.cached;
    }

    public long getBuffered() {
        return this.buffered;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    void updateValues(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        this.total = l;
        this.free = l2;
        this.swapTotal = l3;
        this.swapFree = l4;
        this.cached = l5;
        this.buffered = l6;
        this.timestamp = l7;
    }

    public static MemoryUsage from(CompositeData compositeData) {
        MemoryUsage memoryUsage = null;
        if (null != compositeData) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            if (!MemoryUsageUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l7 = (Long)compositeData.get("total");
                l6 = (Long)compositeData.get("free");
                l5 = (Long)compositeData.get("swapTotal");
                l4 = (Long)compositeData.get("swapFree");
                l3 = (Long)compositeData.get("cached");
                l2 = (Long)compositeData.get("buffered");
                l = (Long)compositeData.get("timestamp");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            memoryUsage = new MemoryUsage(l7, l6, l5, l4, l3, l2, l);
        }
        return memoryUsage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n========== ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" ==========\n\n");
        stringBuilder.append("timestamp = ");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\n");
        stringBuilder.append("total = ");
        stringBuilder.append(this.total);
        stringBuilder.append("\n");
        stringBuilder.append("free = ");
        stringBuilder.append(this.free);
        stringBuilder.append("\n");
        stringBuilder.append("swapTotal = ");
        stringBuilder.append(this.swapTotal);
        stringBuilder.append("\n");
        stringBuilder.append("swapFree = ");
        stringBuilder.append(this.swapFree);
        stringBuilder.append("\n");
        stringBuilder.append("cached = ");
        stringBuilder.append(this.cached);
        stringBuilder.append("\n");
        stringBuilder.append("buffered = ");
        stringBuilder.append(this.buffered);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!(object instanceof MemoryUsage)) {
            return false;
        }
        MemoryUsage memoryUsage = (MemoryUsage)object;
        if (memoryUsage.getTotal() != this.getTotal()) {
            return false;
        }
        if (memoryUsage.getFree() != this.getFree()) {
            return false;
        }
        if (memoryUsage.getSwapTotal() != this.getSwapTotal()) {
            return false;
        }
        if (memoryUsage.getSwapFree() != this.getSwapFree()) {
            return false;
        }
        if (memoryUsage.getCached() != this.getCached()) {
            return false;
        }
        if (memoryUsage.getBuffered() != this.getBuffered()) {
            return false;
        }
        return memoryUsage.getTimestamp() == this.getTimestamp();
    }

    public int hashCode() {
        long l = this.getTotal() + this.getFree() + this.getSwapTotal() + this.getSwapFree() + this.getCached() + this.getBuffered() + this.getTimestamp();
        return (int)(((l >> 32) + l & 0xFFFFFFFL) * 23L);
    }
}

