/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.shared;

import com.ibm.oti.shared.SharedAbstractHelper;
import com.ibm.oti.shared.SharedDataHelper;
import com.ibm.oti.util.Msg;
import java.nio.ByteBuffer;

final class SharedDataHelperImpl
extends SharedAbstractHelper
implements SharedDataHelper {
    SharedDataHelperImpl(ClassLoader classLoader, int n, boolean bl, boolean bl2) {
        this.initialize(classLoader, n, bl, bl2);
    }

    private native ByteBuffer findSharedDataImpl(int var1, String var2);

    private native ByteBuffer storeSharedDataImpl(ClassLoader var1, int var2, String var3, ByteBuffer var4);

    @Override
    public ByteBuffer findSharedData(String string) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canFind) {
            return null;
        }
        if (!SharedDataHelperImpl.checkReadPermission(classLoader)) {
            this.printVerboseError(Msg.getString("K05b5"));
            return null;
        }
        if (string == null) {
            this.printVerboseError(Msg.getString("K05b6"));
            return null;
        }
        return this.findSharedDataImpl(this.id, string);
    }

    @Override
    public ByteBuffer storeSharedData(String string, ByteBuffer byteBuffer) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            this.printVerboseInfo(Msg.getString("K059f"));
            return null;
        }
        if (!this.canStore) {
            return null;
        }
        if (!SharedDataHelperImpl.checkWritePermission(classLoader)) {
            this.printVerboseError(Msg.getString("K05b7"));
            return null;
        }
        if (string == null) {
            this.printVerboseError(Msg.getString("K05b8"));
            return null;
        }
        if (byteBuffer != null && !byteBuffer.isDirect()) {
            this.printVerboseError(Msg.getString("K05b9"));
            return null;
        }
        return this.storeSharedDataImpl(classLoader, this.id, string, byteBuffer);
    }

    @Override
    String getHelperType() {
        return "SharedDataHelper";
    }
}

